# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFlavorsResult',
    'AwaitableGetFlavorsResult',
    'get_flavors',
    'get_flavors_output',
]

@pulumi.output_type
class GetFlavorsResult:
    """
    A collection of values returned by getFlavors.
    """
    def __init__(__self__, engine_name=None, flavors=None, id=None, memory=None, region=None, type=None, vcpus=None):
        if engine_name and not isinstance(engine_name, str):
            raise TypeError("Expected argument 'engine_name' to be a str")
        pulumi.set(__self__, "engine_name", engine_name)
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if memory and not isinstance(memory, str):
            raise TypeError("Expected argument 'memory' to be a str")
        pulumi.set(__self__, "memory", memory)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vcpus and not isinstance(vcpus, str):
            raise TypeError("Expected argument 'vcpus' to be a str")
        pulumi.set(__self__, "vcpus", vcpus)

    @_builtins.property
    @pulumi.getter(name="engineName")
    def engine_name(self) -> _builtins.str:
        return pulumi.get(self, "engine_name")

    @_builtins.property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetFlavorsFlavorResult']:
        """
        Indicates the flavors information. Structure is documented below.
        """
        return pulumi.get(self, "flavors")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.str]:
        """
        See 'memory' above.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        See `type` above.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def vcpus(self) -> Optional[_builtins.str]:
        """
        See `vcpus` above.
        """
        return pulumi.get(self, "vcpus")


class AwaitableGetFlavorsResult(GetFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlavorsResult(
            engine_name=self.engine_name,
            flavors=self.flavors,
            id=self.id,
            memory=self.memory,
            region=self.region,
            type=self.type,
            vcpus=self.vcpus)


def get_flavors(engine_name: Optional[_builtins.str] = None,
                memory: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                type: Optional[_builtins.str] = None,
                vcpus: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlavorsResult:
    """
    Use this data source to get the ID of an available SberCloud dds flavor.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    flavor = sbercloud.Dds.get_flavors(engine_name="DDS-Community",
        vcpus="8")
    ```


    :param _builtins.str engine_name: Specifies the engine name of the dds, "DDS-Community" and "DDS-Enhanced" are supported.
    :param _builtins.str memory: Specifies the ram of the dds flavor in GB.
    :param _builtins.str region: Specifies the region in which to obtain the V3 dds client. If omitted, the provider-level region will be used.
    :param _builtins.str type: Specifies the type of the dds falvor. "mongos", "shard", "config", "replica" and "single" are supported.
    :param _builtins.str vcpus: Specifies the vcpus of the dds flavor.
    """
    __args__ = dict()
    __args__['engineName'] = engine_name
    __args__['memory'] = memory
    __args__['region'] = region
    __args__['type'] = type
    __args__['vcpus'] = vcpus
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Dds/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult).value

    return AwaitableGetFlavorsResult(
        engine_name=pulumi.get(__ret__, 'engine_name'),
        flavors=pulumi.get(__ret__, 'flavors'),
        id=pulumi.get(__ret__, 'id'),
        memory=pulumi.get(__ret__, 'memory'),
        region=pulumi.get(__ret__, 'region'),
        type=pulumi.get(__ret__, 'type'),
        vcpus=pulumi.get(__ret__, 'vcpus'))
def get_flavors_output(engine_name: Optional[pulumi.Input[_builtins.str]] = None,
                       memory: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       vcpus: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlavorsResult]:
    """
    Use this data source to get the ID of an available SberCloud dds flavor.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    flavor = sbercloud.Dds.get_flavors(engine_name="DDS-Community",
        vcpus="8")
    ```


    :param _builtins.str engine_name: Specifies the engine name of the dds, "DDS-Community" and "DDS-Enhanced" are supported.
    :param _builtins.str memory: Specifies the ram of the dds flavor in GB.
    :param _builtins.str region: Specifies the region in which to obtain the V3 dds client. If omitted, the provider-level region will be used.
    :param _builtins.str type: Specifies the type of the dds falvor. "mongos", "shard", "config", "replica" and "single" are supported.
    :param _builtins.str vcpus: Specifies the vcpus of the dds flavor.
    """
    __args__ = dict()
    __args__['engineName'] = engine_name
    __args__['memory'] = memory
    __args__['region'] = region
    __args__['type'] = type
    __args__['vcpus'] = vcpus
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Dds/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult)
    return __ret__.apply(lambda __response__: GetFlavorsResult(
        engine_name=pulumi.get(__response__, 'engine_name'),
        flavors=pulumi.get(__response__, 'flavors'),
        id=pulumi.get(__response__, 'id'),
        memory=pulumi.get(__response__, 'memory'),
        region=pulumi.get(__response__, 'region'),
        type=pulumi.get(__response__, 'type'),
        vcpus=pulumi.get(__response__, 'vcpus')))
