# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[_builtins.str],
                 datastore: pulumi.Input['InstanceDatastoreArgs'],
                 flavors: pulumi.Input[Sequence[pulumi.Input['InstanceFlavorArgs']]],
                 mode: pulumi.Input[_builtins.str],
                 security_group_id: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_strategy: Optional[pulumi.Input['InstanceBackupStrategyArgs']] = None,
                 balancer_active_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 balancer_active_end: Optional[pulumi.Input[_builtins.str]] = None,
                 balancer_status: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 client_network_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigurationArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 second_level_monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 slow_log_desensitization: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the ID of the availability zone. Changing this creates a
               new instance.
        :param pulumi.Input['InstanceDatastoreArgs'] datastore: Specifies database information. The structure is described below. Changing
               this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFlavorArgs']]] flavors: Specifies the flavors information. The structure is described below. Changing
               this creates a new instance.
        :param pulumi.Input[_builtins.str] mode: Specifies the mode of the database instance. **Sharding**, **ReplicaSet**,
               **Single** are supported. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the security group ID of the DDS instance.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the subnet Network ID. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto-renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this creates a new instance.
        :param pulumi.Input['InstanceBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy. The structure is described below.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the instance.
               The valid values are as follows:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
               
               Default value is `postPaid`.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceConfigurationArgs']]] configurations: Specifies the configuration information.
               The structure is described below. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] disk_encryption_id: Specifies the disk encryption ID of the instance. Changing this
               creates a new instance.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the dds instance.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type is unique in the
               same tenant.
        :param pulumi.Input[_builtins.str] password: Specifies the Administrator password of the database instance.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.int] port: Specifies the database access port. The valid values are range from `2100` to `9500` and
               `27017`, `27018`, `27019`. Defaults to `8635`.
        :param pulumi.Input[_builtins.str] region: Specifies the region of the DDS instance. Changing this creates a new
               instance.
        :param pulumi.Input[_builtins.bool] ssl: Specifies whether to enable or disable SSL. Defaults to true.
               
               **NOTE:** The instance will be restarted in the background when switching SSL. Please operate with caution.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the DDS instance.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "datastore", datastore)
        pulumi.set(__self__, "flavors", flavors)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if balancer_active_begin is not None:
            pulumi.set(__self__, "balancer_active_begin", balancer_active_begin)
        if balancer_active_end is not None:
            pulumi.set(__self__, "balancer_active_end", balancer_active_end)
        if balancer_status is not None:
            pulumi.set(__self__, "balancer_status", balancer_status)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if client_network_ranges is not None:
            pulumi.set(__self__, "client_network_ranges", client_network_ranges)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_id is not None:
            pulumi.set(__self__, "disk_encryption_id", disk_encryption_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_set_name is not None:
            pulumi.set(__self__, "replica_set_name", replica_set_name)
        if second_level_monitoring_enabled is not None:
            pulumi.set(__self__, "second_level_monitoring_enabled", second_level_monitoring_enabled)
        if slow_log_desensitization is not None:
            pulumi.set(__self__, "slow_log_desensitization", slow_log_desensitization)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the availability zone. Changing this creates a
        new instance.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter
    def datastore(self) -> pulumi.Input['InstanceDatastoreArgs']:
        """
        Specifies database information. The structure is described below. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "datastore")

    @datastore.setter
    def datastore(self, value: pulumi.Input['InstanceDatastoreArgs']):
        pulumi.set(self, "datastore", value)

    @_builtins.property
    @pulumi.getter
    def flavors(self) -> pulumi.Input[Sequence[pulumi.Input['InstanceFlavorArgs']]]:
        """
        Specifies the flavors information. The structure is described below. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "flavors")

    @flavors.setter
    def flavors(self, value: pulumi.Input[Sequence[pulumi.Input['InstanceFlavorArgs']]]):
        pulumi.set(self, "flavors", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the mode of the database instance. **Sharding**, **ReplicaSet**,
        **Single** are supported. Changing this creates a new instance.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the security group ID of the DDS instance.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the subnet Network ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the VPC ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto-renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['InstanceBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy. The structure is described below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['InstanceBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @_builtins.property
    @pulumi.getter(name="balancerActiveBegin")
    def balancer_active_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "balancer_active_begin")

    @balancer_active_begin.setter
    def balancer_active_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "balancer_active_begin", value)

    @_builtins.property
    @pulumi.getter(name="balancerActiveEnd")
    def balancer_active_end(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "balancer_active_end")

    @balancer_active_end.setter
    def balancer_active_end(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "balancer_active_end", value)

    @_builtins.property
    @pulumi.getter(name="balancerStatus")
    def balancer_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "balancer_status")

    @balancer_status.setter
    def balancer_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "balancer_status", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the instance.
        The valid values are as follows:
        + `prePaid`: indicates the yearly/monthly billing mode.
        + `postPaid`: indicates the pay-per-use billing mode.

        Default value is `postPaid`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="clientNetworkRanges")
    def client_network_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "client_network_ranges")

    @client_network_ranges.setter
    def client_network_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "client_network_ranges", value)

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigurationArgs']]]]:
        """
        Specifies the configuration information.
        The structure is described below. Changing this creates a new instance.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionId")
    def disk_encryption_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the disk encryption ID of the instance. Changing this
        creates a new instance.
        """
        return pulumi.get(self, "disk_encryption_id")

    @disk_encryption_id.setter
    def disk_encryption_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_id", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the dds instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_begin", value)

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type is unique in the
        same tenant.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Administrator password of the database instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the database access port. The valid values are range from `2100` to `9500` and
        `27017`, `27018`, `27019`. Defaults to `8635`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region of the DDS instance. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicaSetName")
    def replica_set_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "replica_set_name")

    @replica_set_name.setter
    def replica_set_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replica_set_name", value)

    @_builtins.property
    @pulumi.getter(name="secondLevelMonitoringEnabled")
    def second_level_monitoring_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "second_level_monitoring_enabled")

    @second_level_monitoring_enabled.setter
    def second_level_monitoring_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "second_level_monitoring_enabled", value)

    @_builtins.property
    @pulumi.getter(name="slowLogDesensitization")
    def slow_log_desensitization(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "slow_log_desensitization")

    @slow_log_desensitization.setter
    def slow_log_desensitization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slow_log_desensitization", value)

    @_builtins.property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable or disable SSL. Defaults to true.

        **NOTE:** The instance will be restarted in the background when switching SSL. Please operate with caution.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the DDS instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_strategy: Optional[pulumi.Input['InstanceBackupStrategyArgs']] = None,
                 balancer_active_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 balancer_active_end: Optional[pulumi.Input[_builtins.str]] = None,
                 balancer_status: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 client_network_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigurationArgs']]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 datastore: Optional[pulumi.Input['InstanceDatastoreArgs']] = None,
                 db_username: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavors: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFlavorArgs']]]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupArgs']]]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 second_level_monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_log_desensitization: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto-renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the ID of the availability zone. Changing this creates a
               new instance.
        :param pulumi.Input['InstanceBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy. The structure is described below.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the instance.
               The valid values are as follows:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
               
               Default value is `postPaid`.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceConfigurationArgs']]] configurations: Specifies the configuration information.
               The structure is described below. Changing this creates a new instance.
        :param pulumi.Input['InstanceDatastoreArgs'] datastore: Specifies database information. The structure is described below. Changing
               this creates a new instance.
        :param pulumi.Input[_builtins.str] db_username: Indicates the DB Administator name.
        :param pulumi.Input[_builtins.str] disk_encryption_id: Specifies the disk encryption ID of the instance. Changing this
               creates a new instance.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the dds instance.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFlavorArgs']]] flavors: Specifies the flavors information. The structure is described below. Changing
               this creates a new instance.
        :param pulumi.Input[_builtins.str] mode: Specifies the mode of the database instance. **Sharding**, **ReplicaSet**,
               **Single** are supported. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type is unique in the
               same tenant.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]] nodes: Indicates the instance nodes information. Structure is documented below.
        :param pulumi.Input[_builtins.str] password: Specifies the Administrator password of the database instance.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.int] port: Specifies the database access port. The valid values are range from `2100` to `9500` and
               `27017`, `27018`, `27019`. Defaults to `8635`.
        :param pulumi.Input[_builtins.str] region: Specifies the region of the DDS instance. Changing this creates a new
               instance.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the security group ID of the DDS instance.
        :param pulumi.Input[_builtins.bool] ssl: Specifies whether to enable or disable SSL. Defaults to true.
               
               **NOTE:** The instance will be restarted in the background when switching SSL. Please operate with caution.
        :param pulumi.Input[_builtins.str] status: Indicates the node status.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the subnet Network ID. Changing this creates a new instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the DDS instance.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID. Changing this creates a new instance.
        """
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if balancer_active_begin is not None:
            pulumi.set(__self__, "balancer_active_begin", balancer_active_begin)
        if balancer_active_end is not None:
            pulumi.set(__self__, "balancer_active_end", balancer_active_end)
        if balancer_status is not None:
            pulumi.set(__self__, "balancer_status", balancer_status)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if client_network_ranges is not None:
            pulumi.set(__self__, "client_network_ranges", client_network_ranges)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if datastore is not None:
            pulumi.set(__self__, "datastore", datastore)
        if db_username is not None:
            pulumi.set(__self__, "db_username", db_username)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_encryption_id is not None:
            pulumi.set(__self__, "disk_encryption_id", disk_encryption_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavors is not None:
            pulumi.set(__self__, "flavors", flavors)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replica_set_name is not None:
            pulumi.set(__self__, "replica_set_name", replica_set_name)
        if second_level_monitoring_enabled is not None:
            pulumi.set(__self__, "second_level_monitoring_enabled", second_level_monitoring_enabled)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if slow_log_desensitization is not None:
            pulumi.set(__self__, "slow_log_desensitization", slow_log_desensitization)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto-renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the availability zone. Changing this creates a
        new instance.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['InstanceBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy. The structure is described below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['InstanceBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @_builtins.property
    @pulumi.getter(name="balancerActiveBegin")
    def balancer_active_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "balancer_active_begin")

    @balancer_active_begin.setter
    def balancer_active_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "balancer_active_begin", value)

    @_builtins.property
    @pulumi.getter(name="balancerActiveEnd")
    def balancer_active_end(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "balancer_active_end")

    @balancer_active_end.setter
    def balancer_active_end(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "balancer_active_end", value)

    @_builtins.property
    @pulumi.getter(name="balancerStatus")
    def balancer_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "balancer_status")

    @balancer_status.setter
    def balancer_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "balancer_status", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the instance.
        The valid values are as follows:
        + `prePaid`: indicates the yearly/monthly billing mode.
        + `postPaid`: indicates the pay-per-use billing mode.

        Default value is `postPaid`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="clientNetworkRanges")
    def client_network_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "client_network_ranges")

    @client_network_ranges.setter
    def client_network_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "client_network_ranges", value)

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigurationArgs']]]]:
        """
        Specifies the configuration information.
        The structure is described below. Changing this creates a new instance.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceConfigurationArgs']]]]):
        pulumi.set(self, "configurations", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def datastore(self) -> Optional[pulumi.Input['InstanceDatastoreArgs']]:
        """
        Specifies database information. The structure is described below. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "datastore")

    @datastore.setter
    def datastore(self, value: Optional[pulumi.Input['InstanceDatastoreArgs']]):
        pulumi.set(self, "datastore", value)

    @_builtins.property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the DB Administator name.
        """
        return pulumi.get(self, "db_username")

    @db_username.setter
    def db_username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "db_username", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionId")
    def disk_encryption_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the disk encryption ID of the instance. Changing this
        creates a new instance.
        """
        return pulumi.get(self, "disk_encryption_id")

    @disk_encryption_id.setter
    def disk_encryption_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_id", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the dds instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def flavors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFlavorArgs']]]]:
        """
        Specifies the flavors information. The structure is described below. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "flavors")

    @flavors.setter
    def flavors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFlavorArgs']]]]):
        pulumi.set(self, "flavors", value)

    @_builtins.property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupArgs']]]]:
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceGroupArgs']]]]):
        pulumi.set(self, "groups", value)

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_begin", value)

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end", value)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the mode of the database instance. **Sharding**, **ReplicaSet**,
        **Single** are supported. Changing this creates a new instance.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type is unique in the
        same tenant.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]]:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Administrator password of the database instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the database access port. The valid values are range from `2100` to `9500` and
        `27017`, `27018`, `27019`. Defaults to `8635`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region of the DDS instance. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="replicaSetName")
    def replica_set_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "replica_set_name")

    @replica_set_name.setter
    def replica_set_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replica_set_name", value)

    @_builtins.property
    @pulumi.getter(name="secondLevelMonitoringEnabled")
    def second_level_monitoring_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "second_level_monitoring_enabled")

    @second_level_monitoring_enabled.setter
    def second_level_monitoring_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "second_level_monitoring_enabled", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the security group ID of the DDS instance.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="slowLogDesensitization")
    def slow_log_desensitization(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "slow_log_desensitization")

    @slow_log_desensitization.setter
    def slow_log_desensitization(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "slow_log_desensitization", value)

    @_builtins.property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable or disable SSL. Defaults to true.

        **NOTE:** The instance will be restarted in the background when switching SSL. Please operate with caution.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the subnet Network ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the DDS instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_zone", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the VPC ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:Dds/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_strategy: Optional[pulumi.Input[Union['InstanceBackupStrategyArgs', 'InstanceBackupStrategyArgsDict']]] = None,
                 balancer_active_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 balancer_active_end: Optional[pulumi.Input[_builtins.str]] = None,
                 balancer_status: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 client_network_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigurationArgs', 'InstanceConfigurationArgsDict']]]]] = None,
                 datastore: Optional[pulumi.Input[Union['InstanceDatastoreArgs', 'InstanceDatastoreArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceFlavorArgs', 'InstanceFlavorArgsDict']]]]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 second_level_monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_log_desensitization: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages dds instance resource within SberCloud.

        ## Example Usage

        ### Creating A Cluster Community Edition

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        instance = sbercloud.dds.Instance("instance",
            name="dds-instance",
            datastore={
                "type": "DDS-Community",
                "version": "3.4",
                "storage_engine": "wiredTiger",
            },
            availability_zone="{{ availability_zone }}",
            vpc_id="{{ vpc_id }}",
            subnet_id="{{ subnet_network_id }}}",
            security_group_id="{{ security_group_id }}",
            password="Test@123",
            mode="Sharding",
            flavors=[
                {
                    "type": "mongos",
                    "num": 2,
                    "spec_code": "dds.mongodb.c3.medium.4.mongos",
                },
                {
                    "type": "shard",
                    "num": 2,
                    "storage": "ULTRAHIGH",
                    "size": 20,
                    "spec_code": "dds.mongodb.c3.medium.4.shard",
                },
                {
                    "type": "config",
                    "num": 1,
                    "storage": "ULTRAHIGH",
                    "size": 20,
                    "spec_code": "dds.mongodb.c3.large.2.config",
                },
            ],
            backup_strategy={
                "start_time": "08:00-09:00",
                "keep_days": 8,
            })
        ```

        ### Creating A Replica Set Community Edition

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        instance = sbercloud.dds.Instance("instance",
            name="dds-instance",
            datastore={
                "type": "DDS-Community",
                "version": "3.4",
                "storage_engine": "wiredTiger",
            },
            availability_zone="{{ availability_zone }}",
            vpc_id="{{ vpc_id }}",
            subnet_id="{{ subnet_network_id }}}",
            security_group_id="{{ security_group_id }}",
            password="Test@123",
            mode="ReplicaSet",
            flavors=[{
                "type": "replica",
                "num": 1,
                "storage": "ULTRAHIGH",
                "size": 30,
                "spec_code": "dds.mongodb.c6.2xlarge.4.repset",
            }])
        ```

        ### Creating A Single Community Edition

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        instance = sbercloud.dds.Instance("instance",
            name="dds-instance",
            datastore={
                "type": "DDS-Community",
                "version": "3.4",
                "storage_engine": "wiredTiger",
            },
            availability_zone="{{ availability_zone }}",
            vpc_id="{{ vpc_id }}",
            subnet_id="{{ subnet_network_id }}}",
            security_group_id="{{ security_group_id }}",
            password="Test@123",
            mode="Single",
            flavors=[{
                "type": "single",
                "num": 1,
                "storage": "ULTRAHIGH",
                "size": 30,
                "spec_code": "dds.mongodb.c6.2xlarge.4.repset",
            }])
        ```

        ## Import

        DDS instance can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Dds/instance:Instance instance 9c6d6ff2cba3434293fd479571517e16in02
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason.

        The missing attributes include: `password`, `availability_zone`, `flavor`, configuration.

        It is generally recommended running `pulumi preview` after importing an instance.

        You can then decide if changes should be applied to the instance, or the resource definition should be updated to

        align with the instance. Also you can ignore changes as below.

        resource "sbercloud_dds_instance" "instance" {

            ...

          lifecycle {

            ignore_changes = [
            
              password, availability_zone, flavor, configuration,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto-renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the ID of the availability zone. Changing this creates a
               new instance.
        :param pulumi.Input[Union['InstanceBackupStrategyArgs', 'InstanceBackupStrategyArgsDict']] backup_strategy: Specifies the advanced backup policy. The structure is described below.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the instance.
               The valid values are as follows:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
               
               Default value is `postPaid`.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigurationArgs', 'InstanceConfigurationArgsDict']]]] configurations: Specifies the configuration information.
               The structure is described below. Changing this creates a new instance.
        :param pulumi.Input[Union['InstanceDatastoreArgs', 'InstanceDatastoreArgsDict']] datastore: Specifies database information. The structure is described below. Changing
               this creates a new instance.
        :param pulumi.Input[_builtins.str] disk_encryption_id: Specifies the disk encryption ID of the instance. Changing this
               creates a new instance.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the dds instance.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceFlavorArgs', 'InstanceFlavorArgsDict']]]] flavors: Specifies the flavors information. The structure is described below. Changing
               this creates a new instance.
        :param pulumi.Input[_builtins.str] mode: Specifies the mode of the database instance. **Sharding**, **ReplicaSet**,
               **Single** are supported. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type is unique in the
               same tenant.
        :param pulumi.Input[_builtins.str] password: Specifies the Administrator password of the database instance.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.int] port: Specifies the database access port. The valid values are range from `2100` to `9500` and
               `27017`, `27018`, `27019`. Defaults to `8635`.
        :param pulumi.Input[_builtins.str] region: Specifies the region of the DDS instance. Changing this creates a new
               instance.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the security group ID of the DDS instance.
        :param pulumi.Input[_builtins.bool] ssl: Specifies whether to enable or disable SSL. Defaults to true.
               
               **NOTE:** The instance will be restarted in the background when switching SSL. Please operate with caution.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the subnet Network ID. Changing this creates a new instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the DDS instance.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID. Changing this creates a new instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages dds instance resource within SberCloud.

        ## Example Usage

        ### Creating A Cluster Community Edition

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        instance = sbercloud.dds.Instance("instance",
            name="dds-instance",
            datastore={
                "type": "DDS-Community",
                "version": "3.4",
                "storage_engine": "wiredTiger",
            },
            availability_zone="{{ availability_zone }}",
            vpc_id="{{ vpc_id }}",
            subnet_id="{{ subnet_network_id }}}",
            security_group_id="{{ security_group_id }}",
            password="Test@123",
            mode="Sharding",
            flavors=[
                {
                    "type": "mongos",
                    "num": 2,
                    "spec_code": "dds.mongodb.c3.medium.4.mongos",
                },
                {
                    "type": "shard",
                    "num": 2,
                    "storage": "ULTRAHIGH",
                    "size": 20,
                    "spec_code": "dds.mongodb.c3.medium.4.shard",
                },
                {
                    "type": "config",
                    "num": 1,
                    "storage": "ULTRAHIGH",
                    "size": 20,
                    "spec_code": "dds.mongodb.c3.large.2.config",
                },
            ],
            backup_strategy={
                "start_time": "08:00-09:00",
                "keep_days": 8,
            })
        ```

        ### Creating A Replica Set Community Edition

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        instance = sbercloud.dds.Instance("instance",
            name="dds-instance",
            datastore={
                "type": "DDS-Community",
                "version": "3.4",
                "storage_engine": "wiredTiger",
            },
            availability_zone="{{ availability_zone }}",
            vpc_id="{{ vpc_id }}",
            subnet_id="{{ subnet_network_id }}}",
            security_group_id="{{ security_group_id }}",
            password="Test@123",
            mode="ReplicaSet",
            flavors=[{
                "type": "replica",
                "num": 1,
                "storage": "ULTRAHIGH",
                "size": 30,
                "spec_code": "dds.mongodb.c6.2xlarge.4.repset",
            }])
        ```

        ### Creating A Single Community Edition

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        instance = sbercloud.dds.Instance("instance",
            name="dds-instance",
            datastore={
                "type": "DDS-Community",
                "version": "3.4",
                "storage_engine": "wiredTiger",
            },
            availability_zone="{{ availability_zone }}",
            vpc_id="{{ vpc_id }}",
            subnet_id="{{ subnet_network_id }}}",
            security_group_id="{{ security_group_id }}",
            password="Test@123",
            mode="Single",
            flavors=[{
                "type": "single",
                "num": 1,
                "storage": "ULTRAHIGH",
                "size": 30,
                "spec_code": "dds.mongodb.c6.2xlarge.4.repset",
            }])
        ```

        ## Import

        DDS instance can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Dds/instance:Instance instance 9c6d6ff2cba3434293fd479571517e16in02
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason.

        The missing attributes include: `password`, `availability_zone`, `flavor`, configuration.

        It is generally recommended running `pulumi preview` after importing an instance.

        You can then decide if changes should be applied to the instance, or the resource definition should be updated to

        align with the instance. Also you can ignore changes as below.

        resource "sbercloud_dds_instance" "instance" {

            ...

          lifecycle {

            ignore_changes = [
            
              password, availability_zone, flavor, configuration,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_strategy: Optional[pulumi.Input[Union['InstanceBackupStrategyArgs', 'InstanceBackupStrategyArgsDict']]] = None,
                 balancer_active_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 balancer_active_end: Optional[pulumi.Input[_builtins.str]] = None,
                 balancer_status: Optional[pulumi.Input[_builtins.str]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 client_network_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigurationArgs', 'InstanceConfigurationArgsDict']]]]] = None,
                 datastore: Optional[pulumi.Input[Union['InstanceDatastoreArgs', 'InstanceDatastoreArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceFlavorArgs', 'InstanceFlavorArgsDict']]]]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 mode: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replica_set_name: Optional[pulumi.Input[_builtins.str]] = None,
                 second_level_monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 slow_log_desensitization: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["backup_strategy"] = backup_strategy
            __props__.__dict__["balancer_active_begin"] = balancer_active_begin
            __props__.__dict__["balancer_active_end"] = balancer_active_end
            __props__.__dict__["balancer_status"] = balancer_status
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["client_network_ranges"] = client_network_ranges
            __props__.__dict__["configurations"] = configurations
            if datastore is None and not opts.urn:
                raise TypeError("Missing required property 'datastore'")
            __props__.__dict__["datastore"] = datastore
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_encryption_id"] = disk_encryption_id
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if flavors is None and not opts.urn:
                raise TypeError("Missing required property 'flavors'")
            __props__.__dict__["flavors"] = flavors
            __props__.__dict__["maintain_begin"] = maintain_begin
            __props__.__dict__["maintain_end"] = maintain_end
            if mode is None and not opts.urn:
                raise TypeError("Missing required property 'mode'")
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["port"] = port
            __props__.__dict__["region"] = region
            __props__.__dict__["replica_set_name"] = replica_set_name
            __props__.__dict__["second_level_monitoring_enabled"] = second_level_monitoring_enabled
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["slow_log_desensitization"] = slow_log_desensitization
            __props__.__dict__["ssl"] = ssl
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["db_username"] = None
            __props__.__dict__["groups"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["time_zone"] = None
            __props__.__dict__["updated_at"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'sbercloud:Dds/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            backup_strategy: Optional[pulumi.Input[Union['InstanceBackupStrategyArgs', 'InstanceBackupStrategyArgsDict']]] = None,
            balancer_active_begin: Optional[pulumi.Input[_builtins.str]] = None,
            balancer_active_end: Optional[pulumi.Input[_builtins.str]] = None,
            balancer_status: Optional[pulumi.Input[_builtins.str]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            client_network_ranges: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigurationArgs', 'InstanceConfigurationArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            datastore: Optional[pulumi.Input[Union['InstanceDatastoreArgs', 'InstanceDatastoreArgsDict']]] = None,
            db_username: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_encryption_id: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            flavors: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceFlavorArgs', 'InstanceFlavorArgsDict']]]]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceGroupArgs', 'InstanceGroupArgsDict']]]]] = None,
            maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
            mode: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNodeArgs', 'InstanceNodeArgsDict']]]]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replica_set_name: Optional[pulumi.Input[_builtins.str]] = None,
            second_level_monitoring_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            slow_log_desensitization: Optional[pulumi.Input[_builtins.str]] = None,
            ssl: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto-renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the ID of the availability zone. Changing this creates a
               new instance.
        :param pulumi.Input[Union['InstanceBackupStrategyArgs', 'InstanceBackupStrategyArgsDict']] backup_strategy: Specifies the advanced backup policy. The structure is described below.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the instance.
               The valid values are as follows:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
               
               Default value is `postPaid`.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceConfigurationArgs', 'InstanceConfigurationArgsDict']]]] configurations: Specifies the configuration information.
               The structure is described below. Changing this creates a new instance.
        :param pulumi.Input[Union['InstanceDatastoreArgs', 'InstanceDatastoreArgsDict']] datastore: Specifies database information. The structure is described below. Changing
               this creates a new instance.
        :param pulumi.Input[_builtins.str] db_username: Indicates the DB Administator name.
        :param pulumi.Input[_builtins.str] disk_encryption_id: Specifies the disk encryption ID of the instance. Changing this
               creates a new instance.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the dds instance.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceFlavorArgs', 'InstanceFlavorArgsDict']]]] flavors: Specifies the flavors information. The structure is described below. Changing
               this creates a new instance.
        :param pulumi.Input[_builtins.str] mode: Specifies the mode of the database instance. **Sharding**, **ReplicaSet**,
               **Single** are supported. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] name: Specifies the DB instance name. The DB instance name of the same type is unique in the
               same tenant.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceNodeArgs', 'InstanceNodeArgsDict']]]] nodes: Indicates the instance nodes information. Structure is documented below.
        :param pulumi.Input[_builtins.str] password: Specifies the Administrator password of the database instance.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.int] port: Specifies the database access port. The valid values are range from `2100` to `9500` and
               `27017`, `27018`, `27019`. Defaults to `8635`.
        :param pulumi.Input[_builtins.str] region: Specifies the region of the DDS instance. Changing this creates a new
               instance.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the security group ID of the DDS instance.
        :param pulumi.Input[_builtins.bool] ssl: Specifies whether to enable or disable SSL. Defaults to true.
               
               **NOTE:** The instance will be restarted in the background when switching SSL. Please operate with caution.
        :param pulumi.Input[_builtins.str] status: Indicates the node status.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the subnet Network ID. Changing this creates a new instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the DDS instance.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the VPC ID. Changing this creates a new instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["backup_strategy"] = backup_strategy
        __props__.__dict__["balancer_active_begin"] = balancer_active_begin
        __props__.__dict__["balancer_active_end"] = balancer_active_end
        __props__.__dict__["balancer_status"] = balancer_status
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["client_network_ranges"] = client_network_ranges
        __props__.__dict__["configurations"] = configurations
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["datastore"] = datastore
        __props__.__dict__["db_username"] = db_username
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_encryption_id"] = disk_encryption_id
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["flavors"] = flavors
        __props__.__dict__["groups"] = groups
        __props__.__dict__["maintain_begin"] = maintain_begin
        __props__.__dict__["maintain_end"] = maintain_end
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["port"] = port
        __props__.__dict__["region"] = region
        __props__.__dict__["replica_set_name"] = replica_set_name
        __props__.__dict__["second_level_monitoring_enabled"] = second_level_monitoring_enabled
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["slow_log_desensitization"] = slow_log_desensitization
        __props__.__dict__["ssl"] = ssl
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["vpc_id"] = vpc_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether auto-renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the availability zone. Changing this creates a
        new instance.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> pulumi.Output['outputs.InstanceBackupStrategy']:
        """
        Specifies the advanced backup policy. The structure is described below.
        """
        return pulumi.get(self, "backup_strategy")

    @_builtins.property
    @pulumi.getter(name="balancerActiveBegin")
    def balancer_active_begin(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "balancer_active_begin")

    @_builtins.property
    @pulumi.getter(name="balancerActiveEnd")
    def balancer_active_end(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "balancer_active_end")

    @_builtins.property
    @pulumi.getter(name="balancerStatus")
    def balancer_status(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "balancer_status")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the charging mode of the instance.
        The valid values are as follows:
        + `prePaid`: indicates the yearly/monthly billing mode.
        + `postPaid`: indicates the pay-per-use billing mode.

        Default value is `postPaid`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="clientNetworkRanges")
    def client_network_ranges(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "client_network_ranges")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceConfiguration']]]:
        """
        Specifies the configuration information.
        The structure is described below. Changing this creates a new instance.
        """
        return pulumi.get(self, "configurations")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def datastore(self) -> pulumi.Output['outputs.InstanceDatastore']:
        """
        Specifies database information. The structure is described below. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "datastore")

    @_builtins.property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the DB Administator name.
        """
        return pulumi.get(self, "db_username")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionId")
    def disk_encryption_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the disk encryption ID of the instance. Changing this
        creates a new instance.
        """
        return pulumi.get(self, "disk_encryption_id")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project id of the dds instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def flavors(self) -> pulumi.Output[Sequence['outputs.InstanceFlavor']]:
        """
        Specifies the flavors information. The structure is described below. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "flavors")

    @_builtins.property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Sequence['outputs.InstanceGroup']]:
        return pulumi.get(self, "groups")

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "maintain_begin")

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "maintain_end")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the mode of the database instance. **Sharding**, **ReplicaSet**,
        **Single** are supported. Changing this creates a new instance.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the DB instance name. The DB instance name of the same type is unique in the
        same tenant.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.InstanceNode']]:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Administrator password of the database instance.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the database access port. The valid values are range from `2100` to `9500` and
        `27017`, `27018`, `27019`. Defaults to `8635`.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region of the DDS instance. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="replicaSetName")
    def replica_set_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "replica_set_name")

    @_builtins.property
    @pulumi.getter(name="secondLevelMonitoringEnabled")
    def second_level_monitoring_enabled(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "second_level_monitoring_enabled")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the security group ID of the DDS instance.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="slowLogDesensitization")
    def slow_log_desensitization(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "slow_log_desensitization")

    @_builtins.property
    @pulumi.getter
    def ssl(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable or disable SSL. Defaults to true.

        **NOTE:** The instance will be restarted in the background when switching SSL. Please operate with caution.
        """
        return pulumi.get(self, "ssl")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the subnet Network ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key/value pairs to associate with the DDS instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the VPC ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "vpc_id")

