# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DdsParameterTemplateArgs', 'DdsParameterTemplate']

@pulumi.input_type
class DdsParameterTemplateArgs:
    def __init__(__self__, *,
                 node_type: pulumi.Input[_builtins.str],
                 node_version: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DdsParameterTemplate resource.
        :param pulumi.Input[_builtins.str] node_type: Specifies the node type of parameter template. Valid value:
               + **mongos**: the mongos node type.
               + **shard**: the shard node type.
               + **config**: the config node type.
               + **replica**: the replica node type.
               + **single**: the single node type.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] node_version: Specifies the database version.
               The value can be **4.4**, **4.2**, **4.0**, **3.4** or **3.2**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the parameter template description.
               The description must consist of a maximum of 256 characters and cannot contain the carriage
               return character or the following special characters: >!<"&'=.
        :param pulumi.Input[_builtins.str] name: Specifies the parameter template name.
               The value must be 1 to 64 characters, which can contain only letters, digits, hyphens (-),
               underscores (_), and periods (.).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameter_values: Specifies the mapping between parameter names and parameter values.
               You can customize parameter values based on the parameters in the default parameter template.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "node_version", node_version)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameter_values is not None:
            pulumi.set(__self__, "parameter_values", parameter_values)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the node type of parameter template. Valid value:
        + **mongos**: the mongos node type.
        + **shard**: the shard node type.
        + **config**: the config node type.
        + **replica**: the replica node type.
        + **single**: the single node type.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="nodeVersion")
    def node_version(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the database version.
        The value can be **4.4**, **4.2**, **4.0**, **3.4** or **3.2**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "node_version")

    @node_version.setter
    def node_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_version", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the parameter template description.
        The description must consist of a maximum of 256 characters and cannot contain the carriage
        return character or the following special characters: >!<"&'=.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the parameter template name.
        The value must be 1 to 64 characters, which can contain only letters, digits, hyphens (-),
        underscores (_), and periods (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parameterValues")
    def parameter_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the mapping between parameter names and parameter values.
        You can customize parameter values based on the parameters in the default parameter template.
        """
        return pulumi.get(self, "parameter_values")

    @parameter_values.setter
    def parameter_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameter_values", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DdsParameterTemplateState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_version: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['DdsParameterTemplateParameterArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DdsParameterTemplate resources.
        :param pulumi.Input[_builtins.str] created_at: The create time of the parameter template.
        :param pulumi.Input[_builtins.str] description: Specifies the parameter template description.
               The description must consist of a maximum of 256 characters and cannot contain the carriage
               return character or the following special characters: >!<"&'=.
        :param pulumi.Input[_builtins.str] name: Specifies the parameter template name.
               The value must be 1 to 64 characters, which can contain only letters, digits, hyphens (-),
               underscores (_), and periods (.).
        :param pulumi.Input[_builtins.str] node_type: Specifies the node type of parameter template. Valid value:
               + **mongos**: the mongos node type.
               + **shard**: the shard node type.
               + **config**: the config node type.
               + **replica**: the replica node type.
               + **single**: the single node type.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] node_version: Specifies the database version.
               The value can be **4.4**, **4.2**, **4.0**, **3.4** or **3.2**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameter_values: Specifies the mapping between parameter names and parameter values.
               You can customize parameter values based on the parameters in the default parameter template.
        :param pulumi.Input[Sequence[pulumi.Input['DdsParameterTemplateParameterArgs']]] parameters: Indicates the parameters defined by users based on the default parameter templates.
               The Parameter structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] updated_at: The update time of the parameter template.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if node_version is not None:
            pulumi.set(__self__, "node_version", node_version)
        if parameter_values is not None:
            pulumi.set(__self__, "parameter_values", parameter_values)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The create time of the parameter template.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the parameter template description.
        The description must consist of a maximum of 256 characters and cannot contain the carriage
        return character or the following special characters: >!<"&'=.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the parameter template name.
        The value must be 1 to 64 characters, which can contain only letters, digits, hyphens (-),
        underscores (_), and periods (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the node type of parameter template. Valid value:
        + **mongos**: the mongos node type.
        + **shard**: the shard node type.
        + **config**: the config node type.
        + **replica**: the replica node type.
        + **single**: the single node type.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="nodeVersion")
    def node_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database version.
        The value can be **4.4**, **4.2**, **4.0**, **3.4** or **3.2**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "node_version")

    @node_version.setter
    def node_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_version", value)

    @_builtins.property
    @pulumi.getter(name="parameterValues")
    def parameter_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the mapping between parameter names and parameter values.
        You can customize parameter values based on the parameters in the default parameter template.
        """
        return pulumi.get(self, "parameter_values")

    @parameter_values.setter
    def parameter_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameter_values", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DdsParameterTemplateParameterArgs']]]]:
        """
        Indicates the parameters defined by users based on the default parameter templates.
        The Parameter structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DdsParameterTemplateParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update time of the parameter template.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:index/ddsParameterTemplate:DdsParameterTemplate")
class DdsParameterTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_version: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a DDS parameter template resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        parameter_values = config.require_object("parameterValues")
        node_type = config.require_object("nodeType")
        node_version = config.require_object("nodeVersion")
        test = sbercloud.DdsParameterTemplate("test",
            name=name,
            parameter_values=parameter_values,
            node_type=node_type,
            node_version=node_version)
        ```

        ## Import

        The DDS parameter template can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/ddsParameterTemplate:DdsParameterTemplate test <tempalate_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the parameter template description.
               The description must consist of a maximum of 256 characters and cannot contain the carriage
               return character or the following special characters: >!<"&'=.
        :param pulumi.Input[_builtins.str] name: Specifies the parameter template name.
               The value must be 1 to 64 characters, which can contain only letters, digits, hyphens (-),
               underscores (_), and periods (.).
        :param pulumi.Input[_builtins.str] node_type: Specifies the node type of parameter template. Valid value:
               + **mongos**: the mongos node type.
               + **shard**: the shard node type.
               + **config**: the config node type.
               + **replica**: the replica node type.
               + **single**: the single node type.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] node_version: Specifies the database version.
               The value can be **4.4**, **4.2**, **4.0**, **3.4** or **3.2**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameter_values: Specifies the mapping between parameter names and parameter values.
               You can customize parameter values based on the parameters in the default parameter template.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DdsParameterTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DDS parameter template resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        name = config.require_object("name")
        parameter_values = config.require_object("parameterValues")
        node_type = config.require_object("nodeType")
        node_version = config.require_object("nodeVersion")
        test = sbercloud.DdsParameterTemplate("test",
            name=name,
            parameter_values=parameter_values,
            node_type=node_type,
            node_version=node_version)
        ```

        ## Import

        The DDS parameter template can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/ddsParameterTemplate:DdsParameterTemplate test <tempalate_id>
        ```

        :param str resource_name: The name of the resource.
        :param DdsParameterTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DdsParameterTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 node_version: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DdsParameterTemplateArgs.__new__(DdsParameterTemplateArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            if node_version is None and not opts.urn:
                raise TypeError("Missing required property 'node_version'")
            __props__.__dict__["node_version"] = node_version
            __props__.__dict__["parameter_values"] = parameter_values
            __props__.__dict__["region"] = region
            __props__.__dict__["created_at"] = None
            __props__.__dict__["parameters"] = None
            __props__.__dict__["updated_at"] = None
        super(DdsParameterTemplate, __self__).__init__(
            'sbercloud:index/ddsParameterTemplate:DdsParameterTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_type: Optional[pulumi.Input[_builtins.str]] = None,
            node_version: Optional[pulumi.Input[_builtins.str]] = None,
            parameter_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DdsParameterTemplateParameterArgs', 'DdsParameterTemplateParameterArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'DdsParameterTemplate':
        """
        Get an existing DdsParameterTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The create time of the parameter template.
        :param pulumi.Input[_builtins.str] description: Specifies the parameter template description.
               The description must consist of a maximum of 256 characters and cannot contain the carriage
               return character or the following special characters: >!<"&'=.
        :param pulumi.Input[_builtins.str] name: Specifies the parameter template name.
               The value must be 1 to 64 characters, which can contain only letters, digits, hyphens (-),
               underscores (_), and periods (.).
        :param pulumi.Input[_builtins.str] node_type: Specifies the node type of parameter template. Valid value:
               + **mongos**: the mongos node type.
               + **shard**: the shard node type.
               + **config**: the config node type.
               + **replica**: the replica node type.
               + **single**: the single node type.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] node_version: Specifies the database version.
               The value can be **4.4**, **4.2**, **4.0**, **3.4** or **3.2**.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameter_values: Specifies the mapping between parameter names and parameter values.
               You can customize parameter values based on the parameters in the default parameter template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DdsParameterTemplateParameterArgs', 'DdsParameterTemplateParameterArgsDict']]]] parameters: Indicates the parameters defined by users based on the default parameter templates.
               The Parameter structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] updated_at: The update time of the parameter template.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DdsParameterTemplateState.__new__(_DdsParameterTemplateState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["node_version"] = node_version
        __props__.__dict__["parameter_values"] = parameter_values
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["region"] = region
        __props__.__dict__["updated_at"] = updated_at
        return DdsParameterTemplate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The create time of the parameter template.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the parameter template description.
        The description must consist of a maximum of 256 characters and cannot contain the carriage
        return character or the following special characters: >!<"&'=.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the parameter template name.
        The value must be 1 to 64 characters, which can contain only letters, digits, hyphens (-),
        underscores (_), and periods (.).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the node type of parameter template. Valid value:
        + **mongos**: the mongos node type.
        + **shard**: the shard node type.
        + **config**: the config node type.
        + **replica**: the replica node type.
        + **single**: the single node type.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter(name="nodeVersion")
    def node_version(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the database version.
        The value can be **4.4**, **4.2**, **4.0**, **3.4** or **3.2**.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "node_version")

    @_builtins.property
    @pulumi.getter(name="parameterValues")
    def parameter_values(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the mapping between parameter names and parameter values.
        You can customize parameter values based on the parameters in the default parameter template.
        """
        return pulumi.get(self, "parameter_values")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.DdsParameterTemplateParameter']]:
        """
        Indicates the parameters defined by users based on the default parameter templates.
        The Parameter structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The update time of the parameter template.
        """
        return pulumi.get(self, "updated_at")

