# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DdsParameterTemplateApplyArgs', 'DdsParameterTemplateApply']

@pulumi.input_type
class DdsParameterTemplateApplyArgs:
    def __init__(__self__, *,
                 configuration_id: pulumi.Input[_builtins.str],
                 entity_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DdsParameterTemplateApply resource.
        :param pulumi.Input[_builtins.str] configuration_id: Specifies the parameter template ID.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] entity_ids: Specifies the entity IDs.
               + If the DB instance type is cluster and the shard or config parameter template is to be changed, the value is the
               group ID. If the parameter template of the mongos node is to be changed, the value is the node ID.
               + If the DB instance to be changed is a replica set instance, the value is the instance ID.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        pulumi.set(__self__, "configuration_id", configuration_id)
        pulumi.set(__self__, "entity_ids", entity_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the parameter template ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="entityIds")
    def entity_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the entity IDs.
        + If the DB instance type is cluster and the shard or config parameter template is to be changed, the value is the
        group ID. If the parameter template of the mongos node is to be changed, the value is the node ID.
        + If the DB instance to be changed is a replica set instance, the value is the instance ID.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "entity_ids")

    @entity_ids.setter
    def entity_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "entity_ids", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DdsParameterTemplateApplyState:
    def __init__(__self__, *,
                 configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DdsParameterTemplateApply resources.
        :param pulumi.Input[_builtins.str] configuration_id: Specifies the parameter template ID.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] entity_ids: Specifies the entity IDs.
               + If the DB instance type is cluster and the shard or config parameter template is to be changed, the value is the
               group ID. If the parameter template of the mongos node is to be changed, the value is the node ID.
               + If the DB instance to be changed is a replica set instance, the value is the instance ID.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if entity_ids is not None:
            pulumi.set(__self__, "entity_ids", entity_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the parameter template ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="entityIds")
    def entity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the entity IDs.
        + If the DB instance type is cluster and the shard or config parameter template is to be changed, the value is the
        group ID. If the parameter template of the mongos node is to be changed, the value is the node ID.
        + If the DB instance to be changed is a replica set instance, the value is the instance ID.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "entity_ids")

    @entity_ids.setter
    def entity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "entity_ids", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:index/ddsParameterTemplateApply:DdsParameterTemplateApply")
class DdsParameterTemplateApply(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a DDS parameter template apply resource within SberCloud.

        > Please check whether the entities need to be restarted after applying parameter template.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        configuration_id = config.require_object("configurationId")
        entity_ids = config.require_object("entityIds")
        test = sbercloud.DdsParameterTemplateApply("test",
            configuration_id=configuration_id,
            entity_ids=entity_ids)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] configuration_id: Specifies the parameter template ID.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] entity_ids: Specifies the entity IDs.
               + If the DB instance type is cluster and the shard or config parameter template is to be changed, the value is the
               group ID. If the parameter template of the mongos node is to be changed, the value is the node ID.
               + If the DB instance to be changed is a replica set instance, the value is the instance ID.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DdsParameterTemplateApplyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DDS parameter template apply resource within SberCloud.

        > Please check whether the entities need to be restarted after applying parameter template.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        configuration_id = config.require_object("configurationId")
        entity_ids = config.require_object("entityIds")
        test = sbercloud.DdsParameterTemplateApply("test",
            configuration_id=configuration_id,
            entity_ids=entity_ids)
        ```

        :param str resource_name: The name of the resource.
        :param DdsParameterTemplateApplyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DdsParameterTemplateApplyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DdsParameterTemplateApplyArgs.__new__(DdsParameterTemplateApplyArgs)

            if configuration_id is None and not opts.urn:
                raise TypeError("Missing required property 'configuration_id'")
            __props__.__dict__["configuration_id"] = configuration_id
            if entity_ids is None and not opts.urn:
                raise TypeError("Missing required property 'entity_ids'")
            __props__.__dict__["entity_ids"] = entity_ids
            __props__.__dict__["region"] = region
        super(DdsParameterTemplateApply, __self__).__init__(
            'sbercloud:index/ddsParameterTemplateApply:DdsParameterTemplateApply',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
            entity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'DdsParameterTemplateApply':
        """
        Get an existing DdsParameterTemplateApply resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] configuration_id: Specifies the parameter template ID.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] entity_ids: Specifies the entity IDs.
               + If the DB instance type is cluster and the shard or config parameter template is to be changed, the value is the
               group ID. If the parameter template of the mongos node is to be changed, the value is the node ID.
               + If the DB instance to be changed is a replica set instance, the value is the instance ID.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DdsParameterTemplateApplyState.__new__(_DdsParameterTemplateApplyState)

        __props__.__dict__["configuration_id"] = configuration_id
        __props__.__dict__["entity_ids"] = entity_ids
        __props__.__dict__["region"] = region
        return DdsParameterTemplateApply(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the parameter template ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "configuration_id")

    @_builtins.property
    @pulumi.getter(name="entityIds")
    def entity_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the entity IDs.
        + If the DB instance type is cluster and the shard or config parameter template is to be changed, the value is the
        group ID. If the parameter template of the mongos node is to be changed, the value is the node ID.
        + If the DB instance to be changed is a replica set instance, the value is the instance ID.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "entity_ids")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

