# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DdsParameterTemplateCompareArgs', 'DdsParameterTemplateCompare']

@pulumi.input_type
class DdsParameterTemplateCompareArgs:
    def __init__(__self__, *,
                 source_configuration_id: pulumi.Input[_builtins.str],
                 target_configuration_id: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DdsParameterTemplateCompare resource.
        :param pulumi.Input[_builtins.str] source_configuration_id: Specifies the ID of the source parameter template to be
               compared. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] target_configuration_id: Specifies the ID of the destination parameter template to be
               compared. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "source_configuration_id", source_configuration_id)
        pulumi.set(__self__, "target_configuration_id", target_configuration_id)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="sourceConfigurationId")
    def source_configuration_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the source parameter template to be
        compared. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_configuration_id")

    @source_configuration_id.setter
    def source_configuration_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source_configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="targetConfigurationId")
    def target_configuration_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the destination parameter template to be
        compared. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "target_configuration_id")

    @target_configuration_id.setter
    def target_configuration_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_configuration_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DdsParameterTemplateCompareState:
    def __init__(__self__, *,
                 differences: Optional[pulumi.Input[Sequence[pulumi.Input['DdsParameterTemplateCompareDifferenceArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_configuration_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DdsParameterTemplateCompare resources.
        :param pulumi.Input[Sequence[pulumi.Input['DdsParameterTemplateCompareDifferenceArgs']]] differences: Indicates the differences between parameters.
               The differences structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] source_configuration_id: Specifies the ID of the source parameter template to be
               compared. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] target_configuration_id: Specifies the ID of the destination parameter template to be
               compared. Changing this parameter will create a new resource.
        """
        if differences is not None:
            pulumi.set(__self__, "differences", differences)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_configuration_id is not None:
            pulumi.set(__self__, "source_configuration_id", source_configuration_id)
        if target_configuration_id is not None:
            pulumi.set(__self__, "target_configuration_id", target_configuration_id)

    @_builtins.property
    @pulumi.getter
    def differences(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DdsParameterTemplateCompareDifferenceArgs']]]]:
        """
        Indicates the differences between parameters.
        The differences structure is documented below.
        """
        return pulumi.get(self, "differences")

    @differences.setter
    def differences(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DdsParameterTemplateCompareDifferenceArgs']]]]):
        pulumi.set(self, "differences", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sourceConfigurationId")
    def source_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the source parameter template to be
        compared. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_configuration_id")

    @source_configuration_id.setter
    def source_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="targetConfigurationId")
    def target_configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the destination parameter template to be
        compared. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "target_configuration_id")

    @target_configuration_id.setter
    def target_configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_configuration_id", value)


@pulumi.type_token("sbercloud:index/ddsParameterTemplateCompare:DdsParameterTemplateCompare")
class DdsParameterTemplateCompare(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a DDS parameter template compare resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        source_configuration_id = config.require_object("sourceConfigurationId")
        target_configuration_id = config.require_object("targetConfigurationId")
        test = sbercloud.DdsParameterTemplateCompare("test",
            source_configuration_id=source_configuration_id,
            target_configuration_id=target_configuration_id)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] source_configuration_id: Specifies the ID of the source parameter template to be
               compared. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] target_configuration_id: Specifies the ID of the destination parameter template to be
               compared. Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DdsParameterTemplateCompareArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DDS parameter template compare resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        source_configuration_id = config.require_object("sourceConfigurationId")
        target_configuration_id = config.require_object("targetConfigurationId")
        test = sbercloud.DdsParameterTemplateCompare("test",
            source_configuration_id=source_configuration_id,
            target_configuration_id=target_configuration_id)
        ```

        :param str resource_name: The name of the resource.
        :param DdsParameterTemplateCompareArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DdsParameterTemplateCompareArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 target_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DdsParameterTemplateCompareArgs.__new__(DdsParameterTemplateCompareArgs)

            __props__.__dict__["region"] = region
            if source_configuration_id is None and not opts.urn:
                raise TypeError("Missing required property 'source_configuration_id'")
            __props__.__dict__["source_configuration_id"] = source_configuration_id
            if target_configuration_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_configuration_id'")
            __props__.__dict__["target_configuration_id"] = target_configuration_id
            __props__.__dict__["differences"] = None
        super(DdsParameterTemplateCompare, __self__).__init__(
            'sbercloud:index/ddsParameterTemplateCompare:DdsParameterTemplateCompare',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            differences: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DdsParameterTemplateCompareDifferenceArgs', 'DdsParameterTemplateCompareDifferenceArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            source_configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
            target_configuration_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DdsParameterTemplateCompare':
        """
        Get an existing DdsParameterTemplateCompare resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DdsParameterTemplateCompareDifferenceArgs', 'DdsParameterTemplateCompareDifferenceArgsDict']]]] differences: Indicates the differences between parameters.
               The differences structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] source_configuration_id: Specifies the ID of the source parameter template to be
               compared. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] target_configuration_id: Specifies the ID of the destination parameter template to be
               compared. Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DdsParameterTemplateCompareState.__new__(_DdsParameterTemplateCompareState)

        __props__.__dict__["differences"] = differences
        __props__.__dict__["region"] = region
        __props__.__dict__["source_configuration_id"] = source_configuration_id
        __props__.__dict__["target_configuration_id"] = target_configuration_id
        return DdsParameterTemplateCompare(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def differences(self) -> pulumi.Output[Sequence['outputs.DdsParameterTemplateCompareDifference']]:
        """
        Indicates the differences between parameters.
        The differences structure is documented below.
        """
        return pulumi.get(self, "differences")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sourceConfigurationId")
    def source_configuration_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the source parameter template to be
        compared. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_configuration_id")

    @_builtins.property
    @pulumi.getter(name="targetConfigurationId")
    def target_configuration_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the destination parameter template to be
        compared. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "target_configuration_id")

