# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DdsParameterTemplateCopyArgs', 'DdsParameterTemplateCopy']

@pulumi.input_type
class DdsParameterTemplateCopyArgs:
    def __init__(__self__, *,
                 configuration_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DdsParameterTemplateCopy resource.
        :param pulumi.Input[_builtins.str] configuration_id: Specifies the parameter template ID.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of replicated parameter template.
               The value is left blank by default. The description must consist of a maximum of **256** characters and cannot contain
               the carriage return character or the following special characters: >!<"&'=
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of replicated parameter template.
               The parameter template name can contain **1** to **64** characters. It can contain only letters, digits, hyphens (-),
               underscores (_), and periods (.).
               Changing this creates a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameter_values: Specifies the mapping between parameter names and parameter values.
               You can customize parameter values based on the parameters in the default parameter template.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        pulumi.set(__self__, "configuration_id", configuration_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameter_values is not None:
            pulumi.set(__self__, "parameter_values", parameter_values)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the parameter template ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "configuration_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of replicated parameter template.
        The value is left blank by default. The description must consist of a maximum of **256** characters and cannot contain
        the carriage return character or the following special characters: >!<"&'=
        Changing this creates a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of replicated parameter template.
        The parameter template name can contain **1** to **64** characters. It can contain only letters, digits, hyphens (-),
        underscores (_), and periods (.).
        Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="parameterValues")
    def parameter_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the mapping between parameter names and parameter values.
        You can customize parameter values based on the parameters in the default parameter template.
        """
        return pulumi.get(self, "parameter_values")

    @parameter_values.setter
    def parameter_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameter_values", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DdsParameterTemplateCopyState:
    def __init__(__self__, *,
                 configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_version: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['DdsParameterTemplateCopyParameterArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DdsParameterTemplateCopy resources.
        :param pulumi.Input[_builtins.str] configuration_id: Specifies the parameter template ID.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] created_at: The create time of the parameter template.
        :param pulumi.Input[_builtins.str] description: Specifies the description of replicated parameter template.
               The value is left blank by default. The description must consist of a maximum of **256** characters and cannot contain
               the carriage return character or the following special characters: >!<"&'=
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of replicated parameter template.
               The parameter template name can contain **1** to **64** characters. It can contain only letters, digits, hyphens (-),
               underscores (_), and periods (.).
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] node_version: Indicates the database version.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameter_values: Specifies the mapping between parameter names and parameter values.
               You can customize parameter values based on the parameters in the default parameter template.
        :param pulumi.Input[Sequence[pulumi.Input['DdsParameterTemplateCopyParameterArgs']]] parameters: Indicates the parameters defined by users based on the default parameter templates.
               The Parameter structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] updated_at: The update time of the parameter template.
        """
        if configuration_id is not None:
            pulumi.set(__self__, "configuration_id", configuration_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_version is not None:
            pulumi.set(__self__, "node_version", node_version)
        if parameter_values is not None:
            pulumi.set(__self__, "parameter_values", parameter_values)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the parameter template ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "configuration_id")

    @configuration_id.setter
    def configuration_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "configuration_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The create time of the parameter template.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of replicated parameter template.
        The value is left blank by default. The description must consist of a maximum of **256** characters and cannot contain
        the carriage return character or the following special characters: >!<"&'=
        Changing this creates a new resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of replicated parameter template.
        The parameter template name can contain **1** to **64** characters. It can contain only letters, digits, hyphens (-),
        underscores (_), and periods (.).
        Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeVersion")
    def node_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "node_version")

    @node_version.setter
    def node_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_version", value)

    @_builtins.property
    @pulumi.getter(name="parameterValues")
    def parameter_values(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the mapping between parameter names and parameter values.
        You can customize parameter values based on the parameters in the default parameter template.
        """
        return pulumi.get(self, "parameter_values")

    @parameter_values.setter
    def parameter_values(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameter_values", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DdsParameterTemplateCopyParameterArgs']]]]:
        """
        Indicates the parameters defined by users based on the default parameter templates.
        The Parameter structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DdsParameterTemplateCopyParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The update time of the parameter template.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:index/ddsParameterTemplateCopy:DdsParameterTemplateCopy")
class DdsParameterTemplateCopy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a DDS parameter template copy resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        configuration_id = config.require_object("configurationId")
        name = config.require_object("name")
        test = sbercloud.DdsParameterTemplateCopy("test",
            configuration_id=configuration_id,
            name=name,
            description="test copy")
        ```

        ## Import

        The DDS copyed parameter template can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/ddsParameterTemplateCopy:DdsParameterTemplateCopy test <id>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason.

        The missing attributes include: `configuration_id`.

        It is generally recommended running `pulumi preview` after importing an template.

        You can then decide if changes should be applied to the template, or the resource definition should be updated to

        align with the template. Also you can ignore changes as below.

        hcl

        resource "sbercloud_dds_parameter_template_copy" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              configuration_id,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] configuration_id: Specifies the parameter template ID.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of replicated parameter template.
               The value is left blank by default. The description must consist of a maximum of **256** characters and cannot contain
               the carriage return character or the following special characters: >!<"&'=
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of replicated parameter template.
               The parameter template name can contain **1** to **64** characters. It can contain only letters, digits, hyphens (-),
               underscores (_), and periods (.).
               Changing this creates a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameter_values: Specifies the mapping between parameter names and parameter values.
               You can customize parameter values based on the parameters in the default parameter template.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DdsParameterTemplateCopyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DDS parameter template copy resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        configuration_id = config.require_object("configurationId")
        name = config.require_object("name")
        test = sbercloud.DdsParameterTemplateCopy("test",
            configuration_id=configuration_id,
            name=name,
            description="test copy")
        ```

        ## Import

        The DDS copyed parameter template can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/ddsParameterTemplateCopy:DdsParameterTemplateCopy test <id>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason.

        The missing attributes include: `configuration_id`.

        It is generally recommended running `pulumi preview` after importing an template.

        You can then decide if changes should be applied to the template, or the resource definition should be updated to

        align with the template. Also you can ignore changes as below.

        hcl

        resource "sbercloud_dds_parameter_template_copy" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              configuration_id,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param DdsParameterTemplateCopyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DdsParameterTemplateCopyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameter_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DdsParameterTemplateCopyArgs.__new__(DdsParameterTemplateCopyArgs)

            if configuration_id is None and not opts.urn:
                raise TypeError("Missing required property 'configuration_id'")
            __props__.__dict__["configuration_id"] = configuration_id
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            __props__.__dict__["parameter_values"] = parameter_values
            __props__.__dict__["region"] = region
            __props__.__dict__["created_at"] = None
            __props__.__dict__["node_version"] = None
            __props__.__dict__["parameters"] = None
            __props__.__dict__["updated_at"] = None
        super(DdsParameterTemplateCopy, __self__).__init__(
            'sbercloud:index/ddsParameterTemplateCopy:DdsParameterTemplateCopy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            configuration_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_version: Optional[pulumi.Input[_builtins.str]] = None,
            parameter_values: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DdsParameterTemplateCopyParameterArgs', 'DdsParameterTemplateCopyParameterArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'DdsParameterTemplateCopy':
        """
        Get an existing DdsParameterTemplateCopy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] configuration_id: Specifies the parameter template ID.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] created_at: The create time of the parameter template.
        :param pulumi.Input[_builtins.str] description: Specifies the description of replicated parameter template.
               The value is left blank by default. The description must consist of a maximum of **256** characters and cannot contain
               the carriage return character or the following special characters: >!<"&'=
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of replicated parameter template.
               The parameter template name can contain **1** to **64** characters. It can contain only letters, digits, hyphens (-),
               underscores (_), and periods (.).
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] node_version: Indicates the database version.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameter_values: Specifies the mapping between parameter names and parameter values.
               You can customize parameter values based on the parameters in the default parameter template.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DdsParameterTemplateCopyParameterArgs', 'DdsParameterTemplateCopyParameterArgsDict']]]] parameters: Indicates the parameters defined by users based on the default parameter templates.
               The Parameter structure is documented below.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] updated_at: The update time of the parameter template.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DdsParameterTemplateCopyState.__new__(_DdsParameterTemplateCopyState)

        __props__.__dict__["configuration_id"] = configuration_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["node_version"] = node_version
        __props__.__dict__["parameter_values"] = parameter_values
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["region"] = region
        __props__.__dict__["updated_at"] = updated_at
        return DdsParameterTemplateCopy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the parameter template ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "configuration_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The create time of the parameter template.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of replicated parameter template.
        The value is left blank by default. The description must consist of a maximum of **256** characters and cannot contain
        the carriage return character or the following special characters: >!<"&'=
        Changing this creates a new resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of replicated parameter template.
        The parameter template name can contain **1** to **64** characters. It can contain only letters, digits, hyphens (-),
        underscores (_), and periods (.).
        Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeVersion")
    def node_version(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the database version.
        """
        return pulumi.get(self, "node_version")

    @_builtins.property
    @pulumi.getter(name="parameterValues")
    def parameter_values(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the mapping between parameter names and parameter values.
        You can customize parameter values based on the parameters in the default parameter template.
        """
        return pulumi.get(self, "parameter_values")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.DdsParameterTemplateCopyParameter']]:
        """
        Indicates the parameters defined by users based on the default parameter templates.
        The Parameter structure is documented below.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The update time of the parameter template.
        """
        return pulumi.get(self, "updated_at")

