# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiArgs', 'Api']

@pulumi.input_type
class ApiArgs:
    def __init__(__self__, *,
                 group_id: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 request_method: pulumi.Input[_builtins.str],
                 request_path: pulumi.Input[_builtins.str],
                 request_protocol: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 authorizer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backend_params: Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParamArgs']]]] = None,
                 body_description: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cors: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 failure_response: Optional[pulumi.Input[_builtins.str]] = None,
                 func_graph: Optional[pulumi.Input['ApiFuncGraphArgs']] = None,
                 func_graph_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyArgs']]]] = None,
                 is_send_fg_body_base64: Optional[pulumi.Input[_builtins.bool]] = None,
                 matching: Optional[pulumi.Input[_builtins.str]] = None,
                 mock: Optional[pulumi.Input['ApiMockArgs']] = None,
                 mock_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_params: Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParamArgs']]]] = None,
                 response_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_authentication: Optional[pulumi.Input[_builtins.str]] = None,
                 simple_authentication: Optional[pulumi.Input[_builtins.bool]] = None,
                 success_response: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 web: Optional[pulumi.Input['ApiWebArgs']] = None,
                 web_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyArgs']]]] = None):
        """
        The set of arguments for constructing a Api resource.
        :param pulumi.Input[_builtins.str] group_id: The ID of the API group to which the API belongs.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance to which the API belongs.
        :param pulumi.Input[_builtins.str] request_method: The request method of the API.
        :param pulumi.Input[_builtins.str] request_path: The request address.
        :param pulumi.Input[_builtins.str] request_protocol: The request protocol of the API request.
        :param pulumi.Input[_builtins.str] type: The API type.
        :param pulumi.Input[_builtins.str] authorizer_id: The ID of the authorizer to which the API request used.
        :param pulumi.Input[Sequence[pulumi.Input['ApiBackendParamArgs']]] backend_params: The configurations of the backend parameters.
        :param pulumi.Input[_builtins.str] body_description: The description of the API request body, which can be an example request body, media type or parameters.
        :param pulumi.Input[_builtins.str] content_type: The content type of the request body.
        :param pulumi.Input[_builtins.bool] cors: Whether CORS is supported.
        :param pulumi.Input[_builtins.str] description: The API description.
        :param pulumi.Input[_builtins.str] failure_response: The example response for a failure request.
        :param pulumi.Input['ApiFuncGraphArgs'] func_graph: The FunctionGraph backend details.
        :param pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyArgs']]] func_graph_policies: The policy backends of the FunctionGraph function.
        :param pulumi.Input[_builtins.bool] is_send_fg_body_base64: Whether to perform Base64 encoding on the body for interaction with FunctionGraph.
        :param pulumi.Input[_builtins.str] matching: The matching mode of the API.
        :param pulumi.Input['ApiMockArgs'] mock: The mock backend details.
        :param pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyArgs']]] mock_policies: The mock policy backends.
        :param pulumi.Input[_builtins.str] name: The API name.
        :param pulumi.Input[_builtins.str] region: The region where the API is located.
        :param pulumi.Input[Sequence[pulumi.Input['ApiRequestParamArgs']]] request_params: The configurations of the front-end parameters.
        :param pulumi.Input[_builtins.str] response_id: The ID of the custom response that API used.
        :param pulumi.Input[_builtins.str] security_authentication: The security authentication mode of the API request.
        :param pulumi.Input[_builtins.bool] simple_authentication: Whether the authentication of the application code is enabled.
        :param pulumi.Input[_builtins.str] success_response: The example response for a successful request.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The list of tags configuration.
        :param pulumi.Input['ApiWebArgs'] web: The web backend details.
        :param pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyArgs']]] web_policies: The web policy backends.
        """
        pulumi.set(__self__, "group_id", group_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "request_method", request_method)
        pulumi.set(__self__, "request_path", request_path)
        pulumi.set(__self__, "request_protocol", request_protocol)
        pulumi.set(__self__, "type", type)
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if backend_params is not None:
            pulumi.set(__self__, "backend_params", backend_params)
        if body_description is not None:
            pulumi.set(__self__, "body_description", body_description)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if failure_response is not None:
            pulumi.set(__self__, "failure_response", failure_response)
        if func_graph is not None:
            pulumi.set(__self__, "func_graph", func_graph)
        if func_graph_policies is not None:
            pulumi.set(__self__, "func_graph_policies", func_graph_policies)
        if is_send_fg_body_base64 is not None:
            pulumi.set(__self__, "is_send_fg_body_base64", is_send_fg_body_base64)
        if matching is not None:
            pulumi.set(__self__, "matching", matching)
        if mock is not None:
            pulumi.set(__self__, "mock", mock)
        if mock_policies is not None:
            pulumi.set(__self__, "mock_policies", mock_policies)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if request_params is not None:
            pulumi.set(__self__, "request_params", request_params)
        if response_id is not None:
            pulumi.set(__self__, "response_id", response_id)
        if security_authentication is not None:
            pulumi.set(__self__, "security_authentication", security_authentication)
        if simple_authentication is not None:
            pulumi.set(__self__, "simple_authentication", simple_authentication)
        if success_response is not None:
            pulumi.set(__self__, "success_response", success_response)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if web is not None:
            pulumi.set(__self__, "web", web)
        if web_policies is not None:
            pulumi.set(__self__, "web_policies", web_policies)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the API group to which the API belongs.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the instance to which the API belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> pulumi.Input[_builtins.str]:
        """
        The request method of the API.
        """
        return pulumi.get(self, "request_method")

    @request_method.setter
    def request_method(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "request_method", value)

    @_builtins.property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> pulumi.Input[_builtins.str]:
        """
        The request address.
        """
        return pulumi.get(self, "request_path")

    @request_path.setter
    def request_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "request_path", value)

    @_builtins.property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> pulumi.Input[_builtins.str]:
        """
        The request protocol of the API request.
        """
        return pulumi.get(self, "request_protocol")

    @request_protocol.setter
    def request_protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "request_protocol", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The API type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the authorizer to which the API request used.
        """
        return pulumi.get(self, "authorizer_id")

    @authorizer_id.setter
    def authorizer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorizer_id", value)

    @_builtins.property
    @pulumi.getter(name="backendParams")
    def backend_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParamArgs']]]]:
        """
        The configurations of the backend parameters.
        """
        return pulumi.get(self, "backend_params")

    @backend_params.setter
    def backend_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParamArgs']]]]):
        pulumi.set(self, "backend_params", value)

    @_builtins.property
    @pulumi.getter(name="bodyDescription")
    def body_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the API request body, which can be an example request body, media type or parameters.
        """
        return pulumi.get(self, "body_description")

    @body_description.setter
    def body_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "body_description", value)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content type of the request body.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether CORS is supported.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="failureResponse")
    def failure_response(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The example response for a failure request.
        """
        return pulumi.get(self, "failure_response")

    @failure_response.setter
    def failure_response(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "failure_response", value)

    @_builtins.property
    @pulumi.getter(name="funcGraph")
    def func_graph(self) -> Optional[pulumi.Input['ApiFuncGraphArgs']]:
        """
        The FunctionGraph backend details.
        """
        return pulumi.get(self, "func_graph")

    @func_graph.setter
    def func_graph(self, value: Optional[pulumi.Input['ApiFuncGraphArgs']]):
        pulumi.set(self, "func_graph", value)

    @_builtins.property
    @pulumi.getter(name="funcGraphPolicies")
    def func_graph_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyArgs']]]]:
        """
        The policy backends of the FunctionGraph function.
        """
        return pulumi.get(self, "func_graph_policies")

    @func_graph_policies.setter
    def func_graph_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyArgs']]]]):
        pulumi.set(self, "func_graph_policies", value)

    @_builtins.property
    @pulumi.getter(name="isSendFgBodyBase64")
    def is_send_fg_body_base64(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to perform Base64 encoding on the body for interaction with FunctionGraph.
        """
        return pulumi.get(self, "is_send_fg_body_base64")

    @is_send_fg_body_base64.setter
    def is_send_fg_body_base64(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_send_fg_body_base64", value)

    @_builtins.property
    @pulumi.getter
    def matching(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The matching mode of the API.
        """
        return pulumi.get(self, "matching")

    @matching.setter
    def matching(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "matching", value)

    @_builtins.property
    @pulumi.getter
    def mock(self) -> Optional[pulumi.Input['ApiMockArgs']]:
        """
        The mock backend details.
        """
        return pulumi.get(self, "mock")

    @mock.setter
    def mock(self, value: Optional[pulumi.Input['ApiMockArgs']]):
        pulumi.set(self, "mock", value)

    @_builtins.property
    @pulumi.getter(name="mockPolicies")
    def mock_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyArgs']]]]:
        """
        The mock policy backends.
        """
        return pulumi.get(self, "mock_policies")

    @mock_policies.setter
    def mock_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyArgs']]]]):
        pulumi.set(self, "mock_policies", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the API is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="requestParams")
    def request_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParamArgs']]]]:
        """
        The configurations of the front-end parameters.
        """
        return pulumi.get(self, "request_params")

    @request_params.setter
    def request_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParamArgs']]]]):
        pulumi.set(self, "request_params", value)

    @_builtins.property
    @pulumi.getter(name="responseId")
    def response_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the custom response that API used.
        """
        return pulumi.get(self, "response_id")

    @response_id.setter
    def response_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "response_id", value)

    @_builtins.property
    @pulumi.getter(name="securityAuthentication")
    def security_authentication(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security authentication mode of the API request.
        """
        return pulumi.get(self, "security_authentication")

    @security_authentication.setter
    def security_authentication(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_authentication", value)

    @_builtins.property
    @pulumi.getter(name="simpleAuthentication")
    def simple_authentication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the authentication of the application code is enabled.
        """
        return pulumi.get(self, "simple_authentication")

    @simple_authentication.setter
    def simple_authentication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "simple_authentication", value)

    @_builtins.property
    @pulumi.getter(name="successResponse")
    def success_response(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The example response for a successful request.
        """
        return pulumi.get(self, "success_response")

    @success_response.setter
    def success_response(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "success_response", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of tags configuration.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def web(self) -> Optional[pulumi.Input['ApiWebArgs']]:
        """
        The web backend details.
        """
        return pulumi.get(self, "web")

    @web.setter
    def web(self, value: Optional[pulumi.Input['ApiWebArgs']]):
        pulumi.set(self, "web", value)

    @_builtins.property
    @pulumi.getter(name="webPolicies")
    def web_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyArgs']]]]:
        """
        The web policy backends.
        """
        return pulumi.get(self, "web_policies")

    @web_policies.setter
    def web_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyArgs']]]]):
        pulumi.set(self, "web_policies", value)


@pulumi.input_type
class _ApiState:
    def __init__(__self__, *,
                 authorizer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backend_params: Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParamArgs']]]] = None,
                 body_description: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cors: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 failure_response: Optional[pulumi.Input[_builtins.str]] = None,
                 func_graph: Optional[pulumi.Input['ApiFuncGraphArgs']] = None,
                 func_graph_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyArgs']]]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_send_fg_body_base64: Optional[pulumi.Input[_builtins.bool]] = None,
                 matching: Optional[pulumi.Input[_builtins.str]] = None,
                 mock: Optional[pulumi.Input['ApiMockArgs']] = None,
                 mock_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 registered_at: Optional[pulumi.Input[_builtins.str]] = None,
                 request_method: Optional[pulumi.Input[_builtins.str]] = None,
                 request_params: Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParamArgs']]]] = None,
                 request_path: Optional[pulumi.Input[_builtins.str]] = None,
                 request_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 response_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_authentication: Optional[pulumi.Input[_builtins.str]] = None,
                 simple_authentication: Optional[pulumi.Input[_builtins.bool]] = None,
                 success_response: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 web: Optional[pulumi.Input['ApiWebArgs']] = None,
                 web_policies: Optional[pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyArgs']]]] = None):
        """
        Input properties used for looking up and filtering Api resources.
        :param pulumi.Input[_builtins.str] authorizer_id: The ID of the authorizer to which the API request used.
        :param pulumi.Input[Sequence[pulumi.Input['ApiBackendParamArgs']]] backend_params: The configurations of the backend parameters.
        :param pulumi.Input[_builtins.str] body_description: The description of the API request body, which can be an example request body, media type or parameters.
        :param pulumi.Input[_builtins.str] content_type: The content type of the request body.
        :param pulumi.Input[_builtins.bool] cors: Whether CORS is supported.
        :param pulumi.Input[_builtins.str] description: The API description.
        :param pulumi.Input[_builtins.str] failure_response: The example response for a failure request.
        :param pulumi.Input['ApiFuncGraphArgs'] func_graph: The FunctionGraph backend details.
        :param pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyArgs']]] func_graph_policies: The policy backends of the FunctionGraph function.
        :param pulumi.Input[_builtins.str] group_id: The ID of the API group to which the API belongs.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance to which the API belongs.
        :param pulumi.Input[_builtins.bool] is_send_fg_body_base64: Whether to perform Base64 encoding on the body for interaction with FunctionGraph.
        :param pulumi.Input[_builtins.str] matching: The matching mode of the API.
        :param pulumi.Input['ApiMockArgs'] mock: The mock backend details.
        :param pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyArgs']]] mock_policies: The mock policy backends.
        :param pulumi.Input[_builtins.str] name: The API name.
        :param pulumi.Input[_builtins.str] region: The region where the API is located.
        :param pulumi.Input[_builtins.str] registered_at: The registered time of the API.
        :param pulumi.Input[_builtins.str] request_method: The request method of the API.
        :param pulumi.Input[Sequence[pulumi.Input['ApiRequestParamArgs']]] request_params: The configurations of the front-end parameters.
        :param pulumi.Input[_builtins.str] request_path: The request address.
        :param pulumi.Input[_builtins.str] request_protocol: The request protocol of the API request.
        :param pulumi.Input[_builtins.str] response_id: The ID of the custom response that API used.
        :param pulumi.Input[_builtins.str] security_authentication: The security authentication mode of the API request.
        :param pulumi.Input[_builtins.bool] simple_authentication: Whether the authentication of the application code is enabled.
        :param pulumi.Input[_builtins.str] success_response: The example response for a successful request.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The list of tags configuration.
        :param pulumi.Input[_builtins.str] type: The API type.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time of the API.
        :param pulumi.Input['ApiWebArgs'] web: The web backend details.
        :param pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyArgs']]] web_policies: The web policy backends.
        """
        if authorizer_id is not None:
            pulumi.set(__self__, "authorizer_id", authorizer_id)
        if backend_params is not None:
            pulumi.set(__self__, "backend_params", backend_params)
        if body_description is not None:
            pulumi.set(__self__, "body_description", body_description)
        if content_type is not None:
            pulumi.set(__self__, "content_type", content_type)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if failure_response is not None:
            pulumi.set(__self__, "failure_response", failure_response)
        if func_graph is not None:
            pulumi.set(__self__, "func_graph", func_graph)
        if func_graph_policies is not None:
            pulumi.set(__self__, "func_graph_policies", func_graph_policies)
        if group_id is not None:
            pulumi.set(__self__, "group_id", group_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if is_send_fg_body_base64 is not None:
            pulumi.set(__self__, "is_send_fg_body_base64", is_send_fg_body_base64)
        if matching is not None:
            pulumi.set(__self__, "matching", matching)
        if mock is not None:
            pulumi.set(__self__, "mock", mock)
        if mock_policies is not None:
            pulumi.set(__self__, "mock_policies", mock_policies)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if registered_at is not None:
            pulumi.set(__self__, "registered_at", registered_at)
        if request_method is not None:
            pulumi.set(__self__, "request_method", request_method)
        if request_params is not None:
            pulumi.set(__self__, "request_params", request_params)
        if request_path is not None:
            pulumi.set(__self__, "request_path", request_path)
        if request_protocol is not None:
            pulumi.set(__self__, "request_protocol", request_protocol)
        if response_id is not None:
            pulumi.set(__self__, "response_id", response_id)
        if security_authentication is not None:
            pulumi.set(__self__, "security_authentication", security_authentication)
        if simple_authentication is not None:
            pulumi.set(__self__, "simple_authentication", simple_authentication)
        if success_response is not None:
            pulumi.set(__self__, "success_response", success_response)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if web is not None:
            pulumi.set(__self__, "web", web)
        if web_policies is not None:
            pulumi.set(__self__, "web_policies", web_policies)

    @_builtins.property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the authorizer to which the API request used.
        """
        return pulumi.get(self, "authorizer_id")

    @authorizer_id.setter
    def authorizer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authorizer_id", value)

    @_builtins.property
    @pulumi.getter(name="backendParams")
    def backend_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParamArgs']]]]:
        """
        The configurations of the backend parameters.
        """
        return pulumi.get(self, "backend_params")

    @backend_params.setter
    def backend_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiBackendParamArgs']]]]):
        pulumi.set(self, "backend_params", value)

    @_builtins.property
    @pulumi.getter(name="bodyDescription")
    def body_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the API request body, which can be an example request body, media type or parameters.
        """
        return pulumi.get(self, "body_description")

    @body_description.setter
    def body_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "body_description", value)

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The content type of the request body.
        """
        return pulumi.get(self, "content_type")

    @content_type.setter
    def content_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "content_type", value)

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether CORS is supported.
        """
        return pulumi.get(self, "cors")

    @cors.setter
    def cors(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cors", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="failureResponse")
    def failure_response(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The example response for a failure request.
        """
        return pulumi.get(self, "failure_response")

    @failure_response.setter
    def failure_response(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "failure_response", value)

    @_builtins.property
    @pulumi.getter(name="funcGraph")
    def func_graph(self) -> Optional[pulumi.Input['ApiFuncGraphArgs']]:
        """
        The FunctionGraph backend details.
        """
        return pulumi.get(self, "func_graph")

    @func_graph.setter
    def func_graph(self, value: Optional[pulumi.Input['ApiFuncGraphArgs']]):
        pulumi.set(self, "func_graph", value)

    @_builtins.property
    @pulumi.getter(name="funcGraphPolicies")
    def func_graph_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyArgs']]]]:
        """
        The policy backends of the FunctionGraph function.
        """
        return pulumi.get(self, "func_graph_policies")

    @func_graph_policies.setter
    def func_graph_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiFuncGraphPolicyArgs']]]]):
        pulumi.set(self, "func_graph_policies", value)

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the API group to which the API belongs.
        """
        return pulumi.get(self, "group_id")

    @group_id.setter
    def group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_id", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the instance to which the API belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="isSendFgBodyBase64")
    def is_send_fg_body_base64(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to perform Base64 encoding on the body for interaction with FunctionGraph.
        """
        return pulumi.get(self, "is_send_fg_body_base64")

    @is_send_fg_body_base64.setter
    def is_send_fg_body_base64(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_send_fg_body_base64", value)

    @_builtins.property
    @pulumi.getter
    def matching(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The matching mode of the API.
        """
        return pulumi.get(self, "matching")

    @matching.setter
    def matching(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "matching", value)

    @_builtins.property
    @pulumi.getter
    def mock(self) -> Optional[pulumi.Input['ApiMockArgs']]:
        """
        The mock backend details.
        """
        return pulumi.get(self, "mock")

    @mock.setter
    def mock(self, value: Optional[pulumi.Input['ApiMockArgs']]):
        pulumi.set(self, "mock", value)

    @_builtins.property
    @pulumi.getter(name="mockPolicies")
    def mock_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyArgs']]]]:
        """
        The mock policy backends.
        """
        return pulumi.get(self, "mock_policies")

    @mock_policies.setter
    def mock_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiMockPolicyArgs']]]]):
        pulumi.set(self, "mock_policies", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the API is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="registeredAt")
    def registered_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The registered time of the API.
        """
        return pulumi.get(self, "registered_at")

    @registered_at.setter
    def registered_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "registered_at", value)

    @_builtins.property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The request method of the API.
        """
        return pulumi.get(self, "request_method")

    @request_method.setter
    def request_method(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_method", value)

    @_builtins.property
    @pulumi.getter(name="requestParams")
    def request_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParamArgs']]]]:
        """
        The configurations of the front-end parameters.
        """
        return pulumi.get(self, "request_params")

    @request_params.setter
    def request_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiRequestParamArgs']]]]):
        pulumi.set(self, "request_params", value)

    @_builtins.property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The request address.
        """
        return pulumi.get(self, "request_path")

    @request_path.setter
    def request_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_path", value)

    @_builtins.property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The request protocol of the API request.
        """
        return pulumi.get(self, "request_protocol")

    @request_protocol.setter
    def request_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "request_protocol", value)

    @_builtins.property
    @pulumi.getter(name="responseId")
    def response_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the custom response that API used.
        """
        return pulumi.get(self, "response_id")

    @response_id.setter
    def response_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "response_id", value)

    @_builtins.property
    @pulumi.getter(name="securityAuthentication")
    def security_authentication(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The security authentication mode of the API request.
        """
        return pulumi.get(self, "security_authentication")

    @security_authentication.setter
    def security_authentication(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_authentication", value)

    @_builtins.property
    @pulumi.getter(name="simpleAuthentication")
    def simple_authentication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the authentication of the application code is enabled.
        """
        return pulumi.get(self, "simple_authentication")

    @simple_authentication.setter
    def simple_authentication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "simple_authentication", value)

    @_builtins.property
    @pulumi.getter(name="successResponse")
    def success_response(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The example response for a successful request.
        """
        return pulumi.get(self, "success_response")

    @success_response.setter
    def success_response(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "success_response", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of tags configuration.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest update time of the API.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter
    def web(self) -> Optional[pulumi.Input['ApiWebArgs']]:
        """
        The web backend details.
        """
        return pulumi.get(self, "web")

    @web.setter
    def web(self, value: Optional[pulumi.Input['ApiWebArgs']]):
        pulumi.set(self, "web", value)

    @_builtins.property
    @pulumi.getter(name="webPolicies")
    def web_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyArgs']]]]:
        """
        The web policy backends.
        """
        return pulumi.get(self, "web_policies")

    @web_policies.setter
    def web_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ApiWebPolicyArgs']]]]):
        pulumi.set(self, "web_policies", value)


@pulumi.type_token("sbercloud:DedicatedApig/api:Api")
class Api(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorizer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backend_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiBackendParamArgs', 'ApiBackendParamArgsDict']]]]] = None,
                 body_description: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cors: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 failure_response: Optional[pulumi.Input[_builtins.str]] = None,
                 func_graph: Optional[pulumi.Input[Union['ApiFuncGraphArgs', 'ApiFuncGraphArgsDict']]] = None,
                 func_graph_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiFuncGraphPolicyArgs', 'ApiFuncGraphPolicyArgsDict']]]]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_send_fg_body_base64: Optional[pulumi.Input[_builtins.bool]] = None,
                 matching: Optional[pulumi.Input[_builtins.str]] = None,
                 mock: Optional[pulumi.Input[Union['ApiMockArgs', 'ApiMockArgsDict']]] = None,
                 mock_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiMockPolicyArgs', 'ApiMockPolicyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_method: Optional[pulumi.Input[_builtins.str]] = None,
                 request_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiRequestParamArgs', 'ApiRequestParamArgsDict']]]]] = None,
                 request_path: Optional[pulumi.Input[_builtins.str]] = None,
                 request_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 response_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_authentication: Optional[pulumi.Input[_builtins.str]] = None,
                 simple_authentication: Optional[pulumi.Input[_builtins.bool]] = None,
                 success_response: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 web: Optional[pulumi.Input[Union['ApiWebArgs', 'ApiWebArgsDict']]] = None,
                 web_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiWebPolicyArgs', 'ApiWebPolicyArgsDict']]]]] = None,
                 __props__=None):
        """
        Create a Api resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorizer_id: The ID of the authorizer to which the API request used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiBackendParamArgs', 'ApiBackendParamArgsDict']]]] backend_params: The configurations of the backend parameters.
        :param pulumi.Input[_builtins.str] body_description: The description of the API request body, which can be an example request body, media type or parameters.
        :param pulumi.Input[_builtins.str] content_type: The content type of the request body.
        :param pulumi.Input[_builtins.bool] cors: Whether CORS is supported.
        :param pulumi.Input[_builtins.str] description: The API description.
        :param pulumi.Input[_builtins.str] failure_response: The example response for a failure request.
        :param pulumi.Input[Union['ApiFuncGraphArgs', 'ApiFuncGraphArgsDict']] func_graph: The FunctionGraph backend details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiFuncGraphPolicyArgs', 'ApiFuncGraphPolicyArgsDict']]]] func_graph_policies: The policy backends of the FunctionGraph function.
        :param pulumi.Input[_builtins.str] group_id: The ID of the API group to which the API belongs.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance to which the API belongs.
        :param pulumi.Input[_builtins.bool] is_send_fg_body_base64: Whether to perform Base64 encoding on the body for interaction with FunctionGraph.
        :param pulumi.Input[_builtins.str] matching: The matching mode of the API.
        :param pulumi.Input[Union['ApiMockArgs', 'ApiMockArgsDict']] mock: The mock backend details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiMockPolicyArgs', 'ApiMockPolicyArgsDict']]]] mock_policies: The mock policy backends.
        :param pulumi.Input[_builtins.str] name: The API name.
        :param pulumi.Input[_builtins.str] region: The region where the API is located.
        :param pulumi.Input[_builtins.str] request_method: The request method of the API.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiRequestParamArgs', 'ApiRequestParamArgsDict']]]] request_params: The configurations of the front-end parameters.
        :param pulumi.Input[_builtins.str] request_path: The request address.
        :param pulumi.Input[_builtins.str] request_protocol: The request protocol of the API request.
        :param pulumi.Input[_builtins.str] response_id: The ID of the custom response that API used.
        :param pulumi.Input[_builtins.str] security_authentication: The security authentication mode of the API request.
        :param pulumi.Input[_builtins.bool] simple_authentication: Whether the authentication of the application code is enabled.
        :param pulumi.Input[_builtins.str] success_response: The example response for a successful request.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The list of tags configuration.
        :param pulumi.Input[_builtins.str] type: The API type.
        :param pulumi.Input[Union['ApiWebArgs', 'ApiWebArgsDict']] web: The web backend details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiWebPolicyArgs', 'ApiWebPolicyArgsDict']]]] web_policies: The web policy backends.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Api resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ApiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorizer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 backend_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiBackendParamArgs', 'ApiBackendParamArgsDict']]]]] = None,
                 body_description: Optional[pulumi.Input[_builtins.str]] = None,
                 content_type: Optional[pulumi.Input[_builtins.str]] = None,
                 cors: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 failure_response: Optional[pulumi.Input[_builtins.str]] = None,
                 func_graph: Optional[pulumi.Input[Union['ApiFuncGraphArgs', 'ApiFuncGraphArgsDict']]] = None,
                 func_graph_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiFuncGraphPolicyArgs', 'ApiFuncGraphPolicyArgsDict']]]]] = None,
                 group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_send_fg_body_base64: Optional[pulumi.Input[_builtins.bool]] = None,
                 matching: Optional[pulumi.Input[_builtins.str]] = None,
                 mock: Optional[pulumi.Input[Union['ApiMockArgs', 'ApiMockArgsDict']]] = None,
                 mock_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiMockPolicyArgs', 'ApiMockPolicyArgsDict']]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 request_method: Optional[pulumi.Input[_builtins.str]] = None,
                 request_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiRequestParamArgs', 'ApiRequestParamArgsDict']]]]] = None,
                 request_path: Optional[pulumi.Input[_builtins.str]] = None,
                 request_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 response_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_authentication: Optional[pulumi.Input[_builtins.str]] = None,
                 simple_authentication: Optional[pulumi.Input[_builtins.bool]] = None,
                 success_response: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 web: Optional[pulumi.Input[Union['ApiWebArgs', 'ApiWebArgsDict']]] = None,
                 web_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiWebPolicyArgs', 'ApiWebPolicyArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiArgs.__new__(ApiArgs)

            __props__.__dict__["authorizer_id"] = authorizer_id
            __props__.__dict__["backend_params"] = backend_params
            __props__.__dict__["body_description"] = body_description
            __props__.__dict__["content_type"] = content_type
            __props__.__dict__["cors"] = cors
            __props__.__dict__["description"] = description
            __props__.__dict__["failure_response"] = failure_response
            __props__.__dict__["func_graph"] = func_graph
            __props__.__dict__["func_graph_policies"] = func_graph_policies
            if group_id is None and not opts.urn:
                raise TypeError("Missing required property 'group_id'")
            __props__.__dict__["group_id"] = group_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["is_send_fg_body_base64"] = is_send_fg_body_base64
            __props__.__dict__["matching"] = matching
            __props__.__dict__["mock"] = mock
            __props__.__dict__["mock_policies"] = mock_policies
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if request_method is None and not opts.urn:
                raise TypeError("Missing required property 'request_method'")
            __props__.__dict__["request_method"] = request_method
            __props__.__dict__["request_params"] = request_params
            if request_path is None and not opts.urn:
                raise TypeError("Missing required property 'request_path'")
            __props__.__dict__["request_path"] = request_path
            if request_protocol is None and not opts.urn:
                raise TypeError("Missing required property 'request_protocol'")
            __props__.__dict__["request_protocol"] = request_protocol
            __props__.__dict__["response_id"] = response_id
            __props__.__dict__["security_authentication"] = security_authentication
            __props__.__dict__["simple_authentication"] = simple_authentication
            __props__.__dict__["success_response"] = success_response
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["web"] = web
            __props__.__dict__["web_policies"] = web_policies
            __props__.__dict__["registered_at"] = None
            __props__.__dict__["updated_at"] = None
        super(Api, __self__).__init__(
            'sbercloud:DedicatedApig/api:Api',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorizer_id: Optional[pulumi.Input[_builtins.str]] = None,
            backend_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiBackendParamArgs', 'ApiBackendParamArgsDict']]]]] = None,
            body_description: Optional[pulumi.Input[_builtins.str]] = None,
            content_type: Optional[pulumi.Input[_builtins.str]] = None,
            cors: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            failure_response: Optional[pulumi.Input[_builtins.str]] = None,
            func_graph: Optional[pulumi.Input[Union['ApiFuncGraphArgs', 'ApiFuncGraphArgsDict']]] = None,
            func_graph_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiFuncGraphPolicyArgs', 'ApiFuncGraphPolicyArgsDict']]]]] = None,
            group_id: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_send_fg_body_base64: Optional[pulumi.Input[_builtins.bool]] = None,
            matching: Optional[pulumi.Input[_builtins.str]] = None,
            mock: Optional[pulumi.Input[Union['ApiMockArgs', 'ApiMockArgsDict']]] = None,
            mock_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiMockPolicyArgs', 'ApiMockPolicyArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            registered_at: Optional[pulumi.Input[_builtins.str]] = None,
            request_method: Optional[pulumi.Input[_builtins.str]] = None,
            request_params: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiRequestParamArgs', 'ApiRequestParamArgsDict']]]]] = None,
            request_path: Optional[pulumi.Input[_builtins.str]] = None,
            request_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            response_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_authentication: Optional[pulumi.Input[_builtins.str]] = None,
            simple_authentication: Optional[pulumi.Input[_builtins.bool]] = None,
            success_response: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            web: Optional[pulumi.Input[Union['ApiWebArgs', 'ApiWebArgsDict']]] = None,
            web_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ApiWebPolicyArgs', 'ApiWebPolicyArgsDict']]]]] = None) -> 'Api':
        """
        Get an existing Api resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] authorizer_id: The ID of the authorizer to which the API request used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiBackendParamArgs', 'ApiBackendParamArgsDict']]]] backend_params: The configurations of the backend parameters.
        :param pulumi.Input[_builtins.str] body_description: The description of the API request body, which can be an example request body, media type or parameters.
        :param pulumi.Input[_builtins.str] content_type: The content type of the request body.
        :param pulumi.Input[_builtins.bool] cors: Whether CORS is supported.
        :param pulumi.Input[_builtins.str] description: The API description.
        :param pulumi.Input[_builtins.str] failure_response: The example response for a failure request.
        :param pulumi.Input[Union['ApiFuncGraphArgs', 'ApiFuncGraphArgsDict']] func_graph: The FunctionGraph backend details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiFuncGraphPolicyArgs', 'ApiFuncGraphPolicyArgsDict']]]] func_graph_policies: The policy backends of the FunctionGraph function.
        :param pulumi.Input[_builtins.str] group_id: The ID of the API group to which the API belongs.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the instance to which the API belongs.
        :param pulumi.Input[_builtins.bool] is_send_fg_body_base64: Whether to perform Base64 encoding on the body for interaction with FunctionGraph.
        :param pulumi.Input[_builtins.str] matching: The matching mode of the API.
        :param pulumi.Input[Union['ApiMockArgs', 'ApiMockArgsDict']] mock: The mock backend details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiMockPolicyArgs', 'ApiMockPolicyArgsDict']]]] mock_policies: The mock policy backends.
        :param pulumi.Input[_builtins.str] name: The API name.
        :param pulumi.Input[_builtins.str] region: The region where the API is located.
        :param pulumi.Input[_builtins.str] registered_at: The registered time of the API.
        :param pulumi.Input[_builtins.str] request_method: The request method of the API.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiRequestParamArgs', 'ApiRequestParamArgsDict']]]] request_params: The configurations of the front-end parameters.
        :param pulumi.Input[_builtins.str] request_path: The request address.
        :param pulumi.Input[_builtins.str] request_protocol: The request protocol of the API request.
        :param pulumi.Input[_builtins.str] response_id: The ID of the custom response that API used.
        :param pulumi.Input[_builtins.str] security_authentication: The security authentication mode of the API request.
        :param pulumi.Input[_builtins.bool] simple_authentication: Whether the authentication of the application code is enabled.
        :param pulumi.Input[_builtins.str] success_response: The example response for a successful request.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] tags: The list of tags configuration.
        :param pulumi.Input[_builtins.str] type: The API type.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time of the API.
        :param pulumi.Input[Union['ApiWebArgs', 'ApiWebArgsDict']] web: The web backend details.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ApiWebPolicyArgs', 'ApiWebPolicyArgsDict']]]] web_policies: The web policy backends.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiState.__new__(_ApiState)

        __props__.__dict__["authorizer_id"] = authorizer_id
        __props__.__dict__["backend_params"] = backend_params
        __props__.__dict__["body_description"] = body_description
        __props__.__dict__["content_type"] = content_type
        __props__.__dict__["cors"] = cors
        __props__.__dict__["description"] = description
        __props__.__dict__["failure_response"] = failure_response
        __props__.__dict__["func_graph"] = func_graph
        __props__.__dict__["func_graph_policies"] = func_graph_policies
        __props__.__dict__["group_id"] = group_id
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["is_send_fg_body_base64"] = is_send_fg_body_base64
        __props__.__dict__["matching"] = matching
        __props__.__dict__["mock"] = mock
        __props__.__dict__["mock_policies"] = mock_policies
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["registered_at"] = registered_at
        __props__.__dict__["request_method"] = request_method
        __props__.__dict__["request_params"] = request_params
        __props__.__dict__["request_path"] = request_path
        __props__.__dict__["request_protocol"] = request_protocol
        __props__.__dict__["response_id"] = response_id
        __props__.__dict__["security_authentication"] = security_authentication
        __props__.__dict__["simple_authentication"] = simple_authentication
        __props__.__dict__["success_response"] = success_response
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["web"] = web
        __props__.__dict__["web_policies"] = web_policies
        return Api(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorizerId")
    def authorizer_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the authorizer to which the API request used.
        """
        return pulumi.get(self, "authorizer_id")

    @_builtins.property
    @pulumi.getter(name="backendParams")
    def backend_params(self) -> pulumi.Output[Optional[Sequence['outputs.ApiBackendParam']]]:
        """
        The configurations of the backend parameters.
        """
        return pulumi.get(self, "backend_params")

    @_builtins.property
    @pulumi.getter(name="bodyDescription")
    def body_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the API request body, which can be an example request body, media type or parameters.
        """
        return pulumi.get(self, "body_description")

    @_builtins.property
    @pulumi.getter(name="contentType")
    def content_type(self) -> pulumi.Output[_builtins.str]:
        """
        The content type of the request body.
        """
        return pulumi.get(self, "content_type")

    @_builtins.property
    @pulumi.getter
    def cors(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether CORS is supported.
        """
        return pulumi.get(self, "cors")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The API description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="failureResponse")
    def failure_response(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The example response for a failure request.
        """
        return pulumi.get(self, "failure_response")

    @_builtins.property
    @pulumi.getter(name="funcGraph")
    def func_graph(self) -> pulumi.Output['outputs.ApiFuncGraph']:
        """
        The FunctionGraph backend details.
        """
        return pulumi.get(self, "func_graph")

    @_builtins.property
    @pulumi.getter(name="funcGraphPolicies")
    def func_graph_policies(self) -> pulumi.Output[Optional[Sequence['outputs.ApiFuncGraphPolicy']]]:
        """
        The policy backends of the FunctionGraph function.
        """
        return pulumi.get(self, "func_graph_policies")

    @_builtins.property
    @pulumi.getter(name="groupId")
    def group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the API group to which the API belongs.
        """
        return pulumi.get(self, "group_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the instance to which the API belongs.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="isSendFgBodyBase64")
    def is_send_fg_body_base64(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to perform Base64 encoding on the body for interaction with FunctionGraph.
        """
        return pulumi.get(self, "is_send_fg_body_base64")

    @_builtins.property
    @pulumi.getter
    def matching(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The matching mode of the API.
        """
        return pulumi.get(self, "matching")

    @_builtins.property
    @pulumi.getter
    def mock(self) -> pulumi.Output['outputs.ApiMock']:
        """
        The mock backend details.
        """
        return pulumi.get(self, "mock")

    @_builtins.property
    @pulumi.getter(name="mockPolicies")
    def mock_policies(self) -> pulumi.Output[Optional[Sequence['outputs.ApiMockPolicy']]]:
        """
        The mock policy backends.
        """
        return pulumi.get(self, "mock_policies")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The API name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the API is located.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="registeredAt")
    def registered_at(self) -> pulumi.Output[_builtins.str]:
        """
        The registered time of the API.
        """
        return pulumi.get(self, "registered_at")

    @_builtins.property
    @pulumi.getter(name="requestMethod")
    def request_method(self) -> pulumi.Output[_builtins.str]:
        """
        The request method of the API.
        """
        return pulumi.get(self, "request_method")

    @_builtins.property
    @pulumi.getter(name="requestParams")
    def request_params(self) -> pulumi.Output[Sequence['outputs.ApiRequestParam']]:
        """
        The configurations of the front-end parameters.
        """
        return pulumi.get(self, "request_params")

    @_builtins.property
    @pulumi.getter(name="requestPath")
    def request_path(self) -> pulumi.Output[_builtins.str]:
        """
        The request address.
        """
        return pulumi.get(self, "request_path")

    @_builtins.property
    @pulumi.getter(name="requestProtocol")
    def request_protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The request protocol of the API request.
        """
        return pulumi.get(self, "request_protocol")

    @_builtins.property
    @pulumi.getter(name="responseId")
    def response_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the custom response that API used.
        """
        return pulumi.get(self, "response_id")

    @_builtins.property
    @pulumi.getter(name="securityAuthentication")
    def security_authentication(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The security authentication mode of the API request.
        """
        return pulumi.get(self, "security_authentication")

    @_builtins.property
    @pulumi.getter(name="simpleAuthentication")
    def simple_authentication(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the authentication of the application code is enabled.
        """
        return pulumi.get(self, "simple_authentication")

    @_builtins.property
    @pulumi.getter(name="successResponse")
    def success_response(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The example response for a successful request.
        """
        return pulumi.get(self, "success_response")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        The list of tags configuration.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The API type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The latest update time of the API.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter
    def web(self) -> pulumi.Output['outputs.ApiWeb']:
        """
        The web backend details.
        """
        return pulumi.get(self, "web")

    @_builtins.property
    @pulumi.getter(name="webPolicies")
    def web_policies(self) -> pulumi.Output[Optional[Sequence['outputs.ApiWebPolicy']]]:
        """
        The web policy backends.
        """
        return pulumi.get(self, "web_policies")

