# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ApplicationArgs', 'Application']

@pulumi.input_type
class ApplicationArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 app_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_action: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Application resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the application belongs.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] app_codes: The array of one or more application codes that the application has.
        :param pulumi.Input[_builtins.str] description: The application description.
        :param pulumi.Input[_builtins.str] name: The application name.
        :param pulumi.Input[_builtins.str] region: The region where the application is located.
        :param pulumi.Input[_builtins.str] secret_action: The secret action to be done for the application.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if app_codes is not None:
            pulumi.set(__self__, "app_codes", app_codes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_action is not None:
            pulumi.set(__self__, "secret_action", secret_action)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the dedicated instance to which the application belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="appCodes")
    def app_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The array of one or more application codes that the application has.
        """
        return pulumi.get(self, "app_codes")

    @app_codes.setter
    def app_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "app_codes", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the application is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretAction")
    def secret_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret action to be done for the application.
        """
        return pulumi.get(self, "secret_action")

    @secret_action.setter
    def secret_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_action", value)


@pulumi.input_type
class _ApplicationState:
    def __init__(__self__, *,
                 app_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 app_key: Optional[pulumi.Input[_builtins.str]] = None,
                 app_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 registration_time: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_action: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Application resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] app_codes: The array of one or more application codes that the application has.
        :param pulumi.Input[_builtins.str] app_key: The APP key.
        :param pulumi.Input[_builtins.str] app_secret: The APP secret.
        :param pulumi.Input[_builtins.str] description: The application description.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the application belongs.
        :param pulumi.Input[_builtins.str] name: The application name.
        :param pulumi.Input[_builtins.str] region: The region where the application is located.
        :param pulumi.Input[_builtins.str] registration_time: The registration time.
        :param pulumi.Input[_builtins.str] secret_action: The secret action to be done for the application.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time of the application.
        """
        if app_codes is not None:
            pulumi.set(__self__, "app_codes", app_codes)
        if app_key is not None:
            pulumi.set(__self__, "app_key", app_key)
        if app_secret is not None:
            pulumi.set(__self__, "app_secret", app_secret)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if registration_time is not None:
            pulumi.set(__self__, "registration_time", registration_time)
        if secret_action is not None:
            pulumi.set(__self__, "secret_action", secret_action)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="appCodes")
    def app_codes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The array of one or more application codes that the application has.
        """
        return pulumi.get(self, "app_codes")

    @app_codes.setter
    def app_codes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "app_codes", value)

    @_builtins.property
    @pulumi.getter(name="appKey")
    def app_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The APP key.
        """
        return pulumi.get(self, "app_key")

    @app_key.setter
    def app_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_key", value)

    @_builtins.property
    @pulumi.getter(name="appSecret")
    def app_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The APP secret.
        """
        return pulumi.get(self, "app_secret")

    @app_secret.setter
    def app_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_secret", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated instance to which the application belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the application is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="registrationTime")
    def registration_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The registration time.
        """
        return pulumi.get(self, "registration_time")

    @registration_time.setter
    def registration_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "registration_time", value)

    @_builtins.property
    @pulumi.getter(name="secretAction")
    def secret_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secret action to be done for the application.
        """
        return pulumi.get(self, "secret_action")

    @secret_action.setter
    def secret_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_action", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The latest update time of the application.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:DedicatedApig/application:Application")
class Application(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_action: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a Application resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] app_codes: The array of one or more application codes that the application has.
        :param pulumi.Input[_builtins.str] description: The application description.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the application belongs.
        :param pulumi.Input[_builtins.str] name: The application name.
        :param pulumi.Input[_builtins.str] region: The region where the application is located.
        :param pulumi.Input[_builtins.str] secret_action: The secret action to be done for the application.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Application resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_action: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApplicationArgs.__new__(ApplicationArgs)

            __props__.__dict__["app_codes"] = app_codes
            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["secret_action"] = secret_action
            __props__.__dict__["app_key"] = None
            __props__.__dict__["app_secret"] = None
            __props__.__dict__["registration_time"] = None
            __props__.__dict__["updated_at"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["appSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Application, __self__).__init__(
            'sbercloud:DedicatedApig/application:Application',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_codes: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            app_key: Optional[pulumi.Input[_builtins.str]] = None,
            app_secret: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            registration_time: Optional[pulumi.Input[_builtins.str]] = None,
            secret_action: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'Application':
        """
        Get an existing Application resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] app_codes: The array of one or more application codes that the application has.
        :param pulumi.Input[_builtins.str] app_key: The APP key.
        :param pulumi.Input[_builtins.str] app_secret: The APP secret.
        :param pulumi.Input[_builtins.str] description: The application description.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the application belongs.
        :param pulumi.Input[_builtins.str] name: The application name.
        :param pulumi.Input[_builtins.str] region: The region where the application is located.
        :param pulumi.Input[_builtins.str] registration_time: The registration time.
        :param pulumi.Input[_builtins.str] secret_action: The secret action to be done for the application.
        :param pulumi.Input[_builtins.str] updated_at: The latest update time of the application.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApplicationState.__new__(_ApplicationState)

        __props__.__dict__["app_codes"] = app_codes
        __props__.__dict__["app_key"] = app_key
        __props__.__dict__["app_secret"] = app_secret
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["registration_time"] = registration_time
        __props__.__dict__["secret_action"] = secret_action
        __props__.__dict__["updated_at"] = updated_at
        return Application(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appCodes")
    def app_codes(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The array of one or more application codes that the application has.
        """
        return pulumi.get(self, "app_codes")

    @_builtins.property
    @pulumi.getter(name="appKey")
    def app_key(self) -> pulumi.Output[_builtins.str]:
        """
        The APP key.
        """
        return pulumi.get(self, "app_key")

    @_builtins.property
    @pulumi.getter(name="appSecret")
    def app_secret(self) -> pulumi.Output[_builtins.str]:
        """
        The APP secret.
        """
        return pulumi.get(self, "app_secret")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        The application description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the dedicated instance to which the application belongs.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The application name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the application is located.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="registrationTime")
    def registration_time(self) -> pulumi.Output[_builtins.str]:
        """
        The registration time.
        """
        return pulumi.get(self, "registration_time")

    @_builtins.property
    @pulumi.getter(name="secretAction")
    def secret_action(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The secret action to be done for the application.
        """
        return pulumi.get(self, "secret_action")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The latest update time of the application.
        """
        return pulumi.get(self, "updated_at")

