# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomAuthorizerArgs', 'CustomAuthorizer']

@pulumi.input_type
class CustomAuthorizerArgs:
    def __init__(__self__, *,
                 function_urn: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 cache_age: Optional[pulumi.Input[_builtins.int]] = None,
                 function_alias_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 function_version: Optional[pulumi.Input[_builtins.str]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input['CustomAuthorizerIdentityArgs']]]] = None,
                 is_body_send: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CustomAuthorizer resource.
        :param pulumi.Input[_builtins.str] function_urn: The URN of the FGS function.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the custom authorizer belongs.
        :param pulumi.Input[_builtins.int] cache_age: The maximum cache age.
        :param pulumi.Input[_builtins.str] function_alias_uri: The version alias URI of the FGS function.
        :param pulumi.Input[_builtins.str] function_version: The version of the FGS function.
        :param pulumi.Input[Sequence[pulumi.Input['CustomAuthorizerIdentityArgs']]] identities: The array of one or more parameter identities of the custom authorizer.
        :param pulumi.Input[_builtins.bool] is_body_send: Whether to send the body.
        :param pulumi.Input[_builtins.str] name: The name of the custom authorizer.
        :param pulumi.Input[_builtins.str] network_type: The framework type of the function.
        :param pulumi.Input[_builtins.str] region: The region where the custom authorizer is located.
        :param pulumi.Input[_builtins.str] type: The custom authorization type
        :param pulumi.Input[_builtins.str] user_data: The user data for custom authorizer function.
        """
        pulumi.set(__self__, "function_urn", function_urn)
        pulumi.set(__self__, "instance_id", instance_id)
        if cache_age is not None:
            pulumi.set(__self__, "cache_age", cache_age)
        if function_alias_uri is not None:
            pulumi.set(__self__, "function_alias_uri", function_alias_uri)
        if function_version is not None:
            pulumi.set(__self__, "function_version", function_version)
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if is_body_send is not None:
            pulumi.set(__self__, "is_body_send", is_body_send)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> pulumi.Input[_builtins.str]:
        """
        The URN of the FGS function.
        """
        return pulumi.get(self, "function_urn")

    @function_urn.setter
    def function_urn(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "function_urn", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the dedicated instance to which the custom authorizer belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="cacheAge")
    def cache_age(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum cache age.
        """
        return pulumi.get(self, "cache_age")

    @cache_age.setter
    def cache_age(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_age", value)

    @_builtins.property
    @pulumi.getter(name="functionAliasUri")
    def function_alias_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version alias URI of the FGS function.
        """
        return pulumi.get(self, "function_alias_uri")

    @function_alias_uri.setter
    def function_alias_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_alias_uri", value)

    @_builtins.property
    @pulumi.getter(name="functionVersion")
    def function_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the FGS function.
        """
        return pulumi.get(self, "function_version")

    @function_version.setter
    def function_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_version", value)

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomAuthorizerIdentityArgs']]]]:
        """
        The array of one or more parameter identities of the custom authorizer.
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomAuthorizerIdentityArgs']]]]):
        pulumi.set(self, "identities", value)

    @_builtins.property
    @pulumi.getter(name="isBodySend")
    def is_body_send(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to send the body.
        """
        return pulumi.get(self, "is_body_send")

    @is_body_send.setter
    def is_body_send(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_body_send", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the custom authorizer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The framework type of the function.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the custom authorizer is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The custom authorization type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user data for custom authorizer function.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class _CustomAuthorizerState:
    def __init__(__self__, *,
                 cache_age: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 function_alias_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 function_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 function_version: Optional[pulumi.Input[_builtins.str]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input['CustomAuthorizerIdentityArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_body_send: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomAuthorizer resources.
        :param pulumi.Input[_builtins.int] cache_age: The maximum cache age.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the custom authorizer.
        :param pulumi.Input[_builtins.str] function_alias_uri: The version alias URI of the FGS function.
        :param pulumi.Input[_builtins.str] function_urn: The URN of the FGS function.
        :param pulumi.Input[_builtins.str] function_version: The version of the FGS function.
        :param pulumi.Input[Sequence[pulumi.Input['CustomAuthorizerIdentityArgs']]] identities: The array of one or more parameter identities of the custom authorizer.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the custom authorizer belongs.
        :param pulumi.Input[_builtins.bool] is_body_send: Whether to send the body.
        :param pulumi.Input[_builtins.str] name: The name of the custom authorizer.
        :param pulumi.Input[_builtins.str] network_type: The framework type of the function.
        :param pulumi.Input[_builtins.str] region: The region where the custom authorizer is located.
        :param pulumi.Input[_builtins.str] type: The custom authorization type
        :param pulumi.Input[_builtins.str] user_data: The user data for custom authorizer function.
        """
        if cache_age is not None:
            pulumi.set(__self__, "cache_age", cache_age)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if function_alias_uri is not None:
            pulumi.set(__self__, "function_alias_uri", function_alias_uri)
        if function_urn is not None:
            pulumi.set(__self__, "function_urn", function_urn)
        if function_version is not None:
            pulumi.set(__self__, "function_version", function_version)
        if identities is not None:
            pulumi.set(__self__, "identities", identities)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if is_body_send is not None:
            pulumi.set(__self__, "is_body_send", is_body_send)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @_builtins.property
    @pulumi.getter(name="cacheAge")
    def cache_age(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum cache age.
        """
        return pulumi.get(self, "cache_age")

    @cache_age.setter
    def cache_age(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cache_age", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the custom authorizer.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="functionAliasUri")
    def function_alias_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version alias URI of the FGS function.
        """
        return pulumi.get(self, "function_alias_uri")

    @function_alias_uri.setter
    def function_alias_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_alias_uri", value)

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URN of the FGS function.
        """
        return pulumi.get(self, "function_urn")

    @function_urn.setter
    def function_urn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_urn", value)

    @_builtins.property
    @pulumi.getter(name="functionVersion")
    def function_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the FGS function.
        """
        return pulumi.get(self, "function_version")

    @function_version.setter
    def function_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "function_version", value)

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CustomAuthorizerIdentityArgs']]]]:
        """
        The array of one or more parameter identities of the custom authorizer.
        """
        return pulumi.get(self, "identities")

    @identities.setter
    def identities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CustomAuthorizerIdentityArgs']]]]):
        pulumi.set(self, "identities", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated instance to which the custom authorizer belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="isBodySend")
    def is_body_send(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to send the body.
        """
        return pulumi.get(self, "is_body_send")

    @is_body_send.setter
    def is_body_send(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_body_send", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the custom authorizer.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The framework type of the function.
        """
        return pulumi.get(self, "network_type")

    @network_type.setter
    def network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the custom authorizer is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The custom authorization type
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user data for custom authorizer function.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)


@pulumi.type_token("sbercloud:DedicatedApig/customAuthorizer:CustomAuthorizer")
class CustomAuthorizer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_age: Optional[pulumi.Input[_builtins.int]] = None,
                 function_alias_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 function_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 function_version: Optional[pulumi.Input[_builtins.str]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomAuthorizerIdentityArgs', 'CustomAuthorizerIdentityArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_body_send: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a CustomAuthorizer resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cache_age: The maximum cache age.
        :param pulumi.Input[_builtins.str] function_alias_uri: The version alias URI of the FGS function.
        :param pulumi.Input[_builtins.str] function_urn: The URN of the FGS function.
        :param pulumi.Input[_builtins.str] function_version: The version of the FGS function.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomAuthorizerIdentityArgs', 'CustomAuthorizerIdentityArgsDict']]]] identities: The array of one or more parameter identities of the custom authorizer.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the custom authorizer belongs.
        :param pulumi.Input[_builtins.bool] is_body_send: Whether to send the body.
        :param pulumi.Input[_builtins.str] name: The name of the custom authorizer.
        :param pulumi.Input[_builtins.str] network_type: The framework type of the function.
        :param pulumi.Input[_builtins.str] region: The region where the custom authorizer is located.
        :param pulumi.Input[_builtins.str] type: The custom authorization type
        :param pulumi.Input[_builtins.str] user_data: The user data for custom authorizer function.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomAuthorizerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a CustomAuthorizer resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param CustomAuthorizerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomAuthorizerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cache_age: Optional[pulumi.Input[_builtins.int]] = None,
                 function_alias_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 function_urn: Optional[pulumi.Input[_builtins.str]] = None,
                 function_version: Optional[pulumi.Input[_builtins.str]] = None,
                 identities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomAuthorizerIdentityArgs', 'CustomAuthorizerIdentityArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_body_send: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomAuthorizerArgs.__new__(CustomAuthorizerArgs)

            __props__.__dict__["cache_age"] = cache_age
            __props__.__dict__["function_alias_uri"] = function_alias_uri
            if function_urn is None and not opts.urn:
                raise TypeError("Missing required property 'function_urn'")
            __props__.__dict__["function_urn"] = function_urn
            __props__.__dict__["function_version"] = function_version
            __props__.__dict__["identities"] = identities
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["is_body_send"] = is_body_send
            __props__.__dict__["name"] = name
            __props__.__dict__["network_type"] = network_type
            __props__.__dict__["region"] = region
            __props__.__dict__["type"] = type
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["created_at"] = None
        super(CustomAuthorizer, __self__).__init__(
            'sbercloud:DedicatedApig/customAuthorizer:CustomAuthorizer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cache_age: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            function_alias_uri: Optional[pulumi.Input[_builtins.str]] = None,
            function_urn: Optional[pulumi.Input[_builtins.str]] = None,
            function_version: Optional[pulumi.Input[_builtins.str]] = None,
            identities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['CustomAuthorizerIdentityArgs', 'CustomAuthorizerIdentityArgsDict']]]]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_body_send: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_type: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None) -> 'CustomAuthorizer':
        """
        Get an existing CustomAuthorizer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cache_age: The maximum cache age.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the custom authorizer.
        :param pulumi.Input[_builtins.str] function_alias_uri: The version alias URI of the FGS function.
        :param pulumi.Input[_builtins.str] function_urn: The URN of the FGS function.
        :param pulumi.Input[_builtins.str] function_version: The version of the FGS function.
        :param pulumi.Input[Sequence[pulumi.Input[Union['CustomAuthorizerIdentityArgs', 'CustomAuthorizerIdentityArgsDict']]]] identities: The array of one or more parameter identities of the custom authorizer.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the custom authorizer belongs.
        :param pulumi.Input[_builtins.bool] is_body_send: Whether to send the body.
        :param pulumi.Input[_builtins.str] name: The name of the custom authorizer.
        :param pulumi.Input[_builtins.str] network_type: The framework type of the function.
        :param pulumi.Input[_builtins.str] region: The region where the custom authorizer is located.
        :param pulumi.Input[_builtins.str] type: The custom authorization type
        :param pulumi.Input[_builtins.str] user_data: The user data for custom authorizer function.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomAuthorizerState.__new__(_CustomAuthorizerState)

        __props__.__dict__["cache_age"] = cache_age
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["function_alias_uri"] = function_alias_uri
        __props__.__dict__["function_urn"] = function_urn
        __props__.__dict__["function_version"] = function_version
        __props__.__dict__["identities"] = identities
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["is_body_send"] = is_body_send
        __props__.__dict__["name"] = name
        __props__.__dict__["network_type"] = network_type
        __props__.__dict__["region"] = region
        __props__.__dict__["type"] = type
        __props__.__dict__["user_data"] = user_data
        return CustomAuthorizer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cacheAge")
    def cache_age(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum cache age.
        """
        return pulumi.get(self, "cache_age")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the custom authorizer.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="functionAliasUri")
    def function_alias_uri(self) -> pulumi.Output[_builtins.str]:
        """
        The version alias URI of the FGS function.
        """
        return pulumi.get(self, "function_alias_uri")

    @_builtins.property
    @pulumi.getter(name="functionUrn")
    def function_urn(self) -> pulumi.Output[_builtins.str]:
        """
        The URN of the FGS function.
        """
        return pulumi.get(self, "function_urn")

    @_builtins.property
    @pulumi.getter(name="functionVersion")
    def function_version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the FGS function.
        """
        return pulumi.get(self, "function_version")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> pulumi.Output[Optional[Sequence['outputs.CustomAuthorizerIdentity']]]:
        """
        The array of one or more parameter identities of the custom authorizer.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the dedicated instance to which the custom authorizer belongs.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="isBodySend")
    def is_body_send(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to send the body.
        """
        return pulumi.get(self, "is_body_send")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the custom authorizer.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkType")
    def network_type(self) -> pulumi.Output[_builtins.str]:
        """
        The framework type of the function.
        """
        return pulumi.get(self, "network_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the custom authorizer is located.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The custom authorization type
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user data for custom authorizer function.
        """
        return pulumi.get(self, "user_data")

