# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 edition: pulumi.Input[_builtins.str],
                 security_group_id: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bandwidth_size: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_ingress_ports: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceCustomIngressPortArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_bandwidth_charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_bandwidth_size: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 loadbalancer_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpcep_service_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[_builtins.str] edition: The edition of the dedicated instance.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the dedicated instance belongs to.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the VPC subnet used to create the dedicated instance.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC used to create the dedicated instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: schema: Required; The name list of availability zones for the dedicated instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] available_zones: schema: Deprecated; The name list of availability zones for the dedicated instance.
        :param pulumi.Input[_builtins.int] bandwidth_size: The egress bandwidth size of the dedicated instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceCustomIngressPortArgs']]] custom_ingress_ports: Specified the list of the instance custom ingress ports.
        :param pulumi.Input[_builtins.str] description: The description of the dedicated instance.
        :param pulumi.Input[_builtins.str] eip_id: The EIP ID associated with the dedicated instance.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID to which the dedicated instance belongs.
        :param pulumi.Input[_builtins.bool] ipv6_enable: Whether public access with an IPv6 address is supported.
        :param pulumi.Input[_builtins.str] loadbalancer_provider: The type of loadbalancer provider used by the instance.
        :param pulumi.Input[_builtins.str] maintain_begin: The start time of the maintenance time window.
        :param pulumi.Input[_builtins.str] name: The name of the dedicated instance.
        :param pulumi.Input[_builtins.str] region: The region in which to create the dedicated instance resource.
        :param pulumi.Input[_builtins.str] vpcep_service_name: Name of the VPC endpoint service.
        """
        pulumi.set(__self__, "edition", edition)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if bandwidth_size is not None:
            pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        if custom_ingress_ports is not None:
            pulumi.set(__self__, "custom_ingress_ports", custom_ingress_ports)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ingress_bandwidth_charging_mode is not None:
            pulumi.set(__self__, "ingress_bandwidth_charging_mode", ingress_bandwidth_charging_mode)
        if ingress_bandwidth_size is not None:
            pulumi.set(__self__, "ingress_bandwidth_size", ingress_bandwidth_size)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if loadbalancer_provider is not None:
            pulumi.set(__self__, "loadbalancer_provider", loadbalancer_provider)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpcep_service_name is not None:
            pulumi.set(__self__, "vpcep_service_name", vpcep_service_name)

    @_builtins.property
    @pulumi.getter
    def edition(self) -> pulumi.Input[_builtins.str]:
        """
        The edition of the dedicated instance.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "edition", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the security group to which the dedicated instance belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPC subnet used to create the dedicated instance.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the VPC used to create the dedicated instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        schema: Required; The name list of availability zones for the dedicated instance.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        schema: Deprecated; The name list of availability zones for the dedicated instance.
        """
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "available_zones", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The egress bandwidth size of the dedicated instance.
        """
        return pulumi.get(self, "bandwidth_size")

    @bandwidth_size.setter
    def bandwidth_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth_size", value)

    @_builtins.property
    @pulumi.getter(name="customIngressPorts")
    def custom_ingress_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceCustomIngressPortArgs']]]]:
        """
        Specified the list of the instance custom ingress ports.
        """
        return pulumi.get(self, "custom_ingress_ports")

    @custom_ingress_ports.setter
    def custom_ingress_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceCustomIngressPortArgs']]]]):
        pulumi.set(self, "custom_ingress_ports", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the dedicated instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EIP ID associated with the dedicated instance.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eip_id", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project ID to which the dedicated instance belongs.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="ingressBandwidthChargingMode")
    def ingress_bandwidth_charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ingress_bandwidth_charging_mode")

    @ingress_bandwidth_charging_mode.setter
    def ingress_bandwidth_charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingress_bandwidth_charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="ingressBandwidthSize")
    def ingress_bandwidth_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "ingress_bandwidth_size")

    @ingress_bandwidth_size.setter
    def ingress_bandwidth_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ingress_bandwidth_size", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public access with an IPv6 address is supported.
        """
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enable", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerProvider")
    def loadbalancer_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of loadbalancer provider used by the instance.
        """
        return pulumi.get(self, "loadbalancer_provider")

    @loadbalancer_provider.setter
    def loadbalancer_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "loadbalancer_provider", value)

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time of the maintenance time window.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_begin", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the dedicated instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the dedicated instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcepServiceName")
    def vpcep_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the VPC endpoint service.
        """
        return pulumi.get(self, "vpcep_service_name")

    @vpcep_service_name.setter
    def vpcep_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpcep_service_name", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bandwidth_size: Optional[pulumi.Input[_builtins.int]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_ingress_ports: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceCustomIngressPortArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 edition: Optional[pulumi.Input[_builtins.str]] = None,
                 egress_address: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_address: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_bandwidth_charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_bandwidth_size: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 loadbalancer_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 supported_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_ingress_address: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcep_service_address: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcep_service_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: schema: Required; The name list of availability zones for the dedicated instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] available_zones: schema: Deprecated; The name list of availability zones for the dedicated instance.
        :param pulumi.Input[_builtins.int] bandwidth_size: The egress bandwidth size of the dedicated instance.
        :param pulumi.Input[_builtins.str] create_time: schema: Deprecated; Time when the dedicated instance is created.
        :param pulumi.Input[_builtins.str] created_at: Time when the dedicated instance is created, in RFC-3339 format.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceCustomIngressPortArgs']]] custom_ingress_ports: Specified the list of the instance custom ingress ports.
        :param pulumi.Input[_builtins.str] description: The description of the dedicated instance.
        :param pulumi.Input[_builtins.str] edition: The edition of the dedicated instance.
        :param pulumi.Input[_builtins.str] egress_address: The egress (NAT) public IP address.
        :param pulumi.Input[_builtins.str] eip_id: The EIP ID associated with the dedicated instance.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID to which the dedicated instance belongs.
        :param pulumi.Input[_builtins.str] ingress_address: The ingress EIP address.
        :param pulumi.Input[_builtins.bool] ipv6_enable: Whether public access with an IPv6 address is supported.
        :param pulumi.Input[_builtins.str] loadbalancer_provider: The type of loadbalancer provider used by the instance.
        :param pulumi.Input[_builtins.str] maintain_begin: The start time of the maintenance time window.
        :param pulumi.Input[_builtins.str] maintain_end: End time of the maintenance time window, 4-hour difference between the start time and end time.
        :param pulumi.Input[_builtins.str] name: The name of the dedicated instance.
        :param pulumi.Input[_builtins.str] region: The region in which to create the dedicated instance resource.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the dedicated instance belongs to.
        :param pulumi.Input[_builtins.str] status: Status of the dedicated instance.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the VPC subnet used to create the dedicated instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] supported_features: The supported features of the dedicated instance.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC used to create the dedicated instance.
        :param pulumi.Input[_builtins.str] vpc_ingress_address: The ingress private IP address of the VPC.
        :param pulumi.Input[_builtins.str] vpcep_service_address: The address (full name) of the VPC endpoint service.
        :param pulumi.Input[_builtins.str] vpcep_service_name: Name of the VPC endpoint service.
        """
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if bandwidth_size is not None:
            pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        if create_time is not None:
            warnings.warn("""Use 'created_at' instead""", DeprecationWarning)
            pulumi.log.warn("""create_time is deprecated: Use 'created_at' instead""")
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if custom_ingress_ports is not None:
            pulumi.set(__self__, "custom_ingress_ports", custom_ingress_ports)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if egress_address is not None:
            pulumi.set(__self__, "egress_address", egress_address)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ingress_address is not None:
            pulumi.set(__self__, "ingress_address", ingress_address)
        if ingress_bandwidth_charging_mode is not None:
            pulumi.set(__self__, "ingress_bandwidth_charging_mode", ingress_bandwidth_charging_mode)
        if ingress_bandwidth_size is not None:
            pulumi.set(__self__, "ingress_bandwidth_size", ingress_bandwidth_size)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if loadbalancer_provider is not None:
            pulumi.set(__self__, "loadbalancer_provider", loadbalancer_provider)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if supported_features is not None:
            pulumi.set(__self__, "supported_features", supported_features)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpc_ingress_address is not None:
            pulumi.set(__self__, "vpc_ingress_address", vpc_ingress_address)
        if vpcep_service_address is not None:
            pulumi.set(__self__, "vpcep_service_address", vpcep_service_address)
        if vpcep_service_name is not None:
            pulumi.set(__self__, "vpcep_service_name", vpcep_service_name)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        schema: Required; The name list of availability zones for the dedicated instance.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        schema: Deprecated; The name list of availability zones for the dedicated instance.
        """
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "available_zones", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The egress bandwidth size of the dedicated instance.
        """
        return pulumi.get(self, "bandwidth_size")

    @bandwidth_size.setter
    def bandwidth_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "bandwidth_size", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    @_utilities.deprecated("""Use 'created_at' instead""")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Deprecated; Time when the dedicated instance is created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when the dedicated instance is created, in RFC-3339 format.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="customIngressPorts")
    def custom_ingress_ports(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceCustomIngressPortArgs']]]]:
        """
        Specified the list of the instance custom ingress ports.
        """
        return pulumi.get(self, "custom_ingress_ports")

    @custom_ingress_ports.setter
    def custom_ingress_ports(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceCustomIngressPortArgs']]]]):
        pulumi.set(self, "custom_ingress_ports", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the dedicated instance.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The edition of the dedicated instance.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edition", value)

    @_builtins.property
    @pulumi.getter(name="egressAddress")
    def egress_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The egress (NAT) public IP address.
        """
        return pulumi.get(self, "egress_address")

    @egress_address.setter
    def egress_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "egress_address", value)

    @_builtins.property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EIP ID associated with the dedicated instance.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eip_id", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project ID to which the dedicated instance belongs.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="ingressAddress")
    def ingress_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ingress EIP address.
        """
        return pulumi.get(self, "ingress_address")

    @ingress_address.setter
    def ingress_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingress_address", value)

    @_builtins.property
    @pulumi.getter(name="ingressBandwidthChargingMode")
    def ingress_bandwidth_charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "ingress_bandwidth_charging_mode")

    @ingress_bandwidth_charging_mode.setter
    def ingress_bandwidth_charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ingress_bandwidth_charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="ingressBandwidthSize")
    def ingress_bandwidth_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "ingress_bandwidth_size")

    @ingress_bandwidth_size.setter
    def ingress_bandwidth_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ingress_bandwidth_size", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether public access with an IPv6 address is supported.
        """
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enable", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerProvider")
    def loadbalancer_provider(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of loadbalancer provider used by the instance.
        """
        return pulumi.get(self, "loadbalancer_provider")

    @loadbalancer_provider.setter
    def loadbalancer_provider(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "loadbalancer_provider", value)

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time of the maintenance time window.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_begin", value)

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        End time of the maintenance time window, 4-hour difference between the start time and end time.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the dedicated instance.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the dedicated instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the security group to which the dedicated instance belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of the dedicated instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC subnet used to create the dedicated instance.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="supportedFeatures")
    def supported_features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The supported features of the dedicated instance.
        """
        return pulumi.get(self, "supported_features")

    @supported_features.setter
    def supported_features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "supported_features", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the VPC used to create the dedicated instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcIngressAddress")
    def vpc_ingress_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ingress private IP address of the VPC.
        """
        return pulumi.get(self, "vpc_ingress_address")

    @vpc_ingress_address.setter
    def vpc_ingress_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_ingress_address", value)

    @_builtins.property
    @pulumi.getter(name="vpcepServiceAddress")
    def vpcep_service_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The address (full name) of the VPC endpoint service.
        """
        return pulumi.get(self, "vpcep_service_address")

    @vpcep_service_address.setter
    def vpcep_service_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpcep_service_address", value)

    @_builtins.property
    @pulumi.getter(name="vpcepServiceName")
    def vpcep_service_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the VPC endpoint service.
        """
        return pulumi.get(self, "vpcep_service_name")

    @vpcep_service_name.setter
    def vpcep_service_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpcep_service_name", value)


@pulumi.type_token("sbercloud:DedicatedApig/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bandwidth_size: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_ingress_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceCustomIngressPortArgs', 'InstanceCustomIngressPortArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 edition: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_bandwidth_charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_bandwidth_size: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 loadbalancer_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcep_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Create a Instance resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: schema: Required; The name list of availability zones for the dedicated instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] available_zones: schema: Deprecated; The name list of availability zones for the dedicated instance.
        :param pulumi.Input[_builtins.int] bandwidth_size: The egress bandwidth size of the dedicated instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceCustomIngressPortArgs', 'InstanceCustomIngressPortArgsDict']]]] custom_ingress_ports: Specified the list of the instance custom ingress ports.
        :param pulumi.Input[_builtins.str] description: The description of the dedicated instance.
        :param pulumi.Input[_builtins.str] edition: The edition of the dedicated instance.
        :param pulumi.Input[_builtins.str] eip_id: The EIP ID associated with the dedicated instance.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID to which the dedicated instance belongs.
        :param pulumi.Input[_builtins.bool] ipv6_enable: Whether public access with an IPv6 address is supported.
        :param pulumi.Input[_builtins.str] loadbalancer_provider: The type of loadbalancer provider used by the instance.
        :param pulumi.Input[_builtins.str] maintain_begin: The start time of the maintenance time window.
        :param pulumi.Input[_builtins.str] name: The name of the dedicated instance.
        :param pulumi.Input[_builtins.str] region: The region in which to create the dedicated instance resource.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the dedicated instance belongs to.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the VPC subnet used to create the dedicated instance.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC used to create the dedicated instance.
        :param pulumi.Input[_builtins.str] vpcep_service_name: Name of the VPC endpoint service.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a Instance resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bandwidth_size: Optional[pulumi.Input[_builtins.int]] = None,
                 custom_ingress_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceCustomIngressPortArgs', 'InstanceCustomIngressPortArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 edition: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_bandwidth_charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_bandwidth_size: Optional[pulumi.Input[_builtins.int]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 loadbalancer_provider: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vpcep_service_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["available_zones"] = available_zones
            __props__.__dict__["bandwidth_size"] = bandwidth_size
            __props__.__dict__["custom_ingress_ports"] = custom_ingress_ports
            __props__.__dict__["description"] = description
            if edition is None and not opts.urn:
                raise TypeError("Missing required property 'edition'")
            __props__.__dict__["edition"] = edition
            __props__.__dict__["eip_id"] = eip_id
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["ingress_bandwidth_charging_mode"] = ingress_bandwidth_charging_mode
            __props__.__dict__["ingress_bandwidth_size"] = ingress_bandwidth_size
            __props__.__dict__["ipv6_enable"] = ipv6_enable
            __props__.__dict__["loadbalancer_provider"] = loadbalancer_provider
            __props__.__dict__["maintain_begin"] = maintain_begin
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vpcep_service_name"] = vpcep_service_name
            __props__.__dict__["create_time"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["egress_address"] = None
            __props__.__dict__["ingress_address"] = None
            __props__.__dict__["maintain_end"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["supported_features"] = None
            __props__.__dict__["vpc_ingress_address"] = None
            __props__.__dict__["vpcep_service_address"] = None
        super(Instance, __self__).__init__(
            'sbercloud:DedicatedApig/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bandwidth_size: Optional[pulumi.Input[_builtins.int]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            custom_ingress_ports: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceCustomIngressPortArgs', 'InstanceCustomIngressPortArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            edition: Optional[pulumi.Input[_builtins.str]] = None,
            egress_address: Optional[pulumi.Input[_builtins.str]] = None,
            eip_id: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            ingress_address: Optional[pulumi.Input[_builtins.str]] = None,
            ingress_bandwidth_charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            ingress_bandwidth_size: Optional[pulumi.Input[_builtins.int]] = None,
            ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            loadbalancer_provider: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            supported_features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_ingress_address: Optional[pulumi.Input[_builtins.str]] = None,
            vpcep_service_address: Optional[pulumi.Input[_builtins.str]] = None,
            vpcep_service_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: schema: Required; The name list of availability zones for the dedicated instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] available_zones: schema: Deprecated; The name list of availability zones for the dedicated instance.
        :param pulumi.Input[_builtins.int] bandwidth_size: The egress bandwidth size of the dedicated instance.
        :param pulumi.Input[_builtins.str] create_time: schema: Deprecated; Time when the dedicated instance is created.
        :param pulumi.Input[_builtins.str] created_at: Time when the dedicated instance is created, in RFC-3339 format.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceCustomIngressPortArgs', 'InstanceCustomIngressPortArgsDict']]]] custom_ingress_ports: Specified the list of the instance custom ingress ports.
        :param pulumi.Input[_builtins.str] description: The description of the dedicated instance.
        :param pulumi.Input[_builtins.str] edition: The edition of the dedicated instance.
        :param pulumi.Input[_builtins.str] egress_address: The egress (NAT) public IP address.
        :param pulumi.Input[_builtins.str] eip_id: The EIP ID associated with the dedicated instance.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project ID to which the dedicated instance belongs.
        :param pulumi.Input[_builtins.str] ingress_address: The ingress EIP address.
        :param pulumi.Input[_builtins.bool] ipv6_enable: Whether public access with an IPv6 address is supported.
        :param pulumi.Input[_builtins.str] loadbalancer_provider: The type of loadbalancer provider used by the instance.
        :param pulumi.Input[_builtins.str] maintain_begin: The start time of the maintenance time window.
        :param pulumi.Input[_builtins.str] maintain_end: End time of the maintenance time window, 4-hour difference between the start time and end time.
        :param pulumi.Input[_builtins.str] name: The name of the dedicated instance.
        :param pulumi.Input[_builtins.str] region: The region in which to create the dedicated instance resource.
        :param pulumi.Input[_builtins.str] security_group_id: The ID of the security group to which the dedicated instance belongs to.
        :param pulumi.Input[_builtins.str] status: Status of the dedicated instance.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the VPC subnet used to create the dedicated instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] supported_features: The supported features of the dedicated instance.
        :param pulumi.Input[_builtins.str] vpc_id: The ID of the VPC used to create the dedicated instance.
        :param pulumi.Input[_builtins.str] vpc_ingress_address: The ingress private IP address of the VPC.
        :param pulumi.Input[_builtins.str] vpcep_service_address: The address (full name) of the VPC endpoint service.
        :param pulumi.Input[_builtins.str] vpcep_service_name: Name of the VPC endpoint service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["available_zones"] = available_zones
        __props__.__dict__["bandwidth_size"] = bandwidth_size
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["custom_ingress_ports"] = custom_ingress_ports
        __props__.__dict__["description"] = description
        __props__.__dict__["edition"] = edition
        __props__.__dict__["egress_address"] = egress_address
        __props__.__dict__["eip_id"] = eip_id
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["ingress_address"] = ingress_address
        __props__.__dict__["ingress_bandwidth_charging_mode"] = ingress_bandwidth_charging_mode
        __props__.__dict__["ingress_bandwidth_size"] = ingress_bandwidth_size
        __props__.__dict__["ipv6_enable"] = ipv6_enable
        __props__.__dict__["loadbalancer_provider"] = loadbalancer_provider
        __props__.__dict__["maintain_begin"] = maintain_begin
        __props__.__dict__["maintain_end"] = maintain_end
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["supported_features"] = supported_features
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpc_ingress_address"] = vpc_ingress_address
        __props__.__dict__["vpcep_service_address"] = vpcep_service_address
        __props__.__dict__["vpcep_service_name"] = vpcep_service_name
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        schema: Required; The name list of availability zones for the dedicated instance.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        schema: Deprecated; The name list of availability zones for the dedicated instance.
        """
        return pulumi.get(self, "available_zones")

    @_builtins.property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The egress bandwidth size of the dedicated instance.
        """
        return pulumi.get(self, "bandwidth_size")

    @_builtins.property
    @pulumi.getter(name="createTime")
    @_utilities.deprecated("""Use 'created_at' instead""")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        schema: Deprecated; Time when the dedicated instance is created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Time when the dedicated instance is created, in RFC-3339 format.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="customIngressPorts")
    def custom_ingress_ports(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceCustomIngressPort']]]:
        """
        Specified the list of the instance custom ingress ports.
        """
        return pulumi.get(self, "custom_ingress_ports")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the dedicated instance.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def edition(self) -> pulumi.Output[_builtins.str]:
        """
        The edition of the dedicated instance.
        """
        return pulumi.get(self, "edition")

    @_builtins.property
    @pulumi.getter(name="egressAddress")
    def egress_address(self) -> pulumi.Output[_builtins.str]:
        """
        The egress (NAT) public IP address.
        """
        return pulumi.get(self, "egress_address")

    @_builtins.property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> pulumi.Output[_builtins.str]:
        """
        The EIP ID associated with the dedicated instance.
        """
        return pulumi.get(self, "eip_id")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project ID to which the dedicated instance belongs.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="ingressAddress")
    def ingress_address(self) -> pulumi.Output[_builtins.str]:
        """
        The ingress EIP address.
        """
        return pulumi.get(self, "ingress_address")

    @_builtins.property
    @pulumi.getter(name="ingressBandwidthChargingMode")
    def ingress_bandwidth_charging_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "ingress_bandwidth_charging_mode")

    @_builtins.property
    @pulumi.getter(name="ingressBandwidthSize")
    def ingress_bandwidth_size(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "ingress_bandwidth_size")

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether public access with an IPv6 address is supported.
        """
        return pulumi.get(self, "ipv6_enable")

    @_builtins.property
    @pulumi.getter(name="loadbalancerProvider")
    def loadbalancer_provider(self) -> pulumi.Output[_builtins.str]:
        """
        The type of loadbalancer provider used by the instance.
        """
        return pulumi.get(self, "loadbalancer_provider")

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> pulumi.Output[_builtins.str]:
        """
        The start time of the maintenance time window.
        """
        return pulumi.get(self, "maintain_begin")

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> pulumi.Output[_builtins.str]:
        """
        End time of the maintenance time window, 4-hour difference between the start time and end time.
        """
        return pulumi.get(self, "maintain_end")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the dedicated instance.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the dedicated instance resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the security group to which the dedicated instance belongs to.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of the dedicated instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC subnet used to create the dedicated instance.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="supportedFeatures")
    def supported_features(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The supported features of the dedicated instance.
        """
        return pulumi.get(self, "supported_features")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the VPC used to create the dedicated instance.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="vpcIngressAddress")
    def vpc_ingress_address(self) -> pulumi.Output[_builtins.str]:
        """
        The ingress private IP address of the VPC.
        """
        return pulumi.get(self, "vpc_ingress_address")

    @_builtins.property
    @pulumi.getter(name="vpcepServiceAddress")
    def vpcep_service_address(self) -> pulumi.Output[_builtins.str]:
        """
        The address (full name) of the VPC endpoint service.
        """
        return pulumi.get(self, "vpcep_service_address")

    @_builtins.property
    @pulumi.getter(name="vpcepServiceName")
    def vpcep_service_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the VPC endpoint service.
        """
        return pulumi.get(self, "vpcep_service_name")

