# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ThrottlingPolicyArgs', 'ThrottlingPolicy']

@pulumi.input_type
class ThrottlingPolicyArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 max_api_requests: pulumi.Input[_builtins.int],
                 period: pulumi.Input[_builtins.int],
                 app_throttles: Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyAppThrottleArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 max_app_requests: Optional[pulumi.Input[_builtins.int]] = None,
                 max_ip_requests: Optional[pulumi.Input[_builtins.int]] = None,
                 max_user_requests: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_throttles: Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyUserThrottleArgs']]]] = None):
        """
        The set of arguments for constructing a ThrottlingPolicy resource.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the throttling policy belongs.
        :param pulumi.Input[_builtins.int] max_api_requests: The maximum number of times an API can be accessed within a specified period..
        :param pulumi.Input[_builtins.int] period: The period of time for limiting the number of API calls.
        :param pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyAppThrottleArgs']]] app_throttles: The array of one or more special throttling policies for APP limit.
        :param pulumi.Input[_builtins.str] description: The description about the API throttling policy.
        :param pulumi.Input[_builtins.int] max_app_requests: The maximum number of times the API can be accessed by an app within the same period.
        :param pulumi.Input[_builtins.int] max_ip_requests: The maximum number of times the API can be accessed by an IP address within the same period.
        :param pulumi.Input[_builtins.int] max_user_requests: The maximum number of times the API can be accessed by a user within the same period.
        :param pulumi.Input[_builtins.str] name: The name of the throttling policy.
        :param pulumi.Input[_builtins.str] period_unit: The time unit for limiting the number of API calls.
        :param pulumi.Input[_builtins.str] region: The region where the throttling policy is located.
        :param pulumi.Input[_builtins.str] type: The type of the request throttling policy.
        :param pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyUserThrottleArgs']]] user_throttles: The array of one or more special throttling policies for IAM user limit.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "max_api_requests", max_api_requests)
        pulumi.set(__self__, "period", period)
        if app_throttles is not None:
            pulumi.set(__self__, "app_throttles", app_throttles)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if max_app_requests is not None:
            pulumi.set(__self__, "max_app_requests", max_app_requests)
        if max_ip_requests is not None:
            pulumi.set(__self__, "max_ip_requests", max_ip_requests)
        if max_user_requests is not None:
            pulumi.set(__self__, "max_user_requests", max_user_requests)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_throttles is not None:
            pulumi.set(__self__, "user_throttles", user_throttles)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the dedicated instance to which the throttling policy belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="maxApiRequests")
    def max_api_requests(self) -> pulumi.Input[_builtins.int]:
        """
        The maximum number of times an API can be accessed within a specified period..
        """
        return pulumi.get(self, "max_api_requests")

    @max_api_requests.setter
    def max_api_requests(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max_api_requests", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Input[_builtins.int]:
        """
        The period of time for limiting the number of API calls.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="appThrottles")
    def app_throttles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyAppThrottleArgs']]]]:
        """
        The array of one or more special throttling policies for APP limit.
        """
        return pulumi.get(self, "app_throttles")

    @app_throttles.setter
    def app_throttles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyAppThrottleArgs']]]]):
        pulumi.set(self, "app_throttles", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description about the API throttling policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="maxAppRequests")
    def max_app_requests(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times the API can be accessed by an app within the same period.
        """
        return pulumi.get(self, "max_app_requests")

    @max_app_requests.setter
    def max_app_requests(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_app_requests", value)

    @_builtins.property
    @pulumi.getter(name="maxIpRequests")
    def max_ip_requests(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times the API can be accessed by an IP address within the same period.
        """
        return pulumi.get(self, "max_ip_requests")

    @max_ip_requests.setter
    def max_ip_requests(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_ip_requests", value)

    @_builtins.property
    @pulumi.getter(name="maxUserRequests")
    def max_user_requests(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times the API can be accessed by a user within the same period.
        """
        return pulumi.get(self, "max_user_requests")

    @max_user_requests.setter
    def max_user_requests(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_user_requests", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the throttling policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time unit for limiting the number of API calls.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the throttling policy is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the request throttling policy.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userThrottles")
    def user_throttles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyUserThrottleArgs']]]]:
        """
        The array of one or more special throttling policies for IAM user limit.
        """
        return pulumi.get(self, "user_throttles")

    @user_throttles.setter
    def user_throttles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyUserThrottleArgs']]]]):
        pulumi.set(self, "user_throttles", value)


@pulumi.input_type
class _ThrottlingPolicyState:
    def __init__(__self__, *,
                 app_throttles: Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyAppThrottleArgs']]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_api_requests: Optional[pulumi.Input[_builtins.int]] = None,
                 max_app_requests: Optional[pulumi.Input[_builtins.int]] = None,
                 max_ip_requests: Optional[pulumi.Input[_builtins.int]] = None,
                 max_user_requests: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_throttles: Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyUserThrottleArgs']]]] = None):
        """
        Input properties used for looking up and filtering ThrottlingPolicy resources.
        :param pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyAppThrottleArgs']]] app_throttles: The array of one or more special throttling policies for APP limit.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the throttling policy.
        :param pulumi.Input[_builtins.str] description: The description about the API throttling policy.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the throttling policy belongs.
        :param pulumi.Input[_builtins.int] max_api_requests: The maximum number of times an API can be accessed within a specified period..
        :param pulumi.Input[_builtins.int] max_app_requests: The maximum number of times the API can be accessed by an app within the same period.
        :param pulumi.Input[_builtins.int] max_ip_requests: The maximum number of times the API can be accessed by an IP address within the same period.
        :param pulumi.Input[_builtins.int] max_user_requests: The maximum number of times the API can be accessed by a user within the same period.
        :param pulumi.Input[_builtins.str] name: The name of the throttling policy.
        :param pulumi.Input[_builtins.int] period: The period of time for limiting the number of API calls.
        :param pulumi.Input[_builtins.str] period_unit: The time unit for limiting the number of API calls.
        :param pulumi.Input[_builtins.str] region: The region where the throttling policy is located.
        :param pulumi.Input[_builtins.str] type: The type of the request throttling policy.
        :param pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyUserThrottleArgs']]] user_throttles: The array of one or more special throttling policies for IAM user limit.
        """
        if app_throttles is not None:
            pulumi.set(__self__, "app_throttles", app_throttles)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if max_api_requests is not None:
            pulumi.set(__self__, "max_api_requests", max_api_requests)
        if max_app_requests is not None:
            pulumi.set(__self__, "max_app_requests", max_app_requests)
        if max_ip_requests is not None:
            pulumi.set(__self__, "max_ip_requests", max_ip_requests)
        if max_user_requests is not None:
            pulumi.set(__self__, "max_user_requests", max_user_requests)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if user_throttles is not None:
            pulumi.set(__self__, "user_throttles", user_throttles)

    @_builtins.property
    @pulumi.getter(name="appThrottles")
    def app_throttles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyAppThrottleArgs']]]]:
        """
        The array of one or more special throttling policies for APP limit.
        """
        return pulumi.get(self, "app_throttles")

    @app_throttles.setter
    def app_throttles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyAppThrottleArgs']]]]):
        pulumi.set(self, "app_throttles", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time of the throttling policy.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description about the API throttling policy.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the dedicated instance to which the throttling policy belongs.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="maxApiRequests")
    def max_api_requests(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times an API can be accessed within a specified period..
        """
        return pulumi.get(self, "max_api_requests")

    @max_api_requests.setter
    def max_api_requests(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_api_requests", value)

    @_builtins.property
    @pulumi.getter(name="maxAppRequests")
    def max_app_requests(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times the API can be accessed by an app within the same period.
        """
        return pulumi.get(self, "max_app_requests")

    @max_app_requests.setter
    def max_app_requests(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_app_requests", value)

    @_builtins.property
    @pulumi.getter(name="maxIpRequests")
    def max_ip_requests(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times the API can be accessed by an IP address within the same period.
        """
        return pulumi.get(self, "max_ip_requests")

    @max_ip_requests.setter
    def max_ip_requests(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_ip_requests", value)

    @_builtins.property
    @pulumi.getter(name="maxUserRequests")
    def max_user_requests(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of times the API can be accessed by a user within the same period.
        """
        return pulumi.get(self, "max_user_requests")

    @max_user_requests.setter
    def max_user_requests(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_user_requests", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the throttling policy.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The period of time for limiting the number of API calls.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The time unit for limiting the number of API calls.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region where the throttling policy is located.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the request throttling policy.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="userThrottles")
    def user_throttles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyUserThrottleArgs']]]]:
        """
        The array of one or more special throttling policies for IAM user limit.
        """
        return pulumi.get(self, "user_throttles")

    @user_throttles.setter
    def user_throttles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ThrottlingPolicyUserThrottleArgs']]]]):
        pulumi.set(self, "user_throttles", value)


@pulumi.type_token("sbercloud:DedicatedApig/throttlingPolicy:ThrottlingPolicy")
class ThrottlingPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_throttles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThrottlingPolicyAppThrottleArgs', 'ThrottlingPolicyAppThrottleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_api_requests: Optional[pulumi.Input[_builtins.int]] = None,
                 max_app_requests: Optional[pulumi.Input[_builtins.int]] = None,
                 max_ip_requests: Optional[pulumi.Input[_builtins.int]] = None,
                 max_user_requests: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_throttles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThrottlingPolicyUserThrottleArgs', 'ThrottlingPolicyUserThrottleArgsDict']]]]] = None,
                 __props__=None):
        """
        Create a ThrottlingPolicy resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThrottlingPolicyAppThrottleArgs', 'ThrottlingPolicyAppThrottleArgsDict']]]] app_throttles: The array of one or more special throttling policies for APP limit.
        :param pulumi.Input[_builtins.str] description: The description about the API throttling policy.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the throttling policy belongs.
        :param pulumi.Input[_builtins.int] max_api_requests: The maximum number of times an API can be accessed within a specified period..
        :param pulumi.Input[_builtins.int] max_app_requests: The maximum number of times the API can be accessed by an app within the same period.
        :param pulumi.Input[_builtins.int] max_ip_requests: The maximum number of times the API can be accessed by an IP address within the same period.
        :param pulumi.Input[_builtins.int] max_user_requests: The maximum number of times the API can be accessed by a user within the same period.
        :param pulumi.Input[_builtins.str] name: The name of the throttling policy.
        :param pulumi.Input[_builtins.int] period: The period of time for limiting the number of API calls.
        :param pulumi.Input[_builtins.str] period_unit: The time unit for limiting the number of API calls.
        :param pulumi.Input[_builtins.str] region: The region where the throttling policy is located.
        :param pulumi.Input[_builtins.str] type: The type of the request throttling policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThrottlingPolicyUserThrottleArgs', 'ThrottlingPolicyUserThrottleArgsDict']]]] user_throttles: The array of one or more special throttling policies for IAM user limit.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ThrottlingPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a ThrottlingPolicy resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param ThrottlingPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ThrottlingPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_throttles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThrottlingPolicyAppThrottleArgs', 'ThrottlingPolicyAppThrottleArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_api_requests: Optional[pulumi.Input[_builtins.int]] = None,
                 max_app_requests: Optional[pulumi.Input[_builtins.int]] = None,
                 max_ip_requests: Optional[pulumi.Input[_builtins.int]] = None,
                 max_user_requests: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 user_throttles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThrottlingPolicyUserThrottleArgs', 'ThrottlingPolicyUserThrottleArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ThrottlingPolicyArgs.__new__(ThrottlingPolicyArgs)

            __props__.__dict__["app_throttles"] = app_throttles
            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if max_api_requests is None and not opts.urn:
                raise TypeError("Missing required property 'max_api_requests'")
            __props__.__dict__["max_api_requests"] = max_api_requests
            __props__.__dict__["max_app_requests"] = max_app_requests
            __props__.__dict__["max_ip_requests"] = max_ip_requests
            __props__.__dict__["max_user_requests"] = max_user_requests
            __props__.__dict__["name"] = name
            if period is None and not opts.urn:
                raise TypeError("Missing required property 'period'")
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["region"] = region
            __props__.__dict__["type"] = type
            __props__.__dict__["user_throttles"] = user_throttles
            __props__.__dict__["created_at"] = None
        super(ThrottlingPolicy, __self__).__init__(
            'sbercloud:DedicatedApig/throttlingPolicy:ThrottlingPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_throttles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThrottlingPolicyAppThrottleArgs', 'ThrottlingPolicyAppThrottleArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            max_api_requests: Optional[pulumi.Input[_builtins.int]] = None,
            max_app_requests: Optional[pulumi.Input[_builtins.int]] = None,
            max_ip_requests: Optional[pulumi.Input[_builtins.int]] = None,
            max_user_requests: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            user_throttles: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ThrottlingPolicyUserThrottleArgs', 'ThrottlingPolicyUserThrottleArgsDict']]]]] = None) -> 'ThrottlingPolicy':
        """
        Get an existing ThrottlingPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThrottlingPolicyAppThrottleArgs', 'ThrottlingPolicyAppThrottleArgsDict']]]] app_throttles: The array of one or more special throttling policies for APP limit.
        :param pulumi.Input[_builtins.str] created_at: The creation time of the throttling policy.
        :param pulumi.Input[_builtins.str] description: The description about the API throttling policy.
        :param pulumi.Input[_builtins.str] instance_id: The ID of the dedicated instance to which the throttling policy belongs.
        :param pulumi.Input[_builtins.int] max_api_requests: The maximum number of times an API can be accessed within a specified period..
        :param pulumi.Input[_builtins.int] max_app_requests: The maximum number of times the API can be accessed by an app within the same period.
        :param pulumi.Input[_builtins.int] max_ip_requests: The maximum number of times the API can be accessed by an IP address within the same period.
        :param pulumi.Input[_builtins.int] max_user_requests: The maximum number of times the API can be accessed by a user within the same period.
        :param pulumi.Input[_builtins.str] name: The name of the throttling policy.
        :param pulumi.Input[_builtins.int] period: The period of time for limiting the number of API calls.
        :param pulumi.Input[_builtins.str] period_unit: The time unit for limiting the number of API calls.
        :param pulumi.Input[_builtins.str] region: The region where the throttling policy is located.
        :param pulumi.Input[_builtins.str] type: The type of the request throttling policy.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ThrottlingPolicyUserThrottleArgs', 'ThrottlingPolicyUserThrottleArgsDict']]]] user_throttles: The array of one or more special throttling policies for IAM user limit.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ThrottlingPolicyState.__new__(_ThrottlingPolicyState)

        __props__.__dict__["app_throttles"] = app_throttles
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["max_api_requests"] = max_api_requests
        __props__.__dict__["max_app_requests"] = max_app_requests
        __props__.__dict__["max_ip_requests"] = max_ip_requests
        __props__.__dict__["max_user_requests"] = max_user_requests
        __props__.__dict__["name"] = name
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["region"] = region
        __props__.__dict__["type"] = type
        __props__.__dict__["user_throttles"] = user_throttles
        return ThrottlingPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appThrottles")
    def app_throttles(self) -> pulumi.Output[Optional[Sequence['outputs.ThrottlingPolicyAppThrottle']]]:
        """
        The array of one or more special throttling policies for APP limit.
        """
        return pulumi.get(self, "app_throttles")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time of the throttling policy.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description about the API throttling policy.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the dedicated instance to which the throttling policy belongs.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="maxApiRequests")
    def max_api_requests(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of times an API can be accessed within a specified period..
        """
        return pulumi.get(self, "max_api_requests")

    @_builtins.property
    @pulumi.getter(name="maxAppRequests")
    def max_app_requests(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of times the API can be accessed by an app within the same period.
        """
        return pulumi.get(self, "max_app_requests")

    @_builtins.property
    @pulumi.getter(name="maxIpRequests")
    def max_ip_requests(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of times the API can be accessed by an IP address within the same period.
        """
        return pulumi.get(self, "max_ip_requests")

    @_builtins.property
    @pulumi.getter(name="maxUserRequests")
    def max_user_requests(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum number of times the API can be accessed by a user within the same period.
        """
        return pulumi.get(self, "max_user_requests")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the throttling policy.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[_builtins.int]:
        """
        The period of time for limiting the number of API calls.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The time unit for limiting the number of API calls.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region where the throttling policy is located.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the request throttling policy.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="userThrottles")
    def user_throttles(self) -> pulumi.Output[Optional[Sequence['outputs.ThrottlingPolicyUserThrottle']]]:
        """
        The array of one or more special throttling policies for IAM user limit.
        """
        return pulumi.get(self, "user_throttles")

