# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDataKeyResult',
    'AwaitableGetDataKeyResult',
    'get_data_key',
    'get_data_key_output',
]

@pulumi.output_type
class GetDataKeyResult:
    """
    A collection of values returned by getDataKey.
    """
    def __init__(__self__, cipher_text=None, datakey_length=None, encryption_context=None, id=None, key_id=None, plain_text=None, region=None):
        if cipher_text and not isinstance(cipher_text, str):
            raise TypeError("Expected argument 'cipher_text' to be a str")
        pulumi.set(__self__, "cipher_text", cipher_text)
        if datakey_length and not isinstance(datakey_length, str):
            raise TypeError("Expected argument 'datakey_length' to be a str")
        pulumi.set(__self__, "datakey_length", datakey_length)
        if encryption_context and not isinstance(encryption_context, str):
            raise TypeError("Expected argument 'encryption_context' to be a str")
        pulumi.set(__self__, "encryption_context", encryption_context)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if plain_text and not isinstance(plain_text, str):
            raise TypeError("Expected argument 'plain_text' to be a str")
        pulumi.set(__self__, "plain_text", plain_text)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="cipherText")
    def cipher_text(self) -> _builtins.str:
        """
        The ciphertext of a DEK is expressed in hexadecimal format, and two
        characters indicate one byte.
        """
        return pulumi.get(self, "cipher_text")

    @_builtins.property
    @pulumi.getter(name="datakeyLength")
    def datakey_length(self) -> _builtins.str:
        return pulumi.get(self, "datakey_length")

    @_builtins.property
    @pulumi.getter(name="encryptionContext")
    def encryption_context(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "encryption_context")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="plainText")
    def plain_text(self) -> _builtins.str:
        """
        The plaintext of a DEK is expressed in hexadecimal format, and two
        characters indicate one byte.
        """
        return pulumi.get(self, "plain_text")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")


class AwaitableGetDataKeyResult(GetDataKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataKeyResult(
            cipher_text=self.cipher_text,
            datakey_length=self.datakey_length,
            encryption_context=self.encryption_context,
            id=self.id,
            key_id=self.key_id,
            plain_text=self.plain_text,
            region=self.region)


def get_data_key(datakey_length: Optional[_builtins.str] = None,
                 encryption_context: Optional[_builtins.str] = None,
                 key_id: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataKeyResult:
    """
    Use this data source to get the plaintext and the ciphertext of an available
    SberCloud KMS DEK (data encryption key).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudru as sbercloud
    import pulumi_sbercloud as sbercloud

    key1 = sbercloud.dew.Key("key1",
        key_alias="key_1",
        pending_days="7",
        key_description="first test key")
    kms_datakey1 = sbercloud.Dew.get_data_key_output(key_id=key1.id,
        datakey_length="512")
    ```


    :param _builtins.str datakey_length: Number of bits in the length of a DEK (data encryption keys).
           The maximum number is 512. Changing this gets the new data encryption key.
    :param _builtins.str encryption_context: The value of this parameter must be a series of
           "key:value" pairs used to record resource context information. The value of this
           parameter must not contain sensitive information and must be within 8192 characters
           in length. Example: {"Key1":"Value1","Key2":"Value2"}
    :param _builtins.str key_id: The globally unique identifier for the key.
           Changing this gets the new data encryption key.
    :param _builtins.str region: The region in which to obtain the keys. If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['datakeyLength'] = datakey_length
    __args__['encryptionContext'] = encryption_context
    __args__['keyId'] = key_id
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Dew/getDataKey:getDataKey', __args__, opts=opts, typ=GetDataKeyResult).value

    return AwaitableGetDataKeyResult(
        cipher_text=pulumi.get(__ret__, 'cipher_text'),
        datakey_length=pulumi.get(__ret__, 'datakey_length'),
        encryption_context=pulumi.get(__ret__, 'encryption_context'),
        id=pulumi.get(__ret__, 'id'),
        key_id=pulumi.get(__ret__, 'key_id'),
        plain_text=pulumi.get(__ret__, 'plain_text'),
        region=pulumi.get(__ret__, 'region'))
def get_data_key_output(datakey_length: Optional[pulumi.Input[_builtins.str]] = None,
                        encryption_context: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        key_id: Optional[pulumi.Input[_builtins.str]] = None,
                        region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDataKeyResult]:
    """
    Use this data source to get the plaintext and the ciphertext of an available
    SberCloud KMS DEK (data encryption key).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudru as sbercloud
    import pulumi_sbercloud as sbercloud

    key1 = sbercloud.dew.Key("key1",
        key_alias="key_1",
        pending_days="7",
        key_description="first test key")
    kms_datakey1 = sbercloud.Dew.get_data_key_output(key_id=key1.id,
        datakey_length="512")
    ```


    :param _builtins.str datakey_length: Number of bits in the length of a DEK (data encryption keys).
           The maximum number is 512. Changing this gets the new data encryption key.
    :param _builtins.str encryption_context: The value of this parameter must be a series of
           "key:value" pairs used to record resource context information. The value of this
           parameter must not contain sensitive information and must be within 8192 characters
           in length. Example: {"Key1":"Value1","Key2":"Value2"}
    :param _builtins.str key_id: The globally unique identifier for the key.
           Changing this gets the new data encryption key.
    :param _builtins.str region: The region in which to obtain the keys. If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['datakeyLength'] = datakey_length
    __args__['encryptionContext'] = encryption_context
    __args__['keyId'] = key_id
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Dew/getDataKey:getDataKey', __args__, opts=opts, typ=GetDataKeyResult)
    return __ret__.apply(lambda __response__: GetDataKeyResult(
        cipher_text=pulumi.get(__response__, 'cipher_text'),
        datakey_length=pulumi.get(__response__, 'datakey_length'),
        encryption_context=pulumi.get(__response__, 'encryption_context'),
        id=pulumi.get(__response__, 'id'),
        key_id=pulumi.get(__response__, 'key_id'),
        plain_text=pulumi.get(__response__, 'plain_text'),
        region=pulumi.get(__response__, 'region')))
