# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetKeyResult',
    'AwaitableGetKeyResult',
    'get_key',
    'get_key_output',
]

@pulumi.output_type
class GetKeyResult:
    """
    A collection of values returned by getKey.
    """
    def __init__(__self__, creation_date=None, default_key_flag=None, domain_id=None, enterprise_project_id=None, expiration_time=None, id=None, key_alias=None, key_description=None, key_id=None, key_state=None, region=None, rotation_enabled=None, rotation_interval=None, rotation_number=None, scheduled_deletion_date=None, tags=None):
        if creation_date and not isinstance(creation_date, str):
            raise TypeError("Expected argument 'creation_date' to be a str")
        pulumi.set(__self__, "creation_date", creation_date)
        if default_key_flag and not isinstance(default_key_flag, str):
            raise TypeError("Expected argument 'default_key_flag' to be a str")
        pulumi.set(__self__, "default_key_flag", default_key_flag)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if expiration_time and not isinstance(expiration_time, str):
            raise TypeError("Expected argument 'expiration_time' to be a str")
        pulumi.set(__self__, "expiration_time", expiration_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if key_alias and not isinstance(key_alias, str):
            raise TypeError("Expected argument 'key_alias' to be a str")
        pulumi.set(__self__, "key_alias", key_alias)
        if key_description and not isinstance(key_description, str):
            raise TypeError("Expected argument 'key_description' to be a str")
        pulumi.set(__self__, "key_description", key_description)
        if key_id and not isinstance(key_id, str):
            raise TypeError("Expected argument 'key_id' to be a str")
        pulumi.set(__self__, "key_id", key_id)
        if key_state and not isinstance(key_state, str):
            raise TypeError("Expected argument 'key_state' to be a str")
        pulumi.set(__self__, "key_state", key_state)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rotation_enabled and not isinstance(rotation_enabled, bool):
            raise TypeError("Expected argument 'rotation_enabled' to be a bool")
        pulumi.set(__self__, "rotation_enabled", rotation_enabled)
        if rotation_interval and not isinstance(rotation_interval, int):
            raise TypeError("Expected argument 'rotation_interval' to be a int")
        pulumi.set(__self__, "rotation_interval", rotation_interval)
        if rotation_number and not isinstance(rotation_number, int):
            raise TypeError("Expected argument 'rotation_number' to be a int")
        pulumi.set(__self__, "rotation_number", rotation_number)
        if scheduled_deletion_date and not isinstance(scheduled_deletion_date, str):
            raise TypeError("Expected argument 'scheduled_deletion_date' to be a str")
        pulumi.set(__self__, "scheduled_deletion_date", scheduled_deletion_date)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> _builtins.str:
        """
        Creation time (time stamp) of a key.
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter(name="defaultKeyFlag")
    def default_key_flag(self) -> _builtins.str:
        return pulumi.get(self, "default_key_flag")

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> _builtins.str:
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> _builtins.str:
        """
        Expiration time.
        """
        return pulumi.get(self, "expiration_time")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="keyAlias")
    def key_alias(self) -> _builtins.str:
        return pulumi.get(self, "key_alias")

    @_builtins.property
    @pulumi.getter(name="keyDescription")
    def key_description(self) -> _builtins.str:
        return pulumi.get(self, "key_description")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> _builtins.str:
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="keyState")
    def key_state(self) -> _builtins.str:
        return pulumi.get(self, "key_state")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rotationEnabled")
    def rotation_enabled(self) -> _builtins.bool:
        """
        Indicates whether the key rotation is enabled or not.
        """
        return pulumi.get(self, "rotation_enabled")

    @_builtins.property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> _builtins.int:
        """
        The key rotation interval. It's valid when rotation is enabled.
        """
        return pulumi.get(self, "rotation_interval")

    @_builtins.property
    @pulumi.getter(name="rotationNumber")
    def rotation_number(self) -> _builtins.int:
        """
        The total number of key rotations. It's valid when rotation is enabled.
        """
        return pulumi.get(self, "rotation_number")

    @_builtins.property
    @pulumi.getter(name="scheduledDeletionDate")
    def scheduled_deletion_date(self) -> _builtins.str:
        """
        Scheduled deletion time (time stamp) of a key.
        """
        return pulumi.get(self, "scheduled_deletion_date")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The key/value pairs to associate with the kms key.
        """
        return pulumi.get(self, "tags")


class AwaitableGetKeyResult(GetKeyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeyResult(
            creation_date=self.creation_date,
            default_key_flag=self.default_key_flag,
            domain_id=self.domain_id,
            enterprise_project_id=self.enterprise_project_id,
            expiration_time=self.expiration_time,
            id=self.id,
            key_alias=self.key_alias,
            key_description=self.key_description,
            key_id=self.key_id,
            key_state=self.key_state,
            region=self.region,
            rotation_enabled=self.rotation_enabled,
            rotation_interval=self.rotation_interval,
            rotation_number=self.rotation_number,
            scheduled_deletion_date=self.scheduled_deletion_date,
            tags=self.tags)


def get_key(default_key_flag: Optional[_builtins.str] = None,
            domain_id: Optional[_builtins.str] = None,
            enterprise_project_id: Optional[_builtins.str] = None,
            key_alias: Optional[_builtins.str] = None,
            key_description: Optional[_builtins.str] = None,
            key_id: Optional[_builtins.str] = None,
            key_state: Optional[_builtins.str] = None,
            region: Optional[_builtins.str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeyResult:
    """
    Use this data source to get the ID of an available SberCloud KMS key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    key1 = sbercloud.Dew.get_key(key_alias="test_key",
        key_description="test key description",
        key_state="2",
        key_id="af650527-a0ff-4527-aef3-c493df1f3012",
        default_key_flag="0",
        domain_id="b168fe00ff56492495a7d22974df2d0b")
    ```


    :param _builtins.str default_key_flag: Identification of a Master Key. The value "1" indicates a Default Master Key,
           and the value "0" indicates a key. Changing this gets a new key.
    :param _builtins.str domain_id: ID of a user domain for the key. Changing this gets a new key.
    :param _builtins.str enterprise_project_id: The enterprise project id of the kms key.
    :param _builtins.str key_alias: The alias in which to create the key. It is required when we create a new key.
           Changing this gets the new key.
    :param _builtins.str key_description: The description of the key as viewed in Huawei console. Changing this gets a
           new key.
    :param _builtins.str key_id: The globally unique identifier for the key. Changing this gets the new key.
    :param _builtins.str key_state: The state of a key. "1" indicates that the key is waiting to be activated.
           "2" indicates that the key is enabled. "3" indicates that the key is disabled. "4" indicates that the key is scheduled
           for deletion. Changing this gets a new key.
    :param _builtins.str region: The region in which to obtain the keys. If omitted, the provider-level region will be
           used.
    """
    __args__ = dict()
    __args__['defaultKeyFlag'] = default_key_flag
    __args__['domainId'] = domain_id
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['keyAlias'] = key_alias
    __args__['keyDescription'] = key_description
    __args__['keyId'] = key_id
    __args__['keyState'] = key_state
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Dew/getKey:getKey', __args__, opts=opts, typ=GetKeyResult).value

    return AwaitableGetKeyResult(
        creation_date=pulumi.get(__ret__, 'creation_date'),
        default_key_flag=pulumi.get(__ret__, 'default_key_flag'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        expiration_time=pulumi.get(__ret__, 'expiration_time'),
        id=pulumi.get(__ret__, 'id'),
        key_alias=pulumi.get(__ret__, 'key_alias'),
        key_description=pulumi.get(__ret__, 'key_description'),
        key_id=pulumi.get(__ret__, 'key_id'),
        key_state=pulumi.get(__ret__, 'key_state'),
        region=pulumi.get(__ret__, 'region'),
        rotation_enabled=pulumi.get(__ret__, 'rotation_enabled'),
        rotation_interval=pulumi.get(__ret__, 'rotation_interval'),
        rotation_number=pulumi.get(__ret__, 'rotation_number'),
        scheduled_deletion_date=pulumi.get(__ret__, 'scheduled_deletion_date'),
        tags=pulumi.get(__ret__, 'tags'))
def get_key_output(default_key_flag: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   domain_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   key_alias: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   key_description: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   key_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   key_state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeyResult]:
    """
    Use this data source to get the ID of an available SberCloud KMS key.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    key1 = sbercloud.Dew.get_key(key_alias="test_key",
        key_description="test key description",
        key_state="2",
        key_id="af650527-a0ff-4527-aef3-c493df1f3012",
        default_key_flag="0",
        domain_id="b168fe00ff56492495a7d22974df2d0b")
    ```


    :param _builtins.str default_key_flag: Identification of a Master Key. The value "1" indicates a Default Master Key,
           and the value "0" indicates a key. Changing this gets a new key.
    :param _builtins.str domain_id: ID of a user domain for the key. Changing this gets a new key.
    :param _builtins.str enterprise_project_id: The enterprise project id of the kms key.
    :param _builtins.str key_alias: The alias in which to create the key. It is required when we create a new key.
           Changing this gets the new key.
    :param _builtins.str key_description: The description of the key as viewed in Huawei console. Changing this gets a
           new key.
    :param _builtins.str key_id: The globally unique identifier for the key. Changing this gets the new key.
    :param _builtins.str key_state: The state of a key. "1" indicates that the key is waiting to be activated.
           "2" indicates that the key is enabled. "3" indicates that the key is disabled. "4" indicates that the key is scheduled
           for deletion. Changing this gets a new key.
    :param _builtins.str region: The region in which to obtain the keys. If omitted, the provider-level region will be
           used.
    """
    __args__ = dict()
    __args__['defaultKeyFlag'] = default_key_flag
    __args__['domainId'] = domain_id
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['keyAlias'] = key_alias
    __args__['keyDescription'] = key_description
    __args__['keyId'] = key_id
    __args__['keyState'] = key_state
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Dew/getKey:getKey', __args__, opts=opts, typ=GetKeyResult)
    return __ret__.apply(lambda __response__: GetKeyResult(
        creation_date=pulumi.get(__response__, 'creation_date'),
        default_key_flag=pulumi.get(__response__, 'default_key_flag'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        expiration_time=pulumi.get(__response__, 'expiration_time'),
        id=pulumi.get(__response__, 'id'),
        key_alias=pulumi.get(__response__, 'key_alias'),
        key_description=pulumi.get(__response__, 'key_description'),
        key_id=pulumi.get(__response__, 'key_id'),
        key_state=pulumi.get(__response__, 'key_state'),
        region=pulumi.get(__response__, 'region'),
        rotation_enabled=pulumi.get(__response__, 'rotation_enabled'),
        rotation_interval=pulumi.get(__response__, 'rotation_interval'),
        rotation_number=pulumi.get(__response__, 'rotation_number'),
        scheduled_deletion_date=pulumi.get(__response__, 'scheduled_deletion_date'),
        tags=pulumi.get(__response__, 'tags')))
