# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetKeypairsResult',
    'AwaitableGetKeypairsResult',
    'get_keypairs',
    'get_keypairs_output',
]

@pulumi.output_type
class GetKeypairsResult:
    """
    A collection of values returned by getKeypairs.
    """
    def __init__(__self__, fingerprint=None, id=None, is_managed=None, keypairs=None, name=None, public_key=None, region=None):
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_managed and not isinstance(is_managed, bool):
            raise TypeError("Expected argument 'is_managed' to be a bool")
        pulumi.set(__self__, "is_managed", is_managed)
        if keypairs and not isinstance(keypairs, list):
            raise TypeError("Expected argument 'keypairs' to be a list")
        pulumi.set(__self__, "keypairs", keypairs)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[_builtins.str]:
        """
        Indicates the fingerprint information about a keypair.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isManaged")
    def is_managed(self) -> Optional[_builtins.bool]:
        """
        Indicates whether the private key is managed by sberCloud.
        """
        return pulumi.get(self, "is_managed")

    @_builtins.property
    @pulumi.getter
    def keypairs(self) -> Sequence['outputs.GetKeypairsKeypairResult']:
        """
        The KPS keypairs list.
        """
        return pulumi.get(self, "keypairs")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Indicates the name of the keypair.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[_builtins.str]:
        """
        Indicates the imported OpenSSH-formatted public key.
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")


class AwaitableGetKeypairsResult(GetKeypairsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeypairsResult(
            fingerprint=self.fingerprint,
            id=self.id,
            is_managed=self.is_managed,
            keypairs=self.keypairs,
            name=self.name,
            public_key=self.public_key,
            region=self.region)


def get_keypairs(fingerprint: Optional[_builtins.str] = None,
                 is_managed: Optional[_builtins.bool] = None,
                 name: Optional[_builtins.str] = None,
                 public_key: Optional[_builtins.str] = None,
                 region: Optional[_builtins.str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeypairsResult:
    """
    Use this data source to get a list of keypairs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    keypair_name = config.require_object("keypairName")
    test = sbercloud.Dew.get_keypairs(name=keypair_name)
    ```


    :param _builtins.str fingerprint: Specifies the fingerprint of the keypair.
    :param _builtins.bool is_managed: Indicates whether the private key is managed by sberCloud.
    :param _builtins.str name: Specifies the name of the keypair.
    :param _builtins.str public_key: Specifies the imported OpenSSH-formatted public key.
    :param _builtins.str region: Specifies the region in which to obtain the keypairs. If omitted, the provider-level
           region will be used.
    """
    __args__ = dict()
    __args__['fingerprint'] = fingerprint
    __args__['isManaged'] = is_managed
    __args__['name'] = name
    __args__['publicKey'] = public_key
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Dew/getKeypairs:getKeypairs', __args__, opts=opts, typ=GetKeypairsResult).value

    return AwaitableGetKeypairsResult(
        fingerprint=pulumi.get(__ret__, 'fingerprint'),
        id=pulumi.get(__ret__, 'id'),
        is_managed=pulumi.get(__ret__, 'is_managed'),
        keypairs=pulumi.get(__ret__, 'keypairs'),
        name=pulumi.get(__ret__, 'name'),
        public_key=pulumi.get(__ret__, 'public_key'),
        region=pulumi.get(__ret__, 'region'))
def get_keypairs_output(fingerprint: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        is_managed: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                        name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        public_key: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKeypairsResult]:
    """
    Use this data source to get a list of keypairs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    keypair_name = config.require_object("keypairName")
    test = sbercloud.Dew.get_keypairs(name=keypair_name)
    ```


    :param _builtins.str fingerprint: Specifies the fingerprint of the keypair.
    :param _builtins.bool is_managed: Indicates whether the private key is managed by sberCloud.
    :param _builtins.str name: Specifies the name of the keypair.
    :param _builtins.str public_key: Specifies the imported OpenSSH-formatted public key.
    :param _builtins.str region: Specifies the region in which to obtain the keypairs. If omitted, the provider-level
           region will be used.
    """
    __args__ = dict()
    __args__['fingerprint'] = fingerprint
    __args__['isManaged'] = is_managed
    __args__['name'] = name
    __args__['publicKey'] = public_key
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Dew/getKeypairs:getKeypairs', __args__, opts=opts, typ=GetKeypairsResult)
    return __ret__.apply(lambda __response__: GetKeypairsResult(
        fingerprint=pulumi.get(__response__, 'fingerprint'),
        id=pulumi.get(__response__, 'id'),
        is_managed=pulumi.get(__response__, 'is_managed'),
        keypairs=pulumi.get(__response__, 'keypairs'),
        name=pulumi.get(__response__, 'name'),
        public_key=pulumi.get(__response__, 'public_key'),
        region=pulumi.get(__response__, 'region')))
