# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['KeyArgs', 'Key']

@pulumi.input_type
class KeyArgs:
    def __init__(__self__, *,
                 key_alias: pulumi.Input[_builtins.str],
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 key_description: Optional[pulumi.Input[_builtins.str]] = None,
                 key_usage: Optional[pulumi.Input[_builtins.str]] = None,
                 keystore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 origin: Optional[pulumi.Input[_builtins.str]] = None,
                 pending_days: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 rotation_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Key resource.
        :param pulumi.Input[_builtins.str] key_alias: The alias in which to create the key. It is required when
               we create a new key. Changing this updates the alias of key.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the kms key. Changing this creates a new key.
        :param pulumi.Input[_builtins.bool] is_enabled: Specifies whether the key is enabled. Defaults to true.
               Changing this updates the state of existing key.
        :param pulumi.Input[_builtins.str] key_algorithm: The algorithm of the key. Valid values are AES_256, SM4, RSA_2048, RSA_3072,
               RSA_4096, EC_P256, EC_P384, SM2. Changing this creates a new key.
        :param pulumi.Input[_builtins.str] key_description: The description of the key as viewed in Sber console.
               Changing this updates the description of key.
        :param pulumi.Input[_builtins.str] pending_days: Duration in days after which the key is deleted
               after destruction of the resource, must be between 7 and 1096 days. It doesn't
               have default value. It only be used when delete a key.
        :param pulumi.Input[_builtins.str] region: The region in which to create the KMS key resource. If omitted, the provider-level region will be used. Changing this creates a new KMS key resource.
        :param pulumi.Input[_builtins.bool] rotation_enabled: Specifies whether the key rotation is enabled. Defaults to false.
        :param pulumi.Input[_builtins.int] rotation_interval: Specifies the key rotation interval. The valid value is range from 30 to 365,
               defaults to 365.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the kms key.
        """
        pulumi.set(__self__, "key_alias", key_alias)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if key_algorithm is not None:
            pulumi.set(__self__, "key_algorithm", key_algorithm)
        if key_description is not None:
            pulumi.set(__self__, "key_description", key_description)
        if key_usage is not None:
            pulumi.set(__self__, "key_usage", key_usage)
        if keystore_id is not None:
            pulumi.set(__self__, "keystore_id", keystore_id)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if pending_days is not None:
            pulumi.set(__self__, "pending_days", pending_days)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rotation_enabled is not None:
            pulumi.set(__self__, "rotation_enabled", rotation_enabled)
        if rotation_interval is not None:
            pulumi.set(__self__, "rotation_interval", rotation_interval)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="keyAlias")
    def key_alias(self) -> pulumi.Input[_builtins.str]:
        """
        The alias in which to create the key. It is required when
        we create a new key. Changing this updates the alias of key.
        """
        return pulumi.get(self, "key_alias")

    @key_alias.setter
    def key_alias(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_alias", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the kms key. Changing this creates a new key.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the key is enabled. Defaults to true.
        Changing this updates the state of existing key.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The algorithm of the key. Valid values are AES_256, SM4, RSA_2048, RSA_3072,
        RSA_4096, EC_P256, EC_P384, SM2. Changing this creates a new key.
        """
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="keyDescription")
    def key_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the key as viewed in Sber console.
        Changing this updates the description of key.
        """
        return pulumi.get(self, "key_description")

    @key_description.setter
    def key_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_description", value)

    @_builtins.property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "key_usage")

    @key_usage.setter
    def key_usage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_usage", value)

    @_builtins.property
    @pulumi.getter(name="keystoreId")
    def keystore_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "keystore_id")

    @keystore_id.setter
    def keystore_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keystore_id", value)

    @_builtins.property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin", value)

    @_builtins.property
    @pulumi.getter(name="pendingDays")
    def pending_days(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Duration in days after which the key is deleted
        after destruction of the resource, must be between 7 and 1096 days. It doesn't
        have default value. It only be used when delete a key.
        """
        return pulumi.get(self, "pending_days")

    @pending_days.setter
    def pending_days(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pending_days", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the KMS key resource. If omitted, the provider-level region will be used. Changing this creates a new KMS key resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rotationEnabled")
    def rotation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the key rotation is enabled. Defaults to false.
        """
        return pulumi.get(self, "rotation_enabled")

    @rotation_enabled.setter
    def rotation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rotation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the key rotation interval. The valid value is range from 30 to 365,
        defaults to 365.
        """
        return pulumi.get(self, "rotation_interval")

    @rotation_interval.setter
    def rotation_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_interval", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the kms key.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _KeyState:
    def __init__(__self__, *,
                 creation_date: Optional[pulumi.Input[_builtins.str]] = None,
                 default_key_flag: Optional[pulumi.Input[_builtins.str]] = None,
                 domain_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_time: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 key_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 key_description: Optional[pulumi.Input[_builtins.str]] = None,
                 key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_state: Optional[pulumi.Input[_builtins.str]] = None,
                 key_usage: Optional[pulumi.Input[_builtins.str]] = None,
                 keystore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 origin: Optional[pulumi.Input[_builtins.str]] = None,
                 pending_days: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 rotation_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 rotation_number: Optional[pulumi.Input[_builtins.int]] = None,
                 scheduled_deletion_date: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Key resources.
        :param pulumi.Input[_builtins.str] creation_date: Creation time (time stamp) of a key.
        :param pulumi.Input[_builtins.str] default_key_flag: Identification of a Master Key. The value 1 indicates a Default
               Master Key, and the value 0 indicates a key.
        :param pulumi.Input[_builtins.str] domain_id: ID of a user domain for the key.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the kms key. Changing this creates a new key.
        :param pulumi.Input[_builtins.str] expiration_time: Expiration time.
        :param pulumi.Input[_builtins.bool] is_enabled: Specifies whether the key is enabled. Defaults to true.
               Changing this updates the state of existing key.
        :param pulumi.Input[_builtins.str] key_algorithm: The algorithm of the key. Valid values are AES_256, SM4, RSA_2048, RSA_3072,
               RSA_4096, EC_P256, EC_P384, SM2. Changing this creates a new key.
        :param pulumi.Input[_builtins.str] key_alias: The alias in which to create the key. It is required when
               we create a new key. Changing this updates the alias of key.
        :param pulumi.Input[_builtins.str] key_description: The description of the key as viewed in Sber console.
               Changing this updates the description of key.
        :param pulumi.Input[_builtins.str] key_id: The globally unique identifier for the key.
        :param pulumi.Input[_builtins.str] pending_days: Duration in days after which the key is deleted
               after destruction of the resource, must be between 7 and 1096 days. It doesn't
               have default value. It only be used when delete a key.
        :param pulumi.Input[_builtins.str] region: The region in which to create the KMS key resource. If omitted, the provider-level region will be used. Changing this creates a new KMS key resource.
        :param pulumi.Input[_builtins.bool] rotation_enabled: Specifies whether the key rotation is enabled. Defaults to false.
        :param pulumi.Input[_builtins.int] rotation_interval: Specifies the key rotation interval. The valid value is range from 30 to 365,
               defaults to 365.
        :param pulumi.Input[_builtins.int] rotation_number: The total number of key rotations.
        :param pulumi.Input[_builtins.str] scheduled_deletion_date: Scheduled deletion time (time stamp) of a key.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the kms key.
        """
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if default_key_flag is not None:
            pulumi.set(__self__, "default_key_flag", default_key_flag)
        if domain_id is not None:
            pulumi.set(__self__, "domain_id", domain_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if is_enabled is not None:
            pulumi.set(__self__, "is_enabled", is_enabled)
        if key_algorithm is not None:
            pulumi.set(__self__, "key_algorithm", key_algorithm)
        if key_alias is not None:
            pulumi.set(__self__, "key_alias", key_alias)
        if key_description is not None:
            pulumi.set(__self__, "key_description", key_description)
        if key_id is not None:
            pulumi.set(__self__, "key_id", key_id)
        if key_state is not None:
            pulumi.set(__self__, "key_state", key_state)
        if key_usage is not None:
            pulumi.set(__self__, "key_usage", key_usage)
        if keystore_id is not None:
            pulumi.set(__self__, "keystore_id", keystore_id)
        if origin is not None:
            pulumi.set(__self__, "origin", origin)
        if pending_days is not None:
            pulumi.set(__self__, "pending_days", pending_days)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if rotation_enabled is not None:
            pulumi.set(__self__, "rotation_enabled", rotation_enabled)
        if rotation_interval is not None:
            pulumi.set(__self__, "rotation_interval", rotation_interval)
        if rotation_number is not None:
            pulumi.set(__self__, "rotation_number", rotation_number)
        if scheduled_deletion_date is not None:
            pulumi.set(__self__, "scheduled_deletion_date", scheduled_deletion_date)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Creation time (time stamp) of a key.
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "creation_date", value)

    @_builtins.property
    @pulumi.getter(name="defaultKeyFlag")
    def default_key_flag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Identification of a Master Key. The value 1 indicates a Default
        Master Key, and the value 0 indicates a key.
        """
        return pulumi.get(self, "default_key_flag")

    @default_key_flag.setter
    def default_key_flag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_key_flag", value)

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of a user domain for the key.
        """
        return pulumi.get(self, "domain_id")

    @domain_id.setter
    def domain_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "domain_id", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the kms key. Changing this creates a new key.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Expiration time.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiration_time", value)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the key is enabled. Defaults to true.
        Changing this updates the state of existing key.
        """
        return pulumi.get(self, "is_enabled")

    @is_enabled.setter
    def is_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_enabled", value)

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The algorithm of the key. Valid values are AES_256, SM4, RSA_2048, RSA_3072,
        RSA_4096, EC_P256, EC_P384, SM2. Changing this creates a new key.
        """
        return pulumi.get(self, "key_algorithm")

    @key_algorithm.setter
    def key_algorithm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_algorithm", value)

    @_builtins.property
    @pulumi.getter(name="keyAlias")
    def key_alias(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The alias in which to create the key. It is required when
        we create a new key. Changing this updates the alias of key.
        """
        return pulumi.get(self, "key_alias")

    @key_alias.setter
    def key_alias(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_alias", value)

    @_builtins.property
    @pulumi.getter(name="keyDescription")
    def key_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the key as viewed in Sber console.
        Changing this updates the description of key.
        """
        return pulumi.get(self, "key_description")

    @key_description.setter
    def key_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_description", value)

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The globally unique identifier for the key.
        """
        return pulumi.get(self, "key_id")

    @key_id.setter
    def key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_id", value)

    @_builtins.property
    @pulumi.getter(name="keyState")
    def key_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "key_state")

    @key_state.setter
    def key_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_state", value)

    @_builtins.property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "key_usage")

    @key_usage.setter
    def key_usage(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_usage", value)

    @_builtins.property
    @pulumi.getter(name="keystoreId")
    def keystore_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "keystore_id")

    @keystore_id.setter
    def keystore_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "keystore_id", value)

    @_builtins.property
    @pulumi.getter
    def origin(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "origin")

    @origin.setter
    def origin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "origin", value)

    @_builtins.property
    @pulumi.getter(name="pendingDays")
    def pending_days(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Duration in days after which the key is deleted
        after destruction of the resource, must be between 7 and 1096 days. It doesn't
        have default value. It only be used when delete a key.
        """
        return pulumi.get(self, "pending_days")

    @pending_days.setter
    def pending_days(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pending_days", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the KMS key resource. If omitted, the provider-level region will be used. Changing this creates a new KMS key resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="rotationEnabled")
    def rotation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the key rotation is enabled. Defaults to false.
        """
        return pulumi.get(self, "rotation_enabled")

    @rotation_enabled.setter
    def rotation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "rotation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the key rotation interval. The valid value is range from 30 to 365,
        defaults to 365.
        """
        return pulumi.get(self, "rotation_interval")

    @rotation_interval.setter
    def rotation_interval(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_interval", value)

    @_builtins.property
    @pulumi.getter(name="rotationNumber")
    def rotation_number(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The total number of key rotations.
        """
        return pulumi.get(self, "rotation_number")

    @rotation_number.setter
    def rotation_number(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "rotation_number", value)

    @_builtins.property
    @pulumi.getter(name="scheduledDeletionDate")
    def scheduled_deletion_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Scheduled deletion time (time stamp) of a key.
        """
        return pulumi.get(self, "scheduled_deletion_date")

    @scheduled_deletion_date.setter
    def scheduled_deletion_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scheduled_deletion_date", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the kms key.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("sbercloud:Dew/key:Key")
class Key(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 key_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 key_description: Optional[pulumi.Input[_builtins.str]] = None,
                 key_usage: Optional[pulumi.Input[_builtins.str]] = None,
                 keystore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 origin: Optional[pulumi.Input[_builtins.str]] = None,
                 pending_days: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 rotation_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a KMS key resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        key1 = sbercloud.dew.Key("key_1",
            key_alias="key_1",
            pending_days="7",
            key_description="first test key",
            is_enabled=True)
        ```

        ## Import

        KMS Keys can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Dew/key:Key key_1 7056d636-ac60-4663-8a6c-82d3c32c1c64
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the kms key. Changing this creates a new key.
        :param pulumi.Input[_builtins.bool] is_enabled: Specifies whether the key is enabled. Defaults to true.
               Changing this updates the state of existing key.
        :param pulumi.Input[_builtins.str] key_algorithm: The algorithm of the key. Valid values are AES_256, SM4, RSA_2048, RSA_3072,
               RSA_4096, EC_P256, EC_P384, SM2. Changing this creates a new key.
        :param pulumi.Input[_builtins.str] key_alias: The alias in which to create the key. It is required when
               we create a new key. Changing this updates the alias of key.
        :param pulumi.Input[_builtins.str] key_description: The description of the key as viewed in Sber console.
               Changing this updates the description of key.
        :param pulumi.Input[_builtins.str] pending_days: Duration in days after which the key is deleted
               after destruction of the resource, must be between 7 and 1096 days. It doesn't
               have default value. It only be used when delete a key.
        :param pulumi.Input[_builtins.str] region: The region in which to create the KMS key resource. If omitted, the provider-level region will be used. Changing this creates a new KMS key resource.
        :param pulumi.Input[_builtins.bool] rotation_enabled: Specifies whether the key rotation is enabled. Defaults to false.
        :param pulumi.Input[_builtins.int] rotation_interval: Specifies the key rotation interval. The valid value is range from 30 to 365,
               defaults to 365.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the kms key.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KeyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a KMS key resource.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        key1 = sbercloud.dew.Key("key_1",
            key_alias="key_1",
            pending_days="7",
            key_description="first test key",
            is_enabled=True)
        ```

        ## Import

        KMS Keys can be imported using the `id`, e.g.

        ```sh
        $ pulumi import sbercloud:Dew/key:Key key_1 7056d636-ac60-4663-8a6c-82d3c32c1c64
        ```

        :param str resource_name: The name of the resource.
        :param KeyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
                 key_alias: Optional[pulumi.Input[_builtins.str]] = None,
                 key_description: Optional[pulumi.Input[_builtins.str]] = None,
                 key_usage: Optional[pulumi.Input[_builtins.str]] = None,
                 keystore_id: Optional[pulumi.Input[_builtins.str]] = None,
                 origin: Optional[pulumi.Input[_builtins.str]] = None,
                 pending_days: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 rotation_interval: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeyArgs.__new__(KeyArgs)

            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["is_enabled"] = is_enabled
            __props__.__dict__["key_algorithm"] = key_algorithm
            if key_alias is None and not opts.urn:
                raise TypeError("Missing required property 'key_alias'")
            __props__.__dict__["key_alias"] = key_alias
            __props__.__dict__["key_description"] = key_description
            __props__.__dict__["key_usage"] = key_usage
            __props__.__dict__["keystore_id"] = keystore_id
            __props__.__dict__["origin"] = origin
            __props__.__dict__["pending_days"] = pending_days
            __props__.__dict__["region"] = region
            __props__.__dict__["rotation_enabled"] = rotation_enabled
            __props__.__dict__["rotation_interval"] = rotation_interval
            __props__.__dict__["tags"] = tags
            __props__.__dict__["creation_date"] = None
            __props__.__dict__["default_key_flag"] = None
            __props__.__dict__["domain_id"] = None
            __props__.__dict__["expiration_time"] = None
            __props__.__dict__["key_id"] = None
            __props__.__dict__["key_state"] = None
            __props__.__dict__["rotation_number"] = None
            __props__.__dict__["scheduled_deletion_date"] = None
        super(Key, __self__).__init__(
            'sbercloud:Dew/key:Key',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_date: Optional[pulumi.Input[_builtins.str]] = None,
            default_key_flag: Optional[pulumi.Input[_builtins.str]] = None,
            domain_id: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            expiration_time: Optional[pulumi.Input[_builtins.str]] = None,
            is_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            key_algorithm: Optional[pulumi.Input[_builtins.str]] = None,
            key_alias: Optional[pulumi.Input[_builtins.str]] = None,
            key_description: Optional[pulumi.Input[_builtins.str]] = None,
            key_id: Optional[pulumi.Input[_builtins.str]] = None,
            key_state: Optional[pulumi.Input[_builtins.str]] = None,
            key_usage: Optional[pulumi.Input[_builtins.str]] = None,
            keystore_id: Optional[pulumi.Input[_builtins.str]] = None,
            origin: Optional[pulumi.Input[_builtins.str]] = None,
            pending_days: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            rotation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            rotation_interval: Optional[pulumi.Input[_builtins.int]] = None,
            rotation_number: Optional[pulumi.Input[_builtins.int]] = None,
            scheduled_deletion_date: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Key':
        """
        Get an existing Key resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] creation_date: Creation time (time stamp) of a key.
        :param pulumi.Input[_builtins.str] default_key_flag: Identification of a Master Key. The value 1 indicates a Default
               Master Key, and the value 0 indicates a key.
        :param pulumi.Input[_builtins.str] domain_id: ID of a user domain for the key.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the kms key. Changing this creates a new key.
        :param pulumi.Input[_builtins.str] expiration_time: Expiration time.
        :param pulumi.Input[_builtins.bool] is_enabled: Specifies whether the key is enabled. Defaults to true.
               Changing this updates the state of existing key.
        :param pulumi.Input[_builtins.str] key_algorithm: The algorithm of the key. Valid values are AES_256, SM4, RSA_2048, RSA_3072,
               RSA_4096, EC_P256, EC_P384, SM2. Changing this creates a new key.
        :param pulumi.Input[_builtins.str] key_alias: The alias in which to create the key. It is required when
               we create a new key. Changing this updates the alias of key.
        :param pulumi.Input[_builtins.str] key_description: The description of the key as viewed in Sber console.
               Changing this updates the description of key.
        :param pulumi.Input[_builtins.str] key_id: The globally unique identifier for the key.
        :param pulumi.Input[_builtins.str] pending_days: Duration in days after which the key is deleted
               after destruction of the resource, must be between 7 and 1096 days. It doesn't
               have default value. It only be used when delete a key.
        :param pulumi.Input[_builtins.str] region: The region in which to create the KMS key resource. If omitted, the provider-level region will be used. Changing this creates a new KMS key resource.
        :param pulumi.Input[_builtins.bool] rotation_enabled: Specifies whether the key rotation is enabled. Defaults to false.
        :param pulumi.Input[_builtins.int] rotation_interval: Specifies the key rotation interval. The valid value is range from 30 to 365,
               defaults to 365.
        :param pulumi.Input[_builtins.int] rotation_number: The total number of key rotations.
        :param pulumi.Input[_builtins.str] scheduled_deletion_date: Scheduled deletion time (time stamp) of a key.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the kms key.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeyState.__new__(_KeyState)

        __props__.__dict__["creation_date"] = creation_date
        __props__.__dict__["default_key_flag"] = default_key_flag
        __props__.__dict__["domain_id"] = domain_id
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["expiration_time"] = expiration_time
        __props__.__dict__["is_enabled"] = is_enabled
        __props__.__dict__["key_algorithm"] = key_algorithm
        __props__.__dict__["key_alias"] = key_alias
        __props__.__dict__["key_description"] = key_description
        __props__.__dict__["key_id"] = key_id
        __props__.__dict__["key_state"] = key_state
        __props__.__dict__["key_usage"] = key_usage
        __props__.__dict__["keystore_id"] = keystore_id
        __props__.__dict__["origin"] = origin
        __props__.__dict__["pending_days"] = pending_days
        __props__.__dict__["region"] = region
        __props__.__dict__["rotation_enabled"] = rotation_enabled
        __props__.__dict__["rotation_interval"] = rotation_interval
        __props__.__dict__["rotation_number"] = rotation_number
        __props__.__dict__["scheduled_deletion_date"] = scheduled_deletion_date
        __props__.__dict__["tags"] = tags
        return Key(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[_builtins.str]:
        """
        Creation time (time stamp) of a key.
        """
        return pulumi.get(self, "creation_date")

    @_builtins.property
    @pulumi.getter(name="defaultKeyFlag")
    def default_key_flag(self) -> pulumi.Output[_builtins.str]:
        """
        Identification of a Master Key. The value 1 indicates a Default
        Master Key, and the value 0 indicates a key.
        """
        return pulumi.get(self, "default_key_flag")

    @_builtins.property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of a user domain for the key.
        """
        return pulumi.get(self, "domain_id")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project id of the kms key. Changing this creates a new key.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> pulumi.Output[_builtins.str]:
        """
        Expiration time.
        """
        return pulumi.get(self, "expiration_time")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the key is enabled. Defaults to true.
        Changing this updates the state of existing key.
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="keyAlgorithm")
    def key_algorithm(self) -> pulumi.Output[_builtins.str]:
        """
        The algorithm of the key. Valid values are AES_256, SM4, RSA_2048, RSA_3072,
        RSA_4096, EC_P256, EC_P384, SM2. Changing this creates a new key.
        """
        return pulumi.get(self, "key_algorithm")

    @_builtins.property
    @pulumi.getter(name="keyAlias")
    def key_alias(self) -> pulumi.Output[_builtins.str]:
        """
        The alias in which to create the key. It is required when
        we create a new key. Changing this updates the alias of key.
        """
        return pulumi.get(self, "key_alias")

    @_builtins.property
    @pulumi.getter(name="keyDescription")
    def key_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the key as viewed in Sber console.
        Changing this updates the description of key.
        """
        return pulumi.get(self, "key_description")

    @_builtins.property
    @pulumi.getter(name="keyId")
    def key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The globally unique identifier for the key.
        """
        return pulumi.get(self, "key_id")

    @_builtins.property
    @pulumi.getter(name="keyState")
    def key_state(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "key_state")

    @_builtins.property
    @pulumi.getter(name="keyUsage")
    def key_usage(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "key_usage")

    @_builtins.property
    @pulumi.getter(name="keystoreId")
    def keystore_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "keystore_id")

    @_builtins.property
    @pulumi.getter
    def origin(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "origin")

    @_builtins.property
    @pulumi.getter(name="pendingDays")
    def pending_days(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Duration in days after which the key is deleted
        after destruction of the resource, must be between 7 and 1096 days. It doesn't
        have default value. It only be used when delete a key.
        """
        return pulumi.get(self, "pending_days")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the KMS key resource. If omitted, the provider-level region will be used. Changing this creates a new KMS key resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="rotationEnabled")
    def rotation_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the key rotation is enabled. Defaults to false.
        """
        return pulumi.get(self, "rotation_enabled")

    @_builtins.property
    @pulumi.getter(name="rotationInterval")
    def rotation_interval(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the key rotation interval. The valid value is range from 30 to 365,
        defaults to 365.
        """
        return pulumi.get(self, "rotation_interval")

    @_builtins.property
    @pulumi.getter(name="rotationNumber")
    def rotation_number(self) -> pulumi.Output[_builtins.int]:
        """
        The total number of key rotations.
        """
        return pulumi.get(self, "rotation_number")

    @_builtins.property
    @pulumi.getter(name="scheduledDeletionDate")
    def scheduled_deletion_date(self) -> pulumi.Output[_builtins.str]:
        """
        Scheduled deletion time (time stamp) of a key.
        """
        return pulumi.get(self, "scheduled_deletion_date")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the key/value pairs to associate with the kms key.
        """
        return pulumi.get(self, "tags")

