# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['KeypairArgs', 'Keypair']

@pulumi.input_type
class KeypairArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_file: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Keypair resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of keypair.
        :param pulumi.Input[_builtins.str] encryption_type: Specifies encryption mode. The options are as follows:
               + **default**: The default encryption mode. Applicable to sites where KMS is not deployed.
               + **kms**: KMS encryption mode.
               
               > 1. Please configure this field to **default** if the KMS service is not available at the site.
               <br/>2. Due to API restrictions, `private_key` must be configured when editing this field.
        :param pulumi.Input[_builtins.str] key_file: Specifies the path of the created private key.
               The private key file (**.pem**) is created only when creating a KPS keypair.
               Importing an existing keypair will not obtain the private key information.
               
               Changing this parameter will create a new resource.
               
               ->**NOTE:** If the private key file already exists, it will be overwritten after a new keypair is created.
        :param pulumi.Input[_builtins.str] kms_key_id: Specifies the KMS key ID to encrypt private keys.
        :param pulumi.Input[_builtins.str] kms_key_name: Specifies the KMS key name to encrypt private keys.
               
               > 1. At least one of `kms_key_id` or `kms_key_name` must be set when `encryption_type` is set to **kms**.
               <br/>2. Due to API restrictions, `private_key` and `encryption_type` must be configured when editing `kms_key_id` or
               `kms_key_name`.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name for the keypair. The name can contain a maximum of `64`
               characters, including letters, digits, underscores (_) and hyphens (-).
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] private_key: Specifies the imported OpenSSH-formatted private key.
               
               > 1. Setting this field to empty during editing will clear the private key.
               <br/>2. Due to API restrictions, `encryption_type` must be configured when configuring this field.
        :param pulumi.Input[_builtins.str] public_key: Specifies the imported OpenSSH-formatted public key.
               It is required when import keypair. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the keypair resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] scope: Specifies the scope of keypair. The options are as follows:
               + **account**: Tenant-level, available to all users under the same account.
               + **user**: User-level, only available to user.
               
               Defaults to `user`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] user_id: Specifies the user ID to which the keypair belongs.
               
               > 1. If the `scope` set to **user**, this parameter value must be the ID of the user who creates the resource.
               <br/>2. Due to API restrictions, `private_key` and `encryption_type` must be configured when editing this field.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of keypair.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies encryption mode. The options are as follows:
        + **default**: The default encryption mode. Applicable to sites where KMS is not deployed.
        + **kms**: KMS encryption mode.

        > 1. Please configure this field to **default** if the KMS service is not available at the site.
        <br/>2. Due to API restrictions, `private_key` must be configured when editing this field.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_type", value)

    @_builtins.property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the path of the created private key.
        The private key file (**.pem**) is created only when creating a KPS keypair.
        Importing an existing keypair will not obtain the private key information.

        Changing this parameter will create a new resource.

        ->**NOTE:** If the private key file already exists, it will be overwritten after a new keypair is created.
        """
        return pulumi.get(self, "key_file")

    @key_file.setter
    def key_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_file", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the KMS key ID to encrypt private keys.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the KMS key name to encrypt private keys.

        > 1. At least one of `kms_key_id` or `kms_key_name` must be set when `encryption_type` is set to **kms**.
        <br/>2. Due to API restrictions, `private_key` and `encryption_type` must be configured when editing `kms_key_id` or
        `kms_key_name`.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a unique name for the keypair. The name can contain a maximum of `64`
        characters, including letters, digits, underscores (_) and hyphens (-).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the imported OpenSSH-formatted private key.

        > 1. Setting this field to empty during editing will clear the private key.
        <br/>2. Due to API restrictions, `encryption_type` must be configured when configuring this field.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the imported OpenSSH-formatted public key.
        It is required when import keypair. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the keypair resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the scope of keypair. The options are as follows:
        + **account**: Tenant-level, available to all users under the same account.
        + **user**: User-level, only available to user.

        Defaults to `user`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the user ID to which the keypair belongs.

        > 1. If the `scope` set to **user**, this parameter value must be the ID of the user who creates the resource.
        <br/>2. Due to API restrictions, `private_key` and `encryption_type` must be configured when editing this field.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _KeypairState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
                 is_managed: Optional[pulumi.Input[_builtins.bool]] = None,
                 key_file: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Keypair resources.
        :param pulumi.Input[_builtins.str] created_at: The keypair creation time.
        :param pulumi.Input[_builtins.str] description: Specifies the description of keypair.
        :param pulumi.Input[_builtins.str] encryption_type: Specifies encryption mode. The options are as follows:
               + **default**: The default encryption mode. Applicable to sites where KMS is not deployed.
               + **kms**: KMS encryption mode.
               
               > 1. Please configure this field to **default** if the KMS service is not available at the site.
               <br/>2. Due to API restrictions, `private_key` must be configured when editing this field.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint information about a keypair.
        :param pulumi.Input[_builtins.bool] is_managed: Whether the private key is managed by sberCloud.
        :param pulumi.Input[_builtins.str] key_file: Specifies the path of the created private key.
               The private key file (**.pem**) is created only when creating a KPS keypair.
               Importing an existing keypair will not obtain the private key information.
               
               Changing this parameter will create a new resource.
               
               ->**NOTE:** If the private key file already exists, it will be overwritten after a new keypair is created.
        :param pulumi.Input[_builtins.str] kms_key_id: Specifies the KMS key ID to encrypt private keys.
        :param pulumi.Input[_builtins.str] kms_key_name: Specifies the KMS key name to encrypt private keys.
               
               > 1. At least one of `kms_key_id` or `kms_key_name` must be set when `encryption_type` is set to **kms**.
               <br/>2. Due to API restrictions, `private_key` and `encryption_type` must be configured when editing `kms_key_id` or
               `kms_key_name`.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name for the keypair. The name can contain a maximum of `64`
               characters, including letters, digits, underscores (_) and hyphens (-).
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] private_key: Specifies the imported OpenSSH-formatted private key.
               
               > 1. Setting this field to empty during editing will clear the private key.
               <br/>2. Due to API restrictions, `encryption_type` must be configured when configuring this field.
        :param pulumi.Input[_builtins.str] public_key: Specifies the imported OpenSSH-formatted public key.
               It is required when import keypair. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the keypair resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] scope: Specifies the scope of keypair. The options are as follows:
               + **account**: Tenant-level, available to all users under the same account.
               + **user**: User-level, only available to user.
               
               Defaults to `user`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] user_id: Specifies the user ID to which the keypair belongs.
               
               > 1. If the `scope` set to **user**, this parameter value must be the ID of the user who creates the resource.
               <br/>2. Due to API restrictions, `private_key` and `encryption_type` must be configured when editing this field.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption_type is not None:
            pulumi.set(__self__, "encryption_type", encryption_type)
        if fingerprint is not None:
            pulumi.set(__self__, "fingerprint", fingerprint)
        if is_managed is not None:
            pulumi.set(__self__, "is_managed", is_managed)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The keypair creation time.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of keypair.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies encryption mode. The options are as follows:
        + **default**: The default encryption mode. Applicable to sites where KMS is not deployed.
        + **kms**: KMS encryption mode.

        > 1. Please configure this field to **default** if the KMS service is not available at the site.
        <br/>2. Due to API restrictions, `private_key` must be configured when editing this field.
        """
        return pulumi.get(self, "encryption_type")

    @encryption_type.setter
    def encryption_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encryption_type", value)

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Fingerprint information about a keypair.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fingerprint", value)

    @_builtins.property
    @pulumi.getter(name="isManaged")
    def is_managed(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the private key is managed by sberCloud.
        """
        return pulumi.get(self, "is_managed")

    @is_managed.setter
    def is_managed(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_managed", value)

    @_builtins.property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the path of the created private key.
        The private key file (**.pem**) is created only when creating a KPS keypair.
        Importing an existing keypair will not obtain the private key information.

        Changing this parameter will create a new resource.

        ->**NOTE:** If the private key file already exists, it will be overwritten after a new keypair is created.
        """
        return pulumi.get(self, "key_file")

    @key_file.setter
    def key_file(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_file", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the KMS key ID to encrypt private keys.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the KMS key name to encrypt private keys.

        > 1. At least one of `kms_key_id` or `kms_key_name` must be set when `encryption_type` is set to **kms**.
        <br/>2. Due to API restrictions, `private_key` and `encryption_type` must be configured when editing `kms_key_id` or
        `kms_key_name`.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a unique name for the keypair. The name can contain a maximum of `64`
        characters, including letters, digits, underscores (_) and hyphens (-).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the imported OpenSSH-formatted private key.

        > 1. Setting this field to empty during editing will clear the private key.
        <br/>2. Due to API restrictions, `encryption_type` must be configured when configuring this field.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the imported OpenSSH-formatted public key.
        It is required when import keypair. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the keypair resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the scope of keypair. The options are as follows:
        + **account**: Tenant-level, available to all users under the same account.
        + **user**: User-level, only available to user.

        Defaults to `user`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the user ID to which the keypair belongs.

        > 1. If the `scope` set to **user**, this parameter value must be the ID of the user who creates the resource.
        <br/>2. Due to API restrictions, `private_key` and `encryption_type` must be configured when editing this field.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.type_token("sbercloud:Dew/keypair:Keypair")
class Keypair(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_file: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a keypair resource within SberCloud.

        By default, keypair use the SSH-2 (RSA, 2048) algorithm for encryption and decryption.

        Keys imported support the following cryptographic algorithms:

         * RSA-1024
         * RSA-2048
         * RSA-4096

        ## Example Usage

        ### Create a new KPS keypair

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        kms_key_id = config.require_object("kmsKeyId")
        kms_key_name = config.require_object("kmsKeyName")
        key_file = config.require_object("keyFile")
        test = sbercloud.dew.Keypair("test",
            name="test-name",
            scope="user",
            encryption_type="kms",
            kms_key_id=kms_key_id,
            kms_key_name=kms_key_name,
            description="test description",
            key_file=key_file)
        ```

        ### Import an existing KPS keypair

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        public_key = config.require_object("publicKey")
        private_key = config.require_object("privateKey")
        test = sbercloud.dew.Keypair("test",
            name="test-name",
            scope="account",
            encryption_type="default",
            description="test description",
            public_key=public_key,
            private_key=private_key)
        ```

        ### Import an existing KPS keypair without private key

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        public_key = config.require_object("publicKey")
        test = sbercloud.dew.Keypair("test",
            name="test-name",
            scope="account",
            description="test description",
            public_key=public_key)
        ```

        ## Import

        Keypair can be imported using the `name`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Dew/keypair:Keypair test <name>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `encryption_type`, `kms_key_id`,

        `kms_key_name`, `key_file` and `private_key`. It is generally recommended running `pulumi preview` after importing a keypair.

        You can then decide if changes should be applied to the keypair, or the resource definition

        should be updated to align with the keypair. Also, you can ignore changes as below.

        hcl

        resource "sbercloud_kps_keypair" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              encryption_type, kms_key_id, kms_key_name, key_file, private_key
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of keypair.
        :param pulumi.Input[_builtins.str] encryption_type: Specifies encryption mode. The options are as follows:
               + **default**: The default encryption mode. Applicable to sites where KMS is not deployed.
               + **kms**: KMS encryption mode.
               
               > 1. Please configure this field to **default** if the KMS service is not available at the site.
               <br/>2. Due to API restrictions, `private_key` must be configured when editing this field.
        :param pulumi.Input[_builtins.str] key_file: Specifies the path of the created private key.
               The private key file (**.pem**) is created only when creating a KPS keypair.
               Importing an existing keypair will not obtain the private key information.
               
               Changing this parameter will create a new resource.
               
               ->**NOTE:** If the private key file already exists, it will be overwritten after a new keypair is created.
        :param pulumi.Input[_builtins.str] kms_key_id: Specifies the KMS key ID to encrypt private keys.
        :param pulumi.Input[_builtins.str] kms_key_name: Specifies the KMS key name to encrypt private keys.
               
               > 1. At least one of `kms_key_id` or `kms_key_name` must be set when `encryption_type` is set to **kms**.
               <br/>2. Due to API restrictions, `private_key` and `encryption_type` must be configured when editing `kms_key_id` or
               `kms_key_name`.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name for the keypair. The name can contain a maximum of `64`
               characters, including letters, digits, underscores (_) and hyphens (-).
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] private_key: Specifies the imported OpenSSH-formatted private key.
               
               > 1. Setting this field to empty during editing will clear the private key.
               <br/>2. Due to API restrictions, `encryption_type` must be configured when configuring this field.
        :param pulumi.Input[_builtins.str] public_key: Specifies the imported OpenSSH-formatted public key.
               It is required when import keypair. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the keypair resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] scope: Specifies the scope of keypair. The options are as follows:
               + **account**: Tenant-level, available to all users under the same account.
               + **user**: User-level, only available to user.
               
               Defaults to `user`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] user_id: Specifies the user ID to which the keypair belongs.
               
               > 1. If the `scope` set to **user**, this parameter value must be the ID of the user who creates the resource.
               <br/>2. Due to API restrictions, `private_key` and `encryption_type` must be configured when editing this field.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[KeypairArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a keypair resource within SberCloud.

        By default, keypair use the SSH-2 (RSA, 2048) algorithm for encryption and decryption.

        Keys imported support the following cryptographic algorithms:

         * RSA-1024
         * RSA-2048
         * RSA-4096

        ## Example Usage

        ### Create a new KPS keypair

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        kms_key_id = config.require_object("kmsKeyId")
        kms_key_name = config.require_object("kmsKeyName")
        key_file = config.require_object("keyFile")
        test = sbercloud.dew.Keypair("test",
            name="test-name",
            scope="user",
            encryption_type="kms",
            kms_key_id=kms_key_id,
            kms_key_name=kms_key_name,
            description="test description",
            key_file=key_file)
        ```

        ### Import an existing KPS keypair

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        public_key = config.require_object("publicKey")
        private_key = config.require_object("privateKey")
        test = sbercloud.dew.Keypair("test",
            name="test-name",
            scope="account",
            encryption_type="default",
            description="test description",
            public_key=public_key,
            private_key=private_key)
        ```

        ### Import an existing KPS keypair without private key

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        public_key = config.require_object("publicKey")
        test = sbercloud.dew.Keypair("test",
            name="test-name",
            scope="account",
            description="test description",
            public_key=public_key)
        ```

        ## Import

        Keypair can be imported using the `name`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:Dew/keypair:Keypair test <name>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `encryption_type`, `kms_key_id`,

        `kms_key_name`, `key_file` and `private_key`. It is generally recommended running `pulumi preview` after importing a keypair.

        You can then decide if changes should be applied to the keypair, or the resource definition

        should be updated to align with the keypair. Also, you can ignore changes as below.

        hcl

        resource "sbercloud_kps_keypair" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              encryption_type, kms_key_id, kms_key_name, key_file, private_key
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param KeypairArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeypairArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
                 key_file: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeypairArgs.__new__(KeypairArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["encryption_type"] = encryption_type
            __props__.__dict__["key_file"] = key_file
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["kms_key_name"] = kms_key_name
            __props__.__dict__["name"] = name
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["public_key"] = public_key
            __props__.__dict__["region"] = region
            __props__.__dict__["scope"] = scope
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["created_at"] = None
            __props__.__dict__["fingerprint"] = None
            __props__.__dict__["is_managed"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Keypair, __self__).__init__(
            'sbercloud:Dew/keypair:Keypair',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            encryption_type: Optional[pulumi.Input[_builtins.str]] = None,
            fingerprint: Optional[pulumi.Input[_builtins.str]] = None,
            is_managed: Optional[pulumi.Input[_builtins.bool]] = None,
            key_file: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            kms_key_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            public_key: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Keypair':
        """
        Get an existing Keypair resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: The keypair creation time.
        :param pulumi.Input[_builtins.str] description: Specifies the description of keypair.
        :param pulumi.Input[_builtins.str] encryption_type: Specifies encryption mode. The options are as follows:
               + **default**: The default encryption mode. Applicable to sites where KMS is not deployed.
               + **kms**: KMS encryption mode.
               
               > 1. Please configure this field to **default** if the KMS service is not available at the site.
               <br/>2. Due to API restrictions, `private_key` must be configured when editing this field.
        :param pulumi.Input[_builtins.str] fingerprint: Fingerprint information about a keypair.
        :param pulumi.Input[_builtins.bool] is_managed: Whether the private key is managed by sberCloud.
        :param pulumi.Input[_builtins.str] key_file: Specifies the path of the created private key.
               The private key file (**.pem**) is created only when creating a KPS keypair.
               Importing an existing keypair will not obtain the private key information.
               
               Changing this parameter will create a new resource.
               
               ->**NOTE:** If the private key file already exists, it will be overwritten after a new keypair is created.
        :param pulumi.Input[_builtins.str] kms_key_id: Specifies the KMS key ID to encrypt private keys.
        :param pulumi.Input[_builtins.str] kms_key_name: Specifies the KMS key name to encrypt private keys.
               
               > 1. At least one of `kms_key_id` or `kms_key_name` must be set when `encryption_type` is set to **kms**.
               <br/>2. Due to API restrictions, `private_key` and `encryption_type` must be configured when editing `kms_key_id` or
               `kms_key_name`.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name for the keypair. The name can contain a maximum of `64`
               characters, including letters, digits, underscores (_) and hyphens (-).
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] private_key: Specifies the imported OpenSSH-formatted private key.
               
               > 1. Setting this field to empty during editing will clear the private key.
               <br/>2. Due to API restrictions, `encryption_type` must be configured when configuring this field.
        :param pulumi.Input[_builtins.str] public_key: Specifies the imported OpenSSH-formatted public key.
               It is required when import keypair. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the keypair resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] scope: Specifies the scope of keypair. The options are as follows:
               + **account**: Tenant-level, available to all users under the same account.
               + **user**: User-level, only available to user.
               
               Defaults to `user`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] user_id: Specifies the user ID to which the keypair belongs.
               
               > 1. If the `scope` set to **user**, this parameter value must be the ID of the user who creates the resource.
               <br/>2. Due to API restrictions, `private_key` and `encryption_type` must be configured when editing this field.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeypairState.__new__(_KeypairState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["encryption_type"] = encryption_type
        __props__.__dict__["fingerprint"] = fingerprint
        __props__.__dict__["is_managed"] = is_managed
        __props__.__dict__["key_file"] = key_file
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["kms_key_name"] = kms_key_name
        __props__.__dict__["name"] = name
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["region"] = region
        __props__.__dict__["scope"] = scope
        __props__.__dict__["user_id"] = user_id
        return Keypair(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The keypair creation time.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of keypair.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="encryptionType")
    def encryption_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies encryption mode. The options are as follows:
        + **default**: The default encryption mode. Applicable to sites where KMS is not deployed.
        + **kms**: KMS encryption mode.

        > 1. Please configure this field to **default** if the KMS service is not available at the site.
        <br/>2. Due to API restrictions, `private_key` must be configured when editing this field.
        """
        return pulumi.get(self, "encryption_type")

    @_builtins.property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Output[_builtins.str]:
        """
        Fingerprint information about a keypair.
        """
        return pulumi.get(self, "fingerprint")

    @_builtins.property
    @pulumi.getter(name="isManaged")
    def is_managed(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the private key is managed by sberCloud.
        """
        return pulumi.get(self, "is_managed")

    @_builtins.property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the path of the created private key.
        The private key file (**.pem**) is created only when creating a KPS keypair.
        Importing an existing keypair will not obtain the private key information.

        Changing this parameter will create a new resource.

        ->**NOTE:** If the private key file already exists, it will be overwritten after a new keypair is created.
        """
        return pulumi.get(self, "key_file")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the KMS key ID to encrypt private keys.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the KMS key name to encrypt private keys.

        > 1. At least one of `kms_key_id` or `kms_key_name` must be set when `encryption_type` is set to **kms**.
        <br/>2. Due to API restrictions, `private_key` and `encryption_type` must be configured when editing `kms_key_id` or
        `kms_key_name`.
        """
        return pulumi.get(self, "kms_key_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a unique name for the keypair. The name can contain a maximum of `64`
        characters, including letters, digits, underscores (_) and hyphens (-).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the imported OpenSSH-formatted private key.

        > 1. Setting this field to empty during editing will clear the private key.
        <br/>2. Due to API restrictions, `encryption_type` must be configured when configuring this field.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the imported OpenSSH-formatted public key.
        It is required when import keypair. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the keypair resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the scope of keypair. The options are as follows:
        + **account**: Tenant-level, available to all users under the same account.
        + **user**: User-level, only available to user.

        Defaults to `user`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the user ID to which the keypair belongs.

        > 1. If the `scope` set to **user**, this parameter value must be the ID of the user who creates the resource.
        <br/>2. Due to API restrictions, `private_key` and `encryption_type` must be configured when editing this field.
        """
        return pulumi.get(self, "user_id")

