# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StreamArgs', 'Stream']

@pulumi.input_type
class StreamArgs:
    def __init__(__self__, *,
                 partition_count: pulumi.Input[_builtins.int],
                 stream_name: pulumi.Input[_builtins.str],
                 auto_scale_max_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_scale_min_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
                 compression_format: Optional[pulumi.Input[_builtins.str]] = None,
                 csv_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
                 data_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 stream_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Stream resource.
        :param pulumi.Input[_builtins.int] partition_count: Number of the expect partitions. NOTE: Each stream can be scaled up and down a
               total of five times within one hour. After the stream is successfully scaled up or down, it cannot be scaled up or
               down again within the next one hour.
        :param pulumi.Input[_builtins.str] stream_name: Name of the DIS stream to be created.
        :param pulumi.Input[_builtins.int] auto_scale_max_partition_count: Maximum number of partition for automatic scaling.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] auto_scale_min_partition_count: Minimum number of partition for automatic scaling.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] compression_format: Data compression type. The value is one of snappy, gzip and zip.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] csv_delimiter: Field separator for CSV file. Changing this parameter will create a new
               resource.
        :param pulumi.Input[_builtins.str] data_schema: User's JOSN, CSV format data schema, described with Avro schema. Changing
               this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] data_type: Data type of the data putting into the stream. The value is one of `BLOB`,
               `JSON` and `CSV`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the dis stream, Value 0
               indicates the default enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DIS stream resource. If omitted, the
               provider-level region will be used. Changing this creates a new DIS Stream resource.
        :param pulumi.Input[_builtins.int] retention_period: The number of hours for which data from the stream will be retained in DIS.
               Value range: `24` to `72`. Unit: `hour`. Default:`24`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] stream_type: Stream Type. The value is COMMON(means 1M bandwidth) or ADVANCED(means 5M
               bandwidth). Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the stream.
        """
        pulumi.set(__self__, "partition_count", partition_count)
        pulumi.set(__self__, "stream_name", stream_name)
        if auto_scale_max_partition_count is not None:
            pulumi.set(__self__, "auto_scale_max_partition_count", auto_scale_max_partition_count)
        if auto_scale_min_partition_count is not None:
            pulumi.set(__self__, "auto_scale_min_partition_count", auto_scale_min_partition_count)
        if compression_format is not None:
            pulumi.set(__self__, "compression_format", compression_format)
        if csv_delimiter is not None:
            pulumi.set(__self__, "csv_delimiter", csv_delimiter)
        if data_schema is not None:
            pulumi.set(__self__, "data_schema", data_schema)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if stream_type is not None:
            pulumi.set(__self__, "stream_type", stream_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="partitionCount")
    def partition_count(self) -> pulumi.Input[_builtins.int]:
        """
        Number of the expect partitions. NOTE: Each stream can be scaled up and down a
        total of five times within one hour. After the stream is successfully scaled up or down, it cannot be scaled up or
        down again within the next one hour.
        """
        return pulumi.get(self, "partition_count")

    @partition_count.setter
    def partition_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "partition_count", value)

    @_builtins.property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> pulumi.Input[_builtins.str]:
        """
        Name of the DIS stream to be created.
        """
        return pulumi.get(self, "stream_name")

    @stream_name.setter
    def stream_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "stream_name", value)

    @_builtins.property
    @pulumi.getter(name="autoScaleMaxPartitionCount")
    def auto_scale_max_partition_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of partition for automatic scaling.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_scale_max_partition_count")

    @auto_scale_max_partition_count.setter
    def auto_scale_max_partition_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_scale_max_partition_count", value)

    @_builtins.property
    @pulumi.getter(name="autoScaleMinPartitionCount")
    def auto_scale_min_partition_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of partition for automatic scaling.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_scale_min_partition_count")

    @auto_scale_min_partition_count.setter
    def auto_scale_min_partition_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_scale_min_partition_count", value)

    @_builtins.property
    @pulumi.getter(name="compressionFormat")
    def compression_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data compression type. The value is one of snappy, gzip and zip.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "compression_format")

    @compression_format.setter
    def compression_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compression_format", value)

    @_builtins.property
    @pulumi.getter(name="csvDelimiter")
    def csv_delimiter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field separator for CSV file. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "csv_delimiter")

    @csv_delimiter.setter
    def csv_delimiter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "csv_delimiter", value)

    @_builtins.property
    @pulumi.getter(name="dataSchema")
    def data_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User's JOSN, CSV format data schema, described with Avro schema. Changing
        this parameter will create a new resource.
        """
        return pulumi.get(self, "data_schema")

    @data_schema.setter
    def data_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_schema", value)

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data type of the data putting into the stream. The value is one of `BLOB`,
        `JSON` and `CSV`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_type", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the dis stream, Value 0
        indicates the default enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the DIS stream resource. If omitted, the
        provider-level region will be used. Changing this creates a new DIS Stream resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of hours for which data from the stream will be retained in DIS.
        Value range: `24` to `72`. Unit: `hour`. Default:`24`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_period", value)

    @_builtins.property
    @pulumi.getter(name="streamType")
    def stream_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Stream Type. The value is COMMON(means 1M bandwidth) or ADVANCED(means 5M
        bandwidth). Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "stream_type")

    @stream_type.setter
    def stream_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the stream.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _StreamState:
    def __init__(__self__, *,
                 auto_scale_max_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_scale_min_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
                 compression_format: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.int]] = None,
                 csv_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
                 data_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_count: Optional[pulumi.Input[_builtins.int]] = None,
                 partitions: Optional[pulumi.Input[Sequence[pulumi.Input['StreamPartitionArgs']]]] = None,
                 readable_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_id: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 writable_partition_count: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering Stream resources.
        :param pulumi.Input[_builtins.int] auto_scale_max_partition_count: Maximum number of partition for automatic scaling.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] auto_scale_min_partition_count: Minimum number of partition for automatic scaling.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] compression_format: Data compression type. The value is one of snappy, gzip and zip.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] created: Timestamp at which the DIS stream was created.
        :param pulumi.Input[_builtins.str] csv_delimiter: Field separator for CSV file. Changing this parameter will create a new
               resource.
        :param pulumi.Input[_builtins.str] data_schema: User's JOSN, CSV format data schema, described with Avro schema. Changing
               this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] data_type: Data type of the data putting into the stream. The value is one of `BLOB`,
               `JSON` and `CSV`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the dis stream, Value 0
               indicates the default enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] partition_count: Number of the expect partitions. NOTE: Each stream can be scaled up and down a
               total of five times within one hour. After the stream is successfully scaled up or down, it cannot be scaled up or
               down again within the next one hour.
        :param pulumi.Input[Sequence[pulumi.Input['StreamPartitionArgs']]] partitions: The information of stream partitions. Structure is documented below.
        :param pulumi.Input[_builtins.int] readable_partition_count: Total number of readable partitions (including partitions in ACTIVE state only).
        :param pulumi.Input[_builtins.str] region: The region in which to create the DIS stream resource. If omitted, the
               provider-level region will be used. Changing this creates a new DIS Stream resource.
        :param pulumi.Input[_builtins.int] retention_period: The number of hours for which data from the stream will be retained in DIS.
               Value range: `24` to `72`. Unit: `hour`. Default:`24`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: The status of the partition.
        :param pulumi.Input[_builtins.str] stream_id: Indicates a stream ID in UUID format.
        :param pulumi.Input[_builtins.str] stream_name: Name of the DIS stream to be created.
        :param pulumi.Input[_builtins.str] stream_type: Stream Type. The value is COMMON(means 1M bandwidth) or ADVANCED(means 5M
               bandwidth). Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the stream.
        :param pulumi.Input[_builtins.int] writable_partition_count: Total number of writable partitions (including partitions in ACTIVE and DELETED states).
        """
        if auto_scale_max_partition_count is not None:
            pulumi.set(__self__, "auto_scale_max_partition_count", auto_scale_max_partition_count)
        if auto_scale_min_partition_count is not None:
            pulumi.set(__self__, "auto_scale_min_partition_count", auto_scale_min_partition_count)
        if compression_format is not None:
            pulumi.set(__self__, "compression_format", compression_format)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if csv_delimiter is not None:
            pulumi.set(__self__, "csv_delimiter", csv_delimiter)
        if data_schema is not None:
            pulumi.set(__self__, "data_schema", data_schema)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if partition_count is not None:
            pulumi.set(__self__, "partition_count", partition_count)
        if partitions is not None:
            pulumi.set(__self__, "partitions", partitions)
        if readable_partition_count is not None:
            pulumi.set(__self__, "readable_partition_count", readable_partition_count)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retention_period is not None:
            pulumi.set(__self__, "retention_period", retention_period)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stream_id is not None:
            pulumi.set(__self__, "stream_id", stream_id)
        if stream_name is not None:
            pulumi.set(__self__, "stream_name", stream_name)
        if stream_type is not None:
            pulumi.set(__self__, "stream_type", stream_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if writable_partition_count is not None:
            pulumi.set(__self__, "writable_partition_count", writable_partition_count)

    @_builtins.property
    @pulumi.getter(name="autoScaleMaxPartitionCount")
    def auto_scale_max_partition_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of partition for automatic scaling.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_scale_max_partition_count")

    @auto_scale_max_partition_count.setter
    def auto_scale_max_partition_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_scale_max_partition_count", value)

    @_builtins.property
    @pulumi.getter(name="autoScaleMinPartitionCount")
    def auto_scale_min_partition_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of partition for automatic scaling.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_scale_min_partition_count")

    @auto_scale_min_partition_count.setter
    def auto_scale_min_partition_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "auto_scale_min_partition_count", value)

    @_builtins.property
    @pulumi.getter(name="compressionFormat")
    def compression_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data compression type. The value is one of snappy, gzip and zip.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "compression_format")

    @compression_format.setter
    def compression_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compression_format", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Timestamp at which the DIS stream was created.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter(name="csvDelimiter")
    def csv_delimiter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Field separator for CSV file. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "csv_delimiter")

    @csv_delimiter.setter
    def csv_delimiter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "csv_delimiter", value)

    @_builtins.property
    @pulumi.getter(name="dataSchema")
    def data_schema(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User's JOSN, CSV format data schema, described with Avro schema. Changing
        this parameter will create a new resource.
        """
        return pulumi.get(self, "data_schema")

    @data_schema.setter
    def data_schema(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_schema", value)

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data type of the data putting into the stream. The value is one of `BLOB`,
        `JSON` and `CSV`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_type", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the dis stream, Value 0
        indicates the default enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="partitionCount")
    def partition_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of the expect partitions. NOTE: Each stream can be scaled up and down a
        total of five times within one hour. After the stream is successfully scaled up or down, it cannot be scaled up or
        down again within the next one hour.
        """
        return pulumi.get(self, "partition_count")

    @partition_count.setter
    def partition_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "partition_count", value)

    @_builtins.property
    @pulumi.getter
    def partitions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StreamPartitionArgs']]]]:
        """
        The information of stream partitions. Structure is documented below.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StreamPartitionArgs']]]]):
        pulumi.set(self, "partitions", value)

    @_builtins.property
    @pulumi.getter(name="readablePartitionCount")
    def readable_partition_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total number of readable partitions (including partitions in ACTIVE state only).
        """
        return pulumi.get(self, "readable_partition_count")

    @readable_partition_count.setter
    def readable_partition_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "readable_partition_count", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the DIS stream resource. If omitted, the
        provider-level region will be used. Changing this creates a new DIS Stream resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of hours for which data from the stream will be retained in DIS.
        Value range: `24` to `72`. Unit: `hour`. Default:`24`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "retention_period")

    @retention_period.setter
    def retention_period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retention_period", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the partition.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates a stream ID in UUID format.
        """
        return pulumi.get(self, "stream_id")

    @stream_id.setter
    def stream_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_id", value)

    @_builtins.property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the DIS stream to be created.
        """
        return pulumi.get(self, "stream_name")

    @stream_name.setter
    def stream_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_name", value)

    @_builtins.property
    @pulumi.getter(name="streamType")
    def stream_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Stream Type. The value is COMMON(means 1M bandwidth) or ADVANCED(means 5M
        bandwidth). Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "stream_type")

    @stream_type.setter
    def stream_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "stream_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the stream.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="writablePartitionCount")
    def writable_partition_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Total number of writable partitions (including partitions in ACTIVE and DELETED states).
        """
        return pulumi.get(self, "writable_partition_count")

    @writable_partition_count.setter
    def writable_partition_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "writable_partition_count", value)


@pulumi.type_token("sbercloud:Dis/stream:Stream")
class Stream(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scale_max_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_scale_min_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
                 compression_format: Optional[pulumi.Input[_builtins.str]] = None,
                 csv_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
                 data_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_count: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 stream_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages DIS Stream resource within SberCloud.

        ## Example Usage

        ### Create a stream that type is BLOB

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        stream = sbercloud.dis.Stream("stream",
            stream_name="terraform_test_dis_stream",
            partition_count=1)
        ```

        ### Create a stream that type is JSON

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        stream = sbercloud.dis.Stream("stream",
            stream_name="terraform_test_dis_stream",
            partition_count=1,
            data_type="JSON",
            data_schema="{\\"type\\":\\"record\\",\\"name\\":\\"RecordName\\",\\"fields\\":[{\\"name\\":\\"id\\",\\"type\\":\\"string\\",\\"doc\\":\\"Type inferred from '\\\\\\"2017/10/11 11:11:11\\\\\\"'\\"},{\\"name\\":\\"info\\",\\"type\\":{\\"type\\":\\"array\\",\\"items\\":{\\"type\\":\\"record\\",\\"name\\":\\"info\\",\\"fields\\":[{\\"name\\":\\"date\\",\\"type\\":\\"string\\",\\"doc\\":\\"Type inferred from '\\\\\\"2018/10/11 11:11:11\\\\\\"'\\"}]}},\\"doc\\":\\"Type inferred from '[{\\\\\\"date\\\\\\":\\\\\\"2018/10/11 11:11:11\\\\\\"}]'\\"}]}")
        ```

        ## Import

        Dis stream can be imported by `stream_name`. For example,

        ```sh
        $ pulumi import sbercloud:Dis/stream:Stream example _abc123
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] auto_scale_max_partition_count: Maximum number of partition for automatic scaling.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] auto_scale_min_partition_count: Minimum number of partition for automatic scaling.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] compression_format: Data compression type. The value is one of snappy, gzip and zip.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] csv_delimiter: Field separator for CSV file. Changing this parameter will create a new
               resource.
        :param pulumi.Input[_builtins.str] data_schema: User's JOSN, CSV format data schema, described with Avro schema. Changing
               this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] data_type: Data type of the data putting into the stream. The value is one of `BLOB`,
               `JSON` and `CSV`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the dis stream, Value 0
               indicates the default enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] partition_count: Number of the expect partitions. NOTE: Each stream can be scaled up and down a
               total of five times within one hour. After the stream is successfully scaled up or down, it cannot be scaled up or
               down again within the next one hour.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DIS stream resource. If omitted, the
               provider-level region will be used. Changing this creates a new DIS Stream resource.
        :param pulumi.Input[_builtins.int] retention_period: The number of hours for which data from the stream will be retained in DIS.
               Value range: `24` to `72`. Unit: `hour`. Default:`24`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] stream_name: Name of the DIS stream to be created.
        :param pulumi.Input[_builtins.str] stream_type: Stream Type. The value is COMMON(means 1M bandwidth) or ADVANCED(means 5M
               bandwidth). Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the stream.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages DIS Stream resource within SberCloud.

        ## Example Usage

        ### Create a stream that type is BLOB

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        stream = sbercloud.dis.Stream("stream",
            stream_name="terraform_test_dis_stream",
            partition_count=1)
        ```

        ### Create a stream that type is JSON

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        stream = sbercloud.dis.Stream("stream",
            stream_name="terraform_test_dis_stream",
            partition_count=1,
            data_type="JSON",
            data_schema="{\\"type\\":\\"record\\",\\"name\\":\\"RecordName\\",\\"fields\\":[{\\"name\\":\\"id\\",\\"type\\":\\"string\\",\\"doc\\":\\"Type inferred from '\\\\\\"2017/10/11 11:11:11\\\\\\"'\\"},{\\"name\\":\\"info\\",\\"type\\":{\\"type\\":\\"array\\",\\"items\\":{\\"type\\":\\"record\\",\\"name\\":\\"info\\",\\"fields\\":[{\\"name\\":\\"date\\",\\"type\\":\\"string\\",\\"doc\\":\\"Type inferred from '\\\\\\"2018/10/11 11:11:11\\\\\\"'\\"}]}},\\"doc\\":\\"Type inferred from '[{\\\\\\"date\\\\\\":\\\\\\"2018/10/11 11:11:11\\\\\\"}]'\\"}]}")
        ```

        ## Import

        Dis stream can be imported by `stream_name`. For example,

        ```sh
        $ pulumi import sbercloud:Dis/stream:Stream example _abc123
        ```

        :param str resource_name: The name of the resource.
        :param StreamArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scale_max_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
                 auto_scale_min_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
                 compression_format: Optional[pulumi.Input[_builtins.str]] = None,
                 csv_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
                 data_schema: Optional[pulumi.Input[_builtins.str]] = None,
                 data_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 partition_count: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_period: Optional[pulumi.Input[_builtins.int]] = None,
                 stream_name: Optional[pulumi.Input[_builtins.str]] = None,
                 stream_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamArgs.__new__(StreamArgs)

            __props__.__dict__["auto_scale_max_partition_count"] = auto_scale_max_partition_count
            __props__.__dict__["auto_scale_min_partition_count"] = auto_scale_min_partition_count
            __props__.__dict__["compression_format"] = compression_format
            __props__.__dict__["csv_delimiter"] = csv_delimiter
            __props__.__dict__["data_schema"] = data_schema
            __props__.__dict__["data_type"] = data_type
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if partition_count is None and not opts.urn:
                raise TypeError("Missing required property 'partition_count'")
            __props__.__dict__["partition_count"] = partition_count
            __props__.__dict__["region"] = region
            __props__.__dict__["retention_period"] = retention_period
            if stream_name is None and not opts.urn:
                raise TypeError("Missing required property 'stream_name'")
            __props__.__dict__["stream_name"] = stream_name
            __props__.__dict__["stream_type"] = stream_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["created"] = None
            __props__.__dict__["partitions"] = None
            __props__.__dict__["readable_partition_count"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["stream_id"] = None
            __props__.__dict__["writable_partition_count"] = None
        super(Stream, __self__).__init__(
            'sbercloud:Dis/stream:Stream',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_scale_max_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
            auto_scale_min_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
            compression_format: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.int]] = None,
            csv_delimiter: Optional[pulumi.Input[_builtins.str]] = None,
            data_schema: Optional[pulumi.Input[_builtins.str]] = None,
            data_type: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            partition_count: Optional[pulumi.Input[_builtins.int]] = None,
            partitions: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StreamPartitionArgs', 'StreamPartitionArgsDict']]]]] = None,
            readable_partition_count: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            retention_period: Optional[pulumi.Input[_builtins.int]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            stream_id: Optional[pulumi.Input[_builtins.str]] = None,
            stream_name: Optional[pulumi.Input[_builtins.str]] = None,
            stream_type: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            writable_partition_count: Optional[pulumi.Input[_builtins.int]] = None) -> 'Stream':
        """
        Get an existing Stream resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] auto_scale_max_partition_count: Maximum number of partition for automatic scaling.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] auto_scale_min_partition_count: Minimum number of partition for automatic scaling.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] compression_format: Data compression type. The value is one of snappy, gzip and zip.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] created: Timestamp at which the DIS stream was created.
        :param pulumi.Input[_builtins.str] csv_delimiter: Field separator for CSV file. Changing this parameter will create a new
               resource.
        :param pulumi.Input[_builtins.str] data_schema: User's JOSN, CSV format data schema, described with Avro schema. Changing
               this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] data_type: Data type of the data putting into the stream. The value is one of `BLOB`,
               `JSON` and `CSV`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the dis stream, Value 0
               indicates the default enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] partition_count: Number of the expect partitions. NOTE: Each stream can be scaled up and down a
               total of five times within one hour. After the stream is successfully scaled up or down, it cannot be scaled up or
               down again within the next one hour.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StreamPartitionArgs', 'StreamPartitionArgsDict']]]] partitions: The information of stream partitions. Structure is documented below.
        :param pulumi.Input[_builtins.int] readable_partition_count: Total number of readable partitions (including partitions in ACTIVE state only).
        :param pulumi.Input[_builtins.str] region: The region in which to create the DIS stream resource. If omitted, the
               provider-level region will be used. Changing this creates a new DIS Stream resource.
        :param pulumi.Input[_builtins.int] retention_period: The number of hours for which data from the stream will be retained in DIS.
               Value range: `24` to `72`. Unit: `hour`. Default:`24`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: The status of the partition.
        :param pulumi.Input[_builtins.str] stream_id: Indicates a stream ID in UUID format.
        :param pulumi.Input[_builtins.str] stream_name: Name of the DIS stream to be created.
        :param pulumi.Input[_builtins.str] stream_type: Stream Type. The value is COMMON(means 1M bandwidth) or ADVANCED(means 5M
               bandwidth). Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the stream.
        :param pulumi.Input[_builtins.int] writable_partition_count: Total number of writable partitions (including partitions in ACTIVE and DELETED states).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamState.__new__(_StreamState)

        __props__.__dict__["auto_scale_max_partition_count"] = auto_scale_max_partition_count
        __props__.__dict__["auto_scale_min_partition_count"] = auto_scale_min_partition_count
        __props__.__dict__["compression_format"] = compression_format
        __props__.__dict__["created"] = created
        __props__.__dict__["csv_delimiter"] = csv_delimiter
        __props__.__dict__["data_schema"] = data_schema
        __props__.__dict__["data_type"] = data_type
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["partition_count"] = partition_count
        __props__.__dict__["partitions"] = partitions
        __props__.__dict__["readable_partition_count"] = readable_partition_count
        __props__.__dict__["region"] = region
        __props__.__dict__["retention_period"] = retention_period
        __props__.__dict__["status"] = status
        __props__.__dict__["stream_id"] = stream_id
        __props__.__dict__["stream_name"] = stream_name
        __props__.__dict__["stream_type"] = stream_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["writable_partition_count"] = writable_partition_count
        return Stream(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoScaleMaxPartitionCount")
    def auto_scale_max_partition_count(self) -> pulumi.Output[_builtins.int]:
        """
        Maximum number of partition for automatic scaling.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_scale_max_partition_count")

    @_builtins.property
    @pulumi.getter(name="autoScaleMinPartitionCount")
    def auto_scale_min_partition_count(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum number of partition for automatic scaling.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_scale_min_partition_count")

    @_builtins.property
    @pulumi.getter(name="compressionFormat")
    def compression_format(self) -> pulumi.Output[_builtins.str]:
        """
        Data compression type. The value is one of snappy, gzip and zip.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "compression_format")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.int]:
        """
        Timestamp at which the DIS stream was created.
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter(name="csvDelimiter")
    def csv_delimiter(self) -> pulumi.Output[_builtins.str]:
        """
        Field separator for CSV file. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "csv_delimiter")

    @_builtins.property
    @pulumi.getter(name="dataSchema")
    def data_schema(self) -> pulumi.Output[_builtins.str]:
        """
        User's JOSN, CSV format data schema, described with Avro schema. Changing
        this parameter will create a new resource.
        """
        return pulumi.get(self, "data_schema")

    @_builtins.property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Output[_builtins.str]:
        """
        Data type of the data putting into the stream. The value is one of `BLOB`,
        `JSON` and `CSV`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "data_type")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project id of the dis stream, Value 0
        indicates the default enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="partitionCount")
    def partition_count(self) -> pulumi.Output[_builtins.int]:
        """
        Number of the expect partitions. NOTE: Each stream can be scaled up and down a
        total of five times within one hour. After the stream is successfully scaled up or down, it cannot be scaled up or
        down again within the next one hour.
        """
        return pulumi.get(self, "partition_count")

    @_builtins.property
    @pulumi.getter
    def partitions(self) -> pulumi.Output[Sequence['outputs.StreamPartition']]:
        """
        The information of stream partitions. Structure is documented below.
        """
        return pulumi.get(self, "partitions")

    @_builtins.property
    @pulumi.getter(name="readablePartitionCount")
    def readable_partition_count(self) -> pulumi.Output[_builtins.int]:
        """
        Total number of readable partitions (including partitions in ACTIVE state only).
        """
        return pulumi.get(self, "readable_partition_count")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the DIS stream resource. If omitted, the
        provider-level region will be used. Changing this creates a new DIS Stream resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="retentionPeriod")
    def retention_period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of hours for which data from the stream will be retained in DIS.
        Value range: `24` to `72`. Unit: `hour`. Default:`24`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "retention_period")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the partition.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="streamId")
    def stream_id(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates a stream ID in UUID format.
        """
        return pulumi.get(self, "stream_id")

    @_builtins.property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of the DIS stream to be created.
        """
        return pulumi.get(self, "stream_name")

    @_builtins.property
    @pulumi.getter(name="streamType")
    def stream_type(self) -> pulumi.Output[_builtins.str]:
        """
        Stream Type. The value is COMMON(means 1M bandwidth) or ADVANCED(means 5M
        bandwidth). Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "stream_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the key/value pairs to associate with the stream.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="writablePartitionCount")
    def writable_partition_count(self) -> pulumi.Output[_builtins.int]:
        """
        Total number of writable partitions (including partitions in ACTIVE and DELETED states).
        """
        return pulumi.get(self, "writable_partition_count")

