# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DatabaseArgs', 'Database']

@pulumi.input_type
class DatabaseArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Database resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of a queue.
               Changing this parameter will create a new database resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID.
               The value 0 indicates the default enterprise project. Changing this parameter will create a new database resource.
        :param pulumi.Input[_builtins.str] name: Specifies the database name. The name consists of 1 to 128 characters, starting
               with a letter or digit. Only letters, digits and underscores (_) are allowed and the name cannot be all digits.
               Changing this parameter will create a new database resource.
        :param pulumi.Input[_builtins.str] owner: Specifies the name of the SQL database owner.
               The owner must be IAM user.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the DLI database resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new database resource.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of a queue.
        Changing this parameter will create a new database resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID.
        The value 0 indicates the default enterprise project. Changing this parameter will create a new database resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database name. The name consists of 1 to 128 characters, starting
        with a letter or digit. Only letters, digits and underscores (_) are allowed and the name cannot be all digits.
        Changing this parameter will create a new database resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the SQL database owner.
        The owner must be IAM user.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the DLI database resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new database resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DatabaseState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Database resources.
        :param pulumi.Input[_builtins.str] description: Specifies the description of a queue.
               Changing this parameter will create a new database resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID.
               The value 0 indicates the default enterprise project. Changing this parameter will create a new database resource.
        :param pulumi.Input[_builtins.str] name: Specifies the database name. The name consists of 1 to 128 characters, starting
               with a letter or digit. Only letters, digits and underscores (_) are allowed and the name cannot be all digits.
               Changing this parameter will create a new database resource.
        :param pulumi.Input[_builtins.str] owner: Specifies the name of the SQL database owner.
               The owner must be IAM user.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the DLI database resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new database resource.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of a queue.
        Changing this parameter will create a new database resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID.
        The value 0 indicates the default enterprise project. Changing this parameter will create a new database resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the database name. The name consists of 1 to 128 characters, starting
        with a letter or digit. Only letters, digits and underscores (_) are allowed and the name cannot be all digits.
        Changing this parameter will create a new database resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the SQL database owner.
        The owner must be IAM user.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the DLI database resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new database resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("sbercloud:Dli/database:Database")
class Database(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages DLI SQL database resource within SberCloud.

        ## Example Usage

        ### Create a database

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        database_name = config.require_object("databaseName")
        test = sbercloud.dli.Database("test", name=database_name)
        ```

        ## Import

        DLI SQL databases can be imported by their `name`, e.g.

        ```sh
        $ pulumi import sbercloud:Dli/database:Database test terraform_test
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of a queue.
               Changing this parameter will create a new database resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID.
               The value 0 indicates the default enterprise project. Changing this parameter will create a new database resource.
        :param pulumi.Input[_builtins.str] name: Specifies the database name. The name consists of 1 to 128 characters, starting
               with a letter or digit. Only letters, digits and underscores (_) are allowed and the name cannot be all digits.
               Changing this parameter will create a new database resource.
        :param pulumi.Input[_builtins.str] owner: Specifies the name of the SQL database owner.
               The owner must be IAM user.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the DLI database resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new database resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[DatabaseArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages DLI SQL database resource within SberCloud.

        ## Example Usage

        ### Create a database

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        database_name = config.require_object("databaseName")
        test = sbercloud.dli.Database("test", name=database_name)
        ```

        ## Import

        DLI SQL databases can be imported by their `name`, e.g.

        ```sh
        $ pulumi import sbercloud:Dli/database:Database test terraform_test
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseArgs.__new__(DatabaseArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["owner"] = owner
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
        super(Database, __self__).__init__(
            'sbercloud:Dli/database:Database',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Database':
        """
        Get an existing Database resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of a queue.
               Changing this parameter will create a new database resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID.
               The value 0 indicates the default enterprise project. Changing this parameter will create a new database resource.
        :param pulumi.Input[_builtins.str] name: Specifies the database name. The name consists of 1 to 128 characters, starting
               with a letter or digit. Only letters, digits and underscores (_) are allowed and the name cannot be all digits.
               Changing this parameter will create a new database resource.
        :param pulumi.Input[_builtins.str] owner: Specifies the name of the SQL database owner.
               The owner must be IAM user.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the DLI database resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new database resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseState.__new__(_DatabaseState)

        __props__.__dict__["description"] = description
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["region"] = region
        __props__.__dict__["tags"] = tags
        return Database(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of a queue.
        Changing this parameter will create a new database resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project ID.
        The value 0 indicates the default enterprise project. Changing this parameter will create a new database resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the database name. The name consists of 1 to 128 characters, starting
        with a letter or digit. Only letters, digits and underscores (_) are allowed and the name cannot be all digits.
        Changing this parameter will create a new database resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the SQL database owner.
        The owner must be IAM user.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the DLI database resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new database resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "tags")

