# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['PackageArgs', 'Package']

@pulumi.input_type
class PackageArgs:
    def __init__(__self__, *,
                 object_path: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_async: Optional[pulumi.Input[_builtins.bool]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Package resource.
        :param pulumi.Input[_builtins.str] object_path: Specifies the OBS storage path where the package is located.
               Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.str] type: Specifies the package type.
               + **jar**: `.jar` or jar related files.
               + **pyFile**: `.py` or python related files.
               + **file**: Other user files.
               
               Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.str] group_name: Specifies the group name which the package belongs to.
               Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.bool] is_async: Specifies whether to upload resource packages in asynchronous mode.
               The default value is **false**. Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.str] owner: Specifies the name of the package owner. The owner must be IAM user.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to upload packages.
               If omitted, the provider-level region will be used.
               Changing this parameter will delete the current package and upload a new package.
        """
        pulumi.set(__self__, "object_path", object_path)
        pulumi.set(__self__, "type", type)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if is_async is not None:
            pulumi.set(__self__, "is_async", is_async)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="objectPath")
    def object_path(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the OBS storage path where the package is located.
        Changing this parameter will delete the current package and upload a new package.
        """
        return pulumi.get(self, "object_path")

    @object_path.setter
    def object_path(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "object_path", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the package type.
        + **jar**: `.jar` or jar related files.
        + **pyFile**: `.py` or python related files.
        + **file**: Other user files.

        Changing this parameter will delete the current package and upload a new package.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the group name which the package belongs to.
        Changing this parameter will delete the current package and upload a new package.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter(name="isAsync")
    def is_async(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to upload resource packages in asynchronous mode.
        The default value is **false**. Changing this parameter will delete the current package and upload a new package.
        """
        return pulumi.get(self, "is_async")

    @is_async.setter
    def is_async(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_async", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the package owner. The owner must be IAM user.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to upload packages.
        If omitted, the provider-level region will be used.
        Changing this parameter will delete the current package and upload a new package.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _PackageState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_async: Optional[pulumi.Input[_builtins.bool]] = None,
                 object_name: Optional[pulumi.Input[_builtins.str]] = None,
                 object_path: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Package resources.
        :param pulumi.Input[_builtins.str] created_at: Time when a queue is created.
        :param pulumi.Input[_builtins.str] group_name: Specifies the group name which the package belongs to.
               Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.bool] is_async: Specifies whether to upload resource packages in asynchronous mode.
               The default value is **false**. Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.str] object_name: The package name.
        :param pulumi.Input[_builtins.str] object_path: Specifies the OBS storage path where the package is located.
               Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.str] owner: Specifies the name of the package owner. The owner must be IAM user.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to upload packages.
               If omitted, the provider-level region will be used.
               Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.str] status: Status of a package group to be uploaded.
        :param pulumi.Input[_builtins.str] type: Specifies the package type.
               + **jar**: `.jar` or jar related files.
               + **pyFile**: `.py` or python related files.
               + **file**: Other user files.
               
               Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.str] updated_at: The last time when the package configuration update has complated.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if is_async is not None:
            pulumi.set(__self__, "is_async", is_async)
        if object_name is not None:
            pulumi.set(__self__, "object_name", object_name)
        if object_path is not None:
            pulumi.set(__self__, "object_path", object_path)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time when a queue is created.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the group name which the package belongs to.
        Changing this parameter will delete the current package and upload a new package.
        """
        return pulumi.get(self, "group_name")

    @group_name.setter
    def group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group_name", value)

    @_builtins.property
    @pulumi.getter(name="isAsync")
    def is_async(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to upload resource packages in asynchronous mode.
        The default value is **false**. Changing this parameter will delete the current package and upload a new package.
        """
        return pulumi.get(self, "is_async")

    @is_async.setter
    def is_async(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_async", value)

    @_builtins.property
    @pulumi.getter(name="objectName")
    def object_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The package name.
        """
        return pulumi.get(self, "object_name")

    @object_name.setter
    def object_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_name", value)

    @_builtins.property
    @pulumi.getter(name="objectPath")
    def object_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the OBS storage path where the package is located.
        Changing this parameter will delete the current package and upload a new package.
        """
        return pulumi.get(self, "object_path")

    @object_path.setter
    def object_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "object_path", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the package owner. The owner must be IAM user.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to upload packages.
        If omitted, the provider-level region will be used.
        Changing this parameter will delete the current package and upload a new package.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status of a package group to be uploaded.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the package type.
        + **jar**: `.jar` or jar related files.
        + **pyFile**: `.py` or python related files.
        + **file**: Other user files.

        Changing this parameter will delete the current package and upload a new package.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last time when the package configuration update has complated.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)


@pulumi.type_token("sbercloud:Dli/package:Package")
class Package(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_async: Optional[pulumi.Input[_builtins.bool]] = None,
                 object_path: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages DLI package resource within SberCloud

        ## Example Usage

        ### Upload the specified python script as a resource package

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        group_name = config.require_object("groupName")
        access_domain_name = config.require_object("accessDomainName")
        queue = sbercloud.dli.Package("queue",
            group_name=group_name,
            object_path=f"https://{access_domain_name}/dli/packages/object_file.py",
            type="pyFile")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group_name: Specifies the group name which the package belongs to.
               Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.bool] is_async: Specifies whether to upload resource packages in asynchronous mode.
               The default value is **false**. Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.str] object_path: Specifies the OBS storage path where the package is located.
               Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.str] owner: Specifies the name of the package owner. The owner must be IAM user.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to upload packages.
               If omitted, the provider-level region will be used.
               Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.str] type: Specifies the package type.
               + **jar**: `.jar` or jar related files.
               + **pyFile**: `.py` or python related files.
               + **file**: Other user files.
               
               Changing this parameter will delete the current package and upload a new package.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PackageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages DLI package resource within SberCloud

        ## Example Usage

        ### Upload the specified python script as a resource package

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        group_name = config.require_object("groupName")
        access_domain_name = config.require_object("accessDomainName")
        queue = sbercloud.dli.Package("queue",
            group_name=group_name,
            object_path=f"https://{access_domain_name}/dli/packages/object_file.py",
            type="pyFile")
        ```

        :param str resource_name: The name of the resource.
        :param PackageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PackageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 is_async: Optional[pulumi.Input[_builtins.bool]] = None,
                 object_path: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PackageArgs.__new__(PackageArgs)

            __props__.__dict__["group_name"] = group_name
            __props__.__dict__["is_async"] = is_async
            if object_path is None and not opts.urn:
                raise TypeError("Missing required property 'object_path'")
            __props__.__dict__["object_path"] = object_path
            __props__.__dict__["owner"] = owner
            __props__.__dict__["region"] = region
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["object_name"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
        super(Package, __self__).__init__(
            'sbercloud:Dli/package:Package',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            group_name: Optional[pulumi.Input[_builtins.str]] = None,
            is_async: Optional[pulumi.Input[_builtins.bool]] = None,
            object_name: Optional[pulumi.Input[_builtins.str]] = None,
            object_path: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None) -> 'Package':
        """
        Get an existing Package resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: Time when a queue is created.
        :param pulumi.Input[_builtins.str] group_name: Specifies the group name which the package belongs to.
               Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.bool] is_async: Specifies whether to upload resource packages in asynchronous mode.
               The default value is **false**. Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.str] object_name: The package name.
        :param pulumi.Input[_builtins.str] object_path: Specifies the OBS storage path where the package is located.
               Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.str] owner: Specifies the name of the package owner. The owner must be IAM user.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to upload packages.
               If omitted, the provider-level region will be used.
               Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.str] status: Status of a package group to be uploaded.
        :param pulumi.Input[_builtins.str] type: Specifies the package type.
               + **jar**: `.jar` or jar related files.
               + **pyFile**: `.py` or python related files.
               + **file**: Other user files.
               
               Changing this parameter will delete the current package and upload a new package.
        :param pulumi.Input[_builtins.str] updated_at: The last time when the package configuration update has complated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PackageState.__new__(_PackageState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["group_name"] = group_name
        __props__.__dict__["is_async"] = is_async
        __props__.__dict__["object_name"] = object_name
        __props__.__dict__["object_path"] = object_path
        __props__.__dict__["owner"] = owner
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["updated_at"] = updated_at
        return Package(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Time when a queue is created.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="groupName")
    def group_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the group name which the package belongs to.
        Changing this parameter will delete the current package and upload a new package.
        """
        return pulumi.get(self, "group_name")

    @_builtins.property
    @pulumi.getter(name="isAsync")
    def is_async(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to upload resource packages in asynchronous mode.
        The default value is **false**. Changing this parameter will delete the current package and upload a new package.
        """
        return pulumi.get(self, "is_async")

    @_builtins.property
    @pulumi.getter(name="objectName")
    def object_name(self) -> pulumi.Output[_builtins.str]:
        """
        The package name.
        """
        return pulumi.get(self, "object_name")

    @_builtins.property
    @pulumi.getter(name="objectPath")
    def object_path(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the OBS storage path where the package is located.
        Changing this parameter will delete the current package and upload a new package.
        """
        return pulumi.get(self, "object_path")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the package owner. The owner must be IAM user.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to upload packages.
        If omitted, the provider-level region will be used.
        Changing this parameter will delete the current package and upload a new package.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status of a package group to be uploaded.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the package type.
        + **jar**: `.jar` or jar related files.
        + **pyFile**: `.py` or python related files.
        + **file**: Other user files.

        Changing this parameter will delete the current package and upload a new package.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The last time when the package configuration update has complated.
        """
        return pulumi.get(self, "updated_at")

