# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['QueueArgs', 'Queue']

@pulumi.input_type
class QueueArgs:
    def __init__(__self__, *,
                 cu_count: pulumi.Input[_builtins.int],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 elastic_resource_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 feature: Optional[pulumi.Input[_builtins.str]] = None,
                 management_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 scaling_policies: Optional[pulumi.Input[Sequence[pulumi.Input['QueueScalingPolicyArgs']]]] = None,
                 spark_driver: Optional[pulumi.Input['QueueSparkDriverArgs']] = None,
                 subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_cidr: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Queue resource.
        :param pulumi.Input[_builtins.int] cu_count: Minimum number of CUs that are bound to a queue. Initial value can be `16`,
               `64`, or `256`. When scale_out or scale_in, the number must be a multiple of 16
        :param pulumi.Input[_builtins.str] description: Description of a queue. Changing this parameter will create a new
               resource.
        :param pulumi.Input[_builtins.str] elastic_resource_pool_name: The name of the elastic resource pool to which the queue belongs.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Enterprise project ID. The value 0 indicates the default
               enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] feature: Indicates the queue feature. Changing this parameter will create a new
               resource. The options are as follows:
               + basic: basic type (default value)
               + ai: AI-enhanced (Only the SQL x86_64 dedicated queue supports this option.)
        :param pulumi.Input[_builtins.str] name: Name of a queue. Name of a newly created resource queue. The name can contain
               only digits, letters, and underscores (\\_), but cannot contain only digits or start with an underscore (_). Length
               range: 1 to 128 characters. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] platform: CPU architecture of queue compute resources. Changing this parameter will
               create a new resource. The options are as follows:
               + x86_64 : default value
               + aarch64
        :param pulumi.Input[_builtins.str] queue_type: Indicates the queue type. Changing this parameter will create a new
               resource. The options are as follows:
               + sql
               + general
               
               The default value is `sql`.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the dli queue resource. If omitted,
               the provider-level region will be used. Changing this will create a new VPC channel resource.
        :param pulumi.Input[_builtins.int] resource_mode: Queue resource mode. Changing this parameter will create a new
               resource. The options are as follows:
               + 0: indicates the shared resource mode.
               + 1: indicates the exclusive resource mode.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label of a queue. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] vpc_cidr: The CIDR block of a queue. If use DLI enhanced datasource connections, the CIDR block
               cannot be the same as that of the data source.
               The CIDR blocks supported by different CU specifications:
               
               + When `cu_count` is `16` or `64`: 10.0.0.0~10.255.0.0/8~24, 172.16.0.0~172.31.0.0/12~24,
               192.168.0.0~192.168.0.0/16~24.
               + When `cu_count` is `256`: 10.0.0.0~10.255.0.0/8~22, 172.16.0.0~172.31.0.0/12~22, 192.168.0.0~192.168.0.0/16~22.
        """
        pulumi.set(__self__, "cu_count", cu_count)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if elastic_resource_pool_name is not None:
            pulumi.set(__self__, "elastic_resource_pool_name", elastic_resource_pool_name)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if feature is not None:
            pulumi.set(__self__, "feature", feature)
        if management_subnet_cidr is not None:
            warnings.warn("""management_subnet_cidr is Deprecated""", DeprecationWarning)
            pulumi.log.warn("""management_subnet_cidr is deprecated: management_subnet_cidr is Deprecated""")
        if management_subnet_cidr is not None:
            pulumi.set(__self__, "management_subnet_cidr", management_subnet_cidr)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if queue_type is not None:
            pulumi.set(__self__, "queue_type", queue_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_mode is not None:
            pulumi.set(__self__, "resource_mode", resource_mode)
        if scaling_policies is not None:
            pulumi.set(__self__, "scaling_policies", scaling_policies)
        if spark_driver is not None:
            pulumi.set(__self__, "spark_driver", spark_driver)
        if subnet_cidr is not None:
            warnings.warn("""subnet_cidr is Deprecated""", DeprecationWarning)
            pulumi.log.warn("""subnet_cidr is deprecated: subnet_cidr is Deprecated""")
        if subnet_cidr is not None:
            pulumi.set(__self__, "subnet_cidr", subnet_cidr)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_cidr is not None:
            pulumi.set(__self__, "vpc_cidr", vpc_cidr)

    @_builtins.property
    @pulumi.getter(name="cuCount")
    def cu_count(self) -> pulumi.Input[_builtins.int]:
        """
        Minimum number of CUs that are bound to a queue. Initial value can be `16`,
        `64`, or `256`. When scale_out or scale_in, the number must be a multiple of 16
        """
        return pulumi.get(self, "cu_count")

    @cu_count.setter
    def cu_count(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "cu_count", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of a queue. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="elasticResourcePoolName")
    def elastic_resource_pool_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the elastic resource pool to which the queue belongs.
        """
        return pulumi.get(self, "elastic_resource_pool_name")

    @elastic_resource_pool_name.setter
    def elastic_resource_pool_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "elastic_resource_pool_name", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enterprise project ID. The value 0 indicates the default
        enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def feature(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the queue feature. Changing this parameter will create a new
        resource. The options are as follows:
        + basic: basic type (default value)
        + ai: AI-enhanced (Only the SQL x86_64 dedicated queue supports this option.)
        """
        return pulumi.get(self, "feature")

    @feature.setter
    def feature(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature", value)

    @_builtins.property
    @pulumi.getter(name="managementSubnetCidr")
    @_utilities.deprecated("""management_subnet_cidr is Deprecated""")
    def management_subnet_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "management_subnet_cidr")

    @management_subnet_cidr.setter
    def management_subnet_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_subnet_cidr", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of a queue. Name of a newly created resource queue. The name can contain
        only digits, letters, and underscores (\\_), but cannot contain only digits or start with an underscore (_). Length
        range: 1 to 128 characters. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CPU architecture of queue compute resources. Changing this parameter will
        create a new resource. The options are as follows:
        + x86_64 : default value
        + aarch64
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter(name="queueType")
    def queue_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the queue type. Changing this parameter will create a new
        resource. The options are as follows:
        + sql
        + general

        The default value is `sql`.
        """
        return pulumi.get(self, "queue_type")

    @queue_type.setter
    def queue_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the dli queue resource. If omitted,
        the provider-level region will be used. Changing this will create a new VPC channel resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceMode")
    def resource_mode(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Queue resource mode. Changing this parameter will create a new
        resource. The options are as follows:
        + 0: indicates the shared resource mode.
        + 1: indicates the exclusive resource mode.
        """
        return pulumi.get(self, "resource_mode")

    @resource_mode.setter
    def resource_mode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resource_mode", value)

    @_builtins.property
    @pulumi.getter(name="scalingPolicies")
    def scaling_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QueueScalingPolicyArgs']]]]:
        return pulumi.get(self, "scaling_policies")

    @scaling_policies.setter
    def scaling_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QueueScalingPolicyArgs']]]]):
        pulumi.set(self, "scaling_policies", value)

    @_builtins.property
    @pulumi.getter(name="sparkDriver")
    def spark_driver(self) -> Optional[pulumi.Input['QueueSparkDriverArgs']]:
        return pulumi.get(self, "spark_driver")

    @spark_driver.setter
    def spark_driver(self, value: Optional[pulumi.Input['QueueSparkDriverArgs']]):
        pulumi.set(self, "spark_driver", value)

    @_builtins.property
    @pulumi.getter(name="subnetCidr")
    @_utilities.deprecated("""subnet_cidr is Deprecated""")
    def subnet_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "subnet_cidr")

    @subnet_cidr.setter
    def subnet_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_cidr", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Label of a queue. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcCidr")
    def vpc_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR block of a queue. If use DLI enhanced datasource connections, the CIDR block
        cannot be the same as that of the data source.
        The CIDR blocks supported by different CU specifications:

        + When `cu_count` is `16` or `64`: 10.0.0.0~10.255.0.0/8~24, 172.16.0.0~172.31.0.0/12~24,
        192.168.0.0~192.168.0.0/16~24.
        + When `cu_count` is `256`: 10.0.0.0~10.255.0.0/8~22, 172.16.0.0~172.31.0.0/12~22, 192.168.0.0~192.168.0.0/16~22.
        """
        return pulumi.get(self, "vpc_cidr")

    @vpc_cidr.setter
    def vpc_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_cidr", value)


@pulumi.input_type
class _QueueState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[_builtins.int]] = None,
                 cu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 elastic_resource_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 feature: Optional[pulumi.Input[_builtins.str]] = None,
                 management_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 scaling_policies: Optional[pulumi.Input[Sequence[pulumi.Input['QueueScalingPolicyArgs']]]] = None,
                 spark_driver: Optional[pulumi.Input['QueueSparkDriverArgs']] = None,
                 subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_cidr: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Queue resources.
        :param pulumi.Input[_builtins.int] create_time: Time when a queue is created.
        :param pulumi.Input[_builtins.int] cu_count: Minimum number of CUs that are bound to a queue. Initial value can be `16`,
               `64`, or `256`. When scale_out or scale_in, the number must be a multiple of 16
        :param pulumi.Input[_builtins.str] description: Description of a queue. Changing this parameter will create a new
               resource.
        :param pulumi.Input[_builtins.str] elastic_resource_pool_name: The name of the elastic resource pool to which the queue belongs.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Enterprise project ID. The value 0 indicates the default
               enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] feature: Indicates the queue feature. Changing this parameter will create a new
               resource. The options are as follows:
               + basic: basic type (default value)
               + ai: AI-enhanced (Only the SQL x86_64 dedicated queue supports this option.)
        :param pulumi.Input[_builtins.str] name: Name of a queue. Name of a newly created resource queue. The name can contain
               only digits, letters, and underscores (\\_), but cannot contain only digits or start with an underscore (_). Length
               range: 1 to 128 characters. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] platform: CPU architecture of queue compute resources. Changing this parameter will
               create a new resource. The options are as follows:
               + x86_64 : default value
               + aarch64
        :param pulumi.Input[_builtins.str] queue_type: Indicates the queue type. Changing this parameter will create a new
               resource. The options are as follows:
               + sql
               + general
               
               The default value is `sql`.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the dli queue resource. If omitted,
               the provider-level region will be used. Changing this will create a new VPC channel resource.
        :param pulumi.Input[_builtins.int] resource_mode: Queue resource mode. Changing this parameter will create a new
               resource. The options are as follows:
               + 0: indicates the shared resource mode.
               + 1: indicates the exclusive resource mode.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label of a queue. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] vpc_cidr: The CIDR block of a queue. If use DLI enhanced datasource connections, the CIDR block
               cannot be the same as that of the data source.
               The CIDR blocks supported by different CU specifications:
               
               + When `cu_count` is `16` or `64`: 10.0.0.0~10.255.0.0/8~24, 172.16.0.0~172.31.0.0/12~24,
               192.168.0.0~192.168.0.0/16~24.
               + When `cu_count` is `256`: 10.0.0.0~10.255.0.0/8~22, 172.16.0.0~172.31.0.0/12~22, 192.168.0.0~192.168.0.0/16~22.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if cu_count is not None:
            pulumi.set(__self__, "cu_count", cu_count)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if elastic_resource_pool_name is not None:
            pulumi.set(__self__, "elastic_resource_pool_name", elastic_resource_pool_name)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if feature is not None:
            pulumi.set(__self__, "feature", feature)
        if management_subnet_cidr is not None:
            warnings.warn("""management_subnet_cidr is Deprecated""", DeprecationWarning)
            pulumi.log.warn("""management_subnet_cidr is deprecated: management_subnet_cidr is Deprecated""")
        if management_subnet_cidr is not None:
            pulumi.set(__self__, "management_subnet_cidr", management_subnet_cidr)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if queue_type is not None:
            pulumi.set(__self__, "queue_type", queue_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_mode is not None:
            pulumi.set(__self__, "resource_mode", resource_mode)
        if scaling_policies is not None:
            pulumi.set(__self__, "scaling_policies", scaling_policies)
        if spark_driver is not None:
            pulumi.set(__self__, "spark_driver", spark_driver)
        if subnet_cidr is not None:
            warnings.warn("""subnet_cidr is Deprecated""", DeprecationWarning)
            pulumi.log.warn("""subnet_cidr is deprecated: subnet_cidr is Deprecated""")
        if subnet_cidr is not None:
            pulumi.set(__self__, "subnet_cidr", subnet_cidr)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_cidr is not None:
            pulumi.set(__self__, "vpc_cidr", vpc_cidr)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time when a queue is created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter(name="cuCount")
    def cu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of CUs that are bound to a queue. Initial value can be `16`,
        `64`, or `256`. When scale_out or scale_in, the number must be a multiple of 16
        """
        return pulumi.get(self, "cu_count")

    @cu_count.setter
    def cu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "cu_count", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Description of a queue. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="elasticResourcePoolName")
    def elastic_resource_pool_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the elastic resource pool to which the queue belongs.
        """
        return pulumi.get(self, "elastic_resource_pool_name")

    @elastic_resource_pool_name.setter
    def elastic_resource_pool_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "elastic_resource_pool_name", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Enterprise project ID. The value 0 indicates the default
        enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def feature(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the queue feature. Changing this parameter will create a new
        resource. The options are as follows:
        + basic: basic type (default value)
        + ai: AI-enhanced (Only the SQL x86_64 dedicated queue supports this option.)
        """
        return pulumi.get(self, "feature")

    @feature.setter
    def feature(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature", value)

    @_builtins.property
    @pulumi.getter(name="managementSubnetCidr")
    @_utilities.deprecated("""management_subnet_cidr is Deprecated""")
    def management_subnet_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "management_subnet_cidr")

    @management_subnet_cidr.setter
    def management_subnet_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_subnet_cidr", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of a queue. Name of a newly created resource queue. The name can contain
        only digits, letters, and underscores (\\_), but cannot contain only digits or start with an underscore (_). Length
        range: 1 to 128 characters. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CPU architecture of queue compute resources. Changing this parameter will
        create a new resource. The options are as follows:
        + x86_64 : default value
        + aarch64
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "platform", value)

    @_builtins.property
    @pulumi.getter(name="queueType")
    def queue_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the queue type. Changing this parameter will create a new
        resource. The options are as follows:
        + sql
        + general

        The default value is `sql`.
        """
        return pulumi.get(self, "queue_type")

    @queue_type.setter
    def queue_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the dli queue resource. If omitted,
        the provider-level region will be used. Changing this will create a new VPC channel resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceMode")
    def resource_mode(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Queue resource mode. Changing this parameter will create a new
        resource. The options are as follows:
        + 0: indicates the shared resource mode.
        + 1: indicates the exclusive resource mode.
        """
        return pulumi.get(self, "resource_mode")

    @resource_mode.setter
    def resource_mode(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "resource_mode", value)

    @_builtins.property
    @pulumi.getter(name="scalingPolicies")
    def scaling_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['QueueScalingPolicyArgs']]]]:
        return pulumi.get(self, "scaling_policies")

    @scaling_policies.setter
    def scaling_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['QueueScalingPolicyArgs']]]]):
        pulumi.set(self, "scaling_policies", value)

    @_builtins.property
    @pulumi.getter(name="sparkDriver")
    def spark_driver(self) -> Optional[pulumi.Input['QueueSparkDriverArgs']]:
        return pulumi.get(self, "spark_driver")

    @spark_driver.setter
    def spark_driver(self, value: Optional[pulumi.Input['QueueSparkDriverArgs']]):
        pulumi.set(self, "spark_driver", value)

    @_builtins.property
    @pulumi.getter(name="subnetCidr")
    @_utilities.deprecated("""subnet_cidr is Deprecated""")
    def subnet_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "subnet_cidr")

    @subnet_cidr.setter
    def subnet_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_cidr", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Label of a queue. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcCidr")
    def vpc_cidr(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The CIDR block of a queue. If use DLI enhanced datasource connections, the CIDR block
        cannot be the same as that of the data source.
        The CIDR blocks supported by different CU specifications:

        + When `cu_count` is `16` or `64`: 10.0.0.0~10.255.0.0/8~24, 172.16.0.0~172.31.0.0/12~24,
        192.168.0.0~192.168.0.0/16~24.
        + When `cu_count` is `256`: 10.0.0.0~10.255.0.0/8~22, 172.16.0.0~172.31.0.0/12~22, 192.168.0.0~192.168.0.0/16~22.
        """
        return pulumi.get(self, "vpc_cidr")

    @vpc_cidr.setter
    def vpc_cidr(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_cidr", value)


@pulumi.type_token("sbercloud:Dli/queue:Queue")
class Queue(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 elastic_resource_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 feature: Optional[pulumi.Input[_builtins.str]] = None,
                 management_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 scaling_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QueueScalingPolicyArgs', 'QueueScalingPolicyArgsDict']]]]] = None,
                 spark_driver: Optional[pulumi.Input[Union['QueueSparkDriverArgs', 'QueueSparkDriverArgsDict']]] = None,
                 subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages DLI Queue resource within SberCloud

        ## Example Usage

        ### Create a queue

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        queue = sbercloud.dli.Queue("queue",
            name="terraform_dli_queue_test",
            cu_count=16,
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        ### Create a queue with CIDR Block

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        queue = sbercloud.dli.Queue("queue",
            name="terraform_dli_queue_test",
            cu_count=16,
            resource_mode=1,
            vpc_cidr="172.16.0.0/14",
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        ## Import

        DLI queue can be imported by  `id`. For example,

        ```sh
        $ pulumi import sbercloud:Dli/queue:Queue example abc123
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] cu_count: Minimum number of CUs that are bound to a queue. Initial value can be `16`,
               `64`, or `256`. When scale_out or scale_in, the number must be a multiple of 16
        :param pulumi.Input[_builtins.str] description: Description of a queue. Changing this parameter will create a new
               resource.
        :param pulumi.Input[_builtins.str] elastic_resource_pool_name: The name of the elastic resource pool to which the queue belongs.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Enterprise project ID. The value 0 indicates the default
               enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] feature: Indicates the queue feature. Changing this parameter will create a new
               resource. The options are as follows:
               + basic: basic type (default value)
               + ai: AI-enhanced (Only the SQL x86_64 dedicated queue supports this option.)
        :param pulumi.Input[_builtins.str] name: Name of a queue. Name of a newly created resource queue. The name can contain
               only digits, letters, and underscores (\\_), but cannot contain only digits or start with an underscore (_). Length
               range: 1 to 128 characters. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] platform: CPU architecture of queue compute resources. Changing this parameter will
               create a new resource. The options are as follows:
               + x86_64 : default value
               + aarch64
        :param pulumi.Input[_builtins.str] queue_type: Indicates the queue type. Changing this parameter will create a new
               resource. The options are as follows:
               + sql
               + general
               
               The default value is `sql`.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the dli queue resource. If omitted,
               the provider-level region will be used. Changing this will create a new VPC channel resource.
        :param pulumi.Input[_builtins.int] resource_mode: Queue resource mode. Changing this parameter will create a new
               resource. The options are as follows:
               + 0: indicates the shared resource mode.
               + 1: indicates the exclusive resource mode.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label of a queue. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] vpc_cidr: The CIDR block of a queue. If use DLI enhanced datasource connections, the CIDR block
               cannot be the same as that of the data source.
               The CIDR blocks supported by different CU specifications:
               
               + When `cu_count` is `16` or `64`: 10.0.0.0~10.255.0.0/8~24, 172.16.0.0~172.31.0.0/12~24,
               192.168.0.0~192.168.0.0/16~24.
               + When `cu_count` is `256`: 10.0.0.0~10.255.0.0/8~22, 172.16.0.0~172.31.0.0/12~22, 192.168.0.0~192.168.0.0/16~22.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: QueueArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages DLI Queue resource within SberCloud

        ## Example Usage

        ### Create a queue

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        queue = sbercloud.dli.Queue("queue",
            name="terraform_dli_queue_test",
            cu_count=16,
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        ### Create a queue with CIDR Block

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        queue = sbercloud.dli.Queue("queue",
            name="terraform_dli_queue_test",
            cu_count=16,
            resource_mode=1,
            vpc_cidr="172.16.0.0/14",
            tags={
                "foo": "bar",
                "key": "value",
            })
        ```

        ## Import

        DLI queue can be imported by  `id`. For example,

        ```sh
        $ pulumi import sbercloud:Dli/queue:Queue example abc123
        ```

        :param str resource_name: The name of the resource.
        :param QueueArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(QueueArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 elastic_resource_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 feature: Optional[pulumi.Input[_builtins.str]] = None,
                 management_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 platform: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_mode: Optional[pulumi.Input[_builtins.int]] = None,
                 scaling_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QueueScalingPolicyArgs', 'QueueScalingPolicyArgsDict']]]]] = None,
                 spark_driver: Optional[pulumi.Input[Union['QueueSparkDriverArgs', 'QueueSparkDriverArgsDict']]] = None,
                 subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_cidr: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = QueueArgs.__new__(QueueArgs)

            if cu_count is None and not opts.urn:
                raise TypeError("Missing required property 'cu_count'")
            __props__.__dict__["cu_count"] = cu_count
            __props__.__dict__["description"] = description
            __props__.__dict__["elastic_resource_pool_name"] = elastic_resource_pool_name
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["feature"] = feature
            __props__.__dict__["management_subnet_cidr"] = management_subnet_cidr
            __props__.__dict__["name"] = name
            __props__.__dict__["platform"] = platform
            __props__.__dict__["queue_type"] = queue_type
            __props__.__dict__["region"] = region
            __props__.__dict__["resource_mode"] = resource_mode
            __props__.__dict__["scaling_policies"] = scaling_policies
            __props__.__dict__["spark_driver"] = spark_driver
            __props__.__dict__["subnet_cidr"] = subnet_cidr
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_cidr"] = vpc_cidr
            __props__.__dict__["create_time"] = None
        super(Queue, __self__).__init__(
            'sbercloud:Dli/queue:Queue',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[_builtins.int]] = None,
            cu_count: Optional[pulumi.Input[_builtins.int]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            elastic_resource_pool_name: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            feature: Optional[pulumi.Input[_builtins.str]] = None,
            management_subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            platform: Optional[pulumi.Input[_builtins.str]] = None,
            queue_type: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_mode: Optional[pulumi.Input[_builtins.int]] = None,
            scaling_policies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['QueueScalingPolicyArgs', 'QueueScalingPolicyArgsDict']]]]] = None,
            spark_driver: Optional[pulumi.Input[Union['QueueSparkDriverArgs', 'QueueSparkDriverArgsDict']]] = None,
            subnet_cidr: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vpc_cidr: Optional[pulumi.Input[_builtins.str]] = None) -> 'Queue':
        """
        Get an existing Queue resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] create_time: Time when a queue is created.
        :param pulumi.Input[_builtins.int] cu_count: Minimum number of CUs that are bound to a queue. Initial value can be `16`,
               `64`, or `256`. When scale_out or scale_in, the number must be a multiple of 16
        :param pulumi.Input[_builtins.str] description: Description of a queue. Changing this parameter will create a new
               resource.
        :param pulumi.Input[_builtins.str] elastic_resource_pool_name: The name of the elastic resource pool to which the queue belongs.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Enterprise project ID. The value 0 indicates the default
               enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] feature: Indicates the queue feature. Changing this parameter will create a new
               resource. The options are as follows:
               + basic: basic type (default value)
               + ai: AI-enhanced (Only the SQL x86_64 dedicated queue supports this option.)
        :param pulumi.Input[_builtins.str] name: Name of a queue. Name of a newly created resource queue. The name can contain
               only digits, letters, and underscores (\\_), but cannot contain only digits or start with an underscore (_). Length
               range: 1 to 128 characters. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] platform: CPU architecture of queue compute resources. Changing this parameter will
               create a new resource. The options are as follows:
               + x86_64 : default value
               + aarch64
        :param pulumi.Input[_builtins.str] queue_type: Indicates the queue type. Changing this parameter will create a new
               resource. The options are as follows:
               + sql
               + general
               
               The default value is `sql`.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the dli queue resource. If omitted,
               the provider-level region will be used. Changing this will create a new VPC channel resource.
        :param pulumi.Input[_builtins.int] resource_mode: Queue resource mode. Changing this parameter will create a new
               resource. The options are as follows:
               + 0: indicates the shared resource mode.
               + 1: indicates the exclusive resource mode.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Label of a queue. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] vpc_cidr: The CIDR block of a queue. If use DLI enhanced datasource connections, the CIDR block
               cannot be the same as that of the data source.
               The CIDR blocks supported by different CU specifications:
               
               + When `cu_count` is `16` or `64`: 10.0.0.0~10.255.0.0/8~24, 172.16.0.0~172.31.0.0/12~24,
               192.168.0.0~192.168.0.0/16~24.
               + When `cu_count` is `256`: 10.0.0.0~10.255.0.0/8~22, 172.16.0.0~172.31.0.0/12~22, 192.168.0.0~192.168.0.0/16~22.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _QueueState.__new__(_QueueState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["cu_count"] = cu_count
        __props__.__dict__["description"] = description
        __props__.__dict__["elastic_resource_pool_name"] = elastic_resource_pool_name
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["feature"] = feature
        __props__.__dict__["management_subnet_cidr"] = management_subnet_cidr
        __props__.__dict__["name"] = name
        __props__.__dict__["platform"] = platform
        __props__.__dict__["queue_type"] = queue_type
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_mode"] = resource_mode
        __props__.__dict__["scaling_policies"] = scaling_policies
        __props__.__dict__["spark_driver"] = spark_driver
        __props__.__dict__["subnet_cidr"] = subnet_cidr
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_cidr"] = vpc_cidr
        return Queue(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.int]:
        """
        Time when a queue is created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter(name="cuCount")
    def cu_count(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum number of CUs that are bound to a queue. Initial value can be `16`,
        `64`, or `256`. When scale_out or scale_in, the number must be a multiple of 16
        """
        return pulumi.get(self, "cu_count")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Description of a queue. Changing this parameter will create a new
        resource.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="elasticResourcePoolName")
    def elastic_resource_pool_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the elastic resource pool to which the queue belongs.
        """
        return pulumi.get(self, "elastic_resource_pool_name")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Enterprise project ID. The value 0 indicates the default
        enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def feature(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates the queue feature. Changing this parameter will create a new
        resource. The options are as follows:
        + basic: basic type (default value)
        + ai: AI-enhanced (Only the SQL x86_64 dedicated queue supports this option.)
        """
        return pulumi.get(self, "feature")

    @_builtins.property
    @pulumi.getter(name="managementSubnetCidr")
    @_utilities.deprecated("""management_subnet_cidr is Deprecated""")
    def management_subnet_cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "management_subnet_cidr")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Name of a queue. Name of a newly created resource queue. The name can contain
        only digits, letters, and underscores (\\_), but cannot contain only digits or start with an underscore (_). Length
        range: 1 to 128 characters. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def platform(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        CPU architecture of queue compute resources. Changing this parameter will
        create a new resource. The options are as follows:
        + x86_64 : default value
        + aarch64
        """
        return pulumi.get(self, "platform")

    @_builtins.property
    @pulumi.getter(name="queueType")
    def queue_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Indicates the queue type. Changing this parameter will create a new
        resource. The options are as follows:
        + sql
        + general

        The default value is `sql`.
        """
        return pulumi.get(self, "queue_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the dli queue resource. If omitted,
        the provider-level region will be used. Changing this will create a new VPC channel resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceMode")
    def resource_mode(self) -> pulumi.Output[_builtins.int]:
        """
        Queue resource mode. Changing this parameter will create a new
        resource. The options are as follows:
        + 0: indicates the shared resource mode.
        + 1: indicates the exclusive resource mode.
        """
        return pulumi.get(self, "resource_mode")

    @_builtins.property
    @pulumi.getter(name="scalingPolicies")
    def scaling_policies(self) -> pulumi.Output[Sequence['outputs.QueueScalingPolicy']]:
        return pulumi.get(self, "scaling_policies")

    @_builtins.property
    @pulumi.getter(name="sparkDriver")
    def spark_driver(self) -> pulumi.Output[Optional['outputs.QueueSparkDriver']]:
        return pulumi.get(self, "spark_driver")

    @_builtins.property
    @pulumi.getter(name="subnetCidr")
    @_utilities.deprecated("""subnet_cidr is Deprecated""")
    def subnet_cidr(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "subnet_cidr")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Label of a queue. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vpcCidr")
    def vpc_cidr(self) -> pulumi.Output[_builtins.str]:
        """
        The CIDR block of a queue. If use DLI enhanced datasource connections, the CIDR block
        cannot be the same as that of the data source.
        The CIDR blocks supported by different CU specifications:

        + When `cu_count` is `16` or `64`: 10.0.0.0~10.255.0.0/8~24, 172.16.0.0~172.31.0.0/12~24,
        192.168.0.0~192.168.0.0/16~24.
        + When `cu_count` is `256`: 10.0.0.0~10.255.0.0/8~22, 172.16.0.0~172.31.0.0/12~22, 192.168.0.0~192.168.0.0/16~22.
        """
        return pulumi.get(self, "vpc_cidr")

