# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SparkJobArgs', 'SparkJob']

@pulumi.input_type
class SparkJobArgs:
    def __init__(__self__, *,
                 app_name: pulumi.Input[_builtins.str],
                 queue_name: pulumi.Input[_builtins.str],
                 app_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dependent_packages: Optional[pulumi.Input[Sequence[pulumi.Input['SparkJobDependentPackageArgs']]]] = None,
                 driver_cores: Optional[pulumi.Input[_builtins.int]] = None,
                 driver_memory: Optional[pulumi.Input[_builtins.str]] = None,
                 executor_cores: Optional[pulumi.Input[_builtins.int]] = None,
                 executor_memory: Optional[pulumi.Input[_builtins.str]] = None,
                 executors: Optional[pulumi.Input[_builtins.int]] = None,
                 feature: Optional[pulumi.Input[_builtins.str]] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 jars: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 main_class: Optional[pulumi.Input[_builtins.str]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 modules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 python_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 spark_version: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SparkJob resource.
        :param pulumi.Input[_builtins.str] app_name: Specifies the name of the package that is of the JAR or python file type and
               has been uploaded to the DLI resource management system.
               The OBS paths are allowed, for example, `obs://<bucket name>/<package name>`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] queue_name: Specifies the DLI queue name.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] app_parameters: Specifies the input parameters of the main class.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] configurations: Specifies the configuration items of the DLI spark.
               Please following the document of Spark [configurations](https://spark.apache.org/docs/latest/configuration.html) for
               this argument. If you want to enable the `access metadata` of DLI spark in SberCloud, please set
               `spark.dli.metaAccess.enable` to `true`. Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input['SparkJobDependentPackageArgs']]] dependent_packages: Specifies a list of package resource objects.
               The object structure is documented below.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.int] driver_cores: Specifies the number of CPU cores of the Spark application driver.
               The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] driver_memory: Specifies the driver memory of the spark application.
               The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.int] executor_cores: Specifies the number of CPU cores of each executor in the Spark
               application. The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] executor_memory: Specifies the executor memory of the spark application.
               application. The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
               
               ->**NOTE:** The unit must be provided, such as **GB** or **MB**.
        :param pulumi.Input[_builtins.int] executors: Specifies the number of executors in a spark application.
               The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] feature: Specifies the feature name for the Spark Job.
               Required for Spark 3. Known values: `basic`, `ai`, `custom`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] files: Specifies a list of the other dependencies name which has been uploaded to the
               DLI resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<dependent files>`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] jars: Specifies a list of the jar package name which has been uploaded to the DLI
               resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<package name>`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] main_class: Specifies the main class of the spark job.
               Required if the `app_name` is the JAR type.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.int] max_retries: Specifies the maximum retry times.
               The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] modules: Specifies a list of modules that depend on system resources.
               The dependent modules and corresponding services are as follows.
               Changing this parameter will submit a new spark job.
               + **sys.datasource.hbase**: CloudTable/MRS HBase
               + **sys.datasource.opentsdb**: CloudTable/MRS OpenTSDB
               + **sys.datasource.rds**: RDS MySQL
               + **sys.datasource.css**: CSS
        :param pulumi.Input[_builtins.str] name: Specifies the spark job name.
               The value contains a maximum of 128 characters.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] python_files: Specifies a list of the python file name which has been uploaded to the
               DLI resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<python file name>`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to submit a spark job.
               If omitted, the provider-level region will be used.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] spark_version: Version of Spark to use.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] specification: Specifies the compute resource type for spark application.
               The available types and related specifications are as follows, default to minimum configuration (type **A**).
               Changing this parameter will submit a new spark job.
               
               | type | resource | driver cores | excutor cores | driver memory | executor memory | num executor |
               | ---- | ---- | ---- | ---- | ---- | ---- | ---- |
               | A | 8 vCPUs, 32-GB memory | 2 | 1 | 7G | 4G | 6 |
               | B | 16 vCPUs, 64-GB memory | 2 | 2 | 7G | 8G | 7 |
               | C | 32 vCPUs, 128-GB memory | 4 | 2 | 12G | 8G | 14 |
        """
        pulumi.set(__self__, "app_name", app_name)
        pulumi.set(__self__, "queue_name", queue_name)
        if app_parameters is not None:
            pulumi.set(__self__, "app_parameters", app_parameters)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if dependent_packages is not None:
            pulumi.set(__self__, "dependent_packages", dependent_packages)
        if driver_cores is not None:
            pulumi.set(__self__, "driver_cores", driver_cores)
        if driver_memory is not None:
            pulumi.set(__self__, "driver_memory", driver_memory)
        if executor_cores is not None:
            pulumi.set(__self__, "executor_cores", executor_cores)
        if executor_memory is not None:
            pulumi.set(__self__, "executor_memory", executor_memory)
        if executors is not None:
            pulumi.set(__self__, "executors", executors)
        if feature is not None:
            pulumi.set(__self__, "feature", feature)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if jars is not None:
            pulumi.set(__self__, "jars", jars)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if modules is not None:
            pulumi.set(__self__, "modules", modules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if python_files is not None:
            pulumi.set(__self__, "python_files", python_files)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if spark_version is not None:
            pulumi.set(__self__, "spark_version", spark_version)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the package that is of the JAR or python file type and
        has been uploaded to the DLI resource management system.
        The OBS paths are allowed, for example, `obs://<bucket name>/<package name>`.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the DLI queue name.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "queue_name", value)

    @_builtins.property
    @pulumi.getter(name="appParameters")
    def app_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the input parameters of the main class.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "app_parameters")

    @app_parameters.setter
    def app_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "app_parameters", value)

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the configuration items of the DLI spark.
        Please following the document of Spark [configurations](https://spark.apache.org/docs/latest/configuration.html) for
        this argument. If you want to enable the `access metadata` of DLI spark in SberCloud, please set
        `spark.dli.metaAccess.enable` to `true`. Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "configurations", value)

    @_builtins.property
    @pulumi.getter(name="dependentPackages")
    def dependent_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SparkJobDependentPackageArgs']]]]:
        """
        Specifies a list of package resource objects.
        The object structure is documented below.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "dependent_packages")

    @dependent_packages.setter
    def dependent_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SparkJobDependentPackageArgs']]]]):
        pulumi.set(self, "dependent_packages", value)

    @_builtins.property
    @pulumi.getter(name="driverCores")
    def driver_cores(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of CPU cores of the Spark application driver.
        The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "driver_cores")

    @driver_cores.setter
    def driver_cores(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "driver_cores", value)

    @_builtins.property
    @pulumi.getter(name="driverMemory")
    def driver_memory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the driver memory of the spark application.
        The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "driver_memory")

    @driver_memory.setter
    def driver_memory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "driver_memory", value)

    @_builtins.property
    @pulumi.getter(name="executorCores")
    def executor_cores(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of CPU cores of each executor in the Spark
        application. The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "executor_cores")

    @executor_cores.setter
    def executor_cores(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "executor_cores", value)

    @_builtins.property
    @pulumi.getter(name="executorMemory")
    def executor_memory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the executor memory of the spark application.
        application. The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.

        ->**NOTE:** The unit must be provided, such as **GB** or **MB**.
        """
        return pulumi.get(self, "executor_memory")

    @executor_memory.setter
    def executor_memory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "executor_memory", value)

    @_builtins.property
    @pulumi.getter
    def executors(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of executors in a spark application.
        The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "executors")

    @executors.setter
    def executors(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "executors", value)

    @_builtins.property
    @pulumi.getter
    def feature(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the feature name for the Spark Job.
        Required for Spark 3. Known values: `basic`, `ai`, `custom`.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "feature")

    @feature.setter
    def feature(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature", value)

    @_builtins.property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of the other dependencies name which has been uploaded to the
        DLI resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<dependent files>`.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "files", value)

    @_builtins.property
    @pulumi.getter
    def jars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of the jar package name which has been uploaded to the DLI
        resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<package name>`.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "jars")

    @jars.setter
    def jars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "jars", value)

    @_builtins.property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the main class of the spark job.
        Required if the `app_name` is the JAR type.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "main_class")

    @main_class.setter
    def main_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "main_class", value)

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum retry times.
        The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retries", value)

    @_builtins.property
    @pulumi.getter
    def modules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of modules that depend on system resources.
        The dependent modules and corresponding services are as follows.
        Changing this parameter will submit a new spark job.
        + **sys.datasource.hbase**: CloudTable/MRS HBase
        + **sys.datasource.opentsdb**: CloudTable/MRS OpenTSDB
        + **sys.datasource.rds**: RDS MySQL
        + **sys.datasource.css**: CSS
        """
        return pulumi.get(self, "modules")

    @modules.setter
    def modules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "modules", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the spark job name.
        The value contains a maximum of 128 characters.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pythonFiles")
    def python_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of the python file name which has been uploaded to the
        DLI resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<python file name>`.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "python_files")

    @python_files.setter
    def python_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "python_files", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to submit a spark job.
        If omitted, the provider-level region will be used.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of Spark to use.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "spark_version")

    @spark_version.setter
    def spark_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spark_version", value)

    @_builtins.property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the compute resource type for spark application.
        The available types and related specifications are as follows, default to minimum configuration (type **A**).
        Changing this parameter will submit a new spark job.

        | type | resource | driver cores | excutor cores | driver memory | executor memory | num executor |
        | ---- | ---- | ---- | ---- | ---- | ---- | ---- |
        | A | 8 vCPUs, 32-GB memory | 2 | 1 | 7G | 4G | 6 |
        | B | 16 vCPUs, 64-GB memory | 2 | 2 | 7G | 8G | 7 |
        | C | 32 vCPUs, 128-GB memory | 4 | 2 | 12G | 8G | 14 |
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "specification", value)


@pulumi.input_type
class _SparkJobState:
    def __init__(__self__, *,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 dependent_packages: Optional[pulumi.Input[Sequence[pulumi.Input['SparkJobDependentPackageArgs']]]] = None,
                 driver_cores: Optional[pulumi.Input[_builtins.int]] = None,
                 driver_memory: Optional[pulumi.Input[_builtins.str]] = None,
                 executor_cores: Optional[pulumi.Input[_builtins.int]] = None,
                 executor_memory: Optional[pulumi.Input[_builtins.str]] = None,
                 executors: Optional[pulumi.Input[_builtins.int]] = None,
                 feature: Optional[pulumi.Input[_builtins.str]] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 jars: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 main_class: Optional[pulumi.Input[_builtins.str]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 modules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 owner: Optional[pulumi.Input[_builtins.str]] = None,
                 python_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 queue_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 spark_version: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SparkJob resources.
        :param pulumi.Input[_builtins.str] app_name: Specifies the name of the package that is of the JAR or python file type and
               has been uploaded to the DLI resource management system.
               The OBS paths are allowed, for example, `obs://<bucket name>/<package name>`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] app_parameters: Specifies the input parameters of the main class.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] configurations: Specifies the configuration items of the DLI spark.
               Please following the document of Spark [configurations](https://spark.apache.org/docs/latest/configuration.html) for
               this argument. If you want to enable the `access metadata` of DLI spark in SberCloud, please set
               `spark.dli.metaAccess.enable` to `true`. Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] created_at: Time of the DLI spark job submit.
        :param pulumi.Input[Sequence[pulumi.Input['SparkJobDependentPackageArgs']]] dependent_packages: Specifies a list of package resource objects.
               The object structure is documented below.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.int] driver_cores: Specifies the number of CPU cores of the Spark application driver.
               The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] driver_memory: Specifies the driver memory of the spark application.
               The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.int] executor_cores: Specifies the number of CPU cores of each executor in the Spark
               application. The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] executor_memory: Specifies the executor memory of the spark application.
               application. The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
               
               ->**NOTE:** The unit must be provided, such as **GB** or **MB**.
        :param pulumi.Input[_builtins.int] executors: Specifies the number of executors in a spark application.
               The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] feature: Specifies the feature name for the Spark Job.
               Required for Spark 3. Known values: `basic`, `ai`, `custom`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] files: Specifies a list of the other dependencies name which has been uploaded to the
               DLI resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<dependent files>`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] jars: Specifies a list of the jar package name which has been uploaded to the DLI
               resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<package name>`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] main_class: Specifies the main class of the spark job.
               Required if the `app_name` is the JAR type.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.int] max_retries: Specifies the maximum retry times.
               The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] modules: Specifies a list of modules that depend on system resources.
               The dependent modules and corresponding services are as follows.
               Changing this parameter will submit a new spark job.
               + **sys.datasource.hbase**: CloudTable/MRS HBase
               + **sys.datasource.opentsdb**: CloudTable/MRS OpenTSDB
               + **sys.datasource.rds**: RDS MySQL
               + **sys.datasource.css**: CSS
        :param pulumi.Input[_builtins.str] name: Specifies the spark job name.
               The value contains a maximum of 128 characters.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] owner: The owner of the spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] python_files: Specifies a list of the python file name which has been uploaded to the
               DLI resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<python file name>`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] queue_name: Specifies the DLI queue name.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to submit a spark job.
               If omitted, the provider-level region will be used.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] spark_version: Version of Spark to use.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] specification: Specifies the compute resource type for spark application.
               The available types and related specifications are as follows, default to minimum configuration (type **A**).
               Changing this parameter will submit a new spark job.
               
               | type | resource | driver cores | excutor cores | driver memory | executor memory | num executor |
               | ---- | ---- | ---- | ---- | ---- | ---- | ---- |
               | A | 8 vCPUs, 32-GB memory | 2 | 1 | 7G | 4G | 6 |
               | B | 16 vCPUs, 64-GB memory | 2 | 2 | 7G | 8G | 7 |
               | C | 32 vCPUs, 128-GB memory | 4 | 2 | 12G | 8G | 14 |
        """
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if app_parameters is not None:
            pulumi.set(__self__, "app_parameters", app_parameters)
        if configurations is not None:
            pulumi.set(__self__, "configurations", configurations)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if dependent_packages is not None:
            pulumi.set(__self__, "dependent_packages", dependent_packages)
        if driver_cores is not None:
            pulumi.set(__self__, "driver_cores", driver_cores)
        if driver_memory is not None:
            pulumi.set(__self__, "driver_memory", driver_memory)
        if executor_cores is not None:
            pulumi.set(__self__, "executor_cores", executor_cores)
        if executor_memory is not None:
            pulumi.set(__self__, "executor_memory", executor_memory)
        if executors is not None:
            pulumi.set(__self__, "executors", executors)
        if feature is not None:
            pulumi.set(__self__, "feature", feature)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if jars is not None:
            pulumi.set(__self__, "jars", jars)
        if main_class is not None:
            pulumi.set(__self__, "main_class", main_class)
        if max_retries is not None:
            pulumi.set(__self__, "max_retries", max_retries)
        if modules is not None:
            pulumi.set(__self__, "modules", modules)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if owner is not None:
            pulumi.set(__self__, "owner", owner)
        if python_files is not None:
            pulumi.set(__self__, "python_files", python_files)
        if queue_name is not None:
            pulumi.set(__self__, "queue_name", queue_name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if spark_version is not None:
            pulumi.set(__self__, "spark_version", spark_version)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the package that is of the JAR or python file type and
        has been uploaded to the DLI resource management system.
        The OBS paths are allowed, for example, `obs://<bucket name>/<package name>`.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_name", value)

    @_builtins.property
    @pulumi.getter(name="appParameters")
    def app_parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the input parameters of the main class.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "app_parameters")

    @app_parameters.setter
    def app_parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "app_parameters", value)

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the configuration items of the DLI spark.
        Please following the document of Spark [configurations](https://spark.apache.org/docs/latest/configuration.html) for
        this argument. If you want to enable the `access metadata` of DLI spark in SberCloud, please set
        `spark.dli.metaAccess.enable` to `true`. Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "configurations")

    @configurations.setter
    def configurations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "configurations", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Time of the DLI spark job submit.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="dependentPackages")
    def dependent_packages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SparkJobDependentPackageArgs']]]]:
        """
        Specifies a list of package resource objects.
        The object structure is documented below.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "dependent_packages")

    @dependent_packages.setter
    def dependent_packages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SparkJobDependentPackageArgs']]]]):
        pulumi.set(self, "dependent_packages", value)

    @_builtins.property
    @pulumi.getter(name="driverCores")
    def driver_cores(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of CPU cores of the Spark application driver.
        The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "driver_cores")

    @driver_cores.setter
    def driver_cores(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "driver_cores", value)

    @_builtins.property
    @pulumi.getter(name="driverMemory")
    def driver_memory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the driver memory of the spark application.
        The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "driver_memory")

    @driver_memory.setter
    def driver_memory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "driver_memory", value)

    @_builtins.property
    @pulumi.getter(name="executorCores")
    def executor_cores(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of CPU cores of each executor in the Spark
        application. The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "executor_cores")

    @executor_cores.setter
    def executor_cores(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "executor_cores", value)

    @_builtins.property
    @pulumi.getter(name="executorMemory")
    def executor_memory(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the executor memory of the spark application.
        application. The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.

        ->**NOTE:** The unit must be provided, such as **GB** or **MB**.
        """
        return pulumi.get(self, "executor_memory")

    @executor_memory.setter
    def executor_memory(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "executor_memory", value)

    @_builtins.property
    @pulumi.getter
    def executors(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of executors in a spark application.
        The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "executors")

    @executors.setter
    def executors(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "executors", value)

    @_builtins.property
    @pulumi.getter
    def feature(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the feature name for the Spark Job.
        Required for Spark 3. Known values: `basic`, `ai`, `custom`.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "feature")

    @feature.setter
    def feature(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "feature", value)

    @_builtins.property
    @pulumi.getter
    def files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of the other dependencies name which has been uploaded to the
        DLI resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<dependent files>`.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "files")

    @files.setter
    def files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "files", value)

    @_builtins.property
    @pulumi.getter
    def jars(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of the jar package name which has been uploaded to the DLI
        resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<package name>`.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "jars")

    @jars.setter
    def jars(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "jars", value)

    @_builtins.property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the main class of the spark job.
        Required if the `app_name` is the JAR type.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "main_class")

    @main_class.setter
    def main_class(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "main_class", value)

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum retry times.
        The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "max_retries")

    @max_retries.setter
    def max_retries(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_retries", value)

    @_builtins.property
    @pulumi.getter
    def modules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of modules that depend on system resources.
        The dependent modules and corresponding services are as follows.
        Changing this parameter will submit a new spark job.
        + **sys.datasource.hbase**: CloudTable/MRS HBase
        + **sys.datasource.opentsdb**: CloudTable/MRS OpenTSDB
        + **sys.datasource.rds**: RDS MySQL
        + **sys.datasource.css**: CSS
        """
        return pulumi.get(self, "modules")

    @modules.setter
    def modules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "modules", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the spark job name.
        The value contains a maximum of 128 characters.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def owner(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The owner of the spark job.
        """
        return pulumi.get(self, "owner")

    @owner.setter
    def owner(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "owner", value)

    @_builtins.property
    @pulumi.getter(name="pythonFiles")
    def python_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of the python file name which has been uploaded to the
        DLI resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<python file name>`.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "python_files")

    @python_files.setter
    def python_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "python_files", value)

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the DLI queue name.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "queue_name")

    @queue_name.setter
    def queue_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "queue_name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to submit a spark job.
        If omitted, the provider-level region will be used.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Version of Spark to use.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "spark_version")

    @spark_version.setter
    def spark_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spark_version", value)

    @_builtins.property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the compute resource type for spark application.
        The available types and related specifications are as follows, default to minimum configuration (type **A**).
        Changing this parameter will submit a new spark job.

        | type | resource | driver cores | excutor cores | driver memory | executor memory | num executor |
        | ---- | ---- | ---- | ---- | ---- | ---- | ---- |
        | A | 8 vCPUs, 32-GB memory | 2 | 1 | 7G | 4G | 6 |
        | B | 16 vCPUs, 64-GB memory | 2 | 2 | 7G | 8G | 7 |
        | C | 32 vCPUs, 128-GB memory | 4 | 2 | 12G | 8G | 14 |
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "specification", value)


@pulumi.type_token("sbercloud:Dli/sparkJob:SparkJob")
class SparkJob(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dependent_packages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SparkJobDependentPackageArgs', 'SparkJobDependentPackageArgsDict']]]]] = None,
                 driver_cores: Optional[pulumi.Input[_builtins.int]] = None,
                 driver_memory: Optional[pulumi.Input[_builtins.str]] = None,
                 executor_cores: Optional[pulumi.Input[_builtins.int]] = None,
                 executor_memory: Optional[pulumi.Input[_builtins.str]] = None,
                 executors: Optional[pulumi.Input[_builtins.int]] = None,
                 feature: Optional[pulumi.Input[_builtins.str]] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 jars: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 main_class: Optional[pulumi.Input[_builtins.str]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 modules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 python_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 queue_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 spark_version: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages spark job resource of DLI within SberCloud

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_name: Specifies the name of the package that is of the JAR or python file type and
               has been uploaded to the DLI resource management system.
               The OBS paths are allowed, for example, `obs://<bucket name>/<package name>`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] app_parameters: Specifies the input parameters of the main class.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] configurations: Specifies the configuration items of the DLI spark.
               Please following the document of Spark [configurations](https://spark.apache.org/docs/latest/configuration.html) for
               this argument. If you want to enable the `access metadata` of DLI spark in SberCloud, please set
               `spark.dli.metaAccess.enable` to `true`. Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SparkJobDependentPackageArgs', 'SparkJobDependentPackageArgsDict']]]] dependent_packages: Specifies a list of package resource objects.
               The object structure is documented below.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.int] driver_cores: Specifies the number of CPU cores of the Spark application driver.
               The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] driver_memory: Specifies the driver memory of the spark application.
               The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.int] executor_cores: Specifies the number of CPU cores of each executor in the Spark
               application. The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] executor_memory: Specifies the executor memory of the spark application.
               application. The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
               
               ->**NOTE:** The unit must be provided, such as **GB** or **MB**.
        :param pulumi.Input[_builtins.int] executors: Specifies the number of executors in a spark application.
               The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] feature: Specifies the feature name for the Spark Job.
               Required for Spark 3. Known values: `basic`, `ai`, `custom`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] files: Specifies a list of the other dependencies name which has been uploaded to the
               DLI resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<dependent files>`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] jars: Specifies a list of the jar package name which has been uploaded to the DLI
               resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<package name>`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] main_class: Specifies the main class of the spark job.
               Required if the `app_name` is the JAR type.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.int] max_retries: Specifies the maximum retry times.
               The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] modules: Specifies a list of modules that depend on system resources.
               The dependent modules and corresponding services are as follows.
               Changing this parameter will submit a new spark job.
               + **sys.datasource.hbase**: CloudTable/MRS HBase
               + **sys.datasource.opentsdb**: CloudTable/MRS OpenTSDB
               + **sys.datasource.rds**: RDS MySQL
               + **sys.datasource.css**: CSS
        :param pulumi.Input[_builtins.str] name: Specifies the spark job name.
               The value contains a maximum of 128 characters.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] python_files: Specifies a list of the python file name which has been uploaded to the
               DLI resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<python file name>`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] queue_name: Specifies the DLI queue name.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to submit a spark job.
               If omitted, the provider-level region will be used.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] spark_version: Version of Spark to use.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] specification: Specifies the compute resource type for spark application.
               The available types and related specifications are as follows, default to minimum configuration (type **A**).
               Changing this parameter will submit a new spark job.
               
               | type | resource | driver cores | excutor cores | driver memory | executor memory | num executor |
               | ---- | ---- | ---- | ---- | ---- | ---- | ---- |
               | A | 8 vCPUs, 32-GB memory | 2 | 1 | 7G | 4G | 6 |
               | B | 16 vCPUs, 64-GB memory | 2 | 2 | 7G | 8G | 7 |
               | C | 32 vCPUs, 128-GB memory | 4 | 2 | 12G | 8G | 14 |
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SparkJobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages spark job resource of DLI within SberCloud

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param SparkJobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SparkJobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_name: Optional[pulumi.Input[_builtins.str]] = None,
                 app_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 dependent_packages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SparkJobDependentPackageArgs', 'SparkJobDependentPackageArgsDict']]]]] = None,
                 driver_cores: Optional[pulumi.Input[_builtins.int]] = None,
                 driver_memory: Optional[pulumi.Input[_builtins.str]] = None,
                 executor_cores: Optional[pulumi.Input[_builtins.int]] = None,
                 executor_memory: Optional[pulumi.Input[_builtins.str]] = None,
                 executors: Optional[pulumi.Input[_builtins.int]] = None,
                 feature: Optional[pulumi.Input[_builtins.str]] = None,
                 files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 jars: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 main_class: Optional[pulumi.Input[_builtins.str]] = None,
                 max_retries: Optional[pulumi.Input[_builtins.int]] = None,
                 modules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 python_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 queue_name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 spark_version: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SparkJobArgs.__new__(SparkJobArgs)

            if app_name is None and not opts.urn:
                raise TypeError("Missing required property 'app_name'")
            __props__.__dict__["app_name"] = app_name
            __props__.__dict__["app_parameters"] = app_parameters
            __props__.__dict__["configurations"] = configurations
            __props__.__dict__["dependent_packages"] = dependent_packages
            __props__.__dict__["driver_cores"] = driver_cores
            __props__.__dict__["driver_memory"] = driver_memory
            __props__.__dict__["executor_cores"] = executor_cores
            __props__.__dict__["executor_memory"] = executor_memory
            __props__.__dict__["executors"] = executors
            __props__.__dict__["feature"] = feature
            __props__.__dict__["files"] = files
            __props__.__dict__["jars"] = jars
            __props__.__dict__["main_class"] = main_class
            __props__.__dict__["max_retries"] = max_retries
            __props__.__dict__["modules"] = modules
            __props__.__dict__["name"] = name
            __props__.__dict__["python_files"] = python_files
            if queue_name is None and not opts.urn:
                raise TypeError("Missing required property 'queue_name'")
            __props__.__dict__["queue_name"] = queue_name
            __props__.__dict__["region"] = region
            __props__.__dict__["spark_version"] = spark_version
            __props__.__dict__["specification"] = specification
            __props__.__dict__["created_at"] = None
            __props__.__dict__["owner"] = None
        super(SparkJob, __self__).__init__(
            'sbercloud:Dli/sparkJob:SparkJob',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_name: Optional[pulumi.Input[_builtins.str]] = None,
            app_parameters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            configurations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            dependent_packages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SparkJobDependentPackageArgs', 'SparkJobDependentPackageArgsDict']]]]] = None,
            driver_cores: Optional[pulumi.Input[_builtins.int]] = None,
            driver_memory: Optional[pulumi.Input[_builtins.str]] = None,
            executor_cores: Optional[pulumi.Input[_builtins.int]] = None,
            executor_memory: Optional[pulumi.Input[_builtins.str]] = None,
            executors: Optional[pulumi.Input[_builtins.int]] = None,
            feature: Optional[pulumi.Input[_builtins.str]] = None,
            files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            jars: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            main_class: Optional[pulumi.Input[_builtins.str]] = None,
            max_retries: Optional[pulumi.Input[_builtins.int]] = None,
            modules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            owner: Optional[pulumi.Input[_builtins.str]] = None,
            python_files: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            queue_name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            spark_version: Optional[pulumi.Input[_builtins.str]] = None,
            specification: Optional[pulumi.Input[_builtins.str]] = None) -> 'SparkJob':
        """
        Get an existing SparkJob resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_name: Specifies the name of the package that is of the JAR or python file type and
               has been uploaded to the DLI resource management system.
               The OBS paths are allowed, for example, `obs://<bucket name>/<package name>`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] app_parameters: Specifies the input parameters of the main class.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] configurations: Specifies the configuration items of the DLI spark.
               Please following the document of Spark [configurations](https://spark.apache.org/docs/latest/configuration.html) for
               this argument. If you want to enable the `access metadata` of DLI spark in SberCloud, please set
               `spark.dli.metaAccess.enable` to `true`. Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] created_at: Time of the DLI spark job submit.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SparkJobDependentPackageArgs', 'SparkJobDependentPackageArgsDict']]]] dependent_packages: Specifies a list of package resource objects.
               The object structure is documented below.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.int] driver_cores: Specifies the number of CPU cores of the Spark application driver.
               The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] driver_memory: Specifies the driver memory of the spark application.
               The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.int] executor_cores: Specifies the number of CPU cores of each executor in the Spark
               application. The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] executor_memory: Specifies the executor memory of the spark application.
               application. The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
               
               ->**NOTE:** The unit must be provided, such as **GB** or **MB**.
        :param pulumi.Input[_builtins.int] executors: Specifies the number of executors in a spark application.
               The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] feature: Specifies the feature name for the Spark Job.
               Required for Spark 3. Known values: `basic`, `ai`, `custom`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] files: Specifies a list of the other dependencies name which has been uploaded to the
               DLI resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<dependent files>`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] jars: Specifies a list of the jar package name which has been uploaded to the DLI
               resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<package name>`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] main_class: Specifies the main class of the spark job.
               Required if the `app_name` is the JAR type.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.int] max_retries: Specifies the maximum retry times.
               The default value of this value corresponds to the configuration of the selected `specification`.
               If you set this value instead of the default value, `specification` will be invalid.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] modules: Specifies a list of modules that depend on system resources.
               The dependent modules and corresponding services are as follows.
               Changing this parameter will submit a new spark job.
               + **sys.datasource.hbase**: CloudTable/MRS HBase
               + **sys.datasource.opentsdb**: CloudTable/MRS OpenTSDB
               + **sys.datasource.rds**: RDS MySQL
               + **sys.datasource.css**: CSS
        :param pulumi.Input[_builtins.str] name: Specifies the spark job name.
               The value contains a maximum of 128 characters.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] owner: The owner of the spark job.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] python_files: Specifies a list of the python file name which has been uploaded to the
               DLI resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<python file name>`.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] queue_name: Specifies the DLI queue name.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to submit a spark job.
               If omitted, the provider-level region will be used.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] spark_version: Version of Spark to use.
               Changing this parameter will submit a new spark job.
        :param pulumi.Input[_builtins.str] specification: Specifies the compute resource type for spark application.
               The available types and related specifications are as follows, default to minimum configuration (type **A**).
               Changing this parameter will submit a new spark job.
               
               | type | resource | driver cores | excutor cores | driver memory | executor memory | num executor |
               | ---- | ---- | ---- | ---- | ---- | ---- | ---- |
               | A | 8 vCPUs, 32-GB memory | 2 | 1 | 7G | 4G | 6 |
               | B | 16 vCPUs, 64-GB memory | 2 | 2 | 7G | 8G | 7 |
               | C | 32 vCPUs, 128-GB memory | 4 | 2 | 12G | 8G | 14 |
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SparkJobState.__new__(_SparkJobState)

        __props__.__dict__["app_name"] = app_name
        __props__.__dict__["app_parameters"] = app_parameters
        __props__.__dict__["configurations"] = configurations
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["dependent_packages"] = dependent_packages
        __props__.__dict__["driver_cores"] = driver_cores
        __props__.__dict__["driver_memory"] = driver_memory
        __props__.__dict__["executor_cores"] = executor_cores
        __props__.__dict__["executor_memory"] = executor_memory
        __props__.__dict__["executors"] = executors
        __props__.__dict__["feature"] = feature
        __props__.__dict__["files"] = files
        __props__.__dict__["jars"] = jars
        __props__.__dict__["main_class"] = main_class
        __props__.__dict__["max_retries"] = max_retries
        __props__.__dict__["modules"] = modules
        __props__.__dict__["name"] = name
        __props__.__dict__["owner"] = owner
        __props__.__dict__["python_files"] = python_files
        __props__.__dict__["queue_name"] = queue_name
        __props__.__dict__["region"] = region
        __props__.__dict__["spark_version"] = spark_version
        __props__.__dict__["specification"] = specification
        return SparkJob(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the package that is of the JAR or python file type and
        has been uploaded to the DLI resource management system.
        The OBS paths are allowed, for example, `obs://<bucket name>/<package name>`.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "app_name")

    @_builtins.property
    @pulumi.getter(name="appParameters")
    def app_parameters(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the input parameters of the main class.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "app_parameters")

    @_builtins.property
    @pulumi.getter
    def configurations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the configuration items of the DLI spark.
        Please following the document of Spark [configurations](https://spark.apache.org/docs/latest/configuration.html) for
        this argument. If you want to enable the `access metadata` of DLI spark in SberCloud, please set
        `spark.dli.metaAccess.enable` to `true`. Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "configurations")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Time of the DLI spark job submit.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dependentPackages")
    def dependent_packages(self) -> pulumi.Output[Optional[Sequence['outputs.SparkJobDependentPackage']]]:
        """
        Specifies a list of package resource objects.
        The object structure is documented below.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "dependent_packages")

    @_builtins.property
    @pulumi.getter(name="driverCores")
    def driver_cores(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the number of CPU cores of the Spark application driver.
        The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "driver_cores")

    @_builtins.property
    @pulumi.getter(name="driverMemory")
    def driver_memory(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the driver memory of the spark application.
        The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "driver_memory")

    @_builtins.property
    @pulumi.getter(name="executorCores")
    def executor_cores(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the number of CPU cores of each executor in the Spark
        application. The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "executor_cores")

    @_builtins.property
    @pulumi.getter(name="executorMemory")
    def executor_memory(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the executor memory of the spark application.
        application. The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.

        ->**NOTE:** The unit must be provided, such as **GB** or **MB**.
        """
        return pulumi.get(self, "executor_memory")

    @_builtins.property
    @pulumi.getter
    def executors(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the number of executors in a spark application.
        The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "executors")

    @_builtins.property
    @pulumi.getter
    def feature(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the feature name for the Spark Job.
        Required for Spark 3. Known values: `basic`, `ai`, `custom`.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "feature")

    @_builtins.property
    @pulumi.getter
    def files(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of the other dependencies name which has been uploaded to the
        DLI resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<dependent files>`.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "files")

    @_builtins.property
    @pulumi.getter
    def jars(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of the jar package name which has been uploaded to the DLI
        resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<package name>`.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "jars")

    @_builtins.property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the main class of the spark job.
        Required if the `app_name` is the JAR type.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "main_class")

    @_builtins.property
    @pulumi.getter(name="maxRetries")
    def max_retries(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the maximum retry times.
        The default value of this value corresponds to the configuration of the selected `specification`.
        If you set this value instead of the default value, `specification` will be invalid.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "max_retries")

    @_builtins.property
    @pulumi.getter
    def modules(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of modules that depend on system resources.
        The dependent modules and corresponding services are as follows.
        Changing this parameter will submit a new spark job.
        + **sys.datasource.hbase**: CloudTable/MRS HBase
        + **sys.datasource.opentsdb**: CloudTable/MRS OpenTSDB
        + **sys.datasource.rds**: RDS MySQL
        + **sys.datasource.css**: CSS
        """
        return pulumi.get(self, "modules")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the spark job name.
        The value contains a maximum of 128 characters.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def owner(self) -> pulumi.Output[_builtins.str]:
        """
        The owner of the spark job.
        """
        return pulumi.get(self, "owner")

    @_builtins.property
    @pulumi.getter(name="pythonFiles")
    def python_files(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies a list of the python file name which has been uploaded to the
        DLI resource management system. The OBS paths are allowed, for example, `obs://<bucket name>/<python file name>`.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "python_files")

    @_builtins.property
    @pulumi.getter(name="queueName")
    def queue_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the DLI queue name.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "queue_name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to submit a spark job.
        If omitted, the provider-level region will be used.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sparkVersion")
    def spark_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Version of Spark to use.
        Changing this parameter will submit a new spark job.
        """
        return pulumi.get(self, "spark_version")

    @_builtins.property
    @pulumi.getter
    def specification(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the compute resource type for spark application.
        The available types and related specifications are as follows, default to minimum configuration (type **A**).
        Changing this parameter will submit a new spark job.

        | type | resource | driver cores | excutor cores | driver memory | executor memory | num executor |
        | ---- | ---- | ---- | ---- | ---- | ---- | ---- |
        | A | 8 vCPUs, 32-GB memory | 2 | 1 | 7G | 4G | 6 |
        | B | 16 vCPUs, 64-GB memory | 2 | 2 | 7G | 8G | 7 |
        | C | 32 vCPUs, 128-GB memory | 4 | 2 | 12G | 8G | 14 |
        """
        return pulumi.get(self, "specification")

