# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'KafkaInstanceCrossVpcAccessArgs',
    'KafkaInstanceCrossVpcAccessArgsDict',
    'KafkaInstanceParameterArgs',
    'KafkaInstanceParameterArgsDict',
    'KafkaInstancePortProtocolArgs',
    'KafkaInstancePortProtocolArgsDict',
    'KafkaPermissionsPolicyArgs',
    'KafkaPermissionsPolicyArgsDict',
    'KafkaTopicConfigArgs',
    'KafkaTopicConfigArgsDict',
]

MYPY = False

if not MYPY:
    class KafkaInstanceCrossVpcAccessArgsDict(TypedDict):
        advertised_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        The advertised IP Address or domain name.
        """
        lisenter_ip: NotRequired[pulumi.Input[_builtins.str]]
        listener_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        The listener IP address.
        """
        port: NotRequired[pulumi.Input[_builtins.int]]
        """
        The port number.
        """
        port_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The port ID associated with the address.
        """
elif False:
    KafkaInstanceCrossVpcAccessArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KafkaInstanceCrossVpcAccessArgs:
    def __init__(__self__, *,
                 advertised_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 lisenter_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 listener_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] advertised_ip: The advertised IP Address or domain name.
        :param pulumi.Input[_builtins.str] listener_ip: The listener IP address.
        :param pulumi.Input[_builtins.int] port: The port number.
        :param pulumi.Input[_builtins.str] port_id: The port ID associated with the address.
        """
        if advertised_ip is not None:
            pulumi.set(__self__, "advertised_ip", advertised_ip)
        if lisenter_ip is not None:
            warnings.warn("""typo in lisenter_ip, please use \"listener_ip\" instead.""", DeprecationWarning)
            pulumi.log.warn("""lisenter_ip is deprecated: typo in lisenter_ip, please use \"listener_ip\" instead.""")
        if lisenter_ip is not None:
            pulumi.set(__self__, "lisenter_ip", lisenter_ip)
        if listener_ip is not None:
            pulumi.set(__self__, "listener_ip", listener_ip)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)

    @_builtins.property
    @pulumi.getter(name="advertisedIp")
    def advertised_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The advertised IP Address or domain name.
        """
        return pulumi.get(self, "advertised_ip")

    @advertised_ip.setter
    def advertised_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "advertised_ip", value)

    @_builtins.property
    @pulumi.getter(name="lisenterIp")
    @_utilities.deprecated("""typo in lisenter_ip, please use \"listener_ip\" instead.""")
    def lisenter_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "lisenter_ip")

    @lisenter_ip.setter
    def lisenter_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lisenter_ip", value)

    @_builtins.property
    @pulumi.getter(name="listenerIp")
    def listener_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The listener IP address.
        """
        return pulumi.get(self, "listener_ip")

    @listener_ip.setter
    def listener_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "listener_ip", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port number.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port ID associated with the address.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_id", value)


if not MYPY:
    class KafkaInstanceParameterArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Specifies the name of the DMS Kafka instance. An instance name starts with a letter,
        consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        value: pulumi.Input[_builtins.str]
elif False:
    KafkaInstanceParameterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KafkaInstanceParameterArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: Specifies the name of the DMS Kafka instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the DMS Kafka instance. An instance name starts with a letter,
        consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class KafkaInstancePortProtocolArgsDict(TypedDict):
        private_plain_address: NotRequired[pulumi.Input[_builtins.str]]
        private_plain_domain_name: NotRequired[pulumi.Input[_builtins.str]]
        private_plain_enable: NotRequired[pulumi.Input[_builtins.bool]]
        private_sasl_plaintext_address: NotRequired[pulumi.Input[_builtins.str]]
        private_sasl_plaintext_domain_name: NotRequired[pulumi.Input[_builtins.str]]
        private_sasl_plaintext_enable: NotRequired[pulumi.Input[_builtins.bool]]
        private_sasl_ssl_address: NotRequired[pulumi.Input[_builtins.str]]
        private_sasl_ssl_domain_name: NotRequired[pulumi.Input[_builtins.str]]
        private_sasl_ssl_enable: NotRequired[pulumi.Input[_builtins.bool]]
        public_plain_address: NotRequired[pulumi.Input[_builtins.str]]
        public_plain_domain_name: NotRequired[pulumi.Input[_builtins.str]]
        public_plain_enable: NotRequired[pulumi.Input[_builtins.bool]]
        public_sasl_plaintext_address: NotRequired[pulumi.Input[_builtins.str]]
        public_sasl_plaintext_domain_name: NotRequired[pulumi.Input[_builtins.str]]
        public_sasl_plaintext_enable: NotRequired[pulumi.Input[_builtins.bool]]
        public_sasl_ssl_address: NotRequired[pulumi.Input[_builtins.str]]
        public_sasl_ssl_domain_name: NotRequired[pulumi.Input[_builtins.str]]
        public_sasl_ssl_enable: NotRequired[pulumi.Input[_builtins.bool]]
elif False:
    KafkaInstancePortProtocolArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KafkaInstancePortProtocolArgs:
    def __init__(__self__, *,
                 private_plain_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_plain_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_plain_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_sasl_plaintext_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_sasl_plaintext_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_sasl_plaintext_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 private_sasl_ssl_address: Optional[pulumi.Input[_builtins.str]] = None,
                 private_sasl_ssl_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_sasl_ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_plain_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_plain_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_plain_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_sasl_plaintext_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_sasl_plaintext_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_sasl_plaintext_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_sasl_ssl_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_sasl_ssl_domain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_sasl_ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None):
        if private_plain_address is not None:
            pulumi.set(__self__, "private_plain_address", private_plain_address)
        if private_plain_domain_name is not None:
            pulumi.set(__self__, "private_plain_domain_name", private_plain_domain_name)
        if private_plain_enable is not None:
            pulumi.set(__self__, "private_plain_enable", private_plain_enable)
        if private_sasl_plaintext_address is not None:
            pulumi.set(__self__, "private_sasl_plaintext_address", private_sasl_plaintext_address)
        if private_sasl_plaintext_domain_name is not None:
            pulumi.set(__self__, "private_sasl_plaintext_domain_name", private_sasl_plaintext_domain_name)
        if private_sasl_plaintext_enable is not None:
            pulumi.set(__self__, "private_sasl_plaintext_enable", private_sasl_plaintext_enable)
        if private_sasl_ssl_address is not None:
            pulumi.set(__self__, "private_sasl_ssl_address", private_sasl_ssl_address)
        if private_sasl_ssl_domain_name is not None:
            pulumi.set(__self__, "private_sasl_ssl_domain_name", private_sasl_ssl_domain_name)
        if private_sasl_ssl_enable is not None:
            pulumi.set(__self__, "private_sasl_ssl_enable", private_sasl_ssl_enable)
        if public_plain_address is not None:
            pulumi.set(__self__, "public_plain_address", public_plain_address)
        if public_plain_domain_name is not None:
            pulumi.set(__self__, "public_plain_domain_name", public_plain_domain_name)
        if public_plain_enable is not None:
            pulumi.set(__self__, "public_plain_enable", public_plain_enable)
        if public_sasl_plaintext_address is not None:
            pulumi.set(__self__, "public_sasl_plaintext_address", public_sasl_plaintext_address)
        if public_sasl_plaintext_domain_name is not None:
            pulumi.set(__self__, "public_sasl_plaintext_domain_name", public_sasl_plaintext_domain_name)
        if public_sasl_plaintext_enable is not None:
            pulumi.set(__self__, "public_sasl_plaintext_enable", public_sasl_plaintext_enable)
        if public_sasl_ssl_address is not None:
            pulumi.set(__self__, "public_sasl_ssl_address", public_sasl_ssl_address)
        if public_sasl_ssl_domain_name is not None:
            pulumi.set(__self__, "public_sasl_ssl_domain_name", public_sasl_ssl_domain_name)
        if public_sasl_ssl_enable is not None:
            pulumi.set(__self__, "public_sasl_ssl_enable", public_sasl_ssl_enable)

    @_builtins.property
    @pulumi.getter(name="privatePlainAddress")
    def private_plain_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "private_plain_address")

    @private_plain_address.setter
    def private_plain_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_plain_address", value)

    @_builtins.property
    @pulumi.getter(name="privatePlainDomainName")
    def private_plain_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "private_plain_domain_name")

    @private_plain_domain_name.setter
    def private_plain_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_plain_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="privatePlainEnable")
    def private_plain_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "private_plain_enable")

    @private_plain_enable.setter
    def private_plain_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_plain_enable", value)

    @_builtins.property
    @pulumi.getter(name="privateSaslPlaintextAddress")
    def private_sasl_plaintext_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "private_sasl_plaintext_address")

    @private_sasl_plaintext_address.setter
    def private_sasl_plaintext_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_sasl_plaintext_address", value)

    @_builtins.property
    @pulumi.getter(name="privateSaslPlaintextDomainName")
    def private_sasl_plaintext_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "private_sasl_plaintext_domain_name")

    @private_sasl_plaintext_domain_name.setter
    def private_sasl_plaintext_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_sasl_plaintext_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="privateSaslPlaintextEnable")
    def private_sasl_plaintext_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "private_sasl_plaintext_enable")

    @private_sasl_plaintext_enable.setter
    def private_sasl_plaintext_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_sasl_plaintext_enable", value)

    @_builtins.property
    @pulumi.getter(name="privateSaslSslAddress")
    def private_sasl_ssl_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "private_sasl_ssl_address")

    @private_sasl_ssl_address.setter
    def private_sasl_ssl_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_sasl_ssl_address", value)

    @_builtins.property
    @pulumi.getter(name="privateSaslSslDomainName")
    def private_sasl_ssl_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "private_sasl_ssl_domain_name")

    @private_sasl_ssl_domain_name.setter
    def private_sasl_ssl_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_sasl_ssl_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="privateSaslSslEnable")
    def private_sasl_ssl_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "private_sasl_ssl_enable")

    @private_sasl_ssl_enable.setter
    def private_sasl_ssl_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "private_sasl_ssl_enable", value)

    @_builtins.property
    @pulumi.getter(name="publicPlainAddress")
    def public_plain_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_plain_address")

    @public_plain_address.setter
    def public_plain_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_plain_address", value)

    @_builtins.property
    @pulumi.getter(name="publicPlainDomainName")
    def public_plain_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_plain_domain_name")

    @public_plain_domain_name.setter
    def public_plain_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_plain_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="publicPlainEnable")
    def public_plain_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "public_plain_enable")

    @public_plain_enable.setter
    def public_plain_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_plain_enable", value)

    @_builtins.property
    @pulumi.getter(name="publicSaslPlaintextAddress")
    def public_sasl_plaintext_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_sasl_plaintext_address")

    @public_sasl_plaintext_address.setter
    def public_sasl_plaintext_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_sasl_plaintext_address", value)

    @_builtins.property
    @pulumi.getter(name="publicSaslPlaintextDomainName")
    def public_sasl_plaintext_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_sasl_plaintext_domain_name")

    @public_sasl_plaintext_domain_name.setter
    def public_sasl_plaintext_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_sasl_plaintext_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="publicSaslPlaintextEnable")
    def public_sasl_plaintext_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "public_sasl_plaintext_enable")

    @public_sasl_plaintext_enable.setter
    def public_sasl_plaintext_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_sasl_plaintext_enable", value)

    @_builtins.property
    @pulumi.getter(name="publicSaslSslAddress")
    def public_sasl_ssl_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_sasl_ssl_address")

    @public_sasl_ssl_address.setter
    def public_sasl_ssl_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_sasl_ssl_address", value)

    @_builtins.property
    @pulumi.getter(name="publicSaslSslDomainName")
    def public_sasl_ssl_domain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_sasl_ssl_domain_name")

    @public_sasl_ssl_domain_name.setter
    def public_sasl_ssl_domain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_sasl_ssl_domain_name", value)

    @_builtins.property
    @pulumi.getter(name="publicSaslSslEnable")
    def public_sasl_ssl_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "public_sasl_ssl_enable")

    @public_sasl_ssl_enable.setter
    def public_sasl_ssl_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_sasl_ssl_enable", value)


if not MYPY:
    class KafkaPermissionsPolicyArgsDict(TypedDict):
        access_policy: pulumi.Input[_builtins.str]
        """
        Specifies the permissions type. The value can be:
        + **all**: publish and subscribe permissions.
        + **pub**: publish permissions.
        + **sub**: subscribe permissions.
        """
        user_name: pulumi.Input[_builtins.str]
        """
        Specifies the username.
        """
elif False:
    KafkaPermissionsPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KafkaPermissionsPolicyArgs:
    def __init__(__self__, *,
                 access_policy: pulumi.Input[_builtins.str],
                 user_name: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] access_policy: Specifies the permissions type. The value can be:
               + **all**: publish and subscribe permissions.
               + **pub**: publish permissions.
               + **sub**: subscribe permissions.
        :param pulumi.Input[_builtins.str] user_name: Specifies the username.
        """
        pulumi.set(__self__, "access_policy", access_policy)
        pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the permissions type. The value can be:
        + **all**: publish and subscribe permissions.
        + **pub**: publish permissions.
        + **sub**: subscribe permissions.
        """
        return pulumi.get(self, "access_policy")

    @access_policy.setter
    def access_policy(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_policy", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the username.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_name", value)


if not MYPY:
    class KafkaTopicConfigArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        Specifies the name of the topic. The name starts with a letter, consists of 4 to
        64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
        resource.
        """
        value: pulumi.Input[_builtins.str]
elif False:
    KafkaTopicConfigArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class KafkaTopicConfigArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] name: Specifies the name of the topic. The name starts with a letter, consists of 4 to
               64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
               resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the topic. The name starts with a letter, consists of 4 to
        64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
        resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


