# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstancesResult',
    'AwaitableGetInstancesResult',
    'get_instances',
    'get_instances_output',
]

@pulumi.output_type
class GetInstancesResult:
    """
    A collection of values returned by getInstances.
    """
    def __init__(__self__, enterprise_project_id=None, fuzzy_match=None, id=None, include_failure=None, instance_id=None, instances=None, name=None, region=None, status=None):
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if fuzzy_match and not isinstance(fuzzy_match, bool):
            raise TypeError("Expected argument 'fuzzy_match' to be a bool")
        pulumi.set(__self__, "fuzzy_match", fuzzy_match)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_failure and not isinstance(include_failure, bool):
            raise TypeError("Expected argument 'include_failure' to be a bool")
        pulumi.set(__self__, "include_failure", include_failure)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        """
        The enterprise project ID to which the instance belongs.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="fuzzyMatch")
    def fuzzy_match(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "fuzzy_match")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="includeFailure")
    def include_failure(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "include_failure")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetInstancesInstanceResult']:
        """
        The result of the query's list of kafka instances. The structure is documented below.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The instance name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The instance status.
        """
        return pulumi.get(self, "status")


class AwaitableGetInstancesResult(GetInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancesResult(
            enterprise_project_id=self.enterprise_project_id,
            fuzzy_match=self.fuzzy_match,
            id=self.id,
            include_failure=self.include_failure,
            instance_id=self.instance_id,
            instances=self.instances,
            name=self.name,
            region=self.region,
            status=self.status)


def get_instances(enterprise_project_id: Optional[_builtins.str] = None,
                  fuzzy_match: Optional[_builtins.bool] = None,
                  include_failure: Optional[_builtins.bool] = None,
                  instance_id: Optional[_builtins.str] = None,
                  name: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  status: Optional[_builtins.str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancesResult:
    """
    Use this data source to query the available instances within sbercloud DMS service.

    ## Example Usage

    ### Query all instances with the keyword in the name

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    keyword = config.require_object("keyword")
    test = sbercloud.Dms.get_instances(name=keyword,
        fuzzy_match=True)
    ```

    ### Query the instance with the specified name

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_name = config.require_object("instanceName")
    test = sbercloud.Dms.get_instances(name=instance_name)
    ```


    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID to which all instances of the list
           belong.
    :param _builtins.bool fuzzy_match: Specifies whether to match the instance name fuzzily, the default is a exact
           match (`flase`).
    :param _builtins.bool include_failure: Specifies whether the query results contain instances that failed to create.
    :param _builtins.str instance_id: Specifies the kafka instance ID to match exactly.
    :param _builtins.str name: Specifies the kafka instance name for data-source queries.
    :param _builtins.str region: The region in which to query the kafka instance list.
           If omitted, the provider-level region will be used.
    :param _builtins.str status: Specifies the kafka instance status for data-source queries.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['fuzzyMatch'] = fuzzy_match
    __args__['includeFailure'] = include_failure
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Dms/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult).value

    return AwaitableGetInstancesResult(
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        fuzzy_match=pulumi.get(__ret__, 'fuzzy_match'),
        id=pulumi.get(__ret__, 'id'),
        include_failure=pulumi.get(__ret__, 'include_failure'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        instances=pulumi.get(__ret__, 'instances'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'))
def get_instances_output(enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         fuzzy_match: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                         include_failure: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                         instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstancesResult]:
    """
    Use this data source to query the available instances within sbercloud DMS service.

    ## Example Usage

    ### Query all instances with the keyword in the name

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    keyword = config.require_object("keyword")
    test = sbercloud.Dms.get_instances(name=keyword,
        fuzzy_match=True)
    ```

    ### Query the instance with the specified name

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    instance_name = config.require_object("instanceName")
    test = sbercloud.Dms.get_instances(name=instance_name)
    ```


    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID to which all instances of the list
           belong.
    :param _builtins.bool fuzzy_match: Specifies whether to match the instance name fuzzily, the default is a exact
           match (`flase`).
    :param _builtins.bool include_failure: Specifies whether the query results contain instances that failed to create.
    :param _builtins.str instance_id: Specifies the kafka instance ID to match exactly.
    :param _builtins.str name: Specifies the kafka instance name for data-source queries.
    :param _builtins.str region: The region in which to query the kafka instance list.
           If omitted, the provider-level region will be used.
    :param _builtins.str status: Specifies the kafka instance status for data-source queries.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['fuzzyMatch'] = fuzzy_match
    __args__['includeFailure'] = include_failure
    __args__['instanceId'] = instance_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Dms/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult)
    return __ret__.apply(lambda __response__: GetInstancesResult(
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        fuzzy_match=pulumi.get(__response__, 'fuzzy_match'),
        id=pulumi.get(__response__, 'id'),
        include_failure=pulumi.get(__response__, 'include_failure'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        instances=pulumi.get(__response__, 'instances'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status')))
