# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetProductResult',
    'AwaitableGetProductResult',
    'get_product',
    'get_product_output',
]

@pulumi.output_type
class GetProductResult:
    """
    A collection of values returned by getProduct.
    """
    def __init__(__self__, availability_zones=None, bandwidth=None, engine=None, id=None, instance_type=None, io_type=None, node_num=None, partition_num=None, region=None, storage=None, storage_spec_code=None, storage_spec_codes=None, version=None, vm_specification=None):
        if availability_zones and not isinstance(availability_zones, list):
            raise TypeError("Expected argument 'availability_zones' to be a list")
        pulumi.set(__self__, "availability_zones", availability_zones)
        if bandwidth and not isinstance(bandwidth, str):
            raise TypeError("Expected argument 'bandwidth' to be a str")
        pulumi.set(__self__, "bandwidth", bandwidth)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_type and not isinstance(instance_type, str):
            raise TypeError("Expected argument 'instance_type' to be a str")
        pulumi.set(__self__, "instance_type", instance_type)
        if io_type and not isinstance(io_type, str):
            raise TypeError("Expected argument 'io_type' to be a str")
        pulumi.set(__self__, "io_type", io_type)
        if node_num and not isinstance(node_num, str):
            raise TypeError("Expected argument 'node_num' to be a str")
        pulumi.set(__self__, "node_num", node_num)
        if partition_num and not isinstance(partition_num, str):
            raise TypeError("Expected argument 'partition_num' to be a str")
        pulumi.set(__self__, "partition_num", partition_num)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if storage and not isinstance(storage, str):
            raise TypeError("Expected argument 'storage' to be a str")
        pulumi.set(__self__, "storage", storage)
        if storage_spec_code and not isinstance(storage_spec_code, str):
            raise TypeError("Expected argument 'storage_spec_code' to be a str")
        pulumi.set(__self__, "storage_spec_code", storage_spec_code)
        if storage_spec_codes and not isinstance(storage_spec_codes, list):
            raise TypeError("Expected argument 'storage_spec_codes' to be a list")
        pulumi.set(__self__, "storage_spec_codes", storage_spec_codes)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if vm_specification and not isinstance(vm_specification, str):
            raise TypeError("Expected argument 'vm_specification' to be a str")
        pulumi.set(__self__, "vm_specification", vm_specification)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> _builtins.str:
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> _builtins.str:
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> _builtins.str:
        return pulumi.get(self, "instance_type")

    @_builtins.property
    @pulumi.getter(name="ioType")
    @_utilities.deprecated("""io_type has deprecated, please use storage_spec_code""")
    def io_type(self) -> _builtins.str:
        return pulumi.get(self, "io_type")

    @_builtins.property
    @pulumi.getter(name="nodeNum")
    def node_num(self) -> _builtins.str:
        return pulumi.get(self, "node_num")

    @_builtins.property
    @pulumi.getter(name="partitionNum")
    def partition_num(self) -> _builtins.str:
        return pulumi.get(self, "partition_num")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> _builtins.str:
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> _builtins.str:
        return pulumi.get(self, "storage_spec_code")

    @_builtins.property
    @pulumi.getter(name="storageSpecCodes")
    def storage_spec_codes(self) -> Sequence[_builtins.str]:
        """
        The available I/O specifications.
        """
        return pulumi.get(self, "storage_spec_codes")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="vmSpecification")
    def vm_specification(self) -> _builtins.str:
        return pulumi.get(self, "vm_specification")


class AwaitableGetProductResult(GetProductResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProductResult(
            availability_zones=self.availability_zones,
            bandwidth=self.bandwidth,
            engine=self.engine,
            id=self.id,
            instance_type=self.instance_type,
            io_type=self.io_type,
            node_num=self.node_num,
            partition_num=self.partition_num,
            region=self.region,
            storage=self.storage,
            storage_spec_code=self.storage_spec_code,
            storage_spec_codes=self.storage_spec_codes,
            version=self.version,
            vm_specification=self.vm_specification)


def get_product(availability_zones: Optional[Sequence[_builtins.str]] = None,
                bandwidth: Optional[_builtins.str] = None,
                engine: Optional[_builtins.str] = None,
                instance_type: Optional[_builtins.str] = None,
                io_type: Optional[_builtins.str] = None,
                node_num: Optional[_builtins.str] = None,
                partition_num: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                storage: Optional[_builtins.str] = None,
                storage_spec_code: Optional[_builtins.str] = None,
                version: Optional[_builtins.str] = None,
                vm_specification: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProductResult:
    """
    Use this data source to get the ID of an available SberCloud DMS product.

    ## Example Usage

    ### Filter DMS kafka product list by I/O specification

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    product1 = sbercloud.Dms.get_product(engine="kafka",
        version="1.1.0",
        instance_type="cluster",
        partition_num="300",
        storage="600",
        storage_spec_code="dms.physical.storage.high")
    ```

    ### Filter DMS kafka product list by underlying VM specification

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    product2 = sbercloud.Dms.get_product(engine="kafka",
        version="2.3.0",
        instance_type="cluster",
        vm_specification="c6.large.2")
    ```


    :param Sequence[_builtins.str] availability_zones: Indicates the list of availability zones with available resources.
    :param _builtins.str bandwidth: Indicates the baseline bandwidth of a DMS instance.
           The valid values are **100MB**, **300MB**, **600MB** and **1200MB**.
    :param _builtins.str engine: Indicates the name of a message engine. The valid values are **kafka**, **rabbitmq**.
    :param _builtins.str instance_type: Indicates an instance type. The valid values are **single** and **cluster**.
    :param _builtins.str node_num: Indicates the number of nodes in a cluster.
    :param _builtins.str partition_num: Indicates the maximum number of topics that can be created for a Kafka instance.
           The valid values are **300**, **900** and **1800**.
    :param _builtins.str region: The region in which to obtain the dms products. If omitted, the provider-level region
           will be used.
    :param _builtins.str storage: Indicates the storage capacity of the resource.
           The default value is the storage capacity of the product.
    :param _builtins.str storage_spec_code: Indicates an I/O specification.
           The valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
    :param _builtins.str version: Indicates the version of a message engine.
    :param _builtins.str vm_specification: Indicates underlying VM specification, such as **c6.large.2**.
    """
    __args__ = dict()
    __args__['availabilityZones'] = availability_zones
    __args__['bandwidth'] = bandwidth
    __args__['engine'] = engine
    __args__['instanceType'] = instance_type
    __args__['ioType'] = io_type
    __args__['nodeNum'] = node_num
    __args__['partitionNum'] = partition_num
    __args__['region'] = region
    __args__['storage'] = storage
    __args__['storageSpecCode'] = storage_spec_code
    __args__['version'] = version
    __args__['vmSpecification'] = vm_specification
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Dms/getProduct:getProduct', __args__, opts=opts, typ=GetProductResult).value

    return AwaitableGetProductResult(
        availability_zones=pulumi.get(__ret__, 'availability_zones'),
        bandwidth=pulumi.get(__ret__, 'bandwidth'),
        engine=pulumi.get(__ret__, 'engine'),
        id=pulumi.get(__ret__, 'id'),
        instance_type=pulumi.get(__ret__, 'instance_type'),
        io_type=pulumi.get(__ret__, 'io_type'),
        node_num=pulumi.get(__ret__, 'node_num'),
        partition_num=pulumi.get(__ret__, 'partition_num'),
        region=pulumi.get(__ret__, 'region'),
        storage=pulumi.get(__ret__, 'storage'),
        storage_spec_code=pulumi.get(__ret__, 'storage_spec_code'),
        storage_spec_codes=pulumi.get(__ret__, 'storage_spec_codes'),
        version=pulumi.get(__ret__, 'version'),
        vm_specification=pulumi.get(__ret__, 'vm_specification'))
def get_product_output(availability_zones: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                       bandwidth: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       engine: Optional[pulumi.Input[_builtins.str]] = None,
                       instance_type: Optional[pulumi.Input[_builtins.str]] = None,
                       io_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       node_num: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       partition_num: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       storage: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       storage_spec_code: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       version: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       vm_specification: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetProductResult]:
    """
    Use this data source to get the ID of an available SberCloud DMS product.

    ## Example Usage

    ### Filter DMS kafka product list by I/O specification

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    product1 = sbercloud.Dms.get_product(engine="kafka",
        version="1.1.0",
        instance_type="cluster",
        partition_num="300",
        storage="600",
        storage_spec_code="dms.physical.storage.high")
    ```

    ### Filter DMS kafka product list by underlying VM specification

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    product2 = sbercloud.Dms.get_product(engine="kafka",
        version="2.3.0",
        instance_type="cluster",
        vm_specification="c6.large.2")
    ```


    :param Sequence[_builtins.str] availability_zones: Indicates the list of availability zones with available resources.
    :param _builtins.str bandwidth: Indicates the baseline bandwidth of a DMS instance.
           The valid values are **100MB**, **300MB**, **600MB** and **1200MB**.
    :param _builtins.str engine: Indicates the name of a message engine. The valid values are **kafka**, **rabbitmq**.
    :param _builtins.str instance_type: Indicates an instance type. The valid values are **single** and **cluster**.
    :param _builtins.str node_num: Indicates the number of nodes in a cluster.
    :param _builtins.str partition_num: Indicates the maximum number of topics that can be created for a Kafka instance.
           The valid values are **300**, **900** and **1800**.
    :param _builtins.str region: The region in which to obtain the dms products. If omitted, the provider-level region
           will be used.
    :param _builtins.str storage: Indicates the storage capacity of the resource.
           The default value is the storage capacity of the product.
    :param _builtins.str storage_spec_code: Indicates an I/O specification.
           The valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
    :param _builtins.str version: Indicates the version of a message engine.
    :param _builtins.str vm_specification: Indicates underlying VM specification, such as **c6.large.2**.
    """
    __args__ = dict()
    __args__['availabilityZones'] = availability_zones
    __args__['bandwidth'] = bandwidth
    __args__['engine'] = engine
    __args__['instanceType'] = instance_type
    __args__['ioType'] = io_type
    __args__['nodeNum'] = node_num
    __args__['partitionNum'] = partition_num
    __args__['region'] = region
    __args__['storage'] = storage
    __args__['storageSpecCode'] = storage_spec_code
    __args__['version'] = version
    __args__['vmSpecification'] = vm_specification
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Dms/getProduct:getProduct', __args__, opts=opts, typ=GetProductResult)
    return __ret__.apply(lambda __response__: GetProductResult(
        availability_zones=pulumi.get(__response__, 'availability_zones'),
        bandwidth=pulumi.get(__response__, 'bandwidth'),
        engine=pulumi.get(__response__, 'engine'),
        id=pulumi.get(__response__, 'id'),
        instance_type=pulumi.get(__response__, 'instance_type'),
        io_type=pulumi.get(__response__, 'io_type'),
        node_num=pulumi.get(__response__, 'node_num'),
        partition_num=pulumi.get(__response__, 'partition_num'),
        region=pulumi.get(__response__, 'region'),
        storage=pulumi.get(__response__, 'storage'),
        storage_spec_code=pulumi.get(__response__, 'storage_spec_code'),
        storage_spec_codes=pulumi.get(__response__, 'storage_spec_codes'),
        version=pulumi.get(__response__, 'version'),
        vm_specification=pulumi.get(__response__, 'vm_specification')))
