# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KafkaInstanceArgs', 'KafkaInstance']

@pulumi.input_type
class KafkaInstanceArgs:
    def __init__(__self__, *,
                 engine_version: pulumi.Input[_builtins.str],
                 network_id: pulumi.Input[_builtins.str],
                 security_group_id: pulumi.Input[_builtins.str],
                 storage_spec_code: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 access_user: Optional[pulumi.Input[_builtins.str]] = None,
                 arch_type: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 broker_num: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_vpc_accesses: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceCrossVpcAccessArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dumping: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_auto_topic: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_mechanisms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_password: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_user: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_tenant_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceParameterArgs']]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_client_plain: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a KafkaInstance resource.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the version of the Kafka engine,
               such as 1.1.0, 2.3.0, 2.7 or other supported versions. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] network_id: Specifies the ID of a subnet. Changing this creates a new instance
               resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[_builtins.str] storage_spec_code: Specifies the storage I/O specification. Value range:
               + When bandwidth is 100MB: dms.physical.storage.high or dms.physical.storage.ultra
               + When bandwidth is 300MB: dms.physical.storage.high or dms.physical.storage.ultra
               + When bandwidth is 600MB: dms.physical.storage.ultra
               + When bandwidth is 1200MB: dms.physical.storage.ultra
               
               If the instance is created with `product_id`, the valid values are as follows:
               + **dms.physical.storage.high**: Type of the disk that uses high I/O.
               The corresponding bandwidths are **100MB** and **300MB**.
               + **dms.physical.storage.ultra**: Type of the disk that uses ultra-high I/O.
               The corresponding bandwidths are **100MB**, **300MB**, **600MB** and **1,200MB**.
               
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] access_user: Specifies the username of SASL_SSL user. A username consists of 4
               to 64 characters and supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "false".
               
               <a name="dms_cross_vpc_accesses"></a>
               The `cross_vpc_accesses` block supports:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The names of the AZ where the Kafka instances reside.
               The parameter value can not be left blank or an empty array. Changing this creates a new instance resource.
               
               > **NOTE:** Deploy one availability zone or at least three availability zones. Do not select two availability zones.
               Deploy to more availability zones, the better the reliability and SLA coverage.
               
               > The parameter behavior of `availability_zones` has been changed from `list` to `set`.
        :param pulumi.Input[_builtins.int] broker_num: Specifies the broker numbers.
               It is required when creating an instance with `flavor_id`.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the instance. Valid values are *prePaid*
               and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaInstanceCrossVpcAccessArgs']]] cross_vpc_accesses: Specifies the cross-VPC access information.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the DMS Kafka instance. It is a character string
               containing not more than 1,024 characters.
        :param pulumi.Input[_builtins.bool] dumping: Specifies whether to enable message dumping.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.bool] enable_auto_topic: Specifies whether to enable automatic topic creation. If automatic
               topic creation is enabled, a topic will be automatically created with 3 partitions and 3 replicas when a message is
               produced to or consumed from a topic that does not exist.
               The default value is false.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID of the Kafka instance.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the Kafka `flavor ID`. This parameter and `product_id` are alternative.
               
               > It is recommended to use `flavor_id` if the region supports it.\\
               One of:
               * c6.2u4g.cluster
               * c6.4u8g.cluster
               * c6.8u16g.cluster
               * c6.12u24g.cluster
               * c6.16u32g.cluster \\
               Or use data source sbercloud_dms_kafka_flavors
        :param pulumi.Input[_builtins.str] kms_encrypted_password: schema: Internal
        :param pulumi.Input[_builtins.str] maintain_begin: Specifies the time at which a maintenance time window starts. Format: HH:mm. The
               start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
               window. The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
               blank. In this case, the system automatically allocates the default start time 02:00.
        :param pulumi.Input[_builtins.str] maintain_end: Specifies the time at which a maintenance time window ends. Format: HH:mm. The
               start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
               window. The end time is four hours later than the start time. For example, if the start time is 22:00, the end time is
               02:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_end` is left blank, parameter
               `maintain_begin` is also blank. In this case, the system automatically allocates the default end time 06:00.
        :param pulumi.Input[_builtins.str] manager_password: Specifies the password for logging in to the Kafka Manager. The
               password must meet the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of
               the following character types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_
               =+\\\\|[{}]:'",<.>/?). Changing this creates a new instance resource.
               
               > **NOTE:** `manager_user` and `manager_password` are deprecated and will be deleted in future releases
        :param pulumi.Input[_builtins.str] manager_user: Specifies the username for logging in to the Kafka Manager. The username
               consists of 4 to 64 characters and can contain letters, digits, hyphens (-), and underscores (_). Changing this
               creates a new instance resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the DMS Kafka instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        :param pulumi.Input[_builtins.str] password: Specifies the password of SASL_SSL user. A password must meet the
               following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following character
               types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
               Changing this creates a new instance resource.
               
               > **NOTE:** `access_user` and `password` parameters are mandatory when ssl_enable is set to true. These parameters are invalid when ssl_enable is set to false. \\
               > **NOTE:** If `access_user` and `password` are specified, set `ssl_enable = true`, to enable SASL_SSL for a Kafka instance.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance. If `period_unit` is set to *month*
               , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter is
               mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] product_id: Specifies a product ID, which includes bandwidth, partition, broker and default
               storage capacity.
               
               > **NOTE:** Change this to change the bandwidth, partition and broker of the Kafka instances. Please note that the
               broker changes may cause storage capacity changes. So, if you specify the value of `storage_space`, you need to
               manually modify the value of `storage_space` after changing the `product_id`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] public_ip_ids: Specifies the IDs of the elastic IP address (EIP)
               bound to the DMS Kafka instance. Changing this creates a new instance resource.
               + If the instance is created with `flavor_id`, the total number of public IPs is equal to `broker_num`.
               + If the instance is created with `product_id`, the total number of public IPs must provide as follows:
               
               | Bandwidth | Total number of public IPs |
               | ---- | ---- |
               | 100MB | 3 |
               | 300MB | 3 |
               | 600MB | 4 |
               | 1,200MB | 8 |
        :param pulumi.Input[_builtins.str] region: The region in which to create the DMS Kafka instances. If omitted, the
               provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] retention_policy: Specifies the action to be taken when the memory usage reaches the disk
               capacity threshold. The valid values are as follows:
               + **time_base**: Automatically delete the earliest messages.
               + **produce_reject**: Stop producing new messages.
        :param pulumi.Input[_builtins.bool] ssl_enable: Indicates whether the Kafka SASL_SSL is enabled.
        :param pulumi.Input[_builtins.int] storage_space: Specifies the message storage capacity, the unit is GB.
               + When bandwidth is 100MB: 600–90000 GB
               + When bandwidth is 300MB: 1200–90000 GB
               + When bandwidth is 600MB: 2400–90000 GB
               + When bandwidth is 1200MB: 4800–90000 GB
               
               Changing this creates a new instance resource.
               
               It is required when creating an instance with `flavor_id`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the DMS Kafka instance.
        """
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "storage_spec_code", storage_spec_code)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if access_user is not None:
            pulumi.set(__self__, "access_user", access_user)
        if arch_type is not None:
            pulumi.set(__self__, "arch_type", arch_type)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_zones is not None:
            warnings.warn("""available_zones has deprecated, please use \"availability_zones\" instead.""", DeprecationWarning)
            pulumi.log.warn("""available_zones is deprecated: available_zones has deprecated, please use \"availability_zones\" instead.""")
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if bandwidth is not None:
            warnings.warn("""The bandwidth has been deprecated. If you need to change the bandwidth, please update the product_id.""", DeprecationWarning)
            pulumi.log.warn("""bandwidth is deprecated: The bandwidth has been deprecated. If you need to change the bandwidth, please update the product_id.""")
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if broker_num is not None:
            pulumi.set(__self__, "broker_num", broker_num)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if cross_vpc_accesses is not None:
            pulumi.set(__self__, "cross_vpc_accesses", cross_vpc_accesses)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dumping is not None:
            pulumi.set(__self__, "dumping", dumping)
        if enable_auto_topic is not None:
            pulumi.set(__self__, "enable_auto_topic", enable_auto_topic)
        if enabled_mechanisms is not None:
            pulumi.set(__self__, "enabled_mechanisms", enabled_mechanisms)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if manager_password is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""manager_password is deprecated: Deprecated""")
        if manager_password is not None:
            pulumi.set(__self__, "manager_password", manager_password)
        if manager_user is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""manager_user is deprecated: Deprecated""")
        if manager_user is not None:
            pulumi.set(__self__, "manager_user", manager_user)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_tenant_ips is not None:
            pulumi.set(__self__, "new_tenant_ips", new_tenant_ips)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if public_ip_ids is not None:
            pulumi.set(__self__, "public_ip_ids", public_ip_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if security_protocol is not None:
            pulumi.set(__self__, "security_protocol", security_protocol)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if storage_space is not None:
            pulumi.set(__self__, "storage_space", storage_space)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_client_plain is not None:
            pulumi.set(__self__, "vpc_client_plain", vpc_client_plain)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the version of the Kafka engine,
        such as 1.1.0, 2.3.0, 2.7 or other supported versions. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of a subnet. Changing this creates a new instance
        resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of a security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the storage I/O specification. Value range:
        + When bandwidth is 100MB: dms.physical.storage.high or dms.physical.storage.ultra
        + When bandwidth is 300MB: dms.physical.storage.high or dms.physical.storage.ultra
        + When bandwidth is 600MB: dms.physical.storage.ultra
        + When bandwidth is 1200MB: dms.physical.storage.ultra

        If the instance is created with `product_id`, the valid values are as follows:
        + **dms.physical.storage.high**: Type of the disk that uses high I/O.
        The corresponding bandwidths are **100MB** and **300MB**.
        + **dms.physical.storage.ultra**: Type of the disk that uses ultra-high I/O.
        The corresponding bandwidths are **100MB**, **300MB**, **600MB** and **1,200MB**.

        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "storage_spec_code")

    @storage_spec_code.setter
    def storage_spec_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_spec_code", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the username of SASL_SSL user. A username consists of 4
        to 64 characters and supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        """
        return pulumi.get(self, "access_user")

    @access_user.setter
    def access_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_user", value)

    @_builtins.property
    @pulumi.getter(name="archType")
    def arch_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "arch_type")

    @arch_type.setter
    def arch_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arch_type", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "false".

        <a name="dms_cross_vpc_accesses"></a>
        The `cross_vpc_accesses` block supports:
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The names of the AZ where the Kafka instances reside.
        The parameter value can not be left blank or an empty array. Changing this creates a new instance resource.

        > **NOTE:** Deploy one availability zone or at least three availability zones. Do not select two availability zones.
        Deploy to more availability zones, the better the reliability and SLA coverage.

        > The parameter behavior of `availability_zones` has been changed from `list` to `set`.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="availableZones")
    @_utilities.deprecated("""available_zones has deprecated, please use \"availability_zones\" instead.""")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "available_zones", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The bandwidth has been deprecated. If you need to change the bandwidth, please update the product_id.""")
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="brokerNum")
    def broker_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the broker numbers.
        It is required when creating an instance with `flavor_id`.
        """
        return pulumi.get(self, "broker_num")

    @broker_num.setter
    def broker_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "broker_num", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the instance. Valid values are *prePaid*
        and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="crossVpcAccesses")
    def cross_vpc_accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceCrossVpcAccessArgs']]]]:
        """
        Specifies the cross-VPC access information.
        The object structure is documented below.
        """
        return pulumi.get(self, "cross_vpc_accesses")

    @cross_vpc_accesses.setter
    def cross_vpc_accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceCrossVpcAccessArgs']]]]):
        pulumi.set(self, "cross_vpc_accesses", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the DMS Kafka instance. It is a character string
        containing not more than 1,024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def dumping(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable message dumping.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "dumping")

    @dumping.setter
    def dumping(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dumping", value)

    @_builtins.property
    @pulumi.getter(name="enableAutoTopic")
    def enable_auto_topic(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable automatic topic creation. If automatic
        topic creation is enabled, a topic will be automatically created with 3 partitions and 3 replicas when a message is
        produced to or consumed from a topic that does not exist.
        The default value is false.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "enable_auto_topic")

    @enable_auto_topic.setter
    def enable_auto_topic(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_auto_topic", value)

    @_builtins.property
    @pulumi.getter(name="enabledMechanisms")
    def enabled_mechanisms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "enabled_mechanisms")

    @enabled_mechanisms.setter
    def enabled_mechanisms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_mechanisms", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID of the Kafka instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Kafka `flavor ID`. This parameter and `product_id` are alternative.

        > It is recommended to use `flavor_id` if the region supports it.\\
        One of:
        * c6.2u4g.cluster
        * c6.4u8g.cluster
        * c6.8u16g.cluster
        * c6.12u24g.cluster
        * c6.16u32g.cluster \\
        Or use data source sbercloud_dms_kafka_flavors
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enable", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time at which a maintenance time window starts. Format: HH:mm. The
        start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
        window. The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
        blank. In this case, the system automatically allocates the default start time 02:00.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_begin", value)

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time at which a maintenance time window ends. Format: HH:mm. The
        start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
        window. The end time is four hours later than the start time. For example, if the start time is 22:00, the end time is
        02:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_end` is left blank, parameter
        `maintain_begin` is also blank. In this case, the system automatically allocates the default end time 06:00.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end", value)

    @_builtins.property
    @pulumi.getter(name="managerPassword")
    @_utilities.deprecated("""Deprecated""")
    def manager_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password for logging in to the Kafka Manager. The
        password must meet the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of
        the following character types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_
        =+\\\\|[{}]:'",<.>/?). Changing this creates a new instance resource.

        > **NOTE:** `manager_user` and `manager_password` are deprecated and will be deleted in future releases
        """
        return pulumi.get(self, "manager_password")

    @manager_password.setter
    def manager_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manager_password", value)

    @_builtins.property
    @pulumi.getter(name="managerUser")
    @_utilities.deprecated("""Deprecated""")
    def manager_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the username for logging in to the Kafka Manager. The username
        consists of 4 to 64 characters and can contain letters, digits, hyphens (-), and underscores (_). Changing this
        creates a new instance resource.
        """
        return pulumi.get(self, "manager_user")

    @manager_user.setter
    def manager_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manager_user", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the DMS Kafka instance. An instance name starts with a letter,
        consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="newTenantIps")
    def new_tenant_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "new_tenant_ips")

    @new_tenant_ips.setter
    def new_tenant_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "new_tenant_ips", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceParameterArgs']]]]:
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password of SASL_SSL user. A password must meet the
        following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following character
        types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
        Changing this creates a new instance resource.

        > **NOTE:** `access_user` and `password` parameters are mandatory when ssl_enable is set to true. These parameters are invalid when ssl_enable is set to false. \\
        > **NOTE:** If `access_user` and `password` are specified, set `ssl_enable = true`, to enable SASL_SSL for a Kafka instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the instance. If `period_unit` is set to *month*
        , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter is
        mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a product ID, which includes bandwidth, partition, broker and default
        storage capacity.

        > **NOTE:** Change this to change the bandwidth, partition and broker of the Kafka instances. Please note that the
        broker changes may cause storage capacity changes. So, if you specify the value of `storage_space`, you need to
        manually modify the value of `storage_space` after changing the `product_id`.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter(name="publicIpIds")
    def public_ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the IDs of the elastic IP address (EIP)
        bound to the DMS Kafka instance. Changing this creates a new instance resource.
        + If the instance is created with `flavor_id`, the total number of public IPs is equal to `broker_num`.
        + If the instance is created with `product_id`, the total number of public IPs must provide as follows:

        | Bandwidth | Total number of public IPs |
        | ---- | ---- |
        | 100MB | 3 |
        | 300MB | 3 |
        | 600MB | 4 |
        | 1,200MB | 8 |
        """
        return pulumi.get(self, "public_ip_ids")

    @public_ip_ids.setter
    def public_ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "public_ip_ids", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the DMS Kafka instances. If omitted, the
        provider-level region will be used. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the action to be taken when the memory usage reaches the disk
        capacity threshold. The valid values are as follows:
        + **time_base**: Automatically delete the earliest messages.
        + **produce_reject**: Stop producing new messages.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_policy", value)

    @_builtins.property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "security_protocol")

    @security_protocol.setter
    def security_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_protocol", value)

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the Kafka SASL_SSL is enabled.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_enable", value)

    @_builtins.property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the message storage capacity, the unit is GB.
        + When bandwidth is 100MB: 600–90000 GB
        + When bandwidth is 300MB: 1200–90000 GB
        + When bandwidth is 600MB: 2400–90000 GB
        + When bandwidth is 1200MB: 4800–90000 GB

        Changing this creates a new instance resource.

        It is required when creating an instance with `flavor_id`.
        """
        return pulumi.get(self, "storage_space")

    @storage_space.setter
    def storage_space(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_space", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the DMS Kafka instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vpcClientPlain")
    def vpc_client_plain(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "vpc_client_plain")

    @vpc_client_plain.setter
    def vpc_client_plain(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vpc_client_plain", value)


@pulumi.input_type
class _KafkaInstanceState:
    def __init__(__self__, *,
                 access_user: Optional[pulumi.Input[_builtins.str]] = None,
                 arch_type: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 broker_num: Optional[pulumi.Input[_builtins.int]] = None,
                 cert_replaced: Optional[pulumi.Input[_builtins.bool]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connect_address: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_id: Optional[pulumi.Input[_builtins.str]] = None,
                 connector_node_num: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_vpc_accesses: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceCrossVpcAccessArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dumping: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_auto_topic: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_mechanisms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 extend_times: Optional[pulumi.Input[_builtins.int]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_connect_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_logical_volume: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 management_connect_address: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_password: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_user: Optional[pulumi.Input[_builtins.str]] = None,
                 manegement_connect_address: Optional[pulumi.Input[_builtins.str]] = None,
                 message_query_inst_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 new_tenant_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 node_num: Optional[pulumi.Input[_builtins.int]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceParameterArgs']]]] = None,
                 partition_num: Optional[pulumi.Input[_builtins.int]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 pod_connect_address: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 port_protocols: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstancePortProtocolArgs']]]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
                 public_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 public_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssl_two_way_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 used_storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_client_plain: Optional[pulumi.Input[_builtins.bool]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KafkaInstance resources.
        :param pulumi.Input[_builtins.str] access_user: Specifies the username of SASL_SSL user. A username consists of 4
               to 64 characters and supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "false".
               
               <a name="dms_cross_vpc_accesses"></a>
               The `cross_vpc_accesses` block supports:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The names of the AZ where the Kafka instances reside.
               The parameter value can not be left blank or an empty array. Changing this creates a new instance resource.
               
               > **NOTE:** Deploy one availability zone or at least three availability zones. Do not select two availability zones.
               Deploy to more availability zones, the better the reliability and SLA coverage.
               
               > The parameter behavior of `availability_zones` has been changed from `list` to `set`.
        :param pulumi.Input[_builtins.int] broker_num: Specifies the broker numbers.
               It is required when creating an instance with `flavor_id`.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the instance. Valid values are *prePaid*
               and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] connect_address: Indicates the IP address of the DMS Kafka instance.
        :param pulumi.Input[Sequence[pulumi.Input['KafkaInstanceCrossVpcAccessArgs']]] cross_vpc_accesses: Specifies the cross-VPC access information.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the DMS Kafka instance. It is a character string
               containing not more than 1,024 characters.
        :param pulumi.Input[_builtins.bool] dumping: Specifies whether to enable message dumping.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.bool] enable_auto_topic: Specifies whether to enable automatic topic creation. If automatic
               topic creation is enabled, a topic will be automatically created with 3 partitions and 3 replicas when a message is
               produced to or consumed from a topic that does not exist.
               The default value is false.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.bool] enable_public_ip: Indicates whether public access to the DMS Kafka instance is enabled.
        :param pulumi.Input[_builtins.str] engine: Indicates the message engine.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the version of the Kafka engine,
               such as 1.1.0, 2.3.0, 2.7 or other supported versions. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID of the Kafka instance.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the Kafka `flavor ID`. This parameter and `product_id` are alternative.
               
               > It is recommended to use `flavor_id` if the region supports it.\\
               One of:
               * c6.2u4g.cluster
               * c6.4u8g.cluster
               * c6.8u16g.cluster
               * c6.12u24g.cluster
               * c6.16u32g.cluster \\
               Or use data source sbercloud_dms_kafka_flavors
        :param pulumi.Input[_builtins.str] kms_encrypted_password: schema: Internal
        :param pulumi.Input[_builtins.str] maintain_begin: Specifies the time at which a maintenance time window starts. Format: HH:mm. The
               start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
               window. The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
               blank. In this case, the system automatically allocates the default start time 02:00.
        :param pulumi.Input[_builtins.str] maintain_end: Specifies the time at which a maintenance time window ends. Format: HH:mm. The
               start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
               window. The end time is four hours later than the start time. For example, if the start time is 22:00, the end time is
               02:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_end` is left blank, parameter
               `maintain_begin` is also blank. In this case, the system automatically allocates the default end time 06:00.
        :param pulumi.Input[_builtins.str] management_connect_address: Indicates the Kafka Manager connection address of a Kafka instance.
        :param pulumi.Input[_builtins.str] manager_password: Specifies the password for logging in to the Kafka Manager. The
               password must meet the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of
               the following character types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_
               =+\\\\|[{}]:'",<.>/?). Changing this creates a new instance resource.
               
               > **NOTE:** `manager_user` and `manager_password` are deprecated and will be deleted in future releases
        :param pulumi.Input[_builtins.str] manager_user: Specifies the username for logging in to the Kafka Manager. The username
               consists of 4 to 64 characters and can contain letters, digits, hyphens (-), and underscores (_). Changing this
               creates a new instance resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the DMS Kafka instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        :param pulumi.Input[_builtins.str] network_id: Specifies the ID of a subnet. Changing this creates a new instance
               resource.
        :param pulumi.Input[_builtins.int] partition_num: Indicates the number of partitions in Kafka instance.
        :param pulumi.Input[_builtins.str] password: Specifies the password of SASL_SSL user. A password must meet the
               following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following character
               types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
               Changing this creates a new instance resource.
               
               > **NOTE:** `access_user` and `password` parameters are mandatory when ssl_enable is set to true. These parameters are invalid when ssl_enable is set to false. \\
               > **NOTE:** If `access_user` and `password` are specified, set `ssl_enable = true`, to enable SASL_SSL for a Kafka instance.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance. If `period_unit` is set to *month*
               , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter is
               mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] port: The port number.
        :param pulumi.Input[_builtins.str] product_id: Specifies a product ID, which includes bandwidth, partition, broker and default
               storage capacity.
               
               > **NOTE:** Change this to change the bandwidth, partition and broker of the Kafka instances. Please note that the
               broker changes may cause storage capacity changes. So, if you specify the value of `storage_space`, you need to
               manually modify the value of `storage_space` after changing the `product_id`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] public_ip_ids: Specifies the IDs of the elastic IP address (EIP)
               bound to the DMS Kafka instance. Changing this creates a new instance resource.
               + If the instance is created with `flavor_id`, the total number of public IPs is equal to `broker_num`.
               + If the instance is created with `product_id`, the total number of public IPs must provide as follows:
               
               | Bandwidth | Total number of public IPs |
               | ---- | ---- |
               | 100MB | 3 |
               | 300MB | 3 |
               | 600MB | 4 |
               | 1,200MB | 8 |
        :param pulumi.Input[_builtins.str] region: The region in which to create the DMS Kafka instances. If omitted, the
               provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] resource_spec_code: Indicates a resource specifications identifier.
        :param pulumi.Input[_builtins.str] retention_policy: Specifies the action to be taken when the memory usage reaches the disk
               capacity threshold. The valid values are as follows:
               + **time_base**: Automatically delete the earliest messages.
               + **produce_reject**: Stop producing new messages.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[_builtins.bool] ssl_enable: Indicates whether the Kafka SASL_SSL is enabled.
        :param pulumi.Input[_builtins.str] status: Indicates the status of the DMS Kafka instance.
        :param pulumi.Input[_builtins.int] storage_space: Specifies the message storage capacity, the unit is GB.
               + When bandwidth is 100MB: 600–90000 GB
               + When bandwidth is 300MB: 1200–90000 GB
               + When bandwidth is 600MB: 2400–90000 GB
               + When bandwidth is 1200MB: 4800–90000 GB
               
               Changing this creates a new instance resource.
               
               It is required when creating an instance with `flavor_id`.
        :param pulumi.Input[_builtins.str] storage_spec_code: Specifies the storage I/O specification. Value range:
               + When bandwidth is 100MB: dms.physical.storage.high or dms.physical.storage.ultra
               + When bandwidth is 300MB: dms.physical.storage.high or dms.physical.storage.ultra
               + When bandwidth is 600MB: dms.physical.storage.ultra
               + When bandwidth is 1200MB: dms.physical.storage.ultra
               
               If the instance is created with `product_id`, the valid values are as follows:
               + **dms.physical.storage.high**: Type of the disk that uses high I/O.
               The corresponding bandwidths are **100MB** and **300MB**.
               + **dms.physical.storage.ultra**: Type of the disk that uses ultra-high I/O.
               The corresponding bandwidths are **100MB**, **300MB**, **600MB** and **1,200MB**.
               
               Changing this creates a new instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the DMS Kafka instance.
        :param pulumi.Input[_builtins.str] type: Indicates the DMS Kafka instance type.
        :param pulumi.Input[_builtins.int] used_storage_space: Indicates the used message storage space. Unit: GB
        :param pulumi.Input[_builtins.str] user_id: Indicates the ID of the user who created the DMS Kafka instance
        :param pulumi.Input[_builtins.str] user_name: Indicates the name of the user who created the DMS Kafka instance
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        if access_user is not None:
            pulumi.set(__self__, "access_user", access_user)
        if arch_type is not None:
            pulumi.set(__self__, "arch_type", arch_type)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_zones is not None:
            warnings.warn("""available_zones has deprecated, please use \"availability_zones\" instead.""", DeprecationWarning)
            pulumi.log.warn("""available_zones is deprecated: available_zones has deprecated, please use \"availability_zones\" instead.""")
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if bandwidth is not None:
            warnings.warn("""The bandwidth has been deprecated. If you need to change the bandwidth, please update the product_id.""", DeprecationWarning)
            pulumi.log.warn("""bandwidth is deprecated: The bandwidth has been deprecated. If you need to change the bandwidth, please update the product_id.""")
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if broker_num is not None:
            pulumi.set(__self__, "broker_num", broker_num)
        if cert_replaced is not None:
            pulumi.set(__self__, "cert_replaced", cert_replaced)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if connect_address is not None:
            pulumi.set(__self__, "connect_address", connect_address)
        if connector_id is not None:
            pulumi.set(__self__, "connector_id", connector_id)
        if connector_node_num is not None:
            pulumi.set(__self__, "connector_node_num", connector_node_num)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if cross_vpc_accesses is not None:
            pulumi.set(__self__, "cross_vpc_accesses", cross_vpc_accesses)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dumping is not None:
            pulumi.set(__self__, "dumping", dumping)
        if enable_auto_topic is not None:
            pulumi.set(__self__, "enable_auto_topic", enable_auto_topic)
        if enable_public_ip is not None:
            pulumi.set(__self__, "enable_public_ip", enable_public_ip)
        if enabled_mechanisms is not None:
            pulumi.set(__self__, "enabled_mechanisms", enabled_mechanisms)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if extend_times is not None:
            pulumi.set(__self__, "extend_times", extend_times)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if ipv6_connect_addresses is not None:
            pulumi.set(__self__, "ipv6_connect_addresses", ipv6_connect_addresses)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if is_logical_volume is not None:
            pulumi.set(__self__, "is_logical_volume", is_logical_volume)
        if kms_encrypted_password is not None:
            pulumi.set(__self__, "kms_encrypted_password", kms_encrypted_password)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if management_connect_address is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""management_connect_address is deprecated: Deprecated""")
        if management_connect_address is not None:
            pulumi.set(__self__, "management_connect_address", management_connect_address)
        if manager_password is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""manager_password is deprecated: Deprecated""")
        if manager_password is not None:
            pulumi.set(__self__, "manager_password", manager_password)
        if manager_user is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""manager_user is deprecated: Deprecated""")
        if manager_user is not None:
            pulumi.set(__self__, "manager_user", manager_user)
        if manegement_connect_address is not None:
            warnings.warn("""typo in manegement_connect_address, please use \"management_connect_address\" instead.""", DeprecationWarning)
            pulumi.log.warn("""manegement_connect_address is deprecated: typo in manegement_connect_address, please use \"management_connect_address\" instead.""")
        if manegement_connect_address is not None:
            pulumi.set(__self__, "manegement_connect_address", manegement_connect_address)
        if message_query_inst_enable is not None:
            pulumi.set(__self__, "message_query_inst_enable", message_query_inst_enable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if new_tenant_ips is not None:
            pulumi.set(__self__, "new_tenant_ips", new_tenant_ips)
        if node_num is not None:
            pulumi.set(__self__, "node_num", node_num)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if partition_num is not None:
            pulumi.set(__self__, "partition_num", partition_num)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if pod_connect_address is not None:
            pulumi.set(__self__, "pod_connect_address", pod_connect_address)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_protocols is not None:
            pulumi.set(__self__, "port_protocols", port_protocols)
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if public_bandwidth is not None:
            pulumi.set(__self__, "public_bandwidth", public_bandwidth)
        if public_ip_addresses is not None:
            pulumi.set(__self__, "public_ip_addresses", public_ip_addresses)
        if public_ip_ids is not None:
            pulumi.set(__self__, "public_ip_ids", public_ip_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_spec_code is not None:
            pulumi.set(__self__, "resource_spec_code", resource_spec_code)
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_protocol is not None:
            pulumi.set(__self__, "security_protocol", security_protocol)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if ssl_two_way_enable is not None:
            pulumi.set(__self__, "ssl_two_way_enable", ssl_two_way_enable)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_resource_id is not None:
            pulumi.set(__self__, "storage_resource_id", storage_resource_id)
        if storage_space is not None:
            pulumi.set(__self__, "storage_space", storage_space)
        if storage_spec_code is not None:
            pulumi.set(__self__, "storage_spec_code", storage_spec_code)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if used_storage_space is not None:
            pulumi.set(__self__, "used_storage_space", used_storage_space)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if vpc_client_plain is not None:
            pulumi.set(__self__, "vpc_client_plain", vpc_client_plain)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the username of SASL_SSL user. A username consists of 4
        to 64 characters and supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        """
        return pulumi.get(self, "access_user")

    @access_user.setter
    def access_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_user", value)

    @_builtins.property
    @pulumi.getter(name="archType")
    def arch_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "arch_type")

    @arch_type.setter
    def arch_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "arch_type", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "false".

        <a name="dms_cross_vpc_accesses"></a>
        The `cross_vpc_accesses` block supports:
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The names of the AZ where the Kafka instances reside.
        The parameter value can not be left blank or an empty array. Changing this creates a new instance resource.

        > **NOTE:** Deploy one availability zone or at least three availability zones. Do not select two availability zones.
        Deploy to more availability zones, the better the reliability and SLA coverage.

        > The parameter behavior of `availability_zones` has been changed from `list` to `set`.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="availableZones")
    @_utilities.deprecated("""available_zones has deprecated, please use \"availability_zones\" instead.""")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "available_zones", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The bandwidth has been deprecated. If you need to change the bandwidth, please update the product_id.""")
    def bandwidth(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="brokerNum")
    def broker_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the broker numbers.
        It is required when creating an instance with `flavor_id`.
        """
        return pulumi.get(self, "broker_num")

    @broker_num.setter
    def broker_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "broker_num", value)

    @_builtins.property
    @pulumi.getter(name="certReplaced")
    def cert_replaced(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "cert_replaced")

    @cert_replaced.setter
    def cert_replaced(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "cert_replaced", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the instance. Valid values are *prePaid*
        and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="connectAddress")
    def connect_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the IP address of the DMS Kafka instance.
        """
        return pulumi.get(self, "connect_address")

    @connect_address.setter
    def connect_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connect_address", value)

    @_builtins.property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "connector_id")

    @connector_id.setter
    def connector_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connector_id", value)

    @_builtins.property
    @pulumi.getter(name="connectorNodeNum")
    def connector_node_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "connector_node_num")

    @connector_node_num.setter
    def connector_node_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "connector_node_num", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="crossVpcAccesses")
    def cross_vpc_accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceCrossVpcAccessArgs']]]]:
        """
        Specifies the cross-VPC access information.
        The object structure is documented below.
        """
        return pulumi.get(self, "cross_vpc_accesses")

    @cross_vpc_accesses.setter
    def cross_vpc_accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceCrossVpcAccessArgs']]]]):
        pulumi.set(self, "cross_vpc_accesses", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the DMS Kafka instance. It is a character string
        containing not more than 1,024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def dumping(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable message dumping.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "dumping")

    @dumping.setter
    def dumping(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dumping", value)

    @_builtins.property
    @pulumi.getter(name="enableAutoTopic")
    def enable_auto_topic(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable automatic topic creation. If automatic
        topic creation is enabled, a topic will be automatically created with 3 partitions and 3 replicas when a message is
        produced to or consumed from a topic that does not exist.
        The default value is false.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "enable_auto_topic")

    @enable_auto_topic.setter
    def enable_auto_topic(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_auto_topic", value)

    @_builtins.property
    @pulumi.getter(name="enablePublicIp")
    def enable_public_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether public access to the DMS Kafka instance is enabled.
        """
        return pulumi.get(self, "enable_public_ip")

    @enable_public_ip.setter
    def enable_public_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_public_ip", value)

    @_builtins.property
    @pulumi.getter(name="enabledMechanisms")
    def enabled_mechanisms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "enabled_mechanisms")

    @enabled_mechanisms.setter
    def enabled_mechanisms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "enabled_mechanisms", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the message engine.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of the Kafka engine,
        such as 1.1.0, 2.3.0, 2.7 or other supported versions. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID of the Kafka instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="extendTimes")
    def extend_times(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "extend_times")

    @extend_times.setter
    def extend_times(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "extend_times", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Kafka `flavor ID`. This parameter and `product_id` are alternative.

        > It is recommended to use `flavor_id` if the region supports it.\\
        One of:
        * c6.2u4g.cluster
        * c6.4u8g.cluster
        * c6.8u16g.cluster
        * c6.12u24g.cluster
        * c6.16u32g.cluster \\
        Or use data source sbercloud_dms_kafka_flavors
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6ConnectAddresses")
    def ipv6_connect_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "ipv6_connect_addresses")

    @ipv6_connect_addresses.setter
    def ipv6_connect_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ipv6_connect_addresses", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enable", value)

    @_builtins.property
    @pulumi.getter(name="isLogicalVolume")
    def is_logical_volume(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_logical_volume")

    @is_logical_volume.setter
    def is_logical_volume(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_logical_volume", value)

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "kms_encrypted_password")

    @kms_encrypted_password.setter
    def kms_encrypted_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_encrypted_password", value)

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time at which a maintenance time window starts. Format: HH:mm. The
        start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
        window. The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
        blank. In this case, the system automatically allocates the default start time 02:00.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_begin", value)

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time at which a maintenance time window ends. Format: HH:mm. The
        start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
        window. The end time is four hours later than the start time. For example, if the start time is 22:00, the end time is
        02:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_end` is left blank, parameter
        `maintain_begin` is also blank. In this case, the system automatically allocates the default end time 06:00.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end", value)

    @_builtins.property
    @pulumi.getter(name="managementConnectAddress")
    @_utilities.deprecated("""Deprecated""")
    def management_connect_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the Kafka Manager connection address of a Kafka instance.
        """
        return pulumi.get(self, "management_connect_address")

    @management_connect_address.setter
    def management_connect_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_connect_address", value)

    @_builtins.property
    @pulumi.getter(name="managerPassword")
    @_utilities.deprecated("""Deprecated""")
    def manager_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password for logging in to the Kafka Manager. The
        password must meet the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of
        the following character types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_
        =+\\\\|[{}]:'",<.>/?). Changing this creates a new instance resource.

        > **NOTE:** `manager_user` and `manager_password` are deprecated and will be deleted in future releases
        """
        return pulumi.get(self, "manager_password")

    @manager_password.setter
    def manager_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manager_password", value)

    @_builtins.property
    @pulumi.getter(name="managerUser")
    @_utilities.deprecated("""Deprecated""")
    def manager_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the username for logging in to the Kafka Manager. The username
        consists of 4 to 64 characters and can contain letters, digits, hyphens (-), and underscores (_). Changing this
        creates a new instance resource.
        """
        return pulumi.get(self, "manager_user")

    @manager_user.setter
    def manager_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manager_user", value)

    @_builtins.property
    @pulumi.getter(name="manegementConnectAddress")
    @_utilities.deprecated("""typo in manegement_connect_address, please use \"management_connect_address\" instead.""")
    def manegement_connect_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "manegement_connect_address")

    @manegement_connect_address.setter
    def manegement_connect_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manegement_connect_address", value)

    @_builtins.property
    @pulumi.getter(name="messageQueryInstEnable")
    def message_query_inst_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "message_query_inst_enable")

    @message_query_inst_enable.setter
    def message_query_inst_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "message_query_inst_enable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the DMS Kafka instance. An instance name starts with a letter,
        consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a subnet. Changing this creates a new instance
        resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="newTenantIps")
    def new_tenant_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "new_tenant_ips")

    @new_tenant_ips.setter
    def new_tenant_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "new_tenant_ips", value)

    @_builtins.property
    @pulumi.getter(name="nodeNum")
    def node_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "node_num")

    @node_num.setter
    def node_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_num", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceParameterArgs']]]]:
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="partitionNum")
    def partition_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the number of partitions in Kafka instance.
        """
        return pulumi.get(self, "partition_num")

    @partition_num.setter
    def partition_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "partition_num", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password of SASL_SSL user. A password must meet the
        following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following character
        types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
        Changing this creates a new instance resource.

        > **NOTE:** `access_user` and `password` parameters are mandatory when ssl_enable is set to true. These parameters are invalid when ssl_enable is set to false. \\
        > **NOTE:** If `access_user` and `password` are specified, set `ssl_enable = true`, to enable SASL_SSL for a Kafka instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the instance. If `period_unit` is set to *month*
        , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter is
        mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="podConnectAddress")
    def pod_connect_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "pod_connect_address")

    @pod_connect_address.setter
    def pod_connect_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pod_connect_address", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The port number.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="portProtocols")
    def port_protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstancePortProtocolArgs']]]]:
        return pulumi.get(self, "port_protocols")

    @port_protocols.setter
    def port_protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaInstancePortProtocolArgs']]]]):
        pulumi.set(self, "port_protocols", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a product ID, which includes bandwidth, partition, broker and default
        storage capacity.

        > **NOTE:** Change this to change the bandwidth, partition and broker of the Kafka instances. Please note that the
        broker changes may cause storage capacity changes. So, if you specify the value of `storage_space`, you need to
        manually modify the value of `storage_space` after changing the `product_id`.
        """
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter(name="publicBandwidth")
    def public_bandwidth(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "public_bandwidth")

    @public_bandwidth.setter
    def public_bandwidth(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "public_bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "public_ip_addresses")

    @public_ip_addresses.setter
    def public_ip_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "public_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="publicIpIds")
    def public_ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the IDs of the elastic IP address (EIP)
        bound to the DMS Kafka instance. Changing this creates a new instance resource.
        + If the instance is created with `flavor_id`, the total number of public IPs is equal to `broker_num`.
        + If the instance is created with `product_id`, the total number of public IPs must provide as follows:

        | Bandwidth | Total number of public IPs |
        | ---- | ---- |
        | 100MB | 3 |
        | 300MB | 3 |
        | 600MB | 4 |
        | 1,200MB | 8 |
        """
        return pulumi.get(self, "public_ip_ids")

    @public_ip_ids.setter
    def public_ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "public_ip_ids", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the DMS Kafka instances. If omitted, the
        provider-level region will be used. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceSpecCode")
    def resource_spec_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates a resource specifications identifier.
        """
        return pulumi.get(self, "resource_spec_code")

    @resource_spec_code.setter
    def resource_spec_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_spec_code", value)

    @_builtins.property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the action to be taken when the memory usage reaches the disk
        capacity threshold. The valid values are as follows:
        + **time_base**: Automatically delete the earliest messages.
        + **produce_reject**: Stop producing new messages.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "retention_policy", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "security_protocol")

    @security_protocol.setter
    def security_protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_protocol", value)

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether the Kafka SASL_SSL is enabled.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_enable", value)

    @_builtins.property
    @pulumi.getter(name="sslTwoWayEnable")
    def ssl_two_way_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "ssl_two_way_enable")

    @ssl_two_way_enable.setter
    def ssl_two_way_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_two_way_enable", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the status of the DMS Kafka instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageResourceId")
    def storage_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "storage_resource_id")

    @storage_resource_id.setter
    def storage_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the message storage capacity, the unit is GB.
        + When bandwidth is 100MB: 600–90000 GB
        + When bandwidth is 300MB: 1200–90000 GB
        + When bandwidth is 600MB: 2400–90000 GB
        + When bandwidth is 1200MB: 4800–90000 GB

        Changing this creates a new instance resource.

        It is required when creating an instance with `flavor_id`.
        """
        return pulumi.get(self, "storage_space")

    @storage_space.setter
    def storage_space(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_space", value)

    @_builtins.property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the storage I/O specification. Value range:
        + When bandwidth is 100MB: dms.physical.storage.high or dms.physical.storage.ultra
        + When bandwidth is 300MB: dms.physical.storage.high or dms.physical.storage.ultra
        + When bandwidth is 600MB: dms.physical.storage.ultra
        + When bandwidth is 1200MB: dms.physical.storage.ultra

        If the instance is created with `product_id`, the valid values are as follows:
        + **dms.physical.storage.high**: Type of the disk that uses high I/O.
        The corresponding bandwidths are **100MB** and **300MB**.
        + **dms.physical.storage.ultra**: Type of the disk that uses ultra-high I/O.
        The corresponding bandwidths are **100MB**, **300MB**, **600MB** and **1,200MB**.

        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "storage_spec_code")

    @storage_spec_code.setter
    def storage_spec_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_spec_code", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the DMS Kafka instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the DMS Kafka instance type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="usedStorageSpace")
    def used_storage_space(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the used message storage space. Unit: GB
        """
        return pulumi.get(self, "used_storage_space")

    @used_storage_space.setter
    def used_storage_space(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used_storage_space", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the ID of the user who created the DMS Kafka instance
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the name of the user who created the DMS Kafka instance
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcClientPlain")
    def vpc_client_plain(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "vpc_client_plain")

    @vpc_client_plain.setter
    def vpc_client_plain(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vpc_client_plain", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:Dms/kafkaInstance:KafkaInstance")
class KafkaInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_user: Optional[pulumi.Input[_builtins.str]] = None,
                 arch_type: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 broker_num: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_vpc_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaInstanceCrossVpcAccessArgs', 'KafkaInstanceCrossVpcAccessArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dumping: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_auto_topic: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_mechanisms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_password: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_user: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 new_tenant_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaInstanceParameterArgs', 'KafkaInstanceParameterArgsDict']]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_client_plain: Optional[pulumi.Input[_builtins.bool]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage DMS Kafka instance resources within SberCloud.

        ## Example Usage

        ### Create a Kafka instance using flavor ID

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        security_group_id = config.require_object("securityGroupId")
        availability_zones = config.get_object("availabilityZones")
        if availability_zones is None:
            availability_zones = [
                "your_availability_zones_a",
                "your_availability_zones_b",
                "your_availability_zones_c",
            ]
        flavor_id = config.get("flavorId")
        if flavor_id is None:
            flavor_id = "your_flavor_id, such: c6.2u4g.cluster"
        storage_spec_code = config.get("storageSpecCode")
        if storage_spec_code is None:
            storage_spec_code = "your_storage_spec_code, such: dms.physical.storage.ultra.v2"
        test = sbercloud.Dms.get_flavors(type="cluster",
            flavor_id=flavor_id,
            availability_zones=availability_zones,
            storage_spec_code=storage_spec_code)
        test_kafka_instance = sbercloud.dms.KafkaInstance("test",
            name="kafka_test",
            vpc_id=vpc_id,
            network_id=subnet_id,
            security_group_id=security_group_id,
            flavor_id=flavor_id,
            storage_spec_code=storage_spec_code,
            availability_zones=availability_zones,
            engine_version="2.7",
            storage_space=600,
            broker_num=3,
            access_user="user",
            password="Kafka_%^&_Test",
            manager_user="kafka_manager",
            manager_password="Kafka_Test^&*(",
            opts = pulumi.ResourceOptions(depends_on=[test]))
        ```

        > **Why depend on "data.sbercloud_dms_kafka_flavors.test", it is not used?**
        The specified `flavor_id` and `storage_spec_code` are not valid in all regions.
        Before creating kafka, verify their validity through datasource to avoid creation errors.

        ## Import

        DMS Kafka instance can be imported using the instance id, e.g.

        ```sh
        $ pulumi import sbercloud:Dms/kafkaInstance:KafkaInstance  sbercloud_dms_kafka_instance.instance_1 8d3c7938-dc47-4937-a30f-c80de381c5e3
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include:

        `password`, `manager_password` and `public_ip_ids`. It is generally recommended running `pulumi preview` after importing

        a DMS Kafka instance. You can then decide if changes should be applied to the instance, or the resource definition

        should be updated to align with the instance. Also you can ignore changes as below.

        resource "sbercloud_dms_kafka_instance" "instance_1" {

            ...

          lifecycle {

            ignore_changes = [
            
              password, manager_password,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_user: Specifies the username of SASL_SSL user. A username consists of 4
               to 64 characters and supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "false".
               
               <a name="dms_cross_vpc_accesses"></a>
               The `cross_vpc_accesses` block supports:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The names of the AZ where the Kafka instances reside.
               The parameter value can not be left blank or an empty array. Changing this creates a new instance resource.
               
               > **NOTE:** Deploy one availability zone or at least three availability zones. Do not select two availability zones.
               Deploy to more availability zones, the better the reliability and SLA coverage.
               
               > The parameter behavior of `availability_zones` has been changed from `list` to `set`.
        :param pulumi.Input[_builtins.int] broker_num: Specifies the broker numbers.
               It is required when creating an instance with `flavor_id`.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the instance. Valid values are *prePaid*
               and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KafkaInstanceCrossVpcAccessArgs', 'KafkaInstanceCrossVpcAccessArgsDict']]]] cross_vpc_accesses: Specifies the cross-VPC access information.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the DMS Kafka instance. It is a character string
               containing not more than 1,024 characters.
        :param pulumi.Input[_builtins.bool] dumping: Specifies whether to enable message dumping.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.bool] enable_auto_topic: Specifies whether to enable automatic topic creation. If automatic
               topic creation is enabled, a topic will be automatically created with 3 partitions and 3 replicas when a message is
               produced to or consumed from a topic that does not exist.
               The default value is false.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the version of the Kafka engine,
               such as 1.1.0, 2.3.0, 2.7 or other supported versions. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID of the Kafka instance.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the Kafka `flavor ID`. This parameter and `product_id` are alternative.
               
               > It is recommended to use `flavor_id` if the region supports it.\\
               One of:
               * c6.2u4g.cluster
               * c6.4u8g.cluster
               * c6.8u16g.cluster
               * c6.12u24g.cluster
               * c6.16u32g.cluster \\
               Or use data source sbercloud_dms_kafka_flavors
        :param pulumi.Input[_builtins.str] kms_encrypted_password: schema: Internal
        :param pulumi.Input[_builtins.str] maintain_begin: Specifies the time at which a maintenance time window starts. Format: HH:mm. The
               start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
               window. The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
               blank. In this case, the system automatically allocates the default start time 02:00.
        :param pulumi.Input[_builtins.str] maintain_end: Specifies the time at which a maintenance time window ends. Format: HH:mm. The
               start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
               window. The end time is four hours later than the start time. For example, if the start time is 22:00, the end time is
               02:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_end` is left blank, parameter
               `maintain_begin` is also blank. In this case, the system automatically allocates the default end time 06:00.
        :param pulumi.Input[_builtins.str] manager_password: Specifies the password for logging in to the Kafka Manager. The
               password must meet the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of
               the following character types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_
               =+\\\\|[{}]:'",<.>/?). Changing this creates a new instance resource.
               
               > **NOTE:** `manager_user` and `manager_password` are deprecated and will be deleted in future releases
        :param pulumi.Input[_builtins.str] manager_user: Specifies the username for logging in to the Kafka Manager. The username
               consists of 4 to 64 characters and can contain letters, digits, hyphens (-), and underscores (_). Changing this
               creates a new instance resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the DMS Kafka instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        :param pulumi.Input[_builtins.str] network_id: Specifies the ID of a subnet. Changing this creates a new instance
               resource.
        :param pulumi.Input[_builtins.str] password: Specifies the password of SASL_SSL user. A password must meet the
               following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following character
               types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
               Changing this creates a new instance resource.
               
               > **NOTE:** `access_user` and `password` parameters are mandatory when ssl_enable is set to true. These parameters are invalid when ssl_enable is set to false. \\
               > **NOTE:** If `access_user` and `password` are specified, set `ssl_enable = true`, to enable SASL_SSL for a Kafka instance.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance. If `period_unit` is set to *month*
               , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter is
               mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] product_id: Specifies a product ID, which includes bandwidth, partition, broker and default
               storage capacity.
               
               > **NOTE:** Change this to change the bandwidth, partition and broker of the Kafka instances. Please note that the
               broker changes may cause storage capacity changes. So, if you specify the value of `storage_space`, you need to
               manually modify the value of `storage_space` after changing the `product_id`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] public_ip_ids: Specifies the IDs of the elastic IP address (EIP)
               bound to the DMS Kafka instance. Changing this creates a new instance resource.
               + If the instance is created with `flavor_id`, the total number of public IPs is equal to `broker_num`.
               + If the instance is created with `product_id`, the total number of public IPs must provide as follows:
               
               | Bandwidth | Total number of public IPs |
               | ---- | ---- |
               | 100MB | 3 |
               | 300MB | 3 |
               | 600MB | 4 |
               | 1,200MB | 8 |
        :param pulumi.Input[_builtins.str] region: The region in which to create the DMS Kafka instances. If omitted, the
               provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] retention_policy: Specifies the action to be taken when the memory usage reaches the disk
               capacity threshold. The valid values are as follows:
               + **time_base**: Automatically delete the earliest messages.
               + **produce_reject**: Stop producing new messages.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[_builtins.bool] ssl_enable: Indicates whether the Kafka SASL_SSL is enabled.
        :param pulumi.Input[_builtins.int] storage_space: Specifies the message storage capacity, the unit is GB.
               + When bandwidth is 100MB: 600–90000 GB
               + When bandwidth is 300MB: 1200–90000 GB
               + When bandwidth is 600MB: 2400–90000 GB
               + When bandwidth is 1200MB: 4800–90000 GB
               
               Changing this creates a new instance resource.
               
               It is required when creating an instance with `flavor_id`.
        :param pulumi.Input[_builtins.str] storage_spec_code: Specifies the storage I/O specification. Value range:
               + When bandwidth is 100MB: dms.physical.storage.high or dms.physical.storage.ultra
               + When bandwidth is 300MB: dms.physical.storage.high or dms.physical.storage.ultra
               + When bandwidth is 600MB: dms.physical.storage.ultra
               + When bandwidth is 1200MB: dms.physical.storage.ultra
               
               If the instance is created with `product_id`, the valid values are as follows:
               + **dms.physical.storage.high**: Type of the disk that uses high I/O.
               The corresponding bandwidths are **100MB** and **300MB**.
               + **dms.physical.storage.ultra**: Type of the disk that uses ultra-high I/O.
               The corresponding bandwidths are **100MB**, **300MB**, **600MB** and **1,200MB**.
               
               Changing this creates a new instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the DMS Kafka instance.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage DMS Kafka instance resources within SberCloud.

        ## Example Usage

        ### Create a Kafka instance using flavor ID

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        security_group_id = config.require_object("securityGroupId")
        availability_zones = config.get_object("availabilityZones")
        if availability_zones is None:
            availability_zones = [
                "your_availability_zones_a",
                "your_availability_zones_b",
                "your_availability_zones_c",
            ]
        flavor_id = config.get("flavorId")
        if flavor_id is None:
            flavor_id = "your_flavor_id, such: c6.2u4g.cluster"
        storage_spec_code = config.get("storageSpecCode")
        if storage_spec_code is None:
            storage_spec_code = "your_storage_spec_code, such: dms.physical.storage.ultra.v2"
        test = sbercloud.Dms.get_flavors(type="cluster",
            flavor_id=flavor_id,
            availability_zones=availability_zones,
            storage_spec_code=storage_spec_code)
        test_kafka_instance = sbercloud.dms.KafkaInstance("test",
            name="kafka_test",
            vpc_id=vpc_id,
            network_id=subnet_id,
            security_group_id=security_group_id,
            flavor_id=flavor_id,
            storage_spec_code=storage_spec_code,
            availability_zones=availability_zones,
            engine_version="2.7",
            storage_space=600,
            broker_num=3,
            access_user="user",
            password="Kafka_%^&_Test",
            manager_user="kafka_manager",
            manager_password="Kafka_Test^&*(",
            opts = pulumi.ResourceOptions(depends_on=[test]))
        ```

        > **Why depend on "data.sbercloud_dms_kafka_flavors.test", it is not used?**
        The specified `flavor_id` and `storage_spec_code` are not valid in all regions.
        Before creating kafka, verify their validity through datasource to avoid creation errors.

        ## Import

        DMS Kafka instance can be imported using the instance id, e.g.

        ```sh
        $ pulumi import sbercloud:Dms/kafkaInstance:KafkaInstance  sbercloud_dms_kafka_instance.instance_1 8d3c7938-dc47-4937-a30f-c80de381c5e3
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include:

        `password`, `manager_password` and `public_ip_ids`. It is generally recommended running `pulumi preview` after importing

        a DMS Kafka instance. You can then decide if changes should be applied to the instance, or the resource definition

        should be updated to align with the instance. Also you can ignore changes as below.

        resource "sbercloud_dms_kafka_instance" "instance_1" {

            ...

          lifecycle {

            ignore_changes = [
            
              password, manager_password,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param KafkaInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_user: Optional[pulumi.Input[_builtins.str]] = None,
                 arch_type: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
                 broker_num: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 cross_vpc_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaInstanceCrossVpcAccessArgs', 'KafkaInstanceCrossVpcAccessArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dumping: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_auto_topic: Optional[pulumi.Input[_builtins.bool]] = None,
                 enabled_mechanisms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_password: Optional[pulumi.Input[_builtins.str]] = None,
                 manager_user: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 new_tenant_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaInstanceParameterArgs', 'KafkaInstanceParameterArgsDict']]]]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_client_plain: Optional[pulumi.Input[_builtins.bool]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaInstanceArgs.__new__(KafkaInstanceArgs)

            __props__.__dict__["access_user"] = access_user
            __props__.__dict__["arch_type"] = arch_type
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["available_zones"] = available_zones
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["broker_num"] = broker_num
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["cross_vpc_accesses"] = cross_vpc_accesses
            __props__.__dict__["description"] = description
            __props__.__dict__["dumping"] = dumping
            __props__.__dict__["enable_auto_topic"] = enable_auto_topic
            __props__.__dict__["enabled_mechanisms"] = enabled_mechanisms
            if engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'engine_version'")
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["flavor_id"] = flavor_id
            __props__.__dict__["ipv6_enable"] = ipv6_enable
            __props__.__dict__["kms_encrypted_password"] = None if kms_encrypted_password is None else pulumi.Output.secret(kms_encrypted_password)
            __props__.__dict__["maintain_begin"] = maintain_begin
            __props__.__dict__["maintain_end"] = maintain_end
            __props__.__dict__["manager_password"] = None if manager_password is None else pulumi.Output.secret(manager_password)
            __props__.__dict__["manager_user"] = manager_user
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["new_tenant_ips"] = new_tenant_ips
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["public_ip_ids"] = public_ip_ids
            __props__.__dict__["region"] = region
            __props__.__dict__["retention_policy"] = retention_policy
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["security_protocol"] = security_protocol
            __props__.__dict__["ssl_enable"] = ssl_enable
            __props__.__dict__["storage_space"] = storage_space
            if storage_spec_code is None and not opts.urn:
                raise TypeError("Missing required property 'storage_spec_code'")
            __props__.__dict__["storage_spec_code"] = storage_spec_code
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_client_plain"] = vpc_client_plain
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["cert_replaced"] = None
            __props__.__dict__["connect_address"] = None
            __props__.__dict__["connector_id"] = None
            __props__.__dict__["connector_node_num"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["enable_public_ip"] = None
            __props__.__dict__["engine"] = None
            __props__.__dict__["extend_times"] = None
            __props__.__dict__["ipv6_connect_addresses"] = None
            __props__.__dict__["is_logical_volume"] = None
            __props__.__dict__["management_connect_address"] = None
            __props__.__dict__["manegement_connect_address"] = None
            __props__.__dict__["message_query_inst_enable"] = None
            __props__.__dict__["node_num"] = None
            __props__.__dict__["partition_num"] = None
            __props__.__dict__["pod_connect_address"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["port_protocols"] = None
            __props__.__dict__["public_bandwidth"] = None
            __props__.__dict__["public_ip_addresses"] = None
            __props__.__dict__["resource_spec_code"] = None
            __props__.__dict__["ssl_two_way_enable"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["storage_resource_id"] = None
            __props__.__dict__["storage_type"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["used_storage_space"] = None
            __props__.__dict__["user_id"] = None
            __props__.__dict__["user_name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["kmsEncryptedPassword", "managerPassword", "password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(KafkaInstance, __self__).__init__(
            'sbercloud:Dms/kafkaInstance:KafkaInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_user: Optional[pulumi.Input[_builtins.str]] = None,
            arch_type: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            bandwidth: Optional[pulumi.Input[_builtins.str]] = None,
            broker_num: Optional[pulumi.Input[_builtins.int]] = None,
            cert_replaced: Optional[pulumi.Input[_builtins.bool]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            connect_address: Optional[pulumi.Input[_builtins.str]] = None,
            connector_id: Optional[pulumi.Input[_builtins.str]] = None,
            connector_node_num: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            cross_vpc_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaInstanceCrossVpcAccessArgs', 'KafkaInstanceCrossVpcAccessArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dumping: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_auto_topic: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
            enabled_mechanisms: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            extend_times: Optional[pulumi.Input[_builtins.int]] = None,
            flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_connect_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            is_logical_volume: Optional[pulumi.Input[_builtins.bool]] = None,
            kms_encrypted_password: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
            management_connect_address: Optional[pulumi.Input[_builtins.str]] = None,
            manager_password: Optional[pulumi.Input[_builtins.str]] = None,
            manager_user: Optional[pulumi.Input[_builtins.str]] = None,
            manegement_connect_address: Optional[pulumi.Input[_builtins.str]] = None,
            message_query_inst_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            new_tenant_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            node_num: Optional[pulumi.Input[_builtins.int]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaInstanceParameterArgs', 'KafkaInstanceParameterArgsDict']]]]] = None,
            partition_num: Optional[pulumi.Input[_builtins.int]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            pod_connect_address: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            port_protocols: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaInstancePortProtocolArgs', 'KafkaInstancePortProtocolArgsDict']]]]] = None,
            product_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_bandwidth: Optional[pulumi.Input[_builtins.int]] = None,
            public_ip_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            public_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
            retention_policy: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_protocol: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            ssl_two_way_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage_space: Optional[pulumi.Input[_builtins.int]] = None,
            storage_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
            storage_type: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            used_storage_space: Optional[pulumi.Input[_builtins.int]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_client_plain: Optional[pulumi.Input[_builtins.bool]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'KafkaInstance':
        """
        Get an existing KafkaInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_user: Specifies the username of SASL_SSL user. A username consists of 4
               to 64 characters and supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "false".
               
               <a name="dms_cross_vpc_accesses"></a>
               The `cross_vpc_accesses` block supports:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: The names of the AZ where the Kafka instances reside.
               The parameter value can not be left blank or an empty array. Changing this creates a new instance resource.
               
               > **NOTE:** Deploy one availability zone or at least three availability zones. Do not select two availability zones.
               Deploy to more availability zones, the better the reliability and SLA coverage.
               
               > The parameter behavior of `availability_zones` has been changed from `list` to `set`.
        :param pulumi.Input[_builtins.int] broker_num: Specifies the broker numbers.
               It is required when creating an instance with `flavor_id`.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the instance. Valid values are *prePaid*
               and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] connect_address: Indicates the IP address of the DMS Kafka instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['KafkaInstanceCrossVpcAccessArgs', 'KafkaInstanceCrossVpcAccessArgsDict']]]] cross_vpc_accesses: Specifies the cross-VPC access information.
               The object structure is documented below.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the DMS Kafka instance. It is a character string
               containing not more than 1,024 characters.
        :param pulumi.Input[_builtins.bool] dumping: Specifies whether to enable message dumping.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.bool] enable_auto_topic: Specifies whether to enable automatic topic creation. If automatic
               topic creation is enabled, a topic will be automatically created with 3 partitions and 3 replicas when a message is
               produced to or consumed from a topic that does not exist.
               The default value is false.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.bool] enable_public_ip: Indicates whether public access to the DMS Kafka instance is enabled.
        :param pulumi.Input[_builtins.str] engine: Indicates the message engine.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the version of the Kafka engine,
               such as 1.1.0, 2.3.0, 2.7 or other supported versions. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID of the Kafka instance.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the Kafka `flavor ID`. This parameter and `product_id` are alternative.
               
               > It is recommended to use `flavor_id` if the region supports it.\\
               One of:
               * c6.2u4g.cluster
               * c6.4u8g.cluster
               * c6.8u16g.cluster
               * c6.12u24g.cluster
               * c6.16u32g.cluster \\
               Or use data source sbercloud_dms_kafka_flavors
        :param pulumi.Input[_builtins.str] kms_encrypted_password: schema: Internal
        :param pulumi.Input[_builtins.str] maintain_begin: Specifies the time at which a maintenance time window starts. Format: HH:mm. The
               start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
               window. The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
               blank. In this case, the system automatically allocates the default start time 02:00.
        :param pulumi.Input[_builtins.str] maintain_end: Specifies the time at which a maintenance time window ends. Format: HH:mm. The
               start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
               window. The end time is four hours later than the start time. For example, if the start time is 22:00, the end time is
               02:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_end` is left blank, parameter
               `maintain_begin` is also blank. In this case, the system automatically allocates the default end time 06:00.
        :param pulumi.Input[_builtins.str] management_connect_address: Indicates the Kafka Manager connection address of a Kafka instance.
        :param pulumi.Input[_builtins.str] manager_password: Specifies the password for logging in to the Kafka Manager. The
               password must meet the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of
               the following character types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_
               =+\\\\|[{}]:'",<.>/?). Changing this creates a new instance resource.
               
               > **NOTE:** `manager_user` and `manager_password` are deprecated and will be deleted in future releases
        :param pulumi.Input[_builtins.str] manager_user: Specifies the username for logging in to the Kafka Manager. The username
               consists of 4 to 64 characters and can contain letters, digits, hyphens (-), and underscores (_). Changing this
               creates a new instance resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the DMS Kafka instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        :param pulumi.Input[_builtins.str] network_id: Specifies the ID of a subnet. Changing this creates a new instance
               resource.
        :param pulumi.Input[_builtins.int] partition_num: Indicates the number of partitions in Kafka instance.
        :param pulumi.Input[_builtins.str] password: Specifies the password of SASL_SSL user. A password must meet the
               following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following character
               types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
               Changing this creates a new instance resource.
               
               > **NOTE:** `access_user` and `password` parameters are mandatory when ssl_enable is set to true. These parameters are invalid when ssl_enable is set to false. \\
               > **NOTE:** If `access_user` and `password` are specified, set `ssl_enable = true`, to enable SASL_SSL for a Kafka instance.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance. If `period_unit` is set to *month*
               , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter is
               mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] port: The port number.
        :param pulumi.Input[_builtins.str] product_id: Specifies a product ID, which includes bandwidth, partition, broker and default
               storage capacity.
               
               > **NOTE:** Change this to change the bandwidth, partition and broker of the Kafka instances. Please note that the
               broker changes may cause storage capacity changes. So, if you specify the value of `storage_space`, you need to
               manually modify the value of `storage_space` after changing the `product_id`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] public_ip_ids: Specifies the IDs of the elastic IP address (EIP)
               bound to the DMS Kafka instance. Changing this creates a new instance resource.
               + If the instance is created with `flavor_id`, the total number of public IPs is equal to `broker_num`.
               + If the instance is created with `product_id`, the total number of public IPs must provide as follows:
               
               | Bandwidth | Total number of public IPs |
               | ---- | ---- |
               | 100MB | 3 |
               | 300MB | 3 |
               | 600MB | 4 |
               | 1,200MB | 8 |
        :param pulumi.Input[_builtins.str] region: The region in which to create the DMS Kafka instances. If omitted, the
               provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] resource_spec_code: Indicates a resource specifications identifier.
        :param pulumi.Input[_builtins.str] retention_policy: Specifies the action to be taken when the memory usage reaches the disk
               capacity threshold. The valid values are as follows:
               + **time_base**: Automatically delete the earliest messages.
               + **produce_reject**: Stop producing new messages.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[_builtins.bool] ssl_enable: Indicates whether the Kafka SASL_SSL is enabled.
        :param pulumi.Input[_builtins.str] status: Indicates the status of the DMS Kafka instance.
        :param pulumi.Input[_builtins.int] storage_space: Specifies the message storage capacity, the unit is GB.
               + When bandwidth is 100MB: 600–90000 GB
               + When bandwidth is 300MB: 1200–90000 GB
               + When bandwidth is 600MB: 2400–90000 GB
               + When bandwidth is 1200MB: 4800–90000 GB
               
               Changing this creates a new instance resource.
               
               It is required when creating an instance with `flavor_id`.
        :param pulumi.Input[_builtins.str] storage_spec_code: Specifies the storage I/O specification. Value range:
               + When bandwidth is 100MB: dms.physical.storage.high or dms.physical.storage.ultra
               + When bandwidth is 300MB: dms.physical.storage.high or dms.physical.storage.ultra
               + When bandwidth is 600MB: dms.physical.storage.ultra
               + When bandwidth is 1200MB: dms.physical.storage.ultra
               
               If the instance is created with `product_id`, the valid values are as follows:
               + **dms.physical.storage.high**: Type of the disk that uses high I/O.
               The corresponding bandwidths are **100MB** and **300MB**.
               + **dms.physical.storage.ultra**: Type of the disk that uses ultra-high I/O.
               The corresponding bandwidths are **100MB**, **300MB**, **600MB** and **1,200MB**.
               
               Changing this creates a new instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the DMS Kafka instance.
        :param pulumi.Input[_builtins.str] type: Indicates the DMS Kafka instance type.
        :param pulumi.Input[_builtins.int] used_storage_space: Indicates the used message storage space. Unit: GB
        :param pulumi.Input[_builtins.str] user_id: Indicates the ID of the user who created the DMS Kafka instance
        :param pulumi.Input[_builtins.str] user_name: Indicates the name of the user who created the DMS Kafka instance
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaInstanceState.__new__(_KafkaInstanceState)

        __props__.__dict__["access_user"] = access_user
        __props__.__dict__["arch_type"] = arch_type
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["available_zones"] = available_zones
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["broker_num"] = broker_num
        __props__.__dict__["cert_replaced"] = cert_replaced
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["connect_address"] = connect_address
        __props__.__dict__["connector_id"] = connector_id
        __props__.__dict__["connector_node_num"] = connector_node_num
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["cross_vpc_accesses"] = cross_vpc_accesses
        __props__.__dict__["description"] = description
        __props__.__dict__["dumping"] = dumping
        __props__.__dict__["enable_auto_topic"] = enable_auto_topic
        __props__.__dict__["enable_public_ip"] = enable_public_ip
        __props__.__dict__["enabled_mechanisms"] = enabled_mechanisms
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["extend_times"] = extend_times
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["ipv6_connect_addresses"] = ipv6_connect_addresses
        __props__.__dict__["ipv6_enable"] = ipv6_enable
        __props__.__dict__["is_logical_volume"] = is_logical_volume
        __props__.__dict__["kms_encrypted_password"] = kms_encrypted_password
        __props__.__dict__["maintain_begin"] = maintain_begin
        __props__.__dict__["maintain_end"] = maintain_end
        __props__.__dict__["management_connect_address"] = management_connect_address
        __props__.__dict__["manager_password"] = manager_password
        __props__.__dict__["manager_user"] = manager_user
        __props__.__dict__["manegement_connect_address"] = manegement_connect_address
        __props__.__dict__["message_query_inst_enable"] = message_query_inst_enable
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["new_tenant_ips"] = new_tenant_ips
        __props__.__dict__["node_num"] = node_num
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["partition_num"] = partition_num
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["pod_connect_address"] = pod_connect_address
        __props__.__dict__["port"] = port
        __props__.__dict__["port_protocols"] = port_protocols
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["public_bandwidth"] = public_bandwidth
        __props__.__dict__["public_ip_addresses"] = public_ip_addresses
        __props__.__dict__["public_ip_ids"] = public_ip_ids
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_spec_code"] = resource_spec_code
        __props__.__dict__["retention_policy"] = retention_policy
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_protocol"] = security_protocol
        __props__.__dict__["ssl_enable"] = ssl_enable
        __props__.__dict__["ssl_two_way_enable"] = ssl_two_way_enable
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_resource_id"] = storage_resource_id
        __props__.__dict__["storage_space"] = storage_space
        __props__.__dict__["storage_spec_code"] = storage_spec_code
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["used_storage_space"] = used_storage_space
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["vpc_client_plain"] = vpc_client_plain
        __props__.__dict__["vpc_id"] = vpc_id
        return KafkaInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the username of SASL_SSL user. A username consists of 4
        to 64 characters and supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        """
        return pulumi.get(self, "access_user")

    @_builtins.property
    @pulumi.getter(name="archType")
    def arch_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "arch_type")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "false".

        <a name="dms_cross_vpc_accesses"></a>
        The `cross_vpc_accesses` block supports:
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The names of the AZ where the Kafka instances reside.
        The parameter value can not be left blank or an empty array. Changing this creates a new instance resource.

        > **NOTE:** Deploy one availability zone or at least three availability zones. Do not select two availability zones.
        Deploy to more availability zones, the better the reliability and SLA coverage.

        > The parameter behavior of `availability_zones` has been changed from `list` to `set`.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="availableZones")
    @_utilities.deprecated("""available_zones has deprecated, please use \"availability_zones\" instead.""")
    def available_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "available_zones")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""The bandwidth has been deprecated. If you need to change the bandwidth, please update the product_id.""")
    def bandwidth(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="brokerNum")
    def broker_num(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the broker numbers.
        It is required when creating an instance with `flavor_id`.
        """
        return pulumi.get(self, "broker_num")

    @_builtins.property
    @pulumi.getter(name="certReplaced")
    def cert_replaced(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "cert_replaced")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the charging mode of the instance. Valid values are *prePaid*
        and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="connectAddress")
    def connect_address(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the IP address of the DMS Kafka instance.
        """
        return pulumi.get(self, "connect_address")

    @_builtins.property
    @pulumi.getter(name="connectorId")
    def connector_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "connector_id")

    @_builtins.property
    @pulumi.getter(name="connectorNodeNum")
    def connector_node_num(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "connector_node_num")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="crossVpcAccesses")
    def cross_vpc_accesses(self) -> pulumi.Output[Sequence['outputs.KafkaInstanceCrossVpcAccess']]:
        """
        Specifies the cross-VPC access information.
        The object structure is documented below.
        """
        return pulumi.get(self, "cross_vpc_accesses")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the DMS Kafka instance. It is a character string
        containing not more than 1,024 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def dumping(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable message dumping.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "dumping")

    @_builtins.property
    @pulumi.getter(name="enableAutoTopic")
    def enable_auto_topic(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to enable automatic topic creation. If automatic
        topic creation is enabled, a topic will be automatically created with 3 partitions and 3 replicas when a message is
        produced to or consumed from a topic that does not exist.
        The default value is false.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "enable_auto_topic")

    @_builtins.property
    @pulumi.getter(name="enablePublicIp")
    def enable_public_ip(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether public access to the DMS Kafka instance is enabled.
        """
        return pulumi.get(self, "enable_public_ip")

    @_builtins.property
    @pulumi.getter(name="enabledMechanisms")
    def enabled_mechanisms(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "enabled_mechanisms")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the message engine.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the version of the Kafka engine,
        such as 1.1.0, 2.3.0, 2.7 or other supported versions. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project ID of the Kafka instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="extendTimes")
    def extend_times(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "extend_times")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Kafka `flavor ID`. This parameter and `product_id` are alternative.

        > It is recommended to use `flavor_id` if the region supports it.\\
        One of:
        * c6.2u4g.cluster
        * c6.4u8g.cluster
        * c6.8u16g.cluster
        * c6.12u24g.cluster
        * c6.16u32g.cluster \\
        Or use data source sbercloud_dms_kafka_flavors
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="ipv6ConnectAddresses")
    def ipv6_connect_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "ipv6_connect_addresses")

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "ipv6_enable")

    @_builtins.property
    @pulumi.getter(name="isLogicalVolume")
    def is_logical_volume(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "is_logical_volume")

    @_builtins.property
    @pulumi.getter(name="kmsEncryptedPassword")
    def kms_encrypted_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "kms_encrypted_password")

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the time at which a maintenance time window starts. Format: HH:mm. The
        start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
        window. The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
        blank. In this case, the system automatically allocates the default start time 02:00.
        """
        return pulumi.get(self, "maintain_begin")

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the time at which a maintenance time window ends. Format: HH:mm. The
        start time and end time of a maintenance time window must indicate the time segment of a supported maintenance time
        window. The end time is four hours later than the start time. For example, if the start time is 22:00, the end time is
        02:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_end` is left blank, parameter
        `maintain_begin` is also blank. In this case, the system automatically allocates the default end time 06:00.
        """
        return pulumi.get(self, "maintain_end")

    @_builtins.property
    @pulumi.getter(name="managementConnectAddress")
    @_utilities.deprecated("""Deprecated""")
    def management_connect_address(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the Kafka Manager connection address of a Kafka instance.
        """
        return pulumi.get(self, "management_connect_address")

    @_builtins.property
    @pulumi.getter(name="managerPassword")
    @_utilities.deprecated("""Deprecated""")
    def manager_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the password for logging in to the Kafka Manager. The
        password must meet the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of
        the following character types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_
        =+\\\\|[{}]:'",<.>/?). Changing this creates a new instance resource.

        > **NOTE:** `manager_user` and `manager_password` are deprecated and will be deleted in future releases
        """
        return pulumi.get(self, "manager_password")

    @_builtins.property
    @pulumi.getter(name="managerUser")
    @_utilities.deprecated("""Deprecated""")
    def manager_user(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the username for logging in to the Kafka Manager. The username
        consists of 4 to 64 characters and can contain letters, digits, hyphens (-), and underscores (_). Changing this
        creates a new instance resource.
        """
        return pulumi.get(self, "manager_user")

    @_builtins.property
    @pulumi.getter(name="manegementConnectAddress")
    @_utilities.deprecated("""typo in manegement_connect_address, please use \"management_connect_address\" instead.""")
    def manegement_connect_address(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "manegement_connect_address")

    @_builtins.property
    @pulumi.getter(name="messageQueryInstEnable")
    def message_query_inst_enable(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "message_query_inst_enable")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the DMS Kafka instance. An instance name starts with a letter,
        consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of a subnet. Changing this creates a new instance
        resource.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="newTenantIps")
    def new_tenant_ips(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        return pulumi.get(self, "new_tenant_ips")

    @_builtins.property
    @pulumi.getter(name="nodeNum")
    def node_num(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "node_num")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Sequence['outputs.KafkaInstanceParameter']]:
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="partitionNum")
    def partition_num(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates the number of partitions in Kafka instance.
        """
        return pulumi.get(self, "partition_num")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the password of SASL_SSL user. A password must meet the
        following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following character
        types: lowercase letters, uppercase letters, digits, and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
        Changing this creates a new instance resource.

        > **NOTE:** `access_user` and `password` parameters are mandatory when ssl_enable is set to true. These parameters are invalid when ssl_enable is set to false. \\
        > **NOTE:** If `access_user` and `password` are specified, set `ssl_enable = true`, to enable SASL_SSL for a Kafka instance.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the charging period of the instance. If `period_unit` is set to *month*
        , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from 1 to 3. This parameter is
        mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="podConnectAddress")
    def pod_connect_address(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "pod_connect_address")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        The port number.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portProtocols")
    def port_protocols(self) -> pulumi.Output[Sequence['outputs.KafkaInstancePortProtocol']]:
        return pulumi.get(self, "port_protocols")

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a product ID, which includes bandwidth, partition, broker and default
        storage capacity.

        > **NOTE:** Change this to change the bandwidth, partition and broker of the Kafka instances. Please note that the
        broker changes may cause storage capacity changes. So, if you specify the value of `storage_space`, you need to
        manually modify the value of `storage_space` after changing the `product_id`.
        """
        return pulumi.get(self, "product_id")

    @_builtins.property
    @pulumi.getter(name="publicBandwidth")
    def public_bandwidth(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "public_bandwidth")

    @_builtins.property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "public_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="publicIpIds")
    def public_ip_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        Specifies the IDs of the elastic IP address (EIP)
        bound to the DMS Kafka instance. Changing this creates a new instance resource.
        + If the instance is created with `flavor_id`, the total number of public IPs is equal to `broker_num`.
        + If the instance is created with `product_id`, the total number of public IPs must provide as follows:

        | Bandwidth | Total number of public IPs |
        | ---- | ---- |
        | 100MB | 3 |
        | 300MB | 3 |
        | 600MB | 4 |
        | 1,200MB | 8 |
        """
        return pulumi.get(self, "public_ip_ids")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the DMS Kafka instances. If omitted, the
        provider-level region will be used. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceSpecCode")
    def resource_spec_code(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates a resource specifications identifier.
        """
        return pulumi.get(self, "resource_spec_code")

    @_builtins.property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the action to be taken when the memory usage reaches the disk
        capacity threshold. The valid values are as follows:
        + **time_base**: Automatically delete the earliest messages.
        + **produce_reject**: Stop producing new messages.
        """
        return pulumi.get(self, "retention_policy")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of a security group.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "security_protocol")

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether the Kafka SASL_SSL is enabled.
        """
        return pulumi.get(self, "ssl_enable")

    @_builtins.property
    @pulumi.getter(name="sslTwoWayEnable")
    def ssl_two_way_enable(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "ssl_two_way_enable")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the status of the DMS Kafka instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageResourceId")
    def storage_resource_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "storage_resource_id")

    @_builtins.property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the message storage capacity, the unit is GB.
        + When bandwidth is 100MB: 600–90000 GB
        + When bandwidth is 300MB: 1200–90000 GB
        + When bandwidth is 600MB: 2400–90000 GB
        + When bandwidth is 1200MB: 4800–90000 GB

        Changing this creates a new instance resource.

        It is required when creating an instance with `flavor_id`.
        """
        return pulumi.get(self, "storage_space")

    @_builtins.property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the storage I/O specification. Value range:
        + When bandwidth is 100MB: dms.physical.storage.high or dms.physical.storage.ultra
        + When bandwidth is 300MB: dms.physical.storage.high or dms.physical.storage.ultra
        + When bandwidth is 600MB: dms.physical.storage.ultra
        + When bandwidth is 1200MB: dms.physical.storage.ultra

        If the instance is created with `product_id`, the valid values are as follows:
        + **dms.physical.storage.high**: Type of the disk that uses high I/O.
        The corresponding bandwidths are **100MB** and **300MB**.
        + **dms.physical.storage.ultra**: Type of the disk that uses ultra-high I/O.
        The corresponding bandwidths are **100MB**, **300MB**, **600MB** and **1,200MB**.

        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "storage_spec_code")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key/value pairs to associate with the DMS Kafka instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the DMS Kafka instance type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="usedStorageSpace")
    def used_storage_space(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates the used message storage space. Unit: GB
        """
        return pulumi.get(self, "used_storage_space")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the ID of the user who created the DMS Kafka instance
        """
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the name of the user who created the DMS Kafka instance
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter(name="vpcClientPlain")
    def vpc_client_plain(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "vpc_client_plain")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

