# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KafkaTopicArgs', 'KafkaTopic']

@pulumi.input_type
class KafkaTopicArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 partitions: pulumi.Input[_builtins.int],
                 aging_time: Optional[pulumi.Input[_builtins.int]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaTopicConfigArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_partition_brokers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 sync_flushing: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_replication: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a KafkaTopic resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the DMS kafka instance to which the topic belongs.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] partitions: Specifies the partition number. The value ranges from 1 to 100.
        :param pulumi.Input[_builtins.int] aging_time: Specifies the aging time in hours. The value ranges from 1 to 168 and defaults to 72.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the topic. The name starts with a letter, consists of 4 to
               64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
               resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DMS kafka topic resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] replicas: Specifies the replica number. The value ranges from 1 to 3 and defaults to 3.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.bool] sync_flushing: Whether or not to enable synchronous flushing.
        :param pulumi.Input[_builtins.bool] sync_replication: Whether or not to enable synchronous replication.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "partitions", partitions)
        if aging_time is not None:
            pulumi.set(__self__, "aging_time", aging_time)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_partition_brokers is not None:
            pulumi.set(__self__, "new_partition_brokers", new_partition_brokers)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if sync_flushing is not None:
            pulumi.set(__self__, "sync_flushing", sync_flushing)
        if sync_replication is not None:
            pulumi.set(__self__, "sync_replication", sync_replication)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the DMS kafka instance to which the topic belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def partitions(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the partition number. The value ranges from 1 to 100.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "partitions", value)

    @_builtins.property
    @pulumi.getter(name="agingTime")
    def aging_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the aging time in hours. The value ranges from 1 to 168 and defaults to 72.
        """
        return pulumi.get(self, "aging_time")

    @aging_time.setter
    def aging_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "aging_time", value)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaTopicConfigArgs']]]]:
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaTopicConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the topic. The name starts with a letter, consists of 4 to
        64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
        resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="newPartitionBrokers")
    def new_partition_brokers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        return pulumi.get(self, "new_partition_brokers")

    @new_partition_brokers.setter
    def new_partition_brokers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "new_partition_brokers", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the DMS kafka topic resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the replica number. The value ranges from 1 to 3 and defaults to 3.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replicas", value)

    @_builtins.property
    @pulumi.getter(name="syncFlushing")
    def sync_flushing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to enable synchronous flushing.
        """
        return pulumi.get(self, "sync_flushing")

    @sync_flushing.setter
    def sync_flushing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_flushing", value)

    @_builtins.property
    @pulumi.getter(name="syncReplication")
    def sync_replication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to enable synchronous replication.
        """
        return pulumi.get(self, "sync_replication")

    @sync_replication.setter
    def sync_replication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_replication", value)


@pulumi.input_type
class _KafkaTopicState:
    def __init__(__self__, *,
                 aging_time: Optional[pulumi.Input[_builtins.int]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaTopicConfigArgs']]]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_partition_brokers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 partitions: Optional[pulumi.Input[_builtins.int]] = None,
                 policies_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 sync_flushing: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_replication: Optional[pulumi.Input[_builtins.bool]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering KafkaTopic resources.
        :param pulumi.Input[_builtins.int] aging_time: Specifies the aging time in hours. The value ranges from 1 to 168 and defaults to 72.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the DMS kafka instance to which the topic belongs.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the topic. The name starts with a letter, consists of 4 to
               64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
               resource.
        :param pulumi.Input[_builtins.int] partitions: Specifies the partition number. The value ranges from 1 to 100.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DMS kafka topic resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] replicas: Specifies the replica number. The value ranges from 1 to 3 and defaults to 3.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.bool] sync_flushing: Whether or not to enable synchronous flushing.
        :param pulumi.Input[_builtins.bool] sync_replication: Whether or not to enable synchronous replication.
        """
        if aging_time is not None:
            pulumi.set(__self__, "aging_time", aging_time)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if new_partition_brokers is not None:
            pulumi.set(__self__, "new_partition_brokers", new_partition_brokers)
        if partitions is not None:
            pulumi.set(__self__, "partitions", partitions)
        if policies_only is not None:
            pulumi.set(__self__, "policies_only", policies_only)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if replicas is not None:
            pulumi.set(__self__, "replicas", replicas)
        if sync_flushing is not None:
            pulumi.set(__self__, "sync_flushing", sync_flushing)
        if sync_replication is not None:
            pulumi.set(__self__, "sync_replication", sync_replication)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="agingTime")
    def aging_time(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the aging time in hours. The value ranges from 1 to 168 and defaults to 72.
        """
        return pulumi.get(self, "aging_time")

    @aging_time.setter
    def aging_time(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "aging_time", value)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KafkaTopicConfigArgs']]]]:
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KafkaTopicConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the DMS kafka instance to which the topic belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the topic. The name starts with a letter, consists of 4 to
        64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
        resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="newPartitionBrokers")
    def new_partition_brokers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]:
        return pulumi.get(self, "new_partition_brokers")

    @new_partition_brokers.setter
    def new_partition_brokers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]]):
        pulumi.set(self, "new_partition_brokers", value)

    @_builtins.property
    @pulumi.getter
    def partitions(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the partition number. The value ranges from 1 to 100.
        """
        return pulumi.get(self, "partitions")

    @partitions.setter
    def partitions(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "partitions", value)

    @_builtins.property
    @pulumi.getter(name="policiesOnly")
    def policies_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "policies_only")

    @policies_only.setter
    def policies_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "policies_only", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the DMS kafka topic resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the replica number. The value ranges from 1 to 3 and defaults to 3.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "replicas")

    @replicas.setter
    def replicas(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replicas", value)

    @_builtins.property
    @pulumi.getter(name="syncFlushing")
    def sync_flushing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to enable synchronous flushing.
        """
        return pulumi.get(self, "sync_flushing")

    @sync_flushing.setter
    def sync_flushing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_flushing", value)

    @_builtins.property
    @pulumi.getter(name="syncReplication")
    def sync_replication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to enable synchronous replication.
        """
        return pulumi.get(self, "sync_replication")

    @sync_replication.setter
    def sync_replication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "sync_replication", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("sbercloud:Dms/kafkaTopic:KafkaTopic")
class KafkaTopic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aging_time: Optional[pulumi.Input[_builtins.int]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaTopicConfigArgs', 'KafkaTopicConfigArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_partition_brokers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 partitions: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 sync_flushing: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_replication: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a DMS kafka topic resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        kafka_instance_id = config.require_object("kafkaInstanceId")
        topic = sbercloud.dms.KafkaTopic("topic",
            instance_id=kafka_instance_id,
            name="topic_1",
            partitions=20)
        ```

        ## Import

        DMS kafka topics can be imported using the kafka instance ID and topic name separated by a slash, e.g.:

        ```sh
        $ pulumi import sbercloud:Dms/kafkaTopic:KafkaTopic topic c8057fe5-23a8-46ef-ad83-c0055b4e0c5c/topic_1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] aging_time: Specifies the aging time in hours. The value ranges from 1 to 168 and defaults to 72.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the DMS kafka instance to which the topic belongs.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the topic. The name starts with a letter, consists of 4 to
               64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
               resource.
        :param pulumi.Input[_builtins.int] partitions: Specifies the partition number. The value ranges from 1 to 100.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DMS kafka topic resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] replicas: Specifies the replica number. The value ranges from 1 to 3 and defaults to 3.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.bool] sync_flushing: Whether or not to enable synchronous flushing.
        :param pulumi.Input[_builtins.bool] sync_replication: Whether or not to enable synchronous replication.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaTopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DMS kafka topic resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        kafka_instance_id = config.require_object("kafkaInstanceId")
        topic = sbercloud.dms.KafkaTopic("topic",
            instance_id=kafka_instance_id,
            name="topic_1",
            partitions=20)
        ```

        ## Import

        DMS kafka topics can be imported using the kafka instance ID and topic name separated by a slash, e.g.:

        ```sh
        $ pulumi import sbercloud:Dms/kafkaTopic:KafkaTopic topic c8057fe5-23a8-46ef-ad83-c0055b4e0c5c/topic_1
        ```

        :param str resource_name: The name of the resource.
        :param KafkaTopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaTopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aging_time: Optional[pulumi.Input[_builtins.int]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaTopicConfigArgs', 'KafkaTopicConfigArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 new_partition_brokers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
                 partitions: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 replicas: Optional[pulumi.Input[_builtins.int]] = None,
                 sync_flushing: Optional[pulumi.Input[_builtins.bool]] = None,
                 sync_replication: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaTopicArgs.__new__(KafkaTopicArgs)

            __props__.__dict__["aging_time"] = aging_time
            __props__.__dict__["configs"] = configs
            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["new_partition_brokers"] = new_partition_brokers
            if partitions is None and not opts.urn:
                raise TypeError("Missing required property 'partitions'")
            __props__.__dict__["partitions"] = partitions
            __props__.__dict__["region"] = region
            __props__.__dict__["replicas"] = replicas
            __props__.__dict__["sync_flushing"] = sync_flushing
            __props__.__dict__["sync_replication"] = sync_replication
            __props__.__dict__["created_at"] = None
            __props__.__dict__["policies_only"] = None
            __props__.__dict__["type"] = None
        super(KafkaTopic, __self__).__init__(
            'sbercloud:Dms/kafkaTopic:KafkaTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aging_time: Optional[pulumi.Input[_builtins.int]] = None,
            configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['KafkaTopicConfigArgs', 'KafkaTopicConfigArgsDict']]]]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            new_partition_brokers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.int]]]] = None,
            partitions: Optional[pulumi.Input[_builtins.int]] = None,
            policies_only: Optional[pulumi.Input[_builtins.bool]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            replicas: Optional[pulumi.Input[_builtins.int]] = None,
            sync_flushing: Optional[pulumi.Input[_builtins.bool]] = None,
            sync_replication: Optional[pulumi.Input[_builtins.bool]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'KafkaTopic':
        """
        Get an existing KafkaTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] aging_time: Specifies the aging time in hours. The value ranges from 1 to 168 and defaults to 72.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the DMS kafka instance to which the topic belongs.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the topic. The name starts with a letter, consists of 4 to
               64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
               resource.
        :param pulumi.Input[_builtins.int] partitions: Specifies the partition number. The value ranges from 1 to 100.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DMS kafka topic resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] replicas: Specifies the replica number. The value ranges from 1 to 3 and defaults to 3.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.bool] sync_flushing: Whether or not to enable synchronous flushing.
        :param pulumi.Input[_builtins.bool] sync_replication: Whether or not to enable synchronous replication.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaTopicState.__new__(_KafkaTopicState)

        __props__.__dict__["aging_time"] = aging_time
        __props__.__dict__["configs"] = configs
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["new_partition_brokers"] = new_partition_brokers
        __props__.__dict__["partitions"] = partitions
        __props__.__dict__["policies_only"] = policies_only
        __props__.__dict__["region"] = region
        __props__.__dict__["replicas"] = replicas
        __props__.__dict__["sync_flushing"] = sync_flushing
        __props__.__dict__["sync_replication"] = sync_replication
        __props__.__dict__["type"] = type
        return KafkaTopic(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agingTime")
    def aging_time(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the aging time in hours. The value ranges from 1 to 168 and defaults to 72.
        """
        return pulumi.get(self, "aging_time")

    @_builtins.property
    @pulumi.getter
    def configs(self) -> pulumi.Output[Sequence['outputs.KafkaTopicConfig']]:
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the DMS kafka instance to which the topic belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the topic. The name starts with a letter, consists of 4 to
        64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
        resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="newPartitionBrokers")
    def new_partition_brokers(self) -> pulumi.Output[Optional[Sequence[_builtins.int]]]:
        return pulumi.get(self, "new_partition_brokers")

    @_builtins.property
    @pulumi.getter
    def partitions(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the partition number. The value ranges from 1 to 100.
        """
        return pulumi.get(self, "partitions")

    @_builtins.property
    @pulumi.getter(name="policiesOnly")
    def policies_only(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "policies_only")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the DMS kafka topic resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def replicas(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the replica number. The value ranges from 1 to 3 and defaults to 3.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "replicas")

    @_builtins.property
    @pulumi.getter(name="syncFlushing")
    def sync_flushing(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether or not to enable synchronous flushing.
        """
        return pulumi.get(self, "sync_flushing")

    @_builtins.property
    @pulumi.getter(name="syncReplication")
    def sync_replication(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether or not to enable synchronous replication.
        """
        return pulumi.get(self, "sync_replication")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "type")

