# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'KafkaInstanceCrossVpcAccess',
    'KafkaInstanceParameter',
    'KafkaInstancePortProtocol',
    'KafkaPermissionsPolicy',
    'KafkaTopicConfig',
    'GetFlavorsFlavorResult',
    'GetFlavorsFlavorIoResult',
    'GetFlavorsFlavorPropertyResult',
    'GetFlavorsFlavorSupportFeatureResult',
    'GetFlavorsFlavorSupportFeaturePropertyResult',
    'GetInstancesInstanceResult',
    'GetInstancesInstanceCrossVpcAccessResult',
]

@pulumi.output_type
class KafkaInstanceCrossVpcAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "advertisedIp":
            suggest = "advertised_ip"
        elif key == "lisenterIp":
            suggest = "lisenter_ip"
        elif key == "listenerIp":
            suggest = "listener_ip"
        elif key == "portId":
            suggest = "port_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KafkaInstanceCrossVpcAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KafkaInstanceCrossVpcAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KafkaInstanceCrossVpcAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advertised_ip: Optional[_builtins.str] = None,
                 lisenter_ip: Optional[_builtins.str] = None,
                 listener_ip: Optional[_builtins.str] = None,
                 port: Optional[_builtins.int] = None,
                 port_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str advertised_ip: The advertised IP Address or domain name.
        :param _builtins.str listener_ip: The listener IP address.
        :param _builtins.int port: The port number.
        :param _builtins.str port_id: The port ID associated with the address.
        """
        if advertised_ip is not None:
            pulumi.set(__self__, "advertised_ip", advertised_ip)
        if lisenter_ip is not None:
            pulumi.set(__self__, "lisenter_ip", lisenter_ip)
        if listener_ip is not None:
            pulumi.set(__self__, "listener_ip", listener_ip)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)

    @_builtins.property
    @pulumi.getter(name="advertisedIp")
    def advertised_ip(self) -> Optional[_builtins.str]:
        """
        The advertised IP Address or domain name.
        """
        return pulumi.get(self, "advertised_ip")

    @_builtins.property
    @pulumi.getter(name="lisenterIp")
    @_utilities.deprecated("""typo in lisenter_ip, please use \"listener_ip\" instead.""")
    def lisenter_ip(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "lisenter_ip")

    @_builtins.property
    @pulumi.getter(name="listenerIp")
    def listener_ip(self) -> Optional[_builtins.str]:
        """
        The listener IP address.
        """
        return pulumi.get(self, "listener_ip")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.int]:
        """
        The port number.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[_builtins.str]:
        """
        The port ID associated with the address.
        """
        return pulumi.get(self, "port_id")


@pulumi.output_type
class KafkaInstanceParameter(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Specifies the name of the DMS Kafka instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the DMS Kafka instance. An instance name starts with a letter,
        consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class KafkaInstancePortProtocol(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privatePlainAddress":
            suggest = "private_plain_address"
        elif key == "privatePlainDomainName":
            suggest = "private_plain_domain_name"
        elif key == "privatePlainEnable":
            suggest = "private_plain_enable"
        elif key == "privateSaslPlaintextAddress":
            suggest = "private_sasl_plaintext_address"
        elif key == "privateSaslPlaintextDomainName":
            suggest = "private_sasl_plaintext_domain_name"
        elif key == "privateSaslPlaintextEnable":
            suggest = "private_sasl_plaintext_enable"
        elif key == "privateSaslSslAddress":
            suggest = "private_sasl_ssl_address"
        elif key == "privateSaslSslDomainName":
            suggest = "private_sasl_ssl_domain_name"
        elif key == "privateSaslSslEnable":
            suggest = "private_sasl_ssl_enable"
        elif key == "publicPlainAddress":
            suggest = "public_plain_address"
        elif key == "publicPlainDomainName":
            suggest = "public_plain_domain_name"
        elif key == "publicPlainEnable":
            suggest = "public_plain_enable"
        elif key == "publicSaslPlaintextAddress":
            suggest = "public_sasl_plaintext_address"
        elif key == "publicSaslPlaintextDomainName":
            suggest = "public_sasl_plaintext_domain_name"
        elif key == "publicSaslPlaintextEnable":
            suggest = "public_sasl_plaintext_enable"
        elif key == "publicSaslSslAddress":
            suggest = "public_sasl_ssl_address"
        elif key == "publicSaslSslDomainName":
            suggest = "public_sasl_ssl_domain_name"
        elif key == "publicSaslSslEnable":
            suggest = "public_sasl_ssl_enable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KafkaInstancePortProtocol. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KafkaInstancePortProtocol.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KafkaInstancePortProtocol.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_plain_address: Optional[_builtins.str] = None,
                 private_plain_domain_name: Optional[_builtins.str] = None,
                 private_plain_enable: Optional[_builtins.bool] = None,
                 private_sasl_plaintext_address: Optional[_builtins.str] = None,
                 private_sasl_plaintext_domain_name: Optional[_builtins.str] = None,
                 private_sasl_plaintext_enable: Optional[_builtins.bool] = None,
                 private_sasl_ssl_address: Optional[_builtins.str] = None,
                 private_sasl_ssl_domain_name: Optional[_builtins.str] = None,
                 private_sasl_ssl_enable: Optional[_builtins.bool] = None,
                 public_plain_address: Optional[_builtins.str] = None,
                 public_plain_domain_name: Optional[_builtins.str] = None,
                 public_plain_enable: Optional[_builtins.bool] = None,
                 public_sasl_plaintext_address: Optional[_builtins.str] = None,
                 public_sasl_plaintext_domain_name: Optional[_builtins.str] = None,
                 public_sasl_plaintext_enable: Optional[_builtins.bool] = None,
                 public_sasl_ssl_address: Optional[_builtins.str] = None,
                 public_sasl_ssl_domain_name: Optional[_builtins.str] = None,
                 public_sasl_ssl_enable: Optional[_builtins.bool] = None):
        if private_plain_address is not None:
            pulumi.set(__self__, "private_plain_address", private_plain_address)
        if private_plain_domain_name is not None:
            pulumi.set(__self__, "private_plain_domain_name", private_plain_domain_name)
        if private_plain_enable is not None:
            pulumi.set(__self__, "private_plain_enable", private_plain_enable)
        if private_sasl_plaintext_address is not None:
            pulumi.set(__self__, "private_sasl_plaintext_address", private_sasl_plaintext_address)
        if private_sasl_plaintext_domain_name is not None:
            pulumi.set(__self__, "private_sasl_plaintext_domain_name", private_sasl_plaintext_domain_name)
        if private_sasl_plaintext_enable is not None:
            pulumi.set(__self__, "private_sasl_plaintext_enable", private_sasl_plaintext_enable)
        if private_sasl_ssl_address is not None:
            pulumi.set(__self__, "private_sasl_ssl_address", private_sasl_ssl_address)
        if private_sasl_ssl_domain_name is not None:
            pulumi.set(__self__, "private_sasl_ssl_domain_name", private_sasl_ssl_domain_name)
        if private_sasl_ssl_enable is not None:
            pulumi.set(__self__, "private_sasl_ssl_enable", private_sasl_ssl_enable)
        if public_plain_address is not None:
            pulumi.set(__self__, "public_plain_address", public_plain_address)
        if public_plain_domain_name is not None:
            pulumi.set(__self__, "public_plain_domain_name", public_plain_domain_name)
        if public_plain_enable is not None:
            pulumi.set(__self__, "public_plain_enable", public_plain_enable)
        if public_sasl_plaintext_address is not None:
            pulumi.set(__self__, "public_sasl_plaintext_address", public_sasl_plaintext_address)
        if public_sasl_plaintext_domain_name is not None:
            pulumi.set(__self__, "public_sasl_plaintext_domain_name", public_sasl_plaintext_domain_name)
        if public_sasl_plaintext_enable is not None:
            pulumi.set(__self__, "public_sasl_plaintext_enable", public_sasl_plaintext_enable)
        if public_sasl_ssl_address is not None:
            pulumi.set(__self__, "public_sasl_ssl_address", public_sasl_ssl_address)
        if public_sasl_ssl_domain_name is not None:
            pulumi.set(__self__, "public_sasl_ssl_domain_name", public_sasl_ssl_domain_name)
        if public_sasl_ssl_enable is not None:
            pulumi.set(__self__, "public_sasl_ssl_enable", public_sasl_ssl_enable)

    @_builtins.property
    @pulumi.getter(name="privatePlainAddress")
    def private_plain_address(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "private_plain_address")

    @_builtins.property
    @pulumi.getter(name="privatePlainDomainName")
    def private_plain_domain_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "private_plain_domain_name")

    @_builtins.property
    @pulumi.getter(name="privatePlainEnable")
    def private_plain_enable(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "private_plain_enable")

    @_builtins.property
    @pulumi.getter(name="privateSaslPlaintextAddress")
    def private_sasl_plaintext_address(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "private_sasl_plaintext_address")

    @_builtins.property
    @pulumi.getter(name="privateSaslPlaintextDomainName")
    def private_sasl_plaintext_domain_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "private_sasl_plaintext_domain_name")

    @_builtins.property
    @pulumi.getter(name="privateSaslPlaintextEnable")
    def private_sasl_plaintext_enable(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "private_sasl_plaintext_enable")

    @_builtins.property
    @pulumi.getter(name="privateSaslSslAddress")
    def private_sasl_ssl_address(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "private_sasl_ssl_address")

    @_builtins.property
    @pulumi.getter(name="privateSaslSslDomainName")
    def private_sasl_ssl_domain_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "private_sasl_ssl_domain_name")

    @_builtins.property
    @pulumi.getter(name="privateSaslSslEnable")
    def private_sasl_ssl_enable(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "private_sasl_ssl_enable")

    @_builtins.property
    @pulumi.getter(name="publicPlainAddress")
    def public_plain_address(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "public_plain_address")

    @_builtins.property
    @pulumi.getter(name="publicPlainDomainName")
    def public_plain_domain_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "public_plain_domain_name")

    @_builtins.property
    @pulumi.getter(name="publicPlainEnable")
    def public_plain_enable(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "public_plain_enable")

    @_builtins.property
    @pulumi.getter(name="publicSaslPlaintextAddress")
    def public_sasl_plaintext_address(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "public_sasl_plaintext_address")

    @_builtins.property
    @pulumi.getter(name="publicSaslPlaintextDomainName")
    def public_sasl_plaintext_domain_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "public_sasl_plaintext_domain_name")

    @_builtins.property
    @pulumi.getter(name="publicSaslPlaintextEnable")
    def public_sasl_plaintext_enable(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "public_sasl_plaintext_enable")

    @_builtins.property
    @pulumi.getter(name="publicSaslSslAddress")
    def public_sasl_ssl_address(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "public_sasl_ssl_address")

    @_builtins.property
    @pulumi.getter(name="publicSaslSslDomainName")
    def public_sasl_ssl_domain_name(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "public_sasl_ssl_domain_name")

    @_builtins.property
    @pulumi.getter(name="publicSaslSslEnable")
    def public_sasl_ssl_enable(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "public_sasl_ssl_enable")


@pulumi.output_type
class KafkaPermissionsPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessPolicy":
            suggest = "access_policy"
        elif key == "userName":
            suggest = "user_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KafkaPermissionsPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KafkaPermissionsPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KafkaPermissionsPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_policy: _builtins.str,
                 user_name: _builtins.str):
        """
        :param _builtins.str access_policy: Specifies the permissions type. The value can be:
               + **all**: publish and subscribe permissions.
               + **pub**: publish permissions.
               + **sub**: subscribe permissions.
        :param _builtins.str user_name: Specifies the username.
        """
        pulumi.set(__self__, "access_policy", access_policy)
        pulumi.set(__self__, "user_name", user_name)

    @_builtins.property
    @pulumi.getter(name="accessPolicy")
    def access_policy(self) -> _builtins.str:
        """
        Specifies the permissions type. The value can be:
        + **all**: publish and subscribe permissions.
        + **pub**: publish permissions.
        + **sub**: subscribe permissions.
        """
        return pulumi.get(self, "access_policy")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        Specifies the username.
        """
        return pulumi.get(self, "user_name")


@pulumi.output_type
class KafkaTopicConfig(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Specifies the name of the topic. The name starts with a letter, consists of 4 to
               64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
               resource.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the topic. The name starts with a letter, consists of 4 to
        64 characters, and supports only letters, digits, hyphens (-) and underscores (_). Changing this creates a new
        resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetFlavorsFlavorResult(dict):
    def __init__(__self__, *,
                 arch_types: Sequence[_builtins.str],
                 charging_modes: Sequence[_builtins.str],
                 id: _builtins.str,
                 ios: Sequence['outputs.GetFlavorsFlavorIoResult'],
                 properties: Sequence['outputs.GetFlavorsFlavorPropertyResult'],
                 support_features: Sequence['outputs.GetFlavorsFlavorSupportFeatureResult'],
                 type: _builtins.str,
                 vm_specification: _builtins.str):
        """
        :param Sequence[_builtins.str] arch_types: The list of supported CPU architectures.
        :param Sequence[_builtins.str] charging_modes: The list of supported billing modes.
        :param _builtins.str id: The flavor ID.
        :param Sequence['GetFlavorsFlavorIoArgs'] ios: The list of supported disk IO types.
               The object structure is documented below.
        :param Sequence['GetFlavorsFlavorPropertyArgs'] properties: The function property details.
               The object structure is documented below.
        :param Sequence['GetFlavorsFlavorSupportFeatureArgs'] support_features: The list of features supported by the current specification.
               The object structure is documented below.
        :param _builtins.str type: Specifies flavor type. The valid values are **single**, **cluster** and **cluster.small**.
        :param _builtins.str vm_specification: The underlying VM specification.
        """
        pulumi.set(__self__, "arch_types", arch_types)
        pulumi.set(__self__, "charging_modes", charging_modes)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ios", ios)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "support_features", support_features)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "vm_specification", vm_specification)

    @_builtins.property
    @pulumi.getter(name="archTypes")
    def arch_types(self) -> Sequence[_builtins.str]:
        """
        The list of supported CPU architectures.
        """
        return pulumi.get(self, "arch_types")

    @_builtins.property
    @pulumi.getter(name="chargingModes")
    def charging_modes(self) -> Sequence[_builtins.str]:
        """
        The list of supported billing modes.
        """
        return pulumi.get(self, "charging_modes")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The flavor ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ios(self) -> Sequence['outputs.GetFlavorsFlavorIoResult']:
        """
        The list of supported disk IO types.
        The object structure is documented below.
        """
        return pulumi.get(self, "ios")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetFlavorsFlavorPropertyResult']:
        """
        The function property details.
        The object structure is documented below.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="supportFeatures")
    def support_features(self) -> Sequence['outputs.GetFlavorsFlavorSupportFeatureResult']:
        """
        The list of features supported by the current specification.
        The object structure is documented below.
        """
        return pulumi.get(self, "support_features")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies flavor type. The valid values are **single**, **cluster** and **cluster.small**.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="vmSpecification")
    def vm_specification(self) -> _builtins.str:
        """
        The underlying VM specification.
        """
        return pulumi.get(self, "vm_specification")


@pulumi.output_type
class GetFlavorsFlavorIoResult(dict):
    def __init__(__self__, *,
                 availability_zones: Sequence[_builtins.str],
                 storage_spec_code: _builtins.str,
                 type: _builtins.str,
                 unavailability_zones: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] availability_zones: Specifies the list of availability zones with available resources.
        :param _builtins.str storage_spec_code: Specifies the disk IO encoding.
               + **dms.physical.storage.high.v2**: Type of the disk that uses high I/O.
               + **dms.physical.storage.ultra.v2**: Type of the disk that uses ultra-high I/O.
        :param _builtins.str type: Specifies flavor type. The valid values are **single**, **cluster** and **cluster.small**.
        :param Sequence[_builtins.str] unavailability_zones: The list of unavailability zones with available resources.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "storage_spec_code", storage_spec_code)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "unavailability_zones", unavailability_zones)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[_builtins.str]:
        """
        Specifies the list of availability zones with available resources.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> _builtins.str:
        """
        Specifies the disk IO encoding.
        + **dms.physical.storage.high.v2**: Type of the disk that uses high I/O.
        + **dms.physical.storage.ultra.v2**: Type of the disk that uses ultra-high I/O.
        """
        return pulumi.get(self, "storage_spec_code")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies flavor type. The valid values are **single**, **cluster** and **cluster.small**.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="unavailabilityZones")
    def unavailability_zones(self) -> Sequence[_builtins.str]:
        """
        The list of unavailability zones with available resources.
        """
        return pulumi.get(self, "unavailability_zones")


@pulumi.output_type
class GetFlavorsFlavorPropertyResult(dict):
    def __init__(__self__, *,
                 flavor_alias: _builtins.str,
                 max_bandwidth_per_broker: _builtins.int,
                 max_broker: _builtins.int,
                 max_consumer_per_broker: _builtins.int,
                 max_partition_per_broker: _builtins.int,
                 max_storage_per_node: _builtins.int,
                 max_tps_per_broker: _builtins.int,
                 min_broker: _builtins.int,
                 min_storage_per_node: _builtins.int):
        """
        :param _builtins.str flavor_alias: The flavor ID alias.
        :param _builtins.int max_bandwidth_per_broker: The maximum bandwidth per broker.
        :param _builtins.int max_broker: The maximum number of brokers.
        :param _builtins.int max_consumer_per_broker: The maximum number of consumers per broker.
        :param _builtins.int max_partition_per_broker: The maximum number of partitions per broker.
        :param _builtins.int max_storage_per_node: The maximum storage per node. The unit is GB.
        :param _builtins.int max_tps_per_broker: The maximum TPS per broker.
        :param _builtins.int min_broker: The minimum number of brokers.
        :param _builtins.int min_storage_per_node: The minimum storage per node. The unit is GB.
        """
        pulumi.set(__self__, "flavor_alias", flavor_alias)
        pulumi.set(__self__, "max_bandwidth_per_broker", max_bandwidth_per_broker)
        pulumi.set(__self__, "max_broker", max_broker)
        pulumi.set(__self__, "max_consumer_per_broker", max_consumer_per_broker)
        pulumi.set(__self__, "max_partition_per_broker", max_partition_per_broker)
        pulumi.set(__self__, "max_storage_per_node", max_storage_per_node)
        pulumi.set(__self__, "max_tps_per_broker", max_tps_per_broker)
        pulumi.set(__self__, "min_broker", min_broker)
        pulumi.set(__self__, "min_storage_per_node", min_storage_per_node)

    @_builtins.property
    @pulumi.getter(name="flavorAlias")
    def flavor_alias(self) -> _builtins.str:
        """
        The flavor ID alias.
        """
        return pulumi.get(self, "flavor_alias")

    @_builtins.property
    @pulumi.getter(name="maxBandwidthPerBroker")
    def max_bandwidth_per_broker(self) -> _builtins.int:
        """
        The maximum bandwidth per broker.
        """
        return pulumi.get(self, "max_bandwidth_per_broker")

    @_builtins.property
    @pulumi.getter(name="maxBroker")
    def max_broker(self) -> _builtins.int:
        """
        The maximum number of brokers.
        """
        return pulumi.get(self, "max_broker")

    @_builtins.property
    @pulumi.getter(name="maxConsumerPerBroker")
    def max_consumer_per_broker(self) -> _builtins.int:
        """
        The maximum number of consumers per broker.
        """
        return pulumi.get(self, "max_consumer_per_broker")

    @_builtins.property
    @pulumi.getter(name="maxPartitionPerBroker")
    def max_partition_per_broker(self) -> _builtins.int:
        """
        The maximum number of partitions per broker.
        """
        return pulumi.get(self, "max_partition_per_broker")

    @_builtins.property
    @pulumi.getter(name="maxStoragePerNode")
    def max_storage_per_node(self) -> _builtins.int:
        """
        The maximum storage per node. The unit is GB.
        """
        return pulumi.get(self, "max_storage_per_node")

    @_builtins.property
    @pulumi.getter(name="maxTpsPerBroker")
    def max_tps_per_broker(self) -> _builtins.int:
        """
        The maximum TPS per broker.
        """
        return pulumi.get(self, "max_tps_per_broker")

    @_builtins.property
    @pulumi.getter(name="minBroker")
    def min_broker(self) -> _builtins.int:
        """
        The minimum number of brokers.
        """
        return pulumi.get(self, "min_broker")

    @_builtins.property
    @pulumi.getter(name="minStoragePerNode")
    def min_storage_per_node(self) -> _builtins.int:
        """
        The minimum storage per node. The unit is GB.
        """
        return pulumi.get(self, "min_storage_per_node")


@pulumi.output_type
class GetFlavorsFlavorSupportFeatureResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 properties: Sequence['outputs.GetFlavorsFlavorSupportFeaturePropertyResult']):
        """
        :param _builtins.str name: The function name, e.g. **connector_obs**.
        :param Sequence['GetFlavorsFlavorSupportFeaturePropertyArgs'] properties: The function property details.
               The object structure is documented below.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The function name, e.g. **connector_obs**.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetFlavorsFlavorSupportFeaturePropertyResult']:
        """
        The function property details.
        The object structure is documented below.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class GetFlavorsFlavorSupportFeaturePropertyResult(dict):
    def __init__(__self__, *,
                 max_node: _builtins.int,
                 max_task: _builtins.int,
                 min_node: _builtins.int,
                 min_task: _builtins.int):
        """
        :param _builtins.int max_node: The maximum number of nodes for the dump function.
        :param _builtins.int max_task: The maximum number of tasks for the dump function.
        :param _builtins.int min_node: The minimum number of nodes for the dump function.
        :param _builtins.int min_task: The minimum number of tasks for the dump function.
        """
        pulumi.set(__self__, "max_node", max_node)
        pulumi.set(__self__, "max_task", max_task)
        pulumi.set(__self__, "min_node", min_node)
        pulumi.set(__self__, "min_task", min_task)

    @_builtins.property
    @pulumi.getter(name="maxNode")
    def max_node(self) -> _builtins.int:
        """
        The maximum number of nodes for the dump function.
        """
        return pulumi.get(self, "max_node")

    @_builtins.property
    @pulumi.getter(name="maxTask")
    def max_task(self) -> _builtins.int:
        """
        The maximum number of tasks for the dump function.
        """
        return pulumi.get(self, "max_task")

    @_builtins.property
    @pulumi.getter(name="minNode")
    def min_node(self) -> _builtins.int:
        """
        The minimum number of nodes for the dump function.
        """
        return pulumi.get(self, "min_node")

    @_builtins.property
    @pulumi.getter(name="minTask")
    def min_task(self) -> _builtins.int:
        """
        The minimum number of tasks for the dump function.
        """
        return pulumi.get(self, "min_task")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 access_user: _builtins.str,
                 availability_zones: Sequence[_builtins.str],
                 connect_address: _builtins.str,
                 cross_vpc_accesses: Sequence['outputs.GetInstancesInstanceCrossVpcAccessResult'],
                 description: _builtins.str,
                 dumping: _builtins.bool,
                 enable_auto_topic: _builtins.bool,
                 enable_public_ip: _builtins.bool,
                 enabled_mechanisms: Sequence[_builtins.str],
                 engine_version: _builtins.str,
                 enterprise_project_id: _builtins.str,
                 id: _builtins.str,
                 maintain_begin: _builtins.str,
                 maintain_end: _builtins.str,
                 management_connect_address: _builtins.str,
                 manager_user: _builtins.str,
                 manegement_connect_address: _builtins.str,
                 name: _builtins.str,
                 network_id: _builtins.str,
                 partition_num: _builtins.int,
                 port: _builtins.int,
                 product_id: _builtins.str,
                 public_conn_addresses: _builtins.str,
                 public_ip_ids: Sequence[_builtins.str],
                 resource_spec_code: _builtins.str,
                 retention_policy: _builtins.str,
                 security_group_id: _builtins.str,
                 security_protocol: _builtins.str,
                 ssl_enable: _builtins.bool,
                 status: _builtins.str,
                 storage_space: _builtins.int,
                 storage_spec_code: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 type: _builtins.str,
                 used_storage_space: _builtins.int,
                 user_id: _builtins.str,
                 user_name: _builtins.str,
                 vpc_id: _builtins.str):
        """
        :param _builtins.str access_user: The access username.
        :param Sequence[_builtins.str] availability_zones: The list of AZ names.
        :param _builtins.str connect_address: The IP address for instance connection.
        :param Sequence['GetInstancesInstanceCrossVpcAccessArgs'] cross_vpc_accesses: Indicates the Access information of cross-VPC. The structure is documented below.
        :param _builtins.str description: The instance description.
        :param _builtins.bool dumping: Whether to dumping is enabled.
        :param _builtins.bool enable_auto_topic: Whether to enable automatic topic creation.
        :param _builtins.bool enable_public_ip: Whether public access to the instance is enabled.
        :param _builtins.str engine_version: The kafka engine version.
        :param _builtins.str enterprise_project_id: Specifies the enterprise project ID to which all instances of the list
               belong.
        :param _builtins.str id: The instance ID.
        :param _builtins.str maintain_begin: The time at which a maintenance time window starts, the format is `HH:mm`.
        :param _builtins.str maintain_end: The time at which a maintenance time window ends, the format is `HH:mm`.
        :param _builtins.str management_connect_address: The connection address of the Kafka manager of an instance.
        :param _builtins.str manager_user: The username for logging in to the Kafka Manager.
        :param _builtins.str name: Specifies the kafka instance name for data-source queries.
        :param _builtins.str network_id: The subnet ID to which the instance belongs.
        :param _builtins.int partition_num: The maximum number of topics in the DMS kafka instance.
        :param _builtins.int port: The port number.
        :param _builtins.str product_id: The product ID used by the instance.
        :param _builtins.str public_conn_addresses: The instance public access address.
               The format of each connection address is `{IP address}:{port}`.
        :param Sequence[_builtins.str] public_ip_ids: The IDs of the elastic IP address (EIP).
        :param _builtins.str resource_spec_code: The resource specifications identifier.
        :param _builtins.str retention_policy: The action to be taken when the memory usage reaches the disk capacity threshold.
        :param _builtins.str security_group_id: The security group ID associated with the instance.
        :param _builtins.bool ssl_enable: Whether the Kafka SASL_SSL is enabled.
        :param _builtins.str status: Specifies the kafka instance status for data-source queries.
        :param _builtins.int storage_space: The message storage capacity, in GB unit.
        :param _builtins.str storage_spec_code: The storage I/O specification.
        :param Mapping[str, _builtins.str] tags: The key/value pairs to associate with the instance.
        :param _builtins.str type: The instance type.
        :param _builtins.int used_storage_space: The used message storage space, in GB unit.
        :param _builtins.str user_id: The user ID who created the instance.
        :param _builtins.str user_name: The username who created the instance.
        :param _builtins.str vpc_id: The VPC ID to which the instance belongs.
        """
        pulumi.set(__self__, "access_user", access_user)
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "connect_address", connect_address)
        pulumi.set(__self__, "cross_vpc_accesses", cross_vpc_accesses)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "dumping", dumping)
        pulumi.set(__self__, "enable_auto_topic", enable_auto_topic)
        pulumi.set(__self__, "enable_public_ip", enable_public_ip)
        pulumi.set(__self__, "enabled_mechanisms", enabled_mechanisms)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "maintain_begin", maintain_begin)
        pulumi.set(__self__, "maintain_end", maintain_end)
        pulumi.set(__self__, "management_connect_address", management_connect_address)
        pulumi.set(__self__, "manager_user", manager_user)
        pulumi.set(__self__, "manegement_connect_address", manegement_connect_address)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "partition_num", partition_num)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "product_id", product_id)
        pulumi.set(__self__, "public_conn_addresses", public_conn_addresses)
        pulumi.set(__self__, "public_ip_ids", public_ip_ids)
        pulumi.set(__self__, "resource_spec_code", resource_spec_code)
        pulumi.set(__self__, "retention_policy", retention_policy)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "security_protocol", security_protocol)
        pulumi.set(__self__, "ssl_enable", ssl_enable)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage_space", storage_space)
        pulumi.set(__self__, "storage_spec_code", storage_spec_code)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "used_storage_space", used_storage_space)
        pulumi.set(__self__, "user_id", user_id)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> _builtins.str:
        """
        The access username.
        """
        return pulumi.get(self, "access_user")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[_builtins.str]:
        """
        The list of AZ names.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="connectAddress")
    def connect_address(self) -> _builtins.str:
        """
        The IP address for instance connection.
        """
        return pulumi.get(self, "connect_address")

    @_builtins.property
    @pulumi.getter(name="crossVpcAccesses")
    def cross_vpc_accesses(self) -> Sequence['outputs.GetInstancesInstanceCrossVpcAccessResult']:
        """
        Indicates the Access information of cross-VPC. The structure is documented below.
        """
        return pulumi.get(self, "cross_vpc_accesses")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The instance description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def dumping(self) -> _builtins.bool:
        """
        Whether to dumping is enabled.
        """
        return pulumi.get(self, "dumping")

    @_builtins.property
    @pulumi.getter(name="enableAutoTopic")
    def enable_auto_topic(self) -> _builtins.bool:
        """
        Whether to enable automatic topic creation.
        """
        return pulumi.get(self, "enable_auto_topic")

    @_builtins.property
    @pulumi.getter(name="enablePublicIp")
    def enable_public_ip(self) -> _builtins.bool:
        """
        Whether public access to the instance is enabled.
        """
        return pulumi.get(self, "enable_public_ip")

    @_builtins.property
    @pulumi.getter(name="enabledMechanisms")
    def enabled_mechanisms(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "enabled_mechanisms")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> _builtins.str:
        """
        The kafka engine version.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        """
        Specifies the enterprise project ID to which all instances of the list
        belong.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The instance ID.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> _builtins.str:
        """
        The time at which a maintenance time window starts, the format is `HH:mm`.
        """
        return pulumi.get(self, "maintain_begin")

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> _builtins.str:
        """
        The time at which a maintenance time window ends, the format is `HH:mm`.
        """
        return pulumi.get(self, "maintain_end")

    @_builtins.property
    @pulumi.getter(name="managementConnectAddress")
    def management_connect_address(self) -> _builtins.str:
        """
        The connection address of the Kafka manager of an instance.
        """
        return pulumi.get(self, "management_connect_address")

    @_builtins.property
    @pulumi.getter(name="managerUser")
    def manager_user(self) -> _builtins.str:
        """
        The username for logging in to the Kafka Manager.
        """
        return pulumi.get(self, "manager_user")

    @_builtins.property
    @pulumi.getter(name="manegementConnectAddress")
    @_utilities.deprecated("""typo in manegement_connect_address, please use \"management_connect_address\" instead.""")
    def manegement_connect_address(self) -> _builtins.str:
        return pulumi.get(self, "manegement_connect_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the kafka instance name for data-source queries.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> _builtins.str:
        """
        The subnet ID to which the instance belongs.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="partitionNum")
    def partition_num(self) -> _builtins.int:
        """
        The maximum number of topics in the DMS kafka instance.
        """
        return pulumi.get(self, "partition_num")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port number.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> _builtins.str:
        """
        The product ID used by the instance.
        """
        return pulumi.get(self, "product_id")

    @_builtins.property
    @pulumi.getter(name="publicConnAddresses")
    def public_conn_addresses(self) -> _builtins.str:
        """
        The instance public access address.
        The format of each connection address is `{IP address}:{port}`.
        """
        return pulumi.get(self, "public_conn_addresses")

    @_builtins.property
    @pulumi.getter(name="publicIpIds")
    def public_ip_ids(self) -> Sequence[_builtins.str]:
        """
        The IDs of the elastic IP address (EIP).
        """
        return pulumi.get(self, "public_ip_ids")

    @_builtins.property
    @pulumi.getter(name="resourceSpecCode")
    def resource_spec_code(self) -> _builtins.str:
        """
        The resource specifications identifier.
        """
        return pulumi.get(self, "resource_spec_code")

    @_builtins.property
    @pulumi.getter(name="retentionPolicy")
    def retention_policy(self) -> _builtins.str:
        """
        The action to be taken when the memory usage reaches the disk capacity threshold.
        """
        return pulumi.get(self, "retention_policy")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> _builtins.str:
        """
        The security group ID associated with the instance.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter(name="securityProtocol")
    def security_protocol(self) -> _builtins.str:
        return pulumi.get(self, "security_protocol")

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> _builtins.bool:
        """
        Whether the Kafka SASL_SSL is enabled.
        """
        return pulumi.get(self, "ssl_enable")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Specifies the kafka instance status for data-source queries.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> _builtins.int:
        """
        The message storage capacity, in GB unit.
        """
        return pulumi.get(self, "storage_space")

    @_builtins.property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> _builtins.str:
        """
        The storage I/O specification.
        """
        return pulumi.get(self, "storage_spec_code")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The key/value pairs to associate with the instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The instance type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="usedStorageSpace")
    def used_storage_space(self) -> _builtins.int:
        """
        The used message storage space, in GB unit.
        """
        return pulumi.get(self, "used_storage_space")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        """
        The user ID who created the instance.
        """
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> _builtins.str:
        """
        The username who created the instance.
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The VPC ID to which the instance belongs.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class GetInstancesInstanceCrossVpcAccessResult(dict):
    def __init__(__self__, *,
                 advertised_ip: _builtins.str,
                 lisenter_ip: _builtins.str,
                 listener_ip: _builtins.str,
                 port: _builtins.int,
                 port_id: _builtins.str):
        """
        :param _builtins.str advertised_ip: The advertised IP Address.
        :param _builtins.str listener_ip: The listener IP address.
        :param _builtins.int port: The port number.
        :param _builtins.str port_id: The port ID associated with the address
        """
        pulumi.set(__self__, "advertised_ip", advertised_ip)
        pulumi.set(__self__, "lisenter_ip", lisenter_ip)
        pulumi.set(__self__, "listener_ip", listener_ip)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "port_id", port_id)

    @_builtins.property
    @pulumi.getter(name="advertisedIp")
    def advertised_ip(self) -> _builtins.str:
        """
        The advertised IP Address.
        """
        return pulumi.get(self, "advertised_ip")

    @_builtins.property
    @pulumi.getter(name="lisenterIp")
    @_utilities.deprecated("""typo in lisenter_ip, please use \"listener_ip\" instead.""")
    def lisenter_ip(self) -> _builtins.str:
        return pulumi.get(self, "lisenter_ip")

    @_builtins.property
    @pulumi.getter(name="listenerIp")
    def listener_ip(self) -> _builtins.str:
        """
        The listener IP address.
        """
        return pulumi.get(self, "listener_ip")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The port number.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> _builtins.str:
        """
        The port ID associated with the address
        """
        return pulumi.get(self, "port_id")


