# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RabbitmqInstanceArgs', 'RabbitmqInstance']

@pulumi.input_type
class RabbitmqInstanceArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[_builtins.str],
                 security_group_id: pulumi.Input[_builtins.str],
                 storage_spec_code: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 access_user: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 broker_num: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_acl: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a RabbitmqInstance resource.
        :param pulumi.Input[_builtins.str] network_id: Specifies the ID of a subnet. Changing this creates a new instance
               resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[_builtins.str] storage_spec_code: Specifies the storage I/O specification.
               Valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] access_user: Specifies a username. A username consists of 4 to 64 characters and
               supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the names of an AZ.
               The parameter value can not be left blank or an empty array.
               Changing this creates a new instance resource.
               
               > The parameter behavior of `availability_zones` has been changed from `list` to `set`.
        :param pulumi.Input[_builtins.int] broker_num: Specifies the broker numbers.
               It is required when creating a cluster instance with `flavor_id`.
               
               > **NOTE:** Change this will change number of nodes and storage capacity. If you specify the value of
               `storage_space`, you need to manually modify the value of `storage_space` after changing the `broker_num`.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the instance. Valid values are
               **prePaid** and **postPaid**, defaults to **postPaid**. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the DMS RabbitMQ instance.
               It is a character string containing not more than 1,024 characters.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the version of the RabbitMQ engine. Default to "3.7.17".
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID of the RabbitMQ instance.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies a flavor ID.
               It is mandatory when the `charging_mode` is **prePaid**.
        :param pulumi.Input[_builtins.str] maintain_begin: Specifies the time at which a maintenance time window starts. Format: HH:mm.
               The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
               blank. In this case, the system automatically allocates the default start time 02:00.
        :param pulumi.Input[_builtins.str] maintain_end: Specifies the time at which a maintenance time window ends. Format: HH:mm.
               The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window. The end time is four hours later than the start time.
               For example, if the start time is 22:00, the end time is 02:00.
               Parameters `maintain_begin` and `maintain_end` must be set in pairs.
               If parameter `maintain_end` is left  blank, parameter `maintain_begin` is also blank.
               In this case, the system automatically allocates the default end time 06:00.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the DMS RabbitMQ instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        :param pulumi.Input[_builtins.str] password: Specifies the password of the DMS RabbitMQ instance. A password must meet
               the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following
               character types: lowercase letters, uppercase letters, digits,
               and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance. If `period_unit` is set to
               **month**, the value ranges from 1 to 9. If `period_unit` is set to **year**, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] public_ip_id: Specifies the ID of the elastic IP address (EIP)
               bound to the DMS RabbitMQ instance.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DMS RabbitMQ instance resource. If omitted,
               the provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.bool] ssl_enable: Specifies whether to enable public access for the DMS RabbitMQ instance.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.int] storage_space: Specifies the message storage space, unit is GB.
               It is required when creating a instance with `flavor_id`. Value range:
               + Single-node RabbitMQ instance: 100–90000 GB
               + Cluster RabbitMQ instance: 100 GB x Number of nodes to 90000 GB, 200 GB x Number of nodes to 90000 GB,
               and 300 GB x Number of nodes to 90000 GB
               
               Changing this creates a new instance resource.
               
               The storage capacity of the product used by default. Changing this creates a new instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the DMS RabbitMQ instance.
        """
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "storage_spec_code", storage_spec_code)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if access_user is not None:
            pulumi.set(__self__, "access_user", access_user)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_zones is not None:
            warnings.warn("""available_zones has deprecated, please use \"availability_zones\" instead.""", DeprecationWarning)
            pulumi.log.warn("""available_zones is deprecated: available_zones has deprecated, please use \"availability_zones\" instead.""")
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if broker_num is not None:
            pulumi.set(__self__, "broker_num", broker_num)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_acl is not None:
            pulumi.set(__self__, "enable_acl", enable_acl)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if product_id is not None:
            warnings.warn("""product_id has deprecated, please use \"flavor_id\" instead.""", DeprecationWarning)
            pulumi.log.warn("""product_id is deprecated: product_id has deprecated, please use \"flavor_id\" instead.""")
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if public_ip_id is not None:
            pulumi.set(__self__, "public_ip_id", public_ip_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if storage_space is not None:
            pulumi.set(__self__, "storage_space", storage_space)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of a subnet. Changing this creates a new instance
        resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of a security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the storage I/O specification.
        Valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "storage_spec_code")

    @storage_spec_code.setter
    def storage_spec_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_spec_code", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a username. A username consists of 4 to 64 characters and
        supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        """
        return pulumi.get(self, "access_user")

    @access_user.setter
    def access_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_user", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the names of an AZ.
        The parameter value can not be left blank or an empty array.
        Changing this creates a new instance resource.

        > The parameter behavior of `availability_zones` has been changed from `list` to `set`.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="availableZones")
    @_utilities.deprecated("""available_zones has deprecated, please use \"availability_zones\" instead.""")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "available_zones", value)

    @_builtins.property
    @pulumi.getter(name="brokerNum")
    def broker_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the broker numbers.
        It is required when creating a cluster instance with `flavor_id`.

        > **NOTE:** Change this will change number of nodes and storage capacity. If you specify the value of
        `storage_space`, you need to manually modify the value of `storage_space` after changing the `broker_num`.
        """
        return pulumi.get(self, "broker_num")

    @broker_num.setter
    def broker_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "broker_num", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the instance. Valid values are
        **prePaid** and **postPaid**, defaults to **postPaid**. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the DMS RabbitMQ instance.
        It is a character string containing not more than 1,024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableAcl")
    def enable_acl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enable_acl")

    @enable_acl.setter
    def enable_acl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_acl", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of the RabbitMQ engine. Default to "3.7.17".
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID of the RabbitMQ instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a flavor ID.
        It is mandatory when the `charging_mode` is **prePaid**.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time at which a maintenance time window starts. Format: HH:mm.
        The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
        blank. In this case, the system automatically allocates the default start time 02:00.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_begin", value)

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time at which a maintenance time window ends. Format: HH:mm.
        The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window. The end time is four hours later than the start time.
        For example, if the start time is 22:00, the end time is 02:00.
        Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        If parameter `maintain_end` is left  blank, parameter `maintain_begin` is also blank.
        In this case, the system automatically allocates the default end time 06:00.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the DMS RabbitMQ instance. An instance name starts with a letter,
        consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password of the DMS RabbitMQ instance. A password must meet
        the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following
        character types: lowercase letters, uppercase letters, digits,
        and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the instance. If `period_unit` is set to
        **month**, the value ranges from 1 to 9. If `period_unit` is set to **year**, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    @_utilities.deprecated("""product_id has deprecated, please use \"flavor_id\" instead.""")
    def product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the elastic IP address (EIP)
        bound to the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "public_ip_id")

    @public_ip_id.setter
    def public_ip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the DMS RabbitMQ instance resource. If omitted,
        the provider-level region will be used. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable public access for the DMS RabbitMQ instance.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_enable", value)

    @_builtins.property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the message storage space, unit is GB.
        It is required when creating a instance with `flavor_id`. Value range:
        + Single-node RabbitMQ instance: 100–90000 GB
        + Cluster RabbitMQ instance: 100 GB x Number of nodes to 90000 GB, 200 GB x Number of nodes to 90000 GB,
        and 300 GB x Number of nodes to 90000 GB

        Changing this creates a new instance resource.

        The storage capacity of the product used by default. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "storage_space")

    @storage_space.setter
    def storage_space(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_space", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RabbitmqInstanceState:
    def __init__(__self__, *,
                 access_user: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 broker_num: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connect_address: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_acl: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 extend_times: Optional[pulumi.Input[_builtins.int]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 is_logical_volume: Optional[pulumi.Input[_builtins.bool]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 management_connect_address: Optional[pulumi.Input[_builtins.str]] = None,
                 manegement_connect_address: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 used_storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RabbitmqInstance resources.
        :param pulumi.Input[_builtins.str] access_user: Specifies a username. A username consists of 4 to 64 characters and
               supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the names of an AZ.
               The parameter value can not be left blank or an empty array.
               Changing this creates a new instance resource.
               
               > The parameter behavior of `availability_zones` has been changed from `list` to `set`.
        :param pulumi.Input[_builtins.int] broker_num: Specifies the broker numbers.
               It is required when creating a cluster instance with `flavor_id`.
               
               > **NOTE:** Change this will change number of nodes and storage capacity. If you specify the value of
               `storage_space`, you need to manually modify the value of `storage_space` after changing the `broker_num`.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the instance. Valid values are
               **prePaid** and **postPaid**, defaults to **postPaid**. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] connect_address: Indicates the IP address of the DMS RabbitMQ instance.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the DMS RabbitMQ instance.
               It is a character string containing not more than 1,024 characters.
        :param pulumi.Input[_builtins.bool] enable_public_ip: Indicates whether public access to the DMS RabbitMQ instance is enabled.
        :param pulumi.Input[_builtins.str] engine: Indicates the message engine.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the version of the RabbitMQ engine. Default to "3.7.17".
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID of the RabbitMQ instance.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies a flavor ID.
               It is mandatory when the `charging_mode` is **prePaid**.
        :param pulumi.Input[_builtins.str] maintain_begin: Specifies the time at which a maintenance time window starts. Format: HH:mm.
               The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
               blank. In this case, the system automatically allocates the default start time 02:00.
        :param pulumi.Input[_builtins.str] maintain_end: Specifies the time at which a maintenance time window ends. Format: HH:mm.
               The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window. The end time is four hours later than the start time.
               For example, if the start time is 22:00, the end time is 02:00.
               Parameters `maintain_begin` and `maintain_end` must be set in pairs.
               If parameter `maintain_end` is left  blank, parameter `maintain_begin` is also blank.
               In this case, the system automatically allocates the default end time 06:00.
        :param pulumi.Input[_builtins.str] management_connect_address: Indicates the management address of the DMS RabbitMQ instance.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the DMS RabbitMQ instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        :param pulumi.Input[_builtins.str] network_id: Specifies the ID of a subnet. Changing this creates a new instance
               resource.
        :param pulumi.Input[_builtins.str] password: Specifies the password of the DMS RabbitMQ instance. A password must meet
               the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following
               character types: lowercase letters, uppercase letters, digits,
               and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance. If `period_unit` is set to
               **month**, the value ranges from 1 to 9. If `period_unit` is set to **year**, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] port: Indicates the port number of the DMS RabbitMQ instance.
        :param pulumi.Input[_builtins.str] public_ip_id: Specifies the ID of the elastic IP address (EIP)
               bound to the DMS RabbitMQ instance.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DMS RabbitMQ instance resource. If omitted,
               the provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] resource_spec_code: Indicates a resource specifications identifier.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[_builtins.str] specification: Indicates the instance specification. For a single-node DMS RabbitMQ instance, VM specifications are
               returned. For a cluster DMS RabbitMQ instance, VM specifications and the number of nodes are returned.
        :param pulumi.Input[_builtins.bool] ssl_enable: Specifies whether to enable public access for the DMS RabbitMQ instance.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] status: Indicates the status of the DMS RabbitMQ instance.
        :param pulumi.Input[_builtins.int] storage_space: Specifies the message storage space, unit is GB.
               It is required when creating a instance with `flavor_id`. Value range:
               + Single-node RabbitMQ instance: 100–90000 GB
               + Cluster RabbitMQ instance: 100 GB x Number of nodes to 90000 GB, 200 GB x Number of nodes to 90000 GB,
               and 300 GB x Number of nodes to 90000 GB
               
               Changing this creates a new instance resource.
               
               The storage capacity of the product used by default. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] storage_spec_code: Specifies the storage I/O specification.
               Valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
               Changing this creates a new instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the DMS RabbitMQ instance.
        :param pulumi.Input[_builtins.str] type: Indicates the DMS RabbitMQ instance type.
        :param pulumi.Input[_builtins.int] used_storage_space: Indicates the used message storage space. Unit: GB
        :param pulumi.Input[_builtins.str] user_id: Indicates the ID of the user who created the DMS RabbitMQ instance
        :param pulumi.Input[_builtins.str] user_name: Indicates the name of the user who created the DMS RabbitMQ instance
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        if access_user is not None:
            pulumi.set(__self__, "access_user", access_user)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if available_zones is not None:
            warnings.warn("""available_zones has deprecated, please use \"availability_zones\" instead.""", DeprecationWarning)
            pulumi.log.warn("""available_zones is deprecated: available_zones has deprecated, please use \"availability_zones\" instead.""")
        if available_zones is not None:
            pulumi.set(__self__, "available_zones", available_zones)
        if broker_num is not None:
            pulumi.set(__self__, "broker_num", broker_num)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if connect_address is not None:
            pulumi.set(__self__, "connect_address", connect_address)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_acl is not None:
            pulumi.set(__self__, "enable_acl", enable_acl)
        if enable_public_ip is not None:
            pulumi.set(__self__, "enable_public_ip", enable_public_ip)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if extend_times is not None:
            pulumi.set(__self__, "extend_times", extend_times)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if is_logical_volume is not None:
            pulumi.set(__self__, "is_logical_volume", is_logical_volume)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if management_connect_address is not None:
            pulumi.set(__self__, "management_connect_address", management_connect_address)
        if manegement_connect_address is not None:
            warnings.warn("""typo in manegement_connect_address, please use \"management_connect_address\" instead.""", DeprecationWarning)
            pulumi.log.warn("""manegement_connect_address is deprecated: typo in manegement_connect_address, please use \"management_connect_address\" instead.""")
        if manegement_connect_address is not None:
            pulumi.set(__self__, "manegement_connect_address", manegement_connect_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if product_id is not None:
            warnings.warn("""product_id has deprecated, please use \"flavor_id\" instead.""", DeprecationWarning)
            pulumi.log.warn("""product_id is deprecated: product_id has deprecated, please use \"flavor_id\" instead.""")
        if product_id is not None:
            pulumi.set(__self__, "product_id", product_id)
        if public_ip_address is not None:
            pulumi.set(__self__, "public_ip_address", public_ip_address)
        if public_ip_id is not None:
            pulumi.set(__self__, "public_ip_id", public_ip_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_spec_code is not None:
            pulumi.set(__self__, "resource_spec_code", resource_spec_code)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_space is not None:
            pulumi.set(__self__, "storage_space", storage_space)
        if storage_spec_code is not None:
            pulumi.set(__self__, "storage_spec_code", storage_spec_code)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if used_storage_space is not None:
            pulumi.set(__self__, "used_storage_space", used_storage_space)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a username. A username consists of 4 to 64 characters and
        supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        """
        return pulumi.get(self, "access_user")

    @access_user.setter
    def access_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_user", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the names of an AZ.
        The parameter value can not be left blank or an empty array.
        Changing this creates a new instance resource.

        > The parameter behavior of `availability_zones` has been changed from `list` to `set`.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="availableZones")
    @_utilities.deprecated("""available_zones has deprecated, please use \"availability_zones\" instead.""")
    def available_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "available_zones")

    @available_zones.setter
    def available_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "available_zones", value)

    @_builtins.property
    @pulumi.getter(name="brokerNum")
    def broker_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the broker numbers.
        It is required when creating a cluster instance with `flavor_id`.

        > **NOTE:** Change this will change number of nodes and storage capacity. If you specify the value of
        `storage_space`, you need to manually modify the value of `storage_space` after changing the `broker_num`.
        """
        return pulumi.get(self, "broker_num")

    @broker_num.setter
    def broker_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "broker_num", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the instance. Valid values are
        **prePaid** and **postPaid**, defaults to **postPaid**. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="connectAddress")
    def connect_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the IP address of the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "connect_address")

    @connect_address.setter
    def connect_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connect_address", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the DMS RabbitMQ instance.
        It is a character string containing not more than 1,024 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableAcl")
    def enable_acl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "enable_acl")

    @enable_acl.setter
    def enable_acl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_acl", value)

    @_builtins.property
    @pulumi.getter(name="enablePublicIp")
    def enable_public_ip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether public access to the DMS RabbitMQ instance is enabled.
        """
        return pulumi.get(self, "enable_public_ip")

    @enable_public_ip.setter
    def enable_public_ip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_public_ip", value)

    @_builtins.property
    @pulumi.getter
    def engine(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the message engine.
        """
        return pulumi.get(self, "engine")

    @engine.setter
    def engine(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of the RabbitMQ engine. Default to "3.7.17".
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project ID of the RabbitMQ instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="extendTimes")
    def extend_times(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "extend_times")

    @extend_times.setter
    def extend_times(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "extend_times", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a flavor ID.
        It is mandatory when the `charging_mode` is **prePaid**.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="isLogicalVolume")
    def is_logical_volume(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "is_logical_volume")

    @is_logical_volume.setter
    def is_logical_volume(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_logical_volume", value)

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time at which a maintenance time window starts. Format: HH:mm.
        The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
        blank. In this case, the system automatically allocates the default start time 02:00.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_begin", value)

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time at which a maintenance time window ends. Format: HH:mm.
        The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window. The end time is four hours later than the start time.
        For example, if the start time is 22:00, the end time is 02:00.
        Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        If parameter `maintain_end` is left  blank, parameter `maintain_begin` is also blank.
        In this case, the system automatically allocates the default end time 06:00.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end", value)

    @_builtins.property
    @pulumi.getter(name="managementConnectAddress")
    def management_connect_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the management address of the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "management_connect_address")

    @management_connect_address.setter
    def management_connect_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_connect_address", value)

    @_builtins.property
    @pulumi.getter(name="manegementConnectAddress")
    @_utilities.deprecated("""typo in manegement_connect_address, please use \"management_connect_address\" instead.""")
    def manegement_connect_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "manegement_connect_address")

    @manegement_connect_address.setter
    def manegement_connect_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "manegement_connect_address", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the DMS RabbitMQ instance. An instance name starts with a letter,
        consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a subnet. Changing this creates a new instance
        resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password of the DMS RabbitMQ instance. A password must meet
        the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following
        character types: lowercase letters, uppercase letters, digits,
        and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the instance. If `period_unit` is set to
        **month**, the value ranges from 1 to 9. If `period_unit` is set to **year**, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the port number of the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="productId")
    @_utilities.deprecated("""product_id has deprecated, please use \"flavor_id\" instead.""")
    def product_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "product_id")

    @product_id.setter
    def product_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product_id", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "public_ip_address")

    @public_ip_address.setter
    def public_ip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the elastic IP address (EIP)
        bound to the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "public_ip_id")

    @public_ip_id.setter
    def public_ip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the DMS RabbitMQ instance resource. If omitted,
        the provider-level region will be used. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceSpecCode")
    def resource_spec_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates a resource specifications identifier.
        """
        return pulumi.get(self, "resource_spec_code")

    @resource_spec_code.setter
    def resource_spec_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_spec_code", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the instance specification. For a single-node DMS RabbitMQ instance, VM specifications are
        returned. For a cluster DMS RabbitMQ instance, VM specifications and the number of nodes are returned.
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "specification", value)

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable public access for the DMS RabbitMQ instance.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_enable", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the status of the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the message storage space, unit is GB.
        It is required when creating a instance with `flavor_id`. Value range:
        + Single-node RabbitMQ instance: 100–90000 GB
        + Cluster RabbitMQ instance: 100 GB x Number of nodes to 90000 GB, 200 GB x Number of nodes to 90000 GB,
        and 300 GB x Number of nodes to 90000 GB

        Changing this creates a new instance resource.

        The storage capacity of the product used by default. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "storage_space")

    @storage_space.setter
    def storage_space(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_space", value)

    @_builtins.property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the storage I/O specification.
        Valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "storage_spec_code")

    @storage_spec_code.setter
    def storage_spec_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_spec_code", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the DMS RabbitMQ instance type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="usedStorageSpace")
    def used_storage_space(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the used message storage space. Unit: GB
        """
        return pulumi.get(self, "used_storage_space")

    @used_storage_space.setter
    def used_storage_space(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used_storage_space", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the ID of the user who created the DMS RabbitMQ instance
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the name of the user who created the DMS RabbitMQ instance
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:Dms/rabbitmqInstance:RabbitmqInstance")
class RabbitmqInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_user: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 broker_num: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_acl: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage DMS RabbitMQ instance resources within SberCloud.

        ## Example Usage

        ## Import

        DMS RabbitMQ instance can be imported using the instance id, e.g.

        ```sh
        $ pulumi import sbercloud:Dms/rabbitmqInstance:RabbitmqInstance  sbercloud_dms_rabbitmq_instance.instance_1 8d3c7938-dc47-4937-a30f-c80de381c5e3
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include:

        `password`, `auto_renew`, `period` and `period_unit`. It is generally recommended running `pulumi preview` after

        importing a DMS RabbitMQ instance. You can then decide if changes should be applied to the instance, or the resource

        definition should be updated to align with the instance. Also you can ignore changes as below.

        resource "sbercloud_dms_rabbitmq_instance" "instance_1" {

            ...

          lifecycle {

            ignore_changes = [
            
              password, auto_renew, period, period_unit,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_user: Specifies a username. A username consists of 4 to 64 characters and
               supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the names of an AZ.
               The parameter value can not be left blank or an empty array.
               Changing this creates a new instance resource.
               
               > The parameter behavior of `availability_zones` has been changed from `list` to `set`.
        :param pulumi.Input[_builtins.int] broker_num: Specifies the broker numbers.
               It is required when creating a cluster instance with `flavor_id`.
               
               > **NOTE:** Change this will change number of nodes and storage capacity. If you specify the value of
               `storage_space`, you need to manually modify the value of `storage_space` after changing the `broker_num`.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the instance. Valid values are
               **prePaid** and **postPaid**, defaults to **postPaid**. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the DMS RabbitMQ instance.
               It is a character string containing not more than 1,024 characters.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the version of the RabbitMQ engine. Default to "3.7.17".
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID of the RabbitMQ instance.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies a flavor ID.
               It is mandatory when the `charging_mode` is **prePaid**.
        :param pulumi.Input[_builtins.str] maintain_begin: Specifies the time at which a maintenance time window starts. Format: HH:mm.
               The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
               blank. In this case, the system automatically allocates the default start time 02:00.
        :param pulumi.Input[_builtins.str] maintain_end: Specifies the time at which a maintenance time window ends. Format: HH:mm.
               The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window. The end time is four hours later than the start time.
               For example, if the start time is 22:00, the end time is 02:00.
               Parameters `maintain_begin` and `maintain_end` must be set in pairs.
               If parameter `maintain_end` is left  blank, parameter `maintain_begin` is also blank.
               In this case, the system automatically allocates the default end time 06:00.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the DMS RabbitMQ instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        :param pulumi.Input[_builtins.str] network_id: Specifies the ID of a subnet. Changing this creates a new instance
               resource.
        :param pulumi.Input[_builtins.str] password: Specifies the password of the DMS RabbitMQ instance. A password must meet
               the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following
               character types: lowercase letters, uppercase letters, digits,
               and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance. If `period_unit` is set to
               **month**, the value ranges from 1 to 9. If `period_unit` is set to **year**, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] public_ip_id: Specifies the ID of the elastic IP address (EIP)
               bound to the DMS RabbitMQ instance.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DMS RabbitMQ instance resource. If omitted,
               the provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[_builtins.bool] ssl_enable: Specifies whether to enable public access for the DMS RabbitMQ instance.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.int] storage_space: Specifies the message storage space, unit is GB.
               It is required when creating a instance with `flavor_id`. Value range:
               + Single-node RabbitMQ instance: 100–90000 GB
               + Cluster RabbitMQ instance: 100 GB x Number of nodes to 90000 GB, 200 GB x Number of nodes to 90000 GB,
               and 300 GB x Number of nodes to 90000 GB
               
               Changing this creates a new instance resource.
               
               The storage capacity of the product used by default. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] storage_spec_code: Specifies the storage I/O specification.
               Valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
               Changing this creates a new instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the DMS RabbitMQ instance.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RabbitmqInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage DMS RabbitMQ instance resources within SberCloud.

        ## Example Usage

        ## Import

        DMS RabbitMQ instance can be imported using the instance id, e.g.

        ```sh
        $ pulumi import sbercloud:Dms/rabbitmqInstance:RabbitmqInstance  sbercloud_dms_rabbitmq_instance.instance_1 8d3c7938-dc47-4937-a30f-c80de381c5e3
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include:

        `password`, `auto_renew`, `period` and `period_unit`. It is generally recommended running `pulumi preview` after

        importing a DMS RabbitMQ instance. You can then decide if changes should be applied to the instance, or the resource

        definition should be updated to align with the instance. Also you can ignore changes as below.

        resource "sbercloud_dms_rabbitmq_instance" "instance_1" {

            ...

          lifecycle {

            ignore_changes = [
            
              password, auto_renew, period, period_unit,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param RabbitmqInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RabbitmqInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_user: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 broker_num: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_acl: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 product_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RabbitmqInstanceArgs.__new__(RabbitmqInstanceArgs)

            __props__.__dict__["access_user"] = access_user
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["available_zones"] = available_zones
            __props__.__dict__["broker_num"] = broker_num
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_acl"] = enable_acl
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["flavor_id"] = flavor_id
            __props__.__dict__["maintain_begin"] = maintain_begin
            __props__.__dict__["maintain_end"] = maintain_end
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["product_id"] = product_id
            __props__.__dict__["public_ip_id"] = public_ip_id
            __props__.__dict__["region"] = region
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["ssl_enable"] = ssl_enable
            __props__.__dict__["storage_space"] = storage_space
            if storage_spec_code is None and not opts.urn:
                raise TypeError("Missing required property 'storage_spec_code'")
            __props__.__dict__["storage_spec_code"] = storage_spec_code
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["connect_address"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["enable_public_ip"] = None
            __props__.__dict__["engine"] = None
            __props__.__dict__["extend_times"] = None
            __props__.__dict__["is_logical_volume"] = None
            __props__.__dict__["management_connect_address"] = None
            __props__.__dict__["manegement_connect_address"] = None
            __props__.__dict__["port"] = None
            __props__.__dict__["public_ip_address"] = None
            __props__.__dict__["resource_spec_code"] = None
            __props__.__dict__["specification"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["used_storage_space"] = None
            __props__.__dict__["user_id"] = None
            __props__.__dict__["user_name"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RabbitmqInstance, __self__).__init__(
            'sbercloud:Dms/rabbitmqInstance:RabbitmqInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_user: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            available_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            broker_num: Optional[pulumi.Input[_builtins.int]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            connect_address: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_acl: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_public_ip: Optional[pulumi.Input[_builtins.bool]] = None,
            engine: Optional[pulumi.Input[_builtins.str]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            extend_times: Optional[pulumi.Input[_builtins.int]] = None,
            flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
            is_logical_volume: Optional[pulumi.Input[_builtins.bool]] = None,
            maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
            management_connect_address: Optional[pulumi.Input[_builtins.str]] = None,
            manegement_connect_address: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            product_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip_address: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            specification: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_space: Optional[pulumi.Input[_builtins.int]] = None,
            storage_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            used_storage_space: Optional[pulumi.Input[_builtins.int]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'RabbitmqInstance':
        """
        Get an existing RabbitmqInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_user: Specifies a username. A username consists of 4 to 64 characters and
               supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the names of an AZ.
               The parameter value can not be left blank or an empty array.
               Changing this creates a new instance resource.
               
               > The parameter behavior of `availability_zones` has been changed from `list` to `set`.
        :param pulumi.Input[_builtins.int] broker_num: Specifies the broker numbers.
               It is required when creating a cluster instance with `flavor_id`.
               
               > **NOTE:** Change this will change number of nodes and storage capacity. If you specify the value of
               `storage_space`, you need to manually modify the value of `storage_space` after changing the `broker_num`.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the instance. Valid values are
               **prePaid** and **postPaid**, defaults to **postPaid**. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] connect_address: Indicates the IP address of the DMS RabbitMQ instance.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the DMS RabbitMQ instance.
               It is a character string containing not more than 1,024 characters.
        :param pulumi.Input[_builtins.bool] enable_public_ip: Indicates whether public access to the DMS RabbitMQ instance is enabled.
        :param pulumi.Input[_builtins.str] engine: Indicates the message engine.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the version of the RabbitMQ engine. Default to "3.7.17".
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project ID of the RabbitMQ instance.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies a flavor ID.
               It is mandatory when the `charging_mode` is **prePaid**.
        :param pulumi.Input[_builtins.str] maintain_begin: Specifies the time at which a maintenance time window starts. Format: HH:mm.
               The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window.
               The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
               and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
               blank. In this case, the system automatically allocates the default start time 02:00.
        :param pulumi.Input[_builtins.str] maintain_end: Specifies the time at which a maintenance time window ends. Format: HH:mm.
               The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
               time window. The end time is four hours later than the start time.
               For example, if the start time is 22:00, the end time is 02:00.
               Parameters `maintain_begin` and `maintain_end` must be set in pairs.
               If parameter `maintain_end` is left  blank, parameter `maintain_begin` is also blank.
               In this case, the system automatically allocates the default end time 06:00.
        :param pulumi.Input[_builtins.str] management_connect_address: Indicates the management address of the DMS RabbitMQ instance.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the DMS RabbitMQ instance. An instance name starts with a letter,
               consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        :param pulumi.Input[_builtins.str] network_id: Specifies the ID of a subnet. Changing this creates a new instance
               resource.
        :param pulumi.Input[_builtins.str] password: Specifies the password of the DMS RabbitMQ instance. A password must meet
               the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following
               character types: lowercase letters, uppercase letters, digits,
               and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance. If `period_unit` is set to
               **month**, the value ranges from 1 to 9. If `period_unit` is set to **year**, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] port: Indicates the port number of the DMS RabbitMQ instance.
        :param pulumi.Input[_builtins.str] public_ip_id: Specifies the ID of the elastic IP address (EIP)
               bound to the DMS RabbitMQ instance.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DMS RabbitMQ instance resource. If omitted,
               the provider-level region will be used. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] resource_spec_code: Indicates a resource specifications identifier.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[_builtins.str] specification: Indicates the instance specification. For a single-node DMS RabbitMQ instance, VM specifications are
               returned. For a cluster DMS RabbitMQ instance, VM specifications and the number of nodes are returned.
        :param pulumi.Input[_builtins.bool] ssl_enable: Specifies whether to enable public access for the DMS RabbitMQ instance.
               Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] status: Indicates the status of the DMS RabbitMQ instance.
        :param pulumi.Input[_builtins.int] storage_space: Specifies the message storage space, unit is GB.
               It is required when creating a instance with `flavor_id`. Value range:
               + Single-node RabbitMQ instance: 100–90000 GB
               + Cluster RabbitMQ instance: 100 GB x Number of nodes to 90000 GB, 200 GB x Number of nodes to 90000 GB,
               and 300 GB x Number of nodes to 90000 GB
               
               Changing this creates a new instance resource.
               
               The storage capacity of the product used by default. Changing this creates a new instance resource.
        :param pulumi.Input[_builtins.str] storage_spec_code: Specifies the storage I/O specification.
               Valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
               Changing this creates a new instance resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the DMS RabbitMQ instance.
        :param pulumi.Input[_builtins.str] type: Indicates the DMS RabbitMQ instance type.
        :param pulumi.Input[_builtins.int] used_storage_space: Indicates the used message storage space. Unit: GB
        :param pulumi.Input[_builtins.str] user_id: Indicates the ID of the user who created the DMS RabbitMQ instance
        :param pulumi.Input[_builtins.str] user_name: Indicates the name of the user who created the DMS RabbitMQ instance
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RabbitmqInstanceState.__new__(_RabbitmqInstanceState)

        __props__.__dict__["access_user"] = access_user
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["available_zones"] = available_zones
        __props__.__dict__["broker_num"] = broker_num
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["connect_address"] = connect_address
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_acl"] = enable_acl
        __props__.__dict__["enable_public_ip"] = enable_public_ip
        __props__.__dict__["engine"] = engine
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["extend_times"] = extend_times
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["is_logical_volume"] = is_logical_volume
        __props__.__dict__["maintain_begin"] = maintain_begin
        __props__.__dict__["maintain_end"] = maintain_end
        __props__.__dict__["management_connect_address"] = management_connect_address
        __props__.__dict__["manegement_connect_address"] = manegement_connect_address
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["port"] = port
        __props__.__dict__["product_id"] = product_id
        __props__.__dict__["public_ip_address"] = public_ip_address
        __props__.__dict__["public_ip_id"] = public_ip_id
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_spec_code"] = resource_spec_code
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["specification"] = specification
        __props__.__dict__["ssl_enable"] = ssl_enable
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_space"] = storage_space
        __props__.__dict__["storage_spec_code"] = storage_spec_code
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["used_storage_space"] = used_storage_space
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["vpc_id"] = vpc_id
        return RabbitmqInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessUser")
    def access_user(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a username. A username consists of 4 to 64 characters and
        supports only letters, digits, and hyphens (-). Changing this creates a new instance resource.
        """
        return pulumi.get(self, "access_user")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are **true** and **false**.
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the names of an AZ.
        The parameter value can not be left blank or an empty array.
        Changing this creates a new instance resource.

        > The parameter behavior of `availability_zones` has been changed from `list` to `set`.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="availableZones")
    @_utilities.deprecated("""available_zones has deprecated, please use \"availability_zones\" instead.""")
    def available_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "available_zones")

    @_builtins.property
    @pulumi.getter(name="brokerNum")
    def broker_num(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the broker numbers.
        It is required when creating a cluster instance with `flavor_id`.

        > **NOTE:** Change this will change number of nodes and storage capacity. If you specify the value of
        `storage_space`, you need to manually modify the value of `storage_space` after changing the `broker_num`.
        """
        return pulumi.get(self, "broker_num")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the charging mode of the instance. Valid values are
        **prePaid** and **postPaid**, defaults to **postPaid**. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="connectAddress")
    def connect_address(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the IP address of the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "connect_address")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the DMS RabbitMQ instance.
        It is a character string containing not more than 1,024 characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableAcl")
    def enable_acl(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "enable_acl")

    @_builtins.property
    @pulumi.getter(name="enablePublicIp")
    def enable_public_ip(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether public access to the DMS RabbitMQ instance is enabled.
        """
        return pulumi.get(self, "enable_public_ip")

    @_builtins.property
    @pulumi.getter
    def engine(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the message engine.
        """
        return pulumi.get(self, "engine")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the version of the RabbitMQ engine. Default to "3.7.17".
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project ID of the RabbitMQ instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="extendTimes")
    def extend_times(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "extend_times")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a flavor ID.
        It is mandatory when the `charging_mode` is **prePaid**.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="isLogicalVolume")
    def is_logical_volume(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "is_logical_volume")

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the time at which a maintenance time window starts. Format: HH:mm.
        The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window.
        The start time must be set to 22:00, 02:00, 06:00, 10:00, 14:00, or 18:00. Parameters `maintain_begin`
        and `maintain_end` must be set in pairs. If parameter `maintain_begin` is left blank, parameter `maintain_end` is also
        blank. In this case, the system automatically allocates the default start time 02:00.
        """
        return pulumi.get(self, "maintain_begin")

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the time at which a maintenance time window ends. Format: HH:mm.
        The start time and end time of a maintenance time window must indicate the time segment of a supported maintenance
        time window. The end time is four hours later than the start time.
        For example, if the start time is 22:00, the end time is 02:00.
        Parameters `maintain_begin` and `maintain_end` must be set in pairs.
        If parameter `maintain_end` is left  blank, parameter `maintain_begin` is also blank.
        In this case, the system automatically allocates the default end time 06:00.
        """
        return pulumi.get(self, "maintain_end")

    @_builtins.property
    @pulumi.getter(name="managementConnectAddress")
    def management_connect_address(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the management address of the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "management_connect_address")

    @_builtins.property
    @pulumi.getter(name="manegementConnectAddress")
    @_utilities.deprecated("""typo in manegement_connect_address, please use \"management_connect_address\" instead.""")
    def manegement_connect_address(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "manegement_connect_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the DMS RabbitMQ instance. An instance name starts with a letter,
        consists of 4 to 64 characters, and supports only letters, digits, hyphens (-) and underscores (_).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of a subnet. Changing this creates a new instance
        resource.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the password of the DMS RabbitMQ instance. A password must meet
        the following complexity requirements: Must be 8 to 32 characters long. Must contain at least 2 of the following
        character types: lowercase letters, uppercase letters, digits,
        and special characters (`~!@#$%^&*()-_=+\\\\|[{}]:'",<.>/?).
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the charging period of the instance. If `period_unit` is set to
        **month**, the value ranges from 1 to 9. If `period_unit` is set to **year**, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to **prePaid**. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are **month** and **year**. This parameter is mandatory if `charging_mode` is set to **prePaid**.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates the port number of the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="productId")
    @_utilities.deprecated("""product_id has deprecated, please use \"flavor_id\" instead.""")
    def product_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "product_id")

    @_builtins.property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "public_ip_address")

    @_builtins.property
    @pulumi.getter(name="publicIpId")
    def public_ip_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the elastic IP address (EIP)
        bound to the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "public_ip_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the DMS RabbitMQ instance resource. If omitted,
        the provider-level region will be used. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceSpecCode")
    def resource_spec_code(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates a resource specifications identifier.
        """
        return pulumi.get(self, "resource_spec_code")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of a security group.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def specification(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the instance specification. For a single-node DMS RabbitMQ instance, VM specifications are
        returned. For a cluster DMS RabbitMQ instance, VM specifications and the number of nodes are returned.
        """
        return pulumi.get(self, "specification")

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable public access for the DMS RabbitMQ instance.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "ssl_enable")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the status of the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the message storage space, unit is GB.
        It is required when creating a instance with `flavor_id`. Value range:
        + Single-node RabbitMQ instance: 100–90000 GB
        + Cluster RabbitMQ instance: 100 GB x Number of nodes to 90000 GB, 200 GB x Number of nodes to 90000 GB,
        and 300 GB x Number of nodes to 90000 GB

        Changing this creates a new instance resource.

        The storage capacity of the product used by default. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "storage_space")

    @_builtins.property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the storage I/O specification.
        Valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
        Changing this creates a new instance resource.
        """
        return pulumi.get(self, "storage_spec_code")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key/value pairs to associate with the DMS RabbitMQ instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the DMS RabbitMQ instance type.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="usedStorageSpace")
    def used_storage_space(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates the used message storage space. Unit: GB
        """
        return pulumi.get(self, "used_storage_space")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the ID of the user who created the DMS RabbitMQ instance
        """
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the name of the user who created the DMS RabbitMQ instance
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of a VPC. Changing this creates a new instance resource.
        """
        return pulumi.get(self, "vpc_id")

