# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DmsKafkaConsumerGroupArgs', 'DmsKafkaConsumerGroup']

@pulumi.input_type
class DmsKafkaConsumerGroupArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DmsKafkaConsumerGroup resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the DMS kafka instance to which the consumer group belongs.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the consumer group.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the consumer group. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DMS kafka consumer group resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the DMS kafka instance to which the consumer group belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the consumer group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the consumer group. Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the DMS kafka consumer group resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DmsKafkaConsumerGroupState:
    def __init__(__self__, *,
                 coordinator_id: Optional[pulumi.Input[_builtins.int]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lag: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DmsKafkaConsumerGroup resources.
        :param pulumi.Input[_builtins.int] coordinator_id: Indicates the coordinator id of the consumer group.
        :param pulumi.Input[_builtins.str] created_at: Indicates the create time.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the consumer group.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the DMS kafka instance to which the consumer group belongs.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] lag: Indicates the lag number of the consumer group.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the consumer group. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DMS kafka consumer group resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] state: Indicates the state of the consumer group.
        """
        if coordinator_id is not None:
            pulumi.set(__self__, "coordinator_id", coordinator_id)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if lag is not None:
            pulumi.set(__self__, "lag", lag)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="coordinatorId")
    def coordinator_id(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the coordinator id of the consumer group.
        """
        return pulumi.get(self, "coordinator_id")

    @coordinator_id.setter
    def coordinator_id(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "coordinator_id", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the create time.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the consumer group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the DMS kafka instance to which the consumer group belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def lag(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the lag number of the consumer group.
        """
        return pulumi.get(self, "lag")

    @lag.setter
    def lag(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "lag", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the consumer group. Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the DMS kafka consumer group resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the state of the consumer group.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)


@pulumi.type_token("sbercloud:index/dmsKafkaConsumerGroup:DmsKafkaConsumerGroup")
class DmsKafkaConsumerGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a DMS kafka consumer group resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        kafka_instance_id = config.require_object("kafkaInstanceId")
        group1 = sbercloud.DmsKafkaConsumerGroup("group1",
            instance_id=kafka_instance_id,
            name="group1",
            description="Group description")
        ```

        ## Import

        DMS kafka consumer groups can be imported using the kafka instance ID and consumer group name separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/dmsKafkaConsumerGroup:DmsKafkaConsumerGroup user c8057fe5-23a8-46ef-ad83-c0055b4e0c5c/group1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the consumer group.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the DMS kafka instance to which the consumer group belongs.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the consumer group. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DMS kafka consumer group resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DmsKafkaConsumerGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DMS kafka consumer group resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        kafka_instance_id = config.require_object("kafkaInstanceId")
        group1 = sbercloud.DmsKafkaConsumerGroup("group1",
            instance_id=kafka_instance_id,
            name="group1",
            description="Group description")
        ```

        ## Import

        DMS kafka consumer groups can be imported using the kafka instance ID and consumer group name separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/dmsKafkaConsumerGroup:DmsKafkaConsumerGroup user c8057fe5-23a8-46ef-ad83-c0055b4e0c5c/group1
        ```

        :param str resource_name: The name of the resource.
        :param DmsKafkaConsumerGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DmsKafkaConsumerGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DmsKafkaConsumerGroupArgs.__new__(DmsKafkaConsumerGroupArgs)

            __props__.__dict__["description"] = description
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["coordinator_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["lag"] = None
            __props__.__dict__["state"] = None
        super(DmsKafkaConsumerGroup, __self__).__init__(
            'sbercloud:index/dmsKafkaConsumerGroup:DmsKafkaConsumerGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            coordinator_id: Optional[pulumi.Input[_builtins.int]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            lag: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None) -> 'DmsKafkaConsumerGroup':
        """
        Get an existing DmsKafkaConsumerGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] coordinator_id: Indicates the coordinator id of the consumer group.
        :param pulumi.Input[_builtins.str] created_at: Indicates the create time.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the consumer group.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the DMS kafka instance to which the consumer group belongs.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.int] lag: Indicates the lag number of the consumer group.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the consumer group. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DMS kafka consumer group resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] state: Indicates the state of the consumer group.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DmsKafkaConsumerGroupState.__new__(_DmsKafkaConsumerGroupState)

        __props__.__dict__["coordinator_id"] = coordinator_id
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["lag"] = lag
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["state"] = state
        return DmsKafkaConsumerGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="coordinatorId")
    def coordinator_id(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates the coordinator id of the consumer group.
        """
        return pulumi.get(self, "coordinator_id")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the create time.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the consumer group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the DMS kafka instance to which the consumer group belongs.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def lag(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates the lag number of the consumer group.
        """
        return pulumi.get(self, "lag")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the consumer group. Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the DMS kafka consumer group resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the state of the consumer group.
        """
        return pulumi.get(self, "state")

