# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DmsRocketmqConsumerGroupArgs', 'DmsRocketmqConsumerGroup']

@pulumi.input_type
class DmsRocketmqConsumerGroupArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 retry_max_times: pulumi.Input[_builtins.int],
                 broadcast: Optional[pulumi.Input[_builtins.bool]] = None,
                 brokers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 consume_orderly: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DmsRocketmqConsumerGroup resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the rocketMQ instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] retry_max_times: Specifies the maximum number of retry times.  
               The valid value is range from `1` to `16`.
        :param pulumi.Input[_builtins.bool] broadcast: Specifies whether to broadcast of the consumer group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] brokers: Specifies the list of associated brokers of the consumer group.
               It's only valid when RocketMQ instance version is **4.8.0**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] consume_orderly: Specifies whether to consume orderly.
               It's only valid when RocketMQ instance version is **5.x**.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the consumer group.
        :param pulumi.Input[_builtins.bool] enabled: Specifies the consumer group is enabled or not. Defaults to true.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the consumer group.  
               The valid length is limited from `3` to `64`, only letters, digits, vertical lines (|), percent sign (%), hyphens (-)
               and underscores (_) are allowed.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "retry_max_times", retry_max_times)
        if broadcast is not None:
            pulumi.set(__self__, "broadcast", broadcast)
        if brokers is not None:
            pulumi.set(__self__, "brokers", brokers)
        if consume_orderly is not None:
            pulumi.set(__self__, "consume_orderly", consume_orderly)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the rocketMQ instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="retryMaxTimes")
    def retry_max_times(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the maximum number of retry times.  
        The valid value is range from `1` to `16`.
        """
        return pulumi.get(self, "retry_max_times")

    @retry_max_times.setter
    def retry_max_times(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "retry_max_times", value)

    @_builtins.property
    @pulumi.getter
    def broadcast(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to broadcast of the consumer group.
        """
        return pulumi.get(self, "broadcast")

    @broadcast.setter
    def broadcast(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "broadcast", value)

    @_builtins.property
    @pulumi.getter
    def brokers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of associated brokers of the consumer group.
        It's only valid when RocketMQ instance version is **4.8.0**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "brokers")

    @brokers.setter
    def brokers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "brokers", value)

    @_builtins.property
    @pulumi.getter(name="consumeOrderly")
    def consume_orderly(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to consume orderly.
        It's only valid when RocketMQ instance version is **5.x**.
        """
        return pulumi.get(self, "consume_orderly")

    @consume_orderly.setter
    def consume_orderly(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "consume_orderly", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the consumer group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the consumer group is enabled or not. Defaults to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the consumer group.  
        The valid length is limited from `3` to `64`, only letters, digits, vertical lines (|), percent sign (%), hyphens (-)
        and underscores (_) are allowed.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DmsRocketmqConsumerGroupState:
    def __init__(__self__, *,
                 broadcast: Optional[pulumi.Input[_builtins.bool]] = None,
                 brokers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 consume_orderly: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_max_times: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering DmsRocketmqConsumerGroup resources.
        :param pulumi.Input[_builtins.bool] broadcast: Specifies whether to broadcast of the consumer group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] brokers: Specifies the list of associated brokers of the consumer group.
               It's only valid when RocketMQ instance version is **4.8.0**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] consume_orderly: Specifies whether to consume orderly.
               It's only valid when RocketMQ instance version is **5.x**.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the consumer group.
        :param pulumi.Input[_builtins.bool] enabled: Specifies the consumer group is enabled or not. Defaults to true.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the rocketMQ instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the consumer group.  
               The valid length is limited from `3` to `64`, only letters, digits, vertical lines (|), percent sign (%), hyphens (-)
               and underscores (_) are allowed.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] retry_max_times: Specifies the maximum number of retry times.  
               The valid value is range from `1` to `16`.
        """
        if broadcast is not None:
            pulumi.set(__self__, "broadcast", broadcast)
        if brokers is not None:
            pulumi.set(__self__, "brokers", brokers)
        if consume_orderly is not None:
            pulumi.set(__self__, "consume_orderly", consume_orderly)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retry_max_times is not None:
            pulumi.set(__self__, "retry_max_times", retry_max_times)

    @_builtins.property
    @pulumi.getter
    def broadcast(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to broadcast of the consumer group.
        """
        return pulumi.get(self, "broadcast")

    @broadcast.setter
    def broadcast(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "broadcast", value)

    @_builtins.property
    @pulumi.getter
    def brokers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of associated brokers of the consumer group.
        It's only valid when RocketMQ instance version is **4.8.0**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "brokers")

    @brokers.setter
    def brokers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "brokers", value)

    @_builtins.property
    @pulumi.getter(name="consumeOrderly")
    def consume_orderly(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to consume orderly.
        It's only valid when RocketMQ instance version is **5.x**.
        """
        return pulumi.get(self, "consume_orderly")

    @consume_orderly.setter
    def consume_orderly(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "consume_orderly", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the consumer group.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the consumer group is enabled or not. Defaults to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the rocketMQ instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the consumer group.  
        The valid length is limited from `3` to `64`, only letters, digits, vertical lines (|), percent sign (%), hyphens (-)
        and underscores (_) are allowed.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="retryMaxTimes")
    def retry_max_times(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the maximum number of retry times.  
        The valid value is range from `1` to `16`.
        """
        return pulumi.get(self, "retry_max_times")

    @retry_max_times.setter
    def retry_max_times(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "retry_max_times", value)


@pulumi.type_token("sbercloud:index/dmsRocketmqConsumerGroup:DmsRocketmqConsumerGroup")
class DmsRocketmqConsumerGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 broadcast: Optional[pulumi.Input[_builtins.bool]] = None,
                 brokers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 consume_orderly: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_max_times: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages DMS RocketMQ consumer group resources within SberCloud.

        ## Example Usage

        ### Create consumer group for 4.8.0 version instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.DmsRocketmqConsumerGroup("test",
            instance_id=instance_id,
            name="consumer_group_test",
            enabled=True,
            broadcast=True,
            brokers=[
                "broker-0",
                "broker-1",
            ],
            retry_max_times=3,
            description="the description of the consumer group")
        ```

        ### Create consumer group for 5.x version instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.DmsRocketmqConsumerGroup("test",
            instance_id=instance_id,
            name="consumer_group_test",
            enabled=True,
            broadcast=True,
            retry_max_times=3,
            description="the description of the consumer group",
            consume_orderly=True)
        ```

        ## Import

        The rocketmq consumer group can be imported using the rocketMQ instance ID and group name separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/dmsRocketmqConsumerGroup:DmsRocketmqConsumerGroup test 8d3c7938-dc47-4937-a30f-c80de381c5e3/group_1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] broadcast: Specifies whether to broadcast of the consumer group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] brokers: Specifies the list of associated brokers of the consumer group.
               It's only valid when RocketMQ instance version is **4.8.0**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] consume_orderly: Specifies whether to consume orderly.
               It's only valid when RocketMQ instance version is **5.x**.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the consumer group.
        :param pulumi.Input[_builtins.bool] enabled: Specifies the consumer group is enabled or not. Defaults to true.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the rocketMQ instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the consumer group.  
               The valid length is limited from `3` to `64`, only letters, digits, vertical lines (|), percent sign (%), hyphens (-)
               and underscores (_) are allowed.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] retry_max_times: Specifies the maximum number of retry times.  
               The valid value is range from `1` to `16`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DmsRocketmqConsumerGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages DMS RocketMQ consumer group resources within SberCloud.

        ## Example Usage

        ### Create consumer group for 4.8.0 version instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.DmsRocketmqConsumerGroup("test",
            instance_id=instance_id,
            name="consumer_group_test",
            enabled=True,
            broadcast=True,
            brokers=[
                "broker-0",
                "broker-1",
            ],
            retry_max_times=3,
            description="the description of the consumer group")
        ```

        ### Create consumer group for 5.x version instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.DmsRocketmqConsumerGroup("test",
            instance_id=instance_id,
            name="consumer_group_test",
            enabled=True,
            broadcast=True,
            retry_max_times=3,
            description="the description of the consumer group",
            consume_orderly=True)
        ```

        ## Import

        The rocketmq consumer group can be imported using the rocketMQ instance ID and group name separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/dmsRocketmqConsumerGroup:DmsRocketmqConsumerGroup test 8d3c7938-dc47-4937-a30f-c80de381c5e3/group_1
        ```

        :param str resource_name: The name of the resource.
        :param DmsRocketmqConsumerGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DmsRocketmqConsumerGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 broadcast: Optional[pulumi.Input[_builtins.bool]] = None,
                 brokers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 consume_orderly: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retry_max_times: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DmsRocketmqConsumerGroupArgs.__new__(DmsRocketmqConsumerGroupArgs)

            __props__.__dict__["broadcast"] = broadcast
            __props__.__dict__["brokers"] = brokers
            __props__.__dict__["consume_orderly"] = consume_orderly
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            if retry_max_times is None and not opts.urn:
                raise TypeError("Missing required property 'retry_max_times'")
            __props__.__dict__["retry_max_times"] = retry_max_times
        super(DmsRocketmqConsumerGroup, __self__).__init__(
            'sbercloud:index/dmsRocketmqConsumerGroup:DmsRocketmqConsumerGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            broadcast: Optional[pulumi.Input[_builtins.bool]] = None,
            brokers: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            consume_orderly: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            retry_max_times: Optional[pulumi.Input[_builtins.int]] = None) -> 'DmsRocketmqConsumerGroup':
        """
        Get an existing DmsRocketmqConsumerGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] broadcast: Specifies whether to broadcast of the consumer group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] brokers: Specifies the list of associated brokers of the consumer group.
               It's only valid when RocketMQ instance version is **4.8.0**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] consume_orderly: Specifies whether to consume orderly.
               It's only valid when RocketMQ instance version is **5.x**.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the consumer group.
        :param pulumi.Input[_builtins.bool] enabled: Specifies the consumer group is enabled or not. Defaults to true.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the rocketMQ instance.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the consumer group.  
               The valid length is limited from `3` to `64`, only letters, digits, vertical lines (|), percent sign (%), hyphens (-)
               and underscores (_) are allowed.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] retry_max_times: Specifies the maximum number of retry times.  
               The valid value is range from `1` to `16`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DmsRocketmqConsumerGroupState.__new__(_DmsRocketmqConsumerGroupState)

        __props__.__dict__["broadcast"] = broadcast
        __props__.__dict__["brokers"] = brokers
        __props__.__dict__["consume_orderly"] = consume_orderly
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["retry_max_times"] = retry_max_times
        return DmsRocketmqConsumerGroup(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def broadcast(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to broadcast of the consumer group.
        """
        return pulumi.get(self, "broadcast")

    @_builtins.property
    @pulumi.getter
    def brokers(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the list of associated brokers of the consumer group.
        It's only valid when RocketMQ instance version is **4.8.0**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "brokers")

    @_builtins.property
    @pulumi.getter(name="consumeOrderly")
    def consume_orderly(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether to consume orderly.
        It's only valid when RocketMQ instance version is **5.x**.
        """
        return pulumi.get(self, "consume_orderly")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the consumer group.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies the consumer group is enabled or not. Defaults to true.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the rocketMQ instance.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the consumer group.  
        The valid length is limited from `3` to `64`, only letters, digits, vertical lines (|), percent sign (%), hyphens (-)
        and underscores (_) are allowed.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="retryMaxTimes")
    def retry_max_times(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the maximum number of retry times.  
        The valid value is range from `1` to `16`.
        """
        return pulumi.get(self, "retry_max_times")

