# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DmsRocketmqDeadLetterResendArgs', 'DmsRocketmqDeadLetterResend']

@pulumi.input_type
class DmsRocketmqDeadLetterResendArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 message_id_lists: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 topic: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DmsRocketmqDeadLetterResend resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the instance ID.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] message_id_lists: Specifies the message ID list.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] topic: Specifies the dead letter topic name.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "message_id_lists", message_id_lists)
        pulumi.set(__self__, "topic", topic)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the instance ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="messageIdLists")
    def message_id_lists(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the message ID list.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "message_id_lists")

    @message_id_lists.setter
    def message_id_lists(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "message_id_lists", value)

    @_builtins.property
    @pulumi.getter
    def topic(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the dead letter topic name.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "topic", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DmsRocketmqDeadLetterResendState:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 message_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resend_results: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqDeadLetterResendResendResultArgs']]]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DmsRocketmqDeadLetterResend resources.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the instance ID.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] message_id_lists: Specifies the message ID list.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqDeadLetterResendResendResultArgs']]] resend_results: Indicates the resend results.
               The resend_results structure is documented below.
        :param pulumi.Input[_builtins.str] topic: Specifies the dead letter topic name.
               Changing this creates a new resource.
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if message_id_lists is not None:
            pulumi.set(__self__, "message_id_lists", message_id_lists)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resend_results is not None:
            pulumi.set(__self__, "resend_results", resend_results)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the instance ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="messageIdLists")
    def message_id_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the message ID list.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "message_id_lists")

    @message_id_lists.setter
    def message_id_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "message_id_lists", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resendResults")
    def resend_results(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqDeadLetterResendResendResultArgs']]]]:
        """
        Indicates the resend results.
        The resend_results structure is documented below.
        """
        return pulumi.get(self, "resend_results")

    @resend_results.setter
    def resend_results(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqDeadLetterResendResendResultArgs']]]]):
        pulumi.set(self, "resend_results", value)

    @_builtins.property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the dead letter topic name.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic", value)


@pulumi.type_token("sbercloud:index/dmsRocketmqDeadLetterResend:DmsRocketmqDeadLetterResend")
class DmsRocketmqDeadLetterResend(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 message_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a DMS RocketMQ dead letter messages resend resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        dead_letter_topic = config.require_object("deadLetterTopic")
        message_id_list = config.require_object("messageIdList")
        test = sbercloud.DmsRocketmqDeadLetterResend("test",
            instance_id=instance_id,
            topic=dead_letter_topic,
            message_id_lists=message_id_list)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the instance ID.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] message_id_lists: Specifies the message ID list.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] topic: Specifies the dead letter topic name.
               Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DmsRocketmqDeadLetterResendArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DMS RocketMQ dead letter messages resend resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        dead_letter_topic = config.require_object("deadLetterTopic")
        message_id_list = config.require_object("messageIdList")
        test = sbercloud.DmsRocketmqDeadLetterResend("test",
            instance_id=instance_id,
            topic=dead_letter_topic,
            message_id_lists=message_id_list)
        ```

        :param str resource_name: The name of the resource.
        :param DmsRocketmqDeadLetterResendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DmsRocketmqDeadLetterResendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 message_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DmsRocketmqDeadLetterResendArgs.__new__(DmsRocketmqDeadLetterResendArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if message_id_lists is None and not opts.urn:
                raise TypeError("Missing required property 'message_id_lists'")
            __props__.__dict__["message_id_lists"] = message_id_lists
            __props__.__dict__["region"] = region
            if topic is None and not opts.urn:
                raise TypeError("Missing required property 'topic'")
            __props__.__dict__["topic"] = topic
            __props__.__dict__["resend_results"] = None
        super(DmsRocketmqDeadLetterResend, __self__).__init__(
            'sbercloud:index/dmsRocketmqDeadLetterResend:DmsRocketmqDeadLetterResend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            message_id_lists: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resend_results: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqDeadLetterResendResendResultArgs', 'DmsRocketmqDeadLetterResendResendResultArgsDict']]]]] = None,
            topic: Optional[pulumi.Input[_builtins.str]] = None) -> 'DmsRocketmqDeadLetterResend':
        """
        Get an existing DmsRocketmqDeadLetterResend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the instance ID.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] message_id_lists: Specifies the message ID list.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqDeadLetterResendResendResultArgs', 'DmsRocketmqDeadLetterResendResendResultArgsDict']]]] resend_results: Indicates the resend results.
               The resend_results structure is documented below.
        :param pulumi.Input[_builtins.str] topic: Specifies the dead letter topic name.
               Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DmsRocketmqDeadLetterResendState.__new__(_DmsRocketmqDeadLetterResendState)

        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["message_id_lists"] = message_id_lists
        __props__.__dict__["region"] = region
        __props__.__dict__["resend_results"] = resend_results
        __props__.__dict__["topic"] = topic
        return DmsRocketmqDeadLetterResend(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the instance ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="messageIdLists")
    def message_id_lists(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the message ID list.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "message_id_lists")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resendResults")
    def resend_results(self) -> pulumi.Output[Sequence['outputs.DmsRocketmqDeadLetterResendResendResult']]:
        """
        Indicates the resend results.
        The resend_results structure is documented below.
        """
        return pulumi.get(self, "resend_results")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the dead letter topic name.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "topic")

