# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DmsRocketmqInstanceArgs', 'DmsRocketmqInstance']

@pulumi.input_type
class DmsRocketmqInstanceArgs:
    def __init__(__self__, *,
                 availability_zones: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 engine_version: pulumi.Input[_builtins.str],
                 flavor_id: pulumi.Input[_builtins.str],
                 security_group_id: pulumi.Input[_builtins.str],
                 storage_space: pulumi.Input[_builtins.int],
                 storage_spec_code: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 broker_num: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqInstanceConfigArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_acl: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_publicip: Optional[pulumi.Input[_builtins.bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 publicip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a DmsRocketmqInstance resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the list of availability zone names, where
               instance brokers reside and which has available resources.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the version of the RocketMQ engine.
               Valid values are **4.8.0** and **5.x**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the flavor ID.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[_builtins.int] storage_space: Specifies the message storage capacity, Unit: GB.
               When `engine_version` is **4.8.0**, value ranges from `300` to `30,000`.
               When `engine_version` is **5.x**, value ranges from `200` to `60,000`.
        :param pulumi.Input[_builtins.str] storage_spec_code: Specifies the storage I/O specification.
               The options are as follows:
               + **dms.physical.storage.high.v2**: high I/O disk
               + **dms.physical.storage.ultra.v2**: ultra-high I/O disk
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of a subnet.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "false".
        :param pulumi.Input[_builtins.int] broker_num: Specifies the broker numbers. It's **required** when instance architecture is
               **cluster**. Defaults to `1` when instance architecture is **single node**.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the instance. Valid values are *prePaid*
               and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqInstanceConfigArgs']]] configs: Specifies the instance configs.
               The configs structure is documented below.
               
               <a name="dms_configs"></a>
               The `configs` block supports:
        :param pulumi.Input[_builtins.str] description: Specifies the description of the DMS RocketMQ instance.
               The description can contain a maximum of `1,024` characters.
        :param pulumi.Input[_builtins.bool] enable_acl: Specifies whether access control is enabled.
        :param pulumi.Input[_builtins.bool] enable_publicip: Specifies whether to enable public access. By default, public access is disabled.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the instance.
        :param pulumi.Input[_builtins.bool] ipv6_enable: Specifies whether to support IPv6. Defaults to **false**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the config name.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance. If `period_unit` is set to *month*
               , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from `1` to `3`. This parameter is
               mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] publicip_id: Specifies the ID of the EIP bound to the instance. Use commas (,) to separate
               multiple EIP IDs. It is mandatory if `enable_publicip` is **true** and should be empty when `enable_publicip` is **false**.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] retention_policy: Specifies whether access control is enabled.
        :param pulumi.Input[_builtins.bool] ssl_enable: Specifies whether the RocketMQ SASL_SSL is enabled. Defaults to **false**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the instance.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "storage_space", storage_space)
        pulumi.set(__self__, "storage_spec_code", storage_spec_code)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if broker_num is not None:
            pulumi.set(__self__, "broker_num", broker_num)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_acl is not None:
            pulumi.set(__self__, "enable_acl", enable_acl)
        if enable_publicip is not None:
            pulumi.set(__self__, "enable_publicip", enable_publicip)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if publicip_id is not None:
            pulumi.set(__self__, "publicip_id", publicip_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if retention_policy is not None:
            warnings.warn("""Use 'enable_acl' instead""", DeprecationWarning)
            pulumi.log.warn("""retention_policy is deprecated: Use 'enable_acl' instead""")
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        Specifies the list of availability zone names, where
        instance brokers reside and which has available resources.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the version of the RocketMQ engine.
        Valid values are **4.8.0** and **5.x**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the flavor ID.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of a security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the message storage capacity, Unit: GB.
        When `engine_version` is **4.8.0**, value ranges from `300` to `30,000`.
        When `engine_version` is **5.x**, value ranges from `200` to `60,000`.
        """
        return pulumi.get(self, "storage_space")

    @storage_space.setter
    def storage_space(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "storage_space", value)

    @_builtins.property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the storage I/O specification.
        The options are as follows:
        + **dms.physical.storage.high.v2**: high I/O disk
        + **dms.physical.storage.ultra.v2**: ultra-high I/O disk
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "storage_spec_code")

    @storage_spec_code.setter
    def storage_spec_code(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_spec_code", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of a subnet.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of a VPC.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "false".
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="brokerNum")
    def broker_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the broker numbers. It's **required** when instance architecture is
        **cluster**. Defaults to `1` when instance architecture is **single node**.
        """
        return pulumi.get(self, "broker_num")

    @broker_num.setter
    def broker_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "broker_num", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the instance. Valid values are *prePaid*
        and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqInstanceConfigArgs']]]]:
        """
        Specifies the instance configs.
        The configs structure is documented below.

        <a name="dms_configs"></a>
        The `configs` block supports:
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqInstanceConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the DMS RocketMQ instance.
        The description can contain a maximum of `1,024` characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableAcl")
    def enable_acl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether access control is enabled.
        """
        return pulumi.get(self, "enable_acl")

    @enable_acl.setter
    def enable_acl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_acl", value)

    @_builtins.property
    @pulumi.getter(name="enablePublicip")
    def enable_publicip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable public access. By default, public access is disabled.
        """
        return pulumi.get(self, "enable_publicip")

    @enable_publicip.setter
    def enable_publicip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_publicip", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to support IPv6. Defaults to **false**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the config name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the instance. If `period_unit` is set to *month*
        , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from `1` to `3`. This parameter is
        mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="publicipId")
    def publicip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the EIP bound to the instance. Use commas (,) to separate
        multiple EIP IDs. It is mandatory if `enable_publicip` is **true** and should be empty when `enable_publicip` is **false**.
        """
        return pulumi.get(self, "publicip_id")

    @publicip_id.setter
    def publicip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "publicip_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="retentionPolicy")
    @_utilities.deprecated("""Use 'enable_acl' instead""")
    def retention_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether access control is enabled.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retention_policy", value)

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the RocketMQ SASL_SSL is enabled. Defaults to **false**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_enable", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _DmsRocketmqInstanceState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 broker_address: Optional[pulumi.Input[_builtins.str]] = None,
                 broker_num: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqInstanceConfigArgs']]]] = None,
                 cross_vpc_accesses: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqInstanceCrossVpcAccessArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_acl: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_publicip: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
                 maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 namesrv_address: Optional[pulumi.Input[_builtins.str]] = None,
                 new_spec_billing_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 node_num: Optional[pulumi.Input[_builtins.int]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 public_broker_address: Optional[pulumi.Input[_builtins.str]] = None,
                 public_namesrv_address: Optional[pulumi.Input[_builtins.str]] = None,
                 publicip_address: Optional[pulumi.Input[_builtins.str]] = None,
                 publicip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 specification: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 used_storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DmsRocketmqInstance resources.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "false".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the list of availability zone names, where
               instance brokers reside and which has available resources.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] broker_address: Indicates the service data address.
        :param pulumi.Input[_builtins.int] broker_num: Specifies the broker numbers. It's **required** when instance architecture is
               **cluster**. Defaults to `1` when instance architecture is **single node**.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the instance. Valid values are *prePaid*
               and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqInstanceConfigArgs']]] configs: Specifies the instance configs.
               The configs structure is documented below.
               
               <a name="dms_configs"></a>
               The `configs` block supports:
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqInstanceCrossVpcAccessArgs']]] cross_vpc_accesses: Indicates the Access information of cross-VPC. The structure is documented below.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the DMS RocketMQ instance.
               The description can contain a maximum of `1,024` characters.
        :param pulumi.Input[_builtins.bool] enable_acl: Specifies whether access control is enabled.
        :param pulumi.Input[_builtins.bool] enable_publicip: Specifies whether to enable public access. By default, public access is disabled.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the version of the RocketMQ engine.
               Valid values are **4.8.0** and **5.x**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the instance.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the flavor ID.
        :param pulumi.Input[_builtins.bool] ipv6_enable: Specifies whether to support IPv6. Defaults to **false**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] maintain_begin: Indicates the time at which the maintenance window starts. The format is HH:mm:ss.
        :param pulumi.Input[_builtins.str] maintain_end: Indicates the time at which the maintenance window ends. The format is HH:mm:ss.
        :param pulumi.Input[_builtins.str] name: Specifies the config name.
        :param pulumi.Input[_builtins.str] namesrv_address: Indicates the metadata address.
        :param pulumi.Input[_builtins.bool] new_spec_billing_enable: Indicates whether billing based on new specifications is enabled.
        :param pulumi.Input[_builtins.int] node_num: Indicates the node quantity.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance. If `period_unit` is set to *month*
               , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from `1` to `3`. This parameter is
               mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] public_broker_address: Indicates the public network service data address.
        :param pulumi.Input[_builtins.str] public_namesrv_address: Indicates the public network metadata address.
        :param pulumi.Input[_builtins.str] publicip_address: Indicates the public IP address.
        :param pulumi.Input[_builtins.str] publicip_id: Specifies the ID of the EIP bound to the instance. Use commas (,) to separate
               multiple EIP IDs. It is mandatory if `enable_publicip` is **true** and should be empty when `enable_publicip` is **false**.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] resource_spec_code: Indicates the resource specifications.
        :param pulumi.Input[_builtins.bool] retention_policy: Specifies whether access control is enabled.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[_builtins.str] specification: Indicates the instance specification. For a cluster DMS RocketMQ instance, VM specifications
               and the number of nodes are returned.
        :param pulumi.Input[_builtins.bool] ssl_enable: Specifies whether the RocketMQ SASL_SSL is enabled. Defaults to **false**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: Indicates the status of the DMS RocketMQ instance.
        :param pulumi.Input[_builtins.int] storage_space: Specifies the message storage capacity, Unit: GB.
               When `engine_version` is **4.8.0**, value ranges from `300` to `30,000`.
               When `engine_version` is **5.x**, value ranges from `200` to `60,000`.
        :param pulumi.Input[_builtins.str] storage_spec_code: Specifies the storage I/O specification.
               The options are as follows:
               + **dms.physical.storage.high.v2**: high I/O disk
               + **dms.physical.storage.ultra.v2**: ultra-high I/O disk
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of a subnet.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the instance.
        :param pulumi.Input[_builtins.str] type: Indicates the DMS RocketMQ instance type. Value: cluster.
        :param pulumi.Input[_builtins.int] used_storage_space: Indicates the used message storage space. Unit: GB.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC.
               Changing this parameter will create a new resource.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if broker_address is not None:
            pulumi.set(__self__, "broker_address", broker_address)
        if broker_num is not None:
            pulumi.set(__self__, "broker_num", broker_num)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if configs is not None:
            pulumi.set(__self__, "configs", configs)
        if cross_vpc_accesses is not None:
            pulumi.set(__self__, "cross_vpc_accesses", cross_vpc_accesses)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_acl is not None:
            pulumi.set(__self__, "enable_acl", enable_acl)
        if enable_publicip is not None:
            pulumi.set(__self__, "enable_publicip", enable_publicip)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if maintain_begin is not None:
            pulumi.set(__self__, "maintain_begin", maintain_begin)
        if maintain_end is not None:
            pulumi.set(__self__, "maintain_end", maintain_end)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namesrv_address is not None:
            pulumi.set(__self__, "namesrv_address", namesrv_address)
        if new_spec_billing_enable is not None:
            pulumi.set(__self__, "new_spec_billing_enable", new_spec_billing_enable)
        if node_num is not None:
            pulumi.set(__self__, "node_num", node_num)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if public_broker_address is not None:
            pulumi.set(__self__, "public_broker_address", public_broker_address)
        if public_namesrv_address is not None:
            pulumi.set(__self__, "public_namesrv_address", public_namesrv_address)
        if publicip_address is not None:
            pulumi.set(__self__, "publicip_address", publicip_address)
        if publicip_id is not None:
            pulumi.set(__self__, "publicip_id", publicip_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_spec_code is not None:
            pulumi.set(__self__, "resource_spec_code", resource_spec_code)
        if retention_policy is not None:
            warnings.warn("""Use 'enable_acl' instead""", DeprecationWarning)
            pulumi.log.warn("""retention_policy is deprecated: Use 'enable_acl' instead""")
        if retention_policy is not None:
            pulumi.set(__self__, "retention_policy", retention_policy)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if specification is not None:
            pulumi.set(__self__, "specification", specification)
        if ssl_enable is not None:
            pulumi.set(__self__, "ssl_enable", ssl_enable)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if storage_space is not None:
            pulumi.set(__self__, "storage_space", storage_space)
        if storage_spec_code is not None:
            pulumi.set(__self__, "storage_spec_code", storage_spec_code)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if used_storage_space is not None:
            pulumi.set(__self__, "used_storage_space", used_storage_space)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "false".
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies the list of availability zone names, where
        instance brokers reside and which has available resources.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "availability_zones", value)

    @_builtins.property
    @pulumi.getter(name="brokerAddress")
    def broker_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the service data address.
        """
        return pulumi.get(self, "broker_address")

    @broker_address.setter
    def broker_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "broker_address", value)

    @_builtins.property
    @pulumi.getter(name="brokerNum")
    def broker_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the broker numbers. It's **required** when instance architecture is
        **cluster**. Defaults to `1` when instance architecture is **single node**.
        """
        return pulumi.get(self, "broker_num")

    @broker_num.setter
    def broker_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "broker_num", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging mode of the instance. Valid values are *prePaid*
        and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter
    def configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqInstanceConfigArgs']]]]:
        """
        Specifies the instance configs.
        The configs structure is documented below.

        <a name="dms_configs"></a>
        The `configs` block supports:
        """
        return pulumi.get(self, "configs")

    @configs.setter
    def configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqInstanceConfigArgs']]]]):
        pulumi.set(self, "configs", value)

    @_builtins.property
    @pulumi.getter(name="crossVpcAccesses")
    def cross_vpc_accesses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqInstanceCrossVpcAccessArgs']]]]:
        """
        Indicates the Access information of cross-VPC. The structure is documented below.
        """
        return pulumi.get(self, "cross_vpc_accesses")

    @cross_vpc_accesses.setter
    def cross_vpc_accesses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqInstanceCrossVpcAccessArgs']]]]):
        pulumi.set(self, "cross_vpc_accesses", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the DMS RocketMQ instance.
        The description can contain a maximum of `1,024` characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="enableAcl")
    def enable_acl(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether access control is enabled.
        """
        return pulumi.get(self, "enable_acl")

    @enable_acl.setter
    def enable_acl(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_acl", value)

    @_builtins.property
    @pulumi.getter(name="enablePublicip")
    def enable_publicip(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable public access. By default, public access is disabled.
        """
        return pulumi.get(self, "enable_publicip")

    @enable_publicip.setter
    def enable_publicip(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_publicip", value)

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the version of the RocketMQ engine.
        Valid values are **4.8.0** and **5.x**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_version", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id of the instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the flavor ID.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to support IPv6. Defaults to **false**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enable", value)

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the time at which the maintenance window starts. The format is HH:mm:ss.
        """
        return pulumi.get(self, "maintain_begin")

    @maintain_begin.setter
    def maintain_begin(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_begin", value)

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the time at which the maintenance window ends. The format is HH:mm:ss.
        """
        return pulumi.get(self, "maintain_end")

    @maintain_end.setter
    def maintain_end(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "maintain_end", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the config name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="namesrvAddress")
    def namesrv_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the metadata address.
        """
        return pulumi.get(self, "namesrv_address")

    @namesrv_address.setter
    def namesrv_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "namesrv_address", value)

    @_builtins.property
    @pulumi.getter(name="newSpecBillingEnable")
    def new_spec_billing_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Indicates whether billing based on new specifications is enabled.
        """
        return pulumi.get(self, "new_spec_billing_enable")

    @new_spec_billing_enable.setter
    def new_spec_billing_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "new_spec_billing_enable", value)

    @_builtins.property
    @pulumi.getter(name="nodeNum")
    def node_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the node quantity.
        """
        return pulumi.get(self, "node_num")

    @node_num.setter
    def node_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "node_num", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the charging period of the instance. If `period_unit` is set to *month*
        , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from `1` to `3`. This parameter is
        mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="publicBrokerAddress")
    def public_broker_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the public network service data address.
        """
        return pulumi.get(self, "public_broker_address")

    @public_broker_address.setter
    def public_broker_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_broker_address", value)

    @_builtins.property
    @pulumi.getter(name="publicNamesrvAddress")
    def public_namesrv_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the public network metadata address.
        """
        return pulumi.get(self, "public_namesrv_address")

    @public_namesrv_address.setter
    def public_namesrv_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_namesrv_address", value)

    @_builtins.property
    @pulumi.getter(name="publicipAddress")
    def publicip_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the public IP address.
        """
        return pulumi.get(self, "publicip_address")

    @publicip_address.setter
    def publicip_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "publicip_address", value)

    @_builtins.property
    @pulumi.getter(name="publicipId")
    def publicip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the EIP bound to the instance. Use commas (,) to separate
        multiple EIP IDs. It is mandatory if `enable_publicip` is **true** and should be empty when `enable_publicip` is **false**.
        """
        return pulumi.get(self, "publicip_id")

    @publicip_id.setter
    def publicip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "publicip_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="resourceSpecCode")
    def resource_spec_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the resource specifications.
        """
        return pulumi.get(self, "resource_spec_code")

    @resource_spec_code.setter
    def resource_spec_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_spec_code", value)

    @_builtins.property
    @pulumi.getter(name="retentionPolicy")
    @_utilities.deprecated("""Use 'enable_acl' instead""")
    def retention_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether access control is enabled.
        """
        return pulumi.get(self, "retention_policy")

    @retention_policy.setter
    def retention_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "retention_policy", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a security group.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def specification(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the instance specification. For a cluster DMS RocketMQ instance, VM specifications
        and the number of nodes are returned.
        """
        return pulumi.get(self, "specification")

    @specification.setter
    def specification(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "specification", value)

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the RocketMQ SASL_SSL is enabled. Defaults to **false**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ssl_enable")

    @ssl_enable.setter
    def ssl_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_enable", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the status of the DMS RocketMQ instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the message storage capacity, Unit: GB.
        When `engine_version` is **4.8.0**, value ranges from `300` to `30,000`.
        When `engine_version` is **5.x**, value ranges from `200` to `60,000`.
        """
        return pulumi.get(self, "storage_space")

    @storage_space.setter
    def storage_space(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "storage_space", value)

    @_builtins.property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the storage I/O specification.
        The options are as follows:
        + **dms.physical.storage.high.v2**: high I/O disk
        + **dms.physical.storage.ultra.v2**: ultra-high I/O disk
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "storage_spec_code")

    @storage_spec_code.setter
    def storage_spec_code(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_spec_code", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a subnet.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the DMS RocketMQ instance type. Value: cluster.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="usedStorageSpace")
    def used_storage_space(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Indicates the used message storage space. Unit: GB.
        """
        return pulumi.get(self, "used_storage_space")

    @used_storage_space.setter
    def used_storage_space(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "used_storage_space", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a VPC.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:index/dmsRocketmqInstance:DmsRocketmqInstance")
class DmsRocketmqInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 broker_num: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqInstanceConfigArgs', 'DmsRocketmqInstanceConfigArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_acl: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_publicip: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 publicip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage DMS RocketMQ instance resources within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        security_group_id = config.require_object("securityGroupId")
        availability_zones = config.require_object("availabilityZones")
        test = sbercloud.DmsRocketmqInstance("test",
            name="rocketmq_name_test",
            description="this is a rocketmq instance",
            engine_version="4.8.0",
            storage_space=300,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=security_group_id,
            availability_zones=availability_zones,
            flavor_id="c6.4u8g.cluster",
            storage_spec_code="dms.physical.storage.high.v2",
            broker_num=1)
        ```

        ## Import

        The rocketmq instance can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/dmsRocketmqInstance:DmsRocketmqInstance test 8d3c7938-dc47-4937-a30f-c80de381c5e3
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "false".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the list of availability zone names, where
               instance brokers reside and which has available resources.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] broker_num: Specifies the broker numbers. It's **required** when instance architecture is
               **cluster**. Defaults to `1` when instance architecture is **single node**.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the instance. Valid values are *prePaid*
               and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqInstanceConfigArgs', 'DmsRocketmqInstanceConfigArgsDict']]]] configs: Specifies the instance configs.
               The configs structure is documented below.
               
               <a name="dms_configs"></a>
               The `configs` block supports:
        :param pulumi.Input[_builtins.str] description: Specifies the description of the DMS RocketMQ instance.
               The description can contain a maximum of `1,024` characters.
        :param pulumi.Input[_builtins.bool] enable_acl: Specifies whether access control is enabled.
        :param pulumi.Input[_builtins.bool] enable_publicip: Specifies whether to enable public access. By default, public access is disabled.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the version of the RocketMQ engine.
               Valid values are **4.8.0** and **5.x**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the instance.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the flavor ID.
        :param pulumi.Input[_builtins.bool] ipv6_enable: Specifies whether to support IPv6. Defaults to **false**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the config name.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance. If `period_unit` is set to *month*
               , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from `1` to `3`. This parameter is
               mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] publicip_id: Specifies the ID of the EIP bound to the instance. Use commas (,) to separate
               multiple EIP IDs. It is mandatory if `enable_publicip` is **true** and should be empty when `enable_publicip` is **false**.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] retention_policy: Specifies whether access control is enabled.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[_builtins.bool] ssl_enable: Specifies whether the RocketMQ SASL_SSL is enabled. Defaults to **false**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] storage_space: Specifies the message storage capacity, Unit: GB.
               When `engine_version` is **4.8.0**, value ranges from `300` to `30,000`.
               When `engine_version` is **5.x**, value ranges from `200` to `60,000`.
        :param pulumi.Input[_builtins.str] storage_spec_code: Specifies the storage I/O specification.
               The options are as follows:
               + **dms.physical.storage.high.v2**: high I/O disk
               + **dms.physical.storage.ultra.v2**: ultra-high I/O disk
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of a subnet.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the instance.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC.
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DmsRocketmqInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage DMS RocketMQ instance resources within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        security_group_id = config.require_object("securityGroupId")
        availability_zones = config.require_object("availabilityZones")
        test = sbercloud.DmsRocketmqInstance("test",
            name="rocketmq_name_test",
            description="this is a rocketmq instance",
            engine_version="4.8.0",
            storage_space=300,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=security_group_id,
            availability_zones=availability_zones,
            flavor_id="c6.4u8g.cluster",
            storage_spec_code="dms.physical.storage.high.v2",
            broker_num=1)
        ```

        ## Import

        The rocketmq instance can be imported using the `id`, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/dmsRocketmqInstance:DmsRocketmqInstance test 8d3c7938-dc47-4937-a30f-c80de381c5e3
        ```

        :param str resource_name: The name of the resource.
        :param DmsRocketmqInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DmsRocketmqInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 broker_num: Optional[pulumi.Input[_builtins.int]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqInstanceConfigArgs', 'DmsRocketmqInstanceConfigArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_acl: Optional[pulumi.Input[_builtins.bool]] = None,
                 enable_publicip: Optional[pulumi.Input[_builtins.bool]] = None,
                 engine_version: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 publicip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 retention_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 storage_space: Optional[pulumi.Input[_builtins.int]] = None,
                 storage_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DmsRocketmqInstanceArgs.__new__(DmsRocketmqInstanceArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            if availability_zones is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zones'")
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["broker_num"] = broker_num
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["configs"] = configs
            __props__.__dict__["description"] = description
            __props__.__dict__["enable_acl"] = enable_acl
            __props__.__dict__["enable_publicip"] = enable_publicip
            if engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'engine_version'")
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if flavor_id is None and not opts.urn:
                raise TypeError("Missing required property 'flavor_id'")
            __props__.__dict__["flavor_id"] = flavor_id
            __props__.__dict__["ipv6_enable"] = ipv6_enable
            __props__.__dict__["name"] = name
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["publicip_id"] = publicip_id
            __props__.__dict__["region"] = region
            __props__.__dict__["retention_policy"] = retention_policy
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["ssl_enable"] = ssl_enable
            if storage_space is None and not opts.urn:
                raise TypeError("Missing required property 'storage_space'")
            __props__.__dict__["storage_space"] = storage_space
            if storage_spec_code is None and not opts.urn:
                raise TypeError("Missing required property 'storage_spec_code'")
            __props__.__dict__["storage_spec_code"] = storage_spec_code
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["broker_address"] = None
            __props__.__dict__["cross_vpc_accesses"] = None
            __props__.__dict__["maintain_begin"] = None
            __props__.__dict__["maintain_end"] = None
            __props__.__dict__["namesrv_address"] = None
            __props__.__dict__["new_spec_billing_enable"] = None
            __props__.__dict__["node_num"] = None
            __props__.__dict__["public_broker_address"] = None
            __props__.__dict__["public_namesrv_address"] = None
            __props__.__dict__["publicip_address"] = None
            __props__.__dict__["resource_spec_code"] = None
            __props__.__dict__["specification"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["type"] = None
            __props__.__dict__["used_storage_space"] = None
        super(DmsRocketmqInstance, __self__).__init__(
            'sbercloud:index/dmsRocketmqInstance:DmsRocketmqInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            broker_address: Optional[pulumi.Input[_builtins.str]] = None,
            broker_num: Optional[pulumi.Input[_builtins.int]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqInstanceConfigArgs', 'DmsRocketmqInstanceConfigArgsDict']]]]] = None,
            cross_vpc_accesses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqInstanceCrossVpcAccessArgs', 'DmsRocketmqInstanceCrossVpcAccessArgsDict']]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enable_acl: Optional[pulumi.Input[_builtins.bool]] = None,
            enable_publicip: Optional[pulumi.Input[_builtins.bool]] = None,
            engine_version: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
            ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            maintain_begin: Optional[pulumi.Input[_builtins.str]] = None,
            maintain_end: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            namesrv_address: Optional[pulumi.Input[_builtins.str]] = None,
            new_spec_billing_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            node_num: Optional[pulumi.Input[_builtins.int]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            public_broker_address: Optional[pulumi.Input[_builtins.str]] = None,
            public_namesrv_address: Optional[pulumi.Input[_builtins.str]] = None,
            publicip_address: Optional[pulumi.Input[_builtins.str]] = None,
            publicip_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            resource_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
            retention_policy: Optional[pulumi.Input[_builtins.bool]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            specification: Optional[pulumi.Input[_builtins.str]] = None,
            ssl_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            storage_space: Optional[pulumi.Input[_builtins.int]] = None,
            storage_spec_code: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            used_storage_space: Optional[pulumi.Input[_builtins.int]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DmsRocketmqInstance':
        """
        Get an existing DmsRocketmqInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] auto_renew: Specifies whether auto renew is enabled. Valid values are "true" and "false".
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] availability_zones: Specifies the list of availability zone names, where
               instance brokers reside and which has available resources.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] broker_address: Indicates the service data address.
        :param pulumi.Input[_builtins.int] broker_num: Specifies the broker numbers. It's **required** when instance architecture is
               **cluster**. Defaults to `1` when instance architecture is **single node**.
        :param pulumi.Input[_builtins.str] charging_mode: Specifies the charging mode of the instance. Valid values are *prePaid*
               and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqInstanceConfigArgs', 'DmsRocketmqInstanceConfigArgsDict']]]] configs: Specifies the instance configs.
               The configs structure is documented below.
               
               <a name="dms_configs"></a>
               The `configs` block supports:
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqInstanceCrossVpcAccessArgs', 'DmsRocketmqInstanceCrossVpcAccessArgsDict']]]] cross_vpc_accesses: Indicates the Access information of cross-VPC. The structure is documented below.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the DMS RocketMQ instance.
               The description can contain a maximum of `1,024` characters.
        :param pulumi.Input[_builtins.bool] enable_acl: Specifies whether access control is enabled.
        :param pulumi.Input[_builtins.bool] enable_publicip: Specifies whether to enable public access. By default, public access is disabled.
        :param pulumi.Input[_builtins.str] engine_version: Specifies the version of the RocketMQ engine.
               Valid values are **4.8.0** and **5.x**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id of the instance.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the flavor ID.
        :param pulumi.Input[_builtins.bool] ipv6_enable: Specifies whether to support IPv6. Defaults to **false**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] maintain_begin: Indicates the time at which the maintenance window starts. The format is HH:mm:ss.
        :param pulumi.Input[_builtins.str] maintain_end: Indicates the time at which the maintenance window ends. The format is HH:mm:ss.
        :param pulumi.Input[_builtins.str] name: Specifies the config name.
        :param pulumi.Input[_builtins.str] namesrv_address: Indicates the metadata address.
        :param pulumi.Input[_builtins.bool] new_spec_billing_enable: Indicates whether billing based on new specifications is enabled.
        :param pulumi.Input[_builtins.int] node_num: Indicates the node quantity.
        :param pulumi.Input[_builtins.int] period: Specifies the charging period of the instance. If `period_unit` is set to *month*
               , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from `1` to `3`. This parameter is
               mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] public_broker_address: Indicates the public network service data address.
        :param pulumi.Input[_builtins.str] public_namesrv_address: Indicates the public network metadata address.
        :param pulumi.Input[_builtins.str] publicip_address: Indicates the public IP address.
        :param pulumi.Input[_builtins.str] publicip_id: Specifies the ID of the EIP bound to the instance. Use commas (,) to separate
               multiple EIP IDs. It is mandatory if `enable_publicip` is **true** and should be empty when `enable_publicip` is **false**.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] resource_spec_code: Indicates the resource specifications.
        :param pulumi.Input[_builtins.bool] retention_policy: Specifies whether access control is enabled.
        :param pulumi.Input[_builtins.str] security_group_id: Specifies the ID of a security group.
        :param pulumi.Input[_builtins.str] specification: Indicates the instance specification. For a cluster DMS RocketMQ instance, VM specifications
               and the number of nodes are returned.
        :param pulumi.Input[_builtins.bool] ssl_enable: Specifies whether the RocketMQ SASL_SSL is enabled. Defaults to **false**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: Indicates the status of the DMS RocketMQ instance.
        :param pulumi.Input[_builtins.int] storage_space: Specifies the message storage capacity, Unit: GB.
               When `engine_version` is **4.8.0**, value ranges from `300` to `30,000`.
               When `engine_version` is **5.x**, value ranges from `200` to `60,000`.
        :param pulumi.Input[_builtins.str] storage_spec_code: Specifies the storage I/O specification.
               The options are as follows:
               + **dms.physical.storage.high.v2**: high I/O disk
               + **dms.physical.storage.ultra.v2**: ultra-high I/O disk
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies the ID of a subnet.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the instance.
        :param pulumi.Input[_builtins.str] type: Indicates the DMS RocketMQ instance type. Value: cluster.
        :param pulumi.Input[_builtins.int] used_storage_space: Indicates the used message storage space. Unit: GB.
        :param pulumi.Input[_builtins.str] vpc_id: Specifies the ID of a VPC.
               Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DmsRocketmqInstanceState.__new__(_DmsRocketmqInstanceState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["broker_address"] = broker_address
        __props__.__dict__["broker_num"] = broker_num
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["configs"] = configs
        __props__.__dict__["cross_vpc_accesses"] = cross_vpc_accesses
        __props__.__dict__["description"] = description
        __props__.__dict__["enable_acl"] = enable_acl
        __props__.__dict__["enable_publicip"] = enable_publicip
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["ipv6_enable"] = ipv6_enable
        __props__.__dict__["maintain_begin"] = maintain_begin
        __props__.__dict__["maintain_end"] = maintain_end
        __props__.__dict__["name"] = name
        __props__.__dict__["namesrv_address"] = namesrv_address
        __props__.__dict__["new_spec_billing_enable"] = new_spec_billing_enable
        __props__.__dict__["node_num"] = node_num
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["public_broker_address"] = public_broker_address
        __props__.__dict__["public_namesrv_address"] = public_namesrv_address
        __props__.__dict__["publicip_address"] = publicip_address
        __props__.__dict__["publicip_id"] = publicip_id
        __props__.__dict__["region"] = region
        __props__.__dict__["resource_spec_code"] = resource_spec_code
        __props__.__dict__["retention_policy"] = retention_policy
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["specification"] = specification
        __props__.__dict__["ssl_enable"] = ssl_enable
        __props__.__dict__["status"] = status
        __props__.__dict__["storage_space"] = storage_space
        __props__.__dict__["storage_spec_code"] = storage_spec_code
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["used_storage_space"] = used_storage_space
        __props__.__dict__["vpc_id"] = vpc_id
        return DmsRocketmqInstance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies whether auto renew is enabled. Valid values are "true" and "false".
        """
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies the list of availability zone names, where
        instance brokers reside and which has available resources.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="brokerAddress")
    def broker_address(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the service data address.
        """
        return pulumi.get(self, "broker_address")

    @_builtins.property
    @pulumi.getter(name="brokerNum")
    def broker_num(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the broker numbers. It's **required** when instance architecture is
        **cluster**. Defaults to `1` when instance architecture is **single node**.
        """
        return pulumi.get(self, "broker_num")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the charging mode of the instance. Valid values are *prePaid*
        and *postPaid*, defaults to *postPaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter
    def configs(self) -> pulumi.Output[Sequence['outputs.DmsRocketmqInstanceConfig']]:
        """
        Specifies the instance configs.
        The configs structure is documented below.

        <a name="dms_configs"></a>
        The `configs` block supports:
        """
        return pulumi.get(self, "configs")

    @_builtins.property
    @pulumi.getter(name="crossVpcAccesses")
    def cross_vpc_accesses(self) -> pulumi.Output[Sequence['outputs.DmsRocketmqInstanceCrossVpcAccess']]:
        """
        Indicates the Access information of cross-VPC. The structure is documented below.
        """
        return pulumi.get(self, "cross_vpc_accesses")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the description of the DMS RocketMQ instance.
        The description can contain a maximum of `1,024` characters.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="enableAcl")
    def enable_acl(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether access control is enabled.
        """
        return pulumi.get(self, "enable_acl")

    @_builtins.property
    @pulumi.getter(name="enablePublicip")
    def enable_publicip(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable public access. By default, public access is disabled.
        """
        return pulumi.get(self, "enable_publicip")

    @_builtins.property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the version of the RocketMQ engine.
        Valid values are **4.8.0** and **5.x**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "engine_version")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the enterprise project id of the instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the flavor ID.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to support IPv6. Defaults to **false**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ipv6_enable")

    @_builtins.property
    @pulumi.getter(name="maintainBegin")
    def maintain_begin(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the time at which the maintenance window starts. The format is HH:mm:ss.
        """
        return pulumi.get(self, "maintain_begin")

    @_builtins.property
    @pulumi.getter(name="maintainEnd")
    def maintain_end(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the time at which the maintenance window ends. The format is HH:mm:ss.
        """
        return pulumi.get(self, "maintain_end")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the config name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namesrvAddress")
    def namesrv_address(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the metadata address.
        """
        return pulumi.get(self, "namesrv_address")

    @_builtins.property
    @pulumi.getter(name="newSpecBillingEnable")
    def new_spec_billing_enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Indicates whether billing based on new specifications is enabled.
        """
        return pulumi.get(self, "new_spec_billing_enable")

    @_builtins.property
    @pulumi.getter(name="nodeNum")
    def node_num(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates the node quantity.
        """
        return pulumi.get(self, "node_num")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the charging period of the instance. If `period_unit` is set to *month*
        , the value ranges from 1 to 9. If `period_unit` is set to *year*, the value ranges from `1` to `3`. This parameter is
        mandatory if `charging_mode` is set to *prePaid*. Changing this creates a new resource.
        """
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="publicBrokerAddress")
    def public_broker_address(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the public network service data address.
        """
        return pulumi.get(self, "public_broker_address")

    @_builtins.property
    @pulumi.getter(name="publicNamesrvAddress")
    def public_namesrv_address(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the public network metadata address.
        """
        return pulumi.get(self, "public_namesrv_address")

    @_builtins.property
    @pulumi.getter(name="publicipAddress")
    def publicip_address(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the public IP address.
        """
        return pulumi.get(self, "publicip_address")

    @_builtins.property
    @pulumi.getter(name="publicipId")
    def publicip_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of the EIP bound to the instance. Use commas (,) to separate
        multiple EIP IDs. It is mandatory if `enable_publicip` is **true** and should be empty when `enable_publicip` is **false**.
        """
        return pulumi.get(self, "publicip_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="resourceSpecCode")
    def resource_spec_code(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the resource specifications.
        """
        return pulumi.get(self, "resource_spec_code")

    @_builtins.property
    @pulumi.getter(name="retentionPolicy")
    @_utilities.deprecated("""Use 'enable_acl' instead""")
    def retention_policy(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether access control is enabled.
        """
        return pulumi.get(self, "retention_policy")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of a security group.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def specification(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the instance specification. For a cluster DMS RocketMQ instance, VM specifications
        and the number of nodes are returned.
        """
        return pulumi.get(self, "specification")

    @_builtins.property
    @pulumi.getter(name="sslEnable")
    def ssl_enable(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether the RocketMQ SASL_SSL is enabled. Defaults to **false**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ssl_enable")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the status of the DMS RocketMQ instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the message storage capacity, Unit: GB.
        When `engine_version` is **4.8.0**, value ranges from `300` to `30,000`.
        When `engine_version` is **5.x**, value ranges from `200` to `60,000`.
        """
        return pulumi.get(self, "storage_space")

    @_builtins.property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the storage I/O specification.
        The options are as follows:
        + **dms.physical.storage.high.v2**: high I/O disk
        + **dms.physical.storage.ultra.v2**: ultra-high I/O disk
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "storage_spec_code")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of a subnet.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the key/value pairs to associate with the instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the DMS RocketMQ instance type. Value: cluster.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="usedStorageSpace")
    def used_storage_space(self) -> pulumi.Output[_builtins.int]:
        """
        Indicates the used message storage space. Unit: GB.
        """
        return pulumi.get(self, "used_storage_space")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of a VPC.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

