# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['DmsRocketmqMessageOffsetResetArgs', 'DmsRocketmqMessageOffsetReset']

@pulumi.input_type
class DmsRocketmqMessageOffsetResetArgs:
    def __init__(__self__, *,
                 group: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 timestamp: pulumi.Input[_builtins.str],
                 topic: pulumi.Input[_builtins.str],
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DmsRocketmqMessageOffsetReset resource.
        :param pulumi.Input[_builtins.str] group: Specifies the group name.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the instance ID.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] timestamp: Specifies the timestamp.
               + If it is specified as **0**, reset to earliset.
               + If it is specified as **-1**, reset to latest.
               + If it is specified as a timestamp in milliseconds, reset to specific time.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] topic: Specifies the topic name.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        """
        pulumi.set(__self__, "group", group)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "timestamp", timestamp)
        pulumi.set(__self__, "topic", topic)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter
    def group(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the group name.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the instance ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def timestamp(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the timestamp.
        + If it is specified as **0**, reset to earliset.
        + If it is specified as **-1**, reset to latest.
        + If it is specified as a timestamp in milliseconds, reset to specific time.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "timestamp")

    @timestamp.setter
    def timestamp(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "timestamp", value)

    @_builtins.property
    @pulumi.getter
    def topic(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the topic name.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "topic", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _DmsRocketmqMessageOffsetResetState:
    def __init__(__self__, *,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DmsRocketmqMessageOffsetReset resources.
        :param pulumi.Input[_builtins.str] group: Specifies the group name.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the instance ID.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] timestamp: Specifies the timestamp.
               + If it is specified as **0**, reset to earliset.
               + If it is specified as **-1**, reset to latest.
               + If it is specified as a timestamp in milliseconds, reset to specific time.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] topic: Specifies the topic name.
               Changing this creates a new resource.
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if timestamp is not None:
            pulumi.set(__self__, "timestamp", timestamp)
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the group name.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the instance ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def timestamp(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the timestamp.
        + If it is specified as **0**, reset to earliset.
        + If it is specified as **-1**, reset to latest.
        + If it is specified as a timestamp in milliseconds, reset to specific time.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "timestamp")

    @timestamp.setter
    def timestamp(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "timestamp", value)

    @_builtins.property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the topic name.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "topic", value)


@pulumi.type_token("sbercloud:index/dmsRocketmqMessageOffsetReset:DmsRocketmqMessageOffsetReset")
class DmsRocketmqMessageOffsetReset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a DMS RocketMQ message offset reset resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        group = config.require_object("group")
        topic = config.require_object("topic")
        test = sbercloud.DmsRocketmqMessageOffsetReset("test",
            instance_id=instance_id,
            group=group,
            topic=topic,
            timestamp="0")
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group: Specifies the group name.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the instance ID.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] timestamp: Specifies the timestamp.
               + If it is specified as **0**, reset to earliset.
               + If it is specified as **-1**, reset to latest.
               + If it is specified as a timestamp in milliseconds, reset to specific time.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] topic: Specifies the topic name.
               Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DmsRocketmqMessageOffsetResetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DMS RocketMQ message offset reset resource within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        group = config.require_object("group")
        topic = config.require_object("topic")
        test = sbercloud.DmsRocketmqMessageOffsetReset("test",
            instance_id=instance_id,
            group=group,
            topic=topic,
            timestamp="0")
        ```

        :param str resource_name: The name of the resource.
        :param DmsRocketmqMessageOffsetResetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DmsRocketmqMessageOffsetResetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 timestamp: Optional[pulumi.Input[_builtins.str]] = None,
                 topic: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DmsRocketmqMessageOffsetResetArgs.__new__(DmsRocketmqMessageOffsetResetArgs)

            if group is None and not opts.urn:
                raise TypeError("Missing required property 'group'")
            __props__.__dict__["group"] = group
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["region"] = region
            if timestamp is None and not opts.urn:
                raise TypeError("Missing required property 'timestamp'")
            __props__.__dict__["timestamp"] = timestamp
            if topic is None and not opts.urn:
                raise TypeError("Missing required property 'topic'")
            __props__.__dict__["topic"] = topic
        super(DmsRocketmqMessageOffsetReset, __self__).__init__(
            'sbercloud:index/dmsRocketmqMessageOffsetReset:DmsRocketmqMessageOffsetReset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            timestamp: Optional[pulumi.Input[_builtins.str]] = None,
            topic: Optional[pulumi.Input[_builtins.str]] = None) -> 'DmsRocketmqMessageOffsetReset':
        """
        Get an existing DmsRocketmqMessageOffsetReset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group: Specifies the group name.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the instance ID.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] timestamp: Specifies the timestamp.
               + If it is specified as **0**, reset to earliset.
               + If it is specified as **-1**, reset to latest.
               + If it is specified as a timestamp in milliseconds, reset to specific time.
               
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] topic: Specifies the topic name.
               Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DmsRocketmqMessageOffsetResetState.__new__(_DmsRocketmqMessageOffsetResetState)

        __props__.__dict__["group"] = group
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["region"] = region
        __props__.__dict__["timestamp"] = timestamp
        __props__.__dict__["topic"] = topic
        return DmsRocketmqMessageOffsetReset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def group(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the group name.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the instance ID.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def timestamp(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the timestamp.
        + If it is specified as **0**, reset to earliset.
        + If it is specified as **-1**, reset to latest.
        + If it is specified as a timestamp in milliseconds, reset to specific time.

        Changing this creates a new resource.
        """
        return pulumi.get(self, "timestamp")

    @_builtins.property
    @pulumi.getter
    def topic(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the topic name.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "topic")

