# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DmsRocketmqMigrationTaskArgs', 'DmsRocketmqMigrationTask']

@pulumi.input_type
class DmsRocketmqMigrationTaskArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 overwrite: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskBindingArgs']]]] = None,
                 exchanges: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskExchangeArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 queues: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskQueueArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_groups: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskSubscriptionGroupArgs']]]] = None,
                 topic_configs: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskTopicConfigArgs']]]] = None,
                 vhosts: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskVhostArgs']]]] = None):
        """
        The set of arguments for constructing a DmsRocketmqMigrationTask resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RocketMQ instance.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] overwrite: Specifies whether to overwrite configurations with the same name.
               Value options:
               + **true**: Configurations in the destination metadata with the same name as the source metadata will be overwritten.
               + **false**: An error is reported when a topic or group already exists.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] type: Specifies the exchange type. Changing this creates a new resource.
               
               <a name="RocketMQ_migration_task_bindings"></a>
               The `bindings` block supports:
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskBindingArgs']]] bindings: Specifies the binding metadata.
               The bindings structure is documented below.
               Changing this creates a new resource.
               
               > **NOTE:** Parameters `vhosts`, `queues`, `exchanges` and `bindings` are required when `type` is set to **rabbitToRocket**.
               
               <a name="RocketMQ_migration_task_topic_configs"></a>
               The `topic_configs` block supports:
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskExchangeArgs']]] exchanges: Specifies the exchange metadata.
               The exchanges structure is documented below.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the switch name. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskQueueArgs']]] queues: Specifies the queue metadata.
               The queues structure is documented below.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskSubscriptionGroupArgs']]] subscription_groups: Specifies the consumer group metadata.
               The subscription_groups structure is documented below.
               Changing this creates a new resource.
               
               > **NOTE:** Parameters `topic_configs` and `subscription_groups` are required when `type` is set to **rocketmq**.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskTopicConfigArgs']]] topic_configs: Specifies the topic metadata.
               The topic_configs structure is documented below.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskVhostArgs']]] vhosts: Specifies the virtual hosts metadata.
               The vhosts structure is documented below.
               Changing this creates a new resource.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "overwrite", overwrite)
        pulumi.set(__self__, "type", type)
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if exchanges is not None:
            pulumi.set(__self__, "exchanges", exchanges)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if queues is not None:
            pulumi.set(__self__, "queues", queues)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if subscription_groups is not None:
            pulumi.set(__self__, "subscription_groups", subscription_groups)
        if topic_configs is not None:
            pulumi.set(__self__, "topic_configs", topic_configs)
        if vhosts is not None:
            pulumi.set(__self__, "vhosts", vhosts)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the RocketMQ instance.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def overwrite(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies whether to overwrite configurations with the same name.
        Value options:
        + **true**: Configurations in the destination metadata with the same name as the source metadata will be overwritten.
        + **false**: An error is reported when a topic or group already exists.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "overwrite")

    @overwrite.setter
    def overwrite(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "overwrite", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the exchange type. Changing this creates a new resource.

        <a name="RocketMQ_migration_task_bindings"></a>
        The `bindings` block supports:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskBindingArgs']]]]:
        """
        Specifies the binding metadata.
        The bindings structure is documented below.
        Changing this creates a new resource.

        > **NOTE:** Parameters `vhosts`, `queues`, `exchanges` and `bindings` are required when `type` is set to **rabbitToRocket**.

        <a name="RocketMQ_migration_task_topic_configs"></a>
        The `topic_configs` block supports:
        """
        return pulumi.get(self, "bindings")

    @bindings.setter
    def bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskBindingArgs']]]]):
        pulumi.set(self, "bindings", value)

    @_builtins.property
    @pulumi.getter
    def exchanges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskExchangeArgs']]]]:
        """
        Specifies the exchange metadata.
        The exchanges structure is documented below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "exchanges")

    @exchanges.setter
    def exchanges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskExchangeArgs']]]]):
        pulumi.set(self, "exchanges", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the switch name. Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def queues(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskQueueArgs']]]]:
        """
        Specifies the queue metadata.
        The queues structure is documented below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "queues")

    @queues.setter
    def queues(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskQueueArgs']]]]):
        pulumi.set(self, "queues", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionGroups")
    def subscription_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskSubscriptionGroupArgs']]]]:
        """
        Specifies the consumer group metadata.
        The subscription_groups structure is documented below.
        Changing this creates a new resource.

        > **NOTE:** Parameters `topic_configs` and `subscription_groups` are required when `type` is set to **rocketmq**.
        """
        return pulumi.get(self, "subscription_groups")

    @subscription_groups.setter
    def subscription_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskSubscriptionGroupArgs']]]]):
        pulumi.set(self, "subscription_groups", value)

    @_builtins.property
    @pulumi.getter(name="topicConfigs")
    def topic_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskTopicConfigArgs']]]]:
        """
        Specifies the topic metadata.
        The topic_configs structure is documented below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "topic_configs")

    @topic_configs.setter
    def topic_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskTopicConfigArgs']]]]):
        pulumi.set(self, "topic_configs", value)

    @_builtins.property
    @pulumi.getter
    def vhosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskVhostArgs']]]]:
        """
        Specifies the virtual hosts metadata.
        The vhosts structure is documented below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "vhosts")

    @vhosts.setter
    def vhosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskVhostArgs']]]]):
        pulumi.set(self, "vhosts", value)


@pulumi.input_type
class _DmsRocketmqMigrationTaskState:
    def __init__(__self__, *,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskBindingArgs']]]] = None,
                 exchanges: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskExchangeArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 overwrite: Optional[pulumi.Input[_builtins.str]] = None,
                 queues: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskQueueArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 start_date: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_groups: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskSubscriptionGroupArgs']]]] = None,
                 topic_configs: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskTopicConfigArgs']]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vhosts: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskVhostArgs']]]] = None):
        """
        Input properties used for looking up and filtering DmsRocketmqMigrationTask resources.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskBindingArgs']]] bindings: Specifies the binding metadata.
               The bindings structure is documented below.
               Changing this creates a new resource.
               
               > **NOTE:** Parameters `vhosts`, `queues`, `exchanges` and `bindings` are required when `type` is set to **rabbitToRocket**.
               
               <a name="RocketMQ_migration_task_topic_configs"></a>
               The `topic_configs` block supports:
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskExchangeArgs']]] exchanges: Specifies the exchange metadata.
               The exchanges structure is documented below.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RocketMQ instance.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the switch name. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] overwrite: Specifies whether to overwrite configurations with the same name.
               Value options:
               + **true**: Configurations in the destination metadata with the same name as the source metadata will be overwritten.
               + **false**: An error is reported when a topic or group already exists.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskQueueArgs']]] queues: Specifies the queue metadata.
               The queues structure is documented below.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] start_date: Indicates the start time of the migration task.
        :param pulumi.Input[_builtins.str] status: Indicates the status of the migration task. The value can be **finished** or **failed***.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskSubscriptionGroupArgs']]] subscription_groups: Specifies the consumer group metadata.
               The subscription_groups structure is documented below.
               Changing this creates a new resource.
               
               > **NOTE:** Parameters `topic_configs` and `subscription_groups` are required when `type` is set to **rocketmq**.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskTopicConfigArgs']]] topic_configs: Specifies the topic metadata.
               The topic_configs structure is documented below.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] type: Specifies the exchange type. Changing this creates a new resource.
               
               <a name="RocketMQ_migration_task_bindings"></a>
               The `bindings` block supports:
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskVhostArgs']]] vhosts: Specifies the virtual hosts metadata.
               The vhosts structure is documented below.
               Changing this creates a new resource.
        """
        if bindings is not None:
            pulumi.set(__self__, "bindings", bindings)
        if exchanges is not None:
            pulumi.set(__self__, "exchanges", exchanges)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if overwrite is not None:
            pulumi.set(__self__, "overwrite", overwrite)
        if queues is not None:
            pulumi.set(__self__, "queues", queues)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if start_date is not None:
            pulumi.set(__self__, "start_date", start_date)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subscription_groups is not None:
            pulumi.set(__self__, "subscription_groups", subscription_groups)
        if topic_configs is not None:
            pulumi.set(__self__, "topic_configs", topic_configs)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if vhosts is not None:
            pulumi.set(__self__, "vhosts", vhosts)

    @_builtins.property
    @pulumi.getter
    def bindings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskBindingArgs']]]]:
        """
        Specifies the binding metadata.
        The bindings structure is documented below.
        Changing this creates a new resource.

        > **NOTE:** Parameters `vhosts`, `queues`, `exchanges` and `bindings` are required when `type` is set to **rabbitToRocket**.

        <a name="RocketMQ_migration_task_topic_configs"></a>
        The `topic_configs` block supports:
        """
        return pulumi.get(self, "bindings")

    @bindings.setter
    def bindings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskBindingArgs']]]]):
        pulumi.set(self, "bindings", value)

    @_builtins.property
    @pulumi.getter
    def exchanges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskExchangeArgs']]]]:
        """
        Specifies the exchange metadata.
        The exchanges structure is documented below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "exchanges")

    @exchanges.setter
    def exchanges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskExchangeArgs']]]]):
        pulumi.set(self, "exchanges", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the RocketMQ instance.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the switch name. Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def overwrite(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies whether to overwrite configurations with the same name.
        Value options:
        + **true**: Configurations in the destination metadata with the same name as the source metadata will be overwritten.
        + **false**: An error is reported when a topic or group already exists.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "overwrite")

    @overwrite.setter
    def overwrite(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "overwrite", value)

    @_builtins.property
    @pulumi.getter
    def queues(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskQueueArgs']]]]:
        """
        Specifies the queue metadata.
        The queues structure is documented below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "queues")

    @queues.setter
    def queues(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskQueueArgs']]]]):
        pulumi.set(self, "queues", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the start time of the migration task.
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_date", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Indicates the status of the migration task. The value can be **finished** or **failed***.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionGroups")
    def subscription_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskSubscriptionGroupArgs']]]]:
        """
        Specifies the consumer group metadata.
        The subscription_groups structure is documented below.
        Changing this creates a new resource.

        > **NOTE:** Parameters `topic_configs` and `subscription_groups` are required when `type` is set to **rocketmq**.
        """
        return pulumi.get(self, "subscription_groups")

    @subscription_groups.setter
    def subscription_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskSubscriptionGroupArgs']]]]):
        pulumi.set(self, "subscription_groups", value)

    @_builtins.property
    @pulumi.getter(name="topicConfigs")
    def topic_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskTopicConfigArgs']]]]:
        """
        Specifies the topic metadata.
        The topic_configs structure is documented below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "topic_configs")

    @topic_configs.setter
    def topic_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskTopicConfigArgs']]]]):
        pulumi.set(self, "topic_configs", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the exchange type. Changing this creates a new resource.

        <a name="RocketMQ_migration_task_bindings"></a>
        The `bindings` block supports:
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def vhosts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskVhostArgs']]]]:
        """
        Specifies the virtual hosts metadata.
        The vhosts structure is documented below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "vhosts")

    @vhosts.setter
    def vhosts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqMigrationTaskVhostArgs']]]]):
        pulumi.set(self, "vhosts", value)


@pulumi.type_token("sbercloud:index/dmsRocketmqMigrationTask:DmsRocketmqMigrationTask")
class DmsRocketmqMigrationTask(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskBindingArgs', 'DmsRocketmqMigrationTaskBindingArgsDict']]]]] = None,
                 exchanges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskExchangeArgs', 'DmsRocketmqMigrationTaskExchangeArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 overwrite: Optional[pulumi.Input[_builtins.str]] = None,
                 queues: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskQueueArgs', 'DmsRocketmqMigrationTaskQueueArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskSubscriptionGroupArgs', 'DmsRocketmqMigrationTaskSubscriptionGroupArgsDict']]]]] = None,
                 topic_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskTopicConfigArgs', 'DmsRocketmqMigrationTaskTopicConfigArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vhosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskVhostArgs', 'DmsRocketmqMigrationTaskVhostArgsDict']]]]] = None,
                 __props__=None):
        """
        Manages a DMS RocketMQ migration task resource within SberCloud.

        ## Example Usage

        ### RoecktMQ migration task from RocketMQ to RocketMQ

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        name = config.require_object("name")
        topic_name = config.require_object("topicName")
        group_name = config.require_object("groupName")
        test = sbercloud.DmsRocketmqMigrationTask("test",
            instance_id=instance_id,
            overwrite="true",
            name=name,
            type="rocketmq",
            topic_configs=[{
                "order": False,
                "perm": 6,
                "read_queue_num": 16,
                "topic_filter_type": "SINGLE_TAG",
                "topic_name": topic_name,
                "topic_sys_flag": 0,
                "write_queue_num": 16,
            }],
            subscription_groups=[{
                "consume_broadcast_enable": True,
                "consume_enable": True,
                "consume_from_min_enable": True,
                "group_name": group_name,
                "notify_consumerids_changed_enable": True,
                "retry_max_times": 16,
                "retry_queue_num": 1,
                "which_broker_when_consume_slow": 1,
            }])
        ```

        ### RoecktMQ migration task from RabbitMQ to RocketMQ

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        name = config.require_object("name")
        vhost_name = config.require_object("vhostName")
        queue_name = config.require_object("queueName")
        exchange_name = config.require_object("exchangeName")
        test = sbercloud.DmsRocketmqMigrationTask("test",
            instance_id=instance_id,
            overwrite="true",
            name=name,
            type="rabbitToRocket",
            vhosts=[{
                "name": vhost_name,
            }],
            queues=[{
                "name": queue_name,
                "vhost": vhost_name,
                "durable": False,
            }],
            exchanges=[{
                "name": exchange_name,
                "vhost": vhost_name,
                "type": "topic",
                "durable": False,
            }],
            bindings=[{
                "source": exchange_name,
                "vhost": vhost_name,
                "destination": queue_name,
                "destination_type": "queue",
                "routing_key": queue_name,
            }])
        ```

        ## Import

        The RocketMQ migration task can be imported using the RocketMQ instance ID and the RocketMQ migration task ID

        separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/dmsRocketmqMigrationTask:DmsRocketmqMigrationTask test <instance_id>/<id>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attribute includes: `overwrite`.

        It is generally recommended running `pulumi preview` after importing the task. You can then decide

        if changes should be applied to the task, or the resource definition should be updated to align with the task.

        Also you can ignore changes as below.

        hcl

        resource "sbercloud_dms_rocketmq_migration_task" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              overwrite,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskBindingArgs', 'DmsRocketmqMigrationTaskBindingArgsDict']]]] bindings: Specifies the binding metadata.
               The bindings structure is documented below.
               Changing this creates a new resource.
               
               > **NOTE:** Parameters `vhosts`, `queues`, `exchanges` and `bindings` are required when `type` is set to **rabbitToRocket**.
               
               <a name="RocketMQ_migration_task_topic_configs"></a>
               The `topic_configs` block supports:
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskExchangeArgs', 'DmsRocketmqMigrationTaskExchangeArgsDict']]]] exchanges: Specifies the exchange metadata.
               The exchanges structure is documented below.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RocketMQ instance.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the switch name. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] overwrite: Specifies whether to overwrite configurations with the same name.
               Value options:
               + **true**: Configurations in the destination metadata with the same name as the source metadata will be overwritten.
               + **false**: An error is reported when a topic or group already exists.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskQueueArgs', 'DmsRocketmqMigrationTaskQueueArgsDict']]]] queues: Specifies the queue metadata.
               The queues structure is documented below.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskSubscriptionGroupArgs', 'DmsRocketmqMigrationTaskSubscriptionGroupArgsDict']]]] subscription_groups: Specifies the consumer group metadata.
               The subscription_groups structure is documented below.
               Changing this creates a new resource.
               
               > **NOTE:** Parameters `topic_configs` and `subscription_groups` are required when `type` is set to **rocketmq**.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskTopicConfigArgs', 'DmsRocketmqMigrationTaskTopicConfigArgsDict']]]] topic_configs: Specifies the topic metadata.
               The topic_configs structure is documented below.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] type: Specifies the exchange type. Changing this creates a new resource.
               
               <a name="RocketMQ_migration_task_bindings"></a>
               The `bindings` block supports:
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskVhostArgs', 'DmsRocketmqMigrationTaskVhostArgsDict']]]] vhosts: Specifies the virtual hosts metadata.
               The vhosts structure is documented below.
               Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DmsRocketmqMigrationTaskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DMS RocketMQ migration task resource within SberCloud.

        ## Example Usage

        ### RoecktMQ migration task from RocketMQ to RocketMQ

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        name = config.require_object("name")
        topic_name = config.require_object("topicName")
        group_name = config.require_object("groupName")
        test = sbercloud.DmsRocketmqMigrationTask("test",
            instance_id=instance_id,
            overwrite="true",
            name=name,
            type="rocketmq",
            topic_configs=[{
                "order": False,
                "perm": 6,
                "read_queue_num": 16,
                "topic_filter_type": "SINGLE_TAG",
                "topic_name": topic_name,
                "topic_sys_flag": 0,
                "write_queue_num": 16,
            }],
            subscription_groups=[{
                "consume_broadcast_enable": True,
                "consume_enable": True,
                "consume_from_min_enable": True,
                "group_name": group_name,
                "notify_consumerids_changed_enable": True,
                "retry_max_times": 16,
                "retry_queue_num": 1,
                "which_broker_when_consume_slow": 1,
            }])
        ```

        ### RoecktMQ migration task from RabbitMQ to RocketMQ

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        name = config.require_object("name")
        vhost_name = config.require_object("vhostName")
        queue_name = config.require_object("queueName")
        exchange_name = config.require_object("exchangeName")
        test = sbercloud.DmsRocketmqMigrationTask("test",
            instance_id=instance_id,
            overwrite="true",
            name=name,
            type="rabbitToRocket",
            vhosts=[{
                "name": vhost_name,
            }],
            queues=[{
                "name": queue_name,
                "vhost": vhost_name,
                "durable": False,
            }],
            exchanges=[{
                "name": exchange_name,
                "vhost": vhost_name,
                "type": "topic",
                "durable": False,
            }],
            bindings=[{
                "source": exchange_name,
                "vhost": vhost_name,
                "destination": queue_name,
                "destination_type": "queue",
                "routing_key": queue_name,
            }])
        ```

        ## Import

        The RocketMQ migration task can be imported using the RocketMQ instance ID and the RocketMQ migration task ID

        separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/dmsRocketmqMigrationTask:DmsRocketmqMigrationTask test <instance_id>/<id>
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attribute includes: `overwrite`.

        It is generally recommended running `pulumi preview` after importing the task. You can then decide

        if changes should be applied to the task, or the resource definition should be updated to align with the task.

        Also you can ignore changes as below.

        hcl

        resource "sbercloud_dms_rocketmq_migration_task" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              overwrite,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param DmsRocketmqMigrationTaskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DmsRocketmqMigrationTaskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bindings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskBindingArgs', 'DmsRocketmqMigrationTaskBindingArgsDict']]]]] = None,
                 exchanges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskExchangeArgs', 'DmsRocketmqMigrationTaskExchangeArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 overwrite: Optional[pulumi.Input[_builtins.str]] = None,
                 queues: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskQueueArgs', 'DmsRocketmqMigrationTaskQueueArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskSubscriptionGroupArgs', 'DmsRocketmqMigrationTaskSubscriptionGroupArgsDict']]]]] = None,
                 topic_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskTopicConfigArgs', 'DmsRocketmqMigrationTaskTopicConfigArgsDict']]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 vhosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskVhostArgs', 'DmsRocketmqMigrationTaskVhostArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DmsRocketmqMigrationTaskArgs.__new__(DmsRocketmqMigrationTaskArgs)

            __props__.__dict__["bindings"] = bindings
            __props__.__dict__["exchanges"] = exchanges
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            if overwrite is None and not opts.urn:
                raise TypeError("Missing required property 'overwrite'")
            __props__.__dict__["overwrite"] = overwrite
            __props__.__dict__["queues"] = queues
            __props__.__dict__["region"] = region
            __props__.__dict__["subscription_groups"] = subscription_groups
            __props__.__dict__["topic_configs"] = topic_configs
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["vhosts"] = vhosts
            __props__.__dict__["start_date"] = None
            __props__.__dict__["status"] = None
        super(DmsRocketmqMigrationTask, __self__).__init__(
            'sbercloud:index/dmsRocketmqMigrationTask:DmsRocketmqMigrationTask',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bindings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskBindingArgs', 'DmsRocketmqMigrationTaskBindingArgsDict']]]]] = None,
            exchanges: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskExchangeArgs', 'DmsRocketmqMigrationTaskExchangeArgsDict']]]]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            overwrite: Optional[pulumi.Input[_builtins.str]] = None,
            queues: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskQueueArgs', 'DmsRocketmqMigrationTaskQueueArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            start_date: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_groups: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskSubscriptionGroupArgs', 'DmsRocketmqMigrationTaskSubscriptionGroupArgsDict']]]]] = None,
            topic_configs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskTopicConfigArgs', 'DmsRocketmqMigrationTaskTopicConfigArgsDict']]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            vhosts: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskVhostArgs', 'DmsRocketmqMigrationTaskVhostArgsDict']]]]] = None) -> 'DmsRocketmqMigrationTask':
        """
        Get an existing DmsRocketmqMigrationTask resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskBindingArgs', 'DmsRocketmqMigrationTaskBindingArgsDict']]]] bindings: Specifies the binding metadata.
               The bindings structure is documented below.
               Changing this creates a new resource.
               
               > **NOTE:** Parameters `vhosts`, `queues`, `exchanges` and `bindings` are required when `type` is set to **rabbitToRocket**.
               
               <a name="RocketMQ_migration_task_topic_configs"></a>
               The `topic_configs` block supports:
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskExchangeArgs', 'DmsRocketmqMigrationTaskExchangeArgsDict']]]] exchanges: Specifies the exchange metadata.
               The exchanges structure is documented below.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the RocketMQ instance.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the switch name. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] overwrite: Specifies whether to overwrite configurations with the same name.
               Value options:
               + **true**: Configurations in the destination metadata with the same name as the source metadata will be overwritten.
               + **false**: An error is reported when a topic or group already exists.
               Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskQueueArgs', 'DmsRocketmqMigrationTaskQueueArgsDict']]]] queues: Specifies the queue metadata.
               The queues structure is documented below.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] start_date: Indicates the start time of the migration task.
        :param pulumi.Input[_builtins.str] status: Indicates the status of the migration task. The value can be **finished** or **failed***.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskSubscriptionGroupArgs', 'DmsRocketmqMigrationTaskSubscriptionGroupArgsDict']]]] subscription_groups: Specifies the consumer group metadata.
               The subscription_groups structure is documented below.
               Changing this creates a new resource.
               
               > **NOTE:** Parameters `topic_configs` and `subscription_groups` are required when `type` is set to **rocketmq**.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskTopicConfigArgs', 'DmsRocketmqMigrationTaskTopicConfigArgsDict']]]] topic_configs: Specifies the topic metadata.
               The topic_configs structure is documented below.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] type: Specifies the exchange type. Changing this creates a new resource.
               
               <a name="RocketMQ_migration_task_bindings"></a>
               The `bindings` block supports:
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqMigrationTaskVhostArgs', 'DmsRocketmqMigrationTaskVhostArgsDict']]]] vhosts: Specifies the virtual hosts metadata.
               The vhosts structure is documented below.
               Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DmsRocketmqMigrationTaskState.__new__(_DmsRocketmqMigrationTaskState)

        __props__.__dict__["bindings"] = bindings
        __props__.__dict__["exchanges"] = exchanges
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["overwrite"] = overwrite
        __props__.__dict__["queues"] = queues
        __props__.__dict__["region"] = region
        __props__.__dict__["start_date"] = start_date
        __props__.__dict__["status"] = status
        __props__.__dict__["subscription_groups"] = subscription_groups
        __props__.__dict__["topic_configs"] = topic_configs
        __props__.__dict__["type"] = type
        __props__.__dict__["vhosts"] = vhosts
        return DmsRocketmqMigrationTask(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def bindings(self) -> pulumi.Output[Sequence['outputs.DmsRocketmqMigrationTaskBinding']]:
        """
        Specifies the binding metadata.
        The bindings structure is documented below.
        Changing this creates a new resource.

        > **NOTE:** Parameters `vhosts`, `queues`, `exchanges` and `bindings` are required when `type` is set to **rabbitToRocket**.

        <a name="RocketMQ_migration_task_topic_configs"></a>
        The `topic_configs` block supports:
        """
        return pulumi.get(self, "bindings")

    @_builtins.property
    @pulumi.getter
    def exchanges(self) -> pulumi.Output[Sequence['outputs.DmsRocketmqMigrationTaskExchange']]:
        """
        Specifies the exchange metadata.
        The exchanges structure is documented below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "exchanges")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the RocketMQ instance.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the switch name. Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def overwrite(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies whether to overwrite configurations with the same name.
        Value options:
        + **true**: Configurations in the destination metadata with the same name as the source metadata will be overwritten.
        + **false**: An error is reported when a topic or group already exists.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "overwrite")

    @_builtins.property
    @pulumi.getter
    def queues(self) -> pulumi.Output[Sequence['outputs.DmsRocketmqMigrationTaskQueue']]:
        """
        Specifies the queue metadata.
        The queues structure is documented below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "queues")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the start time of the migration task.
        """
        return pulumi.get(self, "start_date")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Indicates the status of the migration task. The value can be **finished** or **failed***.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subscriptionGroups")
    def subscription_groups(self) -> pulumi.Output[Sequence['outputs.DmsRocketmqMigrationTaskSubscriptionGroup']]:
        """
        Specifies the consumer group metadata.
        The subscription_groups structure is documented below.
        Changing this creates a new resource.

        > **NOTE:** Parameters `topic_configs` and `subscription_groups` are required when `type` is set to **rocketmq**.
        """
        return pulumi.get(self, "subscription_groups")

    @_builtins.property
    @pulumi.getter(name="topicConfigs")
    def topic_configs(self) -> pulumi.Output[Sequence['outputs.DmsRocketmqMigrationTaskTopicConfig']]:
        """
        Specifies the topic metadata.
        The topic_configs structure is documented below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "topic_configs")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the exchange type. Changing this creates a new resource.

        <a name="RocketMQ_migration_task_bindings"></a>
        The `bindings` block supports:
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def vhosts(self) -> pulumi.Output[Sequence['outputs.DmsRocketmqMigrationTaskVhost']]:
        """
        Specifies the virtual hosts metadata.
        The vhosts structure is documented below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "vhosts")

