# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DmsRocketmqTopicArgs', 'DmsRocketmqTopic']

@pulumi.input_type
class DmsRocketmqTopicArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 brokers: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqTopicBrokerArgs']]]] = None,
                 message_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_num: Optional[pulumi.Input[_builtins.int]] = None,
                 queues: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqTopicQueueArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 total_read_queue_num: Optional[pulumi.Input[_builtins.int]] = None,
                 total_write_queue_num: Optional[pulumi.Input[_builtins.int]] = None):
        """
        The set of arguments for constructing a DmsRocketmqTopic resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the rocketMQ instance.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqTopicBrokerArgs']]] brokers: Specifies the list of associated brokers of the topic.
               It's only valid when RocketMQ instance version is **4.8.0**.
               Changing this parameter will create a new resource.
               The brokers structure is documented below.
        :param pulumi.Input[_builtins.str] message_type: Specifies the message type of the topic.
               It's only valid when RocketMQ instance version is **5.x**. Valid values are:
               + **NORMAL**: Normal messages.
               + **FIFO**: Ordered messages.
               + **DELAY**: Scheduled messages.
               + **TRANSACTION**: Transactional messages.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the broker.
               
               <a name="DmsRocketMQTopic_QueueRef"></a>
               The `queues` block supports:
        :param pulumi.Input[_builtins.str] permission: Specifies the permissions of the topic.
               Value options: **all**, **sub**, **pub**. Defaults to **all**.
               It's only valid when RocketMQ instance version is **4.8.0**.
        :param pulumi.Input[_builtins.int] queue_num: Specifies the number of the queues.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqTopicQueueArgs']]] queues: Specifies the queues information of the topic.
               It's only valid when RocketMQ instance version is **4.8.0**.
               The queues structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] total_read_queue_num: Specifies the total number of read queues.
        :param pulumi.Input[_builtins.int] total_write_queue_num: Specifies the total number of write queues.
               
               <a name="DmsRocketMQTopic_BrokerRef"></a>
               The `brokers` block supports:
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if brokers is not None:
            pulumi.set(__self__, "brokers", brokers)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)
        if queue_num is not None:
            pulumi.set(__self__, "queue_num", queue_num)
        if queues is not None:
            pulumi.set(__self__, "queues", queues)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if total_read_queue_num is not None:
            pulumi.set(__self__, "total_read_queue_num", total_read_queue_num)
        if total_write_queue_num is not None:
            pulumi.set(__self__, "total_write_queue_num", total_write_queue_num)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the rocketMQ instance.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def brokers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqTopicBrokerArgs']]]]:
        """
        Specifies the list of associated brokers of the topic.
        It's only valid when RocketMQ instance version is **4.8.0**.
        Changing this parameter will create a new resource.
        The brokers structure is documented below.
        """
        return pulumi.get(self, "brokers")

    @brokers.setter
    def brokers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqTopicBrokerArgs']]]]):
        pulumi.set(self, "brokers", value)

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the message type of the topic.
        It's only valid when RocketMQ instance version is **5.x**. Valid values are:
        + **NORMAL**: Normal messages.
        + **FIFO**: Ordered messages.
        + **DELAY**: Scheduled messages.
        + **TRANSACTION**: Transactional messages.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the broker.

        <a name="DmsRocketMQTopic_QueueRef"></a>
        The `queues` block supports:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the permissions of the topic.
        Value options: **all**, **sub**, **pub**. Defaults to **all**.
        It's only valid when RocketMQ instance version is **4.8.0**.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permission", value)

    @_builtins.property
    @pulumi.getter(name="queueNum")
    def queue_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of the queues.
        """
        return pulumi.get(self, "queue_num")

    @queue_num.setter
    def queue_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "queue_num", value)

    @_builtins.property
    @pulumi.getter
    def queues(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqTopicQueueArgs']]]]:
        """
        Specifies the queues information of the topic.
        It's only valid when RocketMQ instance version is **4.8.0**.
        The queues structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "queues")

    @queues.setter
    def queues(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqTopicQueueArgs']]]]):
        pulumi.set(self, "queues", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="totalReadQueueNum")
    def total_read_queue_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the total number of read queues.
        """
        return pulumi.get(self, "total_read_queue_num")

    @total_read_queue_num.setter
    def total_read_queue_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_read_queue_num", value)

    @_builtins.property
    @pulumi.getter(name="totalWriteQueueNum")
    def total_write_queue_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the total number of write queues.

        <a name="DmsRocketMQTopic_BrokerRef"></a>
        The `brokers` block supports:
        """
        return pulumi.get(self, "total_write_queue_num")

    @total_write_queue_num.setter
    def total_write_queue_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_write_queue_num", value)


@pulumi.input_type
class _DmsRocketmqTopicState:
    def __init__(__self__, *,
                 brokers: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqTopicBrokerArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 message_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_num: Optional[pulumi.Input[_builtins.int]] = None,
                 queues: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqTopicQueueArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 total_read_queue_num: Optional[pulumi.Input[_builtins.int]] = None,
                 total_write_queue_num: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering DmsRocketmqTopic resources.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqTopicBrokerArgs']]] brokers: Specifies the list of associated brokers of the topic.
               It's only valid when RocketMQ instance version is **4.8.0**.
               Changing this parameter will create a new resource.
               The brokers structure is documented below.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the rocketMQ instance.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] message_type: Specifies the message type of the topic.
               It's only valid when RocketMQ instance version is **5.x**. Valid values are:
               + **NORMAL**: Normal messages.
               + **FIFO**: Ordered messages.
               + **DELAY**: Scheduled messages.
               + **TRANSACTION**: Transactional messages.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the broker.
               
               <a name="DmsRocketMQTopic_QueueRef"></a>
               The `queues` block supports:
        :param pulumi.Input[_builtins.str] permission: Specifies the permissions of the topic.
               Value options: **all**, **sub**, **pub**. Defaults to **all**.
               It's only valid when RocketMQ instance version is **4.8.0**.
        :param pulumi.Input[_builtins.int] queue_num: Specifies the number of the queues.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqTopicQueueArgs']]] queues: Specifies the queues information of the topic.
               It's only valid when RocketMQ instance version is **4.8.0**.
               The queues structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] total_read_queue_num: Specifies the total number of read queues.
        :param pulumi.Input[_builtins.int] total_write_queue_num: Specifies the total number of write queues.
               
               <a name="DmsRocketMQTopic_BrokerRef"></a>
               The `brokers` block supports:
        """
        if brokers is not None:
            pulumi.set(__self__, "brokers", brokers)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if message_type is not None:
            pulumi.set(__self__, "message_type", message_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permission is not None:
            pulumi.set(__self__, "permission", permission)
        if queue_num is not None:
            pulumi.set(__self__, "queue_num", queue_num)
        if queues is not None:
            pulumi.set(__self__, "queues", queues)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if total_read_queue_num is not None:
            pulumi.set(__self__, "total_read_queue_num", total_read_queue_num)
        if total_write_queue_num is not None:
            pulumi.set(__self__, "total_write_queue_num", total_write_queue_num)

    @_builtins.property
    @pulumi.getter
    def brokers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqTopicBrokerArgs']]]]:
        """
        Specifies the list of associated brokers of the topic.
        It's only valid when RocketMQ instance version is **4.8.0**.
        Changing this parameter will create a new resource.
        The brokers structure is documented below.
        """
        return pulumi.get(self, "brokers")

    @brokers.setter
    def brokers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqTopicBrokerArgs']]]]):
        pulumi.set(self, "brokers", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the rocketMQ instance.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the message type of the topic.
        It's only valid when RocketMQ instance version is **5.x**. Valid values are:
        + **NORMAL**: Normal messages.
        + **FIFO**: Ordered messages.
        + **DELAY**: Scheduled messages.
        + **TRANSACTION**: Transactional messages.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "message_type")

    @message_type.setter
    def message_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "message_type", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the broker.

        <a name="DmsRocketMQTopic_QueueRef"></a>
        The `queues` block supports:
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the permissions of the topic.
        Value options: **all**, **sub**, **pub**. Defaults to **all**.
        It's only valid when RocketMQ instance version is **4.8.0**.
        """
        return pulumi.get(self, "permission")

    @permission.setter
    def permission(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permission", value)

    @_builtins.property
    @pulumi.getter(name="queueNum")
    def queue_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the number of the queues.
        """
        return pulumi.get(self, "queue_num")

    @queue_num.setter
    def queue_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "queue_num", value)

    @_builtins.property
    @pulumi.getter
    def queues(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqTopicQueueArgs']]]]:
        """
        Specifies the queues information of the topic.
        It's only valid when RocketMQ instance version is **4.8.0**.
        The queues structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "queues")

    @queues.setter
    def queues(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqTopicQueueArgs']]]]):
        pulumi.set(self, "queues", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="totalReadQueueNum")
    def total_read_queue_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the total number of read queues.
        """
        return pulumi.get(self, "total_read_queue_num")

    @total_read_queue_num.setter
    def total_read_queue_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_read_queue_num", value)

    @_builtins.property
    @pulumi.getter(name="totalWriteQueueNum")
    def total_write_queue_num(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the total number of write queues.

        <a name="DmsRocketMQTopic_BrokerRef"></a>
        The `brokers` block supports:
        """
        return pulumi.get(self, "total_write_queue_num")

    @total_write_queue_num.setter
    def total_write_queue_num(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "total_write_queue_num", value)


@pulumi.type_token("sbercloud:index/dmsRocketmqTopic:DmsRocketmqTopic")
class DmsRocketmqTopic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 brokers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqTopicBrokerArgs', 'DmsRocketmqTopicBrokerArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 message_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_num: Optional[pulumi.Input[_builtins.int]] = None,
                 queues: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqTopicQueueArgs', 'DmsRocketmqTopicQueueArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 total_read_queue_num: Optional[pulumi.Input[_builtins.int]] = None,
                 total_write_queue_num: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        Manages DMS RocketMQ topic resources within SberCloud.

        ## Example Usage

        ### Create a topic for 5.x version instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.DmsRocketmqTopic("test",
            instance_id=instance_id,
            name="topic_test",
            message_type="NORMAL")
        ```

        ### Create a topic with brokers for 4.8.0 version instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.DmsRocketmqTopic("test",
            instance_id=instance_id,
            name="topic_test",
            queue_num=3,
            permission="all",
            brokers=[{
                "name": "broker-0",
            }])
        ```

        ### Create a topic with queues for 4.8.0 version instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.DmsRocketmqTopic("test",
            instance_id=instance_id,
            name="topic_test",
            permission="all",
            queues=[{
                "broker": "broker-0",
                "queue_num": 3,
            }])
        ```

        ## Import

        The rocketmq topic can be imported using the rocketMQ instance ID and topic name separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/dmsRocketmqTopic:DmsRocketmqTopic test c8057fe5-23a8-46ef-ad83-c0055b4e0c5c/topic_1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqTopicBrokerArgs', 'DmsRocketmqTopicBrokerArgsDict']]]] brokers: Specifies the list of associated brokers of the topic.
               It's only valid when RocketMQ instance version is **4.8.0**.
               Changing this parameter will create a new resource.
               The brokers structure is documented below.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the rocketMQ instance.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] message_type: Specifies the message type of the topic.
               It's only valid when RocketMQ instance version is **5.x**. Valid values are:
               + **NORMAL**: Normal messages.
               + **FIFO**: Ordered messages.
               + **DELAY**: Scheduled messages.
               + **TRANSACTION**: Transactional messages.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the broker.
               
               <a name="DmsRocketMQTopic_QueueRef"></a>
               The `queues` block supports:
        :param pulumi.Input[_builtins.str] permission: Specifies the permissions of the topic.
               Value options: **all**, **sub**, **pub**. Defaults to **all**.
               It's only valid when RocketMQ instance version is **4.8.0**.
        :param pulumi.Input[_builtins.int] queue_num: Specifies the number of the queues.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqTopicQueueArgs', 'DmsRocketmqTopicQueueArgsDict']]]] queues: Specifies the queues information of the topic.
               It's only valid when RocketMQ instance version is **4.8.0**.
               The queues structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] total_read_queue_num: Specifies the total number of read queues.
        :param pulumi.Input[_builtins.int] total_write_queue_num: Specifies the total number of write queues.
               
               <a name="DmsRocketMQTopic_BrokerRef"></a>
               The `brokers` block supports:
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DmsRocketmqTopicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages DMS RocketMQ topic resources within SberCloud.

        ## Example Usage

        ### Create a topic for 5.x version instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.DmsRocketmqTopic("test",
            instance_id=instance_id,
            name="topic_test",
            message_type="NORMAL")
        ```

        ### Create a topic with brokers for 4.8.0 version instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.DmsRocketmqTopic("test",
            instance_id=instance_id,
            name="topic_test",
            queue_num=3,
            permission="all",
            brokers=[{
                "name": "broker-0",
            }])
        ```

        ### Create a topic with queues for 4.8.0 version instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.DmsRocketmqTopic("test",
            instance_id=instance_id,
            name="topic_test",
            permission="all",
            queues=[{
                "broker": "broker-0",
                "queue_num": 3,
            }])
        ```

        ## Import

        The rocketmq topic can be imported using the rocketMQ instance ID and topic name separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/dmsRocketmqTopic:DmsRocketmqTopic test c8057fe5-23a8-46ef-ad83-c0055b4e0c5c/topic_1
        ```

        :param str resource_name: The name of the resource.
        :param DmsRocketmqTopicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DmsRocketmqTopicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 brokers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqTopicBrokerArgs', 'DmsRocketmqTopicBrokerArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 message_type: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 permission: Optional[pulumi.Input[_builtins.str]] = None,
                 queue_num: Optional[pulumi.Input[_builtins.int]] = None,
                 queues: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqTopicQueueArgs', 'DmsRocketmqTopicQueueArgsDict']]]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 total_read_queue_num: Optional[pulumi.Input[_builtins.int]] = None,
                 total_write_queue_num: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DmsRocketmqTopicArgs.__new__(DmsRocketmqTopicArgs)

            __props__.__dict__["brokers"] = brokers
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["message_type"] = message_type
            __props__.__dict__["name"] = name
            __props__.__dict__["permission"] = permission
            __props__.__dict__["queue_num"] = queue_num
            __props__.__dict__["queues"] = queues
            __props__.__dict__["region"] = region
            __props__.__dict__["total_read_queue_num"] = total_read_queue_num
            __props__.__dict__["total_write_queue_num"] = total_write_queue_num
        super(DmsRocketmqTopic, __self__).__init__(
            'sbercloud:index/dmsRocketmqTopic:DmsRocketmqTopic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            brokers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqTopicBrokerArgs', 'DmsRocketmqTopicBrokerArgsDict']]]]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            message_type: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            permission: Optional[pulumi.Input[_builtins.str]] = None,
            queue_num: Optional[pulumi.Input[_builtins.int]] = None,
            queues: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqTopicQueueArgs', 'DmsRocketmqTopicQueueArgsDict']]]]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            total_read_queue_num: Optional[pulumi.Input[_builtins.int]] = None,
            total_write_queue_num: Optional[pulumi.Input[_builtins.int]] = None) -> 'DmsRocketmqTopic':
        """
        Get an existing DmsRocketmqTopic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqTopicBrokerArgs', 'DmsRocketmqTopicBrokerArgsDict']]]] brokers: Specifies the list of associated brokers of the topic.
               It's only valid when RocketMQ instance version is **4.8.0**.
               Changing this parameter will create a new resource.
               The brokers structure is documented below.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the rocketMQ instance.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] message_type: Specifies the message type of the topic.
               It's only valid when RocketMQ instance version is **5.x**. Valid values are:
               + **NORMAL**: Normal messages.
               + **FIFO**: Ordered messages.
               + **DELAY**: Scheduled messages.
               + **TRANSACTION**: Transactional messages.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the broker.
               
               <a name="DmsRocketMQTopic_QueueRef"></a>
               The `queues` block supports:
        :param pulumi.Input[_builtins.str] permission: Specifies the permissions of the topic.
               Value options: **all**, **sub**, **pub**. Defaults to **all**.
               It's only valid when RocketMQ instance version is **4.8.0**.
        :param pulumi.Input[_builtins.int] queue_num: Specifies the number of the queues.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqTopicQueueArgs', 'DmsRocketmqTopicQueueArgsDict']]]] queues: Specifies the queues information of the topic.
               It's only valid when RocketMQ instance version is **4.8.0**.
               The queues structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] total_read_queue_num: Specifies the total number of read queues.
        :param pulumi.Input[_builtins.int] total_write_queue_num: Specifies the total number of write queues.
               
               <a name="DmsRocketMQTopic_BrokerRef"></a>
               The `brokers` block supports:
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DmsRocketmqTopicState.__new__(_DmsRocketmqTopicState)

        __props__.__dict__["brokers"] = brokers
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["message_type"] = message_type
        __props__.__dict__["name"] = name
        __props__.__dict__["permission"] = permission
        __props__.__dict__["queue_num"] = queue_num
        __props__.__dict__["queues"] = queues
        __props__.__dict__["region"] = region
        __props__.__dict__["total_read_queue_num"] = total_read_queue_num
        __props__.__dict__["total_write_queue_num"] = total_write_queue_num
        return DmsRocketmqTopic(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def brokers(self) -> pulumi.Output[Sequence['outputs.DmsRocketmqTopicBroker']]:
        """
        Specifies the list of associated brokers of the topic.
        It's only valid when RocketMQ instance version is **4.8.0**.
        Changing this parameter will create a new resource.
        The brokers structure is documented below.
        """
        return pulumi.get(self, "brokers")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the rocketMQ instance.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="messageType")
    def message_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the message type of the topic.
        It's only valid when RocketMQ instance version is **5.x**. Valid values are:
        + **NORMAL**: Normal messages.
        + **FIFO**: Ordered messages.
        + **DELAY**: Scheduled messages.
        + **TRANSACTION**: Transactional messages.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "message_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the broker.

        <a name="DmsRocketMQTopic_QueueRef"></a>
        The `queues` block supports:
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def permission(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the permissions of the topic.
        Value options: **all**, **sub**, **pub**. Defaults to **all**.
        It's only valid when RocketMQ instance version is **4.8.0**.
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter(name="queueNum")
    def queue_num(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the number of the queues.
        """
        return pulumi.get(self, "queue_num")

    @_builtins.property
    @pulumi.getter
    def queues(self) -> pulumi.Output[Optional[Sequence['outputs.DmsRocketmqTopicQueue']]]:
        """
        Specifies the queues information of the topic.
        It's only valid when RocketMQ instance version is **4.8.0**.
        The queues structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "queues")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="totalReadQueueNum")
    def total_read_queue_num(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the total number of read queues.
        """
        return pulumi.get(self, "total_read_queue_num")

    @_builtins.property
    @pulumi.getter(name="totalWriteQueueNum")
    def total_write_queue_num(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the total number of write queues.

        <a name="DmsRocketMQTopic_BrokerRef"></a>
        The `brokers` block supports:
        """
        return pulumi.get(self, "total_write_queue_num")

