# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DmsRocketmqUserArgs', 'DmsRocketmqUser']

@pulumi.input_type
class DmsRocketmqUserArgs:
    def __init__(__self__, *,
                 access_key: pulumi.Input[_builtins.str],
                 instance_id: pulumi.Input[_builtins.str],
                 secret_key: pulumi.Input[_builtins.str],
                 admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_group_perm: Optional[pulumi.Input[_builtins.str]] = None,
                 default_topic_perm: Optional[pulumi.Input[_builtins.str]] = None,
                 group_perms: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqUserGroupPermArgs']]]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_perms: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqUserTopicPermArgs']]]] = None,
                 white_remote_address: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DmsRocketmqUser resource.
        :param pulumi.Input[_builtins.str] access_key: Specifies the name of the user, which starts with a letter, consists of 7
               to 64 characters and can contain only letters, digits, hyphens (-), and underscores (_).
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the rocketMQ instance.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] secret_key: Specifies the password of the user. Use 8 to 32 characters. Contain at
               least three of the following character types:
               + Uppercase letters.
               + Lowercase letters.
               + Digits.
               + Special characters \\`~!@#$%^&*()-_=+\\|[{}];:'"",<.>/?. Cannot be the `access_key` or the `access_key` spelled
               backwards.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] admin: Specifies whether the user is an administrator.
        :param pulumi.Input[_builtins.str] default_group_perm: Specifies the default consumer group permissions.
               Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
        :param pulumi.Input[_builtins.str] default_topic_perm: Specifies the default topic permissions.
               Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqUserGroupPermArgs']]] group_perms: Specifies the special consumer group permissions.
               The permission structure is documented below.
               
               <a name="DmsRocketMQUser_PermsRef"></a>
               The `topic_perms` and `group_perms` block supports:
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqUserTopicPermArgs']]] topic_perms: Specifies the special topic permissions.
               The permission structure is documented below.
        :param pulumi.Input[_builtins.str] white_remote_address: Specifies the IP address whitelist.
        """
        pulumi.set(__self__, "access_key", access_key)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "secret_key", secret_key)
        if admin is not None:
            pulumi.set(__self__, "admin", admin)
        if default_group_perm is not None:
            pulumi.set(__self__, "default_group_perm", default_group_perm)
        if default_topic_perm is not None:
            pulumi.set(__self__, "default_topic_perm", default_topic_perm)
        if group_perms is not None:
            pulumi.set(__self__, "group_perms", group_perms)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if topic_perms is not None:
            pulumi.set(__self__, "topic_perms", topic_perms)
        if white_remote_address is not None:
            pulumi.set(__self__, "white_remote_address", white_remote_address)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the user, which starts with a letter, consists of 7
        to 64 characters and can contain only letters, digits, hyphens (-), and underscores (_).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of the rocketMQ instance.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the password of the user. Use 8 to 32 characters. Contain at
        least three of the following character types:
        + Uppercase letters.
        + Lowercase letters.
        + Digits.
        + Special characters \\`~!@#$%^&*()-_=+\\|[{}];:'"",<.>/?. Cannot be the `access_key` or the `access_key` spelled
        backwards.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter
    def admin(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the user is an administrator.
        """
        return pulumi.get(self, "admin")

    @admin.setter
    def admin(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "admin", value)

    @_builtins.property
    @pulumi.getter(name="defaultGroupPerm")
    def default_group_perm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default consumer group permissions.
        Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
        """
        return pulumi.get(self, "default_group_perm")

    @default_group_perm.setter
    def default_group_perm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_group_perm", value)

    @_builtins.property
    @pulumi.getter(name="defaultTopicPerm")
    def default_topic_perm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default topic permissions.
        Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
        """
        return pulumi.get(self, "default_topic_perm")

    @default_topic_perm.setter
    def default_topic_perm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_topic_perm", value)

    @_builtins.property
    @pulumi.getter(name="groupPerms")
    def group_perms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqUserGroupPermArgs']]]]:
        """
        Specifies the special consumer group permissions.
        The permission structure is documented below.

        <a name="DmsRocketMQUser_PermsRef"></a>
        The `topic_perms` and `group_perms` block supports:
        """
        return pulumi.get(self, "group_perms")

    @group_perms.setter
    def group_perms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqUserGroupPermArgs']]]]):
        pulumi.set(self, "group_perms", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="topicPerms")
    def topic_perms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqUserTopicPermArgs']]]]:
        """
        Specifies the special topic permissions.
        The permission structure is documented below.
        """
        return pulumi.get(self, "topic_perms")

    @topic_perms.setter
    def topic_perms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqUserTopicPermArgs']]]]):
        pulumi.set(self, "topic_perms", value)

    @_builtins.property
    @pulumi.getter(name="whiteRemoteAddress")
    def white_remote_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IP address whitelist.
        """
        return pulumi.get(self, "white_remote_address")

    @white_remote_address.setter
    def white_remote_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "white_remote_address", value)


@pulumi.input_type
class _DmsRocketmqUserState:
    def __init__(__self__, *,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_group_perm: Optional[pulumi.Input[_builtins.str]] = None,
                 default_topic_perm: Optional[pulumi.Input[_builtins.str]] = None,
                 group_perms: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqUserGroupPermArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_perms: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqUserTopicPermArgs']]]] = None,
                 white_remote_address: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DmsRocketmqUser resources.
        :param pulumi.Input[_builtins.str] access_key: Specifies the name of the user, which starts with a letter, consists of 7
               to 64 characters and can contain only letters, digits, hyphens (-), and underscores (_).
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] admin: Specifies whether the user is an administrator.
        :param pulumi.Input[_builtins.str] default_group_perm: Specifies the default consumer group permissions.
               Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
        :param pulumi.Input[_builtins.str] default_topic_perm: Specifies the default topic permissions.
               Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqUserGroupPermArgs']]] group_perms: Specifies the special consumer group permissions.
               The permission structure is documented below.
               
               <a name="DmsRocketMQUser_PermsRef"></a>
               The `topic_perms` and `group_perms` block supports:
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the rocketMQ instance.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] secret_key: Specifies the password of the user. Use 8 to 32 characters. Contain at
               least three of the following character types:
               + Uppercase letters.
               + Lowercase letters.
               + Digits.
               + Special characters \\`~!@#$%^&*()-_=+\\|[{}];:'"",<.>/?. Cannot be the `access_key` or the `access_key` spelled
               backwards.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['DmsRocketmqUserTopicPermArgs']]] topic_perms: Specifies the special topic permissions.
               The permission structure is documented below.
        :param pulumi.Input[_builtins.str] white_remote_address: Specifies the IP address whitelist.
        """
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if admin is not None:
            pulumi.set(__self__, "admin", admin)
        if default_group_perm is not None:
            pulumi.set(__self__, "default_group_perm", default_group_perm)
        if default_topic_perm is not None:
            pulumi.set(__self__, "default_topic_perm", default_topic_perm)
        if group_perms is not None:
            pulumi.set(__self__, "group_perms", group_perms)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if topic_perms is not None:
            pulumi.set(__self__, "topic_perms", topic_perms)
        if white_remote_address is not None:
            pulumi.set(__self__, "white_remote_address", white_remote_address)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the user, which starts with a letter, consists of 7
        to 64 characters and can contain only letters, digits, hyphens (-), and underscores (_).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "access_key")

    @access_key.setter
    def access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_key", value)

    @_builtins.property
    @pulumi.getter
    def admin(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the user is an administrator.
        """
        return pulumi.get(self, "admin")

    @admin.setter
    def admin(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "admin", value)

    @_builtins.property
    @pulumi.getter(name="defaultGroupPerm")
    def default_group_perm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default consumer group permissions.
        Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
        """
        return pulumi.get(self, "default_group_perm")

    @default_group_perm.setter
    def default_group_perm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_group_perm", value)

    @_builtins.property
    @pulumi.getter(name="defaultTopicPerm")
    def default_topic_perm(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the default topic permissions.
        Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
        """
        return pulumi.get(self, "default_topic_perm")

    @default_topic_perm.setter
    def default_topic_perm(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_topic_perm", value)

    @_builtins.property
    @pulumi.getter(name="groupPerms")
    def group_perms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqUserGroupPermArgs']]]]:
        """
        Specifies the special consumer group permissions.
        The permission structure is documented below.

        <a name="DmsRocketMQUser_PermsRef"></a>
        The `topic_perms` and `group_perms` block supports:
        """
        return pulumi.get(self, "group_perms")

    @group_perms.setter
    def group_perms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqUserGroupPermArgs']]]]):
        pulumi.set(self, "group_perms", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of the rocketMQ instance.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the password of the user. Use 8 to 32 characters. Contain at
        least three of the following character types:
        + Uppercase letters.
        + Lowercase letters.
        + Digits.
        + Special characters \\`~!@#$%^&*()-_=+\\|[{}];:'"",<.>/?. Cannot be the `access_key` or the `access_key` spelled
        backwards.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "secret_key")

    @secret_key.setter
    def secret_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_key", value)

    @_builtins.property
    @pulumi.getter(name="topicPerms")
    def topic_perms(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqUserTopicPermArgs']]]]:
        """
        Specifies the special topic permissions.
        The permission structure is documented below.
        """
        return pulumi.get(self, "topic_perms")

    @topic_perms.setter
    def topic_perms(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DmsRocketmqUserTopicPermArgs']]]]):
        pulumi.set(self, "topic_perms", value)

    @_builtins.property
    @pulumi.getter(name="whiteRemoteAddress")
    def white_remote_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IP address whitelist.
        """
        return pulumi.get(self, "white_remote_address")

    @white_remote_address.setter
    def white_remote_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "white_remote_address", value)


@pulumi.type_token("sbercloud:index/dmsRocketmqUser:DmsRocketmqUser")
class DmsRocketmqUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_group_perm: Optional[pulumi.Input[_builtins.str]] = None,
                 default_topic_perm: Optional[pulumi.Input[_builtins.str]] = None,
                 group_perms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqUserGroupPermArgs', 'DmsRocketmqUserGroupPermArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_perms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqUserTopicPermArgs', 'DmsRocketmqUserTopicPermArgsDict']]]]] = None,
                 white_remote_address: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages DMS RocketMQ user resources within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.DmsRocketmqUser("test",
            instance_id=instance_id,
            access_key="user_test",
            secret_key="abcdefg",
            white_remote_address="10.10.10.10",
            admin=False,
            default_topic_perm="PUB",
            default_group_perm="PUB",
            topic_perms=[{
                "name": "topic_name",
                "perm": "PUB",
            }],
            group_perms=[{
                "name": "group_name",
                "perm": "PUB",
            }])
        ```

        ## Import

        The rocketmq user can be imported using the rocketMQ `instance_id` and user `access_key` separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/dmsRocketmqUser:DmsRocketmqUser test <instance_id>/<access_key>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: Specifies the name of the user, which starts with a letter, consists of 7
               to 64 characters and can contain only letters, digits, hyphens (-), and underscores (_).
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] admin: Specifies whether the user is an administrator.
        :param pulumi.Input[_builtins.str] default_group_perm: Specifies the default consumer group permissions.
               Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
        :param pulumi.Input[_builtins.str] default_topic_perm: Specifies the default topic permissions.
               Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqUserGroupPermArgs', 'DmsRocketmqUserGroupPermArgsDict']]]] group_perms: Specifies the special consumer group permissions.
               The permission structure is documented below.
               
               <a name="DmsRocketMQUser_PermsRef"></a>
               The `topic_perms` and `group_perms` block supports:
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the rocketMQ instance.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] secret_key: Specifies the password of the user. Use 8 to 32 characters. Contain at
               least three of the following character types:
               + Uppercase letters.
               + Lowercase letters.
               + Digits.
               + Special characters \\`~!@#$%^&*()-_=+\\|[{}];:'"",<.>/?. Cannot be the `access_key` or the `access_key` spelled
               backwards.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqUserTopicPermArgs', 'DmsRocketmqUserTopicPermArgsDict']]]] topic_perms: Specifies the special topic permissions.
               The permission structure is documented below.
        :param pulumi.Input[_builtins.str] white_remote_address: Specifies the IP address whitelist.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DmsRocketmqUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages DMS RocketMQ user resources within SberCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        test = sbercloud.DmsRocketmqUser("test",
            instance_id=instance_id,
            access_key="user_test",
            secret_key="abcdefg",
            white_remote_address="10.10.10.10",
            admin=False,
            default_topic_perm="PUB",
            default_group_perm="PUB",
            topic_perms=[{
                "name": "topic_name",
                "perm": "PUB",
            }],
            group_perms=[{
                "name": "group_name",
                "perm": "PUB",
            }])
        ```

        ## Import

        The rocketmq user can be imported using the rocketMQ `instance_id` and user `access_key` separated by a slash, e.g.

        bash

        ```sh
        $ pulumi import sbercloud:index/dmsRocketmqUser:DmsRocketmqUser test <instance_id>/<access_key>
        ```

        :param str resource_name: The name of the resource.
        :param DmsRocketmqUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DmsRocketmqUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 admin: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_group_perm: Optional[pulumi.Input[_builtins.str]] = None,
                 default_topic_perm: Optional[pulumi.Input[_builtins.str]] = None,
                 group_perms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqUserGroupPermArgs', 'DmsRocketmqUserGroupPermArgsDict']]]]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_key: Optional[pulumi.Input[_builtins.str]] = None,
                 topic_perms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqUserTopicPermArgs', 'DmsRocketmqUserTopicPermArgsDict']]]]] = None,
                 white_remote_address: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DmsRocketmqUserArgs.__new__(DmsRocketmqUserArgs)

            if access_key is None and not opts.urn:
                raise TypeError("Missing required property 'access_key'")
            __props__.__dict__["access_key"] = access_key
            __props__.__dict__["admin"] = admin
            __props__.__dict__["default_group_perm"] = default_group_perm
            __props__.__dict__["default_topic_perm"] = default_topic_perm
            __props__.__dict__["group_perms"] = group_perms
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["region"] = region
            if secret_key is None and not opts.urn:
                raise TypeError("Missing required property 'secret_key'")
            __props__.__dict__["secret_key"] = secret_key
            __props__.__dict__["topic_perms"] = topic_perms
            __props__.__dict__["white_remote_address"] = white_remote_address
        super(DmsRocketmqUser, __self__).__init__(
            'sbercloud:index/dmsRocketmqUser:DmsRocketmqUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_key: Optional[pulumi.Input[_builtins.str]] = None,
            admin: Optional[pulumi.Input[_builtins.bool]] = None,
            default_group_perm: Optional[pulumi.Input[_builtins.str]] = None,
            default_topic_perm: Optional[pulumi.Input[_builtins.str]] = None,
            group_perms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqUserGroupPermArgs', 'DmsRocketmqUserGroupPermArgsDict']]]]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            secret_key: Optional[pulumi.Input[_builtins.str]] = None,
            topic_perms: Optional[pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqUserTopicPermArgs', 'DmsRocketmqUserTopicPermArgsDict']]]]] = None,
            white_remote_address: Optional[pulumi.Input[_builtins.str]] = None) -> 'DmsRocketmqUser':
        """
        Get an existing DmsRocketmqUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_key: Specifies the name of the user, which starts with a letter, consists of 7
               to 64 characters and can contain only letters, digits, hyphens (-), and underscores (_).
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] admin: Specifies whether the user is an administrator.
        :param pulumi.Input[_builtins.str] default_group_perm: Specifies the default consumer group permissions.
               Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
        :param pulumi.Input[_builtins.str] default_topic_perm: Specifies the default topic permissions.
               Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqUserGroupPermArgs', 'DmsRocketmqUserGroupPermArgsDict']]]] group_perms: Specifies the special consumer group permissions.
               The permission structure is documented below.
               
               <a name="DmsRocketMQUser_PermsRef"></a>
               The `topic_perms` and `group_perms` block supports:
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of the rocketMQ instance.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the resource.
               If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] secret_key: Specifies the password of the user. Use 8 to 32 characters. Contain at
               least three of the following character types:
               + Uppercase letters.
               + Lowercase letters.
               + Digits.
               + Special characters \\`~!@#$%^&*()-_=+\\|[{}];:'"",<.>/?. Cannot be the `access_key` or the `access_key` spelled
               backwards.
               
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['DmsRocketmqUserTopicPermArgs', 'DmsRocketmqUserTopicPermArgsDict']]]] topic_perms: Specifies the special topic permissions.
               The permission structure is documented below.
        :param pulumi.Input[_builtins.str] white_remote_address: Specifies the IP address whitelist.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DmsRocketmqUserState.__new__(_DmsRocketmqUserState)

        __props__.__dict__["access_key"] = access_key
        __props__.__dict__["admin"] = admin
        __props__.__dict__["default_group_perm"] = default_group_perm
        __props__.__dict__["default_topic_perm"] = default_topic_perm
        __props__.__dict__["group_perms"] = group_perms
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["region"] = region
        __props__.__dict__["secret_key"] = secret_key
        __props__.__dict__["topic_perms"] = topic_perms
        __props__.__dict__["white_remote_address"] = white_remote_address
        return DmsRocketmqUser(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the user, which starts with a letter, consists of 7
        to 64 characters and can contain only letters, digits, hyphens (-), and underscores (_).
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "access_key")

    @_builtins.property
    @pulumi.getter
    def admin(self) -> pulumi.Output[_builtins.bool]:
        """
        Specifies whether the user is an administrator.
        """
        return pulumi.get(self, "admin")

    @_builtins.property
    @pulumi.getter(name="defaultGroupPerm")
    def default_group_perm(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the default consumer group permissions.
        Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
        """
        return pulumi.get(self, "default_group_perm")

    @_builtins.property
    @pulumi.getter(name="defaultTopicPerm")
    def default_topic_perm(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the default topic permissions.
        Value options: **PUB|SUB**, **PUB**, **SUB**, **DENY**.
        """
        return pulumi.get(self, "default_topic_perm")

    @_builtins.property
    @pulumi.getter(name="groupPerms")
    def group_perms(self) -> pulumi.Output[Sequence['outputs.DmsRocketmqUserGroupPerm']]:
        """
        Specifies the special consumer group permissions.
        The permission structure is documented below.

        <a name="DmsRocketMQUser_PermsRef"></a>
        The `topic_perms` and `group_perms` block supports:
        """
        return pulumi.get(self, "group_perms")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of the rocketMQ instance.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the resource.
        If omitted, the provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the password of the user. Use 8 to 32 characters. Contain at
        least three of the following character types:
        + Uppercase letters.
        + Lowercase letters.
        + Digits.
        + Special characters \\`~!@#$%^&*()-_=+\\|[{}];:'"",<.>/?. Cannot be the `access_key` or the `access_key` spelled
        backwards.

        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "secret_key")

    @_builtins.property
    @pulumi.getter(name="topicPerms")
    def topic_perms(self) -> pulumi.Output[Sequence['outputs.DmsRocketmqUserTopicPerm']]:
        """
        Specifies the special topic permissions.
        The permission structure is documented below.
        """
        return pulumi.get(self, "topic_perms")

    @_builtins.property
    @pulumi.getter(name="whiteRemoteAddress")
    def white_remote_address(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the IP address whitelist.
        """
        return pulumi.get(self, "white_remote_address")

