# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ZoneArgs', 'Zone']

@pulumi.input_type
class ZoneArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routers: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneRouterArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Zone resource.
        :param pulumi.Input[_builtins.str] description: A description of the zone.
        :param pulumi.Input[_builtins.str] email: The email address of the administrator managing the zone.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the zone. Changing this creates a
               new zone.
        :param pulumi.Input[_builtins.str] name: The name of the zone. Note the `.` at the end of the name. Changing this creates
               a new DNS zone.
        :param pulumi.Input[_builtins.str] proxy_pattern: The recursive resolution proxy mode for subdomains of the private zone.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DNS zone. If omitted, the `region` argument
               of the provider will be used. Changing this creates a new DNS zone.
        :param pulumi.Input[Sequence[pulumi.Input['ZoneRouterArgs']]] routers: Router configuration block which is required if zone_type is private. The router
               structure is documented below.
        :param pulumi.Input[_builtins.str] status: The status of the zone.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the zone.
        :param pulumi.Input[_builtins.int] ttl: The time to live (TTL) of the zone.
        :param pulumi.Input[_builtins.str] zone_type: The type of zone. Can either be `public` or `private`. Changing this
               creates a new DNS zone.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if proxy_pattern is not None:
            pulumi.set(__self__, "proxy_pattern", proxy_pattern)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routers is not None:
            pulumi.set(__self__, "routers", routers)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if zone_type is not None:
            pulumi.set(__self__, "zone_type", zone_type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the zone.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email address of the administrator managing the zone.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the zone. Changing this creates a
        new zone.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the zone. Note the `.` at the end of the name. Changing this creates
        a new DNS zone.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="proxyPattern")
    def proxy_pattern(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The recursive resolution proxy mode for subdomains of the private zone.
        """
        return pulumi.get(self, "proxy_pattern")

    @proxy_pattern.setter
    def proxy_pattern(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_pattern", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the DNS zone. If omitted, the `region` argument
        of the provider will be used. Changing this creates a new DNS zone.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def routers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZoneRouterArgs']]]]:
        """
        Router configuration block which is required if zone_type is private. The router
        structure is documented below.
        """
        return pulumi.get(self, "routers")

    @routers.setter
    def routers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneRouterArgs']]]]):
        pulumi.set(self, "routers", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the zone.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the zone.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time to live (TTL) of the zone.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter(name="zoneType")
    def zone_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of zone. Can either be `public` or `private`. Changing this
        creates a new DNS zone.
        """
        return pulumi.get(self, "zone_type")

    @zone_type.setter
    def zone_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_type", value)


@pulumi.input_type
class _ZoneState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 masters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routers: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneRouterArgs']]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Zone resources.
        :param pulumi.Input[_builtins.str] description: A description of the zone.
        :param pulumi.Input[_builtins.str] email: The email address of the administrator managing the zone.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the zone. Changing this creates a
               new zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] masters: An array of master DNS servers.
        :param pulumi.Input[_builtins.str] name: The name of the zone. Note the `.` at the end of the name. Changing this creates
               a new DNS zone.
        :param pulumi.Input[_builtins.str] proxy_pattern: The recursive resolution proxy mode for subdomains of the private zone.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DNS zone. If omitted, the `region` argument
               of the provider will be used. Changing this creates a new DNS zone.
        :param pulumi.Input[Sequence[pulumi.Input['ZoneRouterArgs']]] routers: Router configuration block which is required if zone_type is private. The router
               structure is documented below.
        :param pulumi.Input[_builtins.str] status: The status of the zone.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the zone.
        :param pulumi.Input[_builtins.int] ttl: The time to live (TTL) of the zone.
        :param pulumi.Input[_builtins.str] zone_type: The type of zone. Can either be `public` or `private`. Changing this
               creates a new DNS zone.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if masters is not None:
            pulumi.set(__self__, "masters", masters)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if proxy_pattern is not None:
            pulumi.set(__self__, "proxy_pattern", proxy_pattern)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if routers is not None:
            pulumi.set(__self__, "routers", routers)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if zone_type is not None:
            pulumi.set(__self__, "zone_type", zone_type)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the zone.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def email(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The email address of the administrator managing the zone.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "email", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the zone. Changing this creates a
        new zone.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter
    def masters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of master DNS servers.
        """
        return pulumi.get(self, "masters")

    @masters.setter
    def masters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "masters", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the zone. Note the `.` at the end of the name. Changing this creates
        a new DNS zone.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="proxyPattern")
    def proxy_pattern(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The recursive resolution proxy mode for subdomains of the private zone.
        """
        return pulumi.get(self, "proxy_pattern")

    @proxy_pattern.setter
    def proxy_pattern(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "proxy_pattern", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the DNS zone. If omitted, the `region` argument
        of the provider will be used. Changing this creates a new DNS zone.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def routers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ZoneRouterArgs']]]]:
        """
        Router configuration block which is required if zone_type is private. The router
        structure is documented below.
        """
        return pulumi.get(self, "routers")

    @routers.setter
    def routers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ZoneRouterArgs']]]]):
        pulumi.set(self, "routers", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the zone.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the zone.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The time to live (TTL) of the zone.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "ttl", value)

    @_builtins.property
    @pulumi.getter(name="zoneType")
    def zone_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of zone. Can either be `public` or `private`. Changing this
        creates a new DNS zone.
        """
        return pulumi.get(self, "zone_type")

    @zone_type.setter
    def zone_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone_type", value)


@pulumi.type_token("sbercloud:Dns/zone:Zone")
class Zone(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZoneRouterArgs', 'ZoneRouterArgsDict']]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a DNS zone in the SberCloud DNS Service.

        ## Example Usage

        ### Create a public DNS zone

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        my_public_zone = sbercloud.dns.Zone("my_public_zone",
            name="example.com.",
            email="jdoe@example.com",
            description="An example zone",
            ttl=3000,
            zone_type="public")
        ```

        ### Create a private DNS zone

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        my_private_zone = sbercloud.dns.Zone("my_private_zone",
            name="1.example.com.",
            email="jdoe@example.com",
            description="An example zone",
            ttl=3000,
            zone_type="private",
            routers=[{
                "router_id": "2c1fe4bd-ebad-44ca-ae9d-e94e63847b75",
            }])
        ```

        ## Import

        This resource can be imported by specifying the zone ID:

        ```sh
        $ pulumi import sbercloud:Dns/zone:Zone zone_1 <zone_id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the zone.
        :param pulumi.Input[_builtins.str] email: The email address of the administrator managing the zone.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the zone. Changing this creates a
               new zone.
        :param pulumi.Input[_builtins.str] name: The name of the zone. Note the `.` at the end of the name. Changing this creates
               a new DNS zone.
        :param pulumi.Input[_builtins.str] proxy_pattern: The recursive resolution proxy mode for subdomains of the private zone.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DNS zone. If omitted, the `region` argument
               of the provider will be used. Changing this creates a new DNS zone.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZoneRouterArgs', 'ZoneRouterArgsDict']]]] routers: Router configuration block which is required if zone_type is private. The router
               structure is documented below.
        :param pulumi.Input[_builtins.str] status: The status of the zone.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the zone.
        :param pulumi.Input[_builtins.int] ttl: The time to live (TTL) of the zone.
        :param pulumi.Input[_builtins.str] zone_type: The type of zone. Can either be `public` or `private`. Changing this
               creates a new DNS zone.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ZoneArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a DNS zone in the SberCloud DNS Service.

        ## Example Usage

        ### Create a public DNS zone

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        my_public_zone = sbercloud.dns.Zone("my_public_zone",
            name="example.com.",
            email="jdoe@example.com",
            description="An example zone",
            ttl=3000,
            zone_type="public")
        ```

        ### Create a private DNS zone

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        my_private_zone = sbercloud.dns.Zone("my_private_zone",
            name="1.example.com.",
            email="jdoe@example.com",
            description="An example zone",
            ttl=3000,
            zone_type="private",
            routers=[{
                "router_id": "2c1fe4bd-ebad-44ca-ae9d-e94e63847b75",
            }])
        ```

        ## Import

        This resource can be imported by specifying the zone ID:

        ```sh
        $ pulumi import sbercloud:Dns/zone:Zone zone_1 <zone_id>
        ```

        :param str resource_name: The name of the resource.
        :param ZoneArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ZoneArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 email: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 proxy_pattern: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 routers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZoneRouterArgs', 'ZoneRouterArgsDict']]]]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 ttl: Optional[pulumi.Input[_builtins.int]] = None,
                 zone_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ZoneArgs.__new__(ZoneArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["email"] = email
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["name"] = name
            __props__.__dict__["proxy_pattern"] = proxy_pattern
            __props__.__dict__["region"] = region
            __props__.__dict__["routers"] = routers
            __props__.__dict__["status"] = status
            __props__.__dict__["tags"] = tags
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["zone_type"] = zone_type
            __props__.__dict__["masters"] = None
        super(Zone, __self__).__init__(
            'sbercloud:Dns/zone:Zone',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            email: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            masters: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            proxy_pattern: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            routers: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ZoneRouterArgs', 'ZoneRouterArgsDict']]]]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            ttl: Optional[pulumi.Input[_builtins.int]] = None,
            zone_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Zone':
        """
        Get an existing Zone resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: A description of the zone.
        :param pulumi.Input[_builtins.str] email: The email address of the administrator managing the zone.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the zone. Changing this creates a
               new zone.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] masters: An array of master DNS servers.
        :param pulumi.Input[_builtins.str] name: The name of the zone. Note the `.` at the end of the name. Changing this creates
               a new DNS zone.
        :param pulumi.Input[_builtins.str] proxy_pattern: The recursive resolution proxy mode for subdomains of the private zone.
        :param pulumi.Input[_builtins.str] region: The region in which to create the DNS zone. If omitted, the `region` argument
               of the provider will be used. Changing this creates a new DNS zone.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ZoneRouterArgs', 'ZoneRouterArgsDict']]]] routers: Router configuration block which is required if zone_type is private. The router
               structure is documented below.
        :param pulumi.Input[_builtins.str] status: The status of the zone.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the zone.
        :param pulumi.Input[_builtins.int] ttl: The time to live (TTL) of the zone.
        :param pulumi.Input[_builtins.str] zone_type: The type of zone. Can either be `public` or `private`. Changing this
               creates a new DNS zone.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ZoneState.__new__(_ZoneState)

        __props__.__dict__["description"] = description
        __props__.__dict__["email"] = email
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["masters"] = masters
        __props__.__dict__["name"] = name
        __props__.__dict__["proxy_pattern"] = proxy_pattern
        __props__.__dict__["region"] = region
        __props__.__dict__["routers"] = routers
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["zone_type"] = zone_type
        return Zone(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the zone.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def email(self) -> pulumi.Output[_builtins.str]:
        """
        The email address of the administrator managing the zone.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project id of the zone. Changing this creates a
        new zone.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter
    def masters(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        An array of master DNS servers.
        """
        return pulumi.get(self, "masters")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the zone. Note the `.` at the end of the name. Changing this creates
        a new DNS zone.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="proxyPattern")
    def proxy_pattern(self) -> pulumi.Output[_builtins.str]:
        """
        The recursive resolution proxy mode for subdomains of the private zone.
        """
        return pulumi.get(self, "proxy_pattern")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the DNS zone. If omitted, the `region` argument
        of the provider will be used. Changing this creates a new DNS zone.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def routers(self) -> pulumi.Output[Optional[Sequence['outputs.ZoneRouter']]]:
        """
        Router configuration block which is required if zone_type is private. The router
        structure is documented below.
        """
        return pulumi.get(self, "routers")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the zone.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key/value pairs to associate with the zone.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The time to live (TTL) of the zone.
        """
        return pulumi.get(self, "ttl")

    @_builtins.property
    @pulumi.getter(name="zoneType")
    def zone_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of zone. Can either be `public` or `private`. Changing this
        creates a new DNS zone.
        """
        return pulumi.get(self, "zone_type")

