# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'JobDestinationDbArgs',
    'JobDestinationDbArgsDict',
    'JobLimitSpeedArgs',
    'JobLimitSpeedArgsDict',
    'JobSourceDbArgs',
    'JobSourceDbArgsDict',
]

MYPY = False

if not MYPY:
    class JobDestinationDbArgsDict(TypedDict):
        engine_type: pulumi.Input[_builtins.str]
        """
        Specifies the migration engine type.
        Changing this parameter will create a new resource. The options are as follows:
        + **mysql**:  MySQL migration, MySQL synchronization use.
        + **mongodb**: Mongodb migration use.
        + **cloudDataGuard-mysql**: Disaster recovery use.
        + **gaussdbv5**: GaussDB (for openGauss) synchronization use.
        + **mysql-to-kafka**: Synchronization from MySQL to Kafka use.
        + **taurus-to-kafka**: Synchronization from GaussDB(for MySQL) to Kafka use.
        + **gaussdbv5ha-to-kafka**: Synchronization from GaussDB primary/standby to Kafka use.
        + **postgresql**: Synchronization from PostgreSQL to PostgreSQL use.
        """
        ip: pulumi.Input[_builtins.str]
        """
        Specifies the IP of database. Changing this parameter will create a new resource.
        """
        password: pulumi.Input[_builtins.str]
        """
        Specifies the password of database.
        Changing this parameter will create a new resource.
        """
        port: pulumi.Input[_builtins.int]
        """
        Specifies the port of database. Changing this parameter will create a new resource.
        """
        user: pulumi.Input[_builtins.str]
        """
        Specifies the user name of database.
        Changing this parameter will create a new resource.
        """
        instance_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the instance id of database when it is a RDS database.
        Changing this parameter will create a new resource.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the job name. The name consists of 4 to 50 characters, starting with
        a letter. Only letters, digits, underscores (\\_) and hyphens (-) are allowed.
        """
        region: NotRequired[pulumi.Input[_builtins.str]]
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        ssl_cert_check_sum: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the checksum of SSL certificate content.
        It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        """
        ssl_cert_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the SSL certificate content, encrypted with base64.
        It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        """
        ssl_cert_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies SSL certificate name.
        It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        """
        ssl_cert_password: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies SSL certificate password. It is mandatory when
        `ssl_enabled` is `true` and the certificate file suffix is `.p12`. Changing this parameter will create a new resource.
        """
        ssl_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies whether to enable SSL connection.
        Changing this parameter will create a new resource.
        """
        subnet_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies subnet ID of database when it is a RDS database.
        It is mandatory when `direction` is `down`. Changing this parameter will create a new resource.
        """
elif False:
    JobDestinationDbArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobDestinationDbArgs:
    def __init__(__self__, *,
                 engine_type: pulumi.Input[_builtins.str],
                 ip: pulumi.Input[_builtins.str],
                 password: pulumi.Input[_builtins.str],
                 port: pulumi.Input[_builtins.int],
                 user: pulumi.Input[_builtins.str],
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_cert_check_sum: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_cert_key: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_cert_password: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] engine_type: Specifies the migration engine type.
               Changing this parameter will create a new resource. The options are as follows:
               + **mysql**:  MySQL migration, MySQL synchronization use.
               + **mongodb**: Mongodb migration use.
               + **cloudDataGuard-mysql**: Disaster recovery use.
               + **gaussdbv5**: GaussDB (for openGauss) synchronization use.
               + **mysql-to-kafka**: Synchronization from MySQL to Kafka use.
               + **taurus-to-kafka**: Synchronization from GaussDB(for MySQL) to Kafka use.
               + **gaussdbv5ha-to-kafka**: Synchronization from GaussDB primary/standby to Kafka use.
               + **postgresql**: Synchronization from PostgreSQL to PostgreSQL use.
        :param pulumi.Input[_builtins.str] ip: Specifies the IP of database. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] password: Specifies the password of database.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] port: Specifies the port of database. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] user: Specifies the user name of database.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the instance id of database when it is a RDS database.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the job name. The name consists of 4 to 50 characters, starting with
               a letter. Only letters, digits, underscores (\\_) and hyphens (-) are allowed.
        :param pulumi.Input[_builtins.str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ssl_cert_check_sum: Specifies the checksum of SSL certificate content.
               It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ssl_cert_key: Specifies the SSL certificate content, encrypted with base64.
               It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ssl_cert_name: Specifies SSL certificate name.
               It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ssl_cert_password: Specifies SSL certificate password. It is mandatory when
               `ssl_enabled` is `true` and the certificate file suffix is `.p12`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] ssl_enabled: Specifies whether to enable SSL connection.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies subnet ID of database when it is a RDS database.
               It is mandatory when `direction` is `down`. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "engine_type", engine_type)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "user", user)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if ssl_cert_check_sum is not None:
            pulumi.set(__self__, "ssl_cert_check_sum", ssl_cert_check_sum)
        if ssl_cert_key is not None:
            pulumi.set(__self__, "ssl_cert_key", ssl_cert_key)
        if ssl_cert_name is not None:
            pulumi.set(__self__, "ssl_cert_name", ssl_cert_name)
        if ssl_cert_password is not None:
            pulumi.set(__self__, "ssl_cert_password", ssl_cert_password)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the migration engine type.
        Changing this parameter will create a new resource. The options are as follows:
        + **mysql**:  MySQL migration, MySQL synchronization use.
        + **mongodb**: Mongodb migration use.
        + **cloudDataGuard-mysql**: Disaster recovery use.
        + **gaussdbv5**: GaussDB (for openGauss) synchronization use.
        + **mysql-to-kafka**: Synchronization from MySQL to Kafka use.
        + **taurus-to-kafka**: Synchronization from GaussDB(for MySQL) to Kafka use.
        + **gaussdbv5ha-to-kafka**: Synchronization from GaussDB primary/standby to Kafka use.
        + **postgresql**: Synchronization from PostgreSQL to PostgreSQL use.
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_type", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the IP of database. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the password of database.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the port of database. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the user name of database.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the instance id of database when it is a RDS database.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the job name. The name consists of 4 to 50 characters, starting with
        a letter. Only letters, digits, underscores (\\_) and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sslCertCheckSum")
    def ssl_cert_check_sum(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the checksum of SSL certificate content.
        It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ssl_cert_check_sum")

    @ssl_cert_check_sum.setter
    def ssl_cert_check_sum(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_cert_check_sum", value)

    @_builtins.property
    @pulumi.getter(name="sslCertKey")
    def ssl_cert_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SSL certificate content, encrypted with base64.
        It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ssl_cert_key")

    @ssl_cert_key.setter
    def ssl_cert_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_cert_key", value)

    @_builtins.property
    @pulumi.getter(name="sslCertName")
    def ssl_cert_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies SSL certificate name.
        It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ssl_cert_name")

    @ssl_cert_name.setter
    def ssl_cert_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_cert_name", value)

    @_builtins.property
    @pulumi.getter(name="sslCertPassword")
    def ssl_cert_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies SSL certificate password. It is mandatory when
        `ssl_enabled` is `true` and the certificate file suffix is `.p12`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ssl_cert_password")

    @ssl_cert_password.setter
    def ssl_cert_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_cert_password", value)

    @_builtins.property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable SSL connection.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ssl_enabled")

    @ssl_enabled.setter
    def ssl_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_enabled", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies subnet ID of database when it is a RDS database.
        It is mandatory when `direction` is `down`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)


if not MYPY:
    class JobLimitSpeedArgsDict(TypedDict):
        end_time: pulumi.Input[_builtins.str]
        """
        Specifies the time to end speed limit, this time is UTC time. The input must
        end at 59 minutes, the format is `hh:mm`, for example: 15:59. Changing this parameter will create a new resource.
        """
        speed: pulumi.Input[_builtins.str]
        """
        Specifies the transmission speed, the value range is 1 to 9999, unit: `MB/s`.
        Changing this parameter will create a new resource.
        """
        start_time: pulumi.Input[_builtins.str]
        """
        Specifies the time to start speed limit, this time is UTC time. The start
        time is the whole hour, if there is a minute, it will be ignored, the format is `hh:mm`, and the hour number
        is two digits, for example: 01:00. Changing this parameter will create a new resource.
        """
elif False:
    JobLimitSpeedArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobLimitSpeedArgs:
    def __init__(__self__, *,
                 end_time: pulumi.Input[_builtins.str],
                 speed: pulumi.Input[_builtins.str],
                 start_time: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] end_time: Specifies the time to end speed limit, this time is UTC time. The input must
               end at 59 minutes, the format is `hh:mm`, for example: 15:59. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] speed: Specifies the transmission speed, the value range is 1 to 9999, unit: `MB/s`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] start_time: Specifies the time to start speed limit, this time is UTC time. The start
               time is the whole hour, if there is a minute, it will be ignored, the format is `hh:mm`, and the hour number
               is two digits, for example: 01:00. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "speed", speed)
        pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the time to end speed limit, this time is UTC time. The input must
        end at 59 minutes, the format is `hh:mm`, for example: 15:59. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter
    def speed(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the transmission speed, the value range is 1 to 9999, unit: `MB/s`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "speed")

    @speed.setter
    def speed(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "speed", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the time to start speed limit, this time is UTC time. The start
        time is the whole hour, if there is a minute, it will be ignored, the format is `hh:mm`, and the hour number
        is two digits, for example: 01:00. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "start_time", value)


if not MYPY:
    class JobSourceDbArgsDict(TypedDict):
        engine_type: pulumi.Input[_builtins.str]
        """
        Specifies the migration engine type.
        Changing this parameter will create a new resource. The options are as follows:
        + **mysql**:  MySQL migration, MySQL synchronization use.
        + **mongodb**: Mongodb migration use.
        + **cloudDataGuard-mysql**: Disaster recovery use.
        + **gaussdbv5**: GaussDB (for openGauss) synchronization use.
        + **mysql-to-kafka**: Synchronization from MySQL to Kafka use.
        + **taurus-to-kafka**: Synchronization from GaussDB(for MySQL) to Kafka use.
        + **gaussdbv5ha-to-kafka**: Synchronization from GaussDB primary/standby to Kafka use.
        + **postgresql**: Synchronization from PostgreSQL to PostgreSQL use.
        """
        ip: pulumi.Input[_builtins.str]
        """
        Specifies the IP of database. Changing this parameter will create a new resource.
        """
        password: pulumi.Input[_builtins.str]
        """
        Specifies the password of database.
        Changing this parameter will create a new resource.
        """
        port: pulumi.Input[_builtins.int]
        """
        Specifies the port of database. Changing this parameter will create a new resource.
        """
        user: pulumi.Input[_builtins.str]
        """
        Specifies the user name of database.
        Changing this parameter will create a new resource.
        """
        instance_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the instance id of database when it is a RDS database.
        Changing this parameter will create a new resource.
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the job name. The name consists of 4 to 50 characters, starting with
        a letter. Only letters, digits, underscores (\\_) and hyphens (-) are allowed.
        """
        region: NotRequired[pulumi.Input[_builtins.str]]
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        ssl_cert_check_sum: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the checksum of SSL certificate content.
        It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        """
        ssl_cert_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the SSL certificate content, encrypted with base64.
        It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        """
        ssl_cert_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies SSL certificate name.
        It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        """
        ssl_cert_password: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies SSL certificate password. It is mandatory when
        `ssl_enabled` is `true` and the certificate file suffix is `.p12`. Changing this parameter will create a new resource.
        """
        ssl_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies whether to enable SSL connection.
        Changing this parameter will create a new resource.
        """
        subnet_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies subnet ID of database when it is a RDS database.
        It is mandatory when `direction` is `down`. Changing this parameter will create a new resource.
        """
elif False:
    JobSourceDbArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class JobSourceDbArgs:
    def __init__(__self__, *,
                 engine_type: pulumi.Input[_builtins.str],
                 ip: pulumi.Input[_builtins.str],
                 password: pulumi.Input[_builtins.str],
                 port: pulumi.Input[_builtins.int],
                 user: pulumi.Input[_builtins.str],
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_cert_check_sum: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_cert_key: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_cert_name: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_cert_password: Optional[pulumi.Input[_builtins.str]] = None,
                 ssl_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] engine_type: Specifies the migration engine type.
               Changing this parameter will create a new resource. The options are as follows:
               + **mysql**:  MySQL migration, MySQL synchronization use.
               + **mongodb**: Mongodb migration use.
               + **cloudDataGuard-mysql**: Disaster recovery use.
               + **gaussdbv5**: GaussDB (for openGauss) synchronization use.
               + **mysql-to-kafka**: Synchronization from MySQL to Kafka use.
               + **taurus-to-kafka**: Synchronization from GaussDB(for MySQL) to Kafka use.
               + **gaussdbv5ha-to-kafka**: Synchronization from GaussDB primary/standby to Kafka use.
               + **postgresql**: Synchronization from PostgreSQL to PostgreSQL use.
        :param pulumi.Input[_builtins.str] ip: Specifies the IP of database. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] password: Specifies the password of database.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] port: Specifies the port of database. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] user: Specifies the user name of database.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the instance id of database when it is a RDS database.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the job name. The name consists of 4 to 50 characters, starting with
               a letter. Only letters, digits, underscores (\\_) and hyphens (-) are allowed.
        :param pulumi.Input[_builtins.str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ssl_cert_check_sum: Specifies the checksum of SSL certificate content.
               It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ssl_cert_key: Specifies the SSL certificate content, encrypted with base64.
               It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ssl_cert_name: Specifies SSL certificate name.
               It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] ssl_cert_password: Specifies SSL certificate password. It is mandatory when
               `ssl_enabled` is `true` and the certificate file suffix is `.p12`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] ssl_enabled: Specifies whether to enable SSL connection.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] subnet_id: Specifies subnet ID of database when it is a RDS database.
               It is mandatory when `direction` is `down`. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "engine_type", engine_type)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "user", user)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if ssl_cert_check_sum is not None:
            pulumi.set(__self__, "ssl_cert_check_sum", ssl_cert_check_sum)
        if ssl_cert_key is not None:
            pulumi.set(__self__, "ssl_cert_key", ssl_cert_key)
        if ssl_cert_name is not None:
            pulumi.set(__self__, "ssl_cert_name", ssl_cert_name)
        if ssl_cert_password is not None:
            pulumi.set(__self__, "ssl_cert_password", ssl_cert_password)
        if ssl_enabled is not None:
            pulumi.set(__self__, "ssl_enabled", ssl_enabled)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the migration engine type.
        Changing this parameter will create a new resource. The options are as follows:
        + **mysql**:  MySQL migration, MySQL synchronization use.
        + **mongodb**: Mongodb migration use.
        + **cloudDataGuard-mysql**: Disaster recovery use.
        + **gaussdbv5**: GaussDB (for openGauss) synchronization use.
        + **mysql-to-kafka**: Synchronization from MySQL to Kafka use.
        + **taurus-to-kafka**: Synchronization from GaussDB(for MySQL) to Kafka use.
        + **gaussdbv5ha-to-kafka**: Synchronization from GaussDB primary/standby to Kafka use.
        + **postgresql**: Synchronization from PostgreSQL to PostgreSQL use.
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_type", value)

    @_builtins.property
    @pulumi.getter
    def ip(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the IP of database. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ip")

    @ip.setter
    def ip(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the password of database.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the port of database. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter
    def user(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the user name of database.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "user")

    @user.setter
    def user(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the instance id of database when it is a RDS database.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the job name. The name consists of 4 to 50 characters, starting with
        a letter. Only letters, digits, underscores (\\_) and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sslCertCheckSum")
    def ssl_cert_check_sum(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the checksum of SSL certificate content.
        It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ssl_cert_check_sum")

    @ssl_cert_check_sum.setter
    def ssl_cert_check_sum(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_cert_check_sum", value)

    @_builtins.property
    @pulumi.getter(name="sslCertKey")
    def ssl_cert_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SSL certificate content, encrypted with base64.
        It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ssl_cert_key")

    @ssl_cert_key.setter
    def ssl_cert_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_cert_key", value)

    @_builtins.property
    @pulumi.getter(name="sslCertName")
    def ssl_cert_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies SSL certificate name.
        It is mandatory when `ssl_enabled` is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ssl_cert_name")

    @ssl_cert_name.setter
    def ssl_cert_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_cert_name", value)

    @_builtins.property
    @pulumi.getter(name="sslCertPassword")
    def ssl_cert_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies SSL certificate password. It is mandatory when
        `ssl_enabled` is `true` and the certificate file suffix is `.p12`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ssl_cert_password")

    @ssl_cert_password.setter
    def ssl_cert_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "ssl_cert_password", value)

    @_builtins.property
    @pulumi.getter(name="sslEnabled")
    def ssl_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable SSL connection.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "ssl_enabled")

    @ssl_enabled.setter
    def ssl_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssl_enabled", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies subnet ID of database when it is a RDS database.
        It is mandatory when `direction` is `down`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)


