# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JobArgs', 'Job']

@pulumi.input_type
class JobArgs:
    def __init__(__self__, *,
                 destination_db: pulumi.Input['JobDestinationDbArgs'],
                 direction: pulumi.Input[_builtins.str],
                 engine_type: pulumi.Input[_builtins.str],
                 source_db: pulumi.Input['JobSourceDbArgs'],
                 type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_db_readnoly: Optional[pulumi.Input[_builtins.bool]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 expired_days: Optional[pulumi.Input[_builtins.int]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 limit_speeds: Optional[pulumi.Input[Sequence[pulumi.Input['JobLimitSpeedArgs']]]] = None,
                 migrate_definer: Optional[pulumi.Input[_builtins.bool]] = None,
                 migration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_write: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Job resource.
        :param pulumi.Input['JobDestinationDbArgs'] destination_db: Specifies the destination database configuration.
               The `db_info` object structure of the `destination_db` is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] direction: Specifies the direction of data flow.
               Changing this parameter will create a new resource. The options are as follows:
               + **up**: To the cloud. The destination database must be a database in the current cloud.
               + **down**: Out of the cloud. The source database must be a database in the current cloud.
               + **non-dbs**: self-built database.
        :param pulumi.Input[_builtins.str] engine_type: Specifies the migration engine type.
               Changing this parameter will create a new resource. The options are as follows:
               + **mysql**:  MySQL migration, MySQL synchronization use.
               + **mongodb**: Mongodb migration use.
               + **cloudDataGuard-mysql**: Disaster recovery use.
               + **gaussdbv5**: GaussDB (for openGauss) synchronization use.
               + **mysql-to-kafka**: Synchronization from MySQL to Kafka use.
               + **taurus-to-kafka**: Synchronization from GaussDB(for MySQL) to Kafka use.
               + **gaussdbv5ha-to-kafka**: Synchronization from GaussDB primary/standby to Kafka use.
               + **postgresql**: Synchronization from PostgreSQL to PostgreSQL use.
        :param pulumi.Input['JobSourceDbArgs'] source_db: Specifies the source database configuration.
               The `db_info` object structure of the `source_db` is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] type: Specifies the job type. Changing this parameter will create a new
               resource. The options are as follows:
               + **migration**: Online Migration.
               + **sync**: Data Synchronization.
               + **cloudDataGuard**: Disaster Recovery.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the job, which contain a
               maximum of 256 characters, and certain special characters (including !<>&'"\\\\) are not allowed.
        :param pulumi.Input[_builtins.bool] destination_db_readnoly: Specifies the destination DB instance as read-only helps
               ensure the migration is successful. Once the migration is complete, the DB instance automatically changes to
               Read/Write. The default value is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] expired_days: Specifies how many days after the task is abnormal, it will automatically
               end. The value ranges from 14 to 100. the default value is `14`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] force_destroy: Specifies whether to forcibly destroy the job even if it is running.
               The default value is `false`.
        :param pulumi.Input[Sequence[pulumi.Input['JobLimitSpeedArgs']]] limit_speeds: Specifies the migration speed by setting a time period.
               The default is no speed limit. The maximum length is 3. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] migrate_definer: Specifies whether to migrate the definers of all source database
               objects to the `user` of `destination_db`. The default value is `true`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] migration_type: Specifies migration type.
               Changing this parameter will create a new resource. The options are as follows:
               + **FULL_TRANS**: Full migration. Suitable for scenarios where services can be interrupted. It migrates all database
               objects and data, in a non-system database, to a destination database at a time.
               + **INCR_TRANS**: Incremental migration. Suitable for migration from an on-premises self-built database to a
               destination cloud database, or from one cloud database to another in a different region.
               + **FULL_INCR_TRANS**:  Full+Incremental migration. This allows to migrate data with minimal downtime. After a full
               migration initializes the destination database, an incremental migration parses logs to ensure data consistency
               between the source and destination databases.
               
               The default value is `FULL_INCR_TRANS`.
        :param pulumi.Input[_builtins.bool] multi_write: Specifies whether to enable multi write. It is mandatory when `type`
               is `cloudDataGuard`. When the disaster recovery type is dual-active disaster recovery, set `multi_write` to `true`,
               otherwise to `false`. The default value is `false`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the job name. The name consists of 4 to 50 characters, starting with
               a letter. Only letters, digits, underscores (\\_) and hyphens (-) are allowed.
        :param pulumi.Input[_builtins.str] net_type: Specifies the network type.
               Changing this parameter will create a new resource. The options are as follows:
               + **eip**: suitable for migration from an on-premises or other cloud database to a destination cloud database.
               An EIP will be automatically bound to the replication instance and released after the replication task is complete.
               + **vpc**: suitable for migration from one cloud database to another.
               + **vpn**: suitable for migration from an on-premises self-built database to a destination cloud database,
               or from one cloud database to another in a different region.
               
               The default value is `eip`.
        :param pulumi.Input[_builtins.str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] start_time: Specifies the time to start the job. The time format
               is `yyyy-MM-dd HH:mm:ss`. Start immediately by default. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the DRS job.
               Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "destination_db", destination_db)
        pulumi.set(__self__, "direction", direction)
        pulumi.set(__self__, "engine_type", engine_type)
        pulumi.set(__self__, "source_db", source_db)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_db_readnoly is not None:
            pulumi.set(__self__, "destination_db_readnoly", destination_db_readnoly)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if expired_days is not None:
            pulumi.set(__self__, "expired_days", expired_days)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if limit_speeds is not None:
            pulumi.set(__self__, "limit_speeds", limit_speeds)
        if migrate_definer is not None:
            pulumi.set(__self__, "migrate_definer", migrate_definer)
        if migration_type is not None:
            pulumi.set(__self__, "migration_type", migration_type)
        if multi_write is not None:
            pulumi.set(__self__, "multi_write", multi_write)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if net_type is not None:
            pulumi.set(__self__, "net_type", net_type)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="destinationDb")
    def destination_db(self) -> pulumi.Input['JobDestinationDbArgs']:
        """
        Specifies the destination database configuration.
        The `db_info` object structure of the `destination_db` is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "destination_db")

    @destination_db.setter
    def destination_db(self, value: pulumi.Input['JobDestinationDbArgs']):
        pulumi.set(self, "destination_db", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the direction of data flow.
        Changing this parameter will create a new resource. The options are as follows:
        + **up**: To the cloud. The destination database must be a database in the current cloud.
        + **down**: Out of the cloud. The source database must be a database in the current cloud.
        + **non-dbs**: self-built database.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the migration engine type.
        Changing this parameter will create a new resource. The options are as follows:
        + **mysql**:  MySQL migration, MySQL synchronization use.
        + **mongodb**: Mongodb migration use.
        + **cloudDataGuard-mysql**: Disaster recovery use.
        + **gaussdbv5**: GaussDB (for openGauss) synchronization use.
        + **mysql-to-kafka**: Synchronization from MySQL to Kafka use.
        + **taurus-to-kafka**: Synchronization from GaussDB(for MySQL) to Kafka use.
        + **gaussdbv5ha-to-kafka**: Synchronization from GaussDB primary/standby to Kafka use.
        + **postgresql**: Synchronization from PostgreSQL to PostgreSQL use.
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "engine_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceDb")
    def source_db(self) -> pulumi.Input['JobSourceDbArgs']:
        """
        Specifies the source database configuration.
        The `db_info` object structure of the `source_db` is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_db")

    @source_db.setter
    def source_db(self, value: pulumi.Input['JobSourceDbArgs']):
        pulumi.set(self, "source_db", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the job type. Changing this parameter will create a new
        resource. The options are as follows:
        + **migration**: Online Migration.
        + **sync**: Data Synchronization.
        + **cloudDataGuard**: Disaster Recovery.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the job, which contain a
        maximum of 256 characters, and certain special characters (including !<>&'"\\\\) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationDbReadnoly")
    def destination_db_readnoly(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the destination DB instance as read-only helps
        ensure the migration is successful. Once the migration is complete, the DB instance automatically changes to
        Read/Write. The default value is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "destination_db_readnoly")

    @destination_db_readnoly.setter
    def destination_db_readnoly(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "destination_db_readnoly", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="expiredDays")
    def expired_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies how many days after the task is abnormal, it will automatically
        end. The value ranges from 14 to 100. the default value is `14`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "expired_days")

    @expired_days.setter
    def expired_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expired_days", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to forcibly destroy the job even if it is running.
        The default value is `false`.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="limitSpeeds")
    def limit_speeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobLimitSpeedArgs']]]]:
        """
        Specifies the migration speed by setting a time period.
        The default is no speed limit. The maximum length is 3. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "limit_speeds")

    @limit_speeds.setter
    def limit_speeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobLimitSpeedArgs']]]]):
        pulumi.set(self, "limit_speeds", value)

    @_builtins.property
    @pulumi.getter(name="migrateDefiner")
    def migrate_definer(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to migrate the definers of all source database
        objects to the `user` of `destination_db`. The default value is `true`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "migrate_definer")

    @migrate_definer.setter
    def migrate_definer(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "migrate_definer", value)

    @_builtins.property
    @pulumi.getter(name="migrationType")
    def migration_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies migration type.
        Changing this parameter will create a new resource. The options are as follows:
        + **FULL_TRANS**: Full migration. Suitable for scenarios where services can be interrupted. It migrates all database
        objects and data, in a non-system database, to a destination database at a time.
        + **INCR_TRANS**: Incremental migration. Suitable for migration from an on-premises self-built database to a
        destination cloud database, or from one cloud database to another in a different region.
        + **FULL_INCR_TRANS**:  Full+Incremental migration. This allows to migrate data with minimal downtime. After a full
        migration initializes the destination database, an incremental migration parses logs to ensure data consistency
        between the source and destination databases.

        The default value is `FULL_INCR_TRANS`.
        """
        return pulumi.get(self, "migration_type")

    @migration_type.setter
    def migration_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "migration_type", value)

    @_builtins.property
    @pulumi.getter(name="multiWrite")
    def multi_write(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable multi write. It is mandatory when `type`
        is `cloudDataGuard`. When the disaster recovery type is dual-active disaster recovery, set `multi_write` to `true`,
        otherwise to `false`. The default value is `false`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "multi_write")

    @multi_write.setter
    def multi_write(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multi_write", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the job name. The name consists of 4 to 50 characters, starting with
        a letter. Only letters, digits, underscores (\\_) and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the network type.
        Changing this parameter will create a new resource. The options are as follows:
        + **eip**: suitable for migration from an on-premises or other cloud database to a destination cloud database.
        An EIP will be automatically bound to the replication instance and released after the replication task is complete.
        + **vpc**: suitable for migration from one cloud database to another.
        + **vpn**: suitable for migration from an on-premises self-built database to a destination cloud database,
        or from one cloud database to another in a different region.

        The default value is `eip`.
        """
        return pulumi.get(self, "net_type")

    @net_type.setter
    def net_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "net_type", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time to start the job. The time format
        is `yyyy-MM-dd HH:mm:ss`. Start immediately by default. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the DRS job.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _JobState:
    def __init__(__self__, *,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_db: Optional[pulumi.Input['JobDestinationDbArgs']] = None,
                 destination_db_readnoly: Optional[pulumi.Input[_builtins.bool]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 expired_days: Optional[pulumi.Input[_builtins.int]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 limit_speeds: Optional[pulumi.Input[Sequence[pulumi.Input['JobLimitSpeedArgs']]]] = None,
                 migrate_definer: Optional[pulumi.Input[_builtins.bool]] = None,
                 migration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_write: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_db: Optional[pulumi.Input['JobSourceDbArgs']] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Job resources.
        :param pulumi.Input[_builtins.str] created_at: Create time. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        :param pulumi.Input[_builtins.str] description: Specifies the description of the job, which contain a
               maximum of 256 characters, and certain special characters (including !<>&'"\\\\) are not allowed.
        :param pulumi.Input['JobDestinationDbArgs'] destination_db: Specifies the destination database configuration.
               The `db_info` object structure of the `destination_db` is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] destination_db_readnoly: Specifies the destination DB instance as read-only helps
               ensure the migration is successful. Once the migration is complete, the DB instance automatically changes to
               Read/Write. The default value is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] direction: Specifies the direction of data flow.
               Changing this parameter will create a new resource. The options are as follows:
               + **up**: To the cloud. The destination database must be a database in the current cloud.
               + **down**: Out of the cloud. The source database must be a database in the current cloud.
               + **non-dbs**: self-built database.
        :param pulumi.Input[_builtins.str] engine_type: Specifies the migration engine type.
               Changing this parameter will create a new resource. The options are as follows:
               + **mysql**:  MySQL migration, MySQL synchronization use.
               + **mongodb**: Mongodb migration use.
               + **cloudDataGuard-mysql**: Disaster recovery use.
               + **gaussdbv5**: GaussDB (for openGauss) synchronization use.
               + **mysql-to-kafka**: Synchronization from MySQL to Kafka use.
               + **taurus-to-kafka**: Synchronization from GaussDB(for MySQL) to Kafka use.
               + **gaussdbv5ha-to-kafka**: Synchronization from GaussDB primary/standby to Kafka use.
               + **postgresql**: Synchronization from PostgreSQL to PostgreSQL use.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] expired_days: Specifies how many days after the task is abnormal, it will automatically
               end. The value ranges from 14 to 100. the default value is `14`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] force_destroy: Specifies whether to forcibly destroy the job even if it is running.
               The default value is `false`.
        :param pulumi.Input[Sequence[pulumi.Input['JobLimitSpeedArgs']]] limit_speeds: Specifies the migration speed by setting a time period.
               The default is no speed limit. The maximum length is 3. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] migrate_definer: Specifies whether to migrate the definers of all source database
               objects to the `user` of `destination_db`. The default value is `true`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] migration_type: Specifies migration type.
               Changing this parameter will create a new resource. The options are as follows:
               + **FULL_TRANS**: Full migration. Suitable for scenarios where services can be interrupted. It migrates all database
               objects and data, in a non-system database, to a destination database at a time.
               + **INCR_TRANS**: Incremental migration. Suitable for migration from an on-premises self-built database to a
               destination cloud database, or from one cloud database to another in a different region.
               + **FULL_INCR_TRANS**:  Full+Incremental migration. This allows to migrate data with minimal downtime. After a full
               migration initializes the destination database, an incremental migration parses logs to ensure data consistency
               between the source and destination databases.
               
               The default value is `FULL_INCR_TRANS`.
        :param pulumi.Input[_builtins.bool] multi_write: Specifies whether to enable multi write. It is mandatory when `type`
               is `cloudDataGuard`. When the disaster recovery type is dual-active disaster recovery, set `multi_write` to `true`,
               otherwise to `false`. The default value is `false`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the job name. The name consists of 4 to 50 characters, starting with
               a letter. Only letters, digits, underscores (\\_) and hyphens (-) are allowed.
        :param pulumi.Input[_builtins.str] net_type: Specifies the network type.
               Changing this parameter will create a new resource. The options are as follows:
               + **eip**: suitable for migration from an on-premises or other cloud database to a destination cloud database.
               An EIP will be automatically bound to the replication instance and released after the replication task is complete.
               + **vpc**: suitable for migration from one cloud database to another.
               + **vpn**: suitable for migration from an on-premises self-built database to a destination cloud database,
               or from one cloud database to another in a different region.
               
               The default value is `eip`.
        :param pulumi.Input[_builtins.str] private_ip: Private IP.
        :param pulumi.Input[_builtins.str] public_ip: Public IP.
        :param pulumi.Input[_builtins.str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input['JobSourceDbArgs'] source_db: Specifies the source database configuration.
               The `db_info` object structure of the `source_db` is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] start_time: Specifies the time to start the job. The time format
               is `yyyy-MM-dd HH:mm:ss`. Start immediately by default. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: Status.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the DRS job.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] type: Specifies the job type. Changing this parameter will create a new
               resource. The options are as follows:
               + **migration**: Online Migration.
               + **sync**: Data Synchronization.
               + **cloudDataGuard**: Disaster Recovery.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if destination_db is not None:
            pulumi.set(__self__, "destination_db", destination_db)
        if destination_db_readnoly is not None:
            pulumi.set(__self__, "destination_db_readnoly", destination_db_readnoly)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)
        if engine_type is not None:
            pulumi.set(__self__, "engine_type", engine_type)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if expired_days is not None:
            pulumi.set(__self__, "expired_days", expired_days)
        if force_destroy is not None:
            pulumi.set(__self__, "force_destroy", force_destroy)
        if limit_speeds is not None:
            pulumi.set(__self__, "limit_speeds", limit_speeds)
        if migrate_definer is not None:
            pulumi.set(__self__, "migrate_definer", migrate_definer)
        if migration_type is not None:
            pulumi.set(__self__, "migration_type", migration_type)
        if multi_write is not None:
            pulumi.set(__self__, "multi_write", multi_write)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if net_type is not None:
            pulumi.set(__self__, "net_type", net_type)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if source_db is not None:
            pulumi.set(__self__, "source_db", source_db)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Create time. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the job, which contain a
        maximum of 256 characters, and certain special characters (including !<>&'"\\\\) are not allowed.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="destinationDb")
    def destination_db(self) -> Optional[pulumi.Input['JobDestinationDbArgs']]:
        """
        Specifies the destination database configuration.
        The `db_info` object structure of the `destination_db` is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "destination_db")

    @destination_db.setter
    def destination_db(self, value: Optional[pulumi.Input['JobDestinationDbArgs']]):
        pulumi.set(self, "destination_db", value)

    @_builtins.property
    @pulumi.getter(name="destinationDbReadnoly")
    def destination_db_readnoly(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies the destination DB instance as read-only helps
        ensure the migration is successful. Once the migration is complete, the DB instance automatically changes to
        Read/Write. The default value is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "destination_db_readnoly")

    @destination_db_readnoly.setter
    def destination_db_readnoly(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "destination_db_readnoly", value)

    @_builtins.property
    @pulumi.getter
    def direction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the direction of data flow.
        Changing this parameter will create a new resource. The options are as follows:
        + **up**: To the cloud. The destination database must be a database in the current cloud.
        + **down**: Out of the cloud. The source database must be a database in the current cloud.
        + **non-dbs**: self-built database.
        """
        return pulumi.get(self, "direction")

    @direction.setter
    def direction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "direction", value)

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the migration engine type.
        Changing this parameter will create a new resource. The options are as follows:
        + **mysql**:  MySQL migration, MySQL synchronization use.
        + **mongodb**: Mongodb migration use.
        + **cloudDataGuard-mysql**: Disaster recovery use.
        + **gaussdbv5**: GaussDB (for openGauss) synchronization use.
        + **mysql-to-kafka**: Synchronization from MySQL to Kafka use.
        + **taurus-to-kafka**: Synchronization from GaussDB(for MySQL) to Kafka use.
        + **gaussdbv5ha-to-kafka**: Synchronization from GaussDB primary/standby to Kafka use.
        + **postgresql**: Synchronization from PostgreSQL to PostgreSQL use.
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "engine_type", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the enterprise project id.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="expiredDays")
    def expired_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies how many days after the task is abnormal, it will automatically
        end. The value ranges from 14 to 100. the default value is `14`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "expired_days")

    @expired_days.setter
    def expired_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "expired_days", value)

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to forcibly destroy the job even if it is running.
        The default value is `false`.
        """
        return pulumi.get(self, "force_destroy")

    @force_destroy.setter
    def force_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_destroy", value)

    @_builtins.property
    @pulumi.getter(name="limitSpeeds")
    def limit_speeds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JobLimitSpeedArgs']]]]:
        """
        Specifies the migration speed by setting a time period.
        The default is no speed limit. The maximum length is 3. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "limit_speeds")

    @limit_speeds.setter
    def limit_speeds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JobLimitSpeedArgs']]]]):
        pulumi.set(self, "limit_speeds", value)

    @_builtins.property
    @pulumi.getter(name="migrateDefiner")
    def migrate_definer(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to migrate the definers of all source database
        objects to the `user` of `destination_db`. The default value is `true`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "migrate_definer")

    @migrate_definer.setter
    def migrate_definer(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "migrate_definer", value)

    @_builtins.property
    @pulumi.getter(name="migrationType")
    def migration_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies migration type.
        Changing this parameter will create a new resource. The options are as follows:
        + **FULL_TRANS**: Full migration. Suitable for scenarios where services can be interrupted. It migrates all database
        objects and data, in a non-system database, to a destination database at a time.
        + **INCR_TRANS**: Incremental migration. Suitable for migration from an on-premises self-built database to a
        destination cloud database, or from one cloud database to another in a different region.
        + **FULL_INCR_TRANS**:  Full+Incremental migration. This allows to migrate data with minimal downtime. After a full
        migration initializes the destination database, an incremental migration parses logs to ensure data consistency
        between the source and destination databases.

        The default value is `FULL_INCR_TRANS`.
        """
        return pulumi.get(self, "migration_type")

    @migration_type.setter
    def migration_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "migration_type", value)

    @_builtins.property
    @pulumi.getter(name="multiWrite")
    def multi_write(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to enable multi write. It is mandatory when `type`
        is `cloudDataGuard`. When the disaster recovery type is dual-active disaster recovery, set `multi_write` to `true`,
        otherwise to `false`. The default value is `false`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "multi_write")

    @multi_write.setter
    def multi_write(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "multi_write", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the job name. The name consists of 4 to 50 characters, starting with
        a letter. Only letters, digits, underscores (\\_) and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the network type.
        Changing this parameter will create a new resource. The options are as follows:
        + **eip**: suitable for migration from an on-premises or other cloud database to a destination cloud database.
        An EIP will be automatically bound to the replication instance and released after the replication task is complete.
        + **vpc**: suitable for migration from one cloud database to another.
        + **vpn**: suitable for migration from an on-premises self-built database to a destination cloud database,
        or from one cloud database to another in a different region.

        The default value is `eip`.
        """
        return pulumi.get(self, "net_type")

    @net_type.setter
    def net_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "net_type", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Private IP.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Public IP.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="sourceDb")
    def source_db(self) -> Optional[pulumi.Input['JobSourceDbArgs']]:
        """
        Specifies the source database configuration.
        The `db_info` object structure of the `source_db` is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_db")

    @source_db.setter
    def source_db(self, value: Optional[pulumi.Input['JobSourceDbArgs']]):
        pulumi.set(self, "source_db", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the time to start the job. The time format
        is `yyyy-MM-dd HH:mm:ss`. Start immediately by default. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the DRS job.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the job type. Changing this parameter will create a new
        resource. The options are as follows:
        + **migration**: Online Migration.
        + **sync**: Data Synchronization.
        + **cloudDataGuard**: Disaster Recovery.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("sbercloud:Drs/job:Job")
class Job(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_db: Optional[pulumi.Input[Union['JobDestinationDbArgs', 'JobDestinationDbArgsDict']]] = None,
                 destination_db_readnoly: Optional[pulumi.Input[_builtins.bool]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 expired_days: Optional[pulumi.Input[_builtins.int]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 limit_speeds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobLimitSpeedArgs', 'JobLimitSpeedArgsDict']]]]] = None,
                 migrate_definer: Optional[pulumi.Input[_builtins.bool]] = None,
                 migration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_write: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_db: Optional[pulumi.Input[Union['JobSourceDbArgs', 'JobSourceDbArgsDict']]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages DRS job resource within SberCloud.

        ## Example Usage

        ## Import

        The DRS job can be imported by `id`. For example,

        ```sh
        $ pulumi import sbercloud:Drs/job:Job test b11b407c-e604-4e8d-8bc4-92398320b847
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `enterprise_project_id`, `tags`,

        `force_destroy`, `source_db.0.password` and `destination_db.0.password`.It is generally recommended running

        `pulumi preview` after importing a job. You can then decide if changes should be applied to the job, or the resource

        definition should be updated to align with the job. Also you can ignore changes as below.

        resource "sbercloud_drs_job" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              source_db.0.password,destination_db.0.password
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the job, which contain a
               maximum of 256 characters, and certain special characters (including !<>&'"\\\\) are not allowed.
        :param pulumi.Input[Union['JobDestinationDbArgs', 'JobDestinationDbArgsDict']] destination_db: Specifies the destination database configuration.
               The `db_info` object structure of the `destination_db` is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] destination_db_readnoly: Specifies the destination DB instance as read-only helps
               ensure the migration is successful. Once the migration is complete, the DB instance automatically changes to
               Read/Write. The default value is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] direction: Specifies the direction of data flow.
               Changing this parameter will create a new resource. The options are as follows:
               + **up**: To the cloud. The destination database must be a database in the current cloud.
               + **down**: Out of the cloud. The source database must be a database in the current cloud.
               + **non-dbs**: self-built database.
        :param pulumi.Input[_builtins.str] engine_type: Specifies the migration engine type.
               Changing this parameter will create a new resource. The options are as follows:
               + **mysql**:  MySQL migration, MySQL synchronization use.
               + **mongodb**: Mongodb migration use.
               + **cloudDataGuard-mysql**: Disaster recovery use.
               + **gaussdbv5**: GaussDB (for openGauss) synchronization use.
               + **mysql-to-kafka**: Synchronization from MySQL to Kafka use.
               + **taurus-to-kafka**: Synchronization from GaussDB(for MySQL) to Kafka use.
               + **gaussdbv5ha-to-kafka**: Synchronization from GaussDB primary/standby to Kafka use.
               + **postgresql**: Synchronization from PostgreSQL to PostgreSQL use.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] expired_days: Specifies how many days after the task is abnormal, it will automatically
               end. The value ranges from 14 to 100. the default value is `14`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] force_destroy: Specifies whether to forcibly destroy the job even if it is running.
               The default value is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobLimitSpeedArgs', 'JobLimitSpeedArgsDict']]]] limit_speeds: Specifies the migration speed by setting a time period.
               The default is no speed limit. The maximum length is 3. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] migrate_definer: Specifies whether to migrate the definers of all source database
               objects to the `user` of `destination_db`. The default value is `true`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] migration_type: Specifies migration type.
               Changing this parameter will create a new resource. The options are as follows:
               + **FULL_TRANS**: Full migration. Suitable for scenarios where services can be interrupted. It migrates all database
               objects and data, in a non-system database, to a destination database at a time.
               + **INCR_TRANS**: Incremental migration. Suitable for migration from an on-premises self-built database to a
               destination cloud database, or from one cloud database to another in a different region.
               + **FULL_INCR_TRANS**:  Full+Incremental migration. This allows to migrate data with minimal downtime. After a full
               migration initializes the destination database, an incremental migration parses logs to ensure data consistency
               between the source and destination databases.
               
               The default value is `FULL_INCR_TRANS`.
        :param pulumi.Input[_builtins.bool] multi_write: Specifies whether to enable multi write. It is mandatory when `type`
               is `cloudDataGuard`. When the disaster recovery type is dual-active disaster recovery, set `multi_write` to `true`,
               otherwise to `false`. The default value is `false`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the job name. The name consists of 4 to 50 characters, starting with
               a letter. Only letters, digits, underscores (\\_) and hyphens (-) are allowed.
        :param pulumi.Input[_builtins.str] net_type: Specifies the network type.
               Changing this parameter will create a new resource. The options are as follows:
               + **eip**: suitable for migration from an on-premises or other cloud database to a destination cloud database.
               An EIP will be automatically bound to the replication instance and released after the replication task is complete.
               + **vpc**: suitable for migration from one cloud database to another.
               + **vpn**: suitable for migration from an on-premises self-built database to a destination cloud database,
               or from one cloud database to another in a different region.
               
               The default value is `eip`.
        :param pulumi.Input[_builtins.str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Union['JobSourceDbArgs', 'JobSourceDbArgsDict']] source_db: Specifies the source database configuration.
               The `db_info` object structure of the `source_db` is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] start_time: Specifies the time to start the job. The time format
               is `yyyy-MM-dd HH:mm:ss`. Start immediately by default. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the DRS job.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] type: Specifies the job type. Changing this parameter will create a new
               resource. The options are as follows:
               + **migration**: Online Migration.
               + **sync**: Data Synchronization.
               + **cloudDataGuard**: Disaster Recovery.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JobArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages DRS job resource within SberCloud.

        ## Example Usage

        ## Import

        The DRS job can be imported by `id`. For example,

        ```sh
        $ pulumi import sbercloud:Drs/job:Job test b11b407c-e604-4e8d-8bc4-92398320b847
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `enterprise_project_id`, `tags`,

        `force_destroy`, `source_db.0.password` and `destination_db.0.password`.It is generally recommended running

        `pulumi preview` after importing a job. You can then decide if changes should be applied to the job, or the resource

        definition should be updated to align with the job. Also you can ignore changes as below.

        resource "sbercloud_drs_job" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              source_db.0.password,destination_db.0.password
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param JobArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JobArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_db: Optional[pulumi.Input[Union['JobDestinationDbArgs', 'JobDestinationDbArgsDict']]] = None,
                 destination_db_readnoly: Optional[pulumi.Input[_builtins.bool]] = None,
                 direction: Optional[pulumi.Input[_builtins.str]] = None,
                 engine_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 expired_days: Optional[pulumi.Input[_builtins.int]] = None,
                 force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 limit_speeds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobLimitSpeedArgs', 'JobLimitSpeedArgsDict']]]]] = None,
                 migrate_definer: Optional[pulumi.Input[_builtins.bool]] = None,
                 migration_type: Optional[pulumi.Input[_builtins.str]] = None,
                 multi_write: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 net_type: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 source_db: Optional[pulumi.Input[Union['JobSourceDbArgs', 'JobSourceDbArgsDict']]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JobArgs.__new__(JobArgs)

            __props__.__dict__["description"] = description
            if destination_db is None and not opts.urn:
                raise TypeError("Missing required property 'destination_db'")
            __props__.__dict__["destination_db"] = destination_db
            __props__.__dict__["destination_db_readnoly"] = destination_db_readnoly
            if direction is None and not opts.urn:
                raise TypeError("Missing required property 'direction'")
            __props__.__dict__["direction"] = direction
            if engine_type is None and not opts.urn:
                raise TypeError("Missing required property 'engine_type'")
            __props__.__dict__["engine_type"] = engine_type
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["expired_days"] = expired_days
            __props__.__dict__["force_destroy"] = force_destroy
            __props__.__dict__["limit_speeds"] = limit_speeds
            __props__.__dict__["migrate_definer"] = migrate_definer
            __props__.__dict__["migration_type"] = migration_type
            __props__.__dict__["multi_write"] = multi_write
            __props__.__dict__["name"] = name
            __props__.__dict__["net_type"] = net_type
            __props__.__dict__["region"] = region
            if source_db is None and not opts.urn:
                raise TypeError("Missing required property 'source_db'")
            __props__.__dict__["source_db"] = source_db
            __props__.__dict__["start_time"] = start_time
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["created_at"] = None
            __props__.__dict__["private_ip"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["status"] = None
        super(Job, __self__).__init__(
            'sbercloud:Drs/job:Job',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            destination_db: Optional[pulumi.Input[Union['JobDestinationDbArgs', 'JobDestinationDbArgsDict']]] = None,
            destination_db_readnoly: Optional[pulumi.Input[_builtins.bool]] = None,
            direction: Optional[pulumi.Input[_builtins.str]] = None,
            engine_type: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            expired_days: Optional[pulumi.Input[_builtins.int]] = None,
            force_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            limit_speeds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JobLimitSpeedArgs', 'JobLimitSpeedArgsDict']]]]] = None,
            migrate_definer: Optional[pulumi.Input[_builtins.bool]] = None,
            migration_type: Optional[pulumi.Input[_builtins.str]] = None,
            multi_write: Optional[pulumi.Input[_builtins.bool]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            net_type: Optional[pulumi.Input[_builtins.str]] = None,
            private_ip: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            source_db: Optional[pulumi.Input[Union['JobSourceDbArgs', 'JobSourceDbArgsDict']]] = None,
            start_time: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'Job':
        """
        Get an existing Job resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] created_at: Create time. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        :param pulumi.Input[_builtins.str] description: Specifies the description of the job, which contain a
               maximum of 256 characters, and certain special characters (including !<>&'"\\\\) are not allowed.
        :param pulumi.Input[Union['JobDestinationDbArgs', 'JobDestinationDbArgsDict']] destination_db: Specifies the destination database configuration.
               The `db_info` object structure of the `destination_db` is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] destination_db_readnoly: Specifies the destination DB instance as read-only helps
               ensure the migration is successful. Once the migration is complete, the DB instance automatically changes to
               Read/Write. The default value is `true`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] direction: Specifies the direction of data flow.
               Changing this parameter will create a new resource. The options are as follows:
               + **up**: To the cloud. The destination database must be a database in the current cloud.
               + **down**: Out of the cloud. The source database must be a database in the current cloud.
               + **non-dbs**: self-built database.
        :param pulumi.Input[_builtins.str] engine_type: Specifies the migration engine type.
               Changing this parameter will create a new resource. The options are as follows:
               + **mysql**:  MySQL migration, MySQL synchronization use.
               + **mongodb**: Mongodb migration use.
               + **cloudDataGuard-mysql**: Disaster recovery use.
               + **gaussdbv5**: GaussDB (for openGauss) synchronization use.
               + **mysql-to-kafka**: Synchronization from MySQL to Kafka use.
               + **taurus-to-kafka**: Synchronization from GaussDB(for MySQL) to Kafka use.
               + **gaussdbv5ha-to-kafka**: Synchronization from GaussDB primary/standby to Kafka use.
               + **postgresql**: Synchronization from PostgreSQL to PostgreSQL use.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies the enterprise project id.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.int] expired_days: Specifies how many days after the task is abnormal, it will automatically
               end. The value ranges from 14 to 100. the default value is `14`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] force_destroy: Specifies whether to forcibly destroy the job even if it is running.
               The default value is `false`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JobLimitSpeedArgs', 'JobLimitSpeedArgsDict']]]] limit_speeds: Specifies the migration speed by setting a time period.
               The default is no speed limit. The maximum length is 3. Structure is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.bool] migrate_definer: Specifies whether to migrate the definers of all source database
               objects to the `user` of `destination_db`. The default value is `true`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] migration_type: Specifies migration type.
               Changing this parameter will create a new resource. The options are as follows:
               + **FULL_TRANS**: Full migration. Suitable for scenarios where services can be interrupted. It migrates all database
               objects and data, in a non-system database, to a destination database at a time.
               + **INCR_TRANS**: Incremental migration. Suitable for migration from an on-premises self-built database to a
               destination cloud database, or from one cloud database to another in a different region.
               + **FULL_INCR_TRANS**:  Full+Incremental migration. This allows to migrate data with minimal downtime. After a full
               migration initializes the destination database, an incremental migration parses logs to ensure data consistency
               between the source and destination databases.
               
               The default value is `FULL_INCR_TRANS`.
        :param pulumi.Input[_builtins.bool] multi_write: Specifies whether to enable multi write. It is mandatory when `type`
               is `cloudDataGuard`. When the disaster recovery type is dual-active disaster recovery, set `multi_write` to `true`,
               otherwise to `false`. The default value is `false`. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] name: Specifies the job name. The name consists of 4 to 50 characters, starting with
               a letter. Only letters, digits, underscores (\\_) and hyphens (-) are allowed.
        :param pulumi.Input[_builtins.str] net_type: Specifies the network type.
               Changing this parameter will create a new resource. The options are as follows:
               + **eip**: suitable for migration from an on-premises or other cloud database to a destination cloud database.
               An EIP will be automatically bound to the replication instance and released after the replication task is complete.
               + **vpc**: suitable for migration from one cloud database to another.
               + **vpn**: suitable for migration from an on-premises self-built database to a destination cloud database,
               or from one cloud database to another in a different region.
               
               The default value is `eip`.
        :param pulumi.Input[_builtins.str] private_ip: Private IP.
        :param pulumi.Input[_builtins.str] public_ip: Public IP.
        :param pulumi.Input[_builtins.str] region: The region in which to create the resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[Union['JobSourceDbArgs', 'JobSourceDbArgsDict']] source_db: Specifies the source database configuration.
               The `db_info` object structure of the `source_db` is documented below.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] start_time: Specifies the time to start the job. The time format
               is `yyyy-MM-dd HH:mm:ss`. Start immediately by default. Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] status: Status.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the DRS job.
               Changing this parameter will create a new resource.
        :param pulumi.Input[_builtins.str] type: Specifies the job type. Changing this parameter will create a new
               resource. The options are as follows:
               + **migration**: Online Migration.
               + **sync**: Data Synchronization.
               + **cloudDataGuard**: Disaster Recovery.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JobState.__new__(_JobState)

        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["destination_db"] = destination_db
        __props__.__dict__["destination_db_readnoly"] = destination_db_readnoly
        __props__.__dict__["direction"] = direction
        __props__.__dict__["engine_type"] = engine_type
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["expired_days"] = expired_days
        __props__.__dict__["force_destroy"] = force_destroy
        __props__.__dict__["limit_speeds"] = limit_speeds
        __props__.__dict__["migrate_definer"] = migrate_definer
        __props__.__dict__["migration_type"] = migration_type
        __props__.__dict__["multi_write"] = multi_write
        __props__.__dict__["name"] = name
        __props__.__dict__["net_type"] = net_type
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["source_db"] = source_db
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        return Job(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        Create time. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the description of the job, which contain a
        maximum of 256 characters, and certain special characters (including !<>&'"\\\\) are not allowed.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="destinationDb")
    def destination_db(self) -> pulumi.Output['outputs.JobDestinationDb']:
        """
        Specifies the destination database configuration.
        The `db_info` object structure of the `destination_db` is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "destination_db")

    @_builtins.property
    @pulumi.getter(name="destinationDbReadnoly")
    def destination_db_readnoly(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies the destination DB instance as read-only helps
        ensure the migration is successful. Once the migration is complete, the DB instance automatically changes to
        Read/Write. The default value is `true`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "destination_db_readnoly")

    @_builtins.property
    @pulumi.getter
    def direction(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the direction of data flow.
        Changing this parameter will create a new resource. The options are as follows:
        + **up**: To the cloud. The destination database must be a database in the current cloud.
        + **down**: Out of the cloud. The source database must be a database in the current cloud.
        + **non-dbs**: self-built database.
        """
        return pulumi.get(self, "direction")

    @_builtins.property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the migration engine type.
        Changing this parameter will create a new resource. The options are as follows:
        + **mysql**:  MySQL migration, MySQL synchronization use.
        + **mongodb**: Mongodb migration use.
        + **cloudDataGuard-mysql**: Disaster recovery use.
        + **gaussdbv5**: GaussDB (for openGauss) synchronization use.
        + **mysql-to-kafka**: Synchronization from MySQL to Kafka use.
        + **taurus-to-kafka**: Synchronization from GaussDB(for MySQL) to Kafka use.
        + **gaussdbv5ha-to-kafka**: Synchronization from GaussDB primary/standby to Kafka use.
        + **postgresql**: Synchronization from PostgreSQL to PostgreSQL use.
        """
        return pulumi.get(self, "engine_type")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the enterprise project id.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="expiredDays")
    def expired_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies how many days after the task is abnormal, it will automatically
        end. The value ranges from 14 to 100. the default value is `14`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "expired_days")

    @_builtins.property
    @pulumi.getter(name="forceDestroy")
    def force_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to forcibly destroy the job even if it is running.
        The default value is `false`.
        """
        return pulumi.get(self, "force_destroy")

    @_builtins.property
    @pulumi.getter(name="limitSpeeds")
    def limit_speeds(self) -> pulumi.Output[Optional[Sequence['outputs.JobLimitSpeed']]]:
        """
        Specifies the migration speed by setting a time period.
        The default is no speed limit. The maximum length is 3. Structure is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "limit_speeds")

    @_builtins.property
    @pulumi.getter(name="migrateDefiner")
    def migrate_definer(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to migrate the definers of all source database
        objects to the `user` of `destination_db`. The default value is `true`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "migrate_definer")

    @_builtins.property
    @pulumi.getter(name="migrationType")
    def migration_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies migration type.
        Changing this parameter will create a new resource. The options are as follows:
        + **FULL_TRANS**: Full migration. Suitable for scenarios where services can be interrupted. It migrates all database
        objects and data, in a non-system database, to a destination database at a time.
        + **INCR_TRANS**: Incremental migration. Suitable for migration from an on-premises self-built database to a
        destination cloud database, or from one cloud database to another in a different region.
        + **FULL_INCR_TRANS**:  Full+Incremental migration. This allows to migrate data with minimal downtime. After a full
        migration initializes the destination database, an incremental migration parses logs to ensure data consistency
        between the source and destination databases.

        The default value is `FULL_INCR_TRANS`.
        """
        return pulumi.get(self, "migration_type")

    @_builtins.property
    @pulumi.getter(name="multiWrite")
    def multi_write(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to enable multi write. It is mandatory when `type`
        is `cloudDataGuard`. When the disaster recovery type is dual-active disaster recovery, set `multi_write` to `true`,
        otherwise to `false`. The default value is `false`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "multi_write")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the job name. The name consists of 4 to 50 characters, starting with
        a letter. Only letters, digits, underscores (\\_) and hyphens (-) are allowed.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="netType")
    def net_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the network type.
        Changing this parameter will create a new resource. The options are as follows:
        + **eip**: suitable for migration from an on-premises or other cloud database to a destination cloud database.
        An EIP will be automatically bound to the replication instance and released after the replication task is complete.
        + **vpc**: suitable for migration from one cloud database to another.
        + **vpn**: suitable for migration from an on-premises self-built database to a destination cloud database,
        or from one cloud database to another in a different region.

        The default value is `eip`.
        """
        return pulumi.get(self, "net_type")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Private IP.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Public IP.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="sourceDb")
    def source_db(self) -> pulumi.Output['outputs.JobSourceDb']:
        """
        Specifies the source database configuration.
        The `db_info` object structure of the `source_db` is documented below.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "source_db")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the time to start the job. The time format
        is `yyyy-MM-dd HH:mm:ss`. Start immediately by default. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the key/value pairs to associate with the DRS job.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the job type. Changing this parameter will create a new
        resource. The options are as follows:
        + **migration**: Online Migration.
        + **sync**: Data Synchronization.
        + **cloudDataGuard**: Disaster Recovery.
        """
        return pulumi.get(self, "type")

