# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'ClusterElbArgs',
    'ClusterElbArgsDict',
    'ClusterEndpointArgs',
    'ClusterEndpointArgsDict',
    'ClusterMaintainWindowArgs',
    'ClusterMaintainWindowArgsDict',
    'ClusterPublicEndpointArgs',
    'ClusterPublicEndpointArgsDict',
    'ClusterPublicIpArgs',
    'ClusterPublicIpArgsDict',
    'ClusterVolumeArgs',
    'ClusterVolumeArgsDict',
]

MYPY = False

if not MYPY:
    class ClusterElbArgsDict(TypedDict):
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The cluster ID
        """
        name: NotRequired[pulumi.Input[_builtins.str]]
        """
        Cluster name, which must be unique and contains 4 to 64 characters, which
        consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
        Changing this creates a new cluster resource.
        """
        private_endpoint: NotRequired[pulumi.Input[_builtins.str]]
        """
        The private endpoint of the ELB load balancer.
        """
        private_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        List of private network IP address.
        """
        private_ip_v6: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IPv6 address of the ELB load balancer.
        """
        public_ip: NotRequired[pulumi.Input[_builtins.str]]
        """
        A nested object resource Structure is documented below.
        Changing this creates a new cluster resource.
        """
        vpc_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        VPC ID, which is used for configuring cluster network.
        Changing this creates a new cluster resource.
        """
elif False:
    ClusterElbArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterElbArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 private_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 private_ip_v6: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] id: The cluster ID
        :param pulumi.Input[_builtins.str] name: Cluster name, which must be unique and contains 4 to 64 characters, which
               consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] private_endpoint: The private endpoint of the ELB load balancer.
        :param pulumi.Input[_builtins.str] private_ip: List of private network IP address.
        :param pulumi.Input[_builtins.str] private_ip_v6: The IPv6 address of the ELB load balancer.
        :param pulumi.Input[_builtins.str] public_ip: A nested object resource Structure is documented below.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] vpc_id: VPC ID, which is used for configuring cluster network.
               Changing this creates a new cluster resource.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if private_ip_v6 is not None:
            pulumi.set(__self__, "private_ip_v6", private_ip_v6)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The cluster ID
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster name, which must be unique and contains 4 to 64 characters, which
        consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The private endpoint of the ELB load balancer.
        """
        return pulumi.get(self, "private_endpoint")

    @private_endpoint.setter
    def private_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        List of private network IP address.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip", value)

    @_builtins.property
    @pulumi.getter(name="privateIpV6")
    def private_ip_v6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IPv6 address of the ELB load balancer.
        """
        return pulumi.get(self, "private_ip_v6")

    @private_ip_v6.setter
    def private_ip_v6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_ip_v6", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A nested object resource Structure is documented below.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC ID, which is used for configuring cluster network.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


if not MYPY:
    class ClusterEndpointArgsDict(TypedDict):
        connect_info: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Optional, String) Private network connection information.
        """
        jdbc_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Optional, String)
        JDBC URL. The following is the default format:
        jdbc:postgresql://< public_connect_info>/<YOUR_DATABASE_NAME>
        """
elif False:
    ClusterEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterEndpointArgs:
    def __init__(__self__, *,
                 connect_info: Optional[pulumi.Input[_builtins.str]] = None,
                 jdbc_url: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] connect_info: (Optional, String) Private network connection information.
        :param pulumi.Input[_builtins.str] jdbc_url: (Optional, String)
               JDBC URL. The following is the default format:
               jdbc:postgresql://< public_connect_info>/<YOUR_DATABASE_NAME>
        """
        if connect_info is not None:
            pulumi.set(__self__, "connect_info", connect_info)
        if jdbc_url is not None:
            pulumi.set(__self__, "jdbc_url", jdbc_url)

    @_builtins.property
    @pulumi.getter(name="connectInfo")
    def connect_info(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional, String) Private network connection information.
        """
        return pulumi.get(self, "connect_info")

    @connect_info.setter
    def connect_info(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connect_info", value)

    @_builtins.property
    @pulumi.getter(name="jdbcUrl")
    def jdbc_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional, String)
        JDBC URL. The following is the default format:
        jdbc:postgresql://< public_connect_info>/<YOUR_DATABASE_NAME>
        """
        return pulumi.get(self, "jdbc_url")

    @jdbc_url.setter
    def jdbc_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jdbc_url", value)


if not MYPY:
    class ClusterMaintainWindowArgsDict(TypedDict):
        day: NotRequired[pulumi.Input[_builtins.str]]
        """
        Maintenance time in each week in the unit of day.
        """
        end_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        Maintenance end time in HH:mm format. The time zone is GMT+0.
        """
        start_time: NotRequired[pulumi.Input[_builtins.str]]
        """
        Maintenance start time in HH:mm format. The time zone is GMT+0.
        """
elif False:
    ClusterMaintainWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterMaintainWindowArgs:
    def __init__(__self__, *,
                 day: Optional[pulumi.Input[_builtins.str]] = None,
                 end_time: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] day: Maintenance time in each week in the unit of day.
        :param pulumi.Input[_builtins.str] end_time: Maintenance end time in HH:mm format. The time zone is GMT+0.
        :param pulumi.Input[_builtins.str] start_time: Maintenance start time in HH:mm format. The time zone is GMT+0.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter
    def day(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maintenance time in each week in the unit of day.
        """
        return pulumi.get(self, "day")

    @day.setter
    def day(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "day", value)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maintenance end time in HH:mm format. The time zone is GMT+0.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_time", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Maintenance start time in HH:mm format. The time zone is GMT+0.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)


if not MYPY:
    class ClusterPublicEndpointArgsDict(TypedDict):
        jdbc_url: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Optional, String)
        JDBC URL. The following is the default format:
        jdbc:postgresql://< public_connect_info>/<YOUR_DATABASE_NAME>
        """
        public_connect_info: NotRequired[pulumi.Input[_builtins.str]]
        """
        (Optional, String)
        Public network connection information.
        """
elif False:
    ClusterPublicEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterPublicEndpointArgs:
    def __init__(__self__, *,
                 jdbc_url: Optional[pulumi.Input[_builtins.str]] = None,
                 public_connect_info: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] jdbc_url: (Optional, String)
               JDBC URL. The following is the default format:
               jdbc:postgresql://< public_connect_info>/<YOUR_DATABASE_NAME>
        :param pulumi.Input[_builtins.str] public_connect_info: (Optional, String)
               Public network connection information.
        """
        if jdbc_url is not None:
            pulumi.set(__self__, "jdbc_url", jdbc_url)
        if public_connect_info is not None:
            pulumi.set(__self__, "public_connect_info", public_connect_info)

    @_builtins.property
    @pulumi.getter(name="jdbcUrl")
    def jdbc_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional, String)
        JDBC URL. The following is the default format:
        jdbc:postgresql://< public_connect_info>/<YOUR_DATABASE_NAME>
        """
        return pulumi.get(self, "jdbc_url")

    @jdbc_url.setter
    def jdbc_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "jdbc_url", value)

    @_builtins.property
    @pulumi.getter(name="publicConnectInfo")
    def public_connect_info(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Optional, String)
        Public network connection information.
        """
        return pulumi.get(self, "public_connect_info")

    @public_connect_info.setter
    def public_connect_info(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_connect_info", value)


if not MYPY:
    class ClusterPublicIpArgsDict(TypedDict):
        eip_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        EIP ID.
        Changing this creates a new cluster resource.
        """
        public_bind_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        Binding type of an EIP. The value can be either of the following:
        **auto_assign**, **not_use**, **bind_existing**. The default value is **not_use**.
        Changing this creates a new cluster resource.
        """
elif False:
    ClusterPublicIpArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterPublicIpArgs:
    def __init__(__self__, *,
                 eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_bind_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] eip_id: EIP ID.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] public_bind_type: Binding type of an EIP. The value can be either of the following:
               **auto_assign**, **not_use**, **bind_existing**. The default value is **not_use**.
               Changing this creates a new cluster resource.
        """
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if public_bind_type is not None:
            pulumi.set(__self__, "public_bind_type", public_bind_type)

    @_builtins.property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        EIP ID.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eip_id", value)

    @_builtins.property
    @pulumi.getter(name="publicBindType")
    def public_bind_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Binding type of an EIP. The value can be either of the following:
        **auto_assign**, **not_use**, **bind_existing**. The default value is **not_use**.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "public_bind_type")

    @public_bind_type.setter
    def public_bind_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_bind_type", value)


if not MYPY:
    class ClusterVolumeArgsDict(TypedDict):
        capacity: NotRequired[pulumi.Input[_builtins.str]]
        """
        The capacity size, in GB.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The volume type.
        """
elif False:
    ClusterVolumeArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class ClusterVolumeArgs:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] capacity: The capacity size, in GB.
        :param pulumi.Input[_builtins.str] type: The volume type.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The capacity size, in GB.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The volume type.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


