# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[_builtins.str],
                 network_id: pulumi.Input[_builtins.str],
                 node_type: pulumi.Input[_builtins.str],
                 number_of_node: pulumi.Input[_builtins.int],
                 security_group_id: pulumi.Input[_builtins.str],
                 user_name: pulumi.Input[_builtins.str],
                 user_pwd: pulumi.Input[_builtins.str],
                 vpc_id: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dss_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 elb_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 keep_last_manual_snapshot: Optional[pulumi.Input[_builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_cluster_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 lts_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_cn: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 public_ip: Optional[pulumi.Input['ClusterPublicIpArgs']] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 volume: Optional[pulumi.Input['ClusterVolumeArgs']] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[_builtins.str] availability_zone: AZ in a cluster.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] network_id: Network ID, which is used for configuring cluster network.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] node_type: Node type.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.int] number_of_node: Number of nodes in a cluster. The value ranges from 3 to 32. When expanding,
               add at least 3 nodes.
        :param pulumi.Input[_builtins.str] security_group_id: ID of a security group. The ID is used for configuring cluster
               network.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] user_name: Administrator username for logging in to a data warehouse cluster The
               administrator username must:  Consist of lowercase letters, digits, or underscores. Start with a lowercase letter or
               an underscore. Contain 1 to 63 characters. Cannot be a keyword of the DWS database.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] user_pwd: Administrator password for logging in to a data warehouse cluster A password
               must conform to the following rules:  Contains 8 to 32 characters. Cannot be the same as the username or the username
               written in reverse order. Contains three types of the following:
               Lowercase letters Uppercase letters Digits Special characters
               ~!@#%^&*()-_=+|[{}];:,<.>/?
        :param pulumi.Input[_builtins.str] vpc_id: VPC ID, which is used for configuring cluster network.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] description: The description of the cluster.
        :param pulumi.Input[_builtins.str] dss_pool_id: Dedicated storage pool ID.
        :param pulumi.Input[_builtins.str] elb_id: The ID of the ELB load balancer.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the dws cluster,
               Value 0 indicates the default enterprise project.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.bool] force_backup: Whether to automatically execute snapshot when shrinking the number of nodes.
        :param pulumi.Input[_builtins.int] keep_last_manual_snapshot: The number of latest manual snapshots that need to be retained when deleting the cluster.
        :param pulumi.Input[_builtins.str] kms_key_id: The KMS key ID.
        :param pulumi.Input[_builtins.bool] logical_cluster_enable: Whether to enable logical cluster.
        :param pulumi.Input[_builtins.bool] lts_enable: Whether to enable LTS.
        :param pulumi.Input[_builtins.str] name: Cluster name, which must be unique and contains 4 to 64 characters, which
               consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.int] number_of_cn: The number of CN. If you use a large-scale cluster, deploy multiple CNs.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.int] port: Service port of a cluster (8000 to 10000). The default value is 8000.
               Changing this creates a new cluster resource.
        :param pulumi.Input['ClusterPublicIpArgs'] public_ip: A nested object resource Structure is documented below.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this creates a new cluster resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the cluster.
        :param pulumi.Input[_builtins.str] version: Data warehouse version.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "network_id", network_id)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "number_of_node", number_of_node)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "user_name", user_name)
        pulumi.set(__self__, "user_pwd", user_pwd)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dss_pool_id is not None:
            pulumi.set(__self__, "dss_pool_id", dss_pool_id)
        if elb_id is not None:
            pulumi.set(__self__, "elb_id", elb_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if force_backup is not None:
            pulumi.set(__self__, "force_backup", force_backup)
        if keep_last_manual_snapshot is not None:
            pulumi.set(__self__, "keep_last_manual_snapshot", keep_last_manual_snapshot)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if logical_cluster_enable is not None:
            pulumi.set(__self__, "logical_cluster_enable", logical_cluster_enable)
        if lts_enable is not None:
            pulumi.set(__self__, "lts_enable", lts_enable)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_cn is not None:
            pulumi.set(__self__, "number_of_cn", number_of_cn)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if volume is not None:
            pulumi.set(__self__, "volume", volume)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[_builtins.str]:
        """
        AZ in a cluster.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[_builtins.str]:
        """
        Network ID, which is used for configuring cluster network.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Input[_builtins.str]:
        """
        Node type.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="numberOfNode")
    def number_of_node(self) -> pulumi.Input[_builtins.int]:
        """
        Number of nodes in a cluster. The value ranges from 3 to 32. When expanding,
        add at least 3 nodes.
        """
        return pulumi.get(self, "number_of_node")

    @number_of_node.setter
    def number_of_node(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "number_of_node", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[_builtins.str]:
        """
        ID of a security group. The ID is used for configuring cluster
        network.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[_builtins.str]:
        """
        Administrator username for logging in to a data warehouse cluster The
        administrator username must:  Consist of lowercase letters, digits, or underscores. Start with a lowercase letter or
        an underscore. Contain 1 to 63 characters. Cannot be a keyword of the DWS database.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter(name="userPwd")
    def user_pwd(self) -> pulumi.Input[_builtins.str]:
        """
        Administrator password for logging in to a data warehouse cluster A password
        must conform to the following rules:  Contains 8 to 32 characters. Cannot be the same as the username or the username
        written in reverse order. Contains three types of the following:
        Lowercase letters Uppercase letters Digits Special characters
        ~!@#%^&*()-_=+|[{}];:,<.>/?
        """
        return pulumi.get(self, "user_pwd")

    @user_pwd.setter
    def user_pwd(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "user_pwd", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[_builtins.str]:
        """
        VPC ID, which is used for configuring cluster network.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vpc_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dssPoolId")
    def dss_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dedicated storage pool ID.
        """
        return pulumi.get(self, "dss_pool_id")

    @dss_pool_id.setter
    def dss_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dss_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="elbId")
    def elb_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the ELB load balancer.
        """
        return pulumi.get(self, "elb_id")

    @elb_id.setter
    def elb_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "elb_id", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the dws cluster,
        Value 0 indicates the default enterprise project.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="forceBackup")
    def force_backup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically execute snapshot when shrinking the number of nodes.
        """
        return pulumi.get(self, "force_backup")

    @force_backup.setter
    def force_backup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_backup", value)

    @_builtins.property
    @pulumi.getter(name="keepLastManualSnapshot")
    def keep_last_manual_snapshot(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of latest manual snapshots that need to be retained when deleting the cluster.
        """
        return pulumi.get(self, "keep_last_manual_snapshot")

    @keep_last_manual_snapshot.setter
    def keep_last_manual_snapshot(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "keep_last_manual_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The KMS key ID.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="logicalClusterEnable")
    def logical_cluster_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable logical cluster.
        """
        return pulumi.get(self, "logical_cluster_enable")

    @logical_cluster_enable.setter
    def logical_cluster_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "logical_cluster_enable", value)

    @_builtins.property
    @pulumi.getter(name="ltsEnable")
    def lts_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable LTS.
        """
        return pulumi.get(self, "lts_enable")

    @lts_enable.setter
    def lts_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lts_enable", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster name, which must be unique and contains 4 to 64 characters, which
        consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numberOfCn")
    def number_of_cn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of CN. If you use a large-scale cluster, deploy multiple CNs.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "number_of_cn")

    @number_of_cn.setter
    def number_of_cn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_cn", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Service port of a cluster (8000 to 10000). The default value is 8000.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input['ClusterPublicIpArgs']]:
        """
        A nested object resource Structure is documented below.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input['ClusterPublicIpArgs']]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the cluster resource. If omitted, the
        provider-level region will be used. Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data warehouse version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def volume(self) -> Optional[pulumi.Input['ClusterVolumeArgs']]:
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: Optional[pulumi.Input['ClusterVolumeArgs']]):
        pulumi.set(self, "volume", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 created: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dss_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 elb_id: Optional[pulumi.Input[_builtins.str]] = None,
                 elbs: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterElbArgs']]]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterEndpointArgs']]]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 keep_last_manual_snapshot: Optional[pulumi.Input[_builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_cluster_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 lts_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 maintain_windows: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintainWindowArgs']]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_cn: Optional[pulumi.Input[_builtins.int]] = None,
                 number_of_node: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 public_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPublicEndpointArgs']]]] = None,
                 public_ip: Optional[pulumi.Input['ClusterPublicIpArgs']] = None,
                 recent_event: Optional[pulumi.Input[_builtins.int]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 sub_status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 task_status: Optional[pulumi.Input[_builtins.str]] = None,
                 updated: Optional[pulumi.Input[_builtins.str]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pwd: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 volume: Optional[pulumi.Input['ClusterVolumeArgs']] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[_builtins.str] availability_zone: AZ in a cluster.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] created: Cluster creation time. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        :param pulumi.Input[_builtins.str] description: The description of the cluster.
        :param pulumi.Input[_builtins.str] dss_pool_id: Dedicated storage pool ID.
        :param pulumi.Input[_builtins.str] elb_id: The ID of the ELB load balancer.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterElbArgs']]] elbs: The ELB information bound to the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterEndpointArgs']]] endpoints: View the private network connection information about the cluster. Structure is documented below.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the dws cluster,
               Value 0 indicates the default enterprise project.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.bool] force_backup: Whether to automatically execute snapshot when shrinking the number of nodes.
        :param pulumi.Input[_builtins.int] keep_last_manual_snapshot: The number of latest manual snapshots that need to be retained when deleting the cluster.
        :param pulumi.Input[_builtins.str] kms_key_id: The KMS key ID.
        :param pulumi.Input[_builtins.bool] logical_cluster_enable: Whether to enable logical cluster.
        :param pulumi.Input[_builtins.bool] lts_enable: Whether to enable LTS.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterMaintainWindowArgs']]] maintain_windows: Cluster maintenance window.
        :param pulumi.Input[_builtins.str] name: Cluster name, which must be unique and contains 4 to 64 characters, which
               consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] network_id: Network ID, which is used for configuring cluster network.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] node_type: Node type.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.int] number_of_cn: The number of CN. If you use a large-scale cluster, deploy multiple CNs.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.int] number_of_node: Number of nodes in a cluster. The value ranges from 3 to 32. When expanding,
               add at least 3 nodes.
        :param pulumi.Input[_builtins.int] port: Service port of a cluster (8000 to 10000). The default value is 8000.
               Changing this creates a new cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ips: List of private network IP address.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterPublicEndpointArgs']]] public_endpoints: Public network connection information about the cluster. If the value is not specified, the
               public network connection information is not used by default Structure is documented below.
        :param pulumi.Input['ClusterPublicIpArgs'] public_ip: A nested object resource Structure is documented below.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.int] recent_event: The recent event number.
        :param pulumi.Input[_builtins.str] region: The region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] security_group_id: ID of a security group. The ID is used for configuring cluster
               network.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] status: Cluster status, which can be one of the following:  CREATING AVAILABLE UNAVAILABLE CREATION FAILED.
        :param pulumi.Input[_builtins.str] sub_status: Sub-status of clusters in the AVAILABLE state. The value can be one of the following:  NORMAL READONLY
               REDISTRIBUTING REDISTRIBUTION-FAILURE UNBALANCED UNBALANCED | READONLY DEGRADED DEGRADED | READONLY DEGRADED |
               UNBALANCED UNBALANCED | REDISTRIBUTING UNBALANCED | REDISTRIBUTION-FAILURE READONLY | REDISTRIBUTION-FAILURE
               UNBALANCED | READONLY | REDISTRIBUTION-FAILURE DEGRADED | REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED |
               REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED | READONLY | REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED | READONLY
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the cluster.
        :param pulumi.Input[_builtins.str] task_status: Cluster management task. The value can be one of the following:
               RESTORING SNAPSHOTTING GROWING REBOOTING SETTING_CONFIGURATION CONFIGURING_EXT_DATASOURCE DELETING_EXT_DATASOURCE
               REBOOT_FAILURE RESIZE_FAILURE
        :param pulumi.Input[_builtins.str] updated: Last modification time of a cluster. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        :param pulumi.Input[_builtins.str] user_name: Administrator username for logging in to a data warehouse cluster The
               administrator username must:  Consist of lowercase letters, digits, or underscores. Start with a lowercase letter or
               an underscore. Contain 1 to 63 characters. Cannot be a keyword of the DWS database.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] user_pwd: Administrator password for logging in to a data warehouse cluster A password
               must conform to the following rules:  Contains 8 to 32 characters. Cannot be the same as the username or the username
               written in reverse order. Contains three types of the following:
               Lowercase letters Uppercase letters Digits Special characters
               ~!@#%^&*()-_=+|[{}];:,<.>/?
        :param pulumi.Input[_builtins.str] version: Data warehouse version.
        :param pulumi.Input[_builtins.str] vpc_id: VPC ID, which is used for configuring cluster network.
               Changing this creates a new cluster resource.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dss_pool_id is not None:
            pulumi.set(__self__, "dss_pool_id", dss_pool_id)
        if elb_id is not None:
            pulumi.set(__self__, "elb_id", elb_id)
        if elbs is not None:
            pulumi.set(__self__, "elbs", elbs)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if force_backup is not None:
            pulumi.set(__self__, "force_backup", force_backup)
        if keep_last_manual_snapshot is not None:
            pulumi.set(__self__, "keep_last_manual_snapshot", keep_last_manual_snapshot)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if logical_cluster_enable is not None:
            pulumi.set(__self__, "logical_cluster_enable", logical_cluster_enable)
        if lts_enable is not None:
            pulumi.set(__self__, "lts_enable", lts_enable)
        if maintain_windows is not None:
            pulumi.set(__self__, "maintain_windows", maintain_windows)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if number_of_cn is not None:
            pulumi.set(__self__, "number_of_cn", number_of_cn)
        if number_of_node is not None:
            pulumi.set(__self__, "number_of_node", number_of_node)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if private_ips is not None:
            pulumi.set(__self__, "private_ips", private_ips)
        if public_endpoints is not None:
            pulumi.set(__self__, "public_endpoints", public_endpoints)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if recent_event is not None:
            pulumi.set(__self__, "recent_event", recent_event)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if sub_status is not None:
            pulumi.set(__self__, "sub_status", sub_status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if task_status is not None:
            pulumi.set(__self__, "task_status", task_status)
        if updated is not None:
            pulumi.set(__self__, "updated", updated)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if user_pwd is not None:
            pulumi.set(__self__, "user_pwd", user_pwd)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if volume is not None:
            pulumi.set(__self__, "volume", volume)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        AZ in a cluster.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster creation time. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="dssPoolId")
    def dss_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Dedicated storage pool ID.
        """
        return pulumi.get(self, "dss_pool_id")

    @dss_pool_id.setter
    def dss_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dss_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="elbId")
    def elb_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the ELB load balancer.
        """
        return pulumi.get(self, "elb_id")

    @elb_id.setter
    def elb_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "elb_id", value)

    @_builtins.property
    @pulumi.getter
    def elbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterElbArgs']]]]:
        """
        The ELB information bound to the cluster.
        """
        return pulumi.get(self, "elbs")

    @elbs.setter
    def elbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterElbArgs']]]]):
        pulumi.set(self, "elbs", value)

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterEndpointArgs']]]]:
        """
        View the private network connection information about the cluster. Structure is documented below.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The enterprise project id of the dws cluster,
        Value 0 indicates the default enterprise project.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="forceBackup")
    def force_backup(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to automatically execute snapshot when shrinking the number of nodes.
        """
        return pulumi.get(self, "force_backup")

    @force_backup.setter
    def force_backup(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_backup", value)

    @_builtins.property
    @pulumi.getter(name="keepLastManualSnapshot")
    def keep_last_manual_snapshot(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of latest manual snapshots that need to be retained when deleting the cluster.
        """
        return pulumi.get(self, "keep_last_manual_snapshot")

    @keep_last_manual_snapshot.setter
    def keep_last_manual_snapshot(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "keep_last_manual_snapshot", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The KMS key ID.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="logicalClusterEnable")
    def logical_cluster_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable logical cluster.
        """
        return pulumi.get(self, "logical_cluster_enable")

    @logical_cluster_enable.setter
    def logical_cluster_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "logical_cluster_enable", value)

    @_builtins.property
    @pulumi.getter(name="ltsEnable")
    def lts_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable LTS.
        """
        return pulumi.get(self, "lts_enable")

    @lts_enable.setter
    def lts_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lts_enable", value)

    @_builtins.property
    @pulumi.getter(name="maintainWindows")
    def maintain_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintainWindowArgs']]]]:
        """
        Cluster maintenance window.
        """
        return pulumi.get(self, "maintain_windows")

    @maintain_windows.setter
    def maintain_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterMaintainWindowArgs']]]]):
        pulumi.set(self, "maintain_windows", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster name, which must be unique and contains 4 to 64 characters, which
        consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Network ID, which is used for configuring cluster network.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Node type.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "node_type")

    @node_type.setter
    def node_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_type", value)

    @_builtins.property
    @pulumi.getter(name="numberOfCn")
    def number_of_cn(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of CN. If you use a large-scale cluster, deploy multiple CNs.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "number_of_cn")

    @number_of_cn.setter
    def number_of_cn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_cn", value)

    @_builtins.property
    @pulumi.getter(name="numberOfNode")
    def number_of_node(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of nodes in a cluster. The value ranges from 3 to 32. When expanding,
        add at least 3 nodes.
        """
        return pulumi.get(self, "number_of_node")

    @number_of_node.setter
    def number_of_node(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_node", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Service port of a cluster (8000 to 10000). The default value is 8000.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of private network IP address.
        """
        return pulumi.get(self, "private_ips")

    @private_ips.setter
    def private_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "private_ips", value)

    @_builtins.property
    @pulumi.getter(name="publicEndpoints")
    def public_endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPublicEndpointArgs']]]]:
        """
        Public network connection information about the cluster. If the value is not specified, the
        public network connection information is not used by default Structure is documented below.
        """
        return pulumi.get(self, "public_endpoints")

    @public_endpoints.setter
    def public_endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterPublicEndpointArgs']]]]):
        pulumi.set(self, "public_endpoints", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input['ClusterPublicIpArgs']]:
        """
        A nested object resource Structure is documented below.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input['ClusterPublicIpArgs']]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter(name="recentEvent")
    def recent_event(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The recent event number.
        """
        return pulumi.get(self, "recent_event")

    @recent_event.setter
    def recent_event(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "recent_event", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The region in which to create the cluster resource. If omitted, the
        provider-level region will be used. Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of a security group. The ID is used for configuring cluster
        network.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_group_id", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster status, which can be one of the following:  CREATING AVAILABLE UNAVAILABLE CREATION FAILED.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="subStatus")
    def sub_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Sub-status of clusters in the AVAILABLE state. The value can be one of the following:  NORMAL READONLY
        REDISTRIBUTING REDISTRIBUTION-FAILURE UNBALANCED UNBALANCED | READONLY DEGRADED DEGRADED | READONLY DEGRADED |
        UNBALANCED UNBALANCED | REDISTRIBUTING UNBALANCED | REDISTRIBUTION-FAILURE READONLY | REDISTRIBUTION-FAILURE
        UNBALANCED | READONLY | REDISTRIBUTION-FAILURE DEGRADED | REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED |
        REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED | READONLY | REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED | READONLY
        """
        return pulumi.get(self, "sub_status")

    @sub_status.setter
    def sub_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sub_status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The key/value pairs to associate with the cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="taskStatus")
    def task_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Cluster management task. The value can be one of the following:
        RESTORING SNAPSHOTTING GROWING REBOOTING SETTING_CONFIGURATION CONFIGURING_EXT_DATASOURCE DELETING_EXT_DATASOURCE
        REBOOT_FAILURE RESIZE_FAILURE
        """
        return pulumi.get(self, "task_status")

    @task_status.setter
    def task_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "task_status", value)

    @_builtins.property
    @pulumi.getter
    def updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Last modification time of a cluster. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        """
        return pulumi.get(self, "updated")

    @updated.setter
    def updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated", value)

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Administrator username for logging in to a data warehouse cluster The
        administrator username must:  Consist of lowercase letters, digits, or underscores. Start with a lowercase letter or
        an underscore. Contain 1 to 63 characters. Cannot be a keyword of the DWS database.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_name", value)

    @_builtins.property
    @pulumi.getter(name="userPwd")
    def user_pwd(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Administrator password for logging in to a data warehouse cluster A password
        must conform to the following rules:  Contains 8 to 32 characters. Cannot be the same as the username or the username
        written in reverse order. Contains three types of the following:
        Lowercase letters Uppercase letters Digits Special characters
        ~!@#%^&*()-_=+|[{}];:,<.>/?
        """
        return pulumi.get(self, "user_pwd")

    @user_pwd.setter
    def user_pwd(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_pwd", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Data warehouse version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def volume(self) -> Optional[pulumi.Input['ClusterVolumeArgs']]:
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: Optional[pulumi.Input['ClusterVolumeArgs']]):
        pulumi.set(self, "volume", value)

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        VPC ID, which is used for configuring cluster network.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vpc_id", value)


@pulumi.type_token("sbercloud:Dws/cluster:Cluster")
class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dss_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 elb_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 keep_last_manual_snapshot: Optional[pulumi.Input[_builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_cluster_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 lts_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_cn: Optional[pulumi.Input[_builtins.int]] = None,
                 number_of_node: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 public_ip: Optional[pulumi.Input[Union['ClusterPublicIpArgs', 'ClusterPublicIpArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pwd: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 volume: Optional[pulumi.Input[Union['ClusterVolumeArgs', 'ClusterVolumeArgsDict']]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a cluster in the Data Warehouse Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        availability_zone = config.require_object("availabilityZone")
        dws_cluster_name = config.require_object("dwsClusterName")
        user_name = config.require_object("userName")
        user_pwd = config.require_object("userPwd")
        vpc_id = config.require_object("vpcId")
        network_id = config.require_object("networkId")
        secgroup = sbercloud.vpc.Secgroup("secgroup",
            name="sg_dws",
            description="terraform security group")
        cluster = sbercloud.dws.Cluster("cluster",
            name=dws_cluster_name,
            node_type="dws.m3.xlarge",
            number_of_node=3,
            availability_zone=availability_zone,
            user_name=user_name,
            user_pwd=user_pwd,
            vpc_id=vpc_id,
            network_id=network_id,
            security_group_id=secgroup.id)
        ```

        ## Import

        Cluster can be imported using the following format:

        ```sh
        $ pulumi import sbercloud:Dws/cluster:Cluster test 47ad727e-9dcc-4833-bde0-bb298607c719
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `user_pwd`, `number_of_cn`.

        It is generally recommended running `pulumi preview` after importing a cluster.

        You can then decide if changes should be applied to the cluster, or the resource definition

        should be updated to align with the cluster. Also you can ignore changes as below.

        resource "sbercloud_dws_cluster" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              user_pwd, number_of_cn,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_zone: AZ in a cluster.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] description: The description of the cluster.
        :param pulumi.Input[_builtins.str] dss_pool_id: Dedicated storage pool ID.
        :param pulumi.Input[_builtins.str] elb_id: The ID of the ELB load balancer.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the dws cluster,
               Value 0 indicates the default enterprise project.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.bool] force_backup: Whether to automatically execute snapshot when shrinking the number of nodes.
        :param pulumi.Input[_builtins.int] keep_last_manual_snapshot: The number of latest manual snapshots that need to be retained when deleting the cluster.
        :param pulumi.Input[_builtins.str] kms_key_id: The KMS key ID.
        :param pulumi.Input[_builtins.bool] logical_cluster_enable: Whether to enable logical cluster.
        :param pulumi.Input[_builtins.bool] lts_enable: Whether to enable LTS.
        :param pulumi.Input[_builtins.str] name: Cluster name, which must be unique and contains 4 to 64 characters, which
               consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] network_id: Network ID, which is used for configuring cluster network.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] node_type: Node type.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.int] number_of_cn: The number of CN. If you use a large-scale cluster, deploy multiple CNs.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.int] number_of_node: Number of nodes in a cluster. The value ranges from 3 to 32. When expanding,
               add at least 3 nodes.
        :param pulumi.Input[_builtins.int] port: Service port of a cluster (8000 to 10000). The default value is 8000.
               Changing this creates a new cluster resource.
        :param pulumi.Input[Union['ClusterPublicIpArgs', 'ClusterPublicIpArgsDict']] public_ip: A nested object resource Structure is documented below.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] region: The region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] security_group_id: ID of a security group. The ID is used for configuring cluster
               network.
               Changing this creates a new cluster resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the cluster.
        :param pulumi.Input[_builtins.str] user_name: Administrator username for logging in to a data warehouse cluster The
               administrator username must:  Consist of lowercase letters, digits, or underscores. Start with a lowercase letter or
               an underscore. Contain 1 to 63 characters. Cannot be a keyword of the DWS database.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] user_pwd: Administrator password for logging in to a data warehouse cluster A password
               must conform to the following rules:  Contains 8 to 32 characters. Cannot be the same as the username or the username
               written in reverse order. Contains three types of the following:
               Lowercase letters Uppercase letters Digits Special characters
               ~!@#%^&*()-_=+|[{}];:,<.>/?
        :param pulumi.Input[_builtins.str] version: Data warehouse version.
        :param pulumi.Input[_builtins.str] vpc_id: VPC ID, which is used for configuring cluster network.
               Changing this creates a new cluster resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a cluster in the Data Warehouse Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        availability_zone = config.require_object("availabilityZone")
        dws_cluster_name = config.require_object("dwsClusterName")
        user_name = config.require_object("userName")
        user_pwd = config.require_object("userPwd")
        vpc_id = config.require_object("vpcId")
        network_id = config.require_object("networkId")
        secgroup = sbercloud.vpc.Secgroup("secgroup",
            name="sg_dws",
            description="terraform security group")
        cluster = sbercloud.dws.Cluster("cluster",
            name=dws_cluster_name,
            node_type="dws.m3.xlarge",
            number_of_node=3,
            availability_zone=availability_zone,
            user_name=user_name,
            user_pwd=user_pwd,
            vpc_id=vpc_id,
            network_id=network_id,
            security_group_id=secgroup.id)
        ```

        ## Import

        Cluster can be imported using the following format:

        ```sh
        $ pulumi import sbercloud:Dws/cluster:Cluster test 47ad727e-9dcc-4833-bde0-bb298607c719
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason. The missing attributes include: `user_pwd`, `number_of_cn`.

        It is generally recommended running `pulumi preview` after importing a cluster.

        You can then decide if changes should be applied to the cluster, or the resource definition

        should be updated to align with the cluster. Also you can ignore changes as below.

        resource "sbercloud_dws_cluster" "test" {

            ...

          lifecycle {

            ignore_changes = [
            
              user_pwd, number_of_cn,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 dss_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 elb_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 force_backup: Optional[pulumi.Input[_builtins.bool]] = None,
                 keep_last_manual_snapshot: Optional[pulumi.Input[_builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_cluster_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 lts_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 node_type: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_cn: Optional[pulumi.Input[_builtins.int]] = None,
                 number_of_node: Optional[pulumi.Input[_builtins.int]] = None,
                 port: Optional[pulumi.Input[_builtins.int]] = None,
                 public_ip: Optional[pulumi.Input[Union['ClusterPublicIpArgs', 'ClusterPublicIpArgsDict']]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_name: Optional[pulumi.Input[_builtins.str]] = None,
                 user_pwd: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 volume: Optional[pulumi.Input[Union['ClusterVolumeArgs', 'ClusterVolumeArgsDict']]] = None,
                 vpc_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["description"] = description
            __props__.__dict__["dss_pool_id"] = dss_pool_id
            __props__.__dict__["elb_id"] = elb_id
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["force_backup"] = force_backup
            __props__.__dict__["keep_last_manual_snapshot"] = keep_last_manual_snapshot
            __props__.__dict__["kms_key_id"] = kms_key_id
            __props__.__dict__["logical_cluster_enable"] = logical_cluster_enable
            __props__.__dict__["lts_enable"] = lts_enable
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            if node_type is None and not opts.urn:
                raise TypeError("Missing required property 'node_type'")
            __props__.__dict__["node_type"] = node_type
            __props__.__dict__["number_of_cn"] = number_of_cn
            if number_of_node is None and not opts.urn:
                raise TypeError("Missing required property 'number_of_node'")
            __props__.__dict__["number_of_node"] = number_of_node
            __props__.__dict__["port"] = port
            __props__.__dict__["public_ip"] = public_ip
            __props__.__dict__["region"] = region
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["tags"] = tags
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            if user_pwd is None and not opts.urn:
                raise TypeError("Missing required property 'user_pwd'")
            __props__.__dict__["user_pwd"] = None if user_pwd is None else pulumi.Output.secret(user_pwd)
            __props__.__dict__["version"] = version
            __props__.__dict__["volume"] = volume
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["created"] = None
            __props__.__dict__["elbs"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["maintain_windows"] = None
            __props__.__dict__["private_ips"] = None
            __props__.__dict__["public_endpoints"] = None
            __props__.__dict__["recent_event"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["sub_status"] = None
            __props__.__dict__["task_status"] = None
            __props__.__dict__["updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["userPwd"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Cluster, __self__).__init__(
            'sbercloud:Dws/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            created: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            dss_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            elb_id: Optional[pulumi.Input[_builtins.str]] = None,
            elbs: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterElbArgs', 'ClusterElbArgsDict']]]]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterEndpointArgs', 'ClusterEndpointArgsDict']]]]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            force_backup: Optional[pulumi.Input[_builtins.bool]] = None,
            keep_last_manual_snapshot: Optional[pulumi.Input[_builtins.int]] = None,
            kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            logical_cluster_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            lts_enable: Optional[pulumi.Input[_builtins.bool]] = None,
            maintain_windows: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterMaintainWindowArgs', 'ClusterMaintainWindowArgsDict']]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_id: Optional[pulumi.Input[_builtins.str]] = None,
            node_type: Optional[pulumi.Input[_builtins.str]] = None,
            number_of_cn: Optional[pulumi.Input[_builtins.int]] = None,
            number_of_node: Optional[pulumi.Input[_builtins.int]] = None,
            port: Optional[pulumi.Input[_builtins.int]] = None,
            private_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            public_endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['ClusterPublicEndpointArgs', 'ClusterPublicEndpointArgsDict']]]]] = None,
            public_ip: Optional[pulumi.Input[Union['ClusterPublicIpArgs', 'ClusterPublicIpArgsDict']]] = None,
            recent_event: Optional[pulumi.Input[_builtins.int]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            security_group_id: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            sub_status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            task_status: Optional[pulumi.Input[_builtins.str]] = None,
            updated: Optional[pulumi.Input[_builtins.str]] = None,
            user_name: Optional[pulumi.Input[_builtins.str]] = None,
            user_pwd: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            volume: Optional[pulumi.Input[Union['ClusterVolumeArgs', 'ClusterVolumeArgsDict']]] = None,
            vpc_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] availability_zone: AZ in a cluster.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] created: Cluster creation time. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        :param pulumi.Input[_builtins.str] description: The description of the cluster.
        :param pulumi.Input[_builtins.str] dss_pool_id: Dedicated storage pool ID.
        :param pulumi.Input[_builtins.str] elb_id: The ID of the ELB load balancer.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterElbArgs', 'ClusterElbArgsDict']]]] elbs: The ELB information bound to the cluster.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterEndpointArgs', 'ClusterEndpointArgsDict']]]] endpoints: View the private network connection information about the cluster. Structure is documented below.
        :param pulumi.Input[_builtins.str] enterprise_project_id: The enterprise project id of the dws cluster,
               Value 0 indicates the default enterprise project.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.bool] force_backup: Whether to automatically execute snapshot when shrinking the number of nodes.
        :param pulumi.Input[_builtins.int] keep_last_manual_snapshot: The number of latest manual snapshots that need to be retained when deleting the cluster.
        :param pulumi.Input[_builtins.str] kms_key_id: The KMS key ID.
        :param pulumi.Input[_builtins.bool] logical_cluster_enable: Whether to enable logical cluster.
        :param pulumi.Input[_builtins.bool] lts_enable: Whether to enable LTS.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterMaintainWindowArgs', 'ClusterMaintainWindowArgsDict']]]] maintain_windows: Cluster maintenance window.
        :param pulumi.Input[_builtins.str] name: Cluster name, which must be unique and contains 4 to 64 characters, which
               consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] network_id: Network ID, which is used for configuring cluster network.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] node_type: Node type.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.int] number_of_cn: The number of CN. If you use a large-scale cluster, deploy multiple CNs.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.int] number_of_node: Number of nodes in a cluster. The value ranges from 3 to 32. When expanding,
               add at least 3 nodes.
        :param pulumi.Input[_builtins.int] port: Service port of a cluster (8000 to 10000). The default value is 8000.
               Changing this creates a new cluster resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] private_ips: List of private network IP address.
        :param pulumi.Input[Sequence[pulumi.Input[Union['ClusterPublicEndpointArgs', 'ClusterPublicEndpointArgsDict']]]] public_endpoints: Public network connection information about the cluster. If the value is not specified, the
               public network connection information is not used by default Structure is documented below.
        :param pulumi.Input[Union['ClusterPublicIpArgs', 'ClusterPublicIpArgsDict']] public_ip: A nested object resource Structure is documented below.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.int] recent_event: The recent event number.
        :param pulumi.Input[_builtins.str] region: The region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] security_group_id: ID of a security group. The ID is used for configuring cluster
               network.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] status: Cluster status, which can be one of the following:  CREATING AVAILABLE UNAVAILABLE CREATION FAILED.
        :param pulumi.Input[_builtins.str] sub_status: Sub-status of clusters in the AVAILABLE state. The value can be one of the following:  NORMAL READONLY
               REDISTRIBUTING REDISTRIBUTION-FAILURE UNBALANCED UNBALANCED | READONLY DEGRADED DEGRADED | READONLY DEGRADED |
               UNBALANCED UNBALANCED | REDISTRIBUTING UNBALANCED | REDISTRIBUTION-FAILURE READONLY | REDISTRIBUTION-FAILURE
               UNBALANCED | READONLY | REDISTRIBUTION-FAILURE DEGRADED | REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED |
               REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED | READONLY | REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED | READONLY
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: The key/value pairs to associate with the cluster.
        :param pulumi.Input[_builtins.str] task_status: Cluster management task. The value can be one of the following:
               RESTORING SNAPSHOTTING GROWING REBOOTING SETTING_CONFIGURATION CONFIGURING_EXT_DATASOURCE DELETING_EXT_DATASOURCE
               REBOOT_FAILURE RESIZE_FAILURE
        :param pulumi.Input[_builtins.str] updated: Last modification time of a cluster. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        :param pulumi.Input[_builtins.str] user_name: Administrator username for logging in to a data warehouse cluster The
               administrator username must:  Consist of lowercase letters, digits, or underscores. Start with a lowercase letter or
               an underscore. Contain 1 to 63 characters. Cannot be a keyword of the DWS database.
               Changing this creates a new cluster resource.
        :param pulumi.Input[_builtins.str] user_pwd: Administrator password for logging in to a data warehouse cluster A password
               must conform to the following rules:  Contains 8 to 32 characters. Cannot be the same as the username or the username
               written in reverse order. Contains three types of the following:
               Lowercase letters Uppercase letters Digits Special characters
               ~!@#%^&*()-_=+|[{}];:,<.>/?
        :param pulumi.Input[_builtins.str] version: Data warehouse version.
        :param pulumi.Input[_builtins.str] vpc_id: VPC ID, which is used for configuring cluster network.
               Changing this creates a new cluster resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["created"] = created
        __props__.__dict__["description"] = description
        __props__.__dict__["dss_pool_id"] = dss_pool_id
        __props__.__dict__["elb_id"] = elb_id
        __props__.__dict__["elbs"] = elbs
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["force_backup"] = force_backup
        __props__.__dict__["keep_last_manual_snapshot"] = keep_last_manual_snapshot
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["logical_cluster_enable"] = logical_cluster_enable
        __props__.__dict__["lts_enable"] = lts_enable
        __props__.__dict__["maintain_windows"] = maintain_windows
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["node_type"] = node_type
        __props__.__dict__["number_of_cn"] = number_of_cn
        __props__.__dict__["number_of_node"] = number_of_node
        __props__.__dict__["port"] = port
        __props__.__dict__["private_ips"] = private_ips
        __props__.__dict__["public_endpoints"] = public_endpoints
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["recent_event"] = recent_event
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["status"] = status
        __props__.__dict__["sub_status"] = sub_status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["task_status"] = task_status
        __props__.__dict__["updated"] = updated
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["user_pwd"] = user_pwd
        __props__.__dict__["version"] = version
        __props__.__dict__["volume"] = volume
        __props__.__dict__["vpc_id"] = vpc_id
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        AZ in a cluster.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter
    def created(self) -> pulumi.Output[_builtins.str]:
        """
        Cluster creation time. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        """
        return pulumi.get(self, "created")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the cluster.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="dssPoolId")
    def dss_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        Dedicated storage pool ID.
        """
        return pulumi.get(self, "dss_pool_id")

    @_builtins.property
    @pulumi.getter(name="elbId")
    def elb_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the ELB load balancer.
        """
        return pulumi.get(self, "elb_id")

    @_builtins.property
    @pulumi.getter
    def elbs(self) -> pulumi.Output[Sequence['outputs.ClusterElb']]:
        """
        The ELB information bound to the cluster.
        """
        return pulumi.get(self, "elbs")

    @_builtins.property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.ClusterEndpoint']]:
        """
        View the private network connection information about the cluster. Structure is documented below.
        """
        return pulumi.get(self, "endpoints")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        The enterprise project id of the dws cluster,
        Value 0 indicates the default enterprise project.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="forceBackup")
    def force_backup(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to automatically execute snapshot when shrinking the number of nodes.
        """
        return pulumi.get(self, "force_backup")

    @_builtins.property
    @pulumi.getter(name="keepLastManualSnapshot")
    def keep_last_manual_snapshot(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of latest manual snapshots that need to be retained when deleting the cluster.
        """
        return pulumi.get(self, "keep_last_manual_snapshot")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[_builtins.str]:
        """
        The KMS key ID.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="logicalClusterEnable")
    def logical_cluster_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable logical cluster.
        """
        return pulumi.get(self, "logical_cluster_enable")

    @_builtins.property
    @pulumi.getter(name="ltsEnable")
    def lts_enable(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable LTS.
        """
        return pulumi.get(self, "lts_enable")

    @_builtins.property
    @pulumi.getter(name="maintainWindows")
    def maintain_windows(self) -> pulumi.Output[Sequence['outputs.ClusterMaintainWindow']]:
        """
        Cluster maintenance window.
        """
        return pulumi.get(self, "maintain_windows")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Cluster name, which must be unique and contains 4 to 64 characters, which
        consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[_builtins.str]:
        """
        Network ID, which is used for configuring cluster network.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "network_id")

    @_builtins.property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> pulumi.Output[_builtins.str]:
        """
        Node type.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "node_type")

    @_builtins.property
    @pulumi.getter(name="numberOfCn")
    def number_of_cn(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of CN. If you use a large-scale cluster, deploy multiple CNs.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "number_of_cn")

    @_builtins.property
    @pulumi.getter(name="numberOfNode")
    def number_of_node(self) -> pulumi.Output[_builtins.int]:
        """
        Number of nodes in a cluster. The value ranges from 3 to 32. When expanding,
        add at least 3 nodes.
        """
        return pulumi.get(self, "number_of_node")

    @_builtins.property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Service port of a cluster (8000 to 10000). The default value is 8000.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="privateIps")
    def private_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        List of private network IP address.
        """
        return pulumi.get(self, "private_ips")

    @_builtins.property
    @pulumi.getter(name="publicEndpoints")
    def public_endpoints(self) -> pulumi.Output[Sequence['outputs.ClusterPublicEndpoint']]:
        """
        Public network connection information about the cluster. If the value is not specified, the
        public network connection information is not used by default Structure is documented below.
        """
        return pulumi.get(self, "public_endpoints")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output['outputs.ClusterPublicIp']:
        """
        A nested object resource Structure is documented below.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter(name="recentEvent")
    def recent_event(self) -> pulumi.Output[_builtins.int]:
        """
        The recent event number.
        """
        return pulumi.get(self, "recent_event")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        The region in which to create the cluster resource. If omitted, the
        provider-level region will be used. Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[_builtins.str]:
        """
        ID of a security group. The ID is used for configuring cluster
        network.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "security_group_id")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        Cluster status, which can be one of the following:  CREATING AVAILABLE UNAVAILABLE CREATION FAILED.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subStatus")
    def sub_status(self) -> pulumi.Output[_builtins.str]:
        """
        Sub-status of clusters in the AVAILABLE state. The value can be one of the following:  NORMAL READONLY
        REDISTRIBUTING REDISTRIBUTION-FAILURE UNBALANCED UNBALANCED | READONLY DEGRADED DEGRADED | READONLY DEGRADED |
        UNBALANCED UNBALANCED | REDISTRIBUTING UNBALANCED | REDISTRIBUTION-FAILURE READONLY | REDISTRIBUTION-FAILURE
        UNBALANCED | READONLY | REDISTRIBUTION-FAILURE DEGRADED | REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED |
        REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED | READONLY | REDISTRIBUTION-FAILURE DEGRADED | UNBALANCED | READONLY
        """
        return pulumi.get(self, "sub_status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        The key/value pairs to associate with the cluster.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="taskStatus")
    def task_status(self) -> pulumi.Output[_builtins.str]:
        """
        Cluster management task. The value can be one of the following:
        RESTORING SNAPSHOTTING GROWING REBOOTING SETTING_CONFIGURATION CONFIGURING_EXT_DATASOURCE DELETING_EXT_DATASOURCE
        REBOOT_FAILURE RESIZE_FAILURE
        """
        return pulumi.get(self, "task_status")

    @_builtins.property
    @pulumi.getter
    def updated(self) -> pulumi.Output[_builtins.str]:
        """
        Last modification time of a cluster. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        """
        return pulumi.get(self, "updated")

    @_builtins.property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[_builtins.str]:
        """
        Administrator username for logging in to a data warehouse cluster The
        administrator username must:  Consist of lowercase letters, digits, or underscores. Start with a lowercase letter or
        an underscore. Contain 1 to 63 characters. Cannot be a keyword of the DWS database.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "user_name")

    @_builtins.property
    @pulumi.getter(name="userPwd")
    def user_pwd(self) -> pulumi.Output[_builtins.str]:
        """
        Administrator password for logging in to a data warehouse cluster A password
        must conform to the following rules:  Contains 8 to 32 characters. Cannot be the same as the username or the username
        written in reverse order. Contains three types of the following:
        Lowercase letters Uppercase letters Digits Special characters
        ~!@#%^&*()-_=+|[{}];:,<.>/?
        """
        return pulumi.get(self, "user_pwd")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        Data warehouse version.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def volume(self) -> pulumi.Output['outputs.ClusterVolume']:
        return pulumi.get(self, "volume")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[_builtins.str]:
        """
        VPC ID, which is used for configuring cluster network.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "vpc_id")

