# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFlaovrsResult',
    'AwaitableGetFlaovrsResult',
    'get_flaovrs',
    'get_flaovrs_output',
]

@pulumi.output_type
class GetFlaovrsResult:
    """
    A collection of values returned by getFlaovrs.
    """
    def __init__(__self__, availability_zone=None, datastore_type=None, flavors=None, id=None, memory=None, region=None, vcpus=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if datastore_type and not isinstance(datastore_type, str):
            raise TypeError("Expected argument 'datastore_type' to be a str")
        pulumi.set(__self__, "datastore_type", datastore_type)
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if memory and not isinstance(memory, int):
            raise TypeError("Expected argument 'memory' to be a int")
        pulumi.set(__self__, "memory", memory)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if vcpus and not isinstance(vcpus, int):
            raise TypeError("Expected argument 'vcpus' to be a int")
        pulumi.set(__self__, "vcpus", vcpus)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> Optional[_builtins.str]:
        """
        The type of datastore.  
        The options are as follows:
        - **dws**: OLAP, elastic scaling, unlimited scaling of compute and storage capacity.
        - **hybrid**: a single data warehouse used for transaction and analytics workloads,
        in single-node or cluster mode.
        - **stream**: built-in time series operators; up to 40:1 compression ratio; applicable to IoT services.
        """
        return pulumi.get(self, "datastore_type")

    @_builtins.property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetFlaovrsFlavorResult']:
        """
        The list of flavor detail.
        The Flavors structure is documented below.
        """
        return pulumi.get(self, "flavors")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> Optional[_builtins.int]:
        """
        The ram of the dws node flavor in GB.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def vcpus(self) -> Optional[_builtins.int]:
        """
        The vcpus of the dws node flavor.
        """
        return pulumi.get(self, "vcpus")


class AwaitableGetFlaovrsResult(GetFlaovrsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlaovrsResult(
            availability_zone=self.availability_zone,
            datastore_type=self.datastore_type,
            flavors=self.flavors,
            id=self.id,
            memory=self.memory,
            region=self.region,
            vcpus=self.vcpus)


def get_flaovrs(availability_zone: Optional[_builtins.str] = None,
                datastore_type: Optional[_builtins.str] = None,
                memory: Optional[_builtins.int] = None,
                region: Optional[_builtins.str] = None,
                vcpus: Optional[_builtins.int] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlaovrsResult:
    """
    Use this data source to get available flavors of DWS cluster node.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    flavor = sbercloud.Dws.get_flaovrs(vcpus=8)
    ```


    :param _builtins.str availability_zone: The availability zone name.
    :param _builtins.str datastore_type: The type of datastore.  
           The options are as follows:
           - **dws**: OLAP, elastic scaling, unlimited scaling of compute and storage capacity.
           - **hybrid**: a single data warehouse used for transaction and analytics workloads,
           in single-node or cluster mode.
           - **stream**: built-in time series operators; up to 40:1 compression ratio; applicable to IoT services.
    :param _builtins.int memory: The ram of the dws node flavor in GB.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    :param _builtins.int vcpus: The vcpus of the dws node flavor.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['datastoreType'] = datastore_type
    __args__['memory'] = memory
    __args__['region'] = region
    __args__['vcpus'] = vcpus
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Dws/getFlaovrs:getFlaovrs', __args__, opts=opts, typ=GetFlaovrsResult).value

    return AwaitableGetFlaovrsResult(
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        datastore_type=pulumi.get(__ret__, 'datastore_type'),
        flavors=pulumi.get(__ret__, 'flavors'),
        id=pulumi.get(__ret__, 'id'),
        memory=pulumi.get(__ret__, 'memory'),
        region=pulumi.get(__ret__, 'region'),
        vcpus=pulumi.get(__ret__, 'vcpus'))
def get_flaovrs_output(availability_zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       datastore_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       memory: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       vcpus: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlaovrsResult]:
    """
    Use this data source to get available flavors of DWS cluster node.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    flavor = sbercloud.Dws.get_flaovrs(vcpus=8)
    ```


    :param _builtins.str availability_zone: The availability zone name.
    :param _builtins.str datastore_type: The type of datastore.  
           The options are as follows:
           - **dws**: OLAP, elastic scaling, unlimited scaling of compute and storage capacity.
           - **hybrid**: a single data warehouse used for transaction and analytics workloads,
           in single-node or cluster mode.
           - **stream**: built-in time series operators; up to 40:1 compression ratio; applicable to IoT services.
    :param _builtins.int memory: The ram of the dws node flavor in GB.
    :param _builtins.str region: Specifies the region in which to query the data source.
           If omitted, the provider-level region will be used.
    :param _builtins.int vcpus: The vcpus of the dws node flavor.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['datastoreType'] = datastore_type
    __args__['memory'] = memory
    __args__['region'] = region
    __args__['vcpus'] = vcpus
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Dws/getFlaovrs:getFlaovrs', __args__, opts=opts, typ=GetFlaovrsResult)
    return __ret__.apply(lambda __response__: GetFlaovrsResult(
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        datastore_type=pulumi.get(__response__, 'datastore_type'),
        flavors=pulumi.get(__response__, 'flavors'),
        id=pulumi.get(__response__, 'id'),
        memory=pulumi.get(__response__, 'memory'),
        region=pulumi.get(__response__, 'region'),
        vcpus=pulumi.get(__response__, 'vcpus')))
