# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterElb',
    'ClusterEndpoint',
    'ClusterMaintainWindow',
    'ClusterPublicEndpoint',
    'ClusterPublicIp',
    'ClusterVolume',
    'GetFlaovrsFlavorResult',
    'GetFlaovrsFlavorElasticVolumeSpecResult',
]

@pulumi.output_type
class ClusterElb(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "privateIp":
            suggest = "private_ip"
        elif key == "privateIpV6":
            suggest = "private_ip_v6"
        elif key == "publicIp":
            suggest = "public_ip"
        elif key == "vpcId":
            suggest = "vpc_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterElb. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterElb.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterElb.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 private_endpoint: Optional[_builtins.str] = None,
                 private_ip: Optional[_builtins.str] = None,
                 private_ip_v6: Optional[_builtins.str] = None,
                 public_ip: Optional[_builtins.str] = None,
                 vpc_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: The cluster ID
        :param _builtins.str name: Cluster name, which must be unique and contains 4 to 64 characters, which
               consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
               Changing this creates a new cluster resource.
        :param _builtins.str private_endpoint: The private endpoint of the ELB load balancer.
        :param _builtins.str private_ip: List of private network IP address.
        :param _builtins.str private_ip_v6: The IPv6 address of the ELB load balancer.
        :param _builtins.str public_ip: A nested object resource Structure is documented below.
               Changing this creates a new cluster resource.
        :param _builtins.str vpc_id: VPC ID, which is used for configuring cluster network.
               Changing this creates a new cluster resource.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_endpoint is not None:
            pulumi.set(__self__, "private_endpoint", private_endpoint)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if private_ip_v6 is not None:
            pulumi.set(__self__, "private_ip_v6", private_ip_v6)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The cluster ID
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Cluster name, which must be unique and contains 4 to 64 characters, which
        consist of letters, digits, hyphens(-), or underscores(_) only and must start with a letter.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional[_builtins.str]:
        """
        The private endpoint of the ELB load balancer.
        """
        return pulumi.get(self, "private_endpoint")

    @_builtins.property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[_builtins.str]:
        """
        List of private network IP address.
        """
        return pulumi.get(self, "private_ip")

    @_builtins.property
    @pulumi.getter(name="privateIpV6")
    def private_ip_v6(self) -> Optional[_builtins.str]:
        """
        The IPv6 address of the ELB load balancer.
        """
        return pulumi.get(self, "private_ip_v6")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[_builtins.str]:
        """
        A nested object resource Structure is documented below.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        VPC ID, which is used for configuring cluster network.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class ClusterEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "connectInfo":
            suggest = "connect_info"
        elif key == "jdbcUrl":
            suggest = "jdbc_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 connect_info: Optional[_builtins.str] = None,
                 jdbc_url: Optional[_builtins.str] = None):
        """
        :param _builtins.str connect_info: (Optional, String) Private network connection information.
        :param _builtins.str jdbc_url: (Optional, String)
               JDBC URL. The following is the default format:
               jdbc:postgresql://< public_connect_info>/<YOUR_DATABASE_NAME>
        """
        if connect_info is not None:
            pulumi.set(__self__, "connect_info", connect_info)
        if jdbc_url is not None:
            pulumi.set(__self__, "jdbc_url", jdbc_url)

    @_builtins.property
    @pulumi.getter(name="connectInfo")
    def connect_info(self) -> Optional[_builtins.str]:
        """
        (Optional, String) Private network connection information.
        """
        return pulumi.get(self, "connect_info")

    @_builtins.property
    @pulumi.getter(name="jdbcUrl")
    def jdbc_url(self) -> Optional[_builtins.str]:
        """
        (Optional, String)
        JDBC URL. The following is the default format:
        jdbc:postgresql://< public_connect_info>/<YOUR_DATABASE_NAME>
        """
        return pulumi.get(self, "jdbc_url")


@pulumi.output_type
class ClusterMaintainWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMaintainWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMaintainWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMaintainWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: Optional[_builtins.str] = None,
                 end_time: Optional[_builtins.str] = None,
                 start_time: Optional[_builtins.str] = None):
        """
        :param _builtins.str day: Maintenance time in each week in the unit of day.
        :param _builtins.str end_time: Maintenance end time in HH:mm format. The time zone is GMT+0.
        :param _builtins.str start_time: Maintenance start time in HH:mm format. The time zone is GMT+0.
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter
    def day(self) -> Optional[_builtins.str]:
        """
        Maintenance time in each week in the unit of day.
        """
        return pulumi.get(self, "day")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        """
        Maintenance end time in HH:mm format. The time zone is GMT+0.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        """
        Maintenance start time in HH:mm format. The time zone is GMT+0.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class ClusterPublicEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jdbcUrl":
            suggest = "jdbc_url"
        elif key == "publicConnectInfo":
            suggest = "public_connect_info"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPublicEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPublicEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPublicEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jdbc_url: Optional[_builtins.str] = None,
                 public_connect_info: Optional[_builtins.str] = None):
        """
        :param _builtins.str jdbc_url: (Optional, String)
               JDBC URL. The following is the default format:
               jdbc:postgresql://< public_connect_info>/<YOUR_DATABASE_NAME>
        :param _builtins.str public_connect_info: (Optional, String)
               Public network connection information.
        """
        if jdbc_url is not None:
            pulumi.set(__self__, "jdbc_url", jdbc_url)
        if public_connect_info is not None:
            pulumi.set(__self__, "public_connect_info", public_connect_info)

    @_builtins.property
    @pulumi.getter(name="jdbcUrl")
    def jdbc_url(self) -> Optional[_builtins.str]:
        """
        (Optional, String)
        JDBC URL. The following is the default format:
        jdbc:postgresql://< public_connect_info>/<YOUR_DATABASE_NAME>
        """
        return pulumi.get(self, "jdbc_url")

    @_builtins.property
    @pulumi.getter(name="publicConnectInfo")
    def public_connect_info(self) -> Optional[_builtins.str]:
        """
        (Optional, String)
        Public network connection information.
        """
        return pulumi.get(self, "public_connect_info")


@pulumi.output_type
class ClusterPublicIp(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eipId":
            suggest = "eip_id"
        elif key == "publicBindType":
            suggest = "public_bind_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterPublicIp. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterPublicIp.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterPublicIp.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eip_id: Optional[_builtins.str] = None,
                 public_bind_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str eip_id: EIP ID.
               Changing this creates a new cluster resource.
        :param _builtins.str public_bind_type: Binding type of an EIP. The value can be either of the following:
               **auto_assign**, **not_use**, **bind_existing**. The default value is **not_use**.
               Changing this creates a new cluster resource.
        """
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if public_bind_type is not None:
            pulumi.set(__self__, "public_bind_type", public_bind_type)

    @_builtins.property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[_builtins.str]:
        """
        EIP ID.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "eip_id")

    @_builtins.property
    @pulumi.getter(name="publicBindType")
    def public_bind_type(self) -> Optional[_builtins.str]:
        """
        Binding type of an EIP. The value can be either of the following:
        **auto_assign**, **not_use**, **bind_existing**. The default value is **not_use**.
        Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "public_bind_type")


@pulumi.output_type
class ClusterVolume(dict):
    def __init__(__self__, *,
                 capacity: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str capacity: The capacity size, in GB.
        :param _builtins.str type: The volume type.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[_builtins.str]:
        """
        The capacity size, in GB.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The volume type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetFlaovrsFlavorResult(dict):
    def __init__(__self__, *,
                 availability_zones: Sequence[_builtins.str],
                 datastore_type: _builtins.str,
                 datastore_version: _builtins.str,
                 elastic_volume_specs: Sequence['outputs.GetFlaovrsFlavorElasticVolumeSpecResult'],
                 flavor_id: _builtins.str,
                 memory: _builtins.int,
                 size: _builtins.int,
                 vcpus: _builtins.int,
                 volumetype: _builtins.str):
        """
        :param Sequence[_builtins.str] availability_zones: The list of availability zones.
        :param _builtins.str datastore_type: The type of datastore.  
               The options are as follows:
               - **dws**: OLAP, elastic scaling, unlimited scaling of compute and storage capacity.
               - **hybrid**: a single data warehouse used for transaction and analytics workloads,
               in single-node or cluster mode.
               - **stream**: built-in time series operators; up to 40:1 compression ratio; applicable to IoT services.
        :param _builtins.str datastore_version: The version of datastore.
        :param Sequence['GetFlaovrsFlavorElasticVolumeSpecArgs'] elastic_volume_specs: The ElasticVolumeSpec structure is documented below.
        :param _builtins.str flavor_id: The name of the dws node flavor.  
               It is referenced by `node_type` in `dws_get_flaovrs`.
        :param _builtins.int memory: The ram of the dws node flavor in GB.
        :param _builtins.int size: The default disk size in GB.
        :param _builtins.int vcpus: The vcpus of the dws node flavor.
        :param _builtins.str volumetype: Disk type.  
               The options are as follows:
               - **LOCAL_DISK**:common I/O disk.
               - **SSD**: ultra-high I/O disk.
        """
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "datastore_type", datastore_type)
        pulumi.set(__self__, "datastore_version", datastore_version)
        pulumi.set(__self__, "elastic_volume_specs", elastic_volume_specs)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "vcpus", vcpus)
        pulumi.set(__self__, "volumetype", volumetype)

    @_builtins.property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[_builtins.str]:
        """
        The list of availability zones.
        """
        return pulumi.get(self, "availability_zones")

    @_builtins.property
    @pulumi.getter(name="datastoreType")
    def datastore_type(self) -> _builtins.str:
        """
        The type of datastore.  
        The options are as follows:
        - **dws**: OLAP, elastic scaling, unlimited scaling of compute and storage capacity.
        - **hybrid**: a single data warehouse used for transaction and analytics workloads,
        in single-node or cluster mode.
        - **stream**: built-in time series operators; up to 40:1 compression ratio; applicable to IoT services.
        """
        return pulumi.get(self, "datastore_type")

    @_builtins.property
    @pulumi.getter(name="datastoreVersion")
    def datastore_version(self) -> _builtins.str:
        """
        The version of datastore.
        """
        return pulumi.get(self, "datastore_version")

    @_builtins.property
    @pulumi.getter(name="elasticVolumeSpecs")
    def elastic_volume_specs(self) -> Sequence['outputs.GetFlaovrsFlavorElasticVolumeSpecResult']:
        """
        The ElasticVolumeSpec structure is documented below.
        """
        return pulumi.get(self, "elastic_volume_specs")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> _builtins.str:
        """
        The name of the dws node flavor.  
        It is referenced by `node_type` in `dws_get_flaovrs`.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter
    def memory(self) -> _builtins.int:
        """
        The ram of the dws node flavor in GB.
        """
        return pulumi.get(self, "memory")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The default disk size in GB.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def vcpus(self) -> _builtins.int:
        """
        The vcpus of the dws node flavor.
        """
        return pulumi.get(self, "vcpus")

    @_builtins.property
    @pulumi.getter
    def volumetype(self) -> _builtins.str:
        """
        Disk type.  
        The options are as follows:
        - **LOCAL_DISK**:common I/O disk.
        - **SSD**: ultra-high I/O disk.
        """
        return pulumi.get(self, "volumetype")


@pulumi.output_type
class GetFlaovrsFlavorElasticVolumeSpecResult(dict):
    def __init__(__self__, *,
                 max_size: _builtins.int,
                 min_size: _builtins.int,
                 step: _builtins.int):
        """
        :param _builtins.int max_size: Maximum disk size.
        :param _builtins.int min_size: Minimum disk size.
        :param _builtins.int step: Disk size increment step.
        """
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "step", step)

    @_builtins.property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> _builtins.int:
        """
        Maximum disk size.
        """
        return pulumi.get(self, "max_size")

    @_builtins.property
    @pulumi.getter(name="minSize")
    def min_size(self) -> _builtins.int:
        """
        Minimum disk size.
        """
        return pulumi.get(self, "min_size")

    @_builtins.property
    @pulumi.getter
    def step(self) -> _builtins.int:
        """
        Disk size increment step.
        """
        return pulumi.get(self, "step")


