# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'InstanceBandwidthArgs',
    'InstanceBandwidthArgsDict',
    'InstanceDataDiskArgs',
    'InstanceDataDiskArgsDict',
    'InstanceNetworkArgs',
    'InstanceNetworkArgsDict',
    'InstanceSchedulerHintArgs',
    'InstanceSchedulerHintArgsDict',
    'InstanceVolumeAttachedArgs',
    'InstanceVolumeAttachedArgsDict',
]

MYPY = False

if not MYPY:
    class InstanceBandwidthArgsDict(TypedDict):
        share_type: pulumi.Input[_builtins.str]
        """
        Specifies the bandwidth sharing type. Changing this creates a new instance.
        Possible values are as follows:
        + **PER**: Dedicated bandwidth
        + **WHOLE**: Shared bandwidth
        """
        charge_mode: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the bandwidth billing mode. The value can be *traffic* or *bandwidth*.
        Changing this creates a new instance.
        """
        extend_param: NotRequired[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]
        id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the **shared** bandwidth id. This parameter is mandatory when
        `share_type` is set to **WHOLE**. Changing this creates a new instance.
        """
        size: NotRequired[pulumi.Input[_builtins.int]]
        """
        Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
        This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        """
elif False:
    InstanceBandwidthArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceBandwidthArgs:
    def __init__(__self__, *,
                 share_type: pulumi.Input[_builtins.str],
                 charge_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 extend_param: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 id: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] share_type: Specifies the bandwidth sharing type. Changing this creates a new instance.
               Possible values are as follows:
               + **PER**: Dedicated bandwidth
               + **WHOLE**: Shared bandwidth
        :param pulumi.Input[_builtins.str] charge_mode: Specifies the bandwidth billing mode. The value can be *traffic* or *bandwidth*.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] id: Specifies the **shared** bandwidth id. This parameter is mandatory when
               `share_type` is set to **WHOLE**. Changing this creates a new instance.
        :param pulumi.Input[_builtins.int] size: Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
               This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        """
        pulumi.set(__self__, "share_type", share_type)
        if charge_mode is not None:
            pulumi.set(__self__, "charge_mode", charge_mode)
        if extend_param is not None:
            pulumi.set(__self__, "extend_param", extend_param)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the bandwidth sharing type. Changing this creates a new instance.
        Possible values are as follows:
        + **PER**: Dedicated bandwidth
        + **WHOLE**: Shared bandwidth
        """
        return pulumi.get(self, "share_type")

    @share_type.setter
    def share_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "share_type", value)

    @_builtins.property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the bandwidth billing mode. The value can be *traffic* or *bandwidth*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "charge_mode")

    @charge_mode.setter
    def charge_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charge_mode", value)

    @_builtins.property
    @pulumi.getter(name="extendParam")
    def extend_param(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "extend_param")

    @extend_param.setter
    def extend_param(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "extend_param", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the **shared** bandwidth id. This parameter is mandatory when
        `share_type` is set to **WHOLE**. Changing this creates a new instance.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "id", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
        This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)


if not MYPY:
    class InstanceDataDiskArgsDict(TypedDict):
        size: pulumi.Input[_builtins.int]
        """
        Specifies the data disk size, in GB. The value ranges form 10 to 32768.
        Changing this creates a new instance.
        """
        type: pulumi.Input[_builtins.str]
        """
        Specifies the ECS data disk type, which must be one of available disk types,
        contains of *SSD*, *GPSSD* and *SAS*. Changing this creates a new instance.
        """
        dss_pool_id: NotRequired[pulumi.Input[_builtins.str]]
        iops: NotRequired[pulumi.Input[_builtins.int]]
        kms_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the ID of a KMS key. This is used to encrypt the disk.
        Changing this creates a new instance.
        """
        snapshot_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the snapshot id. Changing this creates a new instance.
        """
        throughput: NotRequired[pulumi.Input[_builtins.int]]
elif False:
    InstanceDataDiskArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceDataDiskArgs:
    def __init__(__self__, *,
                 size: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str],
                 dss_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 iops: Optional[pulumi.Input[_builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 snapshot_id: Optional[pulumi.Input[_builtins.str]] = None,
                 throughput: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] size: Specifies the data disk size, in GB. The value ranges form 10 to 32768.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] type: Specifies the ECS data disk type, which must be one of available disk types,
               contains of *SSD*, *GPSSD* and *SAS*. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] kms_key_id: Specifies the ID of a KMS key. This is used to encrypt the disk.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] snapshot_id: Specifies the snapshot id. Changing this creates a new instance.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if dss_pool_id is not None:
            pulumi.set(__self__, "dss_pool_id", dss_pool_id)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.int]:
        """
        Specifies the data disk size, in GB. The value ranges form 10 to 32768.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ECS data disk type, which must be one of available disk types,
        contains of *SSD*, *GPSSD* and *SAS*. Changing this creates a new instance.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="dssPoolId")
    def dss_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "dss_pool_id")

    @dss_pool_id.setter
    def dss_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "dss_pool_id", value)

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "iops", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a KMS key. This is used to encrypt the disk.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the snapshot id. Changing this creates a new instance.
        """
        return pulumi.get(self, "snapshot_id")

    @snapshot_id.setter
    def snapshot_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "snapshot_id", value)

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "throughput")

    @throughput.setter
    def throughput(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "throughput", value)


if not MYPY:
    class InstanceNetworkArgsDict(TypedDict):
        access_network: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies if this network should be used for provisioning access.
        Accepts true or false. Defaults to false.
        """
        fixed_ip_v4: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies a fixed IPv4 address to be used on this network.
        Changing this creates a new instance.
        """
        fixed_ip_v6: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Fixed IPv6 address of the instance on that network.
        """
        ipv6_enable: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies whether the IPv6 function is enabled for the nic.
        Defaults to false. Changing this creates a new instance.
        """
        mac: NotRequired[pulumi.Input[_builtins.str]]
        """
        The MAC address of the NIC on that network.
        """
        port: NotRequired[pulumi.Input[_builtins.str]]
        """
        The port ID corresponding to the IP address on that network.
        """
        source_dest_check: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Specifies whether the ECS processes only traffic that is destined specifically
        for it. This function is enabled by default but should be disabled if the ECS functions as a SNAT server or has a
        virtual IP address bound to it.
        """
        uuid: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the network UUID to attach to the instance.
        Changing this creates a new instance.
        """
elif False:
    InstanceNetworkArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceNetworkArgs:
    def __init__(__self__, *,
                 access_network: Optional[pulumi.Input[_builtins.bool]] = None,
                 fixed_ip_v4: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_ip_v6: Optional[pulumi.Input[_builtins.str]] = None,
                 ipv6_enable: Optional[pulumi.Input[_builtins.bool]] = None,
                 mac: Optional[pulumi.Input[_builtins.str]] = None,
                 port: Optional[pulumi.Input[_builtins.str]] = None,
                 source_dest_check: Optional[pulumi.Input[_builtins.bool]] = None,
                 uuid: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] access_network: Specifies if this network should be used for provisioning access.
               Accepts true or false. Defaults to false.
        :param pulumi.Input[_builtins.str] fixed_ip_v4: Specifies a fixed IPv4 address to be used on this network.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] fixed_ip_v6: The Fixed IPv6 address of the instance on that network.
        :param pulumi.Input[_builtins.bool] ipv6_enable: Specifies whether the IPv6 function is enabled for the nic.
               Defaults to false. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] mac: The MAC address of the NIC on that network.
        :param pulumi.Input[_builtins.str] port: The port ID corresponding to the IP address on that network.
        :param pulumi.Input[_builtins.bool] source_dest_check: Specifies whether the ECS processes only traffic that is destined specifically
               for it. This function is enabled by default but should be disabled if the ECS functions as a SNAT server or has a
               virtual IP address bound to it.
        :param pulumi.Input[_builtins.str] uuid: Specifies the network UUID to attach to the instance.
               Changing this creates a new instance.
        """
        if access_network is not None:
            pulumi.set(__self__, "access_network", access_network)
        if fixed_ip_v4 is not None:
            pulumi.set(__self__, "fixed_ip_v4", fixed_ip_v4)
        if fixed_ip_v6 is not None:
            pulumi.set(__self__, "fixed_ip_v6", fixed_ip_v6)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="accessNetwork")
    def access_network(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if this network should be used for provisioning access.
        Accepts true or false. Defaults to false.
        """
        return pulumi.get(self, "access_network")

    @access_network.setter
    def access_network(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "access_network", value)

    @_builtins.property
    @pulumi.getter(name="fixedIpV4")
    def fixed_ip_v4(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a fixed IPv4 address to be used on this network.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "fixed_ip_v4")

    @fixed_ip_v4.setter
    def fixed_ip_v4(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fixed_ip_v4", value)

    @_builtins.property
    @pulumi.getter(name="fixedIpV6")
    def fixed_ip_v6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Fixed IPv6 address of the instance on that network.
        """
        return pulumi.get(self, "fixed_ip_v6")

    @fixed_ip_v6.setter
    def fixed_ip_v6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fixed_ip_v6", value)

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the IPv6 function is enabled for the nic.
        Defaults to false. Changing this creates a new instance.
        """
        return pulumi.get(self, "ipv6_enable")

    @ipv6_enable.setter
    def ipv6_enable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ipv6_enable", value)

    @_builtins.property
    @pulumi.getter
    def mac(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The MAC address of the NIC on that network.
        """
        return pulumi.get(self, "mac")

    @mac.setter
    def mac(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "mac", value)

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port ID corresponding to the IP address on that network.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port", value)

    @_builtins.property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the ECS processes only traffic that is destined specifically
        for it. This function is enabled by default but should be disabled if the ECS functions as a SNAT server or has a
        virtual IP address bound to it.
        """
        return pulumi.get(self, "source_dest_check")

    @source_dest_check.setter
    def source_dest_check(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "source_dest_check", value)

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the network UUID to attach to the instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "uuid")

    @uuid.setter
    def uuid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uuid", value)


if not MYPY:
    class InstanceSchedulerHintArgsDict(TypedDict):
        deh_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the ID of DeH.
        This parameter takes effect only when the value of tenancy is dedicated. Changing this creates a new instance.
        """
        fault_domain: NotRequired[pulumi.Input[_builtins.str]]
        """
        schema: Internal
        """
        group: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies a UUID of a Server Group.
        The instance will be placed into that group. Changing this creates a new instance.
        """
        tenancy: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the tenancy specifies whether the ECS is to be created on a
        Dedicated Host
        (DeH) or in a shared pool. Changing this creates a new instance.
        """
elif False:
    InstanceSchedulerHintArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceSchedulerHintArgs:
    def __init__(__self__, *,
                 deh_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fault_domain: Optional[pulumi.Input[_builtins.str]] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 tenancy: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] deh_id: Specifies the ID of DeH.
               This parameter takes effect only when the value of tenancy is dedicated. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] fault_domain: schema: Internal
        :param pulumi.Input[_builtins.str] group: Specifies a UUID of a Server Group.
               The instance will be placed into that group. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] tenancy: Specifies the tenancy specifies whether the ECS is to be created on a
               Dedicated Host
               (DeH) or in a shared pool. Changing this creates a new instance.
        """
        if deh_id is not None:
            pulumi.set(__self__, "deh_id", deh_id)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if tenancy is not None:
            pulumi.set(__self__, "tenancy", tenancy)

    @_builtins.property
    @pulumi.getter(name="dehId")
    def deh_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of DeH.
        This parameter takes effect only when the value of tenancy is dedicated. Changing this creates a new instance.
        """
        return pulumi.get(self, "deh_id")

    @deh_id.setter
    def deh_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "deh_id", value)

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        schema: Internal
        """
        return pulumi.get(self, "fault_domain")

    @fault_domain.setter
    def fault_domain(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fault_domain", value)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a UUID of a Server Group.
        The instance will be placed into that group. Changing this creates a new instance.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter
    def tenancy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the tenancy specifies whether the ECS is to be created on a
        Dedicated Host
        (DeH) or in a shared pool. Changing this creates a new instance.
        """
        return pulumi.get(self, "tenancy")

    @tenancy.setter
    def tenancy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenancy", value)


if not MYPY:
    class InstanceVolumeAttachedArgsDict(TypedDict):
        boot_index: NotRequired[pulumi.Input[_builtins.int]]
        """
        The volume boot index on that attachment.
        """
        kms_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the ID of a KMS key. This is used to encrypt the disk.
        Changing this creates a new instance.
        """
        pci_address: NotRequired[pulumi.Input[_builtins.str]]
        """
        The volume pci address on that attachment.
        """
        size: NotRequired[pulumi.Input[_builtins.int]]
        """
        The volume size on that attachment.
        """
        type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The volume type on that attachment.
        """
        volume_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The volume ID on that attachment.
        """
elif False:
    InstanceVolumeAttachedArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class InstanceVolumeAttachedArgs:
    def __init__(__self__, *,
                 boot_index: Optional[pulumi.Input[_builtins.int]] = None,
                 kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 pci_address: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.int]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] boot_index: The volume boot index on that attachment.
        :param pulumi.Input[_builtins.str] kms_key_id: Specifies the ID of a KMS key. This is used to encrypt the disk.
               Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] pci_address: The volume pci address on that attachment.
        :param pulumi.Input[_builtins.int] size: The volume size on that attachment.
        :param pulumi.Input[_builtins.str] type: The volume type on that attachment.
        :param pulumi.Input[_builtins.str] volume_id: The volume ID on that attachment.
        """
        if boot_index is not None:
            pulumi.set(__self__, "boot_index", boot_index)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if pci_address is not None:
            pulumi.set(__self__, "pci_address", pci_address)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter(name="bootIndex")
    def boot_index(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The volume boot index on that attachment.
        """
        return pulumi.get(self, "boot_index")

    @boot_index.setter
    def boot_index(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "boot_index", value)

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of a KMS key. This is used to encrypt the disk.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="pciAddress")
    def pci_address(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The volume pci address on that attachment.
        """
        return pulumi.get(self, "pci_address")

    @pci_address.setter
    def pci_address(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "pci_address", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The volume size on that attachment.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The volume type on that attachment.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The volume ID on that attachment.
        """
        return pulumi.get(self, "volume_id")

    @volume_id.setter
    def volume_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "volume_id", value)


