# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EipAssociateArgs', 'EipAssociate']

@pulumi.input_type
class EipAssociateArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[_builtins.str],
                 bandwidth_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a EipAssociate resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of ECS instance to associated with.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] bandwidth_id: Specifies the **shared** bandwidth ID to associate.
               It's **mandatory** when you want to associate the ECS instance with a specified shared bandwidth.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] fixed_ip: Specifies the private IP address to direct traffic to. It's **mandatory**
               and must be a valid IPv6 address when you want to associate the ECS instance with a specified shared bandwidth.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] public_ip: Specifies the EIP address to associate. It's **mandatory**
               when you want to associate the ECS instance with an EIP. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the associated resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if bandwidth_id is not None:
            pulumi.set(__self__, "bandwidth_id", bandwidth_id)
        if fixed_ip is not None:
            pulumi.set(__self__, "fixed_ip", fixed_ip)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the ID of ECS instance to associated with.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="bandwidthId")
    def bandwidth_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the **shared** bandwidth ID to associate.
        It's **mandatory** when you want to associate the ECS instance with a specified shared bandwidth.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "bandwidth_id")

    @bandwidth_id.setter
    def bandwidth_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_id", value)

    @_builtins.property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the private IP address to direct traffic to. It's **mandatory**
        and must be a valid IPv6 address when you want to associate the ECS instance with a specified shared bandwidth.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "fixed_ip")

    @fixed_ip.setter
    def fixed_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fixed_ip", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the EIP address to associate. It's **mandatory**
        when you want to associate the ECS instance with an EIP. Changing this creates a new resource.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the associated resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _EipAssociateState:
    def __init__(__self__, *,
                 bandwidth_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 port_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering EipAssociate resources.
        :param pulumi.Input[_builtins.str] bandwidth_id: Specifies the **shared** bandwidth ID to associate.
               It's **mandatory** when you want to associate the ECS instance with a specified shared bandwidth.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] fixed_ip: Specifies the private IP address to direct traffic to. It's **mandatory**
               and must be a valid IPv6 address when you want to associate the ECS instance with a specified shared bandwidth.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of ECS instance to associated with.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] port_id: The port ID of the ECS instance that associated with.
        :param pulumi.Input[_builtins.str] public_ip: Specifies the EIP address to associate. It's **mandatory**
               when you want to associate the ECS instance with an EIP. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the associated resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        if bandwidth_id is not None:
            pulumi.set(__self__, "bandwidth_id", bandwidth_id)
        if fixed_ip is not None:
            pulumi.set(__self__, "fixed_ip", fixed_ip)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="bandwidthId")
    def bandwidth_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the **shared** bandwidth ID to associate.
        It's **mandatory** when you want to associate the ECS instance with a specified shared bandwidth.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "bandwidth_id")

    @bandwidth_id.setter
    def bandwidth_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bandwidth_id", value)

    @_builtins.property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the private IP address to direct traffic to. It's **mandatory**
        and must be a valid IPv6 address when you want to associate the ECS instance with a specified shared bandwidth.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "fixed_ip")

    @fixed_ip.setter
    def fixed_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fixed_ip", value)

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of ECS instance to associated with.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance_id", value)

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The port ID of the ECS instance that associated with.
        """
        return pulumi.get(self, "port_id")

    @port_id.setter
    def port_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "port_id", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the EIP address to associate. It's **mandatory**
        when you want to associate the ECS instance with an EIP. Changing this creates a new resource.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the associated resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)


@pulumi.type_token("sbercloud:Ecs/eipAssociate:EipAssociate")
class EipAssociate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        * Associates the **IPv4** address of an ECS instance to a specified EIP.
        * Associates the **IPv6** address of an ECS instance to a specified **Shared** Bandwidth.

        ## Example Usage

        ## Import

        This resource can be imported by specifying all three arguments, separated by a forward slash:

        ```sh
        $ pulumi import sbercloud:Ecs/eipAssociate:EipAssociate bind <eip address or bandwidth_id>/<instance_id>/<fixed_ip>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bandwidth_id: Specifies the **shared** bandwidth ID to associate.
               It's **mandatory** when you want to associate the ECS instance with a specified shared bandwidth.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] fixed_ip: Specifies the private IP address to direct traffic to. It's **mandatory**
               and must be a valid IPv6 address when you want to associate the ECS instance with a specified shared bandwidth.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of ECS instance to associated with.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] public_ip: Specifies the EIP address to associate. It's **mandatory**
               when you want to associate the ECS instance with an EIP. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the associated resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: EipAssociateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        * Associates the **IPv4** address of an ECS instance to a specified EIP.
        * Associates the **IPv6** address of an ECS instance to a specified **Shared** Bandwidth.

        ## Example Usage

        ## Import

        This resource can be imported by specifying all three arguments, separated by a forward slash:

        ```sh
        $ pulumi import sbercloud:Ecs/eipAssociate:EipAssociate bind <eip address or bandwidth_id>/<instance_id>/<fixed_ip>
        ```

        :param str resource_name: The name of the resource.
        :param EipAssociateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EipAssociateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EipAssociateArgs.__new__(EipAssociateArgs)

            __props__.__dict__["bandwidth_id"] = bandwidth_id
            __props__.__dict__["fixed_ip"] = fixed_ip
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["public_ip"] = public_ip
            __props__.__dict__["region"] = region
            __props__.__dict__["port_id"] = None
        super(EipAssociate, __self__).__init__(
            'sbercloud:Ecs/eipAssociate:EipAssociate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth_id: Optional[pulumi.Input[_builtins.str]] = None,
            fixed_ip: Optional[pulumi.Input[_builtins.str]] = None,
            instance_id: Optional[pulumi.Input[_builtins.str]] = None,
            port_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None) -> 'EipAssociate':
        """
        Get an existing EipAssociate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bandwidth_id: Specifies the **shared** bandwidth ID to associate.
               It's **mandatory** when you want to associate the ECS instance with a specified shared bandwidth.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] fixed_ip: Specifies the private IP address to direct traffic to. It's **mandatory**
               and must be a valid IPv6 address when you want to associate the ECS instance with a specified shared bandwidth.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] instance_id: Specifies the ID of ECS instance to associated with.
               Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] port_id: The port ID of the ECS instance that associated with.
        :param pulumi.Input[_builtins.str] public_ip: Specifies the EIP address to associate. It's **mandatory**
               when you want to associate the ECS instance with an EIP. Changing this creates a new resource.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the associated resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EipAssociateState.__new__(_EipAssociateState)

        __props__.__dict__["bandwidth_id"] = bandwidth_id
        __props__.__dict__["fixed_ip"] = fixed_ip
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["port_id"] = port_id
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        return EipAssociate(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bandwidthId")
    def bandwidth_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the **shared** bandwidth ID to associate.
        It's **mandatory** when you want to associate the ECS instance with a specified shared bandwidth.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "bandwidth_id")

    @_builtins.property
    @pulumi.getter(name="fixedIp")
    def fixed_ip(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the private IP address to direct traffic to. It's **mandatory**
        and must be a valid IPv6 address when you want to associate the ECS instance with a specified shared bandwidth.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "fixed_ip")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the ID of ECS instance to associated with.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="portId")
    def port_id(self) -> pulumi.Output[_builtins.str]:
        """
        The port ID of the ECS instance that associated with.
        """
        return pulumi.get(self, "port_id")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the EIP address to associate. It's **mandatory**
        when you want to associate the ECS instance with an EIP. Changing this creates a new resource.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the associated resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

