# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetFlavorsResult',
    'AwaitableGetFlavorsResult',
    'get_flavors',
    'get_flavors_output',
]

@pulumi.output_type
class GetFlavorsResult:
    """
    A collection of values returned by getFlavors.
    """
    def __init__(__self__, availability_zone=None, cpu_core_count=None, flavors=None, generation=None, id=None, ids=None, memory_size=None, performance_type=None, region=None, storage_type=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if cpu_core_count and not isinstance(cpu_core_count, int):
            raise TypeError("Expected argument 'cpu_core_count' to be a int")
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if generation and not isinstance(generation, str):
            raise TypeError("Expected argument 'generation' to be a str")
        pulumi.set(__self__, "generation", generation)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if memory_size and not isinstance(memory_size, int):
            raise TypeError("Expected argument 'memory_size' to be a int")
        pulumi.set(__self__, "memory_size", memory_size)
        if performance_type and not isinstance(performance_type, str):
            raise TypeError("Expected argument 'performance_type' to be a str")
        pulumi.set(__self__, "performance_type", performance_type)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if storage_type and not isinstance(storage_type, str):
            raise TypeError("Expected argument 'storage_type' to be a str")
        pulumi.set(__self__, "storage_type", storage_type)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "cpu_core_count")

    @_builtins.property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetFlavorsFlavorResult']:
        return pulumi.get(self, "flavors")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def ids(self) -> Sequence[_builtins.str]:
        """
        A list of flavor IDs.
        """
        return pulumi.get(self, "ids")

    @_builtins.property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "memory_size")

    @_builtins.property
    @pulumi.getter(name="performanceType")
    def performance_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "performance_type")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "storage_type")


class AwaitableGetFlavorsResult(GetFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlavorsResult(
            availability_zone=self.availability_zone,
            cpu_core_count=self.cpu_core_count,
            flavors=self.flavors,
            generation=self.generation,
            id=self.id,
            ids=self.ids,
            memory_size=self.memory_size,
            performance_type=self.performance_type,
            region=self.region,
            storage_type=self.storage_type)


def get_flavors(availability_zone: Optional[_builtins.str] = None,
                cpu_core_count: Optional[_builtins.int] = None,
                generation: Optional[_builtins.str] = None,
                memory_size: Optional[_builtins.int] = None,
                performance_type: Optional[_builtins.str] = None,
                region: Optional[_builtins.str] = None,
                storage_type: Optional[_builtins.str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlavorsResult:
    """
    Use this data source to get the ID of the available Compute Flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudru as sbercloud
    import pulumi_sbercloud as sbercloud

    flavors = sbercloud.Ecs.get_flavors(availability_zone="ru-moscow-1a",
        performance_type="normal",
        cpu_core_count=2,
        memory_size=4)
    # Create ECS instance with the first matched flavor
    instance = sbercloud.ecs.Instance("instance", flavor_id=flavors.ids[0])
    ```

    ### Additional Examples

    ```python
    import pulumi
    import pulumi_cloudru as sbercloud
    import pulumi_sbercloud as sbercloud

    flavors = sbercloud.Ecs.get_flavors(availability_zone="ru-moscow-1a",
        performance_type="normal",
        cpu_core_count=2,
        memory_size=4)
    # Create ECS instance with the first matched flavor
    instance = sbercloud.ecs.Instance("instance", flavor_id=flavors.ids[0])
    ```

    ## subcategory: "Elastic Cloud Server (ECS)"

    ***

    # sbercloud\\_compute\\_flavors

    Use this data source to get the ID of the available Compute Flavors.


    :param _builtins.str availability_zone: Specifies the AZ name.
    :param _builtins.int cpu_core_count: Specifies the number of vCPUs in the ECS flavor.
    :param _builtins.str generation: Specifies the generation of an ECS type.
    :param _builtins.int memory_size: Specifies the memory size(GB) in the ECS flavor.
    :param _builtins.str performance_type: Specifies the ECS flavor type.
    :param _builtins.str region: The region in which to obtain the flavors. If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['cpuCoreCount'] = cpu_core_count
    __args__['generation'] = generation
    __args__['memorySize'] = memory_size
    __args__['performanceType'] = performance_type
    __args__['region'] = region
    __args__['storageType'] = storage_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Ecs/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult).value

    return AwaitableGetFlavorsResult(
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        cpu_core_count=pulumi.get(__ret__, 'cpu_core_count'),
        flavors=pulumi.get(__ret__, 'flavors'),
        generation=pulumi.get(__ret__, 'generation'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        memory_size=pulumi.get(__ret__, 'memory_size'),
        performance_type=pulumi.get(__ret__, 'performance_type'),
        region=pulumi.get(__ret__, 'region'),
        storage_type=pulumi.get(__ret__, 'storage_type'))
def get_flavors_output(availability_zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       cpu_core_count: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       generation: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       memory_size: Optional[pulumi.Input[Optional[_builtins.int]]] = None,
                       performance_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       storage_type: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFlavorsResult]:
    """
    Use this data source to get the ID of the available Compute Flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudru as sbercloud
    import pulumi_sbercloud as sbercloud

    flavors = sbercloud.Ecs.get_flavors(availability_zone="ru-moscow-1a",
        performance_type="normal",
        cpu_core_count=2,
        memory_size=4)
    # Create ECS instance with the first matched flavor
    instance = sbercloud.ecs.Instance("instance", flavor_id=flavors.ids[0])
    ```

    ### Additional Examples

    ```python
    import pulumi
    import pulumi_cloudru as sbercloud
    import pulumi_sbercloud as sbercloud

    flavors = sbercloud.Ecs.get_flavors(availability_zone="ru-moscow-1a",
        performance_type="normal",
        cpu_core_count=2,
        memory_size=4)
    # Create ECS instance with the first matched flavor
    instance = sbercloud.ecs.Instance("instance", flavor_id=flavors.ids[0])
    ```

    ## subcategory: "Elastic Cloud Server (ECS)"

    ***

    # sbercloud\\_compute\\_flavors

    Use this data source to get the ID of the available Compute Flavors.


    :param _builtins.str availability_zone: Specifies the AZ name.
    :param _builtins.int cpu_core_count: Specifies the number of vCPUs in the ECS flavor.
    :param _builtins.str generation: Specifies the generation of an ECS type.
    :param _builtins.int memory_size: Specifies the memory size(GB) in the ECS flavor.
    :param _builtins.str performance_type: Specifies the ECS flavor type.
    :param _builtins.str region: The region in which to obtain the flavors. If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['cpuCoreCount'] = cpu_core_count
    __args__['generation'] = generation
    __args__['memorySize'] = memory_size
    __args__['performanceType'] = performance_type
    __args__['region'] = region
    __args__['storageType'] = storage_type
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Ecs/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult)
    return __ret__.apply(lambda __response__: GetFlavorsResult(
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        cpu_core_count=pulumi.get(__response__, 'cpu_core_count'),
        flavors=pulumi.get(__response__, 'flavors'),
        generation=pulumi.get(__response__, 'generation'),
        id=pulumi.get(__response__, 'id'),
        ids=pulumi.get(__response__, 'ids'),
        memory_size=pulumi.get(__response__, 'memory_size'),
        performance_type=pulumi.get(__response__, 'performance_type'),
        region=pulumi.get(__response__, 'region'),
        storage_type=pulumi.get(__response__, 'storage_type')))
