# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetInstancesResult',
    'AwaitableGetInstancesResult',
    'get_instances',
    'get_instances_output',
]

@pulumi.output_type
class GetInstancesResult:
    """
    A collection of values returned by getInstances.
    """
    def __init__(__self__, availability_zone=None, enterprise_project_id=None, fixed_ip_v4=None, flavor_id=None, flavor_name=None, id=None, image_id=None, instance_id=None, instances=None, key_pair=None, name=None, region=None, status=None, tags=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if fixed_ip_v4 and not isinstance(fixed_ip_v4, str):
            raise TypeError("Expected argument 'fixed_ip_v4' to be a str")
        pulumi.set(__self__, "fixed_ip_v4", fixed_ip_v4)
        if flavor_id and not isinstance(flavor_id, str):
            raise TypeError("Expected argument 'flavor_id' to be a str")
        pulumi.set(__self__, "flavor_id", flavor_id)
        if flavor_name and not isinstance(flavor_name, str):
            raise TypeError("Expected argument 'flavor_name' to be a str")
        pulumi.set(__self__, "flavor_name", flavor_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if key_pair and not isinstance(key_pair, str):
            raise TypeError("Expected argument 'key_pair' to be a str")
        pulumi.set(__self__, "key_pair", key_pair)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[_builtins.str]:
        """
        The availability zone where the instance is located.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[_builtins.str]:
        """
        The enterprise project ID.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="fixedIpV4")
    def fixed_ip_v4(self) -> Optional[_builtins.str]:
        """
        The fixed IPv4 address of the instance on this network.
        """
        return pulumi.get(self, "fixed_ip_v4")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[_builtins.str]:
        """
        The flavor ID.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> Optional[_builtins.str]:
        """
        The flavor name of the instance.
        """
        return pulumi.get(self, "flavor_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[_builtins.str]:
        """
        The image ID of the instance.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetInstancesInstanceResult']:
        """
        List of ECS instance details. The object structure of each ECS instance is documented below.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[_builtins.str]:
        """
        The key pair that is used to authenticate the instance.
        """
        return pulumi.get(self, "key_pair")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The instance name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The instance status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        The key/value pairs to associate with the instance.
        """
        return pulumi.get(self, "tags")


class AwaitableGetInstancesResult(GetInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetInstancesResult(
            availability_zone=self.availability_zone,
            enterprise_project_id=self.enterprise_project_id,
            fixed_ip_v4=self.fixed_ip_v4,
            flavor_id=self.flavor_id,
            flavor_name=self.flavor_name,
            id=self.id,
            image_id=self.image_id,
            instance_id=self.instance_id,
            instances=self.instances,
            key_pair=self.key_pair,
            name=self.name,
            region=self.region,
            status=self.status,
            tags=self.tags)


def get_instances(availability_zone: Optional[_builtins.str] = None,
                  enterprise_project_id: Optional[_builtins.str] = None,
                  fixed_ip_v4: Optional[_builtins.str] = None,
                  flavor_id: Optional[_builtins.str] = None,
                  flavor_name: Optional[_builtins.str] = None,
                  image_id: Optional[_builtins.str] = None,
                  instance_id: Optional[_builtins.str] = None,
                  key_pair: Optional[_builtins.str] = None,
                  name: Optional[_builtins.str] = None,
                  region: Optional[_builtins.str] = None,
                  status: Optional[_builtins.str] = None,
                  tags: Optional[Mapping[str, _builtins.str]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetInstancesResult:
    """
    Use this data source to get the list of the compute instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    name_regex = config.require_object("nameRegex")
    test = sbercloud.Ecs.get_instances(name=name_regex)
    ```


    :param _builtins.str availability_zone: Specifies the availability zone where the instance is located.
           Please following [reference](https://support.hc.sbercloud.ru/endpoint/index.html) for this argument.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID.
    :param _builtins.str fixed_ip_v4: The fixed IPv4 address of the instance on this network.
    :param _builtins.str flavor_id: Specifies the flavor ID.
    :param _builtins.str flavor_name: Specifies the flavor name of the instance.
    :param _builtins.str image_id: Specifies the image ID of the instance.
    :param _builtins.str instance_id: Specifies the ECS ID.
    :param _builtins.str key_pair: Specifies the key pair that is used to authenticate the instance.
    :param _builtins.str name: Specifies the instance name, which can be queried with a regular expression.
           The instance name supports fuzzy matching query too.
    :param _builtins.str region: Specifies the region in which to obtain the instances.
           If omitted, the provider-level region will be used.
    :param _builtins.str status: Specifies the status of the instance. The valid values are as follows:
           + **ACTIVE**: The instance is running properly.
           + **SHUTOFF**: The instance has been properly stopped.
           + **ERROR**: An error has occurred on the instance.
    :param Mapping[str, _builtins.str] tags: The key/value pairs to associate with the instance.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['fixedIpV4'] = fixed_ip_v4
    __args__['flavorId'] = flavor_id
    __args__['flavorName'] = flavor_name
    __args__['imageId'] = image_id
    __args__['instanceId'] = instance_id
    __args__['keyPair'] = key_pair
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Ecs/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult).value

    return AwaitableGetInstancesResult(
        availability_zone=pulumi.get(__ret__, 'availability_zone'),
        enterprise_project_id=pulumi.get(__ret__, 'enterprise_project_id'),
        fixed_ip_v4=pulumi.get(__ret__, 'fixed_ip_v4'),
        flavor_id=pulumi.get(__ret__, 'flavor_id'),
        flavor_name=pulumi.get(__ret__, 'flavor_name'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        instances=pulumi.get(__ret__, 'instances'),
        key_pair=pulumi.get(__ret__, 'key_pair'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'))
def get_instances_output(availability_zone: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         enterprise_project_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         fixed_ip_v4: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         flavor_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         flavor_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         image_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         instance_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         key_pair: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         status: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                         tags: Optional[pulumi.Input[Optional[Mapping[str, _builtins.str]]]] = None,
                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetInstancesResult]:
    """
    Use this data source to get the list of the compute instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    name_regex = config.require_object("nameRegex")
    test = sbercloud.Ecs.get_instances(name=name_regex)
    ```


    :param _builtins.str availability_zone: Specifies the availability zone where the instance is located.
           Please following [reference](https://support.hc.sbercloud.ru/endpoint/index.html) for this argument.
    :param _builtins.str enterprise_project_id: Specifies the enterprise project ID.
    :param _builtins.str fixed_ip_v4: The fixed IPv4 address of the instance on this network.
    :param _builtins.str flavor_id: Specifies the flavor ID.
    :param _builtins.str flavor_name: Specifies the flavor name of the instance.
    :param _builtins.str image_id: Specifies the image ID of the instance.
    :param _builtins.str instance_id: Specifies the ECS ID.
    :param _builtins.str key_pair: Specifies the key pair that is used to authenticate the instance.
    :param _builtins.str name: Specifies the instance name, which can be queried with a regular expression.
           The instance name supports fuzzy matching query too.
    :param _builtins.str region: Specifies the region in which to obtain the instances.
           If omitted, the provider-level region will be used.
    :param _builtins.str status: Specifies the status of the instance. The valid values are as follows:
           + **ACTIVE**: The instance is running properly.
           + **SHUTOFF**: The instance has been properly stopped.
           + **ERROR**: An error has occurred on the instance.
    :param Mapping[str, _builtins.str] tags: The key/value pairs to associate with the instance.
    """
    __args__ = dict()
    __args__['availabilityZone'] = availability_zone
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['fixedIpV4'] = fixed_ip_v4
    __args__['flavorId'] = flavor_id
    __args__['flavorName'] = flavor_name
    __args__['imageId'] = image_id
    __args__['instanceId'] = instance_id
    __args__['keyPair'] = key_pair
    __args__['name'] = name
    __args__['region'] = region
    __args__['status'] = status
    __args__['tags'] = tags
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Ecs/getInstances:getInstances', __args__, opts=opts, typ=GetInstancesResult)
    return __ret__.apply(lambda __response__: GetInstancesResult(
        availability_zone=pulumi.get(__response__, 'availability_zone'),
        enterprise_project_id=pulumi.get(__response__, 'enterprise_project_id'),
        fixed_ip_v4=pulumi.get(__response__, 'fixed_ip_v4'),
        flavor_id=pulumi.get(__response__, 'flavor_id'),
        flavor_name=pulumi.get(__response__, 'flavor_name'),
        id=pulumi.get(__response__, 'id'),
        image_id=pulumi.get(__response__, 'image_id'),
        instance_id=pulumi.get(__response__, 'instance_id'),
        instances=pulumi.get(__response__, 'instances'),
        key_pair=pulumi.get(__response__, 'key_pair'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        status=pulumi.get(__response__, 'status'),
        tags=pulumi.get(__response__, 'tags')))
