# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetServergroupsResult',
    'AwaitableGetServergroupsResult',
    'get_servergroups',
    'get_servergroups_output',
]

@pulumi.output_type
class GetServergroupsResult:
    """
    A collection of values returned by getServergroups.
    """
    def __init__(__self__, id=None, name=None, region=None, servergroups=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if servergroups and not isinstance(servergroups, list):
            raise TypeError("Expected argument 'servergroups' to be a list")
        pulumi.set(__self__, "servergroups", servergroups)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The server group name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def servergroups(self) -> Sequence['outputs.GetServergroupsServergroupResult']:
        """
        List of ECS server groups details. The object structure of each server group is documented below.
        """
        return pulumi.get(self, "servergroups")


class AwaitableGetServergroupsResult(GetServergroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetServergroupsResult(
            id=self.id,
            name=self.name,
            region=self.region,
            servergroups=self.servergroups)


def get_servergroups(name: Optional[_builtins.str] = None,
                     region: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetServergroupsResult:
    """
    Use this data source to get the list of the compute server groups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    name = config.require_object("name")
    test = sbercloud.Ecs.get_servergroups(name=name)
    ```


    :param _builtins.str name: Specifies the server group name.
    :param _builtins.str region: Specifies the region in which to obtain the server groups.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('sbercloud:Ecs/getServergroups:getServergroups', __args__, opts=opts, typ=GetServergroupsResult).value

    return AwaitableGetServergroupsResult(
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        servergroups=pulumi.get(__ret__, 'servergroups'))
def get_servergroups_output(name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetServergroupsResult]:
    """
    Use this data source to get the list of the compute server groups.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_sbercloud as sbercloud

    config = pulumi.Config()
    name = config.require_object("name")
    test = sbercloud.Ecs.get_servergroups(name=name)
    ```


    :param _builtins.str name: Specifies the server group name.
    :param _builtins.str region: Specifies the region in which to obtain the server groups.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('sbercloud:Ecs/getServergroups:getServergroups', __args__, opts=opts, typ=GetServergroupsResult)
    return __ret__.apply(lambda __response__: GetServergroupsResult(
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        region=pulumi.get(__response__, 'region'),
        servergroups=pulumi.get(__response__, 'servergroups')))
