# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 networks: pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]],
                 admin_pass: Optional[pulumi.Input[_builtins.str]] = None,
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_list: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_terminate_time: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input['InstanceBandwidthArgs']] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]] = None,
                 delete_disks_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_eip_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 power_action: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler_hints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSchedulerHintArgs']]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_duration_count: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_maximum_price: Optional[pulumi.Input[_builtins.str]] = None,
                 stop_before_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_dss_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]] networks: Specifies an array of one or more networks to attach to the instance. The
               network object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] admin_pass: Specifies the administrative password to assign to the instance.
        :param pulumi.Input[_builtins.str] agency_name: Specifies the IAM agency name which is created on IAM to provide
               temporary credentials for ECS to access cloud services.
        :param pulumi.Input[_builtins.str] agent_list: Specifies the agent list in comma-separated string.
               Available agents are:
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the availability zone in which to create the instance.
               Changing this creates a new instance.
        :param pulumi.Input['InstanceBandwidthArgs'] bandwidth: Specifies the bandwidth of an EIP that will be automatically assigned to the instance.
               The object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]] data_disks: Specifies an array of one or more data disks to attach to the instance.
               The data_disks object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[_builtins.bool] delete_disks_on_termination: Specifies whether to delete the data disks when the instance is terminated.
               Defaults to *false*. This parameter is valid if `charging_mode` is set to *postPaid*, and all data disks will be deleted
               in *prePaid* charging mode.
        :param pulumi.Input[_builtins.bool] delete_eip_on_termination: Specifies whether the EIP is released when the instance is terminated.
               Defaults to *true*.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the instance. The description consists of 0 to 85
               characters, and can't contain '<' or '>'.
        :param pulumi.Input[_builtins.str] eip_id: Specifies the ID of an *existing* EIP assigned to the instance.
               This parameter and `eip_type`, `bandwidth` are alternative. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] eip_type: Specifies the type of an EIP that will be automatically assigned to the instance.
               Available values are *5_bgp* (dynamic BGP) and *5_sbgp* (static BGP). Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies a unique id in UUID format of enterprise project.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the flavor ID of the instance to be created.
        :param pulumi.Input[_builtins.str] flavor_name: The flavor name of the instance.
        :param pulumi.Input[_builtins.str] image_id: Required if `image_name` is empty. Specifies the image ID of the desired
               image for the instance. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] image_name: Required if `image_id` is empty. Specifies the name of the desired image
               for the instance. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] key_pair: Specifies the SSH keypair name used for logging in to the instance.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name for the instance. The name consists of 1 to 64 characters,
               including letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[_builtins.str] power_action: Specifies the power action to be done for the instance.
               The valid values are *ON*, *OFF*, *REBOOT*, *FORCE-OFF* and *FORCE-REBOOT*.
               
               > **NOTE:** The `power_action` is a one-time action.
        :param pulumi.Input[_builtins.str] private_key: Specifies the the private key of the keypair in use. This parameter is mandatory
               when replacing or unbinding a keypair and the instance is in **Running** state.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the instance.
               If omitted, the provider-level region will be used. Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceSchedulerHintArgs']]] scheduler_hints: Specifies the scheduler with hints on how the instance should be launched. The
               available hints are described below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: Specifies an array of one or more security group IDs to associate with the
               instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: An array of one or more security groups to associate with the instance.
        :param pulumi.Input[_builtins.bool] stop_before_destroy: Specifies whether to try stop instance gracefully before destroying it, thus giving
               chance for guest OS daemons to stop correctly. If instance doesn't stop within timeout, it will be destroyed anyway.
        :param pulumi.Input[_builtins.int] system_disk_size: Specifies the system disk size in GB, The value range is 1 to 1024.
               Shrinking the disk is not supported.
        :param pulumi.Input[_builtins.str] system_disk_type: Specifies the system disk type of the instance. Defaults to `GPSSD`.
               Changing this creates a new instance.
               
               Available options are:
               + `SAS`: high I/O disk type.
               + `SSD`: ultra-high I/O disk type.
               + `ESSD`: Extreme SSD type.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the instance.
        :param pulumi.Input[_builtins.str] user_data: Specifies the user data to be injected during the instance creation. Text
               and text files can be injected. Changing this creates a new instance.
               
               > **NOTE:** If the `user_data` field is specified for a Linux ECS that is created using an image with Cloud-Init
               installed, the `admin_pass` field becomes invalid.
        :param pulumi.Input[_builtins.str] user_id: Specifies a user ID, required when using key_pair in prePaid charging mode.
               Changing this creates a new instance.
        """
        pulumi.set(__self__, "networks", networks)
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if agency_name is not None:
            pulumi.set(__self__, "agency_name", agency_name)
        if agent_list is not None:
            pulumi.set(__self__, "agent_list", agent_list)
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_terminate_time is not None:
            pulumi.set(__self__, "auto_terminate_time", auto_terminate_time)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if delete_disks_on_termination is not None:
            pulumi.set(__self__, "delete_disks_on_termination", delete_disks_on_termination)
        if delete_eip_on_termination is not None:
            pulumi.set(__self__, "delete_eip_on_termination", delete_eip_on_termination)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if eip_type is not None:
            pulumi.set(__self__, "eip_type", eip_type)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if flavor_name is not None:
            pulumi.set(__self__, "flavor_name", flavor_name)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if power_action is not None:
            pulumi.set(__self__, "power_action", power_action)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scheduler_hints is not None:
            pulumi.set(__self__, "scheduler_hints", scheduler_hints)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if spot_duration is not None:
            pulumi.set(__self__, "spot_duration", spot_duration)
        if spot_duration_count is not None:
            pulumi.set(__self__, "spot_duration_count", spot_duration_count)
        if spot_maximum_price is not None:
            pulumi.set(__self__, "spot_maximum_price", spot_maximum_price)
        if stop_before_destroy is not None:
            pulumi.set(__self__, "stop_before_destroy", stop_before_destroy)
        if system_disk_dss_pool_id is not None:
            pulumi.set(__self__, "system_disk_dss_pool_id", system_disk_dss_pool_id)
        if system_disk_iops is not None:
            pulumi.set(__self__, "system_disk_iops", system_disk_iops)
        if system_disk_kms_key_id is not None:
            pulumi.set(__self__, "system_disk_kms_key_id", system_disk_kms_key_id)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if system_disk_throughput is not None:
            pulumi.set(__self__, "system_disk_throughput", system_disk_throughput)
        if system_disk_type is not None:
            pulumi.set(__self__, "system_disk_type", system_disk_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]:
        """
        Specifies an array of one or more networks to attach to the instance. The
        network object structure is documented below. Changing this creates a new instance.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the administrative password to assign to the instance.
        """
        return pulumi.get(self, "admin_pass")

    @admin_pass.setter
    def admin_pass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_pass", value)

    @_builtins.property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IAM agency name which is created on IAM to provide
        temporary credentials for ECS to access cloud services.
        """
        return pulumi.get(self, "agency_name")

    @agency_name.setter
    def agency_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agency_name", value)

    @_builtins.property
    @pulumi.getter(name="agentList")
    def agent_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the agent list in comma-separated string.
        Available agents are:
        """
        return pulumi.get(self, "agent_list")

    @agent_list.setter
    def agent_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_list", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoTerminateTime")
    def auto_terminate_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_terminate_time")

    @auto_terminate_time.setter
    def auto_terminate_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_terminate_time", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the availability zone in which to create the instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input['InstanceBandwidthArgs']]:
        """
        Specifies the bandwidth of an EIP that will be automatically assigned to the instance.
        The object structure is documented below. Changing this creates a new instance.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input['InstanceBandwidthArgs']]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]:
        """
        Specifies an array of one or more data disks to attach to the instance.
        The data_disks object structure is documented below. Changing this creates a new instance.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="deleteDisksOnTermination")
    def delete_disks_on_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to delete the data disks when the instance is terminated.
        Defaults to *false*. This parameter is valid if `charging_mode` is set to *postPaid*, and all data disks will be deleted
        in *prePaid* charging mode.
        """
        return pulumi.get(self, "delete_disks_on_termination")

    @delete_disks_on_termination.setter
    def delete_disks_on_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_disks_on_termination", value)

    @_builtins.property
    @pulumi.getter(name="deleteEipOnTermination")
    def delete_eip_on_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the EIP is released when the instance is terminated.
        Defaults to *true*.
        """
        return pulumi.get(self, "delete_eip_on_termination")

    @delete_eip_on_termination.setter
    def delete_eip_on_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_eip_on_termination", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the instance. The description consists of 0 to 85
        characters, and can't contain '<' or '>'.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of an *existing* EIP assigned to the instance.
        This parameter and `eip_type`, `bandwidth` are alternative. Changing this creates a new instance.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eip_id", value)

    @_builtins.property
    @pulumi.getter(name="eipType")
    def eip_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of an EIP that will be automatically assigned to the instance.
        Available values are *5_bgp* (dynamic BGP) and *5_sbgp* (static BGP). Changing this creates a new instance.
        """
        return pulumi.get(self, "eip_type")

    @eip_type.setter
    def eip_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eip_type", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a unique id in UUID format of enterprise project.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the flavor ID of the instance to be created.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The flavor name of the instance.
        """
        return pulumi.get(self, "flavor_name")

    @flavor_name.setter
    def flavor_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_name", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required if `image_name` is empty. Specifies the image ID of the desired
        image for the instance. Changing this creates a new instance.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required if `image_id` is empty. Specifies the name of the desired image
        for the instance. Changing this creates a new instance.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SSH keypair name used for logging in to the instance.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a unique name for the instance. The name consists of 1 to 64 characters,
        including letters, digits, underscores (_), hyphens (-), and periods (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="powerAction")
    def power_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the power action to be done for the instance.
        The valid values are *ON*, *OFF*, *REBOOT*, *FORCE-OFF* and *FORCE-REBOOT*.

        > **NOTE:** The `power_action` is a one-time action.
        """
        return pulumi.get(self, "power_action")

    @power_action.setter
    def power_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "power_action", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the the private key of the keypair in use. This parameter is mandatory
        when replacing or unbinding a keypair and the instance is in **Running** state.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the instance.
        If omitted, the provider-level region will be used. Changing this creates a new instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schedulerHints")
    def scheduler_hints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSchedulerHintArgs']]]]:
        """
        Specifies the scheduler with hints on how the instance should be launched. The
        available hints are described below.
        """
        return pulumi.get(self, "scheduler_hints")

    @scheduler_hints.setter
    def scheduler_hints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSchedulerHintArgs']]]]):
        pulumi.set(self, "scheduler_hints", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies an array of one or more security group IDs to associate with the
        instance.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of one or more security groups to associate with the instance.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter(name="spotDuration")
    def spot_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "spot_duration")

    @spot_duration.setter
    def spot_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_duration", value)

    @_builtins.property
    @pulumi.getter(name="spotDurationCount")
    def spot_duration_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "spot_duration_count")

    @spot_duration_count.setter
    def spot_duration_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_duration_count", value)

    @_builtins.property
    @pulumi.getter(name="spotMaximumPrice")
    def spot_maximum_price(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "spot_maximum_price")

    @spot_maximum_price.setter
    def spot_maximum_price(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_maximum_price", value)

    @_builtins.property
    @pulumi.getter(name="stopBeforeDestroy")
    def stop_before_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to try stop instance gracefully before destroying it, thus giving
        chance for guest OS daemons to stop correctly. If instance doesn't stop within timeout, it will be destroyed anyway.
        """
        return pulumi.get(self, "stop_before_destroy")

    @stop_before_destroy.setter
    def stop_before_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stop_before_destroy", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskDssPoolId")
    def system_disk_dss_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "system_disk_dss_pool_id")

    @system_disk_dss_pool_id.setter
    def system_disk_dss_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_dss_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskIops")
    def system_disk_iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "system_disk_iops")

    @system_disk_iops.setter
    def system_disk_iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_iops", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskKmsKeyId")
    def system_disk_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "system_disk_kms_key_id")

    @system_disk_kms_key_id.setter
    def system_disk_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the system disk size in GB, The value range is 1 to 1024.
        Shrinking the disk is not supported.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskThroughput")
    def system_disk_throughput(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "system_disk_throughput")

    @system_disk_throughput.setter
    def system_disk_throughput(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_throughput", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskType")
    def system_disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the system disk type of the instance. Defaults to `GPSSD`.
        Changing this creates a new instance.

        Available options are:
        + `SAS`: high I/O disk type.
        + `SSD`: ultra-high I/O disk type.
        + `ESSD`: Extreme SSD type.
        """
        return pulumi.get(self, "system_disk_type")

    @system_disk_type.setter
    def system_disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the user data to be injected during the instance creation. Text
        and text files can be injected. Changing this creates a new instance.

        > **NOTE:** If the `user_data` field is specified for a Linux ECS that is created using an image with Cloud-Init
        installed, the `admin_pass` field becomes invalid.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a user ID, required when using key_pair in prePaid charging mode.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 access_ip_v4: Optional[pulumi.Input[_builtins.str]] = None,
                 access_ip_v6: Optional[pulumi.Input[_builtins.str]] = None,
                 admin_pass: Optional[pulumi.Input[_builtins.str]] = None,
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_list: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_terminate_time: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input['InstanceBandwidthArgs']] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 created_at: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]] = None,
                 delete_disks_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_eip_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 expired_time: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 power_action: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler_hints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSchedulerHintArgs']]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_duration_count: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_maximum_price: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 stop_before_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_dss_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 updated_at: Optional[pulumi.Input[_builtins.str]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 volume_attacheds: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceVolumeAttachedArgs']]]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[_builtins.str] access_ip_v4: The first detected Fixed IPv4 address or the Floating IP.
        :param pulumi.Input[_builtins.str] access_ip_v6: The first detected Fixed IPv6 address.
        :param pulumi.Input[_builtins.str] admin_pass: Specifies the administrative password to assign to the instance.
        :param pulumi.Input[_builtins.str] agency_name: Specifies the IAM agency name which is created on IAM to provide
               temporary credentials for ECS to access cloud services.
        :param pulumi.Input[_builtins.str] agent_list: Specifies the agent list in comma-separated string.
               Available agents are:
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the availability zone in which to create the instance.
               Changing this creates a new instance.
        :param pulumi.Input['InstanceBandwidthArgs'] bandwidth: Specifies the bandwidth of an EIP that will be automatically assigned to the instance.
               The object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] created_at: The creation time, in UTC format.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]] data_disks: Specifies an array of one or more data disks to attach to the instance.
               The data_disks object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[_builtins.bool] delete_disks_on_termination: Specifies whether to delete the data disks when the instance is terminated.
               Defaults to *false*. This parameter is valid if `charging_mode` is set to *postPaid*, and all data disks will be deleted
               in *prePaid* charging mode.
        :param pulumi.Input[_builtins.bool] delete_eip_on_termination: Specifies whether the EIP is released when the instance is terminated.
               Defaults to *true*.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the instance. The description consists of 0 to 85
               characters, and can't contain '<' or '>'.
        :param pulumi.Input[_builtins.str] eip_id: Specifies the ID of an *existing* EIP assigned to the instance.
               This parameter and `eip_type`, `bandwidth` are alternative. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] eip_type: Specifies the type of an EIP that will be automatically assigned to the instance.
               Available values are *5_bgp* (dynamic BGP) and *5_sbgp* (static BGP). Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies a unique id in UUID format of enterprise project.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the flavor ID of the instance to be created.
        :param pulumi.Input[_builtins.str] flavor_name: The flavor name of the instance.
        :param pulumi.Input[_builtins.str] image_id: Required if `image_name` is empty. Specifies the image ID of the desired
               image for the instance. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] image_name: Required if `image_id` is empty. Specifies the name of the desired image
               for the instance. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] key_pair: Specifies the SSH keypair name used for logging in to the instance.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name for the instance. The name consists of 1 to 64 characters,
               including letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]] networks: Specifies an array of one or more networks to attach to the instance. The
               network object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] power_action: Specifies the power action to be done for the instance.
               The valid values are *ON*, *OFF*, *REBOOT*, *FORCE-OFF* and *FORCE-REBOOT*.
               
               > **NOTE:** The `power_action` is a one-time action.
        :param pulumi.Input[_builtins.str] private_key: Specifies the the private key of the keypair in use. This parameter is mandatory
               when replacing or unbinding a keypair and the instance is in **Running** state.
        :param pulumi.Input[_builtins.str] public_ip: The EIP address that is associted to the instance.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the instance.
               If omitted, the provider-level region will be used. Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceSchedulerHintArgs']]] scheduler_hints: Specifies the scheduler with hints on how the instance should be launched. The
               available hints are described below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: Specifies an array of one or more security group IDs to associate with the
               instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: An array of one or more security groups to associate with the instance.
        :param pulumi.Input[_builtins.str] status: The status of the instance.
        :param pulumi.Input[_builtins.bool] stop_before_destroy: Specifies whether to try stop instance gracefully before destroying it, thus giving
               chance for guest OS daemons to stop correctly. If instance doesn't stop within timeout, it will be destroyed anyway.
        :param pulumi.Input[_builtins.str] system_disk_id: The system disk voume ID.
        :param pulumi.Input[_builtins.int] system_disk_size: Specifies the system disk size in GB, The value range is 1 to 1024.
               Shrinking the disk is not supported.
        :param pulumi.Input[_builtins.str] system_disk_type: Specifies the system disk type of the instance. Defaults to `GPSSD`.
               Changing this creates a new instance.
               
               Available options are:
               + `SAS`: high I/O disk type.
               + `SSD`: ultra-high I/O disk type.
               + `ESSD`: Extreme SSD type.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the instance.
        :param pulumi.Input[_builtins.str] updated_at: The last update time, in UTC format.
        :param pulumi.Input[_builtins.str] user_data: Specifies the user data to be injected during the instance creation. Text
               and text files can be injected. Changing this creates a new instance.
               
               > **NOTE:** If the `user_data` field is specified for a Linux ECS that is created using an image with Cloud-Init
               installed, the `admin_pass` field becomes invalid.
        :param pulumi.Input[_builtins.str] user_id: Specifies a user ID, required when using key_pair in prePaid charging mode.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceVolumeAttachedArgs']]] volume_attacheds: An array of one or more disks to attach to the instance.
               The volume attached object structure is documented below.
        """
        if access_ip_v4 is not None:
            pulumi.set(__self__, "access_ip_v4", access_ip_v4)
        if access_ip_v6 is not None:
            pulumi.set(__self__, "access_ip_v6", access_ip_v6)
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if agency_name is not None:
            pulumi.set(__self__, "agency_name", agency_name)
        if agent_list is not None:
            pulumi.set(__self__, "agent_list", agent_list)
        if auto_pay is not None:
            warnings.warn("""Deprecated""", DeprecationWarning)
            pulumi.log.warn("""auto_pay is deprecated: Deprecated""")
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if auto_terminate_time is not None:
            pulumi.set(__self__, "auto_terminate_time", auto_terminate_time)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if data_disks is not None:
            pulumi.set(__self__, "data_disks", data_disks)
        if delete_disks_on_termination is not None:
            pulumi.set(__self__, "delete_disks_on_termination", delete_disks_on_termination)
        if delete_eip_on_termination is not None:
            pulumi.set(__self__, "delete_eip_on_termination", delete_eip_on_termination)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if eip_type is not None:
            pulumi.set(__self__, "eip_type", eip_type)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if flavor_id is not None:
            pulumi.set(__self__, "flavor_id", flavor_id)
        if flavor_name is not None:
            pulumi.set(__self__, "flavor_name", flavor_name)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if image_id is not None:
            pulumi.set(__self__, "image_id", image_id)
        if image_name is not None:
            pulumi.set(__self__, "image_name", image_name)
        if key_pair is not None:
            pulumi.set(__self__, "key_pair", key_pair)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if networks is not None:
            pulumi.set(__self__, "networks", networks)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if power_action is not None:
            pulumi.set(__self__, "power_action", power_action)
        if private_key is not None:
            pulumi.set(__self__, "private_key", private_key)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scheduler_hints is not None:
            pulumi.set(__self__, "scheduler_hints", scheduler_hints)
        if security_group_ids is not None:
            pulumi.set(__self__, "security_group_ids", security_group_ids)
        if security_groups is not None:
            pulumi.set(__self__, "security_groups", security_groups)
        if spot_duration is not None:
            pulumi.set(__self__, "spot_duration", spot_duration)
        if spot_duration_count is not None:
            pulumi.set(__self__, "spot_duration_count", spot_duration_count)
        if spot_maximum_price is not None:
            pulumi.set(__self__, "spot_maximum_price", spot_maximum_price)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stop_before_destroy is not None:
            pulumi.set(__self__, "stop_before_destroy", stop_before_destroy)
        if system_disk_dss_pool_id is not None:
            pulumi.set(__self__, "system_disk_dss_pool_id", system_disk_dss_pool_id)
        if system_disk_id is not None:
            pulumi.set(__self__, "system_disk_id", system_disk_id)
        if system_disk_iops is not None:
            pulumi.set(__self__, "system_disk_iops", system_disk_iops)
        if system_disk_kms_key_id is not None:
            pulumi.set(__self__, "system_disk_kms_key_id", system_disk_kms_key_id)
        if system_disk_size is not None:
            pulumi.set(__self__, "system_disk_size", system_disk_size)
        if system_disk_throughput is not None:
            pulumi.set(__self__, "system_disk_throughput", system_disk_throughput)
        if system_disk_type is not None:
            pulumi.set(__self__, "system_disk_type", system_disk_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)
        if volume_attacheds is not None:
            pulumi.set(__self__, "volume_attacheds", volume_attacheds)

    @_builtins.property
    @pulumi.getter(name="accessIpV4")
    def access_ip_v4(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first detected Fixed IPv4 address or the Floating IP.
        """
        return pulumi.get(self, "access_ip_v4")

    @access_ip_v4.setter
    def access_ip_v4(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_ip_v4", value)

    @_builtins.property
    @pulumi.getter(name="accessIpV6")
    def access_ip_v6(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The first detected Fixed IPv6 address.
        """
        return pulumi.get(self, "access_ip_v6")

    @access_ip_v6.setter
    def access_ip_v6(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_ip_v6", value)

    @_builtins.property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the administrative password to assign to the instance.
        """
        return pulumi.get(self, "admin_pass")

    @admin_pass.setter
    def admin_pass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "admin_pass", value)

    @_builtins.property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the IAM agency name which is created on IAM to provide
        temporary credentials for ECS to access cloud services.
        """
        return pulumi.get(self, "agency_name")

    @agency_name.setter
    def agency_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agency_name", value)

    @_builtins.property
    @pulumi.getter(name="agentList")
    def agent_list(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the agent list in comma-separated string.
        Available agents are:
        """
        return pulumi.get(self, "agent_list")

    @agent_list.setter
    def agent_list(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_list", value)

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_pay", value)

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_renew", value)

    @_builtins.property
    @pulumi.getter(name="autoTerminateTime")
    def auto_terminate_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "auto_terminate_time")

    @auto_terminate_time.setter
    def auto_terminate_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "auto_terminate_time", value)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the availability zone in which to create the instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "availability_zone", value)

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input['InstanceBandwidthArgs']]:
        """
        Specifies the bandwidth of an EIP that will be automatically assigned to the instance.
        The object structure is documented below. Changing this creates a new instance.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input['InstanceBandwidthArgs']]):
        pulumi.set(self, "bandwidth", value)

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "charging_mode", value)

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation time, in UTC format.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "created_at", value)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]:
        """
        Specifies an array of one or more data disks to attach to the instance.
        The data_disks object structure is documented below. Changing this creates a new instance.
        """
        return pulumi.get(self, "data_disks")

    @data_disks.setter
    def data_disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceDataDiskArgs']]]]):
        pulumi.set(self, "data_disks", value)

    @_builtins.property
    @pulumi.getter(name="deleteDisksOnTermination")
    def delete_disks_on_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to delete the data disks when the instance is terminated.
        Defaults to *false*. This parameter is valid if `charging_mode` is set to *postPaid*, and all data disks will be deleted
        in *prePaid* charging mode.
        """
        return pulumi.get(self, "delete_disks_on_termination")

    @delete_disks_on_termination.setter
    def delete_disks_on_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_disks_on_termination", value)

    @_builtins.property
    @pulumi.getter(name="deleteEipOnTermination")
    def delete_eip_on_termination(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether the EIP is released when the instance is terminated.
        Defaults to *true*.
        """
        return pulumi.get(self, "delete_eip_on_termination")

    @delete_eip_on_termination.setter
    def delete_eip_on_termination(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "delete_eip_on_termination", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the description of the instance. The description consists of 0 to 85
        characters, and can't contain '<' or '>'.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the ID of an *existing* EIP assigned to the instance.
        This parameter and `eip_type`, `bandwidth` are alternative. Changing this creates a new instance.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eip_id", value)

    @_builtins.property
    @pulumi.getter(name="eipType")
    def eip_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of an EIP that will be automatically assigned to the instance.
        Available values are *5_bgp* (dynamic BGP) and *5_sbgp* (static BGP). Changing this creates a new instance.
        """
        return pulumi.get(self, "eip_type")

    @eip_type.setter
    def eip_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eip_type", value)

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a unique id in UUID format of enterprise project.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "expired_time")

    @expired_time.setter
    def expired_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expired_time", value)

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the flavor ID of the instance to be created.
        """
        return pulumi.get(self, "flavor_id")

    @flavor_id.setter
    def flavor_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_id", value)

    @_builtins.property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The flavor name of the instance.
        """
        return pulumi.get(self, "flavor_name")

    @flavor_name.setter
    def flavor_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "flavor_name", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required if `image_name` is empty. Specifies the image ID of the desired
        image for the instance. Changing this creates a new instance.
        """
        return pulumi.get(self, "image_id")

    @image_id.setter
    def image_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_id", value)

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required if `image_id` is empty. Specifies the name of the desired image
        for the instance. Changing this creates a new instance.
        """
        return pulumi.get(self, "image_name")

    @image_name.setter
    def image_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_name", value)

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SSH keypair name used for logging in to the instance.
        """
        return pulumi.get(self, "key_pair")

    @key_pair.setter
    def key_pair(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_pair", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a unique name for the instance. The name consists of 1 to 64 characters,
        including letters, digits, underscores (_), hyphens (-), and periods (.).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]]:
        """
        Specifies an array of one or more networks to attach to the instance. The
        network object structure is documented below. Changing this creates a new instance.
        """
        return pulumi.get(self, "networks")

    @networks.setter
    def networks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNetworkArgs']]]]):
        pulumi.set(self, "networks", value)

    @_builtins.property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "period", value)

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "period_unit", value)

    @_builtins.property
    @pulumi.getter(name="powerAction")
    def power_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the power action to be done for the instance.
        The valid values are *ON*, *OFF*, *REBOOT*, *FORCE-OFF* and *FORCE-REBOOT*.

        > **NOTE:** The `power_action` is a one-time action.
        """
        return pulumi.get(self, "power_action")

    @power_action.setter
    def power_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "power_action", value)

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the the private key of the keypair in use. This parameter is mandatory
        when replacing or unbinding a keypair and the instance is in **Running** state.
        """
        return pulumi.get(self, "private_key")

    @private_key.setter
    def private_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_key", value)

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The EIP address that is associted to the instance.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip", value)

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the region in which to create the instance.
        If omitted, the provider-level region will be used. Changing this creates a new instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "region", value)

    @_builtins.property
    @pulumi.getter(name="schedulerHints")
    def scheduler_hints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSchedulerHintArgs']]]]:
        """
        Specifies the scheduler with hints on how the instance should be launched. The
        available hints are described below.
        """
        return pulumi.get(self, "scheduler_hints")

    @scheduler_hints.setter
    def scheduler_hints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceSchedulerHintArgs']]]]):
        pulumi.set(self, "scheduler_hints", value)

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies an array of one or more security group IDs to associate with the
        instance.
        """
        return pulumi.get(self, "security_group_ids")

    @security_group_ids.setter
    def security_group_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_group_ids", value)

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        An array of one or more security groups to associate with the instance.
        """
        return pulumi.get(self, "security_groups")

    @security_groups.setter
    def security_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "security_groups", value)

    @_builtins.property
    @pulumi.getter(name="spotDuration")
    def spot_duration(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "spot_duration")

    @spot_duration.setter
    def spot_duration(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_duration", value)

    @_builtins.property
    @pulumi.getter(name="spotDurationCount")
    def spot_duration_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "spot_duration_count")

    @spot_duration_count.setter
    def spot_duration_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "spot_duration_count", value)

    @_builtins.property
    @pulumi.getter(name="spotMaximumPrice")
    def spot_maximum_price(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "spot_maximum_price")

    @spot_maximum_price.setter
    def spot_maximum_price(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spot_maximum_price", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter(name="stopBeforeDestroy")
    def stop_before_destroy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether to try stop instance gracefully before destroying it, thus giving
        chance for guest OS daemons to stop correctly. If instance doesn't stop within timeout, it will be destroyed anyway.
        """
        return pulumi.get(self, "stop_before_destroy")

    @stop_before_destroy.setter
    def stop_before_destroy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "stop_before_destroy", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskDssPoolId")
    def system_disk_dss_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "system_disk_dss_pool_id")

    @system_disk_dss_pool_id.setter
    def system_disk_dss_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_dss_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskId")
    def system_disk_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The system disk voume ID.
        """
        return pulumi.get(self, "system_disk_id")

    @system_disk_id.setter
    def system_disk_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_id", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskIops")
    def system_disk_iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "system_disk_iops")

    @system_disk_iops.setter
    def system_disk_iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_iops", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskKmsKeyId")
    def system_disk_kms_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "system_disk_kms_key_id")

    @system_disk_kms_key_id.setter
    def system_disk_kms_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_kms_key_id", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the system disk size in GB, The value range is 1 to 1024.
        Shrinking the disk is not supported.
        """
        return pulumi.get(self, "system_disk_size")

    @system_disk_size.setter
    def system_disk_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_size", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskThroughput")
    def system_disk_throughput(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "system_disk_throughput")

    @system_disk_throughput.setter
    def system_disk_throughput(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "system_disk_throughput", value)

    @_builtins.property
    @pulumi.getter(name="systemDiskType")
    def system_disk_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the system disk type of the instance. Defaults to `GPSSD`.
        Changing this creates a new instance.

        Available options are:
        + `SAS`: high I/O disk type.
        + `SSD`: ultra-high I/O disk type.
        + `ESSD`: Extreme SSD type.
        """
        return pulumi.get(self, "system_disk_type")

    @system_disk_type.setter
    def system_disk_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "system_disk_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies the key/value pairs to associate with the instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last update time, in UTC format.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "updated_at", value)

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the user data to be injected during the instance creation. Text
        and text files can be injected. Changing this creates a new instance.

        > **NOTE:** If the `user_data` field is specified for a Linux ECS that is created using an image with Cloud-Init
        installed, the `admin_pass` field becomes invalid.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_data", value)

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies a user ID, required when using key_pair in prePaid charging mode.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "user_id")

    @user_id.setter
    def user_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "user_id", value)

    @_builtins.property
    @pulumi.getter(name="volumeAttacheds")
    def volume_attacheds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceVolumeAttachedArgs']]]]:
        """
        An array of one or more disks to attach to the instance.
        The volume attached object structure is documented below.
        """
        return pulumi.get(self, "volume_attacheds")

    @volume_attacheds.setter
    def volume_attacheds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceVolumeAttachedArgs']]]]):
        pulumi.set(self, "volume_attacheds", value)


@pulumi.type_token("sbercloud:Ecs/instance:Instance")
class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_pass: Optional[pulumi.Input[_builtins.str]] = None,
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_list: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_terminate_time: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[Union['InstanceBandwidthArgs', 'InstanceBandwidthArgsDict']]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDataDiskArgs', 'InstanceDataDiskArgsDict']]]]] = None,
                 delete_disks_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_eip_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 power_action: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler_hints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceSchedulerHintArgs', 'InstanceSchedulerHintArgsDict']]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_duration_count: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_maximum_price: Optional[pulumi.Input[_builtins.str]] = None,
                 stop_before_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_dss_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a ECS VM instance resource within SberCloud.

        ## Example Usage

        ### Basic Instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        secgroup_id = config.require_object("secgroupId")
        myaz = sbercloud.get_availability_zones()
        myflavor = sbercloud.Ecs.get_flavors(availability_zone=myaz.names[0],
            performance_type="normal",
            cpu_core_count=2,
            memory_size=4)
        mynet = sbercloud.Vpc.get_subnet(name="subnet-default")
        myimage = sbercloud.Ims.get_image(name="Ubuntu 18.04 server 64bit",
            most_recent=True)
        basic = sbercloud.ecs.Instance("basic",
            name="basic",
            image_id=myimage.id,
            flavor_id=myflavor.ids[0],
            security_group_ids=[secgroup_id],
            availability_zone=myaz.names[0],
            networks=[{
                "uuid": mynet.id,
            }])
        ```

        ### Instance With Associated Eip

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        secgroup_id = config.require_object("secgroupId")
        myinstance = sbercloud.ecs.Instance("myinstance",
            name="myinstance",
            image_id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            flavor_id="s6.small.1",
            key_pair="my_key_pair_name",
            security_group_ids=[secgroup_id],
            availability_zone="ru-moscow-1a",
            networks=[{
                "uuid": "55534eaa-533a-419d-9b40-ec427ea7195a",
            }])
        myeip = sbercloud.vpc.Eip("myeip",
            publicip={
                "type": "5_bgp",
            },
            bandwidth={
                "name": "test",
                "size": 8,
                "share_type": "PER",
                "charge_mode": "traffic",
            })
        associated = sbercloud.ecs.EipAssociate("associated",
            public_ip=myeip.address,
            instance_id=myinstance.id)
        ```

        ### Instance With Attached Volume

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        secgroup_id = config.require_object("secgroupId")
        myvolume = sbercloud.evs.Volume("myvolume",
            name="myvolume",
            availability_zone="ru-moscow-1a",
            volume_type="SAS",
            size=10)
        myinstance = sbercloud.ecs.Instance("myinstance",
            name="myinstance",
            image_id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            flavor_id="s6.small.1",
            key_pair="my_key_pair_name",
            security_group_ids=[secgroup_id],
            availability_zone="ru-moscow-1a",
            networks=[{
                "uuid": "55534eaa-533a-419d-9b40-ec427ea7195a",
            }])
        attached = sbercloud.ecs.VolumeAttach("attached",
            instance_id=myinstance.id,
            volume_id=myvolume.id)
        ```

        ### Instance With Multiple Data Disks

        It's possible to specify multiple `data_disks` entries to create an instance with multiple data disks, but we can't
        ensure the volume attached order. So it's recommended to use `Instance With Attached Volume` above.

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        secgroup_id = config.require_object("secgroupId")
        multi_disk = sbercloud.ecs.Instance("multi-disk",
            name="multi-net",
            image_id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            flavor_id="s6.small.1",
            key_pair="my_key_pair_name",
            security_group_ids=[secgroup_id],
            availability_zone="ru-moscow-1a",
            system_disk_type="SAS",
            system_disk_size=40,
            data_disks=[
                {
                    "type": "SAS",
                    "size": 10,
                },
                {
                    "type": "SAS",
                    "size": 20,
                },
            ],
            delete_disks_on_termination=True,
            networks=[{
                "uuid": "55534eaa-533a-419d-9b40-ec427ea7195a",
            }])
        ```

        ### Instance With Multiple Networks

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        secgroup_id = config.require_object("secgroupId")
        multi_net = sbercloud.ecs.Instance("multi-net",
            name="multi-net",
            image_id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            flavor_id="s6.small.1",
            key_pair="my_key_pair_name",
            security_group_ids=[secgroup_id],
            availability_zone="ru-moscow-1a",
            networks=[
                {
                    "uuid": "55534eaa-533a-419d-9b40-ec427ea7195a",
                },
                {
                    "uuid": "3c4a0d74-24b9-46cf-9d7f-8b7a4dc2f65c",
                },
            ])
        ```

        ### Instance with User Data (cloud-init)

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        secgroup_id = config.require_object("secgroupId")
        myinstance = sbercloud.ecs.Instance("myinstance",
            name="instance",
            image_id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            flavor_id="s6.small.1",
            key_pair="my_key_pair_name",
            security_group_ids=[secgroup_id],
            availability_zone="ru-moscow-1a",
            user_data=\"\"\"#cloud-config
        hostname: instance_1.example.com
        fqdn: instance_1.example.com\"\"\",
            networks=[{
                "uuid": "55534eaa-533a-419d-9b40-ec427ea7195a",
            }])
        ```

        ## Import

        Instances can be imported by their `id`. For example,

        ```sh
        $ pulumi import sbercloud:Ecs/instance:Instance my_instance b11b407c-e604-4e8d-8bc4-92398320b847
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason.

        The missing attributes include: `admin_pass`, `user_data`, `data_disks`, `scheduler_hints`, `stop_before_destroy`,

        `delete_disks_on_termination`, `delete_eip_on_termination`, `network/access_network`, `bandwidth`, `eip_type`,

        `power_action` and arguments for pre-paid and spot price.

        It is generally recommended running `pulumi preview` after importing an instance.

        You can then decide if changes should be applied to the instance, or the resource definition should be updated to

        align with the instance. Also you can ignore changes as below.

        resource "sbercloud_compute_instance" "myinstance" {

            ...

          lifecycle {

            ignore_changes = [
            
              user_data, data_disks,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] admin_pass: Specifies the administrative password to assign to the instance.
        :param pulumi.Input[_builtins.str] agency_name: Specifies the IAM agency name which is created on IAM to provide
               temporary credentials for ECS to access cloud services.
        :param pulumi.Input[_builtins.str] agent_list: Specifies the agent list in comma-separated string.
               Available agents are:
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the availability zone in which to create the instance.
               Changing this creates a new instance.
        :param pulumi.Input[Union['InstanceBandwidthArgs', 'InstanceBandwidthArgsDict']] bandwidth: Specifies the bandwidth of an EIP that will be automatically assigned to the instance.
               The object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceDataDiskArgs', 'InstanceDataDiskArgsDict']]]] data_disks: Specifies an array of one or more data disks to attach to the instance.
               The data_disks object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[_builtins.bool] delete_disks_on_termination: Specifies whether to delete the data disks when the instance is terminated.
               Defaults to *false*. This parameter is valid if `charging_mode` is set to *postPaid*, and all data disks will be deleted
               in *prePaid* charging mode.
        :param pulumi.Input[_builtins.bool] delete_eip_on_termination: Specifies whether the EIP is released when the instance is terminated.
               Defaults to *true*.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the instance. The description consists of 0 to 85
               characters, and can't contain '<' or '>'.
        :param pulumi.Input[_builtins.str] eip_id: Specifies the ID of an *existing* EIP assigned to the instance.
               This parameter and `eip_type`, `bandwidth` are alternative. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] eip_type: Specifies the type of an EIP that will be automatically assigned to the instance.
               Available values are *5_bgp* (dynamic BGP) and *5_sbgp* (static BGP). Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies a unique id in UUID format of enterprise project.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the flavor ID of the instance to be created.
        :param pulumi.Input[_builtins.str] flavor_name: The flavor name of the instance.
        :param pulumi.Input[_builtins.str] image_id: Required if `image_name` is empty. Specifies the image ID of the desired
               image for the instance. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] image_name: Required if `image_id` is empty. Specifies the name of the desired image
               for the instance. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] key_pair: Specifies the SSH keypair name used for logging in to the instance.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name for the instance. The name consists of 1 to 64 characters,
               including letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]]] networks: Specifies an array of one or more networks to attach to the instance. The
               network object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] power_action: Specifies the power action to be done for the instance.
               The valid values are *ON*, *OFF*, *REBOOT*, *FORCE-OFF* and *FORCE-REBOOT*.
               
               > **NOTE:** The `power_action` is a one-time action.
        :param pulumi.Input[_builtins.str] private_key: Specifies the the private key of the keypair in use. This parameter is mandatory
               when replacing or unbinding a keypair and the instance is in **Running** state.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the instance.
               If omitted, the provider-level region will be used. Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceSchedulerHintArgs', 'InstanceSchedulerHintArgsDict']]]] scheduler_hints: Specifies the scheduler with hints on how the instance should be launched. The
               available hints are described below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: Specifies an array of one or more security group IDs to associate with the
               instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: An array of one or more security groups to associate with the instance.
        :param pulumi.Input[_builtins.bool] stop_before_destroy: Specifies whether to try stop instance gracefully before destroying it, thus giving
               chance for guest OS daemons to stop correctly. If instance doesn't stop within timeout, it will be destroyed anyway.
        :param pulumi.Input[_builtins.int] system_disk_size: Specifies the system disk size in GB, The value range is 1 to 1024.
               Shrinking the disk is not supported.
        :param pulumi.Input[_builtins.str] system_disk_type: Specifies the system disk type of the instance. Defaults to `GPSSD`.
               Changing this creates a new instance.
               
               Available options are:
               + `SAS`: high I/O disk type.
               + `SSD`: ultra-high I/O disk type.
               + `ESSD`: Extreme SSD type.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the instance.
        :param pulumi.Input[_builtins.str] user_data: Specifies the user data to be injected during the instance creation. Text
               and text files can be injected. Changing this creates a new instance.
               
               > **NOTE:** If the `user_data` field is specified for a Linux ECS that is created using an image with Cloud-Init
               installed, the `admin_pass` field becomes invalid.
        :param pulumi.Input[_builtins.str] user_id: Specifies a user ID, required when using key_pair in prePaid charging mode.
               Changing this creates a new instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a ECS VM instance resource within SberCloud.

        ## Example Usage

        ### Basic Instance

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud
        import pulumi_sbercloud as sbercloud

        config = pulumi.Config()
        secgroup_id = config.require_object("secgroupId")
        myaz = sbercloud.get_availability_zones()
        myflavor = sbercloud.Ecs.get_flavors(availability_zone=myaz.names[0],
            performance_type="normal",
            cpu_core_count=2,
            memory_size=4)
        mynet = sbercloud.Vpc.get_subnet(name="subnet-default")
        myimage = sbercloud.Ims.get_image(name="Ubuntu 18.04 server 64bit",
            most_recent=True)
        basic = sbercloud.ecs.Instance("basic",
            name="basic",
            image_id=myimage.id,
            flavor_id=myflavor.ids[0],
            security_group_ids=[secgroup_id],
            availability_zone=myaz.names[0],
            networks=[{
                "uuid": mynet.id,
            }])
        ```

        ### Instance With Associated Eip

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        secgroup_id = config.require_object("secgroupId")
        myinstance = sbercloud.ecs.Instance("myinstance",
            name="myinstance",
            image_id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            flavor_id="s6.small.1",
            key_pair="my_key_pair_name",
            security_group_ids=[secgroup_id],
            availability_zone="ru-moscow-1a",
            networks=[{
                "uuid": "55534eaa-533a-419d-9b40-ec427ea7195a",
            }])
        myeip = sbercloud.vpc.Eip("myeip",
            publicip={
                "type": "5_bgp",
            },
            bandwidth={
                "name": "test",
                "size": 8,
                "share_type": "PER",
                "charge_mode": "traffic",
            })
        associated = sbercloud.ecs.EipAssociate("associated",
            public_ip=myeip.address,
            instance_id=myinstance.id)
        ```

        ### Instance With Attached Volume

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        secgroup_id = config.require_object("secgroupId")
        myvolume = sbercloud.evs.Volume("myvolume",
            name="myvolume",
            availability_zone="ru-moscow-1a",
            volume_type="SAS",
            size=10)
        myinstance = sbercloud.ecs.Instance("myinstance",
            name="myinstance",
            image_id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            flavor_id="s6.small.1",
            key_pair="my_key_pair_name",
            security_group_ids=[secgroup_id],
            availability_zone="ru-moscow-1a",
            networks=[{
                "uuid": "55534eaa-533a-419d-9b40-ec427ea7195a",
            }])
        attached = sbercloud.ecs.VolumeAttach("attached",
            instance_id=myinstance.id,
            volume_id=myvolume.id)
        ```

        ### Instance With Multiple Data Disks

        It's possible to specify multiple `data_disks` entries to create an instance with multiple data disks, but we can't
        ensure the volume attached order. So it's recommended to use `Instance With Attached Volume` above.

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        secgroup_id = config.require_object("secgroupId")
        multi_disk = sbercloud.ecs.Instance("multi-disk",
            name="multi-net",
            image_id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            flavor_id="s6.small.1",
            key_pair="my_key_pair_name",
            security_group_ids=[secgroup_id],
            availability_zone="ru-moscow-1a",
            system_disk_type="SAS",
            system_disk_size=40,
            data_disks=[
                {
                    "type": "SAS",
                    "size": 10,
                },
                {
                    "type": "SAS",
                    "size": 20,
                },
            ],
            delete_disks_on_termination=True,
            networks=[{
                "uuid": "55534eaa-533a-419d-9b40-ec427ea7195a",
            }])
        ```

        ### Instance With Multiple Networks

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        secgroup_id = config.require_object("secgroupId")
        multi_net = sbercloud.ecs.Instance("multi-net",
            name="multi-net",
            image_id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            flavor_id="s6.small.1",
            key_pair="my_key_pair_name",
            security_group_ids=[secgroup_id],
            availability_zone="ru-moscow-1a",
            networks=[
                {
                    "uuid": "55534eaa-533a-419d-9b40-ec427ea7195a",
                },
                {
                    "uuid": "3c4a0d74-24b9-46cf-9d7f-8b7a4dc2f65c",
                },
            ])
        ```

        ### Instance with User Data (cloud-init)

        ```python
        import pulumi
        import pulumi_cloudru as sbercloud

        config = pulumi.Config()
        secgroup_id = config.require_object("secgroupId")
        myinstance = sbercloud.ecs.Instance("myinstance",
            name="instance",
            image_id="ad091b52-742f-469e-8f3c-fd81cadf0743",
            flavor_id="s6.small.1",
            key_pair="my_key_pair_name",
            security_group_ids=[secgroup_id],
            availability_zone="ru-moscow-1a",
            user_data=\"\"\"#cloud-config
        hostname: instance_1.example.com
        fqdn: instance_1.example.com\"\"\",
            networks=[{
                "uuid": "55534eaa-533a-419d-9b40-ec427ea7195a",
            }])
        ```

        ## Import

        Instances can be imported by their `id`. For example,

        ```sh
        $ pulumi import sbercloud:Ecs/instance:Instance my_instance b11b407c-e604-4e8d-8bc4-92398320b847
        ```

        Note that the imported state may not be identical to your resource definition, due to some attributes missing from the

        API response, security or some other reason.

        The missing attributes include: `admin_pass`, `user_data`, `data_disks`, `scheduler_hints`, `stop_before_destroy`,

        `delete_disks_on_termination`, `delete_eip_on_termination`, `network/access_network`, `bandwidth`, `eip_type`,

        `power_action` and arguments for pre-paid and spot price.

        It is generally recommended running `pulumi preview` after importing an instance.

        You can then decide if changes should be applied to the instance, or the resource definition should be updated to

        align with the instance. Also you can ignore changes as below.

        resource "sbercloud_compute_instance" "myinstance" {

            ...

          lifecycle {

            ignore_changes = [
            
              user_data, data_disks,
            
            ]

          }

        }

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_pass: Optional[pulumi.Input[_builtins.str]] = None,
                 agency_name: Optional[pulumi.Input[_builtins.str]] = None,
                 agent_list: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
                 auto_terminate_time: Optional[pulumi.Input[_builtins.str]] = None,
                 availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 bandwidth: Optional[pulumi.Input[Union['InstanceBandwidthArgs', 'InstanceBandwidthArgsDict']]] = None,
                 charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDataDiskArgs', 'InstanceDataDiskArgsDict']]]]] = None,
                 delete_disks_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 delete_eip_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_id: Optional[pulumi.Input[_builtins.str]] = None,
                 eip_type: Optional[pulumi.Input[_builtins.str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
                 flavor_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 image_id: Optional[pulumi.Input[_builtins.str]] = None,
                 image_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_pair: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]]]] = None,
                 period: Optional[pulumi.Input[_builtins.int]] = None,
                 period_unit: Optional[pulumi.Input[_builtins.str]] = None,
                 power_action: Optional[pulumi.Input[_builtins.str]] = None,
                 private_key: Optional[pulumi.Input[_builtins.str]] = None,
                 region: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduler_hints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceSchedulerHintArgs', 'InstanceSchedulerHintArgsDict']]]]] = None,
                 security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 spot_duration: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_duration_count: Optional[pulumi.Input[_builtins.int]] = None,
                 spot_maximum_price: Optional[pulumi.Input[_builtins.str]] = None,
                 stop_before_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
                 system_disk_dss_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_iops: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_throughput: Optional[pulumi.Input[_builtins.int]] = None,
                 system_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 user_data: Optional[pulumi.Input[_builtins.str]] = None,
                 user_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["admin_pass"] = None if admin_pass is None else pulumi.Output.secret(admin_pass)
            __props__.__dict__["agency_name"] = agency_name
            __props__.__dict__["agent_list"] = agent_list
            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["auto_terminate_time"] = auto_terminate_time
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["data_disks"] = data_disks
            __props__.__dict__["delete_disks_on_termination"] = delete_disks_on_termination
            __props__.__dict__["delete_eip_on_termination"] = delete_eip_on_termination
            __props__.__dict__["description"] = description
            __props__.__dict__["eip_id"] = eip_id
            __props__.__dict__["eip_type"] = eip_type
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["flavor_id"] = flavor_id
            __props__.__dict__["flavor_name"] = flavor_name
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["image_id"] = image_id
            __props__.__dict__["image_name"] = image_name
            __props__.__dict__["key_pair"] = key_pair
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["name"] = name
            if networks is None and not opts.urn:
                raise TypeError("Missing required property 'networks'")
            __props__.__dict__["networks"] = networks
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["power_action"] = power_action
            __props__.__dict__["private_key"] = None if private_key is None else pulumi.Output.secret(private_key)
            __props__.__dict__["region"] = region
            __props__.__dict__["scheduler_hints"] = scheduler_hints
            __props__.__dict__["security_group_ids"] = security_group_ids
            __props__.__dict__["security_groups"] = security_groups
            __props__.__dict__["spot_duration"] = spot_duration
            __props__.__dict__["spot_duration_count"] = spot_duration_count
            __props__.__dict__["spot_maximum_price"] = spot_maximum_price
            __props__.__dict__["stop_before_destroy"] = stop_before_destroy
            __props__.__dict__["system_disk_dss_pool_id"] = system_disk_dss_pool_id
            __props__.__dict__["system_disk_iops"] = system_disk_iops
            __props__.__dict__["system_disk_kms_key_id"] = system_disk_kms_key_id
            __props__.__dict__["system_disk_size"] = system_disk_size
            __props__.__dict__["system_disk_throughput"] = system_disk_throughput
            __props__.__dict__["system_disk_type"] = system_disk_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["user_id"] = user_id
            __props__.__dict__["access_ip_v4"] = None
            __props__.__dict__["access_ip_v6"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["expired_time"] = None
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["system_disk_id"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["volume_attacheds"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["adminPass", "privateKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'sbercloud:Ecs/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_ip_v4: Optional[pulumi.Input[_builtins.str]] = None,
            access_ip_v6: Optional[pulumi.Input[_builtins.str]] = None,
            admin_pass: Optional[pulumi.Input[_builtins.str]] = None,
            agency_name: Optional[pulumi.Input[_builtins.str]] = None,
            agent_list: Optional[pulumi.Input[_builtins.str]] = None,
            auto_pay: Optional[pulumi.Input[_builtins.str]] = None,
            auto_renew: Optional[pulumi.Input[_builtins.str]] = None,
            auto_terminate_time: Optional[pulumi.Input[_builtins.str]] = None,
            availability_zone: Optional[pulumi.Input[_builtins.str]] = None,
            bandwidth: Optional[pulumi.Input[Union['InstanceBandwidthArgs', 'InstanceBandwidthArgsDict']]] = None,
            charging_mode: Optional[pulumi.Input[_builtins.str]] = None,
            created_at: Optional[pulumi.Input[_builtins.str]] = None,
            data_disks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceDataDiskArgs', 'InstanceDataDiskArgsDict']]]]] = None,
            delete_disks_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
            delete_eip_on_termination: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            eip_id: Optional[pulumi.Input[_builtins.str]] = None,
            eip_type: Optional[pulumi.Input[_builtins.str]] = None,
            enterprise_project_id: Optional[pulumi.Input[_builtins.str]] = None,
            expired_time: Optional[pulumi.Input[_builtins.str]] = None,
            flavor_id: Optional[pulumi.Input[_builtins.str]] = None,
            flavor_name: Optional[pulumi.Input[_builtins.str]] = None,
            hostname: Optional[pulumi.Input[_builtins.str]] = None,
            image_id: Optional[pulumi.Input[_builtins.str]] = None,
            image_name: Optional[pulumi.Input[_builtins.str]] = None,
            key_pair: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            networks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]]]] = None,
            period: Optional[pulumi.Input[_builtins.int]] = None,
            period_unit: Optional[pulumi.Input[_builtins.str]] = None,
            power_action: Optional[pulumi.Input[_builtins.str]] = None,
            private_key: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip: Optional[pulumi.Input[_builtins.str]] = None,
            region: Optional[pulumi.Input[_builtins.str]] = None,
            scheduler_hints: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceSchedulerHintArgs', 'InstanceSchedulerHintArgsDict']]]]] = None,
            security_group_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            security_groups: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            spot_duration: Optional[pulumi.Input[_builtins.int]] = None,
            spot_duration_count: Optional[pulumi.Input[_builtins.int]] = None,
            spot_maximum_price: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            stop_before_destroy: Optional[pulumi.Input[_builtins.bool]] = None,
            system_disk_dss_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_id: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_iops: Optional[pulumi.Input[_builtins.int]] = None,
            system_disk_kms_key_id: Optional[pulumi.Input[_builtins.str]] = None,
            system_disk_size: Optional[pulumi.Input[_builtins.int]] = None,
            system_disk_throughput: Optional[pulumi.Input[_builtins.int]] = None,
            system_disk_type: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            updated_at: Optional[pulumi.Input[_builtins.str]] = None,
            user_data: Optional[pulumi.Input[_builtins.str]] = None,
            user_id: Optional[pulumi.Input[_builtins.str]] = None,
            volume_attacheds: Optional[pulumi.Input[Sequence[pulumi.Input[Union['InstanceVolumeAttachedArgs', 'InstanceVolumeAttachedArgsDict']]]]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_ip_v4: The first detected Fixed IPv4 address or the Floating IP.
        :param pulumi.Input[_builtins.str] access_ip_v6: The first detected Fixed IPv6 address.
        :param pulumi.Input[_builtins.str] admin_pass: Specifies the administrative password to assign to the instance.
        :param pulumi.Input[_builtins.str] agency_name: Specifies the IAM agency name which is created on IAM to provide
               temporary credentials for ECS to access cloud services.
        :param pulumi.Input[_builtins.str] agent_list: Specifies the agent list in comma-separated string.
               Available agents are:
        :param pulumi.Input[_builtins.str] availability_zone: Specifies the availability zone in which to create the instance.
               Changing this creates a new instance.
        :param pulumi.Input[Union['InstanceBandwidthArgs', 'InstanceBandwidthArgsDict']] bandwidth: Specifies the bandwidth of an EIP that will be automatically assigned to the instance.
               The object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] created_at: The creation time, in UTC format.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceDataDiskArgs', 'InstanceDataDiskArgsDict']]]] data_disks: Specifies an array of one or more data disks to attach to the instance.
               The data_disks object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[_builtins.bool] delete_disks_on_termination: Specifies whether to delete the data disks when the instance is terminated.
               Defaults to *false*. This parameter is valid if `charging_mode` is set to *postPaid*, and all data disks will be deleted
               in *prePaid* charging mode.
        :param pulumi.Input[_builtins.bool] delete_eip_on_termination: Specifies whether the EIP is released when the instance is terminated.
               Defaults to *true*.
        :param pulumi.Input[_builtins.str] description: Specifies the description of the instance. The description consists of 0 to 85
               characters, and can't contain '<' or '>'.
        :param pulumi.Input[_builtins.str] eip_id: Specifies the ID of an *existing* EIP assigned to the instance.
               This parameter and `eip_type`, `bandwidth` are alternative. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] eip_type: Specifies the type of an EIP that will be automatically assigned to the instance.
               Available values are *5_bgp* (dynamic BGP) and *5_sbgp* (static BGP). Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] enterprise_project_id: Specifies a unique id in UUID format of enterprise project.
        :param pulumi.Input[_builtins.str] flavor_id: Specifies the flavor ID of the instance to be created.
        :param pulumi.Input[_builtins.str] flavor_name: The flavor name of the instance.
        :param pulumi.Input[_builtins.str] image_id: Required if `image_name` is empty. Specifies the image ID of the desired
               image for the instance. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] image_name: Required if `image_id` is empty. Specifies the name of the desired image
               for the instance. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] key_pair: Specifies the SSH keypair name used for logging in to the instance.
        :param pulumi.Input[_builtins.str] name: Specifies a unique name for the instance. The name consists of 1 to 64 characters,
               including letters, digits, underscores (_), hyphens (-), and periods (.).
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceNetworkArgs', 'InstanceNetworkArgsDict']]]] networks: Specifies an array of one or more networks to attach to the instance. The
               network object structure is documented below. Changing this creates a new instance.
        :param pulumi.Input[_builtins.str] power_action: Specifies the power action to be done for the instance.
               The valid values are *ON*, *OFF*, *REBOOT*, *FORCE-OFF* and *FORCE-REBOOT*.
               
               > **NOTE:** The `power_action` is a one-time action.
        :param pulumi.Input[_builtins.str] private_key: Specifies the the private key of the keypair in use. This parameter is mandatory
               when replacing or unbinding a keypair and the instance is in **Running** state.
        :param pulumi.Input[_builtins.str] public_ip: The EIP address that is associted to the instance.
        :param pulumi.Input[_builtins.str] region: Specifies the region in which to create the instance.
               If omitted, the provider-level region will be used. Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceSchedulerHintArgs', 'InstanceSchedulerHintArgsDict']]]] scheduler_hints: Specifies the scheduler with hints on how the instance should be launched. The
               available hints are described below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_group_ids: Specifies an array of one or more security group IDs to associate with the
               instance.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] security_groups: An array of one or more security groups to associate with the instance.
        :param pulumi.Input[_builtins.str] status: The status of the instance.
        :param pulumi.Input[_builtins.bool] stop_before_destroy: Specifies whether to try stop instance gracefully before destroying it, thus giving
               chance for guest OS daemons to stop correctly. If instance doesn't stop within timeout, it will be destroyed anyway.
        :param pulumi.Input[_builtins.str] system_disk_id: The system disk voume ID.
        :param pulumi.Input[_builtins.int] system_disk_size: Specifies the system disk size in GB, The value range is 1 to 1024.
               Shrinking the disk is not supported.
        :param pulumi.Input[_builtins.str] system_disk_type: Specifies the system disk type of the instance. Defaults to `GPSSD`.
               Changing this creates a new instance.
               
               Available options are:
               + `SAS`: high I/O disk type.
               + `SSD`: ultra-high I/O disk type.
               + `ESSD`: Extreme SSD type.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: Specifies the key/value pairs to associate with the instance.
        :param pulumi.Input[_builtins.str] updated_at: The last update time, in UTC format.
        :param pulumi.Input[_builtins.str] user_data: Specifies the user data to be injected during the instance creation. Text
               and text files can be injected. Changing this creates a new instance.
               
               > **NOTE:** If the `user_data` field is specified for a Linux ECS that is created using an image with Cloud-Init
               installed, the `admin_pass` field becomes invalid.
        :param pulumi.Input[_builtins.str] user_id: Specifies a user ID, required when using key_pair in prePaid charging mode.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[Union['InstanceVolumeAttachedArgs', 'InstanceVolumeAttachedArgsDict']]]] volume_attacheds: An array of one or more disks to attach to the instance.
               The volume attached object structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["access_ip_v4"] = access_ip_v4
        __props__.__dict__["access_ip_v6"] = access_ip_v6
        __props__.__dict__["admin_pass"] = admin_pass
        __props__.__dict__["agency_name"] = agency_name
        __props__.__dict__["agent_list"] = agent_list
        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["auto_terminate_time"] = auto_terminate_time
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["data_disks"] = data_disks
        __props__.__dict__["delete_disks_on_termination"] = delete_disks_on_termination
        __props__.__dict__["delete_eip_on_termination"] = delete_eip_on_termination
        __props__.__dict__["description"] = description
        __props__.__dict__["eip_id"] = eip_id
        __props__.__dict__["eip_type"] = eip_type
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["expired_time"] = expired_time
        __props__.__dict__["flavor_id"] = flavor_id
        __props__.__dict__["flavor_name"] = flavor_name
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["image_id"] = image_id
        __props__.__dict__["image_name"] = image_name
        __props__.__dict__["key_pair"] = key_pair
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["name"] = name
        __props__.__dict__["networks"] = networks
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["power_action"] = power_action
        __props__.__dict__["private_key"] = private_key
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["scheduler_hints"] = scheduler_hints
        __props__.__dict__["security_group_ids"] = security_group_ids
        __props__.__dict__["security_groups"] = security_groups
        __props__.__dict__["spot_duration"] = spot_duration
        __props__.__dict__["spot_duration_count"] = spot_duration_count
        __props__.__dict__["spot_maximum_price"] = spot_maximum_price
        __props__.__dict__["status"] = status
        __props__.__dict__["stop_before_destroy"] = stop_before_destroy
        __props__.__dict__["system_disk_dss_pool_id"] = system_disk_dss_pool_id
        __props__.__dict__["system_disk_id"] = system_disk_id
        __props__.__dict__["system_disk_iops"] = system_disk_iops
        __props__.__dict__["system_disk_kms_key_id"] = system_disk_kms_key_id
        __props__.__dict__["system_disk_size"] = system_disk_size
        __props__.__dict__["system_disk_throughput"] = system_disk_throughput
        __props__.__dict__["system_disk_type"] = system_disk_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["user_id"] = user_id
        __props__.__dict__["volume_attacheds"] = volume_attacheds
        return Instance(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessIpV4")
    def access_ip_v4(self) -> pulumi.Output[_builtins.str]:
        """
        The first detected Fixed IPv4 address or the Floating IP.
        """
        return pulumi.get(self, "access_ip_v4")

    @_builtins.property
    @pulumi.getter(name="accessIpV6")
    def access_ip_v6(self) -> pulumi.Output[_builtins.str]:
        """
        The first detected Fixed IPv6 address.
        """
        return pulumi.get(self, "access_ip_v6")

    @_builtins.property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the administrative password to assign to the instance.
        """
        return pulumi.get(self, "admin_pass")

    @_builtins.property
    @pulumi.getter(name="agencyName")
    def agency_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the IAM agency name which is created on IAM to provide
        temporary credentials for ECS to access cloud services.
        """
        return pulumi.get(self, "agency_name")

    @_builtins.property
    @pulumi.getter(name="agentList")
    def agent_list(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the agent list in comma-separated string.
        Available agents are:
        """
        return pulumi.get(self, "agent_list")

    @_builtins.property
    @pulumi.getter(name="autoPay")
    @_utilities.deprecated("""Deprecated""")
    def auto_pay(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "auto_pay")

    @_builtins.property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "auto_renew")

    @_builtins.property
    @pulumi.getter(name="autoTerminateTime")
    def auto_terminate_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "auto_terminate_time")

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the availability zone in which to create the instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[Optional['outputs.InstanceBandwidth']]:
        """
        Specifies the bandwidth of an EIP that will be automatically assigned to the instance.
        The object structure is documented below. Changing this creates a new instance.
        """
        return pulumi.get(self, "bandwidth")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[_builtins.str]:
        """
        The creation time, in UTC format.
        """
        return pulumi.get(self, "created_at")

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceDataDisk']]]:
        """
        Specifies an array of one or more data disks to attach to the instance.
        The data_disks object structure is documented below. Changing this creates a new instance.
        """
        return pulumi.get(self, "data_disks")

    @_builtins.property
    @pulumi.getter(name="deleteDisksOnTermination")
    def delete_disks_on_termination(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to delete the data disks when the instance is terminated.
        Defaults to *false*. This parameter is valid if `charging_mode` is set to *postPaid*, and all data disks will be deleted
        in *prePaid* charging mode.
        """
        return pulumi.get(self, "delete_disks_on_termination")

    @_builtins.property
    @pulumi.getter(name="deleteEipOnTermination")
    def delete_eip_on_termination(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether the EIP is released when the instance is terminated.
        Defaults to *true*.
        """
        return pulumi.get(self, "delete_eip_on_termination")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the description of the instance. The description consists of 0 to 85
        characters, and can't contain '<' or '>'.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the ID of an *existing* EIP assigned to the instance.
        This parameter and `eip_type`, `bandwidth` are alternative. Changing this creates a new instance.
        """
        return pulumi.get(self, "eip_id")

    @_builtins.property
    @pulumi.getter(name="eipType")
    def eip_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the type of an EIP that will be automatically assigned to the instance.
        Available values are *5_bgp* (dynamic BGP) and *5_sbgp* (static BGP). Changing this creates a new instance.
        """
        return pulumi.get(self, "eip_type")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a unique id in UUID format of enterprise project.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the flavor ID of the instance to be created.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> pulumi.Output[_builtins.str]:
        """
        The flavor name of the instance.
        """
        return pulumi.get(self, "flavor_name")

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "hostname")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> pulumi.Output[_builtins.str]:
        """
        Required if `image_name` is empty. Specifies the image ID of the desired
        image for the instance. Changing this creates a new instance.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> pulumi.Output[_builtins.str]:
        """
        Required if `image_id` is empty. Specifies the name of the desired image
        for the instance. Changing this creates a new instance.
        """
        return pulumi.get(self, "image_name")

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the SSH keypair name used for logging in to the instance.
        """
        return pulumi.get(self, "key_pair")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies a unique name for the instance. The name consists of 1 to 64 characters,
        including letters, digits, underscores (_), hyphens (-), and periods (.).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> pulumi.Output[Sequence['outputs.InstanceNetwork']]:
        """
        Specifies an array of one or more networks to attach to the instance. The
        network object structure is documented below. Changing this creates a new instance.
        """
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "period")

    @_builtins.property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "period_unit")

    @_builtins.property
    @pulumi.getter(name="powerAction")
    def power_action(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the power action to be done for the instance.
        The valid values are *ON*, *OFF*, *REBOOT*, *FORCE-OFF* and *FORCE-REBOOT*.

        > **NOTE:** The `power_action` is a one-time action.
        """
        return pulumi.get(self, "power_action")

    @_builtins.property
    @pulumi.getter(name="privateKey")
    def private_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the the private key of the keypair in use. This parameter is mandatory
        when replacing or unbinding a keypair and the instance is in **Running** state.
        """
        return pulumi.get(self, "private_key")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[_builtins.str]:
        """
        The EIP address that is associted to the instance.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter
    def region(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the region in which to create the instance.
        If omitted, the provider-level region will be used. Changing this creates a new instance.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter(name="schedulerHints")
    def scheduler_hints(self) -> pulumi.Output[Sequence['outputs.InstanceSchedulerHint']]:
        """
        Specifies the scheduler with hints on how the instance should be launched. The
        available hints are described below.
        """
        return pulumi.get(self, "scheduler_hints")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        Specifies an array of one or more security group IDs to associate with the
        instance.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter(name="securityGroups")
    def security_groups(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        An array of one or more security groups to associate with the instance.
        """
        return pulumi.get(self, "security_groups")

    @_builtins.property
    @pulumi.getter(name="spotDuration")
    def spot_duration(self) -> pulumi.Output[Optional[_builtins.int]]:
        return pulumi.get(self, "spot_duration")

    @_builtins.property
    @pulumi.getter(name="spotDurationCount")
    def spot_duration_count(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "spot_duration_count")

    @_builtins.property
    @pulumi.getter(name="spotMaximumPrice")
    def spot_maximum_price(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "spot_maximum_price")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The status of the instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="stopBeforeDestroy")
    def stop_before_destroy(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether to try stop instance gracefully before destroying it, thus giving
        chance for guest OS daemons to stop correctly. If instance doesn't stop within timeout, it will be destroyed anyway.
        """
        return pulumi.get(self, "stop_before_destroy")

    @_builtins.property
    @pulumi.getter(name="systemDiskDssPoolId")
    def system_disk_dss_pool_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "system_disk_dss_pool_id")

    @_builtins.property
    @pulumi.getter(name="systemDiskId")
    def system_disk_id(self) -> pulumi.Output[_builtins.str]:
        """
        The system disk voume ID.
        """
        return pulumi.get(self, "system_disk_id")

    @_builtins.property
    @pulumi.getter(name="systemDiskIops")
    def system_disk_iops(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "system_disk_iops")

    @_builtins.property
    @pulumi.getter(name="systemDiskKmsKeyId")
    def system_disk_kms_key_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "system_disk_kms_key_id")

    @_builtins.property
    @pulumi.getter(name="systemDiskSize")
    def system_disk_size(self) -> pulumi.Output[_builtins.int]:
        """
        Specifies the system disk size in GB, The value range is 1 to 1024.
        Shrinking the disk is not supported.
        """
        return pulumi.get(self, "system_disk_size")

    @_builtins.property
    @pulumi.getter(name="systemDiskThroughput")
    def system_disk_throughput(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "system_disk_throughput")

    @_builtins.property
    @pulumi.getter(name="systemDiskType")
    def system_disk_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the system disk type of the instance. Defaults to `GPSSD`.
        Changing this creates a new instance.

        Available options are:
        + `SAS`: high I/O disk type.
        + `SSD`: ultra-high I/O disk type.
        + `ESSD`: Extreme SSD type.
        """
        return pulumi.get(self, "system_disk_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies the key/value pairs to associate with the instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[_builtins.str]:
        """
        The last update time, in UTC format.
        """
        return pulumi.get(self, "updated_at")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the user data to be injected during the instance creation. Text
        and text files can be injected. Changing this creates a new instance.

        > **NOTE:** If the `user_data` field is specified for a Linux ECS that is created using an image with Cloud-Init
        installed, the `admin_pass` field becomes invalid.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies a user ID, required when using key_pair in prePaid charging mode.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "user_id")

    @_builtins.property
    @pulumi.getter(name="volumeAttacheds")
    def volume_attacheds(self) -> pulumi.Output[Sequence['outputs.InstanceVolumeAttached']]:
        """
        An array of one or more disks to attach to the instance.
        The volume attached object structure is documented below.
        """
        return pulumi.get(self, "volume_attacheds")

