# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'InstanceBandwidth',
    'InstanceDataDisk',
    'InstanceNetwork',
    'InstanceSchedulerHint',
    'InstanceVolumeAttached',
    'GetFlavorsFlavorResult',
    'GetInstanceNetworkResult',
    'GetInstanceSchedulerHintResult',
    'GetInstanceVolumeAttachedResult',
    'GetInstancesInstanceResult',
    'GetInstancesInstanceNetworkResult',
    'GetInstancesInstanceSchedulerHintResult',
    'GetInstancesInstanceVolumeAttachedResult',
    'GetServergroupsServergroupResult',
]

@pulumi.output_type
class InstanceBandwidth(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shareType":
            suggest = "share_type"
        elif key == "chargeMode":
            suggest = "charge_mode"
        elif key == "extendParam":
            suggest = "extend_param"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceBandwidth. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceBandwidth.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceBandwidth.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 share_type: _builtins.str,
                 charge_mode: Optional[_builtins.str] = None,
                 extend_param: Optional[Mapping[str, _builtins.str]] = None,
                 id: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None):
        """
        :param _builtins.str share_type: Specifies the bandwidth sharing type. Changing this creates a new instance.
               Possible values are as follows:
               + **PER**: Dedicated bandwidth
               + **WHOLE**: Shared bandwidth
        :param _builtins.str charge_mode: Specifies the bandwidth billing mode. The value can be *traffic* or *bandwidth*.
               Changing this creates a new instance.
        :param _builtins.str id: Specifies the **shared** bandwidth id. This parameter is mandatory when
               `share_type` is set to **WHOLE**. Changing this creates a new instance.
        :param _builtins.int size: Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
               This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        """
        pulumi.set(__self__, "share_type", share_type)
        if charge_mode is not None:
            pulumi.set(__self__, "charge_mode", charge_mode)
        if extend_param is not None:
            pulumi.set(__self__, "extend_param", extend_param)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @_builtins.property
    @pulumi.getter(name="shareType")
    def share_type(self) -> _builtins.str:
        """
        Specifies the bandwidth sharing type. Changing this creates a new instance.
        Possible values are as follows:
        + **PER**: Dedicated bandwidth
        + **WHOLE**: Shared bandwidth
        """
        return pulumi.get(self, "share_type")

    @_builtins.property
    @pulumi.getter(name="chargeMode")
    def charge_mode(self) -> Optional[_builtins.str]:
        """
        Specifies the bandwidth billing mode. The value can be *traffic* or *bandwidth*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "charge_mode")

    @_builtins.property
    @pulumi.getter(name="extendParam")
    def extend_param(self) -> Optional[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "extend_param")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Specifies the **shared** bandwidth id. This parameter is mandatory when
        `share_type` is set to **WHOLE**. Changing this creates a new instance.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        Specifies the bandwidth size. The value ranges from 1 to 300 Mbit/s.
        This parameter is mandatory when `share_type` is set to **PER**. Changing this creates a new instance.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class InstanceDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dssPoolId":
            suggest = "dss_pool_id"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "snapshotId":
            suggest = "snapshot_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 size: _builtins.int,
                 type: _builtins.str,
                 dss_pool_id: Optional[_builtins.str] = None,
                 iops: Optional[_builtins.int] = None,
                 kms_key_id: Optional[_builtins.str] = None,
                 snapshot_id: Optional[_builtins.str] = None,
                 throughput: Optional[_builtins.int] = None):
        """
        :param _builtins.int size: Specifies the data disk size, in GB. The value ranges form 10 to 32768.
               Changing this creates a new instance.
        :param _builtins.str type: Specifies the ECS data disk type, which must be one of available disk types,
               contains of *SSD*, *GPSSD* and *SAS*. Changing this creates a new instance.
        :param _builtins.str kms_key_id: Specifies the ID of a KMS key. This is used to encrypt the disk.
               Changing this creates a new instance.
        :param _builtins.str snapshot_id: Specifies the snapshot id. Changing this creates a new instance.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        if dss_pool_id is not None:
            pulumi.set(__self__, "dss_pool_id", dss_pool_id)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if snapshot_id is not None:
            pulumi.set(__self__, "snapshot_id", snapshot_id)
        if throughput is not None:
            pulumi.set(__self__, "throughput", throughput)

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        Specifies the data disk size, in GB. The value ranges form 10 to 32768.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the ECS data disk type, which must be one of available disk types,
        contains of *SSD*, *GPSSD* and *SAS*. Changing this creates a new instance.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="dssPoolId")
    def dss_pool_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "dss_pool_id")

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "iops")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        """
        Specifies the ID of a KMS key. This is used to encrypt the disk.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="snapshotId")
    def snapshot_id(self) -> Optional[_builtins.str]:
        """
        Specifies the snapshot id. Changing this creates a new instance.
        """
        return pulumi.get(self, "snapshot_id")

    @_builtins.property
    @pulumi.getter
    def throughput(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "throughput")


@pulumi.output_type
class InstanceNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessNetwork":
            suggest = "access_network"
        elif key == "fixedIpV4":
            suggest = "fixed_ip_v4"
        elif key == "fixedIpV6":
            suggest = "fixed_ip_v6"
        elif key == "ipv6Enable":
            suggest = "ipv6_enable"
        elif key == "sourceDestCheck":
            suggest = "source_dest_check"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 access_network: Optional[_builtins.bool] = None,
                 fixed_ip_v4: Optional[_builtins.str] = None,
                 fixed_ip_v6: Optional[_builtins.str] = None,
                 ipv6_enable: Optional[_builtins.bool] = None,
                 mac: Optional[_builtins.str] = None,
                 port: Optional[_builtins.str] = None,
                 source_dest_check: Optional[_builtins.bool] = None,
                 uuid: Optional[_builtins.str] = None):
        """
        :param _builtins.bool access_network: Specifies if this network should be used for provisioning access.
               Accepts true or false. Defaults to false.
        :param _builtins.str fixed_ip_v4: Specifies a fixed IPv4 address to be used on this network.
               Changing this creates a new instance.
        :param _builtins.str fixed_ip_v6: The Fixed IPv6 address of the instance on that network.
        :param _builtins.bool ipv6_enable: Specifies whether the IPv6 function is enabled for the nic.
               Defaults to false. Changing this creates a new instance.
        :param _builtins.str mac: The MAC address of the NIC on that network.
        :param _builtins.str port: The port ID corresponding to the IP address on that network.
        :param _builtins.bool source_dest_check: Specifies whether the ECS processes only traffic that is destined specifically
               for it. This function is enabled by default but should be disabled if the ECS functions as a SNAT server or has a
               virtual IP address bound to it.
        :param _builtins.str uuid: Specifies the network UUID to attach to the instance.
               Changing this creates a new instance.
        """
        if access_network is not None:
            pulumi.set(__self__, "access_network", access_network)
        if fixed_ip_v4 is not None:
            pulumi.set(__self__, "fixed_ip_v4", fixed_ip_v4)
        if fixed_ip_v6 is not None:
            pulumi.set(__self__, "fixed_ip_v6", fixed_ip_v6)
        if ipv6_enable is not None:
            pulumi.set(__self__, "ipv6_enable", ipv6_enable)
        if mac is not None:
            pulumi.set(__self__, "mac", mac)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if source_dest_check is not None:
            pulumi.set(__self__, "source_dest_check", source_dest_check)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="accessNetwork")
    def access_network(self) -> Optional[_builtins.bool]:
        """
        Specifies if this network should be used for provisioning access.
        Accepts true or false. Defaults to false.
        """
        return pulumi.get(self, "access_network")

    @_builtins.property
    @pulumi.getter(name="fixedIpV4")
    def fixed_ip_v4(self) -> Optional[_builtins.str]:
        """
        Specifies a fixed IPv4 address to be used on this network.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "fixed_ip_v4")

    @_builtins.property
    @pulumi.getter(name="fixedIpV6")
    def fixed_ip_v6(self) -> Optional[_builtins.str]:
        """
        The Fixed IPv6 address of the instance on that network.
        """
        return pulumi.get(self, "fixed_ip_v6")

    @_builtins.property
    @pulumi.getter(name="ipv6Enable")
    def ipv6_enable(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the IPv6 function is enabled for the nic.
        Defaults to false. Changing this creates a new instance.
        """
        return pulumi.get(self, "ipv6_enable")

    @_builtins.property
    @pulumi.getter
    def mac(self) -> Optional[_builtins.str]:
        """
        The MAC address of the NIC on that network.
        """
        return pulumi.get(self, "mac")

    @_builtins.property
    @pulumi.getter
    def port(self) -> Optional[_builtins.str]:
        """
        The port ID corresponding to the IP address on that network.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="sourceDestCheck")
    def source_dest_check(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the ECS processes only traffic that is destined specifically
        for it. This function is enabled by default but should be disabled if the ECS functions as a SNAT server or has a
        virtual IP address bound to it.
        """
        return pulumi.get(self, "source_dest_check")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> Optional[_builtins.str]:
        """
        Specifies the network UUID to attach to the instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class InstanceSchedulerHint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dehId":
            suggest = "deh_id"
        elif key == "faultDomain":
            suggest = "fault_domain"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceSchedulerHint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceSchedulerHint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceSchedulerHint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deh_id: Optional[_builtins.str] = None,
                 fault_domain: Optional[_builtins.str] = None,
                 group: Optional[_builtins.str] = None,
                 tenancy: Optional[_builtins.str] = None):
        """
        :param _builtins.str deh_id: Specifies the ID of DeH.
               This parameter takes effect only when the value of tenancy is dedicated. Changing this creates a new instance.
        :param _builtins.str fault_domain: schema: Internal
        :param _builtins.str group: Specifies a UUID of a Server Group.
               The instance will be placed into that group. Changing this creates a new instance.
        :param _builtins.str tenancy: Specifies the tenancy specifies whether the ECS is to be created on a
               Dedicated Host
               (DeH) or in a shared pool. Changing this creates a new instance.
        """
        if deh_id is not None:
            pulumi.set(__self__, "deh_id", deh_id)
        if fault_domain is not None:
            pulumi.set(__self__, "fault_domain", fault_domain)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if tenancy is not None:
            pulumi.set(__self__, "tenancy", tenancy)

    @_builtins.property
    @pulumi.getter(name="dehId")
    def deh_id(self) -> Optional[_builtins.str]:
        """
        Specifies the ID of DeH.
        This parameter takes effect only when the value of tenancy is dedicated. Changing this creates a new instance.
        """
        return pulumi.get(self, "deh_id")

    @_builtins.property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[_builtins.str]:
        """
        schema: Internal
        """
        return pulumi.get(self, "fault_domain")

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[_builtins.str]:
        """
        Specifies a UUID of a Server Group.
        The instance will be placed into that group. Changing this creates a new instance.
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter
    def tenancy(self) -> Optional[_builtins.str]:
        """
        Specifies the tenancy specifies whether the ECS is to be created on a
        Dedicated Host
        (DeH) or in a shared pool. Changing this creates a new instance.
        """
        return pulumi.get(self, "tenancy")


@pulumi.output_type
class InstanceVolumeAttached(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootIndex":
            suggest = "boot_index"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "pciAddress":
            suggest = "pci_address"
        elif key == "volumeId":
            suggest = "volume_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceVolumeAttached. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceVolumeAttached.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceVolumeAttached.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_index: Optional[_builtins.int] = None,
                 kms_key_id: Optional[_builtins.str] = None,
                 pci_address: Optional[_builtins.str] = None,
                 size: Optional[_builtins.int] = None,
                 type: Optional[_builtins.str] = None,
                 volume_id: Optional[_builtins.str] = None):
        """
        :param _builtins.int boot_index: The volume boot index on that attachment.
        :param _builtins.str kms_key_id: Specifies the ID of a KMS key. This is used to encrypt the disk.
               Changing this creates a new instance.
        :param _builtins.str pci_address: The volume pci address on that attachment.
        :param _builtins.int size: The volume size on that attachment.
        :param _builtins.str type: The volume type on that attachment.
        :param _builtins.str volume_id: The volume ID on that attachment.
        """
        if boot_index is not None:
            pulumi.set(__self__, "boot_index", boot_index)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if pci_address is not None:
            pulumi.set(__self__, "pci_address", pci_address)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if volume_id is not None:
            pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter(name="bootIndex")
    def boot_index(self) -> Optional[_builtins.int]:
        """
        The volume boot index on that attachment.
        """
        return pulumi.get(self, "boot_index")

    @_builtins.property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[_builtins.str]:
        """
        Specifies the ID of a KMS key. This is used to encrypt the disk.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "kms_key_id")

    @_builtins.property
    @pulumi.getter(name="pciAddress")
    def pci_address(self) -> Optional[_builtins.str]:
        """
        The volume pci address on that attachment.
        """
        return pulumi.get(self, "pci_address")

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[_builtins.int]:
        """
        The volume size on that attachment.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The volume type on that attachment.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> Optional[_builtins.str]:
        """
        The volume ID on that attachment.
        """
        return pulumi.get(self, "volume_id")


@pulumi.output_type
class GetFlavorsFlavorResult(dict):
    def __init__(__self__, *,
                 cpu_core_count: _builtins.int,
                 generation: _builtins.str,
                 id: _builtins.str,
                 memory_size: _builtins.int,
                 performance_type: _builtins.str,
                 storage_type: _builtins.str):
        """
        :param _builtins.int cpu_core_count: Specifies the number of vCPUs in the ECS flavor.
        :param _builtins.str generation: Specifies the generation of an ECS type.
        :param _builtins.str id: Specifies a data source ID in UUID format.
        :param _builtins.int memory_size: Specifies the memory size(GB) in the ECS flavor.
        :param _builtins.str performance_type: Specifies the ECS flavor type.
        """
        pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "memory_size", memory_size)
        pulumi.set(__self__, "performance_type", performance_type)
        pulumi.set(__self__, "storage_type", storage_type)

    @_builtins.property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> _builtins.int:
        """
        Specifies the number of vCPUs in the ECS flavor.
        """
        return pulumi.get(self, "cpu_core_count")

    @_builtins.property
    @pulumi.getter
    def generation(self) -> _builtins.str:
        """
        Specifies the generation of an ECS type.
        """
        return pulumi.get(self, "generation")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Specifies a data source ID in UUID format.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="memorySize")
    def memory_size(self) -> _builtins.int:
        """
        Specifies the memory size(GB) in the ECS flavor.
        """
        return pulumi.get(self, "memory_size")

    @_builtins.property
    @pulumi.getter(name="performanceType")
    def performance_type(self) -> _builtins.str:
        """
        Specifies the ECS flavor type.
        """
        return pulumi.get(self, "performance_type")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> _builtins.str:
        return pulumi.get(self, "storage_type")


@pulumi.output_type
class GetInstanceNetworkResult(dict):
    def __init__(__self__, *,
                 fixed_ip_v4: _builtins.str,
                 fixed_ip_v6: _builtins.str,
                 mac: _builtins.str,
                 port: _builtins.str,
                 uuid: _builtins.str):
        """
        :param _builtins.str fixed_ip_v4: Specifies the IPv4 addresses of the ECS.
        :param _builtins.str fixed_ip_v6: The Fixed IPv6 address of the instance on that network.
        :param _builtins.str mac: The MAC address of the NIC on that network.
        :param _builtins.str port: The port ID corresponding to the IP address on that network.
        :param _builtins.str uuid: The network UUID to attach to the server.
        """
        pulumi.set(__self__, "fixed_ip_v4", fixed_ip_v4)
        pulumi.set(__self__, "fixed_ip_v6", fixed_ip_v6)
        pulumi.set(__self__, "mac", mac)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="fixedIpV4")
    def fixed_ip_v4(self) -> _builtins.str:
        """
        Specifies the IPv4 addresses of the ECS.
        """
        return pulumi.get(self, "fixed_ip_v4")

    @_builtins.property
    @pulumi.getter(name="fixedIpV6")
    def fixed_ip_v6(self) -> _builtins.str:
        """
        The Fixed IPv6 address of the instance on that network.
        """
        return pulumi.get(self, "fixed_ip_v6")

    @_builtins.property
    @pulumi.getter
    def mac(self) -> _builtins.str:
        """
        The MAC address of the NIC on that network.
        """
        return pulumi.get(self, "mac")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        The port ID corresponding to the IP address on that network.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        The network UUID to attach to the server.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class GetInstanceSchedulerHintResult(dict):
    def __init__(__self__, *,
                 group: _builtins.str):
        """
        :param _builtins.str group: The UUID of a Server Group where the instance will be placed into.
        """
        pulumi.set(__self__, "group", group)

    @_builtins.property
    @pulumi.getter
    def group(self) -> _builtins.str:
        """
        The UUID of a Server Group where the instance will be placed into.
        """
        return pulumi.get(self, "group")


@pulumi.output_type
class GetInstanceVolumeAttachedResult(dict):
    def __init__(__self__, *,
                 boot_index: _builtins.int,
                 is_sys_volume: _builtins.bool,
                 pci_address: _builtins.str,
                 size: _builtins.int,
                 type: _builtins.str,
                 volume_id: _builtins.str):
        """
        :param _builtins.int boot_index: The volume boot index on that attachment.
        :param _builtins.bool is_sys_volume: Whether the volume is the system disk.
        :param _builtins.str pci_address: The volume pci address on that attachment.
        :param _builtins.int size: The volume size on that attachment.
        :param _builtins.str type: The volume type on that attachment.
        :param _builtins.str volume_id: The volume id on that attachment.
        """
        pulumi.set(__self__, "boot_index", boot_index)
        pulumi.set(__self__, "is_sys_volume", is_sys_volume)
        pulumi.set(__self__, "pci_address", pci_address)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter(name="bootIndex")
    def boot_index(self) -> _builtins.int:
        """
        The volume boot index on that attachment.
        """
        return pulumi.get(self, "boot_index")

    @_builtins.property
    @pulumi.getter(name="isSysVolume")
    def is_sys_volume(self) -> _builtins.bool:
        """
        Whether the volume is the system disk.
        """
        return pulumi.get(self, "is_sys_volume")

    @_builtins.property
    @pulumi.getter(name="pciAddress")
    def pci_address(self) -> _builtins.str:
        """
        The volume pci address on that attachment.
        """
        return pulumi.get(self, "pci_address")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The volume size on that attachment.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The volume type on that attachment.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> _builtins.str:
        """
        The volume id on that attachment.
        """
        return pulumi.get(self, "volume_id")


@pulumi.output_type
class GetInstancesInstanceResult(dict):
    def __init__(__self__, *,
                 availability_zone: _builtins.str,
                 charging_mode: _builtins.str,
                 enterprise_project_id: _builtins.str,
                 expired_time: _builtins.str,
                 flavor_id: _builtins.str,
                 flavor_name: _builtins.str,
                 id: _builtins.str,
                 image_id: _builtins.str,
                 image_name: _builtins.str,
                 key_pair: _builtins.str,
                 name: _builtins.str,
                 networks: Sequence['outputs.GetInstancesInstanceNetworkResult'],
                 public_ip: _builtins.str,
                 scheduler_hints: Sequence['outputs.GetInstancesInstanceSchedulerHintResult'],
                 security_group_ids: Sequence[_builtins.str],
                 status: _builtins.str,
                 system_disk_id: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 user_data: _builtins.str,
                 volume_attacheds: Sequence['outputs.GetInstancesInstanceVolumeAttachedResult']):
        """
        :param _builtins.str availability_zone: Specifies the availability zone where the instance is located.
               Please following [reference](https://support.hc.sbercloud.ru/endpoint/index.html) for this argument.
        :param _builtins.str enterprise_project_id: Specifies the enterprise project ID.
        :param _builtins.str flavor_id: Specifies the flavor ID.
        :param _builtins.str flavor_name: Specifies the flavor name of the instance.
        :param _builtins.str id: The instance ID in UUID format.
        :param _builtins.str image_id: Specifies the image ID of the instance.
        :param _builtins.str image_name: The image name of the instance.
        :param _builtins.str key_pair: Specifies the key pair that is used to authenticate the instance.
        :param _builtins.str name: Specifies the instance name, which can be queried with a regular expression.
               The instance name supports fuzzy matching query too.
        :param _builtins.str public_ip: The EIP address that is associted to the instance.
        :param Sequence['GetInstancesInstanceSchedulerHintArgs'] scheduler_hints: The scheduler with hints on how the instance should be launched.
               The object structure is documented below.
        :param Sequence[_builtins.str] security_group_ids: An array of one or more security group IDs to associate with the instance.
        :param _builtins.str status: Specifies the status of the instance. The valid values are as follows:
               + **ACTIVE**: The instance is running properly.
               + **SHUTOFF**: The instance has been properly stopped.
               + **ERROR**: An error has occurred on the instance.
        :param _builtins.str system_disk_id: The system disk voume ID.
        :param Mapping[str, _builtins.str] tags: The key/value pairs to associate with the instance.
        :param _builtins.str user_data: The user data (information after encoding) configured during instance creation.
        :param Sequence['GetInstancesInstanceVolumeAttachedArgs'] volume_attacheds: An array of one or more disks to attach to the instance. The object structure is documented below.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "charging_mode", charging_mode)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "flavor_id", flavor_id)
        pulumi.set(__self__, "flavor_name", flavor_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image_id", image_id)
        pulumi.set(__self__, "image_name", image_name)
        pulumi.set(__self__, "key_pair", key_pair)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "networks", networks)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "scheduler_hints", scheduler_hints)
        pulumi.set(__self__, "security_group_ids", security_group_ids)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "system_disk_id", system_disk_id)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "user_data", user_data)
        pulumi.set(__self__, "volume_attacheds", volume_attacheds)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        Specifies the availability zone where the instance is located.
        Please following [reference](https://support.hc.sbercloud.ru/endpoint/index.html) for this argument.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> _builtins.str:
        return pulumi.get(self, "charging_mode")

    @_builtins.property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> _builtins.str:
        """
        Specifies the enterprise project ID.
        """
        return pulumi.get(self, "enterprise_project_id")

    @_builtins.property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> _builtins.str:
        return pulumi.get(self, "expired_time")

    @_builtins.property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> _builtins.str:
        """
        Specifies the flavor ID.
        """
        return pulumi.get(self, "flavor_id")

    @_builtins.property
    @pulumi.getter(name="flavorName")
    def flavor_name(self) -> _builtins.str:
        """
        Specifies the flavor name of the instance.
        """
        return pulumi.get(self, "flavor_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The instance ID in UUID format.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="imageId")
    def image_id(self) -> _builtins.str:
        """
        Specifies the image ID of the instance.
        """
        return pulumi.get(self, "image_id")

    @_builtins.property
    @pulumi.getter(name="imageName")
    def image_name(self) -> _builtins.str:
        """
        The image name of the instance.
        """
        return pulumi.get(self, "image_name")

    @_builtins.property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> _builtins.str:
        """
        Specifies the key pair that is used to authenticate the instance.
        """
        return pulumi.get(self, "key_pair")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the instance name, which can be queried with a regular expression.
        The instance name supports fuzzy matching query too.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def networks(self) -> Sequence['outputs.GetInstancesInstanceNetworkResult']:
        return pulumi.get(self, "networks")

    @_builtins.property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> _builtins.str:
        """
        The EIP address that is associted to the instance.
        """
        return pulumi.get(self, "public_ip")

    @_builtins.property
    @pulumi.getter(name="schedulerHints")
    def scheduler_hints(self) -> Sequence['outputs.GetInstancesInstanceSchedulerHintResult']:
        """
        The scheduler with hints on how the instance should be launched.
        The object structure is documented below.
        """
        return pulumi.get(self, "scheduler_hints")

    @_builtins.property
    @pulumi.getter(name="securityGroupIds")
    def security_group_ids(self) -> Sequence[_builtins.str]:
        """
        An array of one or more security group IDs to associate with the instance.
        """
        return pulumi.get(self, "security_group_ids")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        Specifies the status of the instance. The valid values are as follows:
        + **ACTIVE**: The instance is running properly.
        + **SHUTOFF**: The instance has been properly stopped.
        + **ERROR**: An error has occurred on the instance.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="systemDiskId")
    def system_disk_id(self) -> _builtins.str:
        """
        The system disk voume ID.
        """
        return pulumi.get(self, "system_disk_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        The key/value pairs to associate with the instance.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userData")
    def user_data(self) -> _builtins.str:
        """
        The user data (information after encoding) configured during instance creation.
        """
        return pulumi.get(self, "user_data")

    @_builtins.property
    @pulumi.getter(name="volumeAttacheds")
    def volume_attacheds(self) -> Sequence['outputs.GetInstancesInstanceVolumeAttachedResult']:
        """
        An array of one or more disks to attach to the instance. The object structure is documented below.
        """
        return pulumi.get(self, "volume_attacheds")


@pulumi.output_type
class GetInstancesInstanceNetworkResult(dict):
    def __init__(__self__, *,
                 fixed_ip_v4: _builtins.str,
                 fixed_ip_v6: _builtins.str,
                 mac: _builtins.str,
                 port: _builtins.str,
                 uuid: _builtins.str):
        """
        :param _builtins.str fixed_ip_v4: The fixed IPv4 address of the instance on this network.
        :param _builtins.str fixed_ip_v6: The Fixed IPv6 address of the instance on that network.
        :param _builtins.str mac: The MAC address of the NIC on that network.
        :param _builtins.str port: The port ID corresponding to the IP address on that network.
        :param _builtins.str uuid: The network ID to attach to the server.
        """
        pulumi.set(__self__, "fixed_ip_v4", fixed_ip_v4)
        pulumi.set(__self__, "fixed_ip_v6", fixed_ip_v6)
        pulumi.set(__self__, "mac", mac)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "uuid", uuid)

    @_builtins.property
    @pulumi.getter(name="fixedIpV4")
    def fixed_ip_v4(self) -> _builtins.str:
        """
        The fixed IPv4 address of the instance on this network.
        """
        return pulumi.get(self, "fixed_ip_v4")

    @_builtins.property
    @pulumi.getter(name="fixedIpV6")
    def fixed_ip_v6(self) -> _builtins.str:
        """
        The Fixed IPv6 address of the instance on that network.
        """
        return pulumi.get(self, "fixed_ip_v6")

    @_builtins.property
    @pulumi.getter
    def mac(self) -> _builtins.str:
        """
        The MAC address of the NIC on that network.
        """
        return pulumi.get(self, "mac")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.str:
        """
        The port ID corresponding to the IP address on that network.
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter
    def uuid(self) -> _builtins.str:
        """
        The network ID to attach to the server.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class GetInstancesInstanceSchedulerHintResult(dict):
    def __init__(__self__, *,
                 group: _builtins.str):
        """
        :param _builtins.str group: The UUID of a server group where the instance will be placed into.
        """
        pulumi.set(__self__, "group", group)

    @_builtins.property
    @pulumi.getter
    def group(self) -> _builtins.str:
        """
        The UUID of a server group where the instance will be placed into.
        """
        return pulumi.get(self, "group")


@pulumi.output_type
class GetInstancesInstanceVolumeAttachedResult(dict):
    def __init__(__self__, *,
                 boot_index: _builtins.int,
                 is_sys_volume: _builtins.bool,
                 pci_address: _builtins.str,
                 size: _builtins.int,
                 type: _builtins.str,
                 volume_id: _builtins.str):
        """
        :param _builtins.bool is_sys_volume: Whether the volume is the system disk.
        :param _builtins.str pci_address: The volume pci address on that attachment.
        :param _builtins.int size: The volume size on that attachment.
        :param _builtins.str type: The volume type on that attachment.
        :param _builtins.str volume_id: The volume id on that attachment.
        """
        pulumi.set(__self__, "boot_index", boot_index)
        pulumi.set(__self__, "is_sys_volume", is_sys_volume)
        pulumi.set(__self__, "pci_address", pci_address)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "volume_id", volume_id)

    @_builtins.property
    @pulumi.getter(name="bootIndex")
    def boot_index(self) -> _builtins.int:
        return pulumi.get(self, "boot_index")

    @_builtins.property
    @pulumi.getter(name="isSysVolume")
    def is_sys_volume(self) -> _builtins.bool:
        """
        Whether the volume is the system disk.
        """
        return pulumi.get(self, "is_sys_volume")

    @_builtins.property
    @pulumi.getter(name="pciAddress")
    def pci_address(self) -> _builtins.str:
        """
        The volume pci address on that attachment.
        """
        return pulumi.get(self, "pci_address")

    @_builtins.property
    @pulumi.getter
    def size(self) -> _builtins.int:
        """
        The volume size on that attachment.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The volume type on that attachment.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="volumeId")
    def volume_id(self) -> _builtins.str:
        """
        The volume id on that attachment.
        """
        return pulumi.get(self, "volume_id")


@pulumi.output_type
class GetServergroupsServergroupResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 members: Sequence[_builtins.str],
                 name: _builtins.str,
                 policies: Sequence[_builtins.str]):
        """
        :param _builtins.str id: The server group ID in UUID format.
        :param Sequence[_builtins.str] members: An array of one or more instance ID attached to the server group.
        :param _builtins.str name: Specifies the server group name.
        :param Sequence[_builtins.str] policies: The set of policies for the server group.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "policies", policies)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The server group ID in UUID format.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def members(self) -> Sequence[_builtins.str]:
        """
        An array of one or more instance ID attached to the server group.
        """
        return pulumi.get(self, "members")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the server group name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def policies(self) -> Sequence[_builtins.str]:
        """
        The set of policies for the server group.
        """
        return pulumi.get(self, "policies")


